 
              #include "SpiceUsr.h"
              #include "SpiceZmc.h"
 
              /*
              Routines for rise-set state function computation.
              */
 
              /*
              Constants
              */
              #define NAMLEN          33
              #define CORLEN          11
 
              /*
              File scope variables:
              */
              static SpiceChar         svcorr [CORLEN];
              static SpiceChar         svsfpt [NAMLEN];
              static SpiceChar         svtarg [NAMLEN];
 
              static SpiceDouble       svlim;
 
 
 
              /*
              Save function arguments to be used while searching.
              */
              void setris ( ConstSpiceChar   * srfpt,
                            ConstSpiceChar   * abcorr,
                            ConstSpiceChar   * target,
                            SpiceDouble        revlim  )
           {
              strncpy ( svcorr, abcorr, CORLEN );
              strncpy ( svsfpt, srfpt,  NAMLEN );
              strncpy ( svtarg, target, NAMLEN );
 
              /*
              Insert null terminators for safety.
              */
              svcorr[CORLEN-1] = NULLCHAR;
              svsfpt[NAMLEN-1] = NULLCHAR;
              svtarg[NAMLEN-1] = NULLCHAR;
 
              svlim = revlim;
           }
 
 
 
 
 
              /*
              Logical function to indicate "state" of target:  the state
              is SPICETRUE when the target has a positive elevation
              in the topocentric frame at the saved surface point;
              otherwise the state is SPICEFALSE.
              */
              SpiceBoolean stris ( SpiceDouble  et )
           {
              /*
              Prototypes
              */
              void srfazl ( ConstSpiceChar       * srfpt,
                            SpiceDouble            et,
                            ConstSpiceChar       * abcorr,
                            ConstSpiceChar       * targ,
                            SpiceDouble          * az,
                            SpiceDouble          * el,
                            SpiceDouble          * r      );
 
              /*
              Local variables
              */
              SpiceDouble             az;
              SpiceDouble             el;
              SpiceDouble             r;
 
 
              /*
              Find the azimuth and elevation of the saved target at et;
              indicate whether the elevation is above the elevation limit.
              */
              srfazl ( svsfpt, et, svcorr, svtarg, &az, &el, &r );
 
              return (  (SpiceBoolean)( el > svlim )  );
           }
