
      LOGICAL FUNCTION MODOCP ( TARGET, OCCBDY, ET, 
     .                          ABCORR, OBSRVR     )
      IMPLICIT NONE
C
C     Umbrella routine for point target occultation function.
C
      CHARACTER*(*)         TARGET
      CHARACTER*(*)         OCCBDY
      DOUBLE PRECISION      ET
      CHARACTER*(*)         ABCORR
      CHARACTER*(*)         OBSRVR

C
C     Non-SPICELIB functions
C
      LOGICAL               OCCPT

C
C     Entry points
C
      LOGICAL               SETOCP
      LOGICAL               STOCP

C
C     Local parameters
C
      INTEGER               NAMLEN
      PARAMETER           ( NAMLEN = 32 )

      INTEGER               CORLEN
      PARAMETER           ( CORLEN = 10 )

C
C     Local variables
C
      CHARACTER*(CORLEN)    SVCORR
      CHARACTER*(NAMLEN)    SVOBSV
      CHARACTER*(NAMLEN)    SVOCBD
      CHARACTER*(NAMLEN)    SVTARG
      
C
C     Saved variables
C
      SAVE                  SVCORR
      SAVE                  SVOBSV
      SAVE                  SVOCBD
      SAVE                  SVTARG


C
C     A return value must be supplied because this is 
C     an entry point of a function.  The value has no
C     significance.
C
      MODOCP = .FALSE.
 
      CALL SIGERR ( 'SPICE(BOGUSENTRY)' )
      RETURN




      ENTRY SETOCP ( TARGET, OCCBDY, ABCORR, OBSRVR )
C
C     Save function arguments to be used while searching.
C
      SVCORR = ABCORR
      SVOCBD = OCCBDY
      SVTARG = TARGET
      SVOBSV = OBSRVR

C
C     A return value must be supplied because this is 
C     an entry point of a function.  The value has no
C     significance.
C
      SETOCP = .FALSE.

      RETURN




      ENTRY STOCP ( ET )
C
C     Logical function to indicate "state" of target:  the state
C     is .TRUE. when the target is occulted as seen from the
C     observer's location; otherwise the state is .FALSE.
C           
      STOCP = OCCPT ( SVTARG, SVOCBD, ET, SVCORR, SVOBSV )

      RETURN

      END

