              #include "SpiceUsr.h"
              #include "SpiceZmc.h"
 
              /*
              Routines for point target occultation state function computation
              */
 
              /*
              Constants
              */
              #define NAMLEN          33
              #define CORLEN          11
 
              /*
              File scope variables:
              */
              static SpiceChar         svcorr [CORLEN];
              static SpiceChar         svobsv [NAMLEN];
              static SpiceChar         svocbd [NAMLEN];
              static SpiceChar         svtarg [NAMLEN];
 
 
 
 
 
              /*
              Save function arguments to be used while searching.
              */
              void setocp ( ConstSpiceChar   * target,
                            ConstSpiceChar   * occbdy,
                            ConstSpiceChar   * abcorr,
                            ConstSpiceChar   * obsrvr )
           {
              strncpy ( svcorr, abcorr, CORLEN );
              strncpy ( svocbd, occbdy, NAMLEN );
              strncpy ( svtarg, target, NAMLEN );
              strncpy ( svobsv, obsrvr, NAMLEN );
 
              svcorr[CORLEN-1] = NULLCHAR;
              svocbd[NAMLEN-1] = NULLCHAR;
              svtarg[NAMLEN-1] = NULLCHAR;
              svobsv[NAMLEN-1] = NULLCHAR;
           }
 
 
 
 
 
              /*
              Logical function to indicate "state" of target:  the state
              is SPICETRUE when the target has a positive elevation
              in the topocentric frame at the saved surface point;
              otherwise the state is SPICEFALSE.
              */
              SpiceBoolean stocp ( SpiceDouble  et )
           {
 
              /*
              Prototypes
              */
              SpiceBoolean occpt ( ConstSpiceChar    * target,
                                   ConstSpiceChar    * occbdy,
                                   SpiceDouble         et,
                                   ConstSpiceChar    * abcorr,
                                   ConstSpiceChar    * obsrvr  );
 
 
              return (  occpt( svtarg, svocbd, et, svcorr, svobsv )  );
           }
 

