

      SUBROUTINE MAKWIN ( ETBEG, ETEND, FSTATE, EVTSET, EVTWIN )
      IMPLICIT NONE
C
C     Utility program for creating a window representing
C     time intervals when a specified binary state function
C     returns .TRUE.
C
C
C     Subroutine arguments:
C
C        ETBEG         is the start time of a time interval on
C                      which the binary state function
C                      FSTATE is defined.
C
C        ETEND         is the end time corresponding to ETBEG.
C
C        FSTATE        is a binary, state function of ET that
C                      returns a value of type LOGICAL.
C
C        EVTSET        is a SPICELIB set containing epochs of
C                      state transitions.  The members of EVTSET
C                      must lie in the interval
C
C                         [ETBEG, ETEND]
C
C        EVTWIN        is a SPICELIB window constructed by this
C                      routine.  EVTWIN contains subintervals
C                      of the interval
C
C                         [ETBEG, ETEND]
C
C                      on which FSTATE(ET) is .TRUE.  EVTWIN
C                      must be initialized by the caller of this
C                      routine.
C
C

      INTEGER               LBCELL
      PARAMETER           ( LBCELL = -5 )

      DOUBLE PRECISION      ETBEG
      DOUBLE PRECISION      ETEND
      LOGICAL               FSTATE
      DOUBLE PRECISION      EVTSET ( LBCELL : * )
      DOUBLE PRECISION      EVTWIN ( LBCELL : * )

C
C
C     SPICELIB functions
C
      INTEGER               CARDD

C
C     External functions
C
      EXTERNAL              FSTATE

C
C     Local variables
C
      INTEGER               CARD
      INTEGER               I


      CALL CHKIN ( 'MAKWIN' )

C
C     Empty the output window.
C
      CALL SCARDD ( 0, EVTWIN )

C
C     Get a local copy of the cardinality of the event set.
C
      CARD = CARDD(EVTSET)

C
C     If FSTATE is .TRUE. at ETBEG, then the first state transition
C     is the right endpoint of the first window interval, and every
C     subsequent even-numbered transition marks the start of a
C     window interval. Otherwise, every odd-numbered transition
C     marks the start of a window interval.
C
      IF ( FSTATE(ETBEG) ) THEN
C
C        The first window interval starts at ETBEG.
C
         IF ( CARD .EQ. 0 ) THEN
C
C           The function is .TRUE. the whole time.  The
C           window consists of the single interval
C
C              [ETBEG, ETEND]
C
            CALL WNINSD ( ETBEG, ETEND, EVTWIN )

         ELSE
C
C           Insert the first interval into the window.
C
            CALL WNINSD ( ETBEG, EVTSET(1), EVTWIN )

C
C           Insert into our window any remaining intervals bounded
C           by transitions.
C
            I = 2

            DO WHILE ( I+1  .LE. CARD )

               CALL WNINSD ( EVTSET(I), EVTSET(I+1), EVTWIN )

               I = I + 2

            END DO

            IF ( I .EQ. CARD ) THEN
C
C              The last interval begins at EVTSET(CARD)
C              and ends at ETEND.
C
               CALL WNINSD ( EVTSET(CARD), ETEND, EVTWIN )

            END IF

         END IF
C
C        We've handled the case where FSTATE is .TRUE. at ETBEG.
C
      ELSE
C
C        The first interval starts at EVTSET(1).
C
         I = 1

         DO WHILE ( I+1  .LE. CARD )

            CALL WNINSD ( EVTSET(I), EVTSET(I+1), EVTWIN )

            I = I + 2

         END DO

         IF ( I .EQ. CARD ) THEN
C
C           The last interval begins at EVTSET(CARD)
C           and ends at ETEND.
C
            CALL WNINSD ( EVTSET(CARD), ETEND, EVTWIN )

         END IF
C
C        We've handled the case where FSTATE is .FALSE. at ETBEG.
C
      END IF

C
C     EVTWIN is ready for use.
C
      CALL CHKOUT ( 'MAKWIN' )
      END


