 
              #include "SpiceUsr.h"
 
 
              void makwin ( SpiceDouble          etbeg,
                            SpiceDouble          etend,
                            SpiceBoolean      (* fstate)( SpiceDouble ),
                            SpiceCell          * evtset,
                            SpiceCell          * evtwin                  )
 
              /*
              Utility program for creating a window representing
              time intervals when a specified binary state function
              returns SPICETRUE.
 
                 Subroutine arguments:
 
                    etbeg         is the start time of a time interval on
                                  which the binary state function
                                  fstate is defined.
 
                    etend         is the end time corresponding to etbeg.
 
                    fstate        is a binary state function of ET that
                                  returns a value of type SpiceBoolean.
 
                    evtset        is a CSPICE set containing epochs of state
                                  transitions.  The members of evtset must
                                  lie in the interval
 
                                     [etbeg, etend]
 
                    evtwin        is a CSPICE window constructed by this
                                  routine.  evtwin contains subintervals
                                  of the interval
 
                                     [etbeg, etend]
 
                                  on which fstate(et) is SPICETRUE.  evtwin
                                  must be intialized by the caller of this
                                  routine.
              */
 
           {
              /*
              Local variables
              */
              SpiceInt                card;
              SpiceInt                i;
 
 
              chkin_c ( "makwin" );
 
              /*
              Empty the output window.
              */
              scard_c ( 0, evtwin );
 
              /*
              Get a local copy of the cardinality of the event set.
              */
              card = card_c ( evtset );
 
              /*
              If fstate is SPICETRUE at etbeg, then the first state
              transition is at the right endpoint of the first window
              interval, and every subsequent even-numbered transition
              marks the start of a window interval. Otherwise,
              every odd-numbered transition marks the start of a window
              interval.
              */
 
              if ( (*fstate)(etbeg) )
              {
                 /*
                 The first window interval starts at etbeg.
                 */
                 if ( card == 0 )
                 {
 
                    /*
                    The function is SPICETRUE the whole time.  The
                    window consists of the single interval
 
                       [etbeg, etend]
                    */
                    wninsd_c ( etbeg, etend, evtwin );
                 }
                 else
                 {
                    /*
                    Insert the first interval into the window.
                    */
                    wninsd_c( etbeg, SPICE_CELL_ELEM_D(evtset,0), evtwin );
 
                    /*
                    Insert into our window any remaining intervals bounded
                    by transitions.
                    */
                    i = 1;
 
                    while ( i+1 < card )
                    {
                       wninsd_c ( SPICE_CELL_ELEM_D( evtset, i   ),
                                  SPICE_CELL_ELEM_D( evtset, i+1 ),
                                  evtwin                            );
 
                       i += 2;
                    }
 
                    if ( i == card-1 )
                    {
                       /*
                       The last interval begins at the [card-1] element
                       of evtset and ends at etend.
                       */
                       wninsd_c ( SPICE_CELL_ELEM_D(evtset, card-1),
                                  etend,
                                  evtwin                          );
                    }
                 }
 
 
                 /*
                 We've handled the case where fstate is SPICETRUE at etbeg.
                 */
              }
 
              else
              {
                 /*
                 The first interval starts at element [0] of evtset.
                 */
                 i = 0;
 
                 while ( i+1 < card )
                 {
                    wninsd_c ( SPICE_CELL_ELEM_D( evtset, i   ),
                               SPICE_CELL_ELEM_D( evtset, i+1 ),
                               evtwin                            );
 
                    i += 2;
                 }
 
                 if ( i == card-1 )
                 {
                    /*
                    The last interval begins at the [card-1] element of evtset
                    and ends at etend.
                    */
                    wninsd_c ( SPICE_CELL_ELEM_D(evtset, card-1),
                               etend,
                               evtwin                           );
                 }
 
                 /*
                 We've handled the case where fstate is SPICEFALSE at etbeg.
                 */
              }
 
              /*
              evtwin is ready for use.
              */
              chkout_c ( "makwin" );
           }
 
