 
              #include "SpiceUsr.h"
 
              void fndevt ( SpiceDouble       etbeg,
                            SpiceDouble       etend,
                            SpiceDouble       step,
                            SpiceBoolean   (* statef) ( SpiceDouble ),
                            SpiceCell       * xset                     )
 
              /*
              Find locations of state changes for a boolean function.
 
                31-OCT-2002 (NJB)
              */
 
           {
              /*
              Local constants
              */
              #define CNVLIM           (1.0e-6)
              #define MAXITR           100
 
              /*
              Local variables
              */
              SpiceBoolean            lstate;
              SpiceBoolean            mstate;
              SpiceBoolean            ustate;
 
              SpiceDouble             delta;
              SpiceDouble             lower;
              SpiceDouble             lpt;
              SpiceDouble             midpt;
              SpiceDouble             upper;
              SpiceDouble             upt;
 
              SpiceInt                nitr;
 
 
 
              if ( return_c() )
              {
                 return;
              }
              chkin_c ( "fndevt" );
 
              /*
              Set the cardinality of the input cell to zero.
              */
              scard_c ( 0, xset );
 
              /*
              If the input interval is empty, we're done.
              */
              if ( etend <= etbeg )
              {
                 chkout_c ( "fndevt" );
                 return;
              }
 
              /*
              The step size must be at least as large as the convergence
              limit.
              */
              if ( step <= CNVLIM )
              {
                 setmsg_c ( "STEP must be > the convergence limit #; "
                            "actual value was #."                      );
                 errdp_c  ( "#", CNVLIM                                );
                 errdp_c  ( "#", step                                  );
                 sigerr_c ( "SPICE(INVALIDVALUE)"                      );
                 chkout_c ( "fndevt"                                   );
                 return;
              }
 
              /*
              Obtain the initial state; save this as the "lower" state.
              */
              lstate = (*statef) ( etbeg );
 
              /*
              Step along the input interval, looking for state changes.
              */
              lpt  =  etbeg;
              upt  =  brcktd_c ( etbeg + step,  etbeg,  etend );
 
              while ( lpt < etend )
              {
                 /*
                 Find the state at the epoch upt.  First, check that upt
                 is actually greater than lpt.
                 */
                 if ( upt <= lpt )
                 {
                    /*
                    We're not getting anywhere; the step is too small.
                    */
                    setmsg_c ( "Upper bracketing epoch UPT = #; "
                               "lower epoch LPT = #. This condition "
                               "arises when the step size is too small." );
                    errdp_c  ( "#", lpt                                  );
                    errdp_c  ( "#", upt                                  );
                    sigerr_c ( "SPICE(STEPTOOSMALL)"                     );
                    chkout_c ( "fndevt"                                  );
                    return;
                 }
 
                 /*
                 Find the state at the upper bound of our step interval.
                 */
                 ustate  =  (*statef)( upt );
 
                 if ( ustate != lstate )
                 {
                    /*
                    There's a state change between the right endpoint upt and
                    the left endpoint lpt.  Do a binary search to locate the
                    epoch at which the state changes.  Note: uniqueness of
                    the root is not guaranteed; it's up to the caller to
                    choose step small enough to ensure that only one root can
                    occur in a time interval of length step.
                    */
                    lower  =  brcktd_c ( lpt, etbeg, etend );
                    upper  =  brcktd_c ( upt, etbeg, etend );
                    midpt  =  ( lower + upper ) / 2;
                    mstate =  (*statef) ( midpt );
 
                    nitr   =  0;
                    delta  =  upper - lower;
 
                    while (  ( delta > CNVLIM ) && ( nitr <= MAXITR )  )
                    {
                       /*
                       Adjust our search interval so the length is reduced
                       by a factor of two and so that the location of the
                       state change remains between lower and upper.
                       */
                       if ( mstate == ustate )
                       {
                          /*
                          The state is the same at the midpoint and the
                          upper bound, so a state change must occur
                          between the lower bound and the midpoint.
                          Make the midpoint the new upper bound.
                          */
                          upper = midpt;
                       }
                       else
                       {
                          /*
                          There is a state change between the midpoint
                          and the upper bound; the state at the midpoint
                          matches the state at the lower bound.  Make
                          the midpoint the new lower bound.
                          */
                          lower = midpt;
                       }
 
                       midpt  = ( lower + upper ) / 2;
                       mstate = (*statef) ( midpt );
 
                       delta  =   upper - lower;
                       nitr++;
 
                       /*
                       At this point, the state at lower matches the state
                       at lpt (lstate), and the state at upper matches
                       the state at upt (ustate).
                       */
                    }
 
                    /*
                    If we dropped out of the loop because we hit the
                    iteration limit, we have a problem.
                    */
                    if ( delta > CNVLIM )
                    {
                       setmsg_c ( "Binary search failed to converge. "
                                  "ETBEG = #, LOWER = #, MIDPT = #, "
                                  "UPPER = #, ETEND = #"               );
                       errdp_c  ( "#", etbeg                           );
                       errdp_c  ( "#", lower                           );
                       errdp_c  ( "#", midpt                           );
                       errdp_c  ( "#", upper                           );
                       errdp_c  ( "#", etend                           );
                       sigerr_c ( "SPICE(NOCONVERGENCE)"               );
                       chkout_c ( "fndevt"                             );
                       return;
                    }
 
                    /*
                    The epoch of the state transition has been determined
                    to within CNVLIM.  We'll use upper as the epoch of
                    the transition.  This ensures that the state at the
                    transition epoch is ustate.
                    */
                    appndd_c ( upper, xset );
 
                    /*
                    upper becomes the left endpoint of the next interval.
                    The state at the right interval endpoint upt becomes
                    the state at the left endpoint of the next interval.
                    Calculate upt at the next step.  We look up
                    ustate at the top of the loop.
                    */
                    lpt     =  upper;
                    lstate  =  ustate;
                    upt     =  brcktd_c ( lpt + step,  etbeg,  etend );
                 }
 
                 else
                 {
                    /*
                    No state change was found on this step.  upt becomes
                    the lower bound of the next search interval.  lstate
                    remains unchanged.  We look up ustate at the top of
                    the loop.
                    */
                    lpt     =  upt;
                    upt     =  brcktd_c ( lpt + step,  etbeg,  etend );
                 }
              }
 
              /*
              The left endpoint equals the right endpoint of our search
              interval, so there are no more state changes to be found.
              */
              chkout_c ( "fndevt" );
           }
 
 
