
      LOGICAL FUNCTION MODRIS ( SRFPT, ET, ABCORR, TARGET, LIMIT )
      IMPLICIT NONE
C
C     Umbrella routine for rise-set function.
C
      CHARACTER*(*)         SRFPT
      DOUBLE PRECISION      ET
      CHARACTER*(*)         ABCORR
      CHARACTER*(*)         TARGET
      DOUBLE PRECISION      LIMIT

C
C     Entry points
C
      LOGICAL               SETRIS
      LOGICAL               STRIS

C
C     Local parameters
C
      INTEGER               NAMLEN
      PARAMETER           ( NAMLEN = 32 )

      INTEGER               CORLEN
      PARAMETER           ( CORLEN = 10 )

C
C     Local variables
C
      CHARACTER*(CORLEN)    SVCORR
      CHARACTER*(NAMLEN)    SVSFPT
      CHARACTER*(NAMLEN)    SVTARG
      
      DOUBLE PRECISION      AZ
      DOUBLE PRECISION      EL
      DOUBLE PRECISION      R
      DOUBLE PRECISION      SVLIM

C
C     Saved variables
C
      SAVE                  SVCORR
      SAVE                  SVLIM
      SAVE                  SVSFPT
      SAVE                  SVTARG


C
C     A return value must be supplied because this is 
C     an entry point of a function.  The value has no
C     significance.
C
      MODRIS = .FALSE.

      CALL SIGERR ( 'SPICE(BOGUSENTRY)' )
      RETURN




      ENTRY SETRIS ( SRFPT, ABCORR, TARGET, LIMIT )
C
C     Save function arguments to be used while searching.
C
      SVCORR = ABCORR
      SVSFPT = SRFPT
      SVTARG = TARGET
      SVLIM  = LIMIT
C
C     A return value must be supplied because this is 
C     an entry point of a function.  The value has no
C     significance.
C
      SETRIS = .FALSE.

      RETURN




      ENTRY STRIS ( ET )
C
C     Logical function to indicate "state" of target:  the state
C     is .TRUE. when the target is above the elevation limit
C     in the topocentric frame at the saved surface point; 
C     otherwise the state is .FALSE.
C
      CALL SRFAZL ( SVSFPT, ET, SVCORR, SVTARG, AZ, EL, R )
      
      STRIS = EL .GT. SVLIM

      RETURN

      END

