


      SUBROUTINE FNDEVT ( ETBEG, ETEND, STEP, STATEF, XSET )
      IMPLICIT NONE
C
C     Find locations of state changes for a boolean function.
C
C       12-SEP-2002 (NJB)
C       06-JUN-2002 (NJB)
C
      INTEGER               LBCELL
      PARAMETER           ( LBCELL = -5 )

      DOUBLE PRECISION      ETBEG
      DOUBLE PRECISION      ETEND
      DOUBLE PRECISION      STEP
      LOGICAL               STATEF
      DOUBLE PRECISION      XSET  ( LBCELL : * )

      EXTERNAL              STATEF


C
C     SPICELIB functions
C
      DOUBLE PRECISION      BRCKTD

C
C     Local parameters
C
      DOUBLE PRECISION      CNVLIM
      PARAMETER           ( CNVLIM = 1.D-6 )

      INTEGER               MAXITR
      PARAMETER           ( MAXITR = 100 )

C
C     Local variables
C
      DOUBLE PRECISION      DELTA
      DOUBLE PRECISION      LOWER
      DOUBLE PRECISION      LPT
      DOUBLE PRECISION      MIDPT
      DOUBLE PRECISION      UPPER
      DOUBLE PRECISION      UPT

      INTEGER               NITR

      LOGICAL               LSTATE
      LOGICAL               MSTATE
      LOGICAL               USTATE


      CALL CHKIN ( 'FNDEVT' )
C
C     Set the cardinality of the input cell to zero.
C
      CALL SCARDD  ( 0, XSET )

C
C     If the input interval is empty, we're done.
C
      IF ( ETEND .LE. ETBEG ) THEN
         CALL CHKOUT ( 'FNDEVT' )
         RETURN
      END IF

C
C     The step size must be at least as large as the convergence
C     limit.
C
      IF ( STEP .LE. CNVLIM ) THEN

         CALL SETMSG ( 'STEP must be > the convergence limit #; '//
     .                 'actual value was #.'                      )
         CALL ERRDP  ( '#',  CNVLIM                               )
         CALL ERRDP  ( '#',  STEP                                 )
         CALL SIGERR ( 'SPICE(INVALIDVALUE)'                      )
         CALL CHKOUT ( 'FNDEVT'                                   )
         RETURN

      END IF

C
C     Obtain the initial state; save this as the "lower" state.
C
      LSTATE = STATEF ( ETBEG )

C
C     Step along the input interval, looking for state changes.
C
      LPT    =  ETBEG
      UPT    =  BRCKTD ( ETBEG + STEP,  ETBEG,  ETEND )

      DO WHILE ( LPT .LT. ETEND )
C
C        Find the state at the epoch UPT.  First, check that UPT
C        is actually greater than LPT.
C
         IF ( UPT .LE. LPT ) THEN
C
C           We're not getting anywhere; the step is too small.
C
            CALL SETMSG ( 'Upper bracketing epoch UPT = #; '     //
     .                    'lower epoch LPT = #. This condition ' //
     .                    'arises when the step size is too '    //
     .                    'small.'                               )
            CALL ERRDP  ( '#', UPT                               )
            CALL ERRDP  ( '#', LPT                               )
            CALL SIGERR ( 'SPICE(STEPTOOSMALL)'                  )
            CALL CHKOUT ( 'FNDEVT'                               )
            RETURN

         END IF

C
C        Find the state at the upper bound of our step interval.
C
         USTATE = STATEF ( UPT )


         IF ( USTATE .NEQV. LSTATE ) THEN
C
C           There's a state change between the right endpoint UPT
C           and the left endpoint LPT.  Do a binary search to
C           locate the epoch at which the state changes.  Note:
C           uniqueness of the root is not guaranteed; it's up
C           to the caller to choose STEP small enough to ensure
C           that only one root can occur in a time interval of
C           length STEP.
C
            LOWER  =  BRCKTD ( LPT, ETBEG, ETEND )
            UPPER  =  BRCKTD ( UPT, ETBEG, ETEND )
            MIDPT  =  ( LOWER + UPPER ) / 2
            MSTATE =  STATEF ( MIDPT )

            NITR   =  0
            DELTA  =  UPPER - LOWER

            DO WHILE (         ( DELTA .GT. CNVLIM )
     .                  .AND.  ( NITR  .LE. MAXITR )  )
C
C              Adjust our search interval so the length is reduced
C              by a factor of two and so that the location of the
C              state change remains between LOWER and UPPER.
C
               IF ( MSTATE .EQV. USTATE ) THEN
C
C                 The state is the same at the midpoint and the
C                 upper bound, so a state change must occur
C                 between the lower bound and the midpoint.
C                 Make the midpoint the new upper bound.
C
                  UPPER = MIDPT

               ELSE
C
C                 There is a state change between the midpoint
C                 and the upper bound; the state at the midpoint
C                 matches the state at the lower bound.  Make
C                 the midpoint the new lower bound.
C
                  LOWER  =  MIDPT

               END IF

               MIDPT  = ( LOWER + UPPER ) / 2
               MSTATE =   STATEF ( MIDPT )

               DELTA  =   UPPER - LOWER
               NITR   =   NITR  + 1

C
C              At this point, the state at LOWER matches the state
C              at LPT (LSTATE), and the state at UPPER matches the
C              state at UPT (USTATE).
C
            END DO

C
C           If we dropped out of the loop because we hit the
C           iteration limit, we have a problem.
C
            IF ( DELTA .GT. CNVLIM ) THEN

               CALL SETMSG ( 'Binary search failed to converge. '//
     .                       'ETBEG = #, LOWER = #, MIDPT = #, ' //
     .                       'UPPER = #, ETEND = #'               )
               CALL ERRDP  ( '#',  ETBEG                          )
               CALL ERRDP  ( '#',  LOWER                          )
               CALL ERRDP  ( '#',  MIDPT                          )
               CALL ERRDP  ( '#',  UPPER                          )
               CALL ERRDP  ( '#',  ETEND                          )
               CALL SIGERR ( 'SPICE(NOCONVERGENCE)'               )
               CALL CHKOUT ( 'FNDEVT'                             )
               RETURN

            END IF

C
C           The epoch of the state transition has been determined
C           to within CNVLIM.  We'll use UPPER as the epoch of
C           the transition.  This ensures that the state at the
C           transition epoch is USTATE.
C
            CALL APPNDD ( UPPER, XSET )

C
C           UPPER becomes the left endpoint of the next interval.
C           The state at the right interval endpoint UPT becomes
C           the state at the left endpoint of the next interval.
C           Calculate UPT at the next step.  We look up
C           USTATE at the top of the loop.
C
            LPT     =  UPPER
            LSTATE  =  USTATE
            UPT     =  BRCKTD ( LPT + STEP,  ETBEG,  ETEND )

         ELSE
C
C           No state change was found on this step.  UPT becomes
C           the lower bound of the next search interval.  LSTATE
C           remains unchanged.  We look up USTATE at the top of
C           the loop.
C
            LPT     =  UPT
            UPT     =  BRCKTD ( LPT + STEP,  ETBEG,  ETEND )

         END IF


      END DO
C
C     The left endpoint equals the right endpoint of our search
C     interval, so there are no more state changes to be found.
C

      CALL CHKOUT ( 'FNDEVT' )
      RETURN
      END

