SKD Git Hooks (post-checkout and post-merge)
===========================================

skd_post_merge is a set of Git Hooks with the responsibility of creating or 
updating the local Meta-Kernels of a given SPICE Kernel Dataset (SKD) everytime
that the local repository of the SKD is updated. This update usually is raisen
by a "git pull", "git merge" or a "git checkout".
 

Function and Purpose
--------------------

The ESA SPICE Service (ESS) of the Cross Mission Support Office is responsible 
for supporting the ESOC auxiliary data transformation into SPICE kernels and 
the distribution of these files to the instrument teams using the public network. 
NASA’s Planetary Data System discipline node NAIF (Navigational Ancillary 
Information Facility) is responsible for designing a transformation software 
tool to generate spacecraft orbit and attitude SPICE kernels. The ESS, helped 
by the individual instrument and FDy teams, the SGSs, and, in some missions, 
supported by NAIF, design and support all the necessary instrument, spacecraft 
and timing kernels.

skd_post_merge is developed and maintained by the [ESA SPICE Service (ESS)](https://spice.esac.esa.int).


Environmental Considerations
----------------------------

skd_post_merge is based on a few bash scripts, so the installation environment
shall support them.


Installation
------------

Then to install skd_post_merge Git Hooks run the following inside
the root folder of the SKD folder structure where you want to install skd_post_merge.

For OS X or Linux:
cd [SKD_PATH] 
chmod +x misc/git_hooks/skd_post_merge/install_hook_linux_or_mac.sh
misc/git_hooks/skd_post_merge/install_hook_linux_or_mac.sh

For Windows
cd [SKD_PATH]\misc\git_hooks\skd_post_merge
install_hook_windows.bat


Usage
-----

If the installation was successful the skd_post_merge Git Hooks will be 
executed when a Git action is run.

In case that you don't want to install the Git Hooks, but you prefer to create or
update the local Meta-Kernels at your own. You could run the following script 
from the root folder of the SKD folder structure everytime that you need to 
create or update the local Meta-Kernels:

For Linux and Mac from
cd [SKD_PATH]
misc/git_hooks/skd_post_merge/update_local_mks.sh

For Windows
cd [SKD_PATH]/misc/git_hooks/skd_post_merge
update_local_mks.bat


Known Working Environments:
---------------------------

skd_post_merge is compatible with modern 64 bits versions of Linux, Mac and Windows.
If you run into issues with your system please submit an issue with details. 

- OS: OS X, Linux, Windows
- CPU: 64bit