KPL/MK

Meta-kernel for Solar Orbiter Dataset v111 -- As Flown 20250508_001
============================================================================

   This meta-kernel lists the Solar_Orbiter As Flown SPICE kernels
   that provide information for the As Flown scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the Solar_Orbiter As Flown scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v4.4.4.


Usage of the Meta-kernel
---------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE Web server:

      https://spiftp.esac.esa.int/data/SPICE/SOLAR-ORBITER/kernels/

   or from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/SOLAR-ORBITER/kernels/


Implementation Notes
---------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the Solar_Orbiter SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on May 8, 2025 by Alfredo Escalante Lopez ESA/ESAC.
   The original name of this file was solo_ANC_soc-flown-mk_V111_20250508_001.tm.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/ck/solo_ANC_soc-sc-iboom-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-sc-oboom-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-sc-fof-ck_20180930-21000101_V03.bc'
                           '$KERNELS/ck/solo_ANC_soc-eui-fsi-ck_20180930-21000101_V04.bc'
                           '$KERNELS/ck/solo_ANC_soc-eui-hri-euv-ck_20180930-21000101_V04.bc'
                           '$KERNELS/ck/solo_ANC_soc-eui-hri-lya-ck_20180930-21000101_V04.bc'
                           '$KERNELS/ck/solo_ANC_soc-metis-euv-ck_20180930-21000101_V03.bc'
                           '$KERNELS/ck/solo_ANC_soc-metis-vis-ck_20180930-21000101_V03.bc'
                           '$KERNELS/ck/solo_ANC_soc-metis-m0-tel-ck_20180930-21000101_V03.bc'
                           '$KERNELS/ck/solo_ANC_soc-phi-fdt-ck_20180930-21000101_V03.bc'
                           '$KERNELS/ck/solo_ANC_soc-phi-hrt-ck_20180930-21000101_V03.bc'
                           '$KERNELS/ck/solo_ANC_soc-solohi-ck_20180930-21000101_V04.bc'
                           '$KERNELS/ck/solo_ANC_soc-spice-sw-ck_20180930-21000101_V04.bc'
                           '$KERNELS/ck/solo_ANC_soc-spice-lw-ck_20180930-21000101_V04.bc'
                           '$KERNELS/ck/solo_ANC_soc-stix-ck_20180930-21000101_V03.bc'
                           '$KERNELS/ck/solo_ANC_soc-interp-att_20200706T094948-20200707T182918_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-interp-att_20200821T110355-20200824T065725_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-interp-att_20200909T073003-20200910T071856_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-interp-att_20210118T040830-20210119T100208_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-interp-att_20210708T225823-20210713T203939_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-interp-att_20220104T150017-20220105T231523_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-interp-att_20220326T211253-20220329T155936_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200210T000000-20210101T111121_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210101T074827-20220101T175423_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220101T122853-20230101T222429_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20230101T074917-20240101T201325_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20231231T112655-20240103T003108_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240102T165038-20240103T233826_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240103T202814-20240104T220826_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240104T132144-20240105T133726_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240105T091444-20240106T002302_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240105T211050-20240106T220823_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240106T134120-20240107T212608_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240108T112132-20240110T014633_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240109T190115-20240110T200515_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240110T111909-20240111T220809_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240111T152221-20240112T220809_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240112T132221-20240113T220809_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240113T111521-20240115T013927_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240114T165203-20240115T220804_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240114T165203-20240116T150304_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240116T121140-20240117T013610_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240116T183010-20240117T220758_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240117T132222-20240118T132046_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240118T083246-20240118T184452_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240118T155016-20240119T205928_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240119T121355-20240120T182658_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240120T114125-20240120T233540_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240120T194755-20240121T170016_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240121T164958-20240122T182653_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240121T170022-20240122T012705_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240122T174035-20240123T084147_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240123T041105-20240124T104135_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240124T040941-20240124T155647_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240124T131141-20240125T012105_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240124T213511-20240126T110717_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240126T110047-20240127T011647_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240126T110723-20240126T164229_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240126T223153-20240127T170341_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240127T111853-20240128T011435_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240127T222926-20240128T111318_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240128T084454-20240128T191126_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240128T190154-20240129T155642_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240128T191130-20240128T234142_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240129T124900-20240130T011006_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240129T212726-20240130T085636_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240130T035830-20240130T201418_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240130T162942-20240131T185618_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240131T184706-20240201T184057_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240131T185624-20240131T211236_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240201T105606-20240202T182636_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240202T144448-20240203T010030_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240202T184306-20240203T182631_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240203T122242-20240203T235631_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240203T211213-20240204T124419_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240204T055949-20240204T212637_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240204T184155-20240205T114413_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240205T060049-20240205T183349_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240205T114919-20240206T085627_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240206T035449-20240206T234349_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240206T191919-20240207T234343_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240207T160919-20240208T204249_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240208T135825-20240209T204249_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240209T135825-20240210T122808_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240210T044502-20240210T204250_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240210T135826-20240211T182628_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240211T114228-20240212T204244_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240212T115832-20240213T185608_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240213T184658-20240214T212950_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240213T185614-20240214T003026_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240214T133138-20240215T212559_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240215T125138-20240216T112729_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240216T081008-20240216T191615_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240216T123139-20240217T211751_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240217T143339-20240218T192759_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240218T105409-20240219T111203_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240218T105409-20240220T210433_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240220T134709-20240221T205630_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240221T121045-20240222T112621_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240222T024109-20240222T190716_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240222T122027-20240223T204930_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240223T130158-20240224T204422_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240224T120210-20240225T203852_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240225T120310-20240226T113358_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240225T120310-20240227T202722_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240227T124216-20240228T114546_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240228T113634-20240229T201447_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240228T114552-20240228T202104_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240229T130141-20240301T230101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240301T161759-20240302T200111_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240302T111559-20240303T195405_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240303T110831-20240304T194641_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240304T110247-20240305T105759_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240305T041353-20240305T193905_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240305T145729-20240306T105254_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240306T080853-20240306T193112_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240306T145654-20240307T104754_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240307T062724-20240307T192306_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240307T123854-20240308T191448_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240308T103036-20240309T222506_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240309T151212-20240310T155606_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240310T082506-20240311T184606_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240311T100224-20240312T183913_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240312T115518-20240313T183001_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240313T105355-20240314T182037_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240314T113703-20240315T181107_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240315T140219-20240316T220243_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240316T172837-20240317T175201_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240317T095725-20240318T215325_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240318T151037-20240319T173308_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240319T104744-20240320T121902_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240320T100402-20240321T171502_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240321T084002-20240322T170626_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240322T091956-20240323T213305_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240323T145120-20240324T155450_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240324T071335-20240325T054038_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240324T225920-20240326T163645_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240326T095627-20240327T151657_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240326T210915-20240415T164408_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240327T120427-20240328T155403_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240328T071415-20240329T162121_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240329T121903-20240330T155333_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240330T071445-20240331T083815_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240331T020557-20240401T045522_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240331T221736-20240402T083216_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240401T235510-20240403T082952_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240402T235316-20240404T125210_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240404T071628-20240405T125152_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240405T071628-20240406T161552_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240406T074104-20240407T082317_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240407T014907-20240408T045837_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240407T222207-20240409T162341_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240409T095053-20240410T155023_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240410T072247-20240411T163011_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240411T094323-20240412T081929_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240411T234753-20240413T154942_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240413T071838-20240414T164042_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240415T081336-20240416T051918_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240415T224730-20240416T154908_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240415T224730-20240417T165054_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240417T082130-20240418T154848_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240417T082130-20240419T082219_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240419T032918-20240419T165725_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240419T082837-20240421T170339_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240420T100637-20240422T081413_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240422T070939-20240423T161743_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240423T122455-20240423T202749_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240423T163249-20240424T081255_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240424T014601-20240424T202649_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240424T172137-20240425T154744_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240425T084631-20240426T074308_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240426T031344-20240426T155238_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240426T075202-20240427T202350_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240427T135626-20240428T171538_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240428T085338-20240429T172438_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240429T103050-20240430T154708_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240430T072538-20240501T172902_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240501T130744-20240502T071139_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240501T233109-20240502T113309_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240502T072209-20240503T104327_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240503T070409-20240503T201727_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240503T135239-20240504T173457_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240504T091445-20240505T173651_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240505T085027-20240506T173833_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240506T100739-20240507T054221_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240506T234057-20240508T051616_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240507T234242-20240508T174152_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240508T132204-20240509T080122_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240508T234416-20240509T174328_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240509T140712-20240510T154604_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240510T072222-20240511T154558_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240511T085134-20240512T172013_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240512T085643-20240513T174913_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240513T094428-20240514T181523_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240514T142323-20240514T200529_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240514T182741-20240515T175143_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240515T143817-20240516T175247_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240516T093041-20240517T154523_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240517T091853-20240518T075323_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240518T013911-20240519T075247_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240518T235853-20240519T175559_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240519T093359-20240520T175705_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240520T142329-20240521T175754_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240521T104300-20240522T175900_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240522T085344-20240523T175948_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240523T115424-20240524T150012_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240524T060124-20240525T180130_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240525T055612-20240526T175654_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240526T093548-20240527T120325_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240527T055455-20240528T180331_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240528T132401-20240529T180407_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240529T055331-20240530T180431_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240530T134425-20240531T180501_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240531T055155-20240601T180537_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240601T094507-20240602T074116_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240602T013455-20240602T180602_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240602T100613-20240603T180626_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240603T054950-20240604T180656_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240604T102556-20240605T180720_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240605T123908-20240606T180738_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240606T132446-20240607T180750_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240607T100308-20240608T154417_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240608T072408-20240609T180833_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240609T103815-20240610T134417_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240610T054539-20240611T180857_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240611T155421-20240612T180903_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240612T072427-20240613T135551_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240613T073609-20240614T180927_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240614T054415-20240615T073303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240615T051451-20240615T180934_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240615T094958-20240616T180934_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240616T110818-20240617T141722_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240617T075746-20240618T120134_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240618T054216-20240619T180940_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240619T160946-20240620T073046_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240620T001604-20240620T140928_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240620T123452-20240621T101222_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240621T075149-20240621T180928_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240621T145128-20240622T072959_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240622T045311-20240622T180929_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240622T094947-20240623T072935_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240623T001559-20240623T193253_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240623T131359-20240624T180917_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240624T073723-20240625T170905_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240625T114947-20240626T180853_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240626T082741-20240627T120511_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240627T054611-20240628T154400_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240628T092448-20240629T072800_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240629T001500-20240629T180818_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240629T160042-20240630T100830_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240630T060830-20240630T193106_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240630T131206-20240701T180748_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240701T094836-20240702T052200_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240701T094836-20240702T112748_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240702T053821-20240703T072730_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240703T012848-20240704T075700_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240704T012612-20240704T112548_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240704T081248-20240705T072713_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240705T020807-20240705T180631_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240705T154649-20240706T180607_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240706T053749-20240707T072713_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240707T061713-20240707T135537_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240707T110619-20240707T193055_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240707T141131-20240708T115713_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240708T053751-20240709T150852_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240709T084931-20240710T072722_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240710T011049-20240711T072732_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240711T061014-20240711T111356_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240711T084414-20240713T072750_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240713T021632-20240713T180308_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240713T150944-20240714T072802_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240714T050832-20240714T202320_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240714T124914-20240715T072814_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240715T045002-20240716T072838_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240716T050408-20240717T072844_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240717T020250-20240717T193327_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240717T132957-20240718T115857_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240718T054257-20240718T193357_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240718T054257-20240719T072927_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240719T051151-20240719T140315_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240719T110915-20240719T193427_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240719T141815-20240720T115939_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240720T095645-20240720T193457_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240720T135745-20240721T073015_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240721T050833-20240721T152839_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240721T111009-20240721T193527_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240721T154345-20240722T041427_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240722T014557-20240723T164824_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240723T074251-20240723T193640_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240723T170339-20240724T175654_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240724T093410-20240725T073216_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240725T051716-20240725T193804_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240725T141724-20240726T162928_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240726T094204-20240727T055222_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240727T033158-20240727T193940_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240727T141916-20240728T194028_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240728T123755-20240729T073452_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240729T051422-20240729T162334_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240729T142040-20240730T194217_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240730T123611-20240731T073623_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240731T043411-20240731T194317_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240731T123455-20240801T073711_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240801T035311-20240801T161347_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240801T133253-20240802T073759_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240802T010629-20240802T194523_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240802T161047-20240803T194626_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240803T123153-20240804T194729_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240804T123441-20240805T194842_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240805T123006-20240806T074148_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240806T044306-20240806T194956_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240806T124554-20240807T074254_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240807T044130-20240807T195112_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240807T122742-20240808T195230_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240808T122642-20240809T074500_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240809T050518-20240809T195357_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240809T124900-20240810T195518_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240810T123827-20240811T195643_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240811T124930-20240812T195819_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240812T124931-20240813T195949_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240813T124537-20240814T200127_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240814T124931-20240815T200307_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240815T124119-20240816T075413_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240816T035925-20240816T200449_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240816T123907-20240817T075543_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240817T054507-20240817T200637_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240817T123658-20240818T200828_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240818T121802-20240819T075856_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240819T023532-20240820T201220_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240819T125914-20240819T155632_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240819T155944-20240821T030238_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240821T002126-20240821T140114_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240821T113808-20240822T201626_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240822T172232-20240823T045438_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240823T023102-20240823T201832_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240823T132220-20240824T023320_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240823T235850-20240824T202045_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240824T120939-20240825T202303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240825T121827-20240826T202527_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240826T140127-20240827T142245_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240827T095809-20240827T202751_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240827T153551-20240828T081527_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240828T030715-20240828T203027_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240828T120545-20240829T163045_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240829T133657-20240830T203540_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240829T163051-20240829T203300_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240830T154545-20240831T203828_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240831T164240-20240901T204116_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240901T163958-20240902T040328_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240902T015228-20240902T153734_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240902T124246-20240903T083058_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240902T153740-20240902T204410_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240903T052146-20240903T202531_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240903T120004-20240904T044658_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240904T020152-20240904T172510_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240904T132128-20240905T172440_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240905T132128-20240906T083911_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240906T061541-20240906T172359_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240906T140611-20240907T084247_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240907T035611-20240907T210029_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240907T035611-20240917T144312_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240907T200001-20240917T135954_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240908T112053-20240908T202747_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240917T132403-20240918T092418_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240918T042436-20240918T214637_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240918T184949-20240919T092901_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240919T041931-20240919T215149_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240919T190331-20240920T163019_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240920T133113-20240921T202331_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240920T163025-20240920T215701_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240921T115401-20240922T220749_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240922T133731-20240923T221325_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240923T134313-20240924T221902_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240924T134849-20240925T145634_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240924T134849-20240925T152634_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240925T115602-20240926T223026_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240925T145638-20240925T203156_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240926T135902-20240927T223608_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240927T140402-20240928T224135_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240928T140902-20240929T224702_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240929T141414-20240930T220603_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20240930T142835-20241001T225121_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241001T141739-20241002T225135_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241002T132657-20241003T225151_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241003T141621-20241004T203651_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241004T120051-20241005T225221_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241005T141621-20241006T225239_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241006T141551-20241007T225252_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241007T125752-20241008T105346_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241008T040616-20241009T225322_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241009T154946-20241010T225334_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241010T154816-20241011T225352_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241011T154522-20241012T225404_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241012T154222-20241013T225417_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241013T153829-20241014T101917_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241013T153829-20241015T223129_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241015T153107-20241016T110135_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241016T040329-20241017T110129_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241017T022138-20241018T225635_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241018T152005-20241019T171748_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241019T092447-20241020T230948_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241020T151300-20241021T101338_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241021T031812-20241022T231008_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241022T143418-20241023T231706_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241023T150130-20241024T231639_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241024T145754-20241025T231613_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241025T145354-20241026T231549_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241026T151807-20241027T231537_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241027T144555-20241028T064137_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241028T021519-20241029T231513_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241029T144131-20241030T221313_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241030T151143-20241031T051649_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241031T020131-20241101T093844_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241031T051655-20241031T085701_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241031T232926-20241101T231744_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241101T203638-20241102T072150_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241102T015938-20241103T231620_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241102T072156-20241102T095710_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241103T131050-20241104T162708_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241104T131114-20241105T231520_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241104T162710-20241104T231544_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241105T143226-20241106T093808_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241106T024726-20241107T093811_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241107T053744-20241108T093821_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241107T233333-20241109T093457_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241109T023951-20241109T231433_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241109T142215-20241110T230945_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241110T142209-20241111T093933_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241111T060503-20241111T171851_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241111T134257-20241112T171027_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241112T133851-20241112T221609_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241112T192815-20241113T174040_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241113T105239-20241114T105204_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241114T063104-20241114T174442_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241114T132940-20241115T081234_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241115T030828-20241115T231834_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241115T030828-20241119T181052_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241115T120952-20241116T105452_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241116T065152-20241116T175346_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241116T132016-20241117T232143_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241117T143310-20241118T221834_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241119T112158-20241120T075823_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241120T062059-20241120T181723_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241120T075829-20241120T094735_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241120T130123-20241121T105241_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241121T070523-20241121T182435_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241121T121317-20241122T091129_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241122T002241-20241123T092443_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241123T015911-20241123T183541_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241123T123535-20241124T090641_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241124T015605-20241125T233953_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241125T145059-20241126T190712_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241126T123124-20241126T234906_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241126T214624-20241127T113024_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241127T042124-20241127T173654_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241127T160718-20241128T100130_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241128T094718-20241129T121012_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241128T100136-20241128T151818_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241129T115614-20241130T121524_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241129T121014-20241129T170454_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241130T120112-20241202T001300_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241130T121530-20241130T165936_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241201T230918-20241202T175749_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241202T100118-20241203T174407_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241203T150255-20241204T002313_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241203T203337-20241204T175107_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241204T145407-20241205T002831_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241204T204207-20241205T073919_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241205T044737-20241205T192101_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241205T135225-20241206T185531_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241206T100607-20241207T125413_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241207T124007-20241208T192144_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241207T125416-20241207T210107_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241208T151213-20241209T004838_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241208T201844-20241209T123508_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241209T083614-20241210T005308_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241209T204356-20241210T123950_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241210T075720-20241211T005732_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241210T210120-20241211T131414_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241211T130020-20241212T010150_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241211T131416-20241211T170056_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241211T222450-20241212T172246_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241212T103326-20241213T125308_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241213T040402-20241214T125702_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241214T100932-20241215T011314_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241214T194402-20241216T011633_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241215T162233-20241216T184827_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241216T104739-20241217T203957_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241217T105039-20241218T204233_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241218T105345-20241219T194503_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241219T105621-20241220T131457_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241220T081527-20241221T012903_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241220T215051-20241221T214304_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241221T163658-20241222T013058_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241221T214928-20241222T195058_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241222T110410-20241223T195228_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241223T110340-20241224T220048_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241224T214740-20241225T220034_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241224T220052-20241225T013504_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241225T214716-20241226T195546_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241225T220040-20241226T013604_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241226T110716-20241227T132434_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241227T083722-20241228T013723_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241227T214759-20241228T132505_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241228T083759-20241229T013749_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241228T214835-20241230T013805_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241229T165505-20241231T013805_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241230T165541-20241231T155841_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241231T110947-20250101T013805_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20241231T215117-20250101T165729_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250101T112017-20250102T123811_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250102T095023-20250102T224429_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250102T165635-20250103T185550_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250103T130800-20250104T013700_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250103T224942-20250104T135406_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250104T134218-20250105T115900_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250104T135412-20250104T192936_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250105T091148-20250105T192848_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250105T134148-20250106T062906_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250106T042250-20250106T155800_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250106T111336-20250107T013450_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250106T215412-20250107T132200_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250107T103442-20250107T204306_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250107T145512-20250108T132106_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250108T103851-20250109T013251_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250108T214024-20250109T120513_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250109T091800-20250109T173501_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250109T134755-20250110T013143_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250109T194425-20250110T154921_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250110T110337-20250111T013025_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250110T214201-20250111T131725_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250111T103001-20250111T223631_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250111T164907-20250112T080321_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250112T041637-20250112T134551_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250112T133407-20250113T131437_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250112T134555-20250112T192107_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250113T102752-20250114T012613_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250113T193943-20250114T210452_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250114T151749-20250115T012437_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250114T224819-20250115T222932_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250115T164331-20250116T075614_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250116T040920-20250116T224556_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250116T223426-20250117T075414_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250116T224602-20250117T012114_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250117T040732-20250117T225732_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250117T163850-20250118T222308_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250118T173044-20250119T074950_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250119T040308-20250119T170552_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250119T165438-20250120T193908_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250119T170556-20250119T194108_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250120T121714-20250121T193708_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250121T135044-20250122T011126_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250121T212444-20250122T064227_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250122T035545-20250122T160309_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250122T115715-20250123T063951_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250123T035321-20250123T142751_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250123T104121-20250123T205523_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250123T162351-20250124T125321_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250124T085133-20250125T010451_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250124T204157-20250125T142315_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250125T103703-20250125T190939_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250125T161827-20250126T010227_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250125T221633-20250126T185327_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250126T130703-20250127T202254_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250127T115033-20250128T112840_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250128T074654-20250128T184340_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250128T131210-20250129T072334_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250129T033540-20250129T155716_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250129T033540-20250130T130754_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250129T122540-20250129T235824_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250130T125710-20250131T004958_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250130T130758-20250130T184310_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250130T210346-20250131T130510_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250131T125416-20250201T004716_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250131T130516-20250131T184028_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250131T210116-20250201T123240_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250201T094652-20250201T214034_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250201T155452-20250202T154916_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250202T101652-20250203T004140_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250202T214222-20250203T122646_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250203T095434-20250203T224817_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250203T170229-20250204T064255_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250204T031435-20250204T185659_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250204T171053-20250205T141111_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250205T100759-20250206T003255_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250205T200435-20250206T065159_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250206T030559-20250206T121735_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250206T093205-20250207T002953_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250206T184405-20250207T134747_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250207T100205-20250208T002641_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250207T184111-20250208T121105_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250208T092535-20250208T211135_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250208T152541-20250209T102641_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250209T101605-20250210T002012_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250209T102647-20250209T160159_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250209T203441-20250210T152600_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250210T095212-20250210T200806_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250210T171012-20250211T225648_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250211T162618-20250212T154806_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250212T153806-20250213T001000_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250212T154812-20250212T183630_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250212T202418-20250213T151454_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250213T094230-20250214T000627_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250213T181118-20250214T114948_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250214T090424-20250215T000200_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250214T181624-20250215T084518_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250215T055957-20250215T155018_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250215T153954-20250216T094637_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250215T155024-20250215T192536_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250216T093625-20250216T235519_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250216T094643-20250216T133901_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250216T191855-20250217T082913_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250217T021131-20250217T153013_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250217T151957-20250218T090725_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250217T153019-20250217T235125_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250218T020527-20250218T135149_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250218T092357-20250219T082213_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250219T021637-20250219T133057_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250219T092101-20250219T234537_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250219T213731-20250220T081849_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250220T051937-20250220T145013_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250220T091907-20250220T232813_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250220T194307-20250221T112543_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250221T084037-20250221T195807_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250221T141307-20250222T052707_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250222T014143-20250222T112301_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250222T083737-20250222T233844_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250222T175344-20250223T052044_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250223T013544-20250223T112008_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250223T083514-20250223T233608_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250223T175038-20250224T080514_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250224T052020-20250224T125520_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250224T091014-20250224T233326_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250224T174820-20250225T232658_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250225T144156-20250226T125014_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250226T090526-20250226T232732_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250226T144226-20250227T131008_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250227T090226-20250227T225402_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250227T190156-20250228T190827_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250228T132332-20250301T105959_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250301T081503-20250301T224403_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250301T165903-20250302T074545_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250302T045439-20250302T143221_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250302T085339-20250303T084515_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250303T060051-20250303T223533_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250303T165051-20250304T223130_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250304T165051-20250305T073615_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250305T045157-20250305T222730_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250305T164257-20250306T084921_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250306T084000-20250307T084534_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250306T084927-20250306T140509_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250307T083640-20250308T102930_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250307T084540-20250307T125040_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250308T074852-20250308T180316_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250308T122104-20250309T124558_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250309T082900-20250309T224416_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250309T183330-20250310T072040_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250310T043710-20250310T174634_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250310T120240-20250311T223434_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250311T135004-20250312T222934_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250312T150001-20250313T222423_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250312T150001-20250314T221911_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250314T133629-20250315T200647_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250315T112417-20250316T074217_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250316T052559-20250317T195232_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250317T111017-20250318T194559_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250318T141241-20250319T073536_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250319T004953-20250320T065130_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250319T223512-20250321T064832_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250319T223512-20250322T070602_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250321T222530-20250323T091048_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250323T003100-20250324T090606_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250324T002630-20250325T155337_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250325T071600-20250326T211855_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250326T132843-20250327T155307_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250327T125437-20250328T155249_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250328T071931-20250329T160237_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250329T072701-20250330T155213_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250330T073219-20250331T155156_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250331T071619-20250401T155144_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250401T071656-20250402T205534_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250402T124138-20250403T083320_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250403T040902-20250404T083132_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250404T001320-20250405T162302_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250405T074956-20250406T155021_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250406T071802-20250407T155005_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250407T071839-20250408T163545_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250408T121703-20250409T134945_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250409T071903-20250410T164427_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250410T081357-20250411T082151_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250411T055151-20250411T203827_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250411T151133-20250412T154909_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250412T071939-20250413T154858_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250413T072728-20250414T154846_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250414T072752-20250415T170504_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250415T121446-20250416T160616_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250416T074604-20250417T154816_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250417T072022-20250418T154810_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250418T072004-20250419T154759_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250419T072023-20250420T172307_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250420T085541-20250421T145241_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250421T092535-20250421T202411_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250421T175659-20250422T081105_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250422T054417-20250423T050535_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250422T084217-20250422T092459_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250423T023841-20250423T144711_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250423T121229-20250424T080905_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250424T054241-20250424T144429_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250424T091805-20250425T060406_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250425T023053-20250425T110154_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250425T061418-20250426T080712_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250425T234100-20250427T080618_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250426T234308-20250428T080524_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250427T234554-20250505T171201_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250429T235130-20250430T173054_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250430T122730-20250501T051836_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250501T002212-20250501T175419_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250501T170655-20250502T080143_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250502T020731-20250505T171201_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250502T155031-20250503T033455_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250502T235801-20250503T175855_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250503T060631-20250504T075955_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250504T000049-20250504T200719_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250504T000049-20250506T073113_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250505T154207-20250507T050919_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250507T002155-20250507T155656_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20250507T125643-20250508T051032_V01.bc'

                           '$KERNELS/fk/solo_ANC_soc-sc-fk_V10.tf'
                           '$KERNELS/fk/solo_ANC_soc-ops-fk_V02.tf'
                           '$KERNELS/fk/solo_ANC_soc-sci-fk_V08.tf'
                           '$KERNELS/fk/earth_topo_050714.tf'
                           '$KERNELS/fk/estrack_v04.tf'

                           '$KERNELS/ik/solo_ANC_soc-epd-ik_V03.ti'
                           '$KERNELS/ik/solo_ANC_soc-eui-ik_V01.ti'
                           '$KERNELS/ik/solo_ANC_soc-metis-ik_V03.ti'
                           '$KERNELS/ik/solo_ANC_soc-phi-ik_V01.ti'
                           '$KERNELS/ik/solo_ANC_soc-solohi-ik_V01.ti'
                           '$KERNELS/ik/solo_ANC_soc-spice-ik_V02.ti'
                           '$KERNELS/ik/solo_ANC_soc-stix-ik_V02.ti'
                           '$KERNELS/ik/solo_ANC_soc-swa-ik_V03.ti'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/pck/pck00010.tpc'

                           '$KERNELS/pck/earth_070425_370426_predict.bpc'

                           '$KERNELS/sclk/solo_ANC_soc-sclk_20250504_V02.tsc'

                           '$KERNELS/spk/solo_ANC_soc-orbit_20200210-20301120_L021_V1_00443_V01.bsp'
                           '$KERNELS/spk/solo_ANC_soc-orbit-stp_20200210-20301120_362_V1_00447_V01.bsp'
                           '$KERNELS/spk/de421.bsp'
                           '$KERNELS/spk/earthstns_itrf93_050714.bsp'
                           '$KERNELS/spk/estrack_v04.bsp'
                           '$KERNELS/spk/earthnpole_19500101_20301231_v01.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
--------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v111_20250508_001'

   \begintext

   The unique identifier for this meta-kernel is provided by the following
   keyword:

   \begindata

      MK_IDENTIFIER = 'solo_ANC_soc-flown-mk_V111_20250508_001'

   \begintext


Contact Information
--------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@cosmos.esa.int,


End of MK file.