KPL/MK

Meta-kernel for Solar Orbiter Dataset v107 -- As Flown 20220302_001
============================================================================

   This meta-kernel lists the Solar_Orbiter As Flown SPICE kernels
   that provide information for the As Flown scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the Solar_Orbiter As Flown scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v3.2.7.


Usage of the Meta-kernel
---------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE Web server:

      https://spiftp.esac.esa.int/data/SPICE/SOLAR-ORBITER/kernels/

   or from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/SOLAR-ORBITER/kernels/


Implementation Notes
---------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the Solar_Orbiter SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on March 2, 2022 by Alfredo Escalante Lopez ESA/ESAC.
   The original name of this file was solo_ANC_soc-flown-mk_V107_20220302_001.tm.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/ck/solo_ANC_soc-sc-iboom-ck_20180930-21000101_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-sc-oboom-ck_20180930-21000101_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-sc-fof-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-eui-fsi-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-eui-hri-euv-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-eui-hri-lya-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-metis-euv-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-metis-vis-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-metis-m0-tel-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-phi-fdt-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-phi-hrt-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-solohi-ck_20180930-21000101_V03.bc'
                           '$KERNELS/ck/solo_ANC_soc-spice-sw-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-spice-lw-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-stix-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200210-20200214_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200212-20200214_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200214-20200216_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200218-20200221_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200222-20200224_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200225-20200228_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200228-20200301_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200229-20200301_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200229-20200302_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200302-20200303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200303-20200303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200303-20200304_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200304-20200305_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200305-20200306_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200306-20200307_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200307-20200308_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200308-20200309_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200309-20200310_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200310-20200311_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200311-20200312_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200312-20200313_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200313-20200314_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200314-20200315_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200315-20200316_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200316-20200317_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200317-20200318_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200318-20200319_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200319-20200320_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200320-20200321_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200321-20200322_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200322-20200323_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200323-20200326_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200324-20200324_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200325-20200325_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200326-20200330_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200327-20200327_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200330-20200331_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200331-20200401_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200401-20200402_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200402-20200403_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200403-20200404_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200404-20200405_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200405-20200406_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200406-20200407_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200407-20200408_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200408-20200410_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200410-20200411_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200411-20200412_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200412-20200413_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200413-20200414_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200414-20200415_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200416-20200416_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200417-20200417_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200418-20200418_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200419-20200419_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200420-20200420_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200421-20200421_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200422-20200422_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200423-20200423_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200424-20200424_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200425-20200425_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200426-20200426_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200427-20200427_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200428-20200428_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200429-20200429_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200430-20200430_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200501-20200501_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200502-20200502_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200503-20200503_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200504-20200504_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200505-20200505_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200506-20200506_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200507-20200507_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200508-20200508_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200509-20200509_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200510-20200510_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200511-20200511_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200512-20200512_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200513-20200513_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200514-20200514_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200515-20200515_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200516-20200516_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200517-20200517_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200518-20200518_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200519-20200519_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200520-20200520_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200521-20200521_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200522-20200522_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200523-20200523_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200524-20200524_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200525-20200525_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200526-20200526_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200526-20200527_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200527-20200528_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200528-20200529_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200529-20200530_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200530-20200531_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200531-20200601_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200601-20200602_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200602-20200603_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200603-20200604_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200604-20200605_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200605-20200608_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200608-20200609_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200609-20200610_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200610-20200611_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200611-20200613_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200613-20200614_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200614-20200615_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200615-20200618_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200618-20200619_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200619-20200622_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200622-20200623_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200623-20200624_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200624-20200625_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200625-20200626_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200626-20200627_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200627-20200629_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200629-20200630_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200630-20200701_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200701-20200702_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200702-20200703_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200703-20200704_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200704-20200706_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200706-20200707_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200707-20200709_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200709-20200710_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200710-20200713_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200713-20200714_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200714-20200715_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200715-20200720_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200720-20200722_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200722-20200724_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200724-20200727_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200727-20200729_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200729-20200730_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200730-20200731_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200731-20200803_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200803-20200804_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200804-20200806_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200806-20200807_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200807-20200810_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200810-20200812_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200812-20200813_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200813-20200813_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200813-20200817_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200817-20200818_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200817-20200819_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200819-20200820_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200819-20200821_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200821-20200824_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200823-20200824_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200824-20200825_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200824-20200827_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200827-20200828_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200828-20200831_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200831-20200901_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200901-20200903_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200902-20200904_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200904-20200904_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200904-20200906_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200906-20200907_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200907-20200908_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200908-20200909_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200909-20200910_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200910-20200910_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200910-20200911_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200911-20200912_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200912-20200915_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200915-20200917_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200917-20200918_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200918-20200919_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200918-20200921_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200921-20200922_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200922-20200923_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200922-20200924_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200924-20200925_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200925-20200928_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200928-20200929_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200929-20201001_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201001-20201002_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201002-20201005_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201004-20201006_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201005-20201006_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201006-20201007_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201007-20201008_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201008-20201009_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201009-20201012_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201012-20201012_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201012-20201013_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201013-20201015_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201015-20201016_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201016-20201017_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201017-20201019_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201019-20201020_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201020-20201021_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201021-20201022_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201022-20201023_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201023-20201026_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201026-20201028_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201028-20201030_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201030-20201102_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201102-20201103_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201103-20201105_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201105-20201106_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201106-20201109_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201109-20201110_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201110-20201111_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201111-20201112_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201112-20201116_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201116-20201116_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201116-20201117_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201116T141503-20201116T211457_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201117-20201117_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201117-20201118_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201118-20201119_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201119-20201119_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201119T082309-20201120T003115_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201119T210936-20201120T203021_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201120T114033-20201121T001727_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201120T205533-20201121T200152_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201121T115116-20201122T200310_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201122T104234-20201123T200428_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201123T122328-20201124T003646_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201123T211046-20201124T141946_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201124T061752-20201125T203646_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201125T104604-20201126T003128_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201125T211807-20201126T141728_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201126T062022-20201127T074252_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201127T041904-20201127T200946_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201127T130352-20201128T201111_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201128T114907-20201129T201207_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201129T105159-20201130T063837_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201130T031505-20201130T201153_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201130T115153-20201201T204123_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201201T115105-20201202T001637_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201201T205553-20201202T204108_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201202T110929-20201202T111623_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201202T115805-20201203T053141_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201202T211617-20201204T001141_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201203T204829-20201204T201117_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201204T114938-20201205T201118_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201205T131830-20201206T201124_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201206T104606-20201207T051648_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201207T015448-20201207T201138_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201207T120054-20201208T140718_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201208T064706-20201209T001142_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201208T204930-20201209T204130_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201209T104824-20201210T051648_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201209T213312-20201211T001154_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201210T204939-20201211T201224_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201211T114630-20201212T201249_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201212T114719-20201213T201319_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201213T105049-20201214T034707_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201214T002325-20201214T140507_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201214T065707-20201215T140455_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201215T095949-20201215T101649_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201215T104243-20201216T075643_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201215T213549-20201216T140449_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201216T081925-20201217T010149_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201216T210837-20201217T140455_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201217T071519-20201218T140455_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201218T071931-20201219T001650_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201218T205538-20201219T201744_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201219T110726-20201220T201840_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201220T110856-20201221T204926_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201221T110050-20201222T063226_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201221T210056-20201222T140708_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201222T105432-20201223T204650_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201223T105902-20201224T054550_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201223T204656-20201223T205144_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201223T210220-20201224T204711_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201224T105856-20201225T071632_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201224T204714-20201224T205311_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201224T205802-20201225T143902_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201225T103908-20201225T213233_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201225T143908-20201225T204933_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201225T210103-20201226T143941_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201225T213239-20201226T090411_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201226T091657-20201227T080457_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201226T143945-20201226T213451_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201226T213457-20201226T214003_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201226T214339-20201227T143951_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201227T094933-20201227T213715_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201227T143957-20201227T205711_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201227T210909-20201228T144027_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201227T210909-20201229T091015_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T095015-20201228T101657_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T101703-20201228T102157_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T102615-20201228T213941_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T144033-20201228T205239_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T210621-20201229T144109_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201229T092203-20201230T203209_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201229T144111-20201229T211341_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201230T110927-20201231T203351_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201231T110809-20210101T111121_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210101T074827-20210101T212010_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210101T125833-20210102T203542_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210102T121452-20210103T203728_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210103T121428-20210104T114958_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210104T075510-20210104T203922_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210104T121346-20210105T204128_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210105T142334-20210106T183910_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210106T122622-20210107T115852_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210107T080643-20210107T200846_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210107T122104-20210108T120146_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210108T080552-20210108T204811_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210108T122934-20210109T205029_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210109T122411-20210110T205259_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210110T122943-20210111T121011_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210111T081859-20210111T205541_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210111T123029-20210112T205817_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210112T123229-20210113T131714_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210113T094723-20210115T060411_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210113T131717-20210113T181311_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210114T215117-20210115T141724_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210115T100647-20210118T075736_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210115T141730-20210115T210242_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210118T011130-20210118T213208_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210118T040830-20210119T100208_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210118T141850-20210119T141708_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210118T181338-20210119T213220_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210119T183938-20210120T062002_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210119T215838-20210120T140238_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210120T083556-20210122T101308_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210122T011650-20210122T204739_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210122T102320-20210125T102039_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210125T012545-20210125T204739_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210125T103557-20210126T141727_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210126T103551-20210127T102527_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210126T141729-20210126T204245_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210127T013503-20210127T204239_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210127T103757-20210129T191040_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210129T104416-20210212T201412_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210201T102146-20210201T171728_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210201T171730-20210201T192346_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210210T110235-20210210T184111_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210210T184117-20210210T200447_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210212T115706-20210215T181802_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210215T120700-20210217T041806_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210216T235324-20210219T041807_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210219T000143-20210219T172733_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210219T090233-20210220T181813_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210220T123413-20210222T172637_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210222T090543-20210223T172613_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210223T090243-20210226T172456_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210226T090720-20210301T172314_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210301T113802-20210302T041544_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210302T010314-20210303T041826_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210303T015150-20210304T041826_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210304T004644-20210304T154235_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210304T090657-20210305T172057_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210305T085551-20210306T041833_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210306T005351-20210306T162015_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210306T085321-20210307T092457_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210307T005745-20210308T171906_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210308T085257-20210311T171704_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210311T084906-20210312T163910_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210312T085036-20210315T192428_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210315T141016-20210316T192807_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210316T084858-20210317T163340_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210317T140528-20210318T193517_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210318T140453-20210322T194859_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210322T084429-20210323T195217_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210323T141323-20210324T195529_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210324T084147-20210325T183342_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210325T084554-20210326T200142_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210326T084100-20210327T200448_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210327T084124-20210328T170630_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210328T083800-20210329T170606_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210329T084006-20210331T201639_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210331T115136-20210402T202219_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210401T181731-20210412T170126_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210402T115619-20210405T203019_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210405T120243-20210408T203750_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210408T120926-20210409T204020_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210412T083702-20210414T170109_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210414T083750-20210416T213133_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210416T153221-20210419T200621_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210419T153927-20210421T055827_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210421T030351-20210421T223522_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210421T154304-20210423T201428_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210423T154834-20210424T070342_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210424T030722-20210424T175758_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210424T155658-20210426T201946_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210426T155334-20210428T090952_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210428T031652-20210429T084159_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210429T031447-20210430T202559_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210430T155823-20210501T103223_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210501T070505-20210503T202953_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210503T195005-20210505T103342_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210505T032217-20210506T075012_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210506T032244-20210507T203412_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210507T160642-20210508T103444_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210508T061454-20210510T203636_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210510T160900-20210511T103554_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210511T032854-20210513T223901_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210513T161155-20210514T203901_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210514T161149-20210517T184001_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210517T161525-20210519T103956_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210519T033325-20210520T104032_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210520T033314-20210521T224338_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210521T161332-20210524T184014_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210524T161402-20210526T100603_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210526T033120-20210527T104447_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210527T033145-20210528T202233_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210528T161257-20210531T190733_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210531T161209-20210603T104910_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210603T033004-20210603T220318_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210603T193622-20210604T220128_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210604T160748-20210609T183353_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210609T125459-20210610T093935_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210610T032423-20210611T201741_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210611T133111-20210614T105617_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210614T032011-20210616T105736_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210616T031747-20210617T105818_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210617T031648-20210618T105854_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210618T075142-20210621T173024_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210621T090630-20210623T211001_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210623T124437-20210625T173251_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210625T090713-20210628T110449_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210628T083907-20210628T230531_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210628T154113-20210629T193301_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210629T122243-20210630T072022_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210630T030055-20210630T225356_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210630T182438-20210701T194422_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210701T113738-20210702T225914_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210702T153220-20210703T154752_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210703T102656-20210703T204102_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210703T181438-20210704T205432_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210704T102802-20210705T110850_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210705T070614-20210705T193320_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210705T152644-20210706T110920_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210706T073708-20210706T204538_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210706T153138-20210707T110953_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210707T082603-20210707T204709_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210707T152327-20210708T204803_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210708T104345-20210709T111057_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210708T225823-20210713T203939_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210709T101153-20210709T205015_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210709T155515-20210710T204445_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210710T102015-20210711T204303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210711T102045-20210712T111233_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210713T103533-20210714T111340_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210714T084540-20210714T184724_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210714T150958-20210715T111410_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210715T023622-20210716T111446_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210716T023504-20210717T232804_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210717T150440-20210718T203046_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210718T170510-20210719T111622_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210719T022940-20210720T202705_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210720T104558-20210721T111723_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210721T022817-20210722T174835_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210722T145547-20210723T111823_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210723T065105-20210723T233235_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210723T145735-20210724T180835_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210724T095605-20210725T180841_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210725T112205-20210727T233530_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210727T144656-20210728T182154_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210728T151754-20210729T112130_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210729T083906-20210729T233700_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210729T144036-20210730T112200_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210730T070730-20210730T233742_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210730T190536-20210731T092106_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210731T021112-20210731T233830_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210731T194118-20210801T092157_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210801T025554-20210801T233912_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210801T190418-20210802T181324_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210802T145900-20210803T234043_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210803T143319-20210804T052919_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210804T020207-20210804T165731_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210804T142801-20210805T112507_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210805T062031-20210805T172507_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210805T144237-20210805T195537_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210805T172513-20210805T181907_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210805T182419-20210806T133237_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210806T093401-20210807T084827_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210807T015513-20210807T190607_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210807T160425-20210807T234343_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210807T192207-20210808T092755_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210808T015337-20210808T150431_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210808T130031-20210809T112713_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210809T054255-20210809T204943_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210809T142355-20210810T112808_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210810T052919-20210810T194520_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210810T181926-20210811T051950_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210811T014902-20210811T190456_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210811T141356-20210812T234838_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210812T141238-20210813T051658_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210813T014620-20210814T235044_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210813T133914-20210813T234944_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210814T140920-20210815T235159_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210815T140408-20210816T235302_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210816T140544-20210817T235409_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210817T140357-20210818T113451_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210818T072251-20210818T235521_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210818T180715-20210819T113551_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210819T013421-20210820T235739_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210820T135803-20210821T230045_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210821T135821-20210824T000104_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210823T152957-20210825T223940_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210825T140722-20210827T203540_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210827T153134-20210828T114404_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210828T074234-20210831T000911_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210830T153516-20210902T001117_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210901T153611-20210903T104911_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210903T061417-20210904T001329_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210903T183717-20210906T230400_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210906T142854-20210909T001812_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210908T154030-20210910T115406_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210910T074724-20210910T230836_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210910T154212-20210911T163242_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210911T130554-20210912T162942_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210912T122742-20210914T002101_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210913T131355-20210914T231307_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210914T132125-20210915T104701_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210915T065855-20210916T004543_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210915T213319-20210916T111555_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210916T004519-20210917T231631_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210916T075401-20210916T114425_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210917T125534-20210918T091704_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210918T003713-20210919T091455_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210919T030243-20210921T001038_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210920T211820-20210922T171108_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210922T153256-20210924T115514_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210924T071732-20210925T000120_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210924T195302-20210927T080639_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210927T041945-20210927T232435_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210927T185415-20210928T210751_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210928T122703-20210930T173303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210930T145105-20211002T172551_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211002T121757-20211005T233052_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211005T144628-20211007T203952_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211007T115622-20211009T231752_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211009T143507-20211012T230729_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211012T142229-20211014T230023_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211014T142753-20211016T225247_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211016T140853-20211019T111948_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211019T110738-20211020T111038_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211019T111954-20211019T153618_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211020T002748-20211021T083809_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211021T024406-20211021T223318_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211021T175530-20211022T222912_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211022T115524-20211023T222509_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211023T113754-20211024T105813_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211024T001237-20211025T105455_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211025T002031-20211026T105137_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211026T000525-20211027T212149_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211027T103337-20211028T104443_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211027T235737-20211029T104110_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211028T235449-20211030T215556_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211030T110655-20211031T215138_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211031T111026-20211101T214720_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211101T110002-20211102T102638_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211102T035702-20211103T102250_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211102T233402-20211104T074356_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211103T232950-20211105T101511_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211104T233041-20211106T093326_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211105T225356-20211107T205303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211107T100803-20211108T211721_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211108T103009-20211109T211303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211109T102133-20211110T210845_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211110T103811-20211111T095133_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211110T230157-20211112T094727_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211111T225739-20211113T205558_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211113T100740-20211114T205142_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211114T100316-20211115T204728_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211114T100316-20211117T072852_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211115T095452-20211116T093116_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211117T034746-20211118T075622_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211117T210513-20211119T091858_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211118T222758-20211120T202647_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211120T103513-20211121T202243_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211121T093247-20211122T201841_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211122T093753-20211123T201441_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211123T092811-20211124T034505_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211123T220605-20211125T092223_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211125T082717-20211126T091505_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211125T092229-20211125T161811_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211126T082229-20211126T213644_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211126T191614-20211127T133624_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211126T213648-20211127T043124_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211127T080706-20211128T133542_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211127T143218-20211127T183618_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211127T194000-20211128T050506_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211128T071524-20211128T183536_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211128T143418-20211129T050144_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211128T194130-20211129T133500_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211129T070948-20211129T183500_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211129T142924-20211130T045754_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211129T193648-20211201T012206_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211130T143042-20211202T011812_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211201T142800-20211203T011418_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211202T142354-20211204T011037_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211203T142015-20211205T010101_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211204T141319-20211205T190325_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211204T141319-20211206T010307_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211205T142031-20211207T005931_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211205T183331-20211206T010307_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211206T141731-20211207T161345_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211207T132437-20211208T042731_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211207T203849-20211208T160955_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211208T132113-20211209T042343_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211208T203416-20211210T004149_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211209T135131-20211211T004508_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211210T135501-20211212T004138_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211211T135202-20211213T003808_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211212T135014-20211213T155120_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211213T065926-20211215T003108_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211214T154526-20211216T002738_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211215T173332-20211217T002408_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211216T153620-20211218T002039_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211217T153415-20211218T145021_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211218T060339-20211220T001351_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211219T152427-20211221T001021_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211219T152427-20211222T000657_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211221T152003-20211223T000327_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211222T151839-20211224T000003_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211223T151121-20211224T235640_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211224T150810-20211225T235316_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211225T150810-20211226T234952_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211226T150204-20211227T213446_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211227T124804-20211228T213104_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211228T131828-20211229T233934_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211229T150419-20211230T233604_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211230T145110-20211231T233241_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20211231T144859-20220101T175423_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220101T122853-20220102T232553_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220102T143935-20220103T232223_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220103T143435-20220104T194320_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220104T150017-20220105T231523_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220105T145541-20220106T231153_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220106T142429-20220107T230820_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220107T142120-20220108T190812_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220108T121242-20220109T230118_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220109T142618-20220110T204230_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220110T145712-20220112T021706_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220111T173330-20220113T015551_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220112T173012-20220114T020931_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220113T183548-20220115T020537_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220114T171931-20220116T020143_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220115T171437-20220117T013549_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220116T165025-20220118T013155_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220117T164637-20220119T012801_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220118T185307-20220119T222331_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220119T145152-20220120T221932_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220120T144513-20220122T013802_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220121T165238-20220123T011150_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220122T183708-20220124T012956_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220123T181214-20220124T210944_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220124T122344-20220125T205608_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220125T121308-20220126T202626_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220126T114002-20220127T193509_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220127T105314-20220128T185733_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220128T110623-20220129T192645_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220129T104153-20220130T192227_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220130T103821-20220131T191809_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220131T103453-20220201T191339_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220201T103027-20220202T175451_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220202T102633-20220203T211504_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220203T123234-20220204T202204_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220204T113558-20220205T192724_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220205T121910-20220206T202728_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220206T114328-20220207T205255_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220207T121146-20220208T204658_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220208T120052-20220209T204058_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220209T115622-20220210T203447_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220210T114941-20220211T202825_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220211T114517-20220212T202155_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220212T114347-20220213T182711_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220213T113323-20220214T200817_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220214T112353-20220215T200123_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220215T111911-20220216T195406_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220216T111211-20220217T175730_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220217T120126-20220218T193912_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220218T105618-20220219T193130_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220219T104606-20220220T192336_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220220T103806-20220221T191536_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220221T103212-20220222T190724_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220222T102706-20220223T185907_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220223T101818-20220224T185037_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220223T101818-20220225T184207_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220225T103149-20220226T183327_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220226T095437-20220227T182443_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220227T094243-20220228T101713_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220228T013619-20220301T054558_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20220301T001007-20220302T054450_V01.bc'

                           '$KERNELS/fk/solo_ANC_soc-sc-fk_V09.tf'
                           '$KERNELS/fk/solo_ANC_soc-ops-fk_V02.tf'
                           '$KERNELS/fk/solo_ANC_soc-sci-fk_V08.tf'
                           '$KERNELS/fk/earth_topo_050714.tf'
                           '$KERNELS/fk/estrack_v04.tf'

                           '$KERNELS/ik/solo_ANC_soc-epd-ik_V03.ti'
                           '$KERNELS/ik/solo_ANC_soc-eui-ik_V01.ti'
                           '$KERNELS/ik/solo_ANC_soc-metis-ik_V03.ti'
                           '$KERNELS/ik/solo_ANC_soc-phi-ik_V01.ti'
                           '$KERNELS/ik/solo_ANC_soc-solohi-ik_V01.ti'
                           '$KERNELS/ik/solo_ANC_soc-spice-ik_V02.ti'
                           '$KERNELS/ik/solo_ANC_soc-stix-ik_V02.ti'
                           '$KERNELS/ik/solo_ANC_soc-swa-ik_V03.ti'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/pck/pck00010.tpc'

                           '$KERNELS/pck/earth_070425_370426_predict.bpc'

                           '$KERNELS/sclk/solo_ANC_soc-sclk_20220228_V01.tsc'

                           '$KERNELS/spk/solo_ANC_soc-orbit_20200210-20301120_L008_V1_00137_V01.bsp'
                           '$KERNELS/spk/solo_ANC_soc-orbit-stp_20200210-20301120_192_V1_00140_V01.bsp'
                           '$KERNELS/spk/de421.bsp'
                           '$KERNELS/spk/earthstns_itrf93_050714.bsp'
                           '$KERNELS/spk/estrack_v04.bsp'
                           '$KERNELS/spk/earthnpole_19500101_20251231_v01.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
--------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v107_20220302_001'

   \begintext


Contact Information
--------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@sciops.esa.int,


End of MK file.