KPL/MK

Meta-kernel for Solar Orbiter Dataset v106 -- As Flown 20210120_002
============================================================================

   This meta-kernel lists the Solar_Orbiter As Flown SPICE kernels
   that provide information for the As Flown scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the Solar_Orbiter As Flown scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v2.5.2.


Usage of the Meta-kernel
---------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/SOLAR-ORBITER/kernels/


Implementation Notes
---------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the Solar_Orbiter SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on January 20, 2021 by Marc Costa Sitja ESA/ESAC.
   The original name of this file was solo_ANC_soc-flown-mk_V106_20210120_002.tm.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/ck/solo_ANC_soc-sc-iboom-ck_20180930-21000101_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-sc-oboom-ck_20180930-21000101_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-sc-fof-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-eui-fsi-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-eui-hri-euv-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-eui-hri-lya-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-metis-euv-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-metis-vis-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-metis-m0-tel-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-phi-fdt-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-phi-hrt-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-solohi-ck_20180930-21000101_V03.bc'
                           '$KERNELS/ck/solo_ANC_soc-spice-sw-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-spice-lw-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-stix-ck_20180930-21000101_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200210-20200214_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200212-20200214_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200214-20200216_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200218-20200221_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200222-20200224_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200225-20200228_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200228-20200301_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200229-20200301_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200229-20200302_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200302-20200303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200303-20200303_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200303-20200304_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200304-20200305_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200305-20200306_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200306-20200307_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200307-20200308_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200308-20200309_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200309-20200310_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200310-20200311_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200311-20200312_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200312-20200313_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200313-20200314_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200314-20200315_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200315-20200316_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200316-20200317_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200317-20200318_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200318-20200319_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200319-20200320_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200320-20200321_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200321-20200322_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200322-20200323_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200323-20200326_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200324-20200324_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200325-20200325_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200326-20200330_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200327-20200327_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200330-20200331_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200331-20200401_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200401-20200402_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200402-20200403_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200403-20200404_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200404-20200405_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200405-20200406_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200406-20200407_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200407-20200408_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200408-20200410_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200410-20200411_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200411-20200412_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200412-20200413_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200413-20200414_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200414-20200415_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200416-20200416_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200417-20200417_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200418-20200418_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200419-20200419_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200420-20200420_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200421-20200421_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200422-20200422_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200423-20200423_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200424-20200424_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200425-20200425_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200426-20200426_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200427-20200427_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200428-20200428_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200429-20200429_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200430-20200430_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200501-20200501_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200502-20200502_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200503-20200503_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200504-20200504_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200505-20200505_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200506-20200506_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200507-20200507_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200508-20200508_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200509-20200509_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200510-20200510_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200511-20200511_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200512-20200512_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200513-20200513_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200514-20200514_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200515-20200515_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200516-20200516_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200517-20200517_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200518-20200518_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200519-20200519_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200520-20200520_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200521-20200521_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200522-20200522_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200523-20200523_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200524-20200524_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200525-20200525_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200526-20200526_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200526-20200527_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200527-20200528_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200528-20200529_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200529-20200530_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200530-20200531_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200531-20200601_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200601-20200602_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200602-20200603_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200603-20200604_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200604-20200605_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200605-20200608_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200608-20200609_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200609-20200610_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200610-20200611_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200611-20200613_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200613-20200614_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200614-20200615_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200615-20200618_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200618-20200619_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200619-20200622_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200622-20200623_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200623-20200624_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200624-20200625_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200625-20200626_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200626-20200627_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200627-20200629_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200629-20200630_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200630-20200701_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200701-20200702_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200702-20200703_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200703-20200704_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200704-20200706_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200706-20200707_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200707-20200709_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200709-20200710_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200710-20200713_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200713-20200714_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200714-20200715_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200715-20200720_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200720-20200722_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200722-20200724_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200724-20200727_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200727-20200729_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200729-20200730_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200730-20200731_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200731-20200803_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200803-20200804_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200804-20200806_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200806-20200807_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200807-20200810_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200810-20200812_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200812-20200813_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200813-20200813_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200813-20200817_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200817-20200818_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200817-20200819_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200819-20200820_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200819-20200821_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200821-20200824_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200823-20200824_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200824-20200825_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200824-20200827_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200827-20200828_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200828-20200831_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200831-20200901_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200901-20200903_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200902-20200904_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200904-20200904_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200904-20200906_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200906-20200907_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200907-20200908_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200908-20200909_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200909-20200910_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200910-20200910_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200910-20200911_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200911-20200912_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200912-20200915_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200915-20200917_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200917-20200918_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200918-20200919_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200918-20200921_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200921-20200922_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200922-20200923_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200922-20200924_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200924-20200925_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200925-20200928_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200928-20200929_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20200929-20201001_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201001-20201002_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201002-20201005_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201004-20201006_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201005-20201006_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201006-20201007_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201007-20201008_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201008-20201009_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201009-20201012_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201012-20201012_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201012-20201013_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201013-20201015_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201015-20201016_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201016-20201017_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201017-20201019_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201019-20201020_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201020-20201021_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201021-20201022_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201022-20201023_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201023-20201026_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201026-20201028_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201028-20201030_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201030-20201102_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201102-20201103_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201103-20201105_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201105-20201106_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201106-20201109_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201109-20201110_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201110-20201111_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201111-20201112_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201112-20201116_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201116-20201116_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201116-20201117_V02.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201116T141503-20201116T211457_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201117-20201117_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201117-20201118_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201118-20201119_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201119-20201119_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201119T082309-20201120T003115_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201119T210936-20201120T203021_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201120T114033-20201121T001727_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201120T205533-20201121T200152_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201121T115116-20201122T200310_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201122T104234-20201123T200428_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201123T122328-20201124T003646_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201123T211046-20201124T141946_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201124T061752-20201125T203646_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201125T104604-20201126T003128_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201125T211807-20201126T141728_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201126T062022-20201127T074252_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201127T041904-20201127T200946_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201127T130352-20201128T201111_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201128T114907-20201129T201207_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201129T105159-20201130T063837_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201130T031505-20201130T201153_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201130T115153-20201201T204123_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201201T115105-20201202T001637_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201201T205553-20201202T204108_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201202T110929-20201202T111623_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201202T115805-20201203T053141_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201202T211617-20201204T001141_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201203T204829-20201204T201117_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201204T114938-20201205T201118_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201205T131830-20201206T201124_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201206T104606-20201207T051648_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201207T015448-20201207T201138_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201207T120054-20201208T140718_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201208T064706-20201209T001142_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201208T204930-20201209T204130_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201209T104824-20201210T051648_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201209T213312-20201211T001154_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201210T204939-20201211T201224_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201211T114630-20201212T201249_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201212T114719-20201213T201319_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201213T105049-20201214T034707_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201214T002325-20201214T140507_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201214T065707-20201215T140455_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201215T095949-20201215T101649_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201215T104243-20201216T075643_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201215T213549-20201216T140449_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201216T081925-20201217T010149_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201216T210837-20201217T140455_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201217T071519-20201218T140455_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201218T071931-20201219T001650_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201218T205538-20201219T201744_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201219T110726-20201220T201840_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201220T110856-20201221T204926_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201221T110050-20201222T063226_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201221T210056-20201222T140708_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201222T105432-20201223T204650_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201223T105902-20201224T054550_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201223T204656-20201223T205144_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201223T210220-20201224T204711_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201224T105856-20201225T071632_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201224T204714-20201224T205311_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201224T205802-20201225T143902_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201225T103908-20201225T213233_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201225T143908-20201225T204933_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201225T210103-20201226T143941_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201225T213239-20201226T090411_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201226T091657-20201227T080457_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201226T143945-20201226T213451_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201226T213457-20201226T214003_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201226T214339-20201227T143951_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201227T094933-20201227T213715_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201227T143957-20201227T205711_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201227T210909-20201228T144027_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201227T210909-20201229T091015_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T095015-20201228T101657_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T101703-20201228T102157_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T102615-20201228T213941_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T144033-20201228T205239_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201228T210621-20201229T144109_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201229T092203-20201230T203209_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201229T144111-20201229T211341_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201230T110927-20201231T203351_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20201231T110809-20210101T111121_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210101T074827-20210101T212010_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210101T125833-20210102T203542_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210102T121452-20210103T203728_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210103T121428-20210104T114958_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210104T075510-20210104T203922_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210104T121346-20210105T204128_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210105T142334-20210106T183910_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210106T122622-20210107T115852_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210107T080643-20210107T200846_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210107T122104-20210108T120146_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210108T080552-20210108T204811_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210108T122934-20210109T205029_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210109T122411-20210110T205259_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210110T122943-20210111T121011_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210111T081859-20210111T205541_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210111T123029-20210112T205817_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210112T123229-20210113T131714_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210113T094723-20210115T060411_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210113T131717-20210113T181311_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210114T215117-20210115T141724_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210115T100647-20210118T075736_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210115T141730-20210115T210242_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210118T011130-20210118T213208_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210118T040830-20210119T100208_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210118T141850-20210119T141708_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210118T181338-20210119T213220_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210119T183938-20210120T062002_V01.bc'
                           '$KERNELS/ck/solo_ANC_soc-flown-att_20210119T215838-20210120T140238_V01.bc'

                           '$KERNELS/fk/solo_ANC_soc-sc-fk_V08.tf'
                           '$KERNELS/fk/solo_ANC_soc-ops-fk_V02.tf'
                           '$KERNELS/fk/solo_ANC_soc-sci-fk_V07.tf'
                           '$KERNELS/fk/earth_topo_050714.tf'
                           '$KERNELS/fk/estrack_v03.tf'

                           '$KERNELS/ik/solo_ANC_soc-epd-ik_V02.ti'
                           '$KERNELS/ik/solo_ANC_soc-eui-ik_V01.ti'
                           '$KERNELS/ik/solo_ANC_soc-metis-ik_V03.ti'
                           '$KERNELS/ik/solo_ANC_soc-phi-ik_V01.ti'
                           '$KERNELS/ik/solo_ANC_soc-solohi-ik_V01.ti'
                           '$KERNELS/ik/solo_ANC_soc-spice-ik_V02.ti'
                           '$KERNELS/ik/solo_ANC_soc-stix-ik_V02.ti'
                           '$KERNELS/ik/solo_ANC_soc-swa-ik_V03.ti'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/pck/pck00010.tpc'

                           '$KERNELS/pck/earth_070425_370426_predict.bpc'

                           '$KERNELS/sclk/solo_ANC_soc-sclk_20210119_V01.tsc'

                           '$KERNELS/spk/solo_ANC_soc-orbit_20200210-20301120_L004_V1_00062_V01.bsp'
                           '$KERNELS/spk/de421.bsp'
                           '$KERNELS/spk/earthstns_itrf93_050714.bsp'
                           '$KERNELS/spk/estrack_v03.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
--------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v106_20210120_002'

   \begintext


Contact Information
--------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           esa_spice@sciops.esa.int, marc.costa@esa.int,


End of MK file.