KPL/FK

Generic Frame Definitions Kernel for Heliocentric frames
========================================================================

   This frames kernel defines a number of generic Heliocentric frames,
   both dynamic and inertial that are currently not ''built'' in the 
   SPICE toolkit.
   

Version and Date
========================================================================

   Version 0.2 -- November 4, 2015 -- Jorge Diaz del Rio, ODC Space
   
      - Renamed EARTH_MECLD (EARTH_MECL_MEQX) and SUN_EARTH_EQU
        (SUN_EARTH_CEQU).
      
      - Updated the NAIF ID codes.

   Version 0.1 -- September 2, 2015 -- Jorge Diaz del Rio, ODC Space
   
      - Added SUN_ARIES_ECL and SUN_HCD.
      
      - Modified the format of the Frame Names and NAIF IDs section.

   Version 0.0 -- August 9, 2015 -- Jorge Diaz del Rio, ODC Space
   
      Initial version.

      
References
========================================================================

   1. "Frames Required Reading"
   
   2. "Kernel Pool Required Reading"
   
   3. Franz and Harper. (2002) "Heliospheric Coordinate Systems,"
      Space Science, 50, 217ff.

   4. Hapgood,M. (1992). "Space physics coordinate transformations:
      A user guide," Planetary and Space Science, 40, 711-717
      
   5. Archinal, B.A., A'Hearn, M.F., Bowell, E., Conrad, A.,
      Consolmagno, G.J., Courtin, R., Fukushima, T., 
      Hestroffer, D., Hilton, J.L., Krasinsky, G.A.,
      Neumann, G., Oberst, J., Seidelmann, P.K., Stooke, P.,
      Tholen, D.J., Thomas, P.C., and Williams, I.P. 
      "Report of the IAU Working Group on Cartographic Coordinates 
      and Rotational Elements: 2009."
   
   6. Thompson, W.T., "Coordinate systems for solar image 
      data," Astronomy & Astrophysics 449, 791-803 (2006)
      
   7. OMNIWeb - Description of Heliospheric Coordinate Systems:
      http://omniweb.gsfc.nasa.gov/coho/helios/plan_des.html

      
Contact Information
========================================================================

   TBD (NAIF contact details?)

   
Usage
========================================================================

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must 'load' the kernel, normally during
   program initialization. The SPICELIB routine FURNSH, the CSPICE
   function furnsh_c, the ICY function cspice_furnsh and the MICE 
   function cspice_furnsh load a kernel file into the kernel pool as 
   shown below.

      CALL FURNSH   ( 'frame_kernel_name' )
      furnsh_c      ( "frame_kernel_name" );
      cspice_furnsh,  'frame_kernel_name'
      cspice_furnsh ( 'frame_kernel_name' )

   This file was created and may be updated with a text editor or word
   processor.

   
Heliocentric Generic Frames NAIF names and ID Codes
========================================================================
 
   The following generic heliocentric frames defined in this kernel 
   file:

      SPICE Frame Name            Long-name
      --------------------------  --------------------------------------
      SUN_ARIES_ECL               Heliocentric Aries Ecliptic
      SUN_EARTH_CEQU              Heliocentric Earth Equatorial
      SUN_EARTH_ECL               Heliocentric Earth Ecliptic
      SUN_HCD                     Heliocentric of date
      SUN_INERTIAL                Heliocentric Inertial

      
   These frames have the following centers, frame class and NAIF
   IDs:
   
      SPICE Frame Name            Center     Class     NAIF ID
      --------------------------  --------   -------  ---------
      SUN_ARIES_ECL               SUN        DYNAMIC  1000010000
      SUN_EARTH_CEQU              SUN        DYNAMIC  1000010001
      SUN_EARTH_ECL               SUN        DYNAMIC  1000010002
      SUN_HCD                     SUN        DYNAMIC  1000010003
      SUN_INERTIAL                SUN        FIXED    1000010004


   These frames have the following common names and other designators
   in literature:
   
      SPICE Frame Name            Common names and other designators
      --------------------        --------------------------------------
      SUN_ARIES_ECL               HAE, Solar Ecliptic (SE)
      SUN_EARTH_CEQU              HEEQ, Stonyhurst Heliographic
      SUN_EARTH_ECL               HEE
      SUN_HCD                     Heliocentric of date (HCD)
      SUN_INERTIAL                HCI, Heliographic Inertial (HGI)


   The keywords implementing these frame definitions are located in the 
   section "Generic Dynamic Frames" and "Generic Inertial Frames."
               
      
General Notes About This File
========================================================================

   About Required Data:
   --------------------

   Most of the dynamic frames defined in this file require at least one
   of the following kernels to be loaded prior to their evaluation, 
   normally during program initialization:

     - Planetary ephemeris data (SPK), i.e. de403, de405, etc.
     - Planetary constants data (PCK), i.e. pck00010.tpc.
     - Earth generic frames definitions (FK), i.e. earth_v03.tf

   Note that loading different kernels will lead to different
   implementations of the same frame, providing different results from
   each other, in terms of state vectors referred to these frames.
 
 
   About Implementation:
   ---------------------
      
   The SPICE frames defined within this file and their corresponding 
   non-SPICE frames might not be equivalent, both due to variations in 
   the SPICE kernels on which the SPICE frame depends, and due to 
   possible differences in both the frame's definition and 
   implementation (e.g. GSE can be defined using the instantaneous 
   orbital plane or mean ecliptic; the mean ecliptic is a function of 
   the ecliptic model). Please refer to each applicable frame 
   description section for particular details on the current SPICE
   kernel implementation.
   
 
Generic Dynamic Frames
========================================================================

   This section contains the definition of the Generic Heliocentric 
   Dynamic Frames.


Heliocentric Aries Ecliptic of Date frame (SUN_ARIES_ECL)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Heliocentric Aries Ecliptic of Date 
   frame is referred as SUN_ARIES_ECL. In literature, this frame is 
   referred as HAE (from [4]), or Solar Ecliptic Coordinate System, 
   SE (from [7]).

   
   Definition:
   -----------
   The Heliocentric Aries Ecliptic frame is defined as follows
   (from [4]):
   
      -  +Z axis is aligned with the north-pointing vector normal to the
         mean orbital plane of the Earth;
         
      -  +X axis points toward the first point of Aries, i.e. along the 
         "mean equinox", which is defined as the intersection of the 
         Earth's mean orbital plane with the Earth's mean equatorial 
         plane. It is aligned with the cross product of the north-pointing 
         vectors normal to the Earth's mean equator and mean orbit plane 
         of date;
        
      -  +Y axis is the cross product of the Z and X axes and completes
         the right-handed frame;

      -  the origin of this frame is the Earth's center of mass.

   The mathematical model used to obtain the orientation of the Earth's 
   mean equator and equinox of date frame is the 1976 IAU precession model, 
   built into SPICE.

   The mathematical model used to obtain the mean orbital plane of the 
   Earth is the 1980 IAU obliquity model, also built into SPICE.

   The base frame for the 1976 IAU precession model is J2000.
   
   
   Required Data:
   --------------
   The usage of this frame does not require additional data since both 
   the precession and the obliquity models used to define this frame are 
   already built into SPICE.
   
   
   Remarks:
   --------
   This frame is (to first order) fixed with respect to the distant stars,
   and therefore inertial, nevertheless it is subject to slow change owing 
   to the various slow motions of the Earth's rotation axis with respect 
   to the fixed stars, and as such it is defined as 'ROTATING.' For details
   about implications of the rotation state definition, please refer to
   reference [1].
   
  \begindata

      FRAME_SUN_ARIES_ECL               =  1000010000   
      FRAME_1000010000_NAME             = 'SUN_ARIES_ECL'
      FRAME_1000010000_CLASS            =  5
      FRAME_1000010000_CLASS_ID         =  1000010000
      FRAME_1000010000_CENTER           =  10
      FRAME_1000010000_RELATIVE         = 'J2000'
      FRAME_1000010000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_1000010000_FAMILY           = 'MEAN_ECLIPTIC_AND_EQUINOX_OF_DATE'
      FRAME_1000010000_PREC_MODEL       = 'EARTH_IAU_1976'
      FRAME_1000010000_OBLIQ_MODEL      = 'EARTH_IAU_1980'
      FRAME_1000010000_ROTATION_STATE   = 'ROTATING'
 
  \begintext
          

Heliocentric earth equatorial frame (SUN_EARTH_CEQU)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE systems, the Heliocentric Earth Equatorial frame is
   referred as SUN_EARTH_CEQU. In literature, this frame is referred as
   HEEQ (from [3] and [4]), or Stonyhurst Heliographic Coordinates
   (from [6], chapter 2.1)


   Definition:
   -----------
   The Heliocentric Earth Equatorial frame is defined as follows (from 
   [3] and [4]):

      -  X-Y plane is the solar equator of date, therefore, the +Z axis 
         is the primary vector and it is aligned to the Sun's north pole
         of date;

      -  +X axis is defined by the intersection between the Sun 
         equatorial plane and the solar central meridian of date as seen
         from the Earth. The solar central meridian of date is defined 
         as the meridian of the Sun that is turned toward the Earth. 
         Therefore, +X axis is the component of the Sun-Earth vector 
         that is orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the Sun's center of mass.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the IAU_SUN
   frame, which is a PCK-based frame. Therefore a PCK file containing
   the orientation constants for the Sun has to be loaded before any
   evaluation of this frame.

   The secondary vector is defined as an 'observer-target position' 
   vector. Therefore, the ephemeris data required to compute the 
   Sun-Earth vector in J2000 frame have to be loaded before using this 
   frame.


   Remarks:
   --------
   This frame is defined based on the IAU_SUN frame, whose evaluation is
   based on the data included in the loaded PCK file: different
   orientation constants for the Sun's spin axis will lead to a different
   frame orientation at a given time.

   Since the secondary vector of this frame is defined as an
   'observer-target position' vector, the usage of different planetary
   ephemerides conduces to different implementations of this frame,
   but only when these data lead to different solar central meridians,
   i.e. the projection of the Sun-Earth vector on the Sun equatorial
   plane obtained from the different ephemerides has a non-zero angular
   separation.
   
   It is strongly recommended to indicate what data have been used in the 
   evaluation of this frame when referring to it, e.g. SUN_EARTH_CEQU using 
   IAU 2009 constants and de405 ephemerides.

   Note that the effect of using different SPK files is smaller, in 
   general, that using different Sun's spin axis constants. As an 
   example, the average difference in the position of the +X axis of 
   the frame, when using DE405 or DE403 ephemerides is about 14.3 
   micro-radians, with a maximum of 15.3 micro-radians.


  \begindata

      FRAME_SUN_EARTH_CEQU             =  1000010001
      FRAME_1000010001_NAME            = 'SUN_EARTH_CEQU'
      FRAME_1000010001_CLASS           =  5
      FRAME_1000010001_CLASS_ID        =  1000010001
      FRAME_1000010001_CENTER          =  10
      FRAME_1000010001_RELATIVE        = 'J2000'
      FRAME_1000010001_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_1000010001_FAMILY          = 'TWO-VECTOR'
      FRAME_1000010001_PRI_AXIS        = 'Z'
      FRAME_1000010001_PRI_VECTOR_DEF  = 'CONSTANT'
      FRAME_1000010001_PRI_FRAME       = 'IAU_SUN'
      FRAME_1000010001_PRI_SPEC        = 'RECTANGULAR'
      FRAME_1000010001_PRI_VECTOR      = ( 0, 0, 1 )
      FRAME_1000010001_SEC_AXIS        = 'X'
      FRAME_1000010001_SEC_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_1000010001_SEC_OBSERVER    = 'SUN'
      FRAME_1000010001_SEC_TARGET      = 'EARTH'
      FRAME_1000010001_SEC_ABCORR      = 'NONE'

  \begintext

   
Heliocentric Earth Ecliptic frame (SUN_EARTH_ECL)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Heliocentric Earth Ecliptic frame is
   referred as SUN_EARTH_ECL. In literature, this frame is referred as
   HEE (from [3]).


   Definition:
   -----------
   The Heliocentric Earth Ecliptic frame is defined as follows 
   (from [3]):

      -  X-Y plane is defined by the Earth Mean Ecliptic plane of date,
         therefore, the +Z axis is the primary vector,and it defined as
         the normal vector to the Ecliptic plane that points toward the
         north pole of date;

      -  +X axis is the component of the Sun-Earth vector that is
         orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the Sun's center of mass.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the Earth mean
   ecliptic and equinox of date (EARTH_MECL_MEQX) frame and therefore
   the definition of this frame have to be loaded before using this
   frame.

   The secondary vector is defined as an 'observer-target position' 
   vector, therefore, the ephemeris data required to compute the 
   Sun-Earth vector in J2000 frame have to be loaded prior to using 
   this frame.


   Remarks:
   --------
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.
      
      If F2 is not dynamic but its evaluation requires evaluation of a 
      dynamic frame F3, the same restrictions apply to F3.

   Therefore, no other dynamic frame should make reference to this
   frame.
   
   Since the secondary vector of this frame is defined as an
   'observer-target position' vector, the usage of different planetary
   ephemerides leads to different implementations of this frame,
   but only when these data lead to different projections of the
   Sun-Earth vector on the Earth Ecliptic plane of date.
   
   It is strongly recommended to indicate what data have been used in the 
   evaluation of this frame when referring to it, e.g. SUN_EARTH_ECL using 
   de405 ephemerides.

   As an example, note that the average difference in position of the 
   +X axis of this frame, when using de405 vs. de403 ephemerides, is 
   about 14.3 micro-radians, with a maximum of 15.0 micro-radians.


  \begindata

      FRAME_SUN_EARTH_ECL              =  1000010002
      FRAME_1000010002_NAME            = 'SUN_EARTH_ECL' 
      FRAME_1000010002_CLASS           =  5
      FRAME_1000010002_CLASS_ID        =  1000010002
      FRAME_1000010002_CENTER          =  10
      FRAME_1000010002_RELATIVE        = 'J2000'
      FRAME_1000010002_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_1000010002_FAMILY          = 'TWO-VECTOR'
      FRAME_1000010002_PRI_AXIS        = 'Z'
      FRAME_1000010002_PRI_VECTOR_DEF  = 'CONSTANT'
      FRAME_1000010002_PRI_FRAME       = 'EARTH_MECL_MEQX'
      FRAME_1000010002_PRI_SPEC        = 'RECTANGULAR'
      FRAME_1000010002_PRI_VECTOR      = ( 0, 0, 1 )
      FRAME_1000010002_SEC_AXIS        = 'X'
      FRAME_1000010002_SEC_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_1000010002_SEC_OBSERVER    = 'SUN'
      FRAME_1000010002_SEC_TARGET      = 'EARTH'
      FRAME_1000010002_SEC_ABCORR      = 'NONE'

  \begintext


Heliocentric of date frame (SUN_HCD)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Heliocentric of date frame is referred
   as SUN_HCD. In literature, this frame is referred as HCD (from [3]).
   
   
   Definition:
   -----------
   The heliocentric of date frame is defined as follows (from [3]):
   
      -  X-Y plane is defined by the Sun's equator of date: the +Z
         axis, primary vector, is parallel to the Sun's rotation
         axis of date, pointing toward the Sun's north pole;
         
      -  +X axis is defined by the ascending node of the Sun's
         equatorial plane on the ecliptic of date;
         
      -  +Y completes the right-handed frame;
      
      -  the origin of this frame is the Sun's centre of mass.
      
   
   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the IAU_SUN
   frame, which is a PCK-based frame. Therefore a PCK file containing
   the orientation constants for the Sun has to be loaded before any
   evaluation of this frame.
   
   The secondary vector is defined as a constant vector in the Earth
   mean ecliptic and equinox of date (EARTH_MECL_MEQX) frame and 
   therefore the definition of this frame have to be loaded before 
   using this frame.
   
   
   Remarks:
   --------
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.
      
      If F2 is not dynamic but its evaluation requires evaluation of a 
      dynamic frame F3, the same restrictions apply to F3.

   Therefore, no other dynamic frame should make reference to this
   frame.
   
   The primary vector of this frame is defined based on the IAU_SUN 
   frame, whose evaluation is based on the data included in the loaded 
   PCK file: different orientation constants for the Sun's spin axis 
   will lead to a different frame orientation at a given time. 
   
   It is strongly recommended to indicate what data have been used in the 
   evaluation of this frame when referring to it, e.g. SUN_HCD using 
   IAU 2009 constants.
   
  \begindata
   
      FRAME_SUN_HCD                    =  1000010003
      FRAME_1000010003_NAME            = 'SUN_HCD' 
      FRAME_1000010003_CLASS           =  5
      FRAME_1000010003_CLASS_ID        =  1000010003
      FRAME_1000010003_CENTER          =  10
      FRAME_1000010003_RELATIVE        = 'J2000'
      FRAME_1000010003_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_1000010003_FAMILY          = 'TWO-VECTOR'
      FRAME_1000010003_PRI_AXIS        = 'Z'
      FRAME_1000010003_PRI_VECTOR_DEF  = 'CONSTANT'
      FRAME_1000010003_PRI_FRAME       = 'IAU_SUN'
      FRAME_1000010003_PRI_SPEC        = 'RECTANGULAR'
      FRAME_1000010003_PRI_VECTOR      = ( 0, 0, 1 )
      FRAME_1000010003_SEC_AXIS        = 'Y'
      FRAME_1000010003_SEC_VECTOR_DEF  = 'CONSTANT'
      FRAME_1000010003_SEC_FRAME       = 'EARTH_MECL_MEQX'
      FRAME_1000010003_SEC_SPEC        = 'RECTANGULAR'
      FRAME_1000010003_SEC_VECTOR      = ( 0, 0, 1 )   
 
  \begintext    


Generic Inertial Frames
========================================================================

   This section contains the definitions of the generic Sun-centric 
   Inertial Frames that are currently not 'built-in' into the SPICE 
   toolkit.


Heliocentric Inertial frame (SUN_INERTIAL)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Heliocentric Inertial frame is
   referred as SUN_INERTIAL. In literature, this frame is referred as
   HCI (from [3]), or Heliographic Inertial, HGI (from [7]).


   Definition:
   -----------
   The Heliocentric Inertial Frame is defined as follows (from [3]):

    -  X-Y plane is defined by the Sun's equator of epoch J2000: the +Z
       axis, primary vector, is parallel to the Sun's rotation axis of
       epoch J2000, pointing toward the Sun's north pole;

    -  +X axis is defined by the ascending node of the Sun's equatorial
       plane on the ecliptic plane of J2000;

    -  +Y completes the right-handed frame;

    -  the origin of this frame is the Sun's center of mass.
    
    
   Remarks:
   --------
   Note that even when the original frame defined in [3] is referenced
   to the orientation of the Solar equator in J1900, the SUN_INERTIAL 
   frame is based on J2000 instead.

   It is possible to define this frame as a dynamic frame frozen at
   J2000 epoch, using the following set of keywords:

      FRAME_SUN_INERTIAL               =  1000010004
      FRAME_1000010004_NAME            = 'SUN_INERTIAL' 
      FRAME_1000010004_CLASS           =  5
      FRAME_1000010004_CLASS_ID        =  1000010004
      FRAME_1000010004_CENTER          =  10
      FRAME_1000010004_RELATIVE        = 'J2000'
      FRAME_1000010004_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_1000010004_FAMILY          = 'TWO-VECTOR'
      FRAME_1000010004_PRI_AXIS        = 'Z'
      FRAME_1000010004_PRI_VECTOR_DEF  = 'CONSTANT'
      FRAME_1000010004_PRI_FRAME       = 'IAU_SUN'
      FRAME_1000010004_PRI_SPEC        = 'RECTANGULAR'
      FRAME_1000010004_PRI_VECTOR      = ( 0, 0, 1 )
      FRAME_1000010004_SEC_AXIS        = 'Y'
      FRAME_1000010004_SEC_VECTOR_DEF  = 'CONSTANT'
      FRAME_1000010004_SEC_FRAME       = 'ECLIPJ2000'
      FRAME_1000010004_SEC_SPEC        = 'RECTANGULAR'
      FRAME_1000010004_SEC_VECTOR      = ( 0, 0, 1 )

   In the above implementation of this frame, the primary vector is
   defined as a constant vector in the IAU_SUN frame, which is a
   PCK-based frame, therefore a PCK file containing the orientation
   constants for the Sun has to be loaded before using this frame.

   Due to the fact that the transformation between the SUN_INERTIAL 
   frame and J2000 frame is fixed and time independent, the SUN_INERTIAL
   frame can be implemented as a fixed offset frame relative to the 
   J2000 frame. The rotation matrix provided in the definition was 
   computed using the following PXFORM call:

      CALL PXFORM( 'SUN_INERTIAL', 'J2000', 0.D0, MATRIX )

   using the implementation of the frame given above, and the following 
   PCK:

      pck00010.tpc

   which contains the following constants for the SUN from the 2009 IAU 
   report (from [5]):

      BODY10_POLE_RA         = (  286.13       0.          0. )
      BODY10_POLE_DEC        = (   63.87       0.          0. )

   This new implementation of the frame is preferred for computing 
   efficiency reasons.

  \begindata

      FRAME_SUN_INERTIAL               = 1000010004
      FRAME_1000010004_NAME            = 'SUN_INERTIAL'         
      FRAME_1000010004_CLASS           =  4
      FRAME_1000010004_CLASS_ID        =  1000010004
      FRAME_1000010004_CENTER          =  10 
      TKFRAME_1000010004_SPEC          = 'MATRIX'
      TKFRAME_1000010004_RELATIVE      = 'J2000'
      TKFRAME_1000010004_MATRIX        = (

         0.2458856764679510     0.8893142951159845    0.3855649343628876
        -0.9615455562494245     0.1735802308455697    0.2128380762847277
         0.1223534934723278    -0.4230720836476433    0.8977971010607901

                                     )

  \begintext



      





