KPL/FK


Generic Frame Definitions Kernel for Earth Planetary System
========================================================================

   This frames kernel defines a number of generic frames for the Earth
   Planetary System, i.e. Geocentric and Moon-centric generic dynamic 
   TK-based and CK-based frames that are currently not ''built'' in the
   SPICE toolkit.


Version and Date
========================================================================

   Version 0.3 -- November 4, 2015 -- Jorge Diaz del Rio, ODC Space
   
      Added EARTH_SUN_BSE implementing Russel's definition of GSE frame,
      and MOON_SUN_BSE for the equivalent on the Moon.
      
      EARTH_MECLD renamed to EARTH_MECL_MEQX; EARTH_MEQUD renamed to
      EARTH_MEQU_MEQX; EARTH_TEQUD to EARTH_TEQU_TEQX; EARTH_TEME to
      EARTH_TEQU_MEQX.
      
      ITRF93 frame changed to IAU_EARTH for Earth body-fixed frame to
      be used in the frame definitions.
      
      Corrected 'Remarks' section of EARTH_SWM and EARTH_SW frames.
      
      Renamed EARTH_MAG to EARTH_MAG_yyyy (common description, several
      epochs) and EARTH_MAGD to EARTH_MAG_CK (CK-based now).
      
      Changed definition of EARTH_SUN_BSM and EARTH_SUN_SM to use 
      intermediate frame EARTH_MAG_SWITCH.
      
      Renamed MOON_SE to MOON_EARTH_EQU and MOON_SL to MOON_EARTH_CEQU.
      
      Changed MOON_EARTH_EQU definition from dynamic to fixed frame.
   
   Version 0.2 -- September 11, 2015 -- Jorge Diaz del Rio, ODC Space
   
      Changed kernels names to lowercase.

   Verions 0.1 -- September 3, 2015 -- Jorge Diaz del Rio, ODC Space
   
      Updated based on NAIF comments.
      
      Added EARTH_SWM, EARTH_SW, EARTH_TEQUD, EARTH_TEMED, 
      MOON_EARTH_ORB, MOON_EARTH_EQU and MOON_EARTH_CEQU frames.

   Version 0.0 -- August 15, 2015 -- Jorge Diaz del Rio, ODC Space
   
      Initial version.


References
========================================================================

    1. "Frames Required Reading"
   
    2. "Kernel Pool Required Reading"
   
    3. Archinal, B.A., A'Hearn, M.F., Bowell, E., Conrad, A.,
       Consolmagno, G.J., Courtin, R., Fukushima, T., 
       Hestroffer, D., Hilton, J.L., Krasinsky, G.A.,
       Neumann, G., Oberst, J., Seidelmann, P.K., Stooke, P.,
       Tholen, D.J., Thomas, P.C., and Williams, I.P. 
       "Report of the IAU Working Group on Cartographic Coordinates 
       and Rotational Elements: 2009."
      
    4. Russell, C.T., "Geophysical Coordinate Transformations," Cosmic 
       Electrodynamics, 2, 184-196, 1971
      
    5. Franz and Harper. (2002) ``Heliospheric Coordinate Systems''
       Space Science, 50, 217ff.
      
    6. Bhavnani, K.H. and Vancour, R.P. (1991), "Coordinate Systems for
       Space and Geophysical Applications"
      
    7. Hapgood, M. and Thompson, W. "Heliophysics Integrated Observatory
       (HELIO) Coordinate Systems," v1.0, HELIO-UCL=N3-003-TN, 
       22-Mar-2010
      
    8. Vallado, D.A. and McClain, W.D., "Fundamentals of Astrondynamics
       and Applications," 2nd edition (2004), Space Technology Library
      
    9. Seago, J.H. and Vallado, D.A., "The Coordinate Frames of the US
       Space Object Catalogs," (2000), AIAA 2000-4025
 
   10. Seidelmann, P.K., "Explanatory Supplement to the Astronomical
       Almanac," (1992), University Science Books
       
   11. Harad, Y., "Interactions of Earth’s Magnetotail Plasma with the 
       Surface, Plasma, and Magnetic Anomalies of the Moon," (2015), 
       Springer
       
   12. Space Physics Archive Search and Extract (SPASE) data dictionary
       http://www.spase-group.org/docs/dictionary/spase-2_2_5-draft.pdf
   
   13. Tamburro, M.B., Abbott, A.S., and Townsend, G.E., "Guidance,
       flight mechanics and trajectory optimization. Volume 1 - 
       Coordinate systems and time measure," SID 65-1200-1
    
   14. NASA/Marshall Solar Physics: 
       http://solarscience.msfc.nasa.gov/SolarWind.shtml
       
   15. Kolaczek, B., "Selenocentric and Lunar topocentric coodinates
       of different spherical systems," SAO Special Report #286 (1968)
       
   16. ESA/ESTEC Space Environment Information System (SPENVIS)
       (2003). Web page:  "Dipole approximations of the geomagnetic 
       field."  <http://www.spenvis.oma.be/spenvis/help/background/
       magfield/cd.html>.
   
   17. Russell, C.T. and Luhmann, J.G. (1990). "Earth: Magnetic 
       Field and Magnetosphere." <http://www-ssc.igpp.ucla.
       edu/personnel/russell/papers/earth_mag>. Originally
       published in "Encyclopedia of Planetary Sciences," J.H.
       Shirley and R.W. Fainbridge, eds. Chapman and Hall,
       New York, pp 208-211.
   
   18. International Association of Geomagnetism and Aeronomy
       and International Union of Geodesy and Geophysics (2004).
       Web page:  "The 9th Generation International Geomagnetic
       Reference Field." <http://www.ngdc.noaa.gov/
       IAGA/vmod/igrf.html>.          
   
   
Contact Information
========================================================================

   TBD (NAIF contact details?)


Usage
========================================================================

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must 'load' the kernel, normally during
   program initialization. The SPICELIB routine FURNSH, the CSPICE
   function furnsh_c, the ICY function cspice_furnsh and the MICE 
   function cspice_furnsh load a kernel file into the kernel pool as 
   shown below.

      CALL FURNSH   ( 'frame_kernel_name' )
      furnsh_c      ( "frame_kernel_name" );
      cspice_furnsh,  'frame_kernel_name'
      cspice_furnsh ( 'frame_kernel_name' )

   This file was created and may be updated with a text editor or word
   processor.

  
Geocentric Generic Frames NAIF names and ID Codes
========================================================================
 
   The following generic frames for the Earth planetary system are
   defined in this kernel file:

      SPICE Frame Name   Long-name
      ----------------   -----------------------------------------------
      EARTH_MAG_1945     Geomagnetic of epoch 1945
      EARTH_MAG_1950     Geomagnetic of epoch 1950
      EARTH_MAG_1955     Geomagnetic of epoch 1955
      EARTH_MAG_1960     Geomagnetic of epoch 1960
      EARTH_MAG_1965     Geomagnetic of epoch 1965
      EARTH_MAG_1970     Geomagnetic of epoch 1970
      EARTH_MAG_1975     Geomagnetic of epoch 1975
      EARTH_MAG_1980     Geomagnetic of epoch 1980
      EARTH_MAG_1985     Geomagnetic of epoch 1985
      EARTH_MAG_1990     Geomagnetic of epoch 1990
      EARTH_MAG_1995     Geomagnetic of epoch 1995
      EARTH_MAG_2000     Geomagnetic of epoch 2000
      EARTH_MAG_2012     Geomagnetic of epoch 2012
      EARTH_MAG_CK       Geomagnetic of date
      EARTH_MECL_MEQX    Earth mean ecliptic and mean equinox of date
      EARTH_MEQU_MEQX    Earth mean equator and equinox of date
      EARTH_MOON_BCSF    Earth-centered Moon-following
      EARTH_SUN_BSE      Geocentric solar ecliptic of date (Russel)
      EARTH_SUN_BSM      Geocentric solar magnetospheric
      EARTH_SUN_ECL      Geocentric solar ecliptic of date (Hapgood)
      EARTH_SUN_EQU      Geocentric solar equatorial
      EARTH_SUN_SM       Solar Magnetic
      EARTH_SWM          Geocentric Solar Wind Magnetospheric
      EARTH_SW           Geocentric Solar Wind
      EARTH_TEQU_MEQX    Earth true equator and mean equinox of date      
      EARTH_TEQU_TEQX    Earth true equator and true equinox of date
      MOON_EARTH_CEQU    Selenocentric lunar equatorial
      MOON_EARTH_EQU     Selenocentric earth equatorial           
      MOON_EARTH_ORB     Selenocentric lunar orbital
      MOON_SUN_BSE       Selenocentric solar ecliptic (Russel)
      MOON_SUN_ECL       Selenocentric solar ecliptic (Hapgood)
      
            
   These frames have the following centers, frame class and NAIF
   IDs: 

      SPICE Frame Name      Center    Class     NAIF ID 
      --------------------  -------   -------  ---------
      EARTH_MAG_1945        EARTH     FIXED    300399998
      EARTH_MAG_1950        EARTH     FIXED    300399997
      EARTH_MAG_1955        EARTH     FIXED    300399996
      EARTH_MAG_1960        EARTH     FIXED    300399995
      EARTH_MAG_1965        EARTH     FIXED    300399994
      EARTH_MAG_1970        EARTH     FIXED    300399993
      EARTH_MAG_1975        EARTH     FIXED    300399992
      EARTH_MAG_1980        EARTH     FIXED    300399991
      EARTH_MAG_1985        EARTH     FIXED    300399990
      EARTH_MAG_1990        EARTH     FIXED    300399989
      EARTH_MAG_1995        EARTH     FIXED    300399988
      EARTH_MAG_2000        EARTH     FIXED    300399987
      EARTH_MAG_2012        EARTH     FIXED    300399986
      EARTH_MAG_CK          EARTH     CK       300399999

      EARTH_MECL_MEQX       EARTH     DYNAMIC  300399000
      EARTH_MEQU_MEQX       EARTH     DYNAMIC  300399001
      EARTH_MOON_BCSF       EARTH     DYNAMIC  300399002
      EARTH_SUN_BSE         EARTH     DYNAMIC  300399003
      EARTH_SUN_BSM         EARTH     DYNAMIC  300399004
      EARTH_SUN_ECL         EARTH     DYNAMIC  300399005
      EARTH_SUN_EQU         EARTH     DYNAMIC  300399006
      EARTH_SUN_SM          EARTH     DYNAMIC  300399007
      EARTH_SWM             EARTH     DYNAMIC  300399008
      EARTH_SW              EARTH     DYNAMIC  300399009
      EARTH_TEQU_MEQX       EARTH     DYNAMIC  300399010
      EARTH_TEQU_TEQX       EARTH     DYNAMIC  300399011
      
      MOON_EARTH_CEQU       MOON      DYNAMIC  300301000
      MOON_EARTH_EQU        MOON      FIXED    300301001
      MOON_EARTH_ORB        MOON      DYNAMIC  300301002
      MOON_SUN_BSE          MOON      DYNAMIC  300301003
      MOON_SUN_ECL          MOON      DYNAMIC  300301004


   These frames have the following common names and other designators
   in literature:
   
      SPICE Frame Name  Common names and other designators
      ----------------  ---------------------------------------------
      EARTH_MAG_1945    MAG; geomagnetic coordinate system of 1945
      EARTH_MAG_1950    MAG; geomagnetic coordinate system of 1950
      EARTH_MAG_1955    MAG; geomagnetic coordinate system of 1955
      EARTH_MAG_1960    MAG; geomagnetic coordinate system of 1960
      EARTH_MAG_1965    MAG; geomagnetic coordinate system of 1965
      EARTH_MAG_1970    MAG; geomagnetic coordinate system of 1970
      EARTH_MAG_1975    MAG; geomagnetic coordinate system of 1975
      EARTH_MAG_1980    MAG; geomagnetic coordinate system of 1980
      EARTH_MAG_1985    MAG; geomagnetic coordinate system of 1985
      EARTH_MAG_1990    MAG; geomagnetic coordinate system of 1990
      EARTH_MAG_1995    MAG; geomagnetic coordinate system of 1995
      EARTH_MAG_2000    MAG; geomagnetic coordinate system of 2000
      EARTH_MAG_2012    MAG; geomagnetic coordinate system of 2012
      EARTH_MAG_CK      MAG; geomagnetic of date
      EARTH_MECL_MEQX   Mean ecliptic of date  
      EARTH_MEQU_MEQX   EME; mean equinox of date (MOD); mean equator
                        and equinox of date; mean geocentric Earth 
                        equatorial (GEID); Geocentric equatorial
                        coordinate system (IJK); Geocentric equatorial
                        intertial system (GEI); Earth centered 
                        inertial (ECI); Conventional inertial system
                        (CIS);
      EARTH_MOON_BCSF
      EARTH_SUN_BSE     GSE
      EARTH_SUN_BSM     GSM
      EARTH_SUN_ECL     GSE
      EARTH_SUN_EQU     GSEQ
      EARTH_SUN_SM      SM, solar magnetic coordinates
      EARTH_SWM         SWM
      EARTH_SW          SW
      EARTH_TEQU_MEQX   TEME
      EARTH_TEQU_TEQX   True equinox of date (TOD); true equator and
                        equinox of date; true geocentric Earth 
                        equatorial (GEIT);
      MOON_EARTH_CEQU   SL
      MOON_EARTH_EQU    Selenocentric equatorial (SE)
      MOON_EARTH_ORB
      MOON_SUN_BSE      LSE/SSE, SSE_L 
      MOON_SUN_ECL      LSE/SSE, SSE_L
       
   The keywords implementing these frame definitions are located in the 
   "Dynamic Frames Definitions," "Text Kernel Frames Definitions" and 
   "CK-based Frames Definitions" sections.

      
General Notes About This File
========================================================================

   About Required Data:
   --------------------

   Most of the dynamic frames defined in this file require at least one
   of the following kernels to be loaded prior to their evaluation, 
   normally during program initialization:

     - Planetary ephemeris data (SPK), i.e. de403, de405, etc.
     - Planetary constants data (PCK), i.e. pck00010.tpc, etc.

   Note that loading different kernels will lead to different
   implementations of the same frame, providing different results from
   each other, in terms of state vectors referred to these frames.
 
 
   About Implementation:
   ---------------------
      
   The SPICE frames defined within this file and their corresponding 
   non-SPICE frames might not be equivalent, both due to variations in 
   the SPICE kernels on which the SPICE frame depends, and due to 
   possible differences in both the frame's definition and 
   implementation (e.g. GSE can be defined using the instantaneous 
   orbital plane or mean ecliptic; the mean ecliptic is a function of 
   the ecliptic model). Please refer to each applicable frame 
   description section for particular details on the current SPICE
   kernel implementation.
   

      
Dynamic Frames Definitions
========================================================================

   This section contains the definition of the Generic Geocentric 
   Dynamic Frames.
   

Earth Mean Ecliptic and Equinox of date frame (EARTH_MECL_MEQX)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Earth mean ecliptic and equinox of
   date frame is referred as EARTH_MECL_MEQX. In literature, this frame
   is referred as mean ecliptic of date (from [10])
   

   Definition:
   -----------
   The Earth mean ecliptic and equinox of date frame is defined as 
   follows (from [10]):

      -  +Z axis is aligned with the north-pointing vector normal to the
         mean orbital plane of the Earth;

      -  +X axis points along the ``mean equinox'', which is defined as
         the intersection of the Earth's mean orbital plane with the 
         Earth's mean equatorial plane. It is aligned with the cross 
         product of the north-pointing vectors normal to the Earth's 
         mean equator and mean orbit plane of date;

      -  +Y axis is the cross product of the Z and X axes and completes
         the right-handed frame;

      -  the origin of this frame is the Earth's center of mass.

   The mathematical model used to obtain the orientation of the Earth's 
   mean equator and equinox of date frame is the 1976 IAU precession model, 
   built into SPICE.

   The mathematical model used to obtain the mean orbital plane of the 
   Earth is the 1980 IAU obliquity model, also built into SPICE.

   The base frame for the 1976 IAU precession model is J2000.


   Required Data:
   --------------
   The usage of this frame does not require additional data since both 
   the precession and the obliquity models used to define this frame are 
   already built into SPICE.


   Remarks:
   --------
   None.


  \begindata

      FRAME_EARTH_MECL_MEQX            =  300399000   
      FRAME_300399000_NAME             = 'EARTH_MECL_MEQX'
      FRAME_300399000_CLASS            =  5
      FRAME_300399000_CLASS_ID         =  300399000
      FRAME_300399000_CENTER           =  399
      FRAME_300399000_RELATIVE         = 'J2000'
      FRAME_300399000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_300399000_FAMILY           = 'MEAN_ECLIPTIC_AND_EQUINOX_OF_DATE'
      FRAME_300399000_PREC_MODEL       = 'EARTH_IAU_1976'
      FRAME_300399000_OBLIQ_MODEL      = 'EARTH_IAU_1980'
      FRAME_300399000_ROTATION_STATE   = 'ROTATING'
 
  \begintext
   
   
   
Earth Mean Equator and Equinox of Date frame (EARTH_MEQU_MEQX)
------------------------------------------------------------------------
   
   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Earth mean equator and mean equinox of
   date frame is referred as EARTH_MEQU_MEQX. In literature, this frame 
   is referred as EME, mean geocentric earth equatorial (GEID) frame
   (from [5]); mean equator and equinox of date, mean equator of date 
   (MOD) frame, Geocentric equatorial coordinate system (IJK), Earth 
   centered inertial (ECI), or Conventional inertial system (CIS) 
   (from [8]); or Geocentric equatorial intertial system (GEI)
   (from [4]); 
   
   
   Definition:
   -----------
   The Earth mean equator and mean equinox of date frame is defined as 
   follows (from [8]):

      -  +Z axis is aligned with the north-pointing vector normal to
         the mean equatorial plane of the Earth;

      -  +X axis points along the ``mean equinox'', which is defined as 
         the intersection of the Earth's mean orbital plane with the 
         Earth's mean equatorial plane. It is aligned with the cross 
         product of the north-pointing vectors normal to the Earth's 
         mean equator and mean orbit plane of date;

      -  +Y axis is the cross product of the Z and X axes and completes
         the right-handed frame;

      -  the origin of this frame is the Earth's center of mass.

   The mathematical model used to obtain the orientation of the Earth's
   mean equator and mean equinox of date frame is the 1976 IAU 
   precession model, built into SPICE.

   The base frame for the 1976 IAU precession model is J2000.


   Required Data:
   --------------
   The usage of this frame does not require additional data since the
   precession model used to define this frame is already built into
   SPICE.


   Remarks:
   --------
   None.


  \begindata

      FRAME_EARTH_MEQU_MEQX           =  300399001
      FRAME_300399001_NAME            =  'EARTH_MEQU_MEQX'        
      FRAME_300399001_CLASS           =  5
      FRAME_300399001_CLASS_ID        =  300399001
      FRAME_300399001_CENTER          =  399
      FRAME_300399001_RELATIVE        = 'J2000'
      FRAME_300399001_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300399001_FAMILY          = 'MEAN_EQUATOR_AND_EQUINOX_OF_DATE'
      FRAME_300399001_PREC_MODEL      = 'EARTH_IAU_1976'
      FRAME_300399001_ROTATION_STATE  = 'ROTATING'        
 
  \begintext

  
  
Earth-centric Moon-following frame (EARTH_MOON_BCSF)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Earth-centric Moon-following 
   frame is referred as EARTH_MOON_BCSF.


   Definition:
   -----------
   The Earth-centric Moon-following frame is defined as follows:
            
	  -  X-Y plane is defined by the Earth's orbital plane of date:
		 the +Z axis, primary vector, is the normal vector to this plane,
		 always pointing toward the North side of the invariant plane;

	  -  +X axis is the component of the Earth-Moon vector 
	     that is orthogonal to the +Z axis;

	  -  +Y axis completes the right-handed system;

	  -  the origin of this frame is the Earth's center of mass.
	  
   All vectors are geometric: no corrections are used.


   Required Data:
   --------------

   The frame is defined as a two-vector frame using two different 
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the Earth mean
   ecliptic and mean equinox of date frame, and therefore the definition 
   of EARTH_MECL_MEQX has to be loaded before using this frame.

   The secondary vector is defined as an 'observer-target position' 
   vector. Therefore, the ephemeris data required to compute the 
   Earth-Moon vector in J2000 frame have to be loaded prior to using 
   this frame.
   
   
   Remarks:
   --------
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.

   Since the secondary vector of this frame is defined as an
   'observer-target position' vector, the usage of different planetary
   ephemerides for the Moon, Earth and Earth system barycenter may 
   lead to a different frame orientation at a given time, but only when
   these data lead to different projections of the Earth-Moon vector on 
   the Earth mean ecliptic plane of date.
   
   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g. 
   EARTH_MOON_BCSF using de405 ephemerides. 

   
  \begindata

      FRAME_EARTH_MOON_BCSF           = 300399002
      FRAME_300399002_NAME            = 'EARTH_MOON_BCSF'
      FRAME_300399002_CLASS           =  5
      FRAME_300399002_CLASS_ID        =  300399002
      FRAME_300399002_CENTER          =  399
      FRAME_300399002_RELATIVE        = 'J2000'
      FRAME_300399002_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300399002_FAMILY          = 'TWO-VECTOR'
      FRAME_300399002_PRI_AXIS        = 'Z'
      FRAME_300399002_PRI_VECTOR_DEF  = 'CONSTANT'
      FRAME_300399002_PRI_FRAME       = 'EARTH_MECL_MEQX'
      FRAME_300399002_PRI_SPEC        = 'RECTANGULAR'
      FRAME_300399002_PRI_VECTOR      = ( 0, 0, 1 )
      FRAME_300399002_SEC_AXIS        = 'X'
      FRAME_300399002_SEC_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_300399002_SEC_OBSERVER    = 'EARTH'
      FRAME_300399002_SEC_TARGET      = 'MOON'  
      FRAME_300399002_SEC_ABCORR      = 'NONE'

  \begintext
  
Geocentric solar ecliptic frame (EARTH_SUN_BSE)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the geocentric solar ecliptic frame
   is referred as EARTH_SUN_BSE. In literature, this frame is referred
   as GSE (from [4]).
               
               
   Definition:
   -----------
   The Geocentric Solar Ecliptic frame is defined as follows (from [4]):
   
      -  +X axis is the position of the Sun relative to the Earth; it's
         the primary vector and points from the Earth to the Sun;
         
      -  +Z axis is the component of the Ecliptic's north pole of date 
         orthogonal to the +X axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the Earth's center of mass.

   All the vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.
   
   The primary vector is defined as an 'observer-target position' 
   vector, therefore, the ephemeris data required to compute the 
   Earth-Sun vector in J2000 frame have to be loaded prior to using this 
   frame.

   The secondary vector is defined as a constant vector in the Earth mean
   ecliptic and mean equinox of date frame, and therefore the definition 
   of EARTH_MECL_MEQX has to be loaded before using this frame.


   Remarks:
   --------
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.

   Since the primary vector of this frame is defined as an
   'observer-target position' vector, the usage of different planetary
   ephemerides for the Moon, Earth system barycenter, the Sun and the
   Solar System barycenter may lead to a different frame orientation at 
   a given time.
   
   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g. 
   EARTH_SUN_BSE using de405 ephemerides.


  \begindata

      FRAME_EARTH_SUN_BSE             =  300399003
      FRAME_300399003_NAME            = 'EARTH_SUN_BSE' 
      FRAME_300399003_CLASS           =  5
      FRAME_300399003_CLASS_ID        =  300399003
      FRAME_300399003_CENTER          =  399
      FRAME_300399003_RELATIVE        = 'J2000'
      FRAME_300399003_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300399003_FAMILY          = 'TWO-VECTOR'
      FRAME_300399003_PRI_AXIS        = 'X'
      FRAME_300399003_PRI_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_300399003_PRI_OBSERVER    = 'EARTH'
      FRAME_300399003_PRI_TARGET      = 'SUN'  
      FRAME_300399003_PRI_ABCORR      = 'NONE'
      FRAME_300399003_SEC_AXIS        = 'Z'
      FRAME_300399003_SEC_VECTOR_DEF  = 'CONSTANT'
      FRAME_300399003_SEC_FRAME       = 'EARTH_MECL_MEQX'
      FRAME_300399003_SEC_SPEC        = 'RECTANGULAR'
      FRAME_300399003_SEC_VECTOR      = ( 0, 0, 1 )

  \begintext
  

  
Geocentric solar ecliptic of date frame (EARTH_SUN_ECL)                     
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the geocentric solar ecliptic of date frame 
   is referred as EARTH_SUN_ECL. In literature, this frame is referred
   as GSE (from [5]).
               
               
   Definition:
   -----------
   The Geocentric Solar Ecliptic frame of date is defined as follows 
   (from [5]):

      -  X-Y plane is defined by the Earth Mean Ecliptic plane of date:
         the +Z axis, primary vector, is the normal vector to this plane,
         always pointing toward the North side of the invariable plane;

      -  +X axis is the component of the Earth-Sun vector that is 
         orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the Earth's center of mass.

   All the vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the Earth mean
   ecliptic and mean equinox of date frame, and therefore the definition 
   of EARTH_MECL_MEQX has to be loaded before using this frame.

   The secondary vector is defined as an 'observer-target position' 
   vector, therefore, the ephemeris data required to compute the 
   Earth-Sun vector in J2000 frame have to be loaded prior to using this 
   frame.


   Remarks:
   --------
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.

   Since the secondary vector of this frame is defined as an
   'observer-target position' vector, the usage of different planetary
   ephemerides may lead to a different frame orientation at a given time,
   but only when these data lead to different projections of the
   Earth-Sun vector on the Earth mean ecliptic plane of date.
   
   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g. 
   EARTH_SUN_ECL using de405 ephemerides.

   As an example, note that the average difference in position of the +X
   axis of this frame, when using de405 vs. de403 ephemerides, is about
   14.3 micro-radians, with a maximum of 15.0 micro-radians.


  \begindata

      FRAME_EARTH_SUN_ECL             =  300399005
      FRAME_300399005_NAME            = 'EARTH_SUN_ECL' 
      FRAME_300399005_CLASS           =  5
      FRAME_300399005_CLASS_ID        =  300399005
      FRAME_300399005_CENTER          =  399
      FRAME_300399005_RELATIVE        = 'J2000'
      FRAME_300399005_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300399005_FAMILY          = 'TWO-VECTOR'
      FRAME_300399005_PRI_AXIS        = 'Z'
      FRAME_300399005_PRI_VECTOR_DEF  = 'CONSTANT'
      FRAME_300399005_PRI_FRAME       = 'EARTH_MECL_MEQX'
      FRAME_300399005_PRI_SPEC        = 'RECTANGULAR'
      FRAME_300399005_PRI_VECTOR      = ( 0, 0, 1 )
      FRAME_300399005_SEC_AXIS        = 'X'
      FRAME_300399005_SEC_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_300399005_SEC_OBSERVER    = 'EARTH'
      FRAME_300399005_SEC_TARGET      = 'SUN'  
      FRAME_300399005_SEC_ABCORR      = 'NONE'

  \begintext


Geocentric Solar Equatorial frame (EARTH_SUN_EQU)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Geocentric Solar Equatorial frame is
   referred as EARTH_SUN_EQU. In literature, this frame is referred as
   GSEQ (from [4]).
   

   Definition:
   -----------
   The Geocentric Solar Equatorial frame is defined as follows (from [4]):

      -  +X axis is the position of the Sun relative to the Earth; it's
         the primary vector and points from the Earth to the Sun;

      -  +Z axis is the component of the Sun's north pole of date 
         orthogonal to the +X axis;

      -  +Y axis completes the right-handed reference frame;

      -  the origin of this frame is the Earth's center of mass.

   All the vectors are geometric: no aberration corrections are used.
   

   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' vector.
   Therefore, the ephemeris data required to compute the Earth-Sun vector
   in J2000 frame have to be loaded before using this frame.

   The secondary vector is defined as a constant vector in the IAU_SUN
   frame, which is a PCK-based frame. Therefore a PCK file containing
   the orientation constants for the Sun has to be loaded before using
   this frame.


   Remarks:
   --------
   This frame is defined based on the IAU_SUN frame, whose evaluation is
   based on the data included in the loaded PCK file: different orientation
   constants for the Sun's spin axis will lead to different frames.

   Since the primary vector of this frame is defined as an 'observer-target
   position' vector, the usage of different planetary ephemerides
   may lead to a different frame orientation at a given time. As an example,
   the difference between using de405 or de403 ephemerides is, in average,
   approximately 10.9 micro-radians, with a maximum of 21.6 micro-radians.
   
   It is strongly recommended to indicate what data have been used in the
   evaluation of this frame when referring to it, i.e. EARTH_SUN_EQU using 
   IAU 2009 constants and de405 ephemerides.


  \begindata

      FRAME_EARTH_SUN_EQU             =  300399006
      FRAME_300399006_NAME            = 'EARTH_SUN_EQU'
      FRAME_300399006_CLASS           =  5
      FRAME_300399006_CLASS_ID        =  300399006
      FRAME_300399006_CENTER          =  399
      FRAME_300399006_RELATIVE        = 'J2000'
      FRAME_300399006_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300399006_FAMILY          = 'TWO-VECTOR'
      FRAME_300399006_PRI_AXIS        = 'X'
      FRAME_300399006_PRI_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_300399006_PRI_OBSERVER    = 'EARTH'
      FRAME_300399006_PRI_TARGET      = 'SUN'
      FRAME_300399006_PRI_ABCORR      = 'NONE'
      FRAME_300399006_SEC_AXIS        = 'Z'
      FRAME_300399006_SEC_VECTOR_DEF  = 'CONSTANT'
      FRAME_300399006_SEC_FRAME       = 'IAU_SUN'
      FRAME_300399006_SEC_SPEC        = 'RECTANGULAR'
      FRAME_300399006_SEC_VECTOR      = ( 0, 0, 1 )

  \begintext
  
  
Geocentric Solar Magnetospheric (EARTH_SUN_BSM)                             
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the geocentric solar magnetospheric 
   frame is referred as EARTH_SUN_BSM. In literature, this frame is 
   referred as GSM (from [4]).
   
   
   Definition:
   -----------
   The geocentric solar magnetospheric frame is defined as 
   follows (from [4]):

      -  +X axis is the position of the Sun relative to the Earth; it's
         the primary vector and points from the Earth to the Sun; 

      -  +Z axis is the component of the Earth north geomagnetic 
         centered dipole orthogonal to the +X axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is Earth's center of mass.

   All vectors are geometric: no corrections are used.
   
   
   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' vector,
   therefore, the ephemeris data required to compute the Earth-Sun vector
   in J2000 frame have to be loaded before using this frame.

   The secondary vector is defined as a constant vector in the 
   EARTH_MAG_SWITCH, which is an alias frame as base frame for the 
   definition of the Earth north geomagnetic centered dipole. The user
   can load through the kernel pool one of the FKs that provide the mapping
   of this alias to one of the available Geomagnetic of epoch or of date
   frames.
   
   Alternatively, this alias could be mapped to the EARTH_MAG_CK or any of 
   the geomagnetic of epoch frames by using the following keyword-value 
   assignments:
   
      TKFRAME_EARTH_MAG_SWITCH_RELATIVE = '<base_frame>'
      TKFRAME_EARTH_MAG_SWITCH_SPEC     = 'MATRIX'
      TKFRAME_EARTH_MAG_SWITCH_MATRIX   = ( 1   0   0
                                            0   1   0
                                            0   0   1 )
                                            
   with <base_frame> EARTH_MAG_CK, EARTH_MAG_2012 or any other of the
   Geomagnetic of epoch frames defined within this kernel. 
       
   
   Remarks:
   --------
   Since the primary vector of this frame is defined as an 'observer-target
   position' vector, the usage of different planetary ephemerides may
   lead to different orientations of this frame, but only when the angular
   separation between the vectors Earth-Sun obtained from the different
   planetary ephemerides is non negligible.
   
   The secondary vector of this frame is defined based on the 
   EARTH_MAG_SWITCH frame. Different assignments of this frame to an 
   existing geomagnetic of date or of epoch frame will lead to different
   orientations of the North geomagnetic centered dipole, and therefore
   to different projections of this vector on the frame's YZ plane,
   resulting on different orientations of this frame.
   
      
   \begindata

       FRAME_EARTH_SUN_BSM             = 300399004
       FRAME_300399004_NAME            = 'EARTH_SUN_BSM'
       FRAME_300399004_CLASS           = 5
       FRAME_300399004_CLASS_ID        = 300399004
       FRAME_300399004_CENTER          = 399
       FRAME_300399004_RELATIVE        = 'J2000'
       FRAME_300399004_DEF_STYLE       = 'PARAMETERIZED'
       FRAME_300399004_FAMILY          = 'TWO-VECTOR'
       FRAME_300399004_PRI_AXIS        = 'X'
       FRAME_300399004_PRI_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
       FRAME_300399004_PRI_OBSERVER    = 'EARTH'
       FRAME_300399004_PRI_TARGET      = 'SUN'
       FRAME_300399004_PRI_ABCORR      = 'NONE'
       FRAME_300399004_SEC_AXIS        = 'Z'
       FRAME_300399004_SEC_VECTOR_DEF  = 'CONSTANT'
       FRAME_300399004_SEC_FRAME       = 'EARTH_MAG_SWITCH'
       FRAME_300399004_SEC_SPEC        = 'RECTANGULAR'
       FRAME_300399004_SEC_VECTOR      = ( 0, 0, 1 )

   \begintext
   
   
Solar Magnetic (EARTH_SUN_SM)                                               
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Solar Magnetic frame is referred as 
   EARTH_SUN_SM. In literature, this frame is referred as Solar
   Magnetic Coordinates and its acronym is SM (from [4] and [5]).
   
   
   Definition:
   -----------
   The Solar Magnetic frame is defined as follows (from [4]):
   
      -  +Z axis is aligned with the Earth's north magnetic pole;

      -  +X axis is the component of the Earth-Sun vector that is
         orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is Earth's center of mass.

   All vectors are geometric: no corrections are used.
   
   
   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.
   
   The primary vector of this frame is defined as a constant vector in 
   the EARTH_MAG_SWITCH, which is an alias frame as base frame for the 
   definition of the Earth north geomagnetic centered dipole. The user
   can load through the kernel pool one of the FKs that provide the 
   mapping of this alias to one of the available Geomagnetic of epoch
   or of date frames.
   
   Alternatively, this alias could be mapped to the EARTH_MAG_CK or 
   any of the geomagnetic of epoch frames by using the following 
   keyword-value assignments:
   
      TKFRAME_EARTH_MAG_SWITCH_RELATIVE = '<base_frame>'
      TKFRAME_EARTH_MAG_SWITCH_SPEC     = 'MATRIX'
      TKFRAME_EARTH_MAG_SWITCH_MATRIX   = ( 1   0   0
                                            0   1   0
                                            0   0   1 )
                                            
   with <base_frame> EARTH_MAG_CK, EARTH_MAG_2012 or any other of the
   Geomagnetic of epoch frames defined within this kernel.

   The secondary vector is defined as an 'observer-target position' 
   vector, therefore, the ephemeris data required to compute the 
   Earth-Sun vector in J2000 frame have to be loaded before using this 
   frame.


   Remarks:
   --------
   The primary vector of this frame is defined based on the 
   EARTH_MAG_SWITCH frame. Different assignments of this frame to an 
   existing geomagnetic of date or of epoch frame will lead to different
   orientations of the North geomagnetic centered dipole, and therefore
   to different projections of this vector on the frame's YZ plane,
   resulting on different orientations of this frame.
        
   Since the secondary vector of this frame is defined as an 
   'observer-target position' vector, the usage of different planetary 
   ephemerides may lead to different orientations of this frame, but
   only when these data lead to different projections of the Earth-Sun 
   vector on the Earth geomagnetic equator.
   
  \begindata

       FRAME_EARTH_SUN_SM              = 300399007
       FRAME_300399007_NAME            = 'EARTH_SUN_SM'
       FRAME_300399007_CLASS           = 5
       FRAME_300399007_CLASS_ID        = 300399007
       FRAME_300399007_CENTER          = 399
       FRAME_300399007_RELATIVE        = 'J2000'
       FRAME_300399007_DEF_STYLE       = 'PARAMETERIZED'
       FRAME_300399007_FAMILY          = 'TWO-VECTOR'
       FRAME_300399007_PRI_AXIS        = 'Z'
       FRAME_300399007_PRI_VECTOR_DEF  = 'CONSTANT'
       FRAME_300399007_PRI_FRAME       = 'EARTH_MAG_SWITCH'
       FRAME_300399007_PRI_SPEC        = 'RECTANGULAR'
       FRAME_300399007_PRI_VECTOR      = ( 0, 0, 1 )       
       FRAME_300399007_SEC_AXIS        = 'X'
       FRAME_300399007_SEC_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
       FRAME_300399007_SEC_OBSERVER    = 'EARTH'
       FRAME_300399007_SEC_TARGET      = 'SUN'
       FRAME_300399007_SEC_ABCORR      = 'NONE'

   \begintext


Earth true equator and equinox of date (EARTH_TEQU_TEQX)                    
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Earth true equator and equinox of date 
   is referred as EARTH_TEQU_TEQX. In literature, this frame is 
   referred as true equator and true equinox of date, true geocentric 
   Earth equatorial (GEIT) frame (from [5]); or true (equinox) of date 
   (TOD) frame (from [8] and [9]).
   
   
   Definition:
   -----------  
   The Earth true equator and equinox of date frame is defined as 
   follows (from [8]):

      -  +Z axis is aligned with the north-pointing vector normal to
         the true equatorial plane of the Earth, i.e. after applying
         precession and nutation effects to obtain the true direction
         of the Earth's rotational axis (from [9]);

      -  +X axis points along the ``true equinox'', which is defined as 
         the intersection of the Earth's mean orbital plane with the 
         Earth's true equatorial plane. It is aligned with the cross 
         product of the north-pointing vectors normal to the Earth's 
         true equator and mean orbit plane of date;

      -  +Y axis is the cross product of the Z and X axes and completes
         the right-handed frame;

      -  the origin of this frame is the Earth's center of mass.

   The mathematical models used to obtain the orientation of the Earth's 
   true equator and equinox of date frame are the 1976 IAU precession 
   model and the 1980 IAU nutation model, built into SPICE.

   The base frame for both the 1976 IAU precession model and the
   1980 nutation model is J2000.
   
   
   Required Data:
   --------------
   The usage of this frame does not require additional data since both
   the precession and nutation models used to define this frame is 
   already built into SPICE.
   
   
   Remarks:
   --------
   The true equator and equinox of date frame may be viewed as a 
   refinement of mean equator and equinox of date frame. The term 
   ``true equator'' indicates that orientation of a body's equatorial 
   plane is modeled accounting for precession and nutation.
   

  \begindata

      FRAME_EARTH_TEQU_TEQX           =  300399011
      FRAME_300399011_NAME            =  'EARTH_TEQU_TEQX'        
      FRAME_300399011_CLASS           =  5
      FRAME_300399011_CLASS_ID        =  300399011
      FRAME_300399011_CENTER          =  399
      FRAME_300399011_RELATIVE        = 'J2000'
      FRAME_300399011_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300399011_FAMILY          = 'TRUE_EQUATOR_AND_EQUINOX_OF_DATE'
      FRAME_300399011_PREC_MODEL      = 'EARTH_IAU_1976'
      FRAME_300399011_NUT_MODEL       = 'EARTH_IAU_1980'
      FRAME_300399011_ROTATION_STATE  = 'ROTATING'        
 
  \begintext
  


Earth true equator and mean equinox of date (EARTH_TEQU_MEQX)               
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Earth true equator and mean equinox of 
   date is referred as EARTH_TEQU_MEQX. In literature, this frame is 
   referred as true equator and mean equinox of date (TEME), or uniform 
   equinox of date (UOD) frame (from [9]).
   
   
   Definition:
   -----------
   The Earth true equator and mean equinox of date frame is defined as 
   follows (from [9]):
   
      -  +Z axis is aligned with the north-pointing vector normal to
         the true equatorial plane of the Earth, i.e. after applying
         precession and nutation effects to obtain the true direction
         of the Earth's rotational axis;
         
      -  +X axis is the projection of the mean equinox of date onto the
         true equator of date, i.e. +X axis is the component of the mean
         equinox of date orthogonal to the +Z-axis;
         
      -  +Y axis is the cross product of the Z and X axes and completes
         the right-handed frame;

      -  the origin of this frame is the Earth's center of mass.
      
   All vectors are geometric: no corrections are used.

   
   Required Data:
   --------------
   This frame is defined as a two-vector frame using rectangular
   coordinates in the Earth true equator and equinox of date and
   Earth mean equator and equinox of date frames for the
   specifications of the primary and secondary vectors.

   Therefore, the definitions of both the Earth true equator and
   equinox of date and the Earth mean equator and equinox of date
   frame have to be loaded before using this frame.


   Remarks:
   --------
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.

   
  \begindata

      FRAME_EARTH_TEQU_MEQX           =  300399010
      FRAME_300399010_NAME            = 'EARTH_TEQU_MEQX'
      FRAME_300399010_CLASS           =  5
      FRAME_300399010_CLASS_ID        =  300399010
      FRAME_300399010_CENTER          =  399
      FRAME_300399010_RELATIVE        = 'J2000'
      FRAME_300399010_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300399010_FAMILY          = 'TWO-VECTOR'
      FRAME_300399010_PRI_AXIS        = 'Z'
      FRAME_300399010_PRI_VECTOR_DEF  = 'CONSTANT'
      FRAME_300399010_PRI_FRAME       = 'EARTH_TEQU_TEQX'
      FRAME_300399010_PRI_SPEC        = 'RECTANGULAR'
      FRAME_300399010_PRI_VECTOR      = ( 0, 0, 1 )
      FRAME_300399010_SEC_AXIS        = 'X'
      FRAME_300399010_SEC_VECTOR_DEF  = 'CONSTANT'
      FRAME_300399010_SEC_FRAME       = 'EARTH_MEQU_MEQX'
      FRAME_300399010_SEC_SPEC        = 'RECTANGULAR'
      FRAME_300399010_SEC_VECTOR      = ( 1, 0, 0 )

  \begintext   

  
Selenocentric lunar orbital frame (MOON_EARTH_ORB)
------------------------------------------------------------------------
   
   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the selenocentric lunar orbital frame is
   referred as MOON_EARTH_ORB.
 
   
   Definition:
   -----------
   The selenocentric lunar orbital frame is defined as follows:

      -  The position of the Moon relative to the Earth is the primary 
         vector: +X axis points from Moon to the Earth;

      -  The inertially referenced velocity of the Earth relative to 
         the Moon is the secondary vector: +Y axis is the component of 
         this velocity vector orthogonal to the +X axis;

      -  +Z axis completes the right-handed system;

      -  the origin of this frame is the Moon's center of mass.

   All vectors are geometric: no corrections are used.


   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' 
   vector. Therefore, the ephemeris data required to compute the 
   Moon-Earth vector in J2000 frame have to be loaded before using this
   frame.

   The secondary vector is defined as an 'observer-target velocity' 
   vector. Therefore, the ephemeris data required to compute the 
   Moon-Earth velocity vector in the J2000 frame have to be loaded 
   before using this frame.


   Remarks:
   --------
   This frame is defined based on SPK data: different planetary 
   ephemerides (DE families) for Moon, the Earth, the Earth System
   barycenter and the Solar System barycenter will lead to 
   different frame orientations of this frame at a given time. 


  \begindata

      FRAME_MOON_EARTH_ORB            =  300301002
      FRAME_300301002_NAME            = 'MOON_EARTH_ORB' 
      FRAME_300301002_CLASS           =  5
      FRAME_300301002_CLASS_ID        =  300301002
      FRAME_300301002_CENTER          =  301
      FRAME_300301002_RELATIVE        = 'J2000'
      FRAME_300301002_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300301002_FAMILY          = 'TWO-VECTOR'
      FRAME_300301002_PRI_AXIS        = 'X'
      FRAME_300301002_PRI_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_300301002_PRI_OBSERVER    = 'MOON'
      FRAME_300301002_PRI_TARGET      = 'EARTH'
      FRAME_300301002_PRI_ABCORR      = 'NONE'
      FRAME_300301002_SEC_AXIS        = 'Y'
      FRAME_300301002_SEC_VECTOR_DEF  = 'OBSERVER_TARGET_VELOCITY'
      FRAME_300301002_SEC_OBSERVER    = 'MOON'
      FRAME_300301002_SEC_TARGET      = 'EARTH'
      FRAME_300301002_SEC_ABCORR      = 'NONE'
      FRAME_300301002_SEC_FRAME       = 'J2000'

  \begintext
   
   

Selenocentric lunar equatorial frame (MOON_EARTH_CEQU)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the selenocentric lunar equatorial frame is
   referred as MOON_EARTH_CEQU. In literature, this frame is referred as 
   SL (from [13]).


   Definition:
   -----------
   The selenocentric lunar equatorial frame is defined as follows
   (from [13]):
   
      -  X-Y plane is defined by the Moon's equatorial plane: the +Z
         axis is aligned with the north-pointing vector normal to the
         moon's equatorial plane;
        
      -  +X axis is the intersection of Earth's equatorial meridian
         passing through the true vernal equinox of date and the Moon's
         equatorial plane;
         
      -  +Y axis completes the right-handed system;
      
      -  the origin of this frame is the Moon's centre of mass.
      
   All the vectors are geometric: no aberration corrections are used.
   
   
   Required Data:
   --------------
   This frame is defined as a two-vector frame using constant 
   rectangular coordinates in the Earth true equator and equinox of 
   date and IAU_MOON frames for the specifications of the primary and 
   secondary vectors.

   Therefore, the definition of the Earth true equator and equinox
   of date a frame has to be loaded before using this frame.
   
   In addition, the primary vector is defined as a constant vector
   in the IAU_MOON frame, which is a PCK-based frame. Therefore a 
   PCK file containing the orientation constants for the Moon has 
   to be loaded before using this frame.
   
   Remarks:
   --------
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.
   
   Since the primary vector of this frame is defined based on the 
   IAU_MOON frame, whose evaluation is based on the data included in 
   the loaded PCK file: different orientation constants for the Moon's
   spin axis will lead to different frame orientations at a given
   time. 
   
   It is strongly recommended to indicate what data have been used in the 
   evaluation of this frame when referring to it, e.g. MOON_EARTH_CEQU 
   using IAU 2009 constants.
      
   
  \begindata

      FRAME_MOON_EARTH_CEQU           =  300301000
      FRAME_300301000_NAME            = 'MOON_EARTH_CEQU'
      FRAME_300301000_CLASS           =  5
      FRAME_300301000_CLASS_ID        =  300301000
      FRAME_300301000_CENTER          =  301
      FRAME_300301000_RELATIVE        = 'J2000'
      FRAME_300301000_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300301000_FAMILY          = 'TWO-VECTOR'
      FRAME_300301000_PRI_AXIS        = 'Z'
      FRAME_300301000_PRI_VECTOR_DEF  = 'CONSTANT'
      FRAME_300301000_PRI_FRAME       = 'IAU_MOON'
      FRAME_300301000_PRI_SPEC        = 'RECTANGULAR'
      FRAME_300301000_PRI_VECTOR      = ( 0, 0, 1 )
      FRAME_300301000_SEC_AXIS        = 'X'
      FRAME_300301000_SEC_VECTOR_DEF  = 'CONSTANT'
      FRAME_300301000_SEC_FRAME       = 'EARTH_TEQU_TEQX'
      FRAME_300301000_SEC_SPEC        = 'RECTANGULAR'
      FRAME_300301000_SEC_VECTOR      = ( 1, 0, 0 )

  \begintext   



Selenocentric solar ecliptic frame (MOON_SUN_BSE)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the selenocentric solar ecliptic frame
   is referred as MOON_SUN_BSE. In literature, this frame is referred
   as LSE, SSE (from [11]), or SSE_L (from [12]).
               
               
   Definition:
   -----------
   The Selenocentric solar ecliptic frame is defined, based on Russel's
   definition (from [4]), as follows:
   
      -  +X axis is the position of the Sun relative to the Moon; it's
         the primary vector and points from the Moon to the Sun;
         
      -  +Z axis is the component of the Ecliptic's north pole of date 
         orthogonal to the +X axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the Moon's center of mass.

   All the vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.
   
   The primary vector is defined as an 'observer-target position' 
   vector. Therefore, the ephemeris data required to compute the 
   Moon-Sun vector in J2000 frame have to be loaded prior to using this 
   frame.

   The secondary vector is defined as a constant vector in the Earth mean
   ecliptic and mean equinox of date frame, and therefore the definition 
   of EARTH_MECL_MEQX has to be loaded before using this frame.


   Remarks:
   --------
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.

   Since the primary vector of this frame is defined as an
   'observer-target position' vector, the usage of different planetary
   ephemerides for the Moon, the Earth System barycenter, the Sun and
   the Solar System barycenter may lead to different frame orientations
   at a given time, but only when the difference in the position of the 
   Sun as seen from the Moon, computed using the different ephemerides 
   families, is not negligible.
   
   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g. 
   MOON_SUN_BSE using de405 ephemerides.


  \begindata

      FRAME_MOON_SUN_BSE              =  300301003
      FRAME_300301003_NAME            = 'MOON_SUN_BSE' 
      FRAME_300301003_CLASS           =  5
      FRAME_300301003_CLASS_ID        =  300301003
      FRAME_300301003_CENTER          =  301
      FRAME_300301003_RELATIVE        = 'J2000'
      FRAME_300301003_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300301003_FAMILY          = 'TWO-VECTOR'
      FRAME_300301003_PRI_AXIS        = 'X'
      FRAME_300301003_PRI_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_300301003_PRI_OBSERVER    = 'MOON'
      FRAME_300301003_PRI_TARGET      = 'SUN'  
      FRAME_300301003_PRI_ABCORR      = 'NONE'
      FRAME_300301003_SEC_AXIS        = 'Z'
      FRAME_300301003_SEC_VECTOR_DEF  = 'CONSTANT'
      FRAME_300301003_SEC_FRAME       = 'EARTH_MECL_MEQX'
      FRAME_300301003_SEC_SPEC        = 'RECTANGULAR'
      FRAME_300301003_SEC_VECTOR      = ( 0, 0, 1 )

  \begintext
   


Selenocentric solar ecliptic frame (MOON_SUN_ECL)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the selenocentric solar ecliptic frame is
   referred as MOON_SUN_ECL. In literature, this frame is referred as
   LSE, SSE (from [11]), or SSE_L (from [12]).


   Definition:
   -----------     
   The selenocentric solar ecliptic frame is defined as follows 
   (from [11]):
   
      -  X-Y plane is defined by the Earth Mean Ecliptic plane of date:
         the +Z axis, primary vector, is the normal vector to this 
         plane, always pointing toward the North side of the invariable 
         plane;

      -  +X axis is the component of the Moon-Sun vector that is 
         orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the Moon's center of mass.

   All the vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------
   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the 
   EARTH_MECL_MEQX frame and therefore, no additional data is required to
   compute this vector.

   The secondary vector is defined as an 'observer-target position' 
   vector. Therefore, the ephemeris data required to compute the Moon-Sun
   vector in J2000 frame have to be loaded prior to using this frame.


   Remarks:
   --------
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.

   Since the secondary vector of this frame is defined as an
   'observer-target position' vector, the usage of different planetary
   ephemerides for the Moon, Earth System barycenter, the Sun and the
   Solar System barycenter may lead to different orientations of this frame
   at a given time, but only when these data lead to different projections 
   of the Moon-Sun vector on the Earth Ecliptic plane of date.
   
   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g. 
   EARTH_SUN_ECL using de405 ephemerides.

  \begindata

      FRAME_MOON_SUN_ECL              = 300301004
      FRAME_300301004_NAME            = 'MOON_SUN_ECL'
      FRAME_300301004_CLASS           =  5
      FRAME_300301004_CLASS_ID        =  300301004
      FRAME_300301004_CENTER          =  301
      FRAME_300301004_RELATIVE        = 'J2000'
      FRAME_300301004_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_300301004_FAMILY          = 'TWO-VECTOR'
      FRAME_300301004_PRI_AXIS        = 'Z'
      FRAME_300301004_PRI_VECTOR_DEF  = 'CONSTANT'
      FRAME_300301004_PRI_FRAME       = 'EARTH_MECL_MEQX'
      FRAME_300301004_PRI_SPEC        = 'RECTANGULAR'
      FRAME_300301004_PRI_VECTOR      = ( 0, 0, 1 )
      FRAME_300301004_SEC_AXIS        = 'X'
      FRAME_300301004_SEC_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_300301004_SEC_OBSERVER    = 'MOON'
      FRAME_300301004_SEC_TARGET      = 'SUN'  
      FRAME_300301004_SEC_ABCORR      = 'NONE'

  \begintext


        
Text Kernel (TK) Frames Definitions
========================================================================

   This section contains the definitions of the Generic Geocentric 
   Text Kernel (TK - type 4) frames that are currently not 'built-in' 
   into the SPICE toolkit.


Geomagnetic of epoch frame (EARTH_MAG_yyyy)                                 
------------------------------------------------------------------------

   SPICE Frame Name and synonyms:
   ------------------------------
   Within the SPICE system, the Geomagnetic of epoch frame is referred 
   as EARTH_MAG_yyyy, where yyyy is the epoch at which the value of the
   north dipole location has been sampled. In literature, this frame is 
   referred as Geomagnetic coordinate system and its acronym is MAG 
   (from [4]).


   Definition:
   -----------
   The Geomagnetic of epoch frame is defined as follows (from [4]):

    -  +Z axis is parallel to the magnetic dipole axis of epoch and aligned with
       the North magnetic pole of epoch;

    -  +Y axis is perpendicular to the geographic poles such that if D 
       is the dipole position and S is the south pole Y=DxS;

    -  +X completes the right-handed frame;

    -  the origin of this frame is the Earth's center of mass.
    
    
   Remarks:
   --------
   The north dipole location is time-varying. Nevertheless, this frame is
   frozen at a given epoch. The values used for the Earth north 
   geomagnetic centered dipole vector at this epoch are taken from [16]
   and represent a discrete sampling of the north dipole location from 1945
   to 2000. The terms DGRF and IGRF refer to, respectively, "Definitive 
   Geomagnetic Reference Field" and "International Geomagnetic Reference
   Field."  See references [16], [17], and [18] for details.
   
   Coordinates are planetocentric. 

             Data source    Lat      Lon
             -----------   -----    ------
              DGRF 1945    78.47    291.47
              DGRF 1950    78.47    291.15
              DGRF 1955    78.46    290.84
              DGRF 1960    78.51    290.53
              DGRF 1965    78.53    290.15
              DGRF 1970    78.59    289.82
              DGRF 1975    78.69    289.53
              DGRF 1980    78.81    289.24 
              DGRF 1985    78.97    289.10
              DGRF 1990    79.13    288.89
              IGRF 1995    79.30    288.59
              IGRF 2000    79.54    288.43
   
   In addition, values given for epoch 2012 are taken from the data
   provided in pck00010.tpc in the the following keywords:
   
   
        BODY399_N_GEOMAG_CTR_DIPOLE_LON  =  ( 287.62 )
        BODY399_N_GEOMAG_CTR_DIPOLE_LAT  =  (  80.13 )
   
   
   The 3x3 transformation matrix M defined by the angles is

      M = [angle_1]   [angle_2]   [angle_3]
                   3           1           3
                   
   An initial rotation of -90 degrees is required in order to align
   the +Y axis of EARTH_MAG_yyy to the normal vector to the plane
   defined by the magnetic dipole position of epoch and the south
   pole of epoch;                

   Vectors are mapped from the IAU_EARTH base frame to the EARTH_MAG_yyyy
   frame via left multiplication by M. The relationship of these Euler 
   angles to lon and lat for the IAU_EARTH-to-EARTH_MAG_yyyy 
   transformation is as follows:

       angle_1 is      - 90.0  * (radians/degree)
       angle_2 is pi/2 - lat   * (radians/degree)
       angle_3 is pi/2 + lon   * (radians/degree)
       
   For the definition of EARTH_MAG_yyyy frame it is necessary to provide
   the *inverse* of the above transformation, therefore the angles for
   the definition are reversed and the signs negated:
   
       angle_1 is -pi/2 - lon   * (radians/degree)
       angle_2 is -pi/2 + lat   * (radians/degree)
       angle_3 is       + 90.0  * (radians/degree)
    
 

  \begindata

      FRAME_EARTH_MAG_1945        = 300399998
      FRAME_300399998_NAME        = 'EARTH_MAG_1945'         
      FRAME_300399998_CLASS       = 4
      FRAME_300399998_CLASS_ID    = 300399998
      FRAME_300399998_CENTER      = 399 
      TKFRAME_300399998_SPEC      = 'ANGLES'
      TKFRAME_300399998_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399998_ANGLES    = ( -21.47, -11.53,  90.0 )
      TKFRAME_300399998_AXES      = (      3,      2,     3 )
      TKFRAME_300399998_UNITS     = 'DEGREES'
      
      FRAME_EARTH_MAG_1950        = 300399997
      FRAME_300399997_NAME        = 'EARTH_MAG_1950'         
      FRAME_300399997_CLASS       = 4
      FRAME_300399997_CLASS_ID    = 300399997
      FRAME_300399997_CENTER      = 399 
      TKFRAME_300399997_SPEC      = 'ANGLES'
      TKFRAME_300399997_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399997_ANGLES    = ( -21.15, -11.53,  90.0 )
      TKFRAME_300399997_AXES      = (      3,      2,     3 )
      TKFRAME_300399997_UNITS     = 'DEGREES'

      FRAME_EARTH_MAG_1955        = 300399996
      FRAME_300399996_NAME        = 'EARTH_MAG_1955'         
      FRAME_300399996_CLASS       = 4
      FRAME_300399996_CLASS_ID    = 300399996
      FRAME_300399996_CENTER      = 399 
      TKFRAME_300399996_SPEC      = 'ANGLES'
      TKFRAME_300399996_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399996_ANGLES    = ( -20.84, -11.54,  90.0 )
      TKFRAME_300399996_AXES      = (      3,      2,     3 )
      TKFRAME_300399996_UNITS     = 'DEGREES'

      FRAME_EARTH_MAG_1960        = 300399995
      FRAME_300399995_NAME        = 'EARTH_MAG_1960'         
      FRAME_300399995_CLASS       = 4
      FRAME_300399995_CLASS_ID    = 300399995
      FRAME_300399995_CENTER      = 399 
      TKFRAME_300399995_SPEC      = 'ANGLES'
      TKFRAME_300399995_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399995_ANGLES    = ( -20.53, -11.49,  90.0 )
      TKFRAME_300399995_AXES      = (      3,      2,     3 )
      TKFRAME_300399995_UNITS     = 'DEGREES'
      
      FRAME_EARTH_MAG_1965        = 300399994
      FRAME_300399994_NAME        = 'EARTH_MAG_1965'         
      FRAME_300399994_CLASS       = 4
      FRAME_300399994_CLASS_ID    = 300399994
      FRAME_300399994_CENTER      = 399 
      TKFRAME_300399994_SPEC      = 'ANGLES'
      TKFRAME_300399994_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399994_ANGLES    = ( -20.15, -11.47,  90.0 )
      TKFRAME_300399994_AXES      = (      3,      2,     3 )
      TKFRAME_300399994_UNITS     = 'DEGREES'
      
      FRAME_EARTH_MAG_1970        = 300399993
      FRAME_300399993_NAME        = 'EARTH_MAG_1970'         
      FRAME_300399993_CLASS       = 4
      FRAME_300399993_CLASS_ID    = 300399993
      FRAME_300399993_CENTER      = 399 
      TKFRAME_300399993_SPEC      = 'ANGLES'
      TKFRAME_300399993_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399993_ANGLES    = ( -19.82, -11.41,  90.0 )
      TKFRAME_300399993_AXES      = (      3,      2,     3 )
      TKFRAME_300399993_UNITS     = 'DEGREES'
      
      FRAME_EARTH_MAG_1975        = 300399992
      FRAME_300399992_NAME        = 'EARTH_MAG_1975'         
      FRAME_300399992_CLASS       = 4
      FRAME_300399992_CLASS_ID    = 300399992
      FRAME_300399992_CENTER      = 399 
      TKFRAME_300399992_SPEC      = 'ANGLES'
      TKFRAME_300399992_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399992_ANGLES    = ( -19.53, -11.31,  90.0 )
      TKFRAME_300399992_AXES      = (      3,      2,     3 )
      TKFRAME_300399992_UNITS     = 'DEGREES'

      FRAME_EARTH_MAG_1980        = 300399991
      FRAME_300399991_NAME        = 'EARTH_MAG_1980'         
      FRAME_300399991_CLASS       = 4
      FRAME_300399991_CLASS_ID    = 300399991
      FRAME_300399991_CENTER      = 399 
      TKFRAME_300399991_SPEC      = 'ANGLES'
      TKFRAME_300399991_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399991_ANGLES    = ( -19.24, -11.19,  90.0 )
      TKFRAME_300399991_AXES      = (      3,      2,     3 )
      TKFRAME_300399991_UNITS     = 'DEGREES'
      
      FRAME_EARTH_MAG_1985        = 300399990
      FRAME_300399990_NAME        = 'EARTH_MAG_1985'         
      FRAME_300399990_CLASS       = 4
      FRAME_300399990_CLASS_ID    = 300399990
      FRAME_300399990_CENTER      = 399 
      TKFRAME_300399990_SPEC      = 'ANGLES'
      TKFRAME_300399990_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399990_ANGLES    = ( -19.10, -11.03,  90.0 )
      TKFRAME_300399990_AXES      = (      3,      2,     3 )
      TKFRAME_300399990_UNITS     = 'DEGREES'
      
      FRAME_EARTH_MAG_1990        = 300399989
      FRAME_300399989_NAME        = 'EARTH_MAG_1990'         
      FRAME_300399989_CLASS       = 4
      FRAME_300399989_CLASS_ID    = 300399989
      FRAME_300399989_CENTER      = 399 
      TKFRAME_300399989_SPEC      = 'ANGLES'
      TKFRAME_300399989_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399989_ANGLES    = ( -18.89, -10.87,  90.0 )
      TKFRAME_300399989_AXES      = (      3,      2,     3 )
      TKFRAME_300399989_UNITS     = 'DEGREES'
      
      FRAME_EARTH_MAG_1995        = 300399988
      FRAME_300399988_NAME        = 'EARTH_MAG_1995'         
      FRAME_300399988_CLASS       = 4
      FRAME_300399988_CLASS_ID    = 300399988
      FRAME_300399988_CENTER      = 399 
      TKFRAME_300399988_SPEC      = 'ANGLES'
      TKFRAME_300399988_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399988_ANGLES    = ( -18.59, -10.70,  90.0 )
      TKFRAME_300399988_AXES      = (      3,      2,     3 )
      TKFRAME_300399988_UNITS     = 'DEGREES'
      
      FRAME_EARTH_MAG_2000        = 300399987
      FRAME_300399987_NAME        = 'EARTH_MAG_2000'         
      FRAME_300399987_CLASS       = 4
      FRAME_300399987_CLASS_ID    = 300399987
      FRAME_300399987_CENTER      = 399 
      TKFRAME_300399987_SPEC      = 'ANGLES'
      TKFRAME_300399987_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399987_ANGLES    = ( -18.43, -10.46,  90.0 )
      TKFRAME_300399987_AXES      = (      3,      2,     3 )
      TKFRAME_300399987_UNITS     = 'DEGREES'
      
      FRAME_EARTH_MAG_2012        = 300399986
      FRAME_300399986_NAME        = 'EARTH_MAG_2012'         
      FRAME_300399986_CLASS       = 4
      FRAME_300399986_CLASS_ID    = 300399986
      FRAME_300399986_CENTER      = 399 
      TKFRAME_300399986_SPEC      = 'ANGLES'
      TKFRAME_300399986_RELATIVE  = 'IAU_EARTH'
      TKFRAME_300399986_ANGLES    = ( -17.62,  -9.87,  90.0 )
      TKFRAME_300399986_AXES      = (      3,      2,     3 )
      TKFRAME_300399986_UNITS     = 'DEGREES'

  \begintext


Geocentric Solar Wind Magnetospheric frame (EARTH_SWM)                      
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Geocentric Solar Wind Magnetospheric 
   frame is referred as EARTH_SWM. In literature, this frame 
   is referred as SWM (from [6]).
   
   
   Definition:
   -----------  
   The Geocentric solar wind magnetospheric frame is defined as follows
   (from [6], section 3.3.6):
   
      -  +X axis is aligned the solar wind direction. This axis is
         positive in the direction opposite to the solar wind;
         
      -  +Z axis is the component of the geomagnetic axis (magnetic
         dipole) orthogonal to the +X axis, positive towards magnetic
         north;
         
      -  +Y axis completes the right-handed system. It is perpendicular
         to the geomagnetic axis (magnetic dipole) and is positive
         towards dusk;
         
      -  the origin of this frame is the Earth's centre of mass.
   
   
   Uses and applications:
   ----------------------
   The geocentric solar wind magnetospheric frame is useful in 
   studying the effects of the solar wind on the magnetosphere (from
   [6], section 3.3.6).
   
   
   Remarks:
   --------
   A critical issue to consider in the definition of this 
   frame is aberration – the bow shock of the Earth is rotated in 
   the plane of the Earth's orbit by angle Vearth/Vsolar_wind, 
   where Vearth is the velocity of the Earth in its orbit and 
   Vsolar_wind is the solar wind speed. The sense of rotation is 
   such the bow shock lags its un-rotated location on the anti-sunward 
   side of the Earth. This is the +Y direction for geocentric solar 
   ecliptic frame (EARTH_SUN_ECL). Strictly speaking Vplanet should 
   be the component perpendicular to the solar wind. 
   
   Th solar wind streams off of the Sun in all directions at speeds 
   of about 400 km/s. Nevertheless, the solar wind is not uniform. 
   Although it is always directed away from the Sun, it changes speed 
   and carries with it magnetic clouds, interacting regions where high
   speed wind catches up with slow speed wind, and composition 
   variations. The solar wind speed can range from high (800 km/s) over
   coronal holes to low velocities (300 km/s) over streamers 
   (see [14]).
   
   For the Earth under normal solar wind conditions (v ~400 km/s) the 
   angle of aberration ranges from 4.34 degrees for Earth's maximum 
   orbital velocity to 4.18 degrees for Earth's minimum orbital
   velocity.
   
   By convention, the average velocity for Earth in its orbit and for
   the solar wind at the Earth, will be used in the definition
   of this frame, which is highly significant for determining 
   magnetopause and bow shock locations. This value is determined to
   be 4.2685 degrees. 
   
   Since the minimum aberration is of approximately 2.09 degrees
   (maximum solar wind and minimum Earth orbital velocities) and the
   maximum aberration is of approximately 5.79 degrees (minimum solar
   wind and maximum Earth orbital velocities), the error in the
   definition of the +X-axis direction is between -2.17 to 1.53 
   degrees.  
   
   
  \begindata

      FRAME_EARTH_SWM             = 300399008
      FRAME_300399008_NAME        = 'EARTH_SWM'
      FRAME_300399008_CLASS       = 4
      FRAME_300399008_CLASS_ID    = 300399008
      FRAME_300399008_CENTER      = 399
      TKFRAME_300399008_SPEC      = 'ANGLES'
      TKFRAME_300399008_RELATIVE  = 'EARTH_SUN_BSM'
      TKFRAME_300399008_ANGLES    = ( -4.2685,  0.0,  0.0 )
      TKFRAME_300399008_AXES      = (       3,    2,    3 )
      TKFRAME_300399008_UNITS     = 'DEGREES'

   \begintext
   
       
   
Geocentric Solar Wind frame (EARTH_SW)                                      
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the Geocentric Solar Wind frame 
   is referred as EARTH_SW. In literature, this frame is referred as 
   SWM (from [6]).
   
   
   Definition:
   -----------  
   The Geocentric solar wind frame is defined as follows (from [6], 
   section 3.3.7):
   
      -  +Z is perpendicular to the Ecliptic plane and is positive
         towards North;
         
      -  +X axis is the component of the solar wind direction vector
         that is orthogonal to the +Z-axis. This axis lies in the
         ecliptic plane and is positive in the direction opposite
         to the solar wind;
         
      -  +Y axis completes the right-handed system;
         
      -  the origin of this frame is the Earth's centre of mass.
   
   
   Uses and applications:
   ----------------------
   The geocentric solar wind frame is useful in analyzing the impact
   of solar wind on hemispheric events (from [6], section 3.3.7).
   
   
   Remarks:
   --------
   A critical issue to consider in the definition of this 
   frame is aberration – the bow shock of the Earth is rotated in 
   the plane of the Earth's orbit by angle Vearth/Vsolar_wind, 
   where Vearth is the velocity of the Earth in its orbit and 
   Vsolar_wind is the solar wind speed. The sense of rotation is 
   such the bow shock lags its un-rotated location on the anti-sunward 
   side of the Earth. This is the +Y direction for geocentric solar 
   ecliptic frame (EARTH_SUN_ECL). Strictly speaking Vplanet should 
   be the component perpendicular to the solar wind. 
   
   Th solar wind streams off of the Sun in all directions at speeds 
   of about 400 km/s. Nevertheless, the solar wind is not uniform. 
   Although it is always directed away from the Sun, it changes speed 
   and carries with it magnetic clouds, interacting regions where high
   speed wind catches up with slow speed wind, and composition 
   variations. The solar wind speed can range from high (800 km/s) over
   coronal holes to low velocities (300 km/s) over streamers 
   (see [14]).
   
   For the Earth under normal solar wind conditions (v ~400 km/s) the 
   angle of aberration ranges from 4.34 degrees for Earth's maximum 
   orbital velocity to 4.18 degrees for Earth's minimum orbital
   velocity.
   
   By convention, the average velocity for Earth in its orbit and for
   the solar wind at the Earth, will be used in the definition
   of this frame, which is highly significant for determining 
   magnetopause and bow shock locations. This value is determined to
   be 4.2685 degrees. 
   
   Since the minimum aberration is of approximately 2.09 degrees
   (maximum solar wind and minimum Earth orbital velocities) and the
   maximum aberration is of approximately 5.79 degrees (minimum solar
   wind and maximum Earth orbital velocities), the error in the
   definition of the +X-axis direction is between -2.17 to 1.53 
   degrees.
   
   This frame is defined relative to EARTH_SUN_ECL, whose evaluation
   requires evaluation of EARTH_MECL_MEQX. These frames are both 
   dynamic.
   
   SPICE imposes a constraint in the definition of dynamic frames 
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.
      
      If F2 is not dynamic but its evaluation requires evaluation of a 
      dynamic frame F3, the same restrictions apply to F3.

   Therefore, no other dynamic frame should make reference to this
   frame.  
   
   
  \begindata

      FRAME_EARTH_SW              =  300399009
      FRAME_300399009_NAME        = 'EARTH_SW'
      FRAME_300399009_CLASS       =  4
      FRAME_300399009_CLASS_ID    =  300399009
      FRAME_300399009_CENTER      =  399
      TKFRAME_300399009_SPEC      = 'ANGLES'
      TKFRAME_300399009_RELATIVE  = 'EARTH_SUN_ECL'
      TKFRAME_300399009_ANGLES    = ( -4.2685,  0.0,  0.0 )
      TKFRAME_300399009_AXES      = (       3,    2,    3 )
      TKFRAME_300399009_UNITS     = 'DEGREES'

   \begintext


Selenocentric earth equatorial frame (MOON_EARTH_EQU)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------
   Within the SPICE system, the selenocentric lunar equatorial frame is
   referred as MOON_EARTH_EQU. In literature, this frame is referred as 
   selenocentric equatorial (SE) frame (from [13]).


   Definition:
   -----------
   The selenocentric earth equatorial frame is defined as follows
   (from [13]):
   
      -  +Z axis is aligned with the north-pointing vector normal to
         the true equatorial plane of the Earth, i.e. after applying
         precession and nutation effects to obtain the true direction
         of the Earth's rotational axis;
         
      -  +X axis points along the ``true equinox'', which is defined as 
         the intersection of the Earth's mean orbital plane with the 
         Earth's true equatorial plane. It is aligned with the cross 
         product of the north-pointing vectors normal to the Earth's 
         true equator and mean orbit plane of date;

      -  +Y axis is the cross product of the Z and X axes and completes
         the right-handed frame;

      -  the origin of this frame is the Moon's center of mass.

   The mathematical models used to obtain the orientation of the Earth's 
   true equator and equinox of date frame are the 1976 IAU precession 
   model and the 1980 IAU nutation model, built into SPICE.

   The base frame for both the 1976 IAU precession model and the
   1980 nutation model is J2000.
   
   
   Remarks:
   --------
   The usage of this frame does not require additional data since both
   the precession and nutation models used to define this frame is 
   already built into SPICE.
   
   The evaluation of this frame requires the evaluation of the
   EARTH_TEQU_TEQX at given epoch. Nevertheless, since the origin of
   this frame is the Moon, the frame orientation adjusted for light time
   will be different than the Earth's true equator and true equinox of
   date to which this frame is mapped, since the frames' centers are
   different. For further details, please refer to [1].   

  \begindata

      FRAME_MOON_EARTH_EQU            =  300301001
      FRAME_300301001_NAME            = 'MOON_EARTH_EQU'        
      FRAME_300301001_CLASS           =  4
      FRAME_300301001_CLASS_ID        =  300301001
      FRAME_300301001_CENTER          =  301
      
      TKFRAME_300301001_RELATIVE      = 'EARTH_TEQU_TEQX'
      TKFRAME_300301001_SPEC          = 'MATRIX'
      TKFRAME_300301001_MATRIX        = ( 1   0   0
                                          0   1   0
                                          0   0   1 ) 
 
  \begintext
   

   
CK-based Frames Definitions
========================================================================

   This section contains the definitions of the Generic Geocentric 
   CK-based (CK - type 3) frames that are currently not 'built-in' 
   into the SPICE toolkit.
   

Geomagnetic of date frame (EARTH_MAG_CK)                                  
------------------------------------------------------------------------

   SPICE Frame Name and synonyms:
   ------------------------------
   Within the SPICE system, the Geomagnetic of date frame is referred 
   as EARTH_MAG_CK. In literature, this frame is referred as 
   Geomagnetic coordinate system and its acronym is MAG (from [4]).


   Definition:
   -----------
   The Geomagnetic of date frame is defined as follows (from [4]):

    -  +Z axis is parallel to the magnetic dipole axis of date and 
       aligned to the North magnetic pole of date;

    -  +Y axis is perpendicular to the geographic poles such that if D 
       is the dipole position and S is the south pole Y=DxS;

    -  +X completes the right-handed frame;

    -  the origin of this frame is the Earth's center of mass.
    
    
   Remarks:
   --------
   This frame is defined as a CK frame. Therefore, a C-kernel containing
   orientation data for the Geomagnetic of date frame must be loaded 
   prior to evaluating the orientation of this frame at a given epoch.
   
   CKs based on the current and past IGRF models are available for use 
   with this frame on the NAIF server. For further details, please refer 
   to the comment area of the different CK files.
   
   These C-kernels require an SCLK kernel for converting ephemeris time
   to the `ticks' used to represent time in the CK [1]. This artificial
   clock is provided within this frame's definition for convenience. 
   
   Since the International Geomagnetic Reference Field (IGRF) data 
   spans from 1900.0 to date, this SCLK provides mapping between the 
   artificial clock to Terrestrial Dynamical Time (TDT) from 
   1899 DEC 31 12:00:00 TDT. 
   
   
   \begindata

        FRAME_EARTH_MAG_CK              =  300399999
        FRAME_300399999_NAME            = 'EARTH_MAG_CK'
        FRAME_300399999_CLASS           =  3
        FRAME_300399999_CLASS_ID        =  300399999
        FRAME_300399999_CENTER          =  399

        CK_300399999_SCLK               = -300399999
        CK_300399999_SPK                =  399
        
        
        SCLK_KERNEL_ID                  = ( @2015-11-01 )
        SCLK_DATA_TYPE_300399999        = ( 1 )        
        SCLK01_TIME_SYSTEM_300399999    = ( 2 )
        SCLK01_N_FIELDS_300399999       = ( 1 )
        SCLK01_MODULI_300399999         = ( 1.0000000000000E+15 )
        SCLK01_OFFSETS_300399999        = ( 0 )
        SCLK01_OUTPUT_DELIM_300399999   = ( 2 )

        SCLK_PARTITION_START_300399999  = ( 0.0000000000000E+00 )
        SCLK_PARTITION_END_300399999    = ( 1.0000000000000E+15 )

        SCLK01_COEFFICIENTS_300399999   = (
        0.0000000000000E+00   -3.1557600000000E+09  1.0000000000000E+00 )

   \begintext