KPL/FK

Frame (FK) SPICE kernel file for SOLO-specific generic frames
==============================================================================

   This frames kernel defines a number of generic frames used by JUICE
   mission for Science opportunities identification, data analysis and
   scientific research. These frames are currently not ``built'' into
   the SPICE toolkit.
   
   These frames are sorted in two groups: those that are JUICE mission 
   specific and those that are Jupiter system generic. The first group
   contains the frames defined by and for the JUICE mission, while the
   second provides the frames that are commonly accepted by the scientific
   community for the Jupiter system and its satellites.
   
   The IAU body-fixed rotational frames for Jupiter, Callisto, Europa and
   Ganymede is an exception to this grouping, as they are provided in a
   separate PCK kernel file. 
   

Version and Date
------------------------------------------------------------------------------

   Version 0.0 -- February 5, 2016 -- Jorge Diaz del Rio, ODC Space
   
      Initial version.


References
------------------------------------------------------------------------------

   [1]   "Frames Required Reading"
   
   [2]   "Kernel Pool Required Reading"
   
   [3]   Kivelson, M., Russell, C., 1995. "Introduction to Space
         Physics." Cambridge Univ. Press, Cambridge,UK.

   [4]   http://stereo.sr.unh.edu/data/PLASTIC_Resources/
         stereo_coordinates.pdf

   [5]   Weiduo Hu, "Fundamental Spacecraft Dynamics and Control,"
         Wiley 2015

   [6]   Bentley, R.D., Hapgood, M. and Thompson, W.T., "Coordinate
         Systems," 22-Mar-2010, HELIO-UCL=N3-003-TN.
         http://www.helio-vo.eu/documents/public/
         HELIO_Coordinates_100322.pdf

   [7]   Franz and Harper. (2002) "Heliospheric Coordinate Systems,"
         Space Science, 50, 217ff.

   [8]   Burlaga, L. F., 1984. "MHD processes in the outer
         heliosphere." Space Sci. Rev. 39, 255-316.

   [9]   "Space Station Reference Coordinate Systems," Revision F,
         26-Oct-2001

   [10]  Li, H., "Geostationary Satellites Collocation," Springer, 2014

   [11]  Russell, C.T., "Geophysical Coordinate Transformations,"
         Cosmic Electrodynamics, 2, 184-196, 1971
         
   [12]  Bhavnani, K.H. and Vancour, R.P. (1991), "Coordinate Systems for
         Space and Geophysical Applications"
         
   [13]  NASA/Marshall Solar Physics: 
         http://solarscience.msfc.nasa.gov/SolarWind.shtml
         
   [14]  Seidelmann, P.K., Divine, N. "Evaluation of Jupiter longitudes in 
         System III (1965)", Geophysical Research Letters, Volume 4, 
         Issue 2, Pages 65-68, 1977

   [15]  Liu X., Sachse, M., Spahn, F., Schmidt J., "Dynamics and 
         distribution of Jovian dust ejected from the Galilean satellites",
         doi: 10.1002/2016JE004999, American Geophysical Union, 2016

   [16]  Connerney, J.E.P., Acuna, M.H., Ness N.F., Satoh, T.,  
         "New models of Jupiter's magnetic field constrained by the Io 
         flux tube footprint", Journal of Geophysical Research, Vol. 103, 
         No. A6, 929-939, 1998

   [17]  Bagenal F., Wilson, R.J., "Jupiter Coordinate Systems", 
         ASP - U of Colorado, 07/15/16
         http://lasp.colorado.edu/home/mop/missions/juno/coordinates/,
         accessed 21/07/16.

   [18]  "Report of the IAU/IAG/COSPAR Working Group on Cartographic
         Coordinates and Rotational Elements of the Planets and
         Satellites: 1994."

   [19]  Archinal, B.A., A'Hearn, M.F., Bowell, E., Conrad, A.,
         Consolmagno, G.J., Courtin, R., Fukushima, T., 
         Hestroffer, D., Hilton, J.L., Krasinsky, G.A.,
         Neumann, G., Oberst, J., Seidelmann, P.K., Stooke, P.,
         Tholen, D.J., Thomas, P.C., and Williams, I.P. 
         "Report of the IAU Working Group on Cartographic Coordinates 
         and Rotational Elements: 2009."

   [20]  Dessler, A. J., "Appendix B: Coordinate Systems," in Physics of
         the Jovian Magnetosphere, Cambridge Univ. Press, A. J. Dessler,
         Ed., 1983.

   [21]  JMAG Coordinate Systems, version 2.


Contact Information
------------------------------------------------------------------------------

   If you have any questions regarding this file contact SPICE support at
   ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           mcosta@sciops.esa.int, esa_spice@sciops.esa.int

   or NAIF at JPL:

           Boris Semenov
           (818) 354-8136
           Boris.Semenov@jpl.nasa.gov


Implementation Notes
------------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must "load" the kernel normally during 
   program initialization. Loading the kernel associates the data items 
   with their names in a data structure called the "kernel pool". The 
   routine that loads a kernel into the pool is shown below:

      FORTRAN: (SPICELIB)

         CALL FURNSH ( frame_kernel_name )

      C: (CSPICE)

         furnsh_c ( frame_kernel_name );

      IDL: (ICY)

         cspice_furnsh, frame_kernel_name

      MATLAB: (MICE)

         cspice_furnsh ( 'frame_kernel_name' )

   This file was created and may be updated with a text editor or word
   processor


SPICE Frame names and NAIF ID Codes
------------------------------------------------------------------------------
 
   The following generic frames are defined in this kernel file:

      SPICE Frame Name             Long-name
      --------------------------   ------------------------------------------

   JUICE mission specific generic frames(*):

      JUICE_JUPITER_IF_J2000       Jupiter Inertial Frame at J2000
      JUICE_JUPITER_MAG_S3RH1965   Jupiter Magnetic System III VIP4 model
                                   using IAU 1994 constants
      JUICE_JUPITER_MAG_S3RH2009   Jupiter Magnetic System III VIP4 model
                                   using IAU 2009 constants
  
      JUICE_JSEQ                  Jovian-centric Equatorial Solar
      JUICE_JUPITER_BSM            Jupiter Solar Magnetospheric
      JUICE_JUPITER_SJC            Solar Joviancentric Coordinates
      JUICE_JSM                    Jupiter Solar Magnetic
      JUICE_JSW                    Jupiter Solar Wind
      JUICE_JSWM                   Jupiter Solar Wind Magnetospheric
  
      JUICE_CALLISTO_PHI_ORB       Callisto-centered Phi-Zorb
      JUICE_EUROPA_PHI_ORB         Europa-centered Phi-Zorb
      JUICE_GANYMEDE_PHI_ORB       Ganymede-centered Phi-Zorb
  
      JUICE_HGRTN                  JUICE Heliocentric Radial-Tangential-Normal
      JUICE_SUN_RTN                Sun-orbit JUICE Radial-Tangential-Normal
      JUICE_JUPITER_DM             Jupiter JUICE Dipole Meridian
      JUICE_JUPITER_RTP            JUICE Jupiter R-Theta-Phi
  
   Jupiter system generic frames(**):
   
      JUPITER_SYSTEM3RH_1965       Jupiter System III Right-handed using the
                                   IAU 1994 constants
      JUPITER_SYSTEM3RH_2009       Jupiter System III Right-handed using the
                                   IAU 2009 constants
      JUPITER_MAG_VIP4             Jupiter Magnetic System III VIP4
  
      JUPITER_MEQUD                Jupiter Mean Equator of date
      JUPITER_SUN_EQU              Jupiter Solar Equatorial
      JUPITER_SUN_ORB              Jupiter Solar Orbital
        
      JUPITER_CALLISTO_BCSF        Jupiter-centric Callisto-following    
      JUPITER_EUROPA_BCSF          Jupiter-centric Europa-following      
      JUPITER_GANYMEDE_BCSF        Jupiter-centric Ganymede-following    
  
      CALLISTO_JUPITER_ORB         Callisto Orbital
      EUROPA_JUPITER_ORB           Europa Orbital
      GANYMEDE_JUPITER_ORB         Ganymede Orbital 


   (*)  The definition of the dipole direction of these frames needs to
        be discussed within the Science Operations Working Team Working
        Group 3 in coordination with Juno and Europa Multi Fly-by Mission.
        The name for JUICE_SUN_RTN also needs to be discussed.

   (**) These frames are commonly used by other missions for data analysis
        and scientific research. In the future NAIF may include them
        in their official generic frames kernel for the Jupiter system.
        When this happens the frames will be removed from this kernel.


   These frames have the following centers, frame class and NAIF
   IDs:
   
      SPICE Frame Name              Center      Class    NAIF ID
      --------------------------    ----------  -------  ----------
      JUICE_JUPITER_IF_J2000        JUPITER     FIXED        -28970
      JUICE_JUPITER_MAG_S3RH1965    JUPITER     FIXED        -28971
      JUICE_JUPITER_MAG_S3RH2009    JUPITER     FIXED        -28972

      JUICE_JSEQ                    JUPITER     DYNAMIC      -28973
      JUICE_JUPITER_BSM             JUPITER     DYNAMIC      -28974
      JUICE_JUPITER_SJC             JUPITER     DYNAMIC      -28975
      JUICE_JSM                     JUPITER     DYNAMIC      -28976
      JUICE_JSW                     JUPITER     FIXED        -28977
      JUICE_JSWM                    JUPITER     FIXED        -28978

      JUICE_CALLISTO_PHI_ORB        CALLISTO    DYNAMIC      -28980
      JUICE_EUROPA_PHI_ORB          EUROPA      DYNAMIC      -28981
      JUICE_GANYMEDE_PHI_ORB        GANYMEDE    DYNAMIC      -28982
  
      JUICE_HGRTN                   SUN         DYNAMIC      -28990
      JUICE_SUN_RTN                 JUICE       DYNAMIC      -28991
      JUICE_JUPITER_DM              JUPITER     DYNAMIC      -28992
      JUICE_JUPITER_RTP             JUPITER     DYNAMIC      -28993

      JUPITER_SYSTEM3RH_1965        JUPITER     PCK          -28999
      JUPITER_SYSTEM3RH_2009        JUPITER     PCK          -28998
      JUPITER_MAG_VIP4              JUPITER     FIXED        -28997

      JUPITER_MEQUD                 JUPITER     DYNAMIC   500599000
      JUPITER_SUN_EQU               JUPITER     DYNAMIC   500599001
      JUPITER_SUN_ORB               JUPITER     DYNAMIC   500599002
        
      JUPITER_CALLISTO_BCSF         JUPITER     DYNAMIC   500599006
      JUPITER_EUROPA_BCSF           JUPITER     DYNAMIC   500599004
      JUPITER_GANYMEDE_BCSF         JUPITER     DYNAMIC   500599005
     
      CALLISTO_JUPITER_ORB          CALLISTO    DYNAMIC   500504000
      EUROPA_JUPITER_ORB            EUROPA      DYNAMIC   500502000
      GANYMEDE_JUPITER_ORB          GANYMEDE    DYNAMIC   500503000


   These frames have been defined relative to the following frames:
   
      SPICE Frame Name              Relative to
      --------------------------    ----------------------
      JUICE_JUPITER_IF_J2000        J2000
      JUICE_JUPITER_MAG_S3RH1965    JUPITER_SYSTEM3RH_1965
      JUICE_JUPITER_MAG_S3RH2009    JUPITER_SYSTEM3RH_2009
      JUICE_JSEQ                    J2000
      JUICE_JUPITER_BSM             J2000
      JUICE_JUPITER_SJC             J2000
      JUICE_JSM                     J2000
      JUICE_JSW                     JUPITER_SUN_ORB     (1)
      JUICE_JSWM                    JUICE_JUPITER_BSM   (1)
      
      JUICE_CALLISTO_PHI_ORB        J2000
      JUICE_EUROPA_PHI_ORB          J2000
      JUICE_GANYMEDE_PHI_ORB        J2000
      
      JUICE_HGRTN                   J2000
      JUICE_SUN_RTN                 J2000
      JUICE_JUPITER_DM              J2000
      JUICE_JUPITER_RTP             J2000

      JUPITER_SYSTEM3RH_1965        J2000
      JUPITER_SYSTEM3RH_2009        J2000
      JUPITER_MAG_VIP4              IAU_JUPITER

      JUPITER_MEQUD                 J2000
      JUPITER_SUN_EQU               J2000
      JUPITER_SUN_ORB               J2000
        
      JUPITER_CALLISTO_BCSF         J2000
      JUPITER_EUROPA_BCSF           J2000
      JUPITER_GANYMEDE_BCSF         J2000
     
      CALLISTO_JUPITER_ORB          J2000
      EUROPA_JUPITER_ORB            J2000
      GANYMEDE_JUPITER_ORB          J2000


   (1) SPICE imposes a constraint in the definition of dynamic frames
       (see [1]):

          When the definition of a parameterized dynamic frame F1 refers to
          a second frame F2 the referenced frame F2 may be dynamic, but F2
          must not make reference to any dynamic frame.

       Therefore, no other dynamic frame should make reference to this
       frame.
       

   The keywords implementing these frame definitions are located in the 
   "JUICE Mission Specific Generic Frame Definitions" and "JUPITER System
   Generic Frame Definitions" sections.
               
      
General Notes About This File
------------------------------------------------------------------------------

   About Required Data:
   --------------------
 
   Most of the dynamic frames defined in this file require at least one
   of the following kernels to be loaded prior to their evaluation, 
   normally during program initialization:

     - Planetary ephemeris data (SPK), e.g. DE403, DE405, etc;
     - Planetary constants data (PCK);
     - Earth generic frames definitions (FK).

   Note that loading different kernels will lead to different
   orientations of the same frame at a given epoch, providing different
   results from each other, in terms of state vectors referred to these 
   frames.
 
 
   About Implementation:
   ---------------------
 
   The SPICE frames defined within this file and their corresponding 
   references in literature might not be equivalent, both due to 
   variations in the SPICE kernels on which the SPICE frame depends, 
   and due to possible differences in both the frame's definition and 
   implementation (e.g. GSE can be defined using the instantaneous 
   orbital plane or mean ecliptic; the mean ecliptic is a function of 
   the ecliptic model). Please refer to each applicable frame 
   description section for particular details on the current SPICE
   kernel implementation.
   
 
JUICE Mission Specific Scientific Frame Definitions
------------------------------------------------------------------------------

   This section contains the definition of the JUICE mission specific
   scientific frames.


Jupiter Inertial Frame at J2000 (JUICE_JUPITER_IF_J2000)
------------------------------------------------------------------------

   Definition:
   -----------   

   The Jupiter Inertial Frame at J2000 is defined as follows:

      -  +Z axis is parallel to Jupiter rotation axis 
         at J2000, pointing toward the North side of the 
         invariable plane;

      -  +X axis is aligned with the ascending node of the Jovian 
         orbital plane with the Jovian equator plane at J2000;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.


   Remarks:
   --------
 
   This frame is defined as a fixed offset frame using constant vectors 
   as the specification method. The fixed offset for these vectors were 
   based on the following directions (that also define a two-vector 
   frame):

     - +Z axis along Right Ascension of 268.05720404270755 degrees and 
       Declination of 64.495809953395721 of Jupiter pole at J2000 epoch
       in J2000 inertial frame;

     - +X axis along Right Ascension of 139.90957808624046 degrees and 
       Declination of 16.419104754306645 with respect to J2000 inertial
       frame at J2000 epoch, which corresponds to the RA/DEC of Jupiter
       instantaneous orbital plane ascending node on Jupiter equator at
       J2000 epoch in J2000 inertial frame; 

   This frame has been defined based on the IAU_JUPITER frame, whose 
   evaluation was based on the data included in the loaded PCK file.
   When evaluated, the IAU 2009 constants for Jupiter (see [19]) were
   used.

   In addition jup310.bsp has been used to compute the Jupiter 
   instantaneous orbital plane ascending node on Jupiter equator at 
   J2000 epoch in J2000 inertial frame.

  \begindata

      FRAME_JUICE_JUPITER_IF_J2000   = -28970
      FRAME_-28970_NAME              = 'JUICE_JUPITER_IF_J2000'
      FRAME_-28970_CLASS             =  4
      FRAME_-28970_CLASS_ID          = -28970
      FRAME_-28970_CENTER            =  599

      TKFRAME_-28970_SPEC            = 'ANGLES'
      TKFRAME_-28970_RELATIVE        = 'J2000'
      TKFRAME_-28970_ANGLES          = ( 
                                         -88.057204042707568   
                                          25.504190046604286   
                                         -48.968728165793905
                                       )
      TKFRAME_-28970_AXES            = ( 
                                          3,
                                          2,   
                                          3
                                       )
      TKFRAME_-28970_UNITS           = 'DEGREES'

  \begintext


Jupiter Magnetic S3RH VIP4 model - IAU 1994 (JUICE_JUPITER_MAG_S3RH1965)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, the Jupiter Magnetic System III Right-handed
   frame using the VIP4 model (see [16]) and IAU 1994 constants (see
   [18]) is referred as JUICE_JUPITER_MAG_S3RH1965.


   Definition:
   -----------
 
   The Jupiter Magnetic System III Right-Handed frame is defined as
   follows (from [17]):

      -  +Z axis is parallel to the magnetic dipole axis of epoch and
         aligned with the North magnetic pole of epoch;

      -  +Y axis is defined with respect to the meridian where the
         magnetic and geographic equators cross at longitude 249.2
         degrees in the System III Right-handed frame;

      -  +X completes the right-handed frame;

      -  the origin of this frame is the center of mass of Jupiter.
    
    
   Remarks:
   --------
 
   This frame is base on the VIP4 model (see [16]) using as reference
   the System III Right-handed body-fixed frame for Jupiter with the
   constants provided in the IAU 1994 report (see [18]) for Jupiter's
   north pole and primer meridian location. The magnetic system
   rotates with Jupiter at the same rate, but about the magnetic
   dipole instead of the Jovian spin axis. 

   The north dipole location is the best-fit, centered dipole magnetic 
   moment vector M direction in the JUPITER_SYSTEM3RH_1965 frame based
   on the VIP4 model. M is defined to be titled 9.50 degrees away from
   the Jovian spin axis towards longitude 200.8 degrees West, therefore,
   the current values for the Jupiter north magnetic centered dipole
   planetocentric coordinates are:
      
      Longitude    =  159.2 (degrees)
      Latitude     =   80.5 (degrees)
 
  \begindata

      FRAME_JUICE_JUPITER_MAG_S3RH1965   = -28971
      FRAME_-28971_NAME                  = 'JUICE_JUPITER_MAG_S3RH1965'
      FRAME_-28971_CLASS                 =  4
      FRAME_-28971_CLASS_ID              = -28971
      FRAME_-28971_CENTER                =  599 
      TKFRAME_-28971_SPEC                = 'ANGLES'
      TKFRAME_-28971_RELATIVE            = 'JUPITER_SYSTEM3RH_1965'
      TKFRAME_-28971_ANGLES              = ( 0, -159.2, -9.5 )
      TKFRAME_-28971_AXES                = ( 2,      3,    2 )
      TKFRAME_-28971_UNITS               = 'DEGREES'

  \begintext
  
  
Jupiter Magnetic S3RH VIP4 model - IAU 2009 (JUICE_JUPITER_MAG_S3RH2009)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, the Jupiter Magnetic System III Right-handed
   frame using the VIP4 model and IAU 2009 constants is referred as
   JUICE_JUPITER_MAG_S3RH2009.


   Definition:
   -----------
 
   The Jupiter Magnetic System III Right-Handed frame is defined as
   follows (from [17]):

      -  +Z axis is parallel to the magnetic dipole axis of epoch and
         aligned with the North magnetic pole of epoch;

      -  +Y axis is defined with respect to the meridian where the
         magnetic and geographic equators cross at longitude 249.2
         degrees in the System III Right-handed frame;

      -  +X completes the right-handed frame;

      -  the origin of this frame is the center of mass of Jupiter.
    
    
   Remarks:
   --------
 
   This frame is base on the VIP4 model (see [16]) using as reference
   the System III Right-handed body-fixed frame for Jupiter with the
   constants provided in the IAU 2009 report (see [19]) for Jupiter's
   north pole and primer meridian location. The magnetic system
   rotates with Jupiter at the same rate, but about the magnetic
   dipole instead of the Jovian spin axis. 

   The north dipole location is the best-fit, centered dipole magnetic 
   moment vector M direction in the JUPITER_SYSTEM3RH_2009 frame based
   on the VIP4 model. M is defined to be titled 9.50 degrees away from
   the Jovian spin axis towards longitude 200.8 degrees West, therefore,
   the current values for the Jupiter north magnetic centered dipole
   planetocentric coordinates are:
      
      Longitude    =  159.2 (degrees)
      Latitude     =   80.5 (degrees)

  \begindata

      FRAME_JUICE_JUPITER_MAG_S3RH2009   = -28972
      FRAME_-28972_NAME                  = 'JUICE_JUPITER_MAG_S3RH2009'
      FRAME_-28972_CLASS                 =  4
      FRAME_-28972_CLASS_ID              = -28972
      FRAME_-28972_CENTER                =  599 
      TKFRAME_-28972_SPEC                = 'ANGLES'
      TKFRAME_-28972_RELATIVE            = 'JUPITER_SYSTEM3RH_2009'
      TKFRAME_-28972_ANGLES              = ( 0, -159.2, -9.5 )
      TKFRAME_-28972_AXES                = ( 2,      3,    2 )
      TKFRAME_-28972_UNITS               = 'DEGREES'

  \begintext


Joviancentric Equatorial Solar frame (JUICE_JSEQ)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, and for the JUICE mission, the Joviancentric
   Equatorial Solar frame is referred as JUICE_JSEQ. In the
   documentation provided by the JUICE MAG team (see [21]), it is
   referred as Joviancentric Solar Equatorial frame or JSEq.
   
   CAUTION: xSEQ coordinate systems are typically referenced to the
   planet Sun line and the solar equator. JUICE mission uses a lowercase
   q in the frame designator to distinguish this type of coordinate
   system, where the planetary equator is the plane of reference.
   

   Definition:
   -----------

   The Joviancentric Equatorial Solar frame is defined as follows
   (from [4]):

      -  X-Y plane is defined by the Jupiter equator of date. Therefore,
         the +Z axis is the primary vector and it is aligned to
         Jupiter's north pole of date;

      -  +X axis is the component of the position of Jupiter relative
         to the Sun that is orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.
   

   Uses and applications:
   ----------------------

   The Joviancentric Equatorial Solar frame is commonly used in the
   analysis of orbital trajectories where planetary rotation complicates
   the analysis but where knowledge of the equatorial plane is still
   required. Data can be analyzed for local time and north-south
   asymmetries in this reference frame.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the IAU_JUPITER
   body-fixed frame, which is a PCK-based frame. Therefore a PCK file
   containing the orientation constants for Jupiter must be loaded
   before using this frame.

   The secondary vector is defined as an 'observer-target position'
   vector. Therefore, the ephemeris data required to compute the
   Sun-Jupiter position vector in the J2000 reference frame must be
   loaded before using this frame.
 
  
   Remarks:
   --------
 
   This frame is defined based on SPK data: different planetary
   ephemerides for Jupiter, Jupiter's Barycenter, the Sun and the Solar
   System Barycenter will lead to different frame orientation at a given
   time.
   
   This frame is also defined based on the IAU_JUPITER frame, whose
   evaluation is based on the data included in the loaded PCK file:
   different orientation constants for Jupiter's spin axis will lead to
   different frame orientation at a given time. 
   
   It is strongly recommended to indicate what data have been used in
   the evaluation of this frame when referring to it, e.g.
   JUICE_JSEQ using the IAU 2009 constants and the DE405
   ephemeris.
   
  \begindata

      FRAME_JUICE_JSEQ              = -28973
      FRAME_-28973_NAME             = 'JUICE_JSEQ'
      FRAME_-28973_CLASS            =  5
      FRAME_-28973_CLASS_ID         = -28973
      FRAME_-28973_CENTER           =  599
      FRAME_-28973_RELATIVE         = 'J2000'
      FRAME_-28973_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28973_FAMILY           = 'TWO-VECTOR'
      FRAME_-28973_PRI_AXIS         = 'Z'
      FRAME_-28973_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_-28973_PRI_FRAME        = 'IAU_JUPITER'
      FRAME_-28973_PRI_SPEC         = 'RECTANGULAR'
      FRAME_-28973_PRI_VECTOR       = ( 0, 0, 1 )
      FRAME_-28973_SEC_AXIS         = 'X'
      FRAME_-28973_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28973_SEC_OBSERVER     = 'JUPITER'
      FRAME_-28973_SEC_TARGET       = 'SUN'
      FRAME_-28973_SEC_ABCORR       = 'NONE'

  \begintext


Jupiter Solar Magnetospheric (JUICE_JUPITER_BSM)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, the Jupiter Solar Magnetospheric frame is 
   referred as JUICE_SUN_BSM. In the documentation provided by the
   JUICE MAG team (see [21]),, this frame is referred as JSM.


   Definition:
   -----------
 
   The Jupiter Solar Magnetospheric frame is defined, based on the
   definition in [11] for the Earth, as follows (from [21]):
   
      -  +X axis is the position of the Sun relative to Jupiter; 
         it's the primary vector and points from Jupiter to the Sun;
         
      -  +Z axis is the projection of the magnetic centered
         dipole axis (positive North) of Jupiter onto the plane 
         perpendicular to the +X axis.
    
      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.


   Uses and applications:
   ----------------------
 
   The Jupiter Solar Magnetospheric is used to analyze data affected
   by both the solar wind flow velocity and the rotating magnetic
   field of Jupiter, but where the solar wind forces still dominate
   (in the magnetosheath and near the magnetopause) (from [21]).
   
   
   Required Data:
   --------------
 
   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.
   
   The primary vector is defined as an 'observer-target position' 
   vector. Therefore, the ephemeris data required to compute the 
   Jupiter-Sun position vector in the J2000 reference frame must be
   loaded before using this frame.
   
   The secondary vector is defined as a constant vector in the 
   JUPITER_MAG_VIP4 body-fixed frame, which provides the orientation
   for the Jupiter North magnetic dipole and the Jupiter magnetic
   frame with respect to the IAU_JUPITER body-fixed frame.

   
   Remarks:
   --------
 
   This frame is defined based on SPK data: different planetary 
   ephemerides for Jupiter, Jupiter Barycenter, the Sun and the 
   Solar System Barycenter will lead to a different frame orientation 
   at a given time.
   
   This frame is also defined based on the JUPITER_MAG_VIP4 frame, which
   is defined relative to the IAU_JUPITER frame, whose evaluation is
   based on the data included in the loaded PCK file: different
   orientation constants for Jupiter's spin axis will lead to different
   frame orientation at a given time, but only when these constants 
   result on different projections of the north magnetic centered dipole
   on the frame's YZ plane.
      
   It is strongly recommended to indicate what data have been used 
   in the evaluation of this frame when referring to it, e.g. 
   JUICE_JUPITER_BSM using the IAU 2009 constants and the DE405
   ephemeris.
   
  \begindata

       FRAME_JUICE_JUPITER_BSM       = -28974
       FRAME_-28974_NAME             = 'JUICE_JUPITER_BSM'
       FRAME_-28974_CLASS            =  5
       FRAME_-28974_CLASS_ID         = -28974
       FRAME_-28974_CENTER           =  599
       FRAME_-28974_RELATIVE         = 'J2000'
       FRAME_-28974_DEF_STYLE        = 'PARAMETERIZED'
       FRAME_-28974_FAMILY           = 'TWO-VECTOR'
       FRAME_-28974_PRI_AXIS         = 'X'
       FRAME_-28974_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
       FRAME_-28974_PRI_OBSERVER     = 'JUPITER'
       FRAME_-28974_PRI_TARGET       = 'SUN'
       FRAME_-28974_PRI_ABCORR       = 'NONE'
       FRAME_-28974_SEC_AXIS         = 'Z'
       FRAME_-28974_SEC_VECTOR_DEF   = 'CONSTANT'
       FRAME_-28974_SEC_SPEC         = 'RECTANGULAR'
       FRAME_-28974_SEC_VECTOR       = ( 0, 0, 1 )
       FRAME_-28974_SEC_FRAME        = 'JUPITER_MAG_VIP4'

  \begintext


Solar Joviancentric Coordinates frame (JUICE_JUPITER_SJC)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, and for the JUICE mission, the Solar
   Joviancentric Coordinates frame is referred as JUICE_JUPITER_SJC. In
   the documentation provided by the JUICE MAG team (see [21]), it is
   referred as Solar Joviancentric Coordinates or SJ.
   
   
   Definition:
   -----------

   The Solar Joviancentric Coordinates frame is defined as follows
   (from [21]):
   
      -  +X axis is the position of the Sun relative to Jupiter; it's
         the primary vector and points from Jupiter to the Sun;

      -  +Z axis is the component of Jupiter's north pole of date 
         orthogonal to the +X axis;

      -  +Y axis completes the right-handed reference frame;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.
   

   Required Data:
   --------------
 
   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position'
   vector. Therefore, the ephemeris data required to compute the
   Jupiter-Sun vector in the J2000 reference frame must be loaded
   before using this frame.

   The secondary vector is defined as a constant vector in the
   IAU_JUPITER body-fixed frame, which is a PCK-based frame. Therefore
   a PCK file containing the orientation constants for Jupiter must be
   loaded before using this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Jupiter, Jupiter Barycenter, the Sun and the
   Solar System Barycenter will lead to a different frame
   orientation at a given time.

   This frame is also defined based on the IAU_JUPITER frame, whose
   evaluation is based on the data included in the loaded PCK file:
   different orientation constants for Jupiter's spin axis will lead
   to a different frame orientation at a given time.
   
   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUICE_JUPITER_SJC using the IAU 2009 constants and the DE405
   ephemeris.

  \begindata

      FRAME_JUICE_JUPITER_SJC       = -28975
      FRAME_-28975_NAME             = 'JUICE_JUPITER_SJC'
      FRAME_-28975_CLASS            =  5
      FRAME_-28975_CLASS_ID         = -28975
      FRAME_-28975_CENTER           =  599
      FRAME_-28975_RELATIVE         = 'J2000'
      FRAME_-28975_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28975_FAMILY           = 'TWO-VECTOR'
      FRAME_-28975_PRI_AXIS         = 'X'
      FRAME_-28975_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28975_PRI_OBSERVER     = 'JUPITER'
      FRAME_-28975_PRI_TARGET       = 'SUN'
      FRAME_-28975_PRI_ABCORR       = 'NONE'
      FRAME_-28975_SEC_AXIS         = 'Z'
      FRAME_-28975_SEC_VECTOR_DEF   = 'CONSTANT'
      FRAME_-28975_SEC_FRAME        = 'IAU_JUPITER'
      FRAME_-28975_SEC_SPEC         = 'RECTANGULAR'
      FRAME_-28975_SEC_VECTOR       = ( 0, 0, 1 )

  \begintext


Jupiter Solar Magnetic (JUICE_JSM)
------------------------------------------------------------------------

   Definition:
   -----------

   The Jupiter Solar Magnetic frame is defined, based on the definition
   provided in [11] for the Earth's solar magnetic frame, as follows:
   
      -  +Z axis is aligned with the North magnetic centered dipole of
         Jupiter;

      -  +X axis is the component of the Jupiter-Sun vector that is
         orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.
   
   
   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different types
   of specifications for the primary and secondary vectors.
   
   The primary vector is defined as a constant vector in the 
   JUPITER_MAG_VIP4 body-fixed frame, which provides the 
   orientation for the Jupiter North magnetic dipole and the Jupiter 
   magnetic frame with respect to the IAU_JUPITER body-fixed frame.   

   The secondary vector is defined as an 'observer-target position' 
   vector. Therefore, the ephemeris data required to compute the 
   Jupiter-Sun position vector in the J2000 reference frame must be
   loaded before using this frame.


   Remarks:
   --------
 
   This frame is defined based on SPK data: different planetary
   ephemerides for Jupiter, Jupiter's Barycenter, the Sun and the Solar
   System Barycenter will lead to different frame orientation at a given
   time.
   
   This frame is also defined based on the JUPITER_MAG_VIP4 frame, which
   is defined relative to the IAU_JUPITER frame, whose evaluation is
   based on the data included in the loaded PCK file: different
   orientation constants for Jupiter's spin axis will lead to different
   frame orientation at a given time. 
   
   It is strongly recommended to indicate what data have been used 
   in the evaluation of this frame when referring to it, e.g. 
   JUICE_JSM using the IAU 2009 constants and the DE405 ephemeris.
   
  \begindata
  
      FRAME_JUICE_JSM               = -28976
      FRAME_-28976_NAME             = 'JUICE_JSM'
      FRAME_-28976_CLASS            =  5
      FRAME_-28976_CLASS_ID         = -28976
      FRAME_-28976_CENTER           =  599
      FRAME_-28976_RELATIVE         = 'J2000'
      FRAME_-28976_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28976_FAMILY           = 'TWO-VECTOR'
      FRAME_-28976_PRI_AXIS         = 'Z'
      FRAME_-28976_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_-28976_PRI_SPEC         = 'RECTANGULAR'
      FRAME_-28976_PRI_VECTOR       = ( 0, 0, 1 )
      FRAME_-28976_PRI_FRAME        = 'JUPITER_MAG_VIP4'       
      FRAME_-28976_SEC_AXIS         = 'X'
      FRAME_-28976_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28976_SEC_OBSERVER     = 'JUPITER'
      FRAME_-28976_SEC_TARGET       = 'SUN'
      FRAME_-28976_SEC_ABCORR       = 'NONE'

  \begintext


Jupiter Solar Wind frame (JUICE_JSW)
------------------------------------------------------------------------

   Definition:
   -----------  

   The Jupiter Solar Wind frame is defined is defined, based on the
   definition in [12], section 3.3.7) for the Geocentric Solar Wind 
   frame, as follows:
   
      -  +Z is perpendicular to the orbital plane of Jupiter and is 
         positive towards North;
         
      -  +X axis is the component of the solar wind direction vector
         that is orthogonal to the +Z-axis. This axis lies in the
         orbital plane of Jupiter and is positive in the direction 
         opposite to the solar wind;
         
      -  +Y axis completes the right-handed system;
         
      -  the origin of this frame is the center of mass of Jupiter.

   
   Uses and applications:
   ----------------------

   The Jupiter Solar Wind frame is useful in analyzing the impact
   of solar wind on hemispheric events (from [12], section 3.3.7).
   
   
   Remarks:
   --------

   A critical issue to consider in the definition of this 
   frame is aberration - the bow shock of Jupiter is rotated in 
   the plane of the orbit of Jupiter by angle Vplanet/Vsolar_wind, 
   where Vplanet is the velocity of Jupiter in its orbit and 
   Vsolar_wind is the solar wind speed. The sense of rotation is 
   such the bow shock lags its un-rotated location on the anti-sunward 
   side of Jupiter. This is the +Y direction for Jupiter solar 
   orbital frame (JUPITER_SUN_ORB). Strictly speaking Vplanet should 
   be the component perpendicular to the solar wind. 
   
   Th solar wind streams off of the Sun in all directions at speeds 
   of about 400 km/s. Nevertheless, the solar wind is not uniform. 
   Although it is always directed away from the Sun, it changes speed 
   and carries with it magnetic clouds, interacting regions where high
   speed wind catches up with slow speed wind, and composition 
   variations. The solar wind speed can range from high (800 km/s) over
   coronal holes to low velocities (300 km/s) over streamers 
   (see [13]).
   
   For Jupiter under normal solar wind conditions (v ~400 km/s) the 
   angle of aberration ranges from 1.9652 degrees for the maximum 
   orbital velocity to 1.7819 degrees for the minimum orbital 
   velocity of Jupiter.
   
   By convention, the average velocity for Jupiter in its orbit and for
   the solar wind at Jupiter will be used in the definition of this
   frame, which is highly significant for determining  magnetopause and
   bow shock locations. This value is determined to be 1.8707 degrees. 
   
   Since the minimum aberration is of approximately 0.89095 degrees
   (maximum solar wind and minimum Jupiter orbital velocities) and 
   the maximum aberration is of approximately 2.6203 degrees (minimum 
   solar wind and maximum Jupiter orbital velocities), the error in 
   the definition of the +X-axis direction is between -0.97975 to 
   0.7496 degrees.
      
   This frame is defined relative to JUPITER_SUN_ORB, which is 
   dynamic. This aspect shall be taken into account if/when using this
   frame to define other dynamic frames. For further details, please
   refer to [1].
   
  \begindata

      FRAME_JUICE_JSW           = -28977
      FRAME_-28977_NAME         = 'JUICE_JSW'
      FRAME_-28977_CLASS        =  4
      FRAME_-28977_CLASS_ID     = -28977
      FRAME_-28977_CENTER       =  599
      TKFRAME_-28977_SPEC       = 'ANGLES'
      TKFRAME_-28977_RELATIVE   = 'JUPITER_SUN_ORB'
      TKFRAME_-28977_ANGLES     = (   -1.8707,  0.0,  0.0 )
      TKFRAME_-28977_AXES       = (         3,    2,    3 )
      TKFRAME_-28977_UNITS      = 'DEGREES'

  \begintext

   
Jupiter Solar Wind Magnetospheric frame (JUICE_JSWM)
------------------------------------------------------------------------

   Definition:
   -----------  

   The Jupiter solar wind magnetospheric frame is defined, based on the
   definition in [12], section 3.3.6) for the Geocentric Solar Wind 
   Magnetospheric frame, as follows:
   
      -  +X axis is aligned with the solar wind direction. This axis is
         positive in the direction opposite to the solar wind;
         
      -  +Z axis is the component of the magnetic axis (magnetic
         dipole) orthogonal to the +X axis, positive towards magnetic
         north of Jupiter;
         
      -  +Y axis completes the right-handed system. It is perpendicular
         to the magnetic axis (magnetic dipole);
         
      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.
   
   
   Remarks:
   --------

   A critical issue to consider in the definition of this 
   frame is aberration - the bow shock of Jupiter is rotated in 
   the plane of the orbit of Jupiter by angle Vplanet/Vsolar_wind, 
   where Vplanet is the velocity of Jupiter in its orbit and 
   Vsolar_wind is the solar wind speed. The sense of rotation is 
   such the bow shock lags its un-rotated location on the anti-sunward 
   side of Jupiter. This is the +Y direction for Jupiter Solar 
   Orbital frame (JUPITER_SUN_ORB). Strictly speaking Vplanet should 
   be the component perpendicular to the solar wind. 
   
   Th solar wind streams off of the Sun in all directions at speeds 
   of about 400 km/s. Nevertheless, the solar wind is not uniform. 
   Although it is always directed away from the Sun, it changes speed 
   and carries with it magnetic clouds, interacting regions where high
   speed wind catches up with slow speed wind, and composition 
   variations. The solar wind speed can range from high (800 km/s) over
   coronal holes to low velocities (300 km/s) over streamers 
   (see [13]).
   
   For Jupiter under normal solar wind conditions (v ~400 km/s) the 
   angle of aberration ranges from 1.9652 degrees for the maximum 
   orbital velocity to 1.7819 degrees for the minimum orbital 
   velocity of Jupiter.
   
   By convention, the average velocity for Jupiter in its orbit and for
   the solar wind at Jupiter, will be used in the definition of this
   frame, which is highly significant for determining magnetopause and
   bow shock locations. This value is determined to be 1.8707 degrees. 
   
   Since the minimum aberration is of approximately 0.89095 degrees
   (maximum solar wind and minimum Jupiter orbital velocities) and 
   the maximum aberration is of approximately 2.6203 degrees (minimum 
   solar wind and maximum Jupiter orbital velocities), the error in 
   the definition of the +X-axis direction is between -0.97975 to 
   0.7496 degrees.
   
   This frame is defined relative to JUICE_JUPITER_BSM, which is 
   dynamic. This aspect shall be taken into account if/when using this
   frame to define other dynamic frames. For further details, please
   refer to [1].
   
  \begindata

      FRAME_JUICE_JSWM          = -28978
      FRAME_-28978_NAME         = 'JUICE_JSWM'
      FRAME_-28978_CLASS        =  4
      FRAME_-28978_CLASS_ID     = -28978
      FRAME_-28978_CENTER       =  599
      TKFRAME_-28978_SPEC       = 'ANGLES'
      TKFRAME_-28978_RELATIVE   = 'JUICE_JUPITER_BSM'
      TKFRAME_-28978_ANGLES     = (   -1.8707,  0.0,  0.0 )
      TKFRAME_-28978_AXES       = (         3,    2,    3 )
      TKFRAME_-28978_UNITS      = 'DEGREES'

  \begintext


Callisto-centered Phi Zorb frame (JUICE_CALLISTO_PHI_ORB)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, and for the JUICE mission, the Callisto
   centered Phi Zorb frame is referred as JUICE_CALLISTO_PHI_ORB. In
   the documentation provided by the JUICE MAG team (see [21]), it is
   referred as Satellite centered Phi Zorb Coordinates or SPhiZ.

   
   Definition:
   -----------

   The Callisto-centered Phi Zorb frame is defined as follows (from
   [21]):

      -  Y axis is the position of the Jupiter relative to 
         Callisto; it's the primary vector and points 
         from Callisto to Jupiter;
 
      -  -X axis is the component of the inertially referenced
         velocity of Jupiter relative to Callisto orthogonal 
         to the +Y axis;
   
      -  +Z axis completes the right-handed system;
   
      -  the origin of this frame is the center of mass of Callisto.
   
   All vectors are geometric: no aberration corrections are used.


   Uses and applications:
   ----------------------
   The Callisto-centered Phi Zorb frame is used to analyze Callisto
   data where the interactions between the plasma flow and Callisto's
   orbital motions are the processes of interest.
   

   Required Data:
   --------------
 
   This frame is defined as a two-vector frame using two different 
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' 
   vector and the secondary vector is defined as an 'observer-target
   velocity' vector, therefore, the ephemeris data required to compute
   the Callisto-Jupiter state vector in the J2000 reference frame must
   be loaded before using this frame.


   Remarks:
   --------

   This frame is a transformation of the CALLISTO_JUPITER_ORB frame.
   The transformation applied is x'=-y, y'=x, z'=z. 

   This frame is defined based on SPK data: different planetary 
   ephemerides for Callisto, Jupiter and the Jupiter Barycenter
   will lead to a different frame orientation at a given time.
   
   It is strongly recommended to indicate what data have been used 
   in the evaluation of this frame when referring to it, e.g. 
   JUICE_CALLISTO_PHI_ORB using the DE405 ephemeris.

  \begindata

      FRAME_JUICE_CALLISTO_PHI_ORB   = -28980
      FRAME_-28980_NAME              = 'JUICE_CALLISTO_PHI_ORB' 
      FRAME_-28980_CLASS             =  5
      FRAME_-28980_CLASS_ID          = -28980
      FRAME_-28980_CENTER            =  504
      FRAME_-28980_RELATIVE          = 'J2000'
      FRAME_-28980_DEF_STYLE         = 'PARAMETERIZED'
      FRAME_-28980_FAMILY            = 'TWO-VECTOR'
      FRAME_-28980_PRI_AXIS          = 'Y'
      FRAME_-28980_PRI_VECTOR_DEF    = 'OBSERVER_TARGET_POSITION'
      FRAME_-28980_PRI_OBSERVER      = 'CALLISTO'
      FRAME_-28980_PRI_TARGET        = 'JUPITER'
      FRAME_-28980_PRI_ABCORR        = 'NONE'
      FRAME_-28980_SEC_AXIS          = '-X'
      FRAME_-28980_SEC_VECTOR_DEF    = 'OBSERVER_TARGET_VELOCITY'
      FRAME_-28980_SEC_OBSERVER      = 'CALLISTO'
      FRAME_-28980_SEC_TARGET        = 'JUPITER'
      FRAME_-28980_SEC_ABCORR        = 'NONE'
      FRAME_-28980_SEC_FRAME         = 'J2000'
     
  \begintext
  

Europa-centered Phi Zorb frame (JUICE_EUROPA_PHI_ORB)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, and for the JUICE mission, the Europa
   centered Phi Zorb frame is referred as JUICE_EUROPA_PHI_ORB. In
   the documentation provided by the JUICE MAG team (see [21]), it is
   referred as Satellite centered Phi Zorb Coordinates or SPhiZ.
   
   
   Definition:
   -----------
 
   The Europa-centered Phi Zorb frame is defined as follows (from
   [21]):

      -  +Y axis is the position of the Jupiter relative to 
         Europa; it's the primary vector and points 
         from Europa to Jupiter;
 
      -  -X axis is the component of the inertially referenced
         velocity of Jupiter relative to Europa orthogonal 
         to the +Y axis;

      -  +Z axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Europa.

   All vectors are geometric: no aberration corrections are used.


   Uses and applications:
   ----------------------
   The Europa-centered Phi Zorb frame is used to analyze Europa
   data where the interactions between the plasma flow and Europa's
   orbital motions are the processes of interest.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different 
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' 
   vector and the secondary vector is defined as an 'observer-target
   velocity' vector, therefore, the ephemeris data required to compute
   the Europa-Jupiter state vector in the J2000 reference frame must
   be loaded before using this frame.


   Remarks:
   --------

   This frame is a transformation of the EUROPA_JUPITER_ORB frame.
   The transformation applied is x'=-y, y'=x, z'=z. 

   This frame is defined based on SPK data: different planetary 
   ephemerides for Europa, Jupiter and the Jupiter Barycenter
   will lead to a different frame orientation at a given time.
   
   It is strongly recommended to indicate what data have been used 
   in the evaluation of this frame when referring to it, e.g. 
   JUICE_EUROPA_PHI_ORB using DE405 ephemeris.

  \begindata

      FRAME_JUICE_EUROPA_PHI_ORB      = -28981
      FRAME_-28981_NAME               = 'JUICE_EUROPA_PHI_ORB' 
      FRAME_-28981_CLASS              =  5
      FRAME_-28981_CLASS_ID           = -28981
      FRAME_-28981_CENTER             =  502
      FRAME_-28981_RELATIVE           = 'J2000'
      FRAME_-28981_DEF_STYLE          = 'PARAMETERIZED'
      FRAME_-28981_FAMILY             = 'TWO-VECTOR'
      FRAME_-28981_PRI_AXIS           = 'Y'
      FRAME_-28981_PRI_VECTOR_DEF     = 'OBSERVER_TARGET_POSITION'
      FRAME_-28981_PRI_OBSERVER       = 'EUROPA'
      FRAME_-28981_PRI_TARGET         = 'JUPITER'
      FRAME_-28981_PRI_ABCORR         = 'NONE'
      FRAME_-28981_SEC_AXIS           = '-X'
      FRAME_-28981_SEC_VECTOR_DEF     = 'OBSERVER_TARGET_VELOCITY'
      FRAME_-28981_SEC_OBSERVER       = 'EUROPA'
      FRAME_-28981_SEC_TARGET         = 'JUPITER'
      FRAME_-28981_SEC_ABCORR         = 'NONE'
      FRAME_-28981_SEC_FRAME          = 'J2000'

  \begintext
  

Ganymede-centered Phi Zorb frame (JUICE_GANYMEDE_PHI_ORB)
------------------------------------------------------------------------
   
   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, and for the JUICE mission, the Ganymede
   centered Phi Zorb frame is referred as JUICE_GANYMEDE_PHI_ORB. In
   the documentation provided by the JUICE MAG team (see [21]), it is
   referred as Satellite centered Phi Zorb Coordinates or SPhiZ.
   
   
   Definition:
   -----------
 
   The Ganymede-centered Phi Zorb frame is defined as follows (from
   [21]):

      -  +Y axis is the position of the Jupiter relative to 
         Ganymede; it's the primary vector and points 
         from Ganymede to Jupiter;
 
      -  -X axis is the component of the inertially referenced
         velocity of Jupiter relative to Ganymede orthogonal 
         to the +Y axis;

      -  +Z axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Ganymede.

   All vectors are geometric: no aberration corrections are used.

   
   Uses and applications:
   ----------------------
   The Europa-centered Phi Zorb frame is used to analyze Europa
   data where the interactions between the plasma flow and Europa's
   orbital motions are the processes of interest.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different 
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' 
   vector and the secondary vector is defined as an 'observer-target
   velocity' vector, therefore, the ephemeris data required to compute
   the Ganymede-Jupiter state vector in the J2000 reference frame must
   be loaded before using this frame.


   Remarks:
   --------

   This frame is a transformation of the EUROPA_JUPITER_ORB frame.
   The transformation applied is x'=-y, y'=x, z'=z. 

   This frame is defined based on SPK data: different planetary 
   ephemerides for Ganymede, Jupiter and the Jupiter Barycenter
   will lead to a different frame orientation at a given time.
   
   It is strongly recommended to indicate what data have been used 
   in the evaluation of this frame when referring to it, e.g. 
   JUICE_GANYMEDE_PHI_ORB using the DE405 ephemeris.

  \begindata

      FRAME_JUICE_GANYMEDE_PHI_ORB    = -28982
      FRAME_-28982_NAME               = 'JUICE_GANYMEDE_PHI_ORB'
      FRAME_-28982_CLASS              =  5
      FRAME_-28982_CLASS_ID           = -28982
      FRAME_-28982_CENTER             =  503
      FRAME_-28982_RELATIVE           = 'J2000'
      FRAME_-28982_DEF_STYLE          = 'PARAMETERIZED'
      FRAME_-28982_FAMILY             = 'TWO-VECTOR'
      FRAME_-28982_PRI_AXIS           = 'Y'
      FRAME_-28982_PRI_VECTOR_DEF     = 'OBSERVER_TARGET_POSITION'
      FRAME_-28982_PRI_OBSERVER       = 'GANYMEDE'
      FRAME_-28982_PRI_TARGET         = 'JUPITER'
      FRAME_-28982_PRI_ABCORR         = 'NONE'
      FRAME_-28982_SEC_AXIS           = '-X'
      FRAME_-28982_SEC_VECTOR_DEF     = 'OBSERVER_TARGET_VELOCITY'
      FRAME_-28982_SEC_OBSERVER       = 'GANYMEDE'
      FRAME_-28982_SEC_TARGET         = 'JUPITER'
      FRAME_-28982_SEC_ABCORR         = 'NONE'
      FRAME_-28982_SEC_FRAME          = 'J2000'


  \begintext


JUICE Heliocentric Radial-Tangential-Normal (JUICE_HGRTN)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, the JUICE Heliocentric
   Radial-Tangential-Normal frame is referred as JUICE_HGRTN. In
   literature, this frame is referred as HGRTN (from [4], [6], [7], and
   [8]).
   
      
   Definition:
   -----------
 
   The JUICE Heliocentric Radial-Tangential-Normal frame is defined as 
   follows (from [4]):

      -  the position of JUICE relative to the Sun is the 
         primary vector: +X axis points from the Sun to
         JUICE;

      -  the projection of the solar rotational axis perpendicular to
         the +X axis defines the frame's +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of the Sun.

   All vectors are geometric: no aberration corrections are used.
   
   
   Uses and applications (from [6]):
   ----------------------------------

   This frame is used to define the velocity and field direction of the 
   plasma environment that the spacecraft finds itself in.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' 
   vector, therefore, the ephemeris data required to compute the 
   Sun-JUICE position vector in the J2000 reference frame must be
   loaded before using this frame.

   The secondary vector is defined as a constant vector in the IAU_SUN
   frame, which is a PCK-based frame, therefore a PCK file containing
   the orientation constants for the Sun must be loaded before using 
   this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Jupiter, Jupiter's Barycenter, the Sun, the Solar
   System Barycenter and JUICE spacecraft will lead to different frame
   orientation at a given time.
   
   This frame is also defined based on the IAU_SUN frame, whose
   evaluation is based on the data included in the loaded PCK file:
   different orientation constants for the Sun's spin axis will lead to
   different frame orientation at a given time. 
   
   It is strongly recommended to indicate what data have been used 
   in the evaluation of this frame when referring to it, e.g. 
   JUICE_HGRTN using the IAU 2009 constants, the DE405 ephemeris and 
   the JUICE ephemeris version N.

  \begindata

      FRAME_JUICE_HGRTN             = -28990
      FRAME_-28990_NAME             = 'JUICE_HGRTN' 
      FRAME_-28990_CLASS            =  5
      FRAME_-28990_CLASS_ID         = -28990
      FRAME_-28990_CENTER           =  10
      FRAME_-28990_RELATIVE         = 'J2000'
      FRAME_-28990_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28990_FAMILY           = 'TWO-VECTOR'
      FRAME_-28990_PRI_AXIS         = 'X'
      FRAME_-28990_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28990_PRI_OBSERVER     = 'SUN'
      FRAME_-28990_PRI_TARGET       = 'JUICE'
      FRAME_-28990_PRI_ABCORR       = 'NONE'
      FRAME_-28990_SEC_AXIS         = 'Z'
      FRAME_-28990_SEC_VECTOR_DEF   = 'CONSTANT'
      FRAME_-28990_SEC_FRAME        = 'IAU_SUN'
      FRAME_-28990_SEC_SPEC         = 'RECTANGULAR'
      FRAME_-28990_SEC_VECTOR       = ( 0, 0, 1 )

  \begintext


Sun JUICE Radial-Tangential-Normal (JUICE_SUN_RTN)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, the Sun JUICE Radial-Tangential-Normal
   frame is referred as JUICE_SUN_RTN. In literature, this frame is
   referred as RTN (from [4]), Orbit RTN Coordinate System (from 
   [10]), or radial-transverse-normal (from [5]).
   
   
   Definition:
   -----------
   The Sun JUICE Radial-Tangential-Normal frame is defined as
   follows (from [10]):
   
      -  the position of Sun relative to JUICE is the 
         primary vector: +X axis points from the JUICE to
         Sun;

      -  the normal vector to the orbit plane defines the 
         frame's +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of JUICE.

   All vectors are geometric: no aberration corrections are used.
   
   
   Uses and applications (from [10]):
   ----------------------------------
 
   This frame is used to project the perturbation forces imposed on the
   spacecraft so that the Gauss Lagrange equations can be established
   and the variations of the orbit elements expressed as function
   of the three components of the perturbation acceleration in the
   orbit radial (+X), tangential (+Y) and normal (+Z) axis.
   
   
   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.
   
   The primary vector is defined as an 'observer-target position' 
   vector and the secondary vector is defined as an 'observer-target
   velocity' vector, therefore, the ephemeris data required to compute
   the JUICE-Sun state vector in the J2000 reference frame must be
   loaded before using this frame.
   
   
   Remarks:
   --------
   
   This frame is defined based on SPK data: different planetary
   ephemerides for Jupiter, Jupiter's Barycenter, the Sun, the Solar
   System Barycenter and JUICE spacecraft will lead to different frame
   orientation at a given time.
   
   It is strongly recommended to indicate what data have been used 
   in the evaluation of this frame when referring to it, e.g. 
   JUICE_SUN_RTN using the DE405 ephemeris and the JUICE ephemeris
   version N.
   
  \begindata

      FRAME_JUICE_SUN_RTN           = -28991
      FRAME_-28991_NAME             = 'JUICE_SUN_RTN'
      FRAME_-28991_CLASS            =  5
      FRAME_-28991_CLASS_ID         = -28991
      FRAME_-28991_CENTER           = -28
      FRAME_-28991_RELATIVE         = 'J2000'
      FRAME_-28991_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28991_FAMILY           = 'TWO-VECTOR'
      FRAME_-28991_PRI_AXIS         = 'X'
      FRAME_-28991_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28991_PRI_OBSERVER     = 'JUICE'
      FRAME_-28991_PRI_TARGET       = 'SUN'
      FRAME_-28991_PRI_ABCORR       = 'NONE'
      FRAME_-28991_SEC_AXIS         = 'Y'
      FRAME_-28991_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_VELOCITY'
      FRAME_-28991_SEC_OBSERVER     = 'JUICE'
      FRAME_-28991_SEC_TARGET       = 'SUN'
      FRAME_-28991_SEC_ABCORR       = 'NONE'
      FRAME_-28991_SEC_FRAME        = 'J2000'

  \begintext     


Jupiter JUICE Dipole Meridian (JUICE_JUPITER_DM)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, the Jupiter JUICE Dipole Meridian Frame 
   frame is referred as JUICE_JUPITER_DM. In literature, this frame 
   is referred as Jupiter DM (from [3] and [11]).


   Definition:
   -----------

   The Jupiter JUICE Dipole Meridian frame is defined, based on the
   definition provided in [11] for the Earth's dipole meridian frame,
   as follows:
   
      -  +Z axis is aligned with Jupiter's north magnetic pole;

      -  the Y-axis is chosen to be perpendicular to a radius vector to 
         the point of observation. The positive Y direction is chosen 
         to be eastwards, so that the X-axis is directed outwards from
         Jupiter to JUICE.

      -  the X-axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.
     
   All vectors are geometric: no aberration corrections are used.
   
   
   Uses and applications (from [11]):
   ----------------------------------
 
   It is used to order data controlled by the dipole magnetic field
   where the influence of the solar wind interaction with the
   magnetosphere is weak. It has been used extensively to describe the
   distortions of the magnetospheric field in terms of the two angles
   declination and inclination which can be easily derived from
   measurements in this frame.
   

   Required Data:
   --------------
 
   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.
   
   The primary vector is defined as a constant vector in the 
   JUPITER_MAG_VIP4 body-fixed frame, which provides the 
   orientation for the Jupiter North magnetic dipole and the Jupiter 
   magnetic frame with respect to the IAU_JUPITER body-fixed frame.   
   
   The secondary vector is defined as an 'observer-target position' 
   vector, therefore, the ephemeris data required to compute the 
   Jupiter-JUICE position vector in the J2000 reference frame must be
   loaded before using this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Jupiter, Jupiter's Barycenter and JUICE spacecraft
   will lead to different frame orientation at a given time.
   
   This frame is also defined based on the JUPITER_MAG_VIP4 frame, which
   is defined relative to the IAU_JUPITER frame, whose evaluation is
   based on the data included in the loaded PCK file: different
   orientation constants for Jupiter's spin axis will lead to different
   frame orientation at a given time. 
   
   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUICE_JUPITER_DM using the IAU 2009 constants, the DE405 ephemeris
   and JUICE ephemeris version N.

  \begindata

      FRAME_JUICE_JUPITER_DM        = -28992
      FRAME_-28992_NAME             = 'JUICE_JUPITER_DM'
      FRAME_-28992_CLASS            =  5
      FRAME_-28992_CLASS_ID         = -28992
      FRAME_-28992_CENTER           =  599
      FRAME_-28992_RELATIVE         = 'J2000'
      FRAME_-28992_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28992_FAMILY           = 'TWO-VECTOR'
      FRAME_-28992_PRI_AXIS         = 'Z'
      FRAME_-28992_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_-28992_PRI_FRAME        = 'JUPITER_MAG_VIP4'
      FRAME_-28992_PRI_SPEC         = 'RECTANGULAR'
      FRAME_-28992_PRI_VECTOR       = ( 0, 0, 1 )
      FRAME_-28992_SEC_AXIS         = 'X'
      FRAME_-28992_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28992_SEC_OBSERVER     = 'JUPITER'
      FRAME_-28992_SEC_TARGET       = 'JUICE'
      FRAME_-28992_SEC_ABCORR       = 'NONE'

  \begintext


JUICE Jupiter R-Theta-Phi (JUICE_JUPITER_RTP)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, the JUICE Jupiter R-Theta-Phi frame is
   referred as JUICE_JUPITER_RTP. In literature, this frame is referred
   as Jupiter R-Theta-Phi, R-Theta-Phi or Radial-Down-Corotation ([20]).


   Definition:
   -----------

   The JUICE Jupiter R-Theta-Phi is defined as follows:
   
      -  +X axis is the position of JUICE relative to Jupiter; it is
         the primary vector and points from Jupiter's center to
         center of the spacecraft;

      -  +Y axis is the component of Jupiter's south pole of date
         orthogonal to the +X axis;

      -  +Z axis completes the right-handed system; it is parallel to
         the Jovian equator and positive in the direction of corotation.

      -  the origin of this frame is the center of mass of Jupiter.
     
   All vectors are geometric: no aberration corrections are used.
   
   
   Required Data:
   --------------
 
   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.
   
   The primary vector is defined as an 'observer-target position' 
   vector, therefore, the ephemeris data required to compute the 
   Jupiter-JUICE position vector in the J2000 reference frame must
   be loaded before using this frame.
   
   The secondary vector is defined as a constant vector in the 
   IAU_JUPITER body-fixed frame, which is a PCK-based frame.
   Therefore a PCK file containing the orientation constants for
   Jupiter must be loaded before using this frame.  


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Jupiter, Jupiter Barycenter, and JUICE spacecraft
   will lead to a different frame orientation at a given time.

   This frame is also defined based on the IAU_JUPITER frame, whose
   evaluation is based on the data included in the loaded PCK file:
   different orientation constants for Jupiter's spin axis will lead
   to a different frame orientation at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUICE_JUPITER_RTPU using the IAU 2009 constants, the DE405 ephemeris
   and JUICE ephemeris version N.   

  \begindata

       FRAME_JUICE_JUPITER_RTP      = -28993
       FRAME_-28993_NAME            = 'JUICE_JUPITER_RTP'
       FRAME_-28993_CLASS           =  5
       FRAME_-28993_CLASS_ID        = -28993
       FRAME_-28993_CENTER          =  599
       FRAME_-28993_RELATIVE        = 'J2000'
       FRAME_-28993_DEF_STYLE       = 'PARAMETERIZED'
       FRAME_-28993_FAMILY          = 'TWO-VECTOR'
       FRAME_-28993_PRI_AXIS        = 'X'
       FRAME_-28993_PRI_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
       FRAME_-28993_PRI_OBSERVER    = 'JUPITER'
       FRAME_-28993_PRI_TARGET      = 'JUICE'
       FRAME_-28993_PRI_ABCORR      = 'NONE'
       FRAME_-28993_SEC_AXIS        = 'Y'
       FRAME_-28993_SEC_VECTOR_DEF  = 'CONSTANT'
       FRAME_-28993_SEC_SPEC        = 'RECTANGULAR'
       FRAME_-28993_SEC_VECTOR      = ( 0.0, 0.0, -1.0 )
       FRAME_-28993_SEC_FRAME       = 'IAU_JUPITER'

  \begintext


Jupiter Generic Frame Definitions
------------------------------------------------------------------------------

   This section contains the definition of the Jupiter System generic
   frames.


Jupiter System III Right-handed - IAU 1994 (JUPITER_SYSTEM3RH_1965)
------------------------------------------------------------------------
   
   SPICE frame name, common names and other designators:
   -----------------------------------------------------
 
   Within the SPICE system, the Jupiter System III Right-handed using
   IAU 1994 constants is referred as JUPITER_SYSTEM3RH_1965. In the
   documentation provided by the JUNO team (see [17]), this frame is
   referred as S3RH. Note that in the JUNO S3RH colatitude is used
   instead of latitude.

   
   Definition:
   -----------
 
   The Jupiter System III Right-handed frame is defined as follows
   (from [14]):

      -  +Z axis is parallel to Jupiter rotation axis, pointing 
         toward the North side of the invariable plane;
 
      -  +X axis is aligned with the ascending node of the Jovian 
         orbital plane with the Jovian equator plane;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.


   Remarks:
   --------
 
   This frame is defined as a PCK-based frame, using Jupiter's
   orientation data provided in the IAU 1994 report (see [18]). This
   frame is equivalent to the IAU_JUPITER body-fixed frame, when 
   using pck00006.tpc.  

   The orientation of this frame with respect to the J2000 inertial
   frame is provided using three Euler angles which describe the pole
   and prime meridian location: the first two angles, in order, are
   the right ascension and declination (RA and DEC) of the north pole
   of Jupiter as a function of time. The third angle is the prime
   meridian location (represented by 'PM'), which is expressed as a
   rotation about the north pole, also a function of time.
   
   The time arguments of functions that define orientation always
   refer to Barycentric Dynamical Time (TDB), measured in centuries
   or days past J2000 epoch, which is Julian ephemeris date 2451545.0.
   The time units are ephemeris days for prime meridian motion and
   ephemeris centuries for motion of the pole.
   
   In addition to the north pole and prime meridian location, the
   IAU 1994 report also provides the nutation precession angles for
   Jupiter's Barycenter, which is provided using the ``Nutation
   Precession Angles'' keyword. For further information about the
   nutation models used, please refer to section ``Models for 
   Satellites in Text PCK Kernels'' in [1].

  \begindata
  
      FRAME_JUPITER_SYSTEM3RH_1965   = -28999
      FRAME_-28999_NAME              = 'JUPITER_SYSTEM3RH_1965'
      FRAME_-28999_CLASS             =  2
      FRAME_-28999_CLASS_ID          = -28999
      FRAME_-28999_CENTER            =  599

      BODY-28999_POLE_RA             = (  268.05       -0.009     0. )
      BODY-28999_POLE_DEC            = (   64.49        0.003     0. )
      BODY-28999_PM                  = (  284.95      870.536     0. )
      BODY-28999_LONG_AXIS           = (    0.                       )

      BODY-28999_NUT_PREC_ANGLES     = (    73.32      91472.9
                                            24.62      45137.2
                                           283.90       4850.7
                                           355.80       1191.3
                                           119.90        262.1
                                           229.80         64.3
                                           352.25       2382.6
                                           113.35       6070.0   
                                           146.64     182945.8
                                            49.24      90274.4      )
  
  \begintext
  

Jupiter System III Right-handed - IAU 2009 (JUPITER_SYSTEM3RH_2009)
------------------------------------------------------------------------
   
   SPICE frame name, common names and other designators:
   -----------------------------------------------------
 
   Within the SPICE system, the Jupiter System III Right-handed using
   IAU 2009 constants is referred as JUPITER_SYSTEM3RH_2009. In the
   documentation provided by the JUNO team (see [17]), this frame is
   referred as S3RH. Note that in the JUNO S3RH colatitude is used
   instead of latitude.

   
   Definition:
   -----------
 
   The Jupiter System III Right-handed frame is defined as follows
   (from [14]):

      -  +Z axis is parallel to Jupiter rotation axis, pointing 
         toward the North side of the invariable plane;
 
      -  +X axis is aligned with the ascending node of the Jovian 
         orbital plane with the Jovian equator plane;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.


   Remarks:
   --------
 
   This frame is defined as a PCK-based frame, using Jupiter's
   orientation data provided in the IAU 2009 report (see [19]). This
   frame is equivalent to the IAU_JUPITER body-fixed frame, when 
   using pck00010.tpc.  

   The orientation of this frame with respect to the J2000 inertial
   frame is provided using three Euler angles which describe the pole
   and prime meridian location: the first two angles, in order, are
   the right ascension and declination (RA and DEC) of the north pole
   of Jupiter as a function of time. The third angle is the prime
   meridian location (represented by 'PM'), which is expressed as a
   rotation about the north pole, also a function of time.
   
   The time arguments of functions that define orientation always
   refer to Barycentric Dynamical Time (TDB), measured in centuries
   or days past J2000 epoch, which is Julian ephemeris date 2451545.0.
   The time units are ephemeris days for prime meridian motion and
   ephemeris centuries for motion of the pole.
   
   In addition to the north pole and prime meridian location, the
   IAU 2009 report also provides the nutation precession angles for
   Jupiter's north pole and primer meridian location, and for
   Jupiter's Barycenter. For further information about the
   nutation models used, please refer to section ``Models for 
   Satellites in Text PCK Kernels'' in [1].

  \begindata
  
      FRAME_JUPITER_SYSTEM3RH_2009   = -28998
      FRAME_-28998_NAME              = 'JUPITER_SYSTEM3RH_2009'
      FRAME_-28998_CLASS             =  2
      FRAME_-28998_CLASS_ID          = -28998
      FRAME_-28998_CENTER            =  599

      BODY-28998_POLE_RA             = (  268.056595   -0.006499  0. )
      BODY-28998_POLE_DEC            = (   64.495303    0.002413  0. )
      BODY-28998_PM                  = (  284.95      870.536000  0. )
      BODY-28998_LONG_AXIS           = (    0.                       )
 
      BODY-28998_NUT_PREC_RA         = (  0. 0. 0. 0. 0. 0. 0.
                                                            0.
                                                            0.
                                                            0.
                                                            0.000117
                                                            0.000938
                                                            0.001432
                                                            0.000030
                                                            0.002150 )

      BODY-28998_NUT_PREC_DEC        = (  0. 0. 0. 0. 0. 0. 0.
                                                            0.
                                                            0.
                                                            0.
                                                            0.000050
                                                            0.000404
                                                            0.000617
                                                           -0.000013
                                                            0.000926 )

      BODY-28998_NUT_PREC_PM         = (  0. 0. 0. 0. 0. 0. 0.
                                                            0.
                                                            0.
                                                            0. 
                                                            0.0
                                                            0.0
                                                            0.0
                                                            0.0
                                                            0.0      ) 


      BODY-28998_NUT_PREC_ANGLES     = (    73.32      91472.9
                                            24.62      45137.2
                                           283.90       4850.7
                                           355.80       1191.3
                                           119.90        262.1
                                           229.80         64.3
                                           352.25       2382.6
                                           113.35       6070.0   
                                           146.64     182945.8
                                            49.24      90274.4  
                                            99.360714   4850.4046
                                           175.895369   1191.9605
                                           300.323162    262.5475
                                           114.012305   6070.2476
                                            49.511251     64.3000   )

  \begintext


Jupiter Magnetic System III - VIP4 model (JUPITER_MAG_VIP4)
------------------------------------------------------------------------

   SPICE frame name, common names and other designators:
   -----------------------------------------------------

   Within the SPICE system, the Jupiter Magnetic System III Right-handed
   frame using the VIP4 model is referred as JUPITER_MAG_VIP4. In
   documentation, this frame is commonly referred as Jupiter Magnetic,
   with Magnetic north pole obtained using the VIP4 model (see [16],
   and [17]).


   Definition:
   -----------
 
   The Jupiter Magnetic System III Right-Handed frame is defined as
   follows (from [17]):

      -  +Z axis is parallel to the magnetic dipole axis of epoch and
         aligned with the North magnetic pole of epoch;

      -  +Y axis is defined with respect to the meridian where the
         magnetic and geographic equators cross at longitude 249.2
         degrees in the System III Right-handed frame;

      -  +X completes the right-handed frame;

      -  the origin of this frame is the center of mass of Jupiter.
    
   Required Data:
   --------------

   This frame is defined as a constant rotation with respect to the
   IAU_JUPITER body-fixed frame, which is a PCK-based frame. Therefore,
   a PCK file containing the orientation constants for Jupiter must be
   loaded before using this frame.

    
   Remarks:
   --------
 
   This frame is base on the VIP4 model (see [16]) using as reference
   the System III Right-handed body-fixed frame for Jupiter provided
   in the loaded PCK kernel. The magnetic system rotates with Jupiter
   at the same rate, but about the magnetic dipole instead of the
   Jovian spin axis. 

   The north dipole location is the best-fit, centered dipole magnetic 
   moment vector M direction in the IAU_JUPITER body-fixed frame based
   on the VIP4 model. M is defined to be titled 9.50 degrees away from
   the Jovian spin axis towards longitude 200.8 degrees West, therefore,
   the current values for the Jupiter north magnetic centered dipole
   planetocentric coordinates are:
      
      Longitude    =  159.2 (degrees)
      Latitude     =   80.5 (degrees)

   This frame is provided as the ``most generic'' Jupiter Magnetic
   System III Right-handed frame since the user has the possibility of
   loading different Jupiter orientation constants that would help to
   define different implementations of this frame.
   
   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUPITER_MAG_VIP4 using the IAU 2009 constants.

  \begindata

      FRAME_JUPITER_MAG_VIP4     = -28997
      FRAME_-28997_NAME          = 'JUPITER_MAG_VIP4'
      FRAME_-28997_CLASS         =  4
      FRAME_-28997_CLASS_ID      = -28997
      FRAME_-28997_CENTER        =  599 
      TKFRAME_-28997_SPEC        = 'ANGLES'
      TKFRAME_-28997_RELATIVE    = 'IAU_JUPITER'
      TKFRAME_-28997_ANGLES      = ( 0, -159.2, -9.5 )
      TKFRAME_-28997_AXES        = ( 2,      3,    2 )
      TKFRAME_-28997_UNITS       = 'DEGREES'

  \begintext


Jupiter Mean Equator of Date Frame (JUPITER_MEQUD)
------------------------------------------------------------------------

   Definition:
   -----------

   The Jupiter mean equator of date frame is defined as follows:

      -  X-Y plane is defined by Jupiter equator of date, with
         the +Z axis, the primary vector, parallel to Jupiter rotation
         axis of date, pointing toward the North side of the
         invariable plane;

      -  +X axis is the component of the ascending node of Jupiter
         equator of date on the Earth Mean Equator of J2000
         orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using constant vectors
   as the specification method.

   The primary vector is defined as a constant vector in the
   IAU_JUPITER body-fixed frame, which is a PCK-based frame. Therefore,
   a PCK file containing the orientation constants for Jupiter must be
   loaded before using this frame.

   The secondary vector is defined in the J2000 reference frame and
   therefore it does not require any additional data.


   Remarks:
   --------

   This frame is defined based on the IAU_JUPITER frame, whose
   evaluation is based on the data included in the loaded PCK file:
   different orientation constants for the spin axis of Jupiter will
   lead to a different frame orientation at a given time.

   This frame is provided as the ``most generic'' Jupiter mean
   equator of date frame since the user has the possibility of loading
   different Jupiter orientation constants that would help to
   define different implementations of this frame.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUPITER_MEQUD using the IAU 2009 constants.

  \begindata

      FRAME_JUPITER_MEQUD              =  500599000
      FRAME_500599000_NAME             = 'JUPITER_MEQUD'
      FRAME_500599000_CLASS            =  5
      FRAME_500599000_CLASS_ID         =  500599000
      FRAME_500599000_CENTER           =  599
      FRAME_500599000_RELATIVE         = 'J2000'
      FRAME_500599000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_500599000_FAMILY           = 'TWO-VECTOR'
      FRAME_500599000_PRI_AXIS         = 'Z'
      FRAME_500599000_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_500599000_PRI_FRAME        = 'IAU_JUPITER'
      FRAME_500599000_PRI_SPEC         = 'RECTANGULAR'
      FRAME_500599000_PRI_VECTOR       = ( 0, 0, 1 )
      FRAME_500599000_SEC_AXIS         = 'Y'
      FRAME_500599000_SEC_VECTOR_DEF   = 'CONSTANT'
      FRAME_500599000_SEC_FRAME        = 'J2000'
      FRAME_500599000_SEC_SPEC         = 'RECTANGULAR'
      FRAME_500599000_SEC_VECTOR       = ( 0, 0, 1 )

  \begintext


Jupiter Solar Equatorial Frame (JUPITER_SUN_EQU)
------------------------------------------------------------------------

   Definition:
   -----------

   The Jupiter solar equatorial frame is defined, based on the
   definition provided in [15] for the solar equatorial
   frame, as follows:

      -  +X axis is the position of the Sun relative to Jupiter;
         it's the primary vector and points from Jupiter to the Sun;

      -  +Z axis is the component of the Sun's north pole of date
         orthogonal to the +X axis;

      -  +Y axis completes the right-handed reference frame;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position'
   vector. Therefore, the ephemeris data required to compute the
   Jupiter-Sun vector in the J2000 reference frame must be loaded before
   using this frame.

   The primary vector is defined as a constant vector in the IAU_SUN
   frame, which is a PCK-based frame. Therefore a PCK file containing
   the orientation constants for the Sun must be loaded before using
   this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Jupiter, Jupiter Barycenter, the Sun and the Solar
   System Barycenter will lead to a different frame orientation at a
   given time.

   This frame is also defined based on the IAU_SUN frame, whose
   evaluation is based on the data included in the loaded PCK file:
   different orientation constants for the Sun's spin axis will lead
   to a different frame orientation at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUPITER_SUN_EQU using the IAU 2009 constants and the DE405 ephemeris.

  \begindata

      FRAME_JUPITER_SUN_EQU            =  500599001
      FRAME_500599001_NAME             = 'JUPITER_SUN_EQU'
      FRAME_500599001_CLASS            =  5
      FRAME_500599001_CLASS_ID         =  500599001
      FRAME_500599001_CENTER           =  599
      FRAME_500599001_RELATIVE         = 'J2000'
      FRAME_500599001_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_500599001_FAMILY           = 'TWO-VECTOR'
      FRAME_500599001_PRI_AXIS         = 'X'
      FRAME_500599001_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_500599001_PRI_OBSERVER     = 'JUPITER'
      FRAME_500599001_PRI_TARGET       = 'SUN'
      FRAME_500599001_PRI_ABCORR       = 'NONE'
      FRAME_500599001_SEC_AXIS         = 'Z'
      FRAME_500599001_SEC_VECTOR_DEF   = 'CONSTANT'
      FRAME_500599001_SEC_FRAME        = 'IAU_SUN'
      FRAME_500599001_SEC_SPEC         = 'RECTANGULAR'
      FRAME_500599001_SEC_VECTOR       = ( 0, 0, 1 )

  \begintext


Jupiter Orbital Frame (JUPITER_SUN_ORB)
------------------------------------------------------------------------

   Definition:
   -----------

   The Jupiter orbital frame is defined as follows:

      -  +X axis is the position of the Sun relative to Jupiter; it's
         the primary vector and points from Jupiter to Sun;

      -  +Y axis is the component of the inertially referenced
         velocity of Sun relative to Jupiter orthogonal to the +X axis;

      -  +Z axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' 
   vector and the secondary vector is defined as an 'observer-target
   velocity' vector, therefore, the ephemeris data required to compute
   the Jupiter-Sun state vector in the J2000 reference frame must be
   loaded before using this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Jupiter, Sun and the Sun Barycenter
   will lead to a different frame orientation at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUPITER_SUN_ORB using the DE405 ephemeris.

  \begindata

      FRAME_JUPITER_SUN_ORB            =  500599002
      FRAME_500599002_NAME             = 'JUPITER_SUN_ORB'
      FRAME_500599002_CLASS            =  5
      FRAME_500599002_CLASS_ID         =  500599002
      FRAME_500599002_CENTER           =  599
      FRAME_500599002_RELATIVE         = 'J2000'
      FRAME_500599002_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_500599002_FAMILY           = 'TWO-VECTOR'
      FRAME_500599002_PRI_AXIS         = 'X'
      FRAME_500599002_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_500599002_PRI_OBSERVER     = 'JUPITER'
      FRAME_500599002_PRI_TARGET       = 'SUN'
      FRAME_500599002_PRI_ABCORR       = 'NONE'
      FRAME_500599002_SEC_AXIS         = 'Y'
      FRAME_500599002_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_VELOCITY'
      FRAME_500599002_SEC_OBSERVER     = 'JUPITER'
      FRAME_500599002_SEC_TARGET       = 'SUN'
      FRAME_500599002_SEC_ABCORR       = 'NONE'
      FRAME_500599002_SEC_FRAME        = 'J2000'

  \begintext


Jupiter-Centric Callisto-Following Frame (JUPITER_CALLISTO_BCSF)
------------------------------------------------------------------------

   Definition:
   -----------

   The Jupiter-centric Callisto-following frame is defined as
   follows:

      -  X-Y plane is defined by the Jupiter's orbital plane
         of date with the +Z axis, the primary vector and the normal
         vector to this plane, always pointing toward the north
         side of the invariable plane;

      -  +X axis is the component of the position of Callisto relative
         to Jupiter that is orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   The frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the
   JUPITER_SUN_ORB (Jupiter orbital) frame, which is a dynamic
   frame. Therefore, the data required to evaluate that base frame
   at the requested epoch must be loaded before using this frame.

   The secondary vector is defined as an 'observer-target position'
   vector. Therefore, the ephemeris data required to compute the
   Jupiter-Callisto vector in the J2000 reference frame must be loaded
   before using this frame.


   Remarks:
   --------

   SPICE imposes a constraint in the definition of dynamic frames
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.

   This frame is defined based on SPK data: different planetary
   ephemerides for Callisto, Jupiter, Jupiter Barycenter, the Sun
   and the Solar System will lead to a different frame orientation
   at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUPITER_CALLISTO_BCSF using the DE405 ephemeris.

  \begindata

      FRAME_JUPITER_CALLISTO_BCSF      =  500599006
      FRAME_500599006_NAME             = 'JUPITER_CALLISTO_BCSF'
      FRAME_500599006_CLASS            =  5
      FRAME_500599006_CLASS_ID         =  500599006
      FRAME_500599006_CENTER           =  599
      FRAME_500599006_RELATIVE         = 'J2000'
      FRAME_500599006_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_500599006_FAMILY           = 'TWO-VECTOR'
      FRAME_500599006_PRI_AXIS         = 'Z'
      FRAME_500599006_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_500599006_PRI_FRAME        = 'JUPITER_SUN_ORB'
      FRAME_500599006_PRI_SPEC         = 'RECTANGULAR'
      FRAME_500599006_PRI_VECTOR       = ( 0, 0, 1 )
      FRAME_500599006_SEC_AXIS         = 'X'
      FRAME_500599006_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_500599006_SEC_OBSERVER     = 'JUPITER'
      FRAME_500599006_SEC_TARGET       = 'CALLISTO'
      FRAME_500599006_SEC_ABCORR       = 'NONE'

  \begintext


Jupiter-Centric Europa-Following Frame (JUPITER_EUROPA_BCSF)
------------------------------------------------------------------------

   Definition:
   -----------

   The Jupiter-centric Europa-following frame is defined as follows:

      -  X-Y plane is defined by the Jupiter's orbital plane
         of date with the +Z axis, the primary vector and the normal
         vector to this plane, always pointing toward the north
         side of the invariable plane;

      -  +X axis is the component of the position of Europa relative
         to Jupiter that is orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   The frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the
   JUPITER_SUN_ORB (Jupiter orbital) frame, which is a dynamic
   frame. Therefore, the data required to evaluate that base frame
   at the requested epoch must be loaded before using this frame.

   The secondary vector is defined as an 'observer-target position'
   vector. Therefore, the ephemeris data required to compute the
   Europa-Jupiter vector in the J2000 reference frame must be loaded
   before using this frame.


   Remarks:
   --------

   SPICE imposes a constraint in the definition of dynamic frames
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.

   This frame is defined based on SPK data: different planetary
   ephemerides for Europa, Jupiter, Jupiter Barycenter, the Sun
   and the Solar System will lead to a different frame orientation
   at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUPITER_EUROPA_BCSF using the DE405 ephemeris.

  \begindata

      FRAME_JUPITER_EUROPA_BCSF        =  500599004
      FRAME_500599004_NAME             = 'JUPITER_EUROPA_BCSF'
      FRAME_500599004_CLASS            =  5
      FRAME_500599004_CLASS_ID         =  500599004
      FRAME_500599004_CENTER           =  599
      FRAME_500599004_RELATIVE         = 'J2000'
      FRAME_500599004_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_500599004_FAMILY           = 'TWO-VECTOR'
      FRAME_500599004_PRI_AXIS         = 'Z'
      FRAME_500599004_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_500599004_PRI_FRAME        = 'JUPITER_SUN_ORB'
      FRAME_500599004_PRI_SPEC         = 'RECTANGULAR'
      FRAME_500599004_PRI_VECTOR       = ( 0, 0, 1 )
      FRAME_500599004_SEC_AXIS         = 'X'
      FRAME_500599004_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_500599004_SEC_OBSERVER     = 'JUPITER'
      FRAME_500599004_SEC_TARGET       = 'EUROPA'
      FRAME_500599004_SEC_ABCORR       = 'NONE'

  \begintext


Jupiter-Centric Ganymede-Following Frame (JUPITER_GANYMEDE_BCSF)
------------------------------------------------------------------------

   Definition:
   -----------

   The Jupiter-centric Ganymede-following frame is defined as follows:

      -  X-Y plane is defined by the Jupiter's orbital plane
         of date with the +Z axis, the primary vector and the normal
         vector to this plane, always pointing toward the north
         side of the invariable plane;

      -  +X axis is the component of the position of Ganymede relative
         to Jupiter that is orthogonal to the +Z axis;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Jupiter.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   The frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the
   JUPITER_SUN_ORB (Jupiter orbital) frame, which is a dynamic
   frame. Therefore, the data required to evaluate that base frame
   at the requested epoch must be loaded before using this frame.

   The secondary vector is defined as an 'observer-target position'
   vector. Therefore, the ephemeris data required to compute the
   Ganymede-Jupiter vector in the J2000 reference frame must be loaded
   before using this frame.


   Remarks:
   --------

   SPICE imposes a constraint in the definition of dynamic frames
   (see [1]):

      When the definition of a parameterized dynamic frame F1 refers to
      a second frame F2 the referenced frame F2 may be dynamic, but F2
      must not make reference to any dynamic frame.

   Therefore, no other dynamic frame should make reference to this
   frame.

   This frame is defined based on SPK data: different planetary
   ephemerides for Ganymede, Jupiter, Jupiter Barycenter, the Sun
   and the Solar System will lead to a different frame orientation
   at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   JUPITER_GANYMEDE_BCSF using the DE405 ephemeris.

  \begindata

      FRAME_JUPITER_GANYMEDE_BCSF      =  500599005
      FRAME_500599005_NAME             = 'JUPITER_GANYMEDE_BCSF'
      FRAME_500599005_CLASS            =  5
      FRAME_500599005_CLASS_ID         =  500599005
      FRAME_500599005_CENTER           =  599
      FRAME_500599005_RELATIVE         = 'J2000'
      FRAME_500599005_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_500599005_FAMILY           = 'TWO-VECTOR'
      FRAME_500599005_PRI_AXIS         = 'Z'
      FRAME_500599005_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_500599005_PRI_FRAME        = 'JUPITER_SUN_ORB'
      FRAME_500599005_PRI_SPEC         = 'RECTANGULAR'
      FRAME_500599005_PRI_VECTOR       = ( 0, 0, 1 )
      FRAME_500599005_SEC_AXIS         = 'X'
      FRAME_500599005_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_500599005_SEC_OBSERVER     = 'JUPITER'
      FRAME_500599005_SEC_TARGET       = 'GANYMEDE'
      FRAME_500599005_SEC_ABCORR       = 'NONE'

  \begintext


Callisto Orbital Frame (CALLISTO_JUPITER_ORB)
------------------------------------------------------------------------

   Definition:
   -----------

   The Callisto orbital frame is defined as follows:

      -  +X axis is the position of the Jupiter relative to Callisto;
         it's the primary vector and points from Callisto to Jupiter;

      -  +Y axis is the component of the inertially referenced
         velocity of Jupiter relative to Callisto orthogonal
         to the +X axis;

      -  +Z axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Callisto.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' 
   vector and the secondary vector is defined as an 'observer-target
   velocity' vector, therefore, the ephemeris data required to compute
   the Callisto-Jupiter state vector in the J2000 reference frame must
   be loaded before using this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Callisto, Jupiter and the Jupiter Barycenter
   will lead to a different frame orientation at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   CALLISTO_JUPITER_ORB using the DE405 ephemeris.

  \begindata

      FRAME_CALLISTO_JUPITER_ORB       =  500504000
      FRAME_500504000_NAME             = 'CALLISTO_JUPITER_ORB'
      FRAME_500504000_CLASS            =  5
      FRAME_500504000_CLASS_ID         =  500504000
      FRAME_500504000_CENTER           =  504
      FRAME_500504000_RELATIVE         = 'J2000'
      FRAME_500504000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_500504000_FAMILY           = 'TWO-VECTOR'
      FRAME_500504000_PRI_AXIS         = 'X'
      FRAME_500504000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_500504000_PRI_OBSERVER     = 'CALLISTO'
      FRAME_500504000_PRI_TARGET       = 'JUPITER'
      FRAME_500504000_PRI_ABCORR       = 'NONE'
      FRAME_500504000_SEC_AXIS         = 'Y'
      FRAME_500504000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_VELOCITY'
      FRAME_500504000_SEC_OBSERVER     = 'CALLISTO'
      FRAME_500504000_SEC_TARGET       = 'JUPITER'
      FRAME_500504000_SEC_ABCORR       = 'NONE'
      FRAME_500504000_SEC_FRAME        = 'J2000'

  \begintext


Europa Orbital Frame (EUROPA_JUPITER_ORB)
------------------------------------------------------------------------

   Definition:
   -----------

   The Europa orbital frame is defined as follows:

      -  +X axis is the position of the Jupiter relative to
         Europa; it's the primary vector and points
         from Europa to Jupiter;

      -  +Y axis is the component of the inertially referenced
         velocity of Jupiter relative to Europa orthogonal
         to the +X axis;

      -  +Z axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Europa.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' 
   vector and the secondary vector is defined as an 'observer-target
   velocity' vector, therefore, the ephemeris data required to compute
   the Europa-Jupiter state vector in the J2000 reference frame must
   be loaded before using this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Europa, Jupiter and the Jupiter Barycenter
   will lead to a different frame orientation at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   EUROPA_JUPITER_ORB using the DE405 ephemeris.

  \begindata

      FRAME_EUROPA_JUPITER_ORB         =  500502000
      FRAME_500502000_NAME             = 'EUROPA_JUPITER_ORB'
      FRAME_500502000_CLASS            =  5
      FRAME_500502000_CLASS_ID         =  500502000
      FRAME_500502000_CENTER           =  502
      FRAME_500502000_RELATIVE         = 'J2000'
      FRAME_500502000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_500502000_FAMILY           = 'TWO-VECTOR'
      FRAME_500502000_PRI_AXIS         = 'X'
      FRAME_500502000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_500502000_PRI_OBSERVER     = 'EUROPA'
      FRAME_500502000_PRI_TARGET       = 'JUPITER'
      FRAME_500502000_PRI_ABCORR       = 'NONE'
      FRAME_500502000_SEC_AXIS         = 'Y'
      FRAME_500502000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_VELOCITY'
      FRAME_500502000_SEC_OBSERVER     = 'EUROPA'
      FRAME_500502000_SEC_TARGET       = 'JUPITER'
      FRAME_500502000_SEC_ABCORR       = 'NONE'
      FRAME_500502000_SEC_FRAME        = 'J2000'

  \begintext


Ganymede Orbital Frame (GANYMEDE_JUPITER_ORB)
------------------------------------------------------------------------

   Definition:
   -----------

   The Ganymede orbital frame is defined as follows:

      -  +X axis is the position of the Jupiter relative to
         Ganymede; it's the primary vector and points
         from Ganymede to Jupiter;

      -  +Y axis is the component of the inertially referenced
         velocity of Jupiter relative to Ganymede orthogonal
         to the +X axis;

      -  +Z axis completes the right-handed system;

      -  the origin of this frame is the center of mass of Ganymede.

   All vectors are geometric: no aberration corrections are used.


   Required Data:
   --------------

   This frame is defined as a two-vector frame using two different
   types of specifications for the primary and secondary vectors.

   The primary vector is defined as an 'observer-target position' 
   vector and the secondary vector is defined as an 'observer-target
   velocity' vector, therefore, the ephemeris data required to compute
   the Ganymede-Jupiter state vector in the J2000 reference frame must
   be loaded before using this frame.


   Remarks:
   --------

   This frame is defined based on SPK data: different planetary
   ephemerides for Ganymede, Jupiter and the Jupiter Barycenter
   will lead to a different frame orientation at a given time.

   It is strongly recommended to indicate what data have been used
   in the evaluation of this frame when referring to it, e.g.
   GANYMEDE_JUPITER_ORB using the DE405 ephemeris.

  \begindata

      FRAME_GANYMEDE_JUPITER_ORB       =  500503000
      FRAME_500503000_NAME             = 'GANYMEDE_JUPITER_ORB'
      FRAME_500503000_CLASS            =  5
      FRAME_500503000_CLASS_ID         =  500503000
      FRAME_500503000_CENTER           =  503
      FRAME_500503000_RELATIVE         = 'J2000'
      FRAME_500503000_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_500503000_FAMILY           = 'TWO-VECTOR'
      FRAME_500503000_PRI_AXIS         = 'X'
      FRAME_500503000_PRI_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_500503000_PRI_OBSERVER     = 'GANYMEDE'
      FRAME_500503000_PRI_TARGET       = 'JUPITER'
      FRAME_500503000_PRI_ABCORR       = 'NONE'
      FRAME_500503000_SEC_AXIS         = 'Y'
      FRAME_500503000_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_VELOCITY'
      FRAME_500503000_SEC_OBSERVER     = 'GANYMEDE'
      FRAME_500503000_SEC_TARGET       = 'JUPITER'
      FRAME_500503000_SEC_ABCORR       = 'NONE'
      FRAME_500503000_SEC_FRAME        = 'J2000'

  \begintext
