#!/bin/csh
#
#  This script creates complete PDS directory structure with zero-size
#  file placeholders for all generic meta-info/aareadme files in the 
#  locations and with the names they should have on an actual PDS SPICE
#  data set.
#
#  Usage:
#
#     % make_pds_directories.csh <directory_name>
#
#  where 
#
#     directory_name    is the name of the directory under which PDS SPICE
#                       directory tree will be created. This must be 
#                       name of non-existing directory.
#
#  BVS/NAIF  May 24, 2007
#
#     Added extras, its subdirectories and .txt files.
#
#  BVS/NAIF  Jan 18, 2006
#
#     Added spice_hsk.cat, spice_inst.cat and release.cat to the list of zero-size 
#     placeholder files that are being made.
#
#  LSE/NAIF  Sept 3, 2002
#
#     Directory/file names changed to lower case.  UNTESTED.
#
#  BVS/NAIF, January 3, 2000
#
#     Script was updated to create directories with uppercase names
#     and to reduce number of DS files (SPICEDS.CAT instead of many.)
#
#  BVS/NAIF, April 26, 1999
#

#
#  Get command line argument
#
if ( $#argv != 1 ) then 
   echo " "
   echo "Usage: % make_pds_directories.csh <directory_name> "
   echo " "
   exit
else
   set TOPDIR = $1
endif

#
#  Check whether provided directory already exists.
#
if ( -e $TOPDIR ) then 
   echo " "
   echo "ERROR: Directory '$TOPDIR' specified on the command line already exists."
   echo " "
   exit
endif

#
#  Create top level directory.
#
mkdir $TOPDIR
if ( ! $status == 0 ) then
   echo " "
   echo "ERROR: Couldn't create directory '$TOPDIR'."
   echo " "
   exit
endif

#
#  Create complete PDS directory structure.
#
mkdir $TOPDIR/catalog
mkdir $TOPDIR/data
mkdir $TOPDIR/data/ck
mkdir $TOPDIR/data/ek
mkdir $TOPDIR/data/fk
mkdir $TOPDIR/data/ik
mkdir $TOPDIR/data/lsk
mkdir $TOPDIR/data/pck
mkdir $TOPDIR/data/sclk
mkdir $TOPDIR/data/spk
mkdir $TOPDIR/document
mkdir $TOPDIR/extras
mkdir $TOPDIR/extras/mk
mkdir $TOPDIR/extras/orbnum
mkdir $TOPDIR/index
mkdir $TOPDIR/software

#
#  Create complete set of meta-data/aareadme placeholder files.
#
touch $TOPDIR/aareadme.txt
touch $TOPDIR/aareadme.htm
touch $TOPDIR/aareadme.lbl
touch $TOPDIR/voldesc.cat
touch $TOPDIR/errata.txt
touch $TOPDIR/catalog/catinfo.txt
touch $TOPDIR/catalog/spiceds.cat
touch $TOPDIR/catalog/ref.cat
touch $TOPDIR/catalog/insthost.cat
touch $TOPDIR/catalog/mission.cat
touch $TOPDIR/catalog/person.cat
touch $TOPDIR/catalog/spice_hsk.cat
touch $TOPDIR/catalog/spice_inst.cat
touch $TOPDIR/catalog/release.cat
touch $TOPDIR/data/ck/ckinfo.txt
touch $TOPDIR/data/ek/ekinfo.txt
touch $TOPDIR/data/fk/fkinfo.txt
touch $TOPDIR/data/ik/ikinfo.txt
touch $TOPDIR/data/lsk/lskinfo.txt
touch $TOPDIR/data/pck/pckinfo.txt
touch $TOPDIR/data/sclk/sclkinfo.txt
touch $TOPDIR/data/spk/spkinfo.txt
touch $TOPDIR/document/docinfo.txt
touch $TOPDIR/document/lblinfo.txt
touch $TOPDIR/document/onlabels.txt
touch $TOPDIR/extras/extrinfo.txt
touch $TOPDIR/extras/mk/mkinfo.txt
touch $TOPDIR/extras/orbnum/orbinfo.txt
touch $TOPDIR/index/indxinfo.txt
touch $TOPDIR/index/index.tab
touch $TOPDIR/index/index.lbl
touch $TOPDIR/software/softinfo.txt

#
#  Display listing of created directories/placeholders.
#
echo " "
echo "-----------------------------------------------------------------"
echo " "
echo "The following directory sctructure/placeholder files were created"
echo "under $TOPDIR :"
echo " "
echo "-----------------------------------------------------------------"
echo " "

ls -lFR $TOPDIR

echo " "
echo "-----------------------------------------------------------------"
echo " "

