import glob
import os
import fnmatch
from arcgen.utils.files import is_empty_file
from arcgen.utils.files import has_badchars
from arcgen.utils.files import exceeds_line_lengths
from arcgen.tests.utils.skd_validator import KERNEL_EXTENSIONS
from arcgen.tests.utils.skd_validator import is_valid_kernel

BUNDLE_PATH = "/home/rvalles/spice/arcgenOutput/bc_spice/001/bc_spice"

IGNORE_FILES = ["earth_??????_*.bpc",
                "gm_de431.tpc",
                "pck00010.tpc",
                "de403_masses.tpc",
                "earth*.tf",
                "*_2021????_2021????_s????????_v??.bc"]

SHOW_ALL_FILES = False
CHECK_LINE_LENGTHS = True

DOC_EXTENSIONS = [".txt", ".csv", ".xml", ".html"]
LONG_LINE_EXTENSIONS = [".csv", ".xml", ".html"]
IGNORE_EXTENSIONS = [".tar"]
CHECK_EXTENSIONS = DOC_EXTENSIONS + KERNEL_EXTENSIONS


def is_valid_doc_file(filename):

    if is_empty_file(filename):
        print("ERROR!! - EMPTY FILE: " + filename)
        return False

    if has_badchars(filename):
        print("ERROR!! - HAS BAD CHARS: " + filename)
        return False

    extension = str(os.path.splitext(filename)[1]).lower()
    if CHECK_LINE_LENGTHS and not extension in LONG_LINE_EXTENSIONS:
        if exceeds_line_lengths(filename):
            print("ERROR!! - EXCEEDS LINE LENGTH: " + filename)
            return False

    # TODO: Continue implementation

    return True


def is_an_ingnore_file(file_path):

    filename = os.path.basename(file_path)

    for ignore_pattern in IGNORE_FILES:
        if fnmatch.fnmatch(filename, ignore_pattern):
            return True

    return False


def validate_pds4(bundle_path):

    bundle_files = list(glob.iglob(bundle_path + '/**/*', recursive=True))

    all_files_are_valid = True

    # Check contents file by file
    for filename in bundle_files:

        if not os.path.isdir(filename)\
           and not is_an_ingnore_file(filename):

            extension = str(os.path.splitext(filename)[1]).lower()
            if extension in CHECK_EXTENSIONS:

                # CHECK IF IS A DOC FILE
                if extension in DOC_EXTENSIONS:

                    if not is_valid_doc_file(filename):
                        all_files_are_valid = False
                        print("")
                        continue

                elif extension in KERNEL_EXTENSIONS:

                    if not is_valid_kernel(filename, CHECK_LINE_LENGTHS):
                        all_files_are_valid = False
                        print("")
                        continue

                if SHOW_ALL_FILES:
                    print("OK: " + filename)

            elif extension not in IGNORE_EXTENSIONS:

                print("ERROR!! - NOT SUPPORTED: " + filename)
                print("")
                all_files_are_valid = False

    # SHOW RESULTS
    if all_files_are_valid:
        print("")
        print("=============================================================")
        print("==========           BUNDLE IS VALID!!!!            =========")
        print("=============================================================")
    else:
        print("")
        print("=============================================================")
        print("==========             NOT VALID BUNDLE             =========")
        print("=============================================================")


##################################################################################################

validate_pds4(BUNDLE_PATH)

##################################################################################################