import os
import logging

from glob import glob
from bs4 import BeautifulSoup


def transfer(bundle, start_dir='', out_dir='.'):

    logging.info("Generating transfer file for bundle: " + bundle)

    if not start_dir:
        start_dir = os.getcwd()

    labels = []
    pattern = "*.xml"

    for dir, _, _ in os.walk(start_dir):
        labels.extend(glob(os.path.join(dir, pattern)))
    labels.sort()

    lidvids = []
    paths = []
    for label in labels:
        with open(label, "r") as xml:
            soup = BeautifulSoup(xml, features="html.parser")
            lid = soup.find('logical_identifier').string
            vid = soup.find('version_id').string

            lidvids.append('{}::{}'.format(lid, vid))
            paths.append('./'+label.split(bundle+'/')[-1])

    if len(lidvids):
        width = len(max(lidvids, key=len)) + 1

        transfer_file = '{}/{}.transfer'.format(out_dir, bundle)

        logging.info("Writing transfer file: " + transfer_file + " with "
                     + str(len(lidvids)) + " lidvids")

        with open(transfer_file, "w+") as f:
            for lidvid, path in zip(lidvids, paths):
                lidvid = lidvid.ljust(width)
                f.write('{} {}\n'.format(lidvid, path))

    return


def checksum():

    return