
import glob
import os


kernels_dir = "/home/rvalles/spice/kernels/bepicolombo/kernels/spk"
extension = ".bsp"
meta_kernels = ["/home/rvalles/spice/kernels/bepicolombo/kernels/mk/bc_ops_local.tm"]

# List all files
files = list(glob.iglob(kernels_dir + '/*' + extension, recursive=False))

replaced_kernels = {}

# FOR EACH KERNEL GET LATEST TXT AND UPDATE ITS COMMENTS AND VERSION
for filename in files:

    print(filename)

    # Find related txt files
    filename_no_version = os.path.basename(filename).replace(extension, "")
    filename_no_version = filename_no_version[0:len(filename_no_version) - 2]

    txts = list(glob.iglob(kernels_dir + '/' + filename_no_version + "??.txt", recursive=False))
    txts = sorted(txts)

    if len(txts) > 1:
        last_txt = txts[-1]

        last_version = last_txt.replace(".txt", "")
        last_version = last_version[len(last_version) - 2: len(last_version)]

        new_filename = kernels_dir + '/' + filename_no_version + last_version + extension
        print(new_filename)

        os.system("cp " + filename + " " + new_filename)
        os.system("commnt -d " + new_filename)
        os.system("commnt -a " + new_filename + " " + last_txt)
        os.system("rm " + filename)

        replaced_kernels[os.path.basename(filename)] = os.path.basename(new_filename)

    for txt in txts:
        os.system("rm " + txt)

    print("")

# UPDATE METAKERNELS
for mk in meta_kernels:

    temp_mk = mk.replace(".tm", ".temp")
    any_replacement_done = False
    with open(mk, 'r') as f:
        with open(temp_mk, 'w+') as t:
            for line in f:
                if "$KERNELS" in line:
                    for kernel in replaced_kernels:
                        if kernel in line:
                            line = line.replace(kernel, replaced_kernels[kernel])
                            any_replacement_done = True

                t.write(line)

    if any_replacement_done:
        os.system("rm " + mk)
        os.system("mv " + temp_mk + " " + mk)
        print("METAKERNEL UPDATED: " + mk)
    else:
        os.system("rm " + temp_mk)
