C$Procedure      CLFURN ( command line furnish )
 
      SUBROUTINE CLFURN ( CMLINE )
 
C$ Abstract
C
C     Look for the substring '-furnish <filename> on the command line
C     and do it.  Removing the furnish instruction from the string.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     UTILITY
C
C$ Declarations
 
      IMPLICIT NONE
      CHARACTER*(*)         CMLINE
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     CMLINE    I/O  String to examine for the template -furnish file
C
C$ Detailed_Input
C
C     CMLINE    On input, is a string (usually obtained from GETCML,
C               that may or may not have the command -furnish file.
C
C               Note that the case of -furnish is not significant
C
C$ Detailed_Output
C
C     CMLINE    Input string with the substring -furnish file removed.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     None.
C
C$ Particulars
C
C     This is utility that makes it easier to get kernel data into
C     your program using a standard interface.
C
C$ Examples
C
C     CALL GETCML ( LINE )
C     CALL CLFURN ( LINE )
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 16-MAR-2000 (WLT)
C
C
C-&
 
C$ Index_Entries
C
C     Furnish kernels from the command line.
C
C-&
C
C     SPICELIB Functions
C
      LOGICAL               EQSTR
      LOGICAL               RETURN
 
 
C
C     Local Variables
C
      INTEGER               START
      INTEGER               B
      INTEGER               E
      INTEGER               FB
      INTEGER               FE
C
C     Standard SPICE error handling.
C
      IF ( RETURN() ) THEN
         RETURN
      END IF
 
      CALL CHKIN ( 'CLFURN')
 
      START = 1
      B     = 1
      CALL FNDNWD ( CMLINE, START, B, E )
 
      DO WHILE ( B .NE. 0 )
 
         IF ( EQSTR( CMLINE(B:E), '-FURNISH' ) ) THEN
 
            START = E + 1
            CALL FNDNWD ( CMLINE, START, FB, FE )
 
            IF ( FB .NE. 0 ) THEN
               CALL FURNSH ( CMLINE(FB:FE) )
               CMLINE      ( B:FE ) = ' '
            END IF
            CALL CHKOUT ( 'CLFURN' )
            RETURN
 
         END IF
 
         START = E + 1
         CALL FNDNWD ( CMLINE, START, B, E )
      END DO
 
      CALL CHKOUT ( 'CLFURN' )
      RETURN
      END
