#!/bin/tcsh

#
# This script fixes s/c name and data set id and gets rid of 
# data set name.
#

cd /usr1/rosetta/RO_RL-E_M_A_C-SPICE-6-V1.0

foreach PAIR ( \
"RO    DATA/CK/ATNR_P040302093352_00046.LBL" \
"RO    DATA/CK/ATNR_P040302093352_00096.LBL" \
"RO    DATA/CK/ATNR_P040302093352_00109.LBL" \
"RO    DATA/CK/ATNR_P040302093352_00127.LBL" \
"RO_RL DATA/CK/CATT_DV_145_01_______00216.LBL" \
"RO    DATA/CK/RATT_DV_145_01_01____00216.LBL" \
"RO    DATA/CK/ROS_HGA_2004_V0001.LBL" \
"RO    DATA/CK/ROS_HGA_2005_V0001.LBL" \
"RO    DATA/CK/ROS_HGA_2006_V0001.LBL" \
"RO    DATA/CK/ROS_HGA_2007_V0001.LBL" \
"RO    DATA/CK/ROS_HGA_2008_V0018.LBL" \
"RO    DATA/CK/ROS_HGA_2008_V0019.LBL" \
"RO    DATA/CK/ROS_HGA_2009_V0051.LBL" \
"RO    DATA/CK/ROS_HGA_2009_V0052.LBL" \
"RO    DATA/CK/ROS_HGA_2010_V0042.LBL" \
"RO    DATA/CK/ROS_HGA_2010_V0046.LBL" \
"RO    DATA/CK/ROS_HGA_2011_V0018.LBL" \
"RO    DATA/CK/ROS_HGA_2014_V0044.LBL" \
"RO    DATA/CK/ROS_HGA_2015_V0038.LBL" \
"RO    DATA/CK/ROS_LBOOM_V0.LBL" \
"RO    DATA/CK/ROS_SA_2004_V0001.LBL" \
"RO    DATA/CK/ROS_SA_2005_V0001.LBL" \
"RO    DATA/CK/ROS_SA_2006_V0001.LBL" \
"RO    DATA/CK/ROS_SA_2007_V0001.LBL" \
"RO    DATA/CK/ROS_SA_2008_V0038.LBL" \
"RO    DATA/CK/ROS_SA_2009_V0054.LBL" \
"RO    DATA/CK/ROS_SA_2010_V0043.LBL" \
"RO    DATA/CK/ROS_SA_2010_V0052.LBL" \
"RO    DATA/CK/ROS_SA_2011_V0020.LBL" \
"RO    DATA/CK/ROS_SA_2014_V0047.LBL" \
"RO    DATA/CK/ROS_SA_2015_V0037.LBL" \
"RO    DATA/CK/ROS_VIRTIS_M_0403_1509_V1.LBL" \
"RO    DATA/CK/ROS_VIRTIS_ZERO_V1.LBL" \
"RO_RL DATA/FK/EARTHFIXEDIAU.LBL" \
"RO_RL DATA/FK/EARTHFIXEDITRF93.LBL" \
"RO_RL DATA/FK/EARTH_TOPO_050714.LBL" \
"RO_RL DATA/FK/ESTRACK_V01.LBL" \
"RO_RL DATA/FK/NEW_NORCIA_TOPO.LBL" \
"RO    DATA/FK/ROS_LUTETIA_RSOC_V02.LBL" \
"RO    DATA/FK/ROS_LUTETIA_RSOC_V03.LBL" \
"RO_RL DATA/FK/ROS_V12.LBL" \
"RO_RL DATA/FK/ROS_V16.LBL" \
"RO_RL DATA/FK/ROS_V17.LBL" \
"RO_RL DATA/FK/ROS_V25.LBL" \
"RO_RL DATA/FK/RSSD0001.LBL" \
"RO_RL DATA/FK/RSSD0002.LBL" \
"RO    DATA/IK/ROS_ALICE_V12.LBL" \
"RO    DATA/IK/ROS_ALICE_V15.LBL" \
"RO    DATA/IK/ROS_ALICE_V16.LBL" \
"   RL DATA/IK/ROS_CIVA_V10.LBL" \
"RO    DATA/IK/ROS_CONSERT_V10.LBL" \
"RO    DATA/IK/ROS_COSIMA_V13.LBL" \
"   RL DATA/IK/ROS_DIM_V10.LBL" \
"RO    DATA/IK/ROS_GIADA_V11.LBL" \
"RO    DATA/IK/ROS_MIDAS_V10.LBL" \
"RO    DATA/IK/ROS_MIRO_V10.LBL" \
"RO    DATA/IK/ROS_NAVCAM_V01.LBL" \
"RO    DATA/IK/ROS_OSIRIS_V10.LBL" \
"RO    DATA/IK/ROS_OSIRIS_V11.LBL" \
"RO    DATA/IK/ROS_OSIRIS_V12.LBL" \
"   RL DATA/IK/ROS_ROLIS_V03.LBL" \
"RO    DATA/IK/ROS_ROSINA_V10.LBL" \
"RO    DATA/IK/ROS_ROSINA_V11.LBL" \
"RO    DATA/IK/ROS_RPC_V15.LBL" \
"RO    DATA/IK/ROS_RPC_V17.LBL" \
"RO    DATA/IK/ROS_STR_V10.LBL" \
"RO    DATA/IK/ROS_VIRTIS_V11.LBL" \
"RO    DATA/IK/ROS_VIRTIS_V12.LBL" \
"RO    DATA/IK/ROS_VIRTIS_V13.LBL" \
"RO_RL DATA/LSK/NAIF0008.LBL" \
"RO_RL DATA/LSK/NAIF0009.LBL" \
"RO_RL DATA/LSK/NAIF0011.LBL" \
"RO_RL DATA/PCK/DE403_MASSES.LBL" \
"RO_RL DATA/PCK/EARTH_000101_070916_070625.LBL" \
"RO_RL DATA/PCK/EARTH_000101_100428_100204.LBL" \
"RO_RL DATA/PCK/EARTH_000101_110111_101020.LBL" \
"RO_RL DATA/PCK/EARTH_000101_120117_111026.LBL" \
"RO_RL DATA/PCK/EARTH_000101_160131_151109.LBL" \
"RO_RL DATA/PCK/PCK00008.LBL" \
"RO_RL DATA/PCK/PCK00010.LBL" \
"RO_RL DATA/PCK/ROS_CGS_RSOC_V01.LBL" \
"RO_RL DATA/PCK/ROS_CG_RAD_V10.LBL" \
"RO_RL DATA/PCK/ROS_CG_ROT_1408_1409_V10.LBL" \
"RO    DATA/PCK/ROS_LUTETIA_LC1_V02.LBL" \
"RO    DATA/PCK/ROS_LUTETIA_LC2_V02.LBL" \
"RO    DATA/PCK/ROS_LUTETIA_R1_V02.LBL" \
"RO    DATA/PCK/ROS_LUTETIA_R2_V02.LBL" \
"RO    DATA/PCK/ROS_LUTETIA_RSOC_V01.LBL" \
"RO    DATA/PCK/ROS_LUTETIA_RSOC_V03.LBL" \
"RO    DATA/PCK/ROS_STEINS_V03.LBL" \
"RO    DATA/PCK/ROS_STEINS_V04.LBL" \
"RO    DATA/PCK/ROS_STEINS_V05.LBL" \
"RO_RL DATA/SCLK/ROS_061208_STEP.LBL" \
"RO_RL DATA/SCLK/ROS_091210_STEP.LBL" \
"RO_RL DATA/SCLK/ROS_100617_STEP.LBL" \
"RO_RL DATA/SCLK/ROS_110405_STEP.LBL" \
"RO_RL DATA/SCLK/ROS_150908_STEP.LBL" \
"RO    DATA/SPK/21_LUTETIA_2004_2016.LBL" \
"RO    DATA/SPK/2867_STEINS_2004_2016.LBL" \
"RO_RL DATA/SPK/67P_CHURY_GERAS_2004_2016.LBL" \
"RO_RL DATA/SPK/CORB_DV_145_01_______00216.LBL" \
"RO_RL DATA/SPK/DE405.LBL" \
"RO_RL DATA/SPK/EARTHSTNS_FX_050714.LBL" \
"RO_RL DATA/SPK/EARTHSTNS_ITRF93_050714.LBL" \
"RO_RL DATA/SPK/ESTRACK_V01.LBL" \
"   RL DATA/SPK/LORB_DV_145_01_______00216.LBL" \
"RO_RL DATA/SPK/NEW_NORCIA.LBL" \
"RO    DATA/SPK/ORER_______________00031.LBL" \
"RO    DATA/SPK/ORFR_______________00067.LBL" \
"RO    DATA/SPK/ORGR_______________00096.LBL" \
"RO    DATA/SPK/ORHO_______________00077.LBL" \
"RO    DATA/SPK/ORHR_______________00047.LBL" \
"RO    DATA/SPK/ORHR_______________00096.LBL" \
"RO    DATA/SPK/ORHR_______________00109.LBL" \
"RO    DATA/SPK/ORHR_______________00122.LBL" \
"RO    DATA/SPK/ORHS_______________00109.LBL" \
"RO_RL DATA/SPK/ORHW_______________00016.LBL" \
"RO_RL DATA/SPK/ORHW_______________00122.LBL" \
"RO    DATA/SPK/ORMR_______________00052.LBL" \
"RO_RL DATA/SPK/OUTERPLANETS_V0002.LBL" \
"RO    DATA/SPK/RORB_DV_145_01_______00216.LBL" \
"RO_RL DATA/SPK/ROS_STRUCT_V1.LBL" \
"RO_RL DATA/SPK/ROS_STRUCT_V2.LBL" \
"RO_RL DATA/SPK/ROS_STRUCT_V5.LBL" \
"RO    DATA/SPK/TEMPEL1_9P_DI_P.LBL" \
)
    set ITEM = ( $PAIR )
    set TAG  = $ITEM[1]
    set LBL  = $ITEM[2]

    if      ( $TAG == "RO_RL" ) then

	grep -v DATA_SET_NAME $LBL | \
            sed 's/DATA_SET_ID                  =.*$/DATA_SET_ID                  = "RO\/RL-E\/M\/A\/C-SPICE-6-V1.0"/' | \
            sed 's/SPACECRAFT_NAME              = ROSETTA/INSTRUMENT_HOST_NAME         = { "ROSETTA-ORBITER", "ROSETTA-LANDER" }/' \
            > $LBL.new

    else if ( $TAG == "RO" ) then

	grep -v DATA_SET_NAME $LBL | \
            sed 's/DATA_SET_ID                  =.*$/DATA_SET_ID                  = "RO\/RL-E\/M\/A\/C-SPICE-6-V1.0"/' | \
            sed 's/SPACECRAFT_NAME              = ROSETTA/INSTRUMENT_HOST_NAME         = "ROSETTA-ORBITER"/' \
            > $LBL.new

    else if ( $TAG == "RL" ) then

	grep -v DATA_SET_NAME $LBL | \
            sed 's/DATA_SET_ID                  =.*$/DATA_SET_ID                  = "RO\/RL-E\/M\/A\/C-SPICE-6-V1.0"/' | \
            sed 's/SPACECRAFT_NAME              = ROSETTA/INSTRUMENT_HOST_NAME         = "ROSETTA-LANDER"/' \
            > $LBL.new

    else
	echo
	echo ERROR: Cannot recognize $TAG.
	echo 
    endif

    echo -------------------------------------------------------- $LBL
    diff $LBL.new $LBL

end

exit
