#include <stdio.h>

#define OK    1
#define NOTOK 0
#define TRUE  1
#define FALSE 0

  struct _CharList {
    int decimal;
    char name[4];
    long count;
  };

  typedef struct _CharList CharList;

  CharList ch[128] = {
    {   0, "nul", 0L }, 
    {   1, "soh", 0L },  {   2, "stx", 0L },  {   3, "etx", 0L }, 
    {   4, "eot", 0L },  {   5, "enq", 0L },  {   6, "ack", 0L }, 
    {   7, "bel", 0L },  {   8, "bs", 0L },   {   9, "ht", 0L }, 
    {  10, "nl", 0L },   {  11, "vt", 0L },   {  12, "np", 0L }, 
    {  13, "cr", 0L },   {  14, "so", 0L },   {  15, "si", 0L }, 
    {  16, "dle", 0L },  {  17, "dc1", 0L },  {  18, "dc2", 0L }, 
    {  19, "dc3", 0L },  {  20, "dc4", 0L },  {  21, "nak", 0L }, 
    {  22, "syn", 0L },  {  23, "etb", 0L },  {  24, "can", 0L }, 
    {  25, "em", 0L },   {  26, "sub", 0L },  {  27, "esc", 0L }, 
    {  28, "fs", 0L },   {  29, "gs", 0L },   {  30, "rs", 0L }, 
    {  31, "us", 0L },   {  32, "sp", 0L },   {  33, "!", 0L }, 
    {  34, "\"", 0L },   {  35, "#", 0L },    {  36, "$", 0L }, 
    {  37, "%", 0L },    {  38, "&", 0L },    {  39, "'", 0L }, 
    {  40, "(", 0L },    {  41, ")", 0L },    {  42, "*", 0L }, 
    {  43, "+", 0L },    {  44, ",", 0L },    {  45, "-", 0L }, 
    {  46, ".", 0L },    {  47, "/", 0L },    {  48, "0", 0L }, 
    {  49, "1", 0L },    {  50, "2", 0L },    {  51, "3", 0L }, 
    {  52, "4", 0L },    {  53, "5", 0L },    {  54, "6", 0L }, 
    {  55, "7", 0L },    {  56, "8", 0L },    {  57, "9", 0L }, 
    {  58, ":", 0L },    {  59, ";", 0L },    {  60, "<", 0L }, 
    {  61, "=", 0L },    {  62, ">", 0L },    {  63, "?", 0L }, 
    {  64, "@", 0L },    {  65, "A", 0L },    {  66, "B", 0L }, 
    {  67, "C", 0L },    {  68, "D", 0L },    {  69, "E", 0L }, 
    {  70, "F", 0L },    {  71, "G", 0L },    {  72, "H", 0L }, 
    {  73, "I", 0L },    {  74, "J", 0L },    {  75, "K", 0L }, 
    {  76, "L", 0L },    {  77, "M", 0L },    {  78, "N", 0L }, 
    {  79, "O", 0L },    {  80, "P", 0L },    {  81, "Q", 0L }, 
    {  82, "R", 0L },    {  83, "S", 0L },    {  84, "T", 0L }, 
    {  85, "U", 0L },    {  86, "V", 0L },    {  87, "W", 0L }, 
    {  88, "X", 0L },    {  89, "Y", 0L },    {  90, "Z", 0L }, 
    {  91, "[", 0L },    {  92, "\\", 0L },   {  93, "]", 0L }, 
    {  94, "^", 0L },    {  95, "_", 0L },    {  96, "`", 0L }, 
    {  97, "a", 0L },    {  98, "b", 0L },    {  99, "c", 0L }, 
    { 100, "d", 0L },    { 101, "e", 0L },    { 102, "f", 0L }, 
    { 103, "g", 0L },    { 104, "h", 0L },    { 105, "i", 0L }, 
    { 106, "j", 0L },    { 107, "k", 0L },    { 108, "l", 0L }, 
    { 109, "m", 0L },    { 110, "n", 0L },    { 111, "o", 0L }, 
    { 112, "p", 0L },    { 113, "q", 0L },    { 114, "r", 0L }, 
    { 115, "s", 0L },    { 116, "t", 0L },    { 117, "u", 0L }, 
    { 118, "v", 0L },    { 119, "w", 0L },    { 120, "x", 0L }, 
    { 121, "y", 0L },    { 122, "z", 0L },    { 123, "{", 0L }, 
    { 124, "|", 0L },    { 125, "}", 0L },    { 126, "~", 0L }, 
    { 127, "del", 0L }
  };

int main( int argc, char **argv )
{
  char c;
  int i;
  int j;
  int status;
  int verbose=FALSE;
  int silent=FALSE;
  int printlines=FALSE;
  int flagnonascii=TRUE;
  int printchars=FALSE;
  int totals=FALSE;

  FILE *fp=(FILE *)NULL;

  unsigned long counts[128];
  unsigned long nonascii=0L;
  unsigned long filenonascii=0L;
  unsigned long nlines=0L;
  unsigned long nfiles=0L;
  unsigned long nchars=0L;
  unsigned long nbad=0L;
  unsigned long tlines=0L;
  unsigned long tchars=0L;
  unsigned long tbad=0L;

  if ( argc <= 1 ){
     printf("\n");
     printf("Check files for non-printing and non-ASCII characters.\n");
     printf("\n");
     printf("Usage:\n");
     printf("\n");
     printf("   badchar [-svtlcn] <file-list>\n");
     printf("\n");
     printf("Options:\n");
     printf("\n");
     printf("   -s ... silent output: only set exit status\n");
     printf("   -v ... verbose output: report every bad character\n");
     printf("   -t ... report totals for all input files together\n");
     printf("   -l ... print total number of lines for each file\n");
     printf("   -c ... print total number of chars for each file\n");
     printf("   -n ... don't treat non-ASCII (128-255) as error\n");
     printf("\n");
     exit(1);
  } /* end if */

  i = 1;
  while ( i < argc && (*(*(argv+i)) == '-') ){
    switch ( *(*(argv+i)+1) ){
      case 'v':{
        verbose = TRUE;
        break;
      } /* end case: 'v' */
      case 's':{
        silent = TRUE;
        break;
      } /* end case: 's' */
      case 't':{
        totals = TRUE;
        break;
      } /* end case: 't' */
      case 'l':{
        printlines = TRUE;
        break;
      } /* end case: 'l' */
      case 'n':{
        flagnonascii = FALSE;
        break;
      } /* end case: 'n' */
      case 'c':{
        printchars = TRUE;
        break;
      } /* end case: 'c' */
    }; /* end switch */
    i++;
  } /* end while */

  while ( i < argc ){
    nfiles++;

    nlines = 0L;
    nchars = 0L;
    nbad = 0L;
    filenonascii = 0L;

    fp = fopen ( argv[i], "rb" );

    if ( fp == NULL ) {
      if ( !silent ){
        printf("Error opening file");
      }
      exit(1);
    }

    for ( j=0; j<128; j++){
      counts[j] = 0L;
    } /* end for */

    if ( !silent ){
       printf("\n");
    }

    while ( (c = fgetc(fp)) != EOF ){
      nchars ++;

      if ( ( (int)c < 0 ) || ( (int)c >= 128 ) ){
         nonascii++;
         if ( flagnonascii ){
            nbad++;
            filenonascii++;
            if ( verbose && (!silent) ) {
               printf( "BAD CHARACTER -- File: %s,", argv[i]);
               printf( " line: %6ld,", nlines+1L );
               if ( (int)c < 0 ) {
                  printf( " Character: NON-ASCII (%3d)\n", (int)c+256 );
               } else {
                  printf( " Character: NON-ASCII (%3d)\n", (int)c );
               }
            }
         } 
      }
      else{
         ch[(int)c].count++;

         switch ( (int) c ){
           case  0:  case  1:  case  2:  case  3:  case  4:  case  5:
           case  6:  case  7:  case  8:  case  9:  case 11:  case 12:
           case 13:  case 14:  case 15:  case 16:  case 17:  case 18:
           case 19:  case 20:  case 21:  case 22:  case 23:  case 24:
           case 25:  case 26:  case 27:  case 28:  case 29:  case 30:
           case 31:  case 127:
          {
             status = NOTOK;
             nbad++;
             counts[(int) c]++;
             break;
          }
          case 10:{
            status = OK;
            nlines++;
            break;
          }
          default:{
            status = OK;
            break;
          } /* end default */
        }; /* end switch */

        if ( ( status == NOTOK ) && verbose && (!silent) ) {
         printf( "BAD CHARACTER -- File: %s,", argv[i]);
         printf( " line: %6ld,", nlines+1L );
         printf( " Character: %3s (%3d)\n",
                 ch[(int)c].name, ch[(int)c].decimal );
        } /* end if */
      } /* end if */

    } /* end while*/

    fclose ( fp );

    if ( !silent ){
      printf("File: %s,", argv[i]);
      if ( printlines ) {
         printf(" Lines: %ld,", nlines);
      }
      if ( printchars ) {
         printf(" Chars: %ld,", nchars);
      }
      printf(" Bad Chars: %ld\n", nbad);
    }

    if ( !silent && verbose ){
       if ( nbad > 0L ) {
         for ( j=0; j<128; j++){
           if ( counts[j] > 0L ){
             printf("Bad Character: %3s (%3d), Count: %10ld\n", 
             ch[j].name, ch[j].decimal, counts[j]);
           } /* end if */
         } /* end for */
         if ( flagnonascii && filenonascii > 0L ) {
             printf("Bad Character: NON-ASCII (128-255), Count: %10ld\n", 
                     filenonascii );
         }
       } /* end if */
    } /* end if */
 
    tlines += nlines;
    tchars += nchars;
    tbad   += nbad;
    i++;

  } /* end while */

  if ( !silent && totals){
     printf( "\n" );
     printf( "Total Files         : %ld\n", nfiles );
     printf( "Total Lines         : %ld\n", tlines );
     printf( "Total Characters    : %ld\n", tchars );
     printf( "Total Bad Characters: %ld\n", tbad);
     printf( "Total Non-ASCII     : %ld\n", nonascii );
     printf("\n");
  }

  if ( tbad > 0L ){
     exit(1);
  }
  else
  {
     exit(0);
  }

}
