KPL/MK

Meta-kernel for VENUS EXPRESS Archived Kernels
==========================================================================

   This meta-kernel lists the VENUS EXPRESS Archived SPICE kernels
   providing information for the full mission. All of the kernels listed
   below are archived in the PSA VENUS EXPRESS SPICE kernel archive.

   This set of files and the order in which they are listed were picked to
   provide the best available data and the most complete coverage for the
   specified year based on the information about the kernels available at
   the time this meta-kernel was made. For detailed information about the
   kernels listed below refer to the internal comments included in the
   kernels and the documentation accompanying the VENUS EXPRESS
   SPICE kernel archive.


Usage of the Meta-kernel
-------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make
   use of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".
   The SPICELIB routine FURNSH loads a kernel into the pool.


Implementation Notes
-------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the VENUS EXPRESS SPICE data set's ``data'' directory
   on their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on 2020-11-06 by Alfredo Escalante Lopez ESA/ESAC.
   The original name of this file was VEX_V01.TM.


   \begindata

     PATH_VALUES       = ( './DATA' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

'$KERNELS/CK/ATNV_MEASURED_2012_V01.BC'
'$KERNELS/CK/ATNV_MEASURED_2013_V01.BC'
'$KERNELS/CK/VEX_ASPERA_SAF_051109_01.BC'
'$KERNELS/CK/VEX_BOOM_V01.BC'
'$KERNELS/CK/VEX_SA_2013_V0048.BC'
'$KERNELS/CK/VEX_VIRTIS_2012_V01.BC'

'$KERNELS/FK/EARTH_TOPO_050714.TF'
'$KERNELS/FK/EARTHFIXEDITRF93.TF'
'$KERNELS/FK/ESTRACK_V03.TF'
'$KERNELS/FK/RSSD0002.TF'
'$KERNELS/FK/VEX_V11.TF'

'$KERNELS/IK/VEX_ASPERA4_V03.TI'
'$KERNELS/IK/VEX_PFS_V01.TI'
'$KERNELS/IK/VEX_SOIR_V02.TI'
'$KERNELS/IK/VEX_VIRTIS_V04.TI'
'$KERNELS/IK/VEX_VMC_V05.TI'

'$KERNELS/LSK/NAIF0011.TLS'

'$KERNELS/PCK/PCK00010.TPC'
'$KERNELS/PCK/DE403_MASSES.TPC'

'$KERNELS/PCK/EARTH_000101_150330_150107.BPC'

'$KERNELS/SCLK/VEX_141112_STEP.TSC'

'$KERNELS/SPK/DE405.BSP'
'$KERNELS/SPK/EARTHSTNS_ITRF93_050714.BSP'
'$KERNELS/SPK/ESTRACK_V03.BSP'
'$KERNELS/SPK/ORVM_T19___________00001.BSP'
'$KERNELS/SPK/VEX_STRUCT_V01.BSP'
'$KERNELS/SPK/OUTERPLANETS_V0003.BSP'

                         )

   \begintext


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service at ESAC:

           Alfredo Escalante Lopez
           (+34) 91 813 14 29
           spice@sciops.esa.int

   or NAIF at JPL:

           Marc Costa Sitja
           (818) 354-4852
           Marc.Costa.Sitja@jpl.nasa.gov


End of MK file.
