KPL/FK

Venus Express Spacecraft Frames Kernel
========================================================================

   This frame kernel contains complete set of frame definitions for the
   Venus Express Spacecraft (VEX) including definitions for the VEX
   fixed and VEX science instrument frames. This kernel also contains
   NAIF ID/name mapping for the VEX instruments.


Version and Date
========================================================================

   Version 1.1 -- November 5, 2020 -- Alfredo Escalante Lopez, ESAC/ESA
                                      Marc Costa Sitja, ESAC/ESA

      Added new VEX name/ID mappings:

            VEX_SPACECRAFT_C1      -248001
            VEX_SPACECRAFT_C2      -248002
            VEX_SPACECRAFT_C3      -248003
            VEX_SPACECRAFT_C4      -248004
            VEX_SPACECRAFT_C5      -248005
            VEX_SPACECRAFT_C6      -248006
            VEX_SPACECRAFT_C7      -248007
            VEX_SPACECRAFT_C8      -248008

            VEX_SA+Y_GIMBAL        -248010
            VEX_SA+Y_C1            -248014
            VEX_SA+Y_C2            -248015
            VEX_SA+Y_C3            -248016
            VEX_SA+Y_C4            -248017
            VEX_SA-Y_GIMBAL        -248020
            VEX_SA-Y_C1            -248024
            VEX_SA-Y_C2            -248025
            VEX_SA-Y_C3            -248026
            VEX_SA-Y_C4            -248027

      VEX_PFS_SCANNER frame set to FIXED due to its failure.

      Added spacecraft corners ID name associations.

      VIRTIS alignment previously quoted as ``preliminary'' is considered
      final.

      Misalignments implemented for SPICAV SOIR, Star Trackers and HGAs
      from EDF files.

      Latest VMC alignments from EDF files implemented.

      Centers of reference frames have been updated to match IDs of the
      structures in the STRUCT SPK.

   Version 1.0 -- December 20, 2012 -- J. Vazquez, ESAC/ESA
                                       B. Semenov, NAIF/JPL

      Typo fixed in VEX_SPICAV_SIR definition.

   Version 0.9 -- June 1, 2010 -- B. Geiger, ESAC/ESA

      Alignment information for Star Tracker B updated with information
      from [20] and [21].

   Version 0.8 -- May 21, 2008 -- J. Vazquez, ESAC/ESA

      Modified Solar Array frames:

         - Added VEX_SA_+Y_ZERO and VEX_SA_-Y_ZERO, fixed offset
           frames with respect to VEX_SPACECRAFT.

         - Modified VEX_SA+Y and VEX_SA-Y. The cells of the Solar
           Arrays face the +Z axis of the frames. The frames are
           type 3 frames that rotate with respect to VEX_SA+Y_ZERO
           and VEX_SA-Y_ZERO.


   Version 0.7 -- April 8, 2008 -- J. Vazquez, ESAC/ESA
                                   Thomas Roatsch VMC/DLR

      Updated alignment information for the VMC filters.


   Version 0.6 -- August 24, 2006 -- Maud Barthelemy, RSSD/ESA &
                                     Boris Semenov, NAIF/JPL

      Modified VEX_SPICAV_SIR_SOLAR, VEX_SPICAV_SUV_SOLAR, VEX_SPICAV_SOIR:

         - correction of error (30 degrees with X axis not 60)

         - update of the boresight for VEX_SPICAV_SOIR.


   Version 0.5 -- July 12, 2006 -- Maud Barthelemy, RSSD/ESA &
                                   Boris Semenov, NAIF/JPL

      Added star tracker (ST1 and ST2) frames and name/ID mappings.


   Version 0.4 -- February 6, 2006 -- Boris Semenov, NAIF/JPL

      Added VEX_VIRTIS-M_VIS_ZERO and VEX_VIRTIS-M_IR_ZERO frames.
      Incorporated preliminary VIRTIS-M alignment data. Improved
      VIRTIS frame descriptions.


   Version 0.3 -- January 18, 2006 -- Boris Semenov, NAIF/JPL

      Modified VIRTIS-M frames and IDs to provide more efficient layout
      for capturing scan mirror orientation and detector alignment
      data, specifically:

         -  eliminated VEX_VIRTIS-M_VIS_SCAN (-248512) and
            VEX_VIRTIS-M_IR_SCAN (-248514) frames and parallel
            instrument name/IDs pairs

         -  introduced VEX_VIRTIS-M_SCAN (-248515) CK-based frame
            to capture instrument pointing for an arbitrary
            scan mirror position

         -  redefined VEX_VIRTIS-M_VIS and VEX_VIRTIS-M_IR frames
            to be with respect to VEX_VIRTIS-M_SCAN


   Version 0.2 -- December 09, 2005 -- Jorge Diaz del Rio, RSSD/ESA

      VIRTIS-H frame comments updated to reflect that the slit is
      aligned with the +Y axis (spatial resolution)


   Version 0.1 -- November 15, 2005 -- Jorge Diaz del Rio, RSSD/ESA

      VIRTIS, VMC and ASPERA-4 frames added. Preliminary Version.
      Pending review and approval by VEX instrument teams and Venus
      Express Science Operations team.


   Version 0.0 -- November 01, 2005 -- Jorge Diaz del Rio, RSSD/ESA

      Preliminary Version. Pending review and approval by VEX
      instrument teams and Venus Express Science operations team.


References
========================================================================

   1. ``Frames Required Reading'', NAIF Document No.____

   2. ``Kernel Pool Required Reading'', NAIF Document No.____

   3. ``C-Kernel Required Reading'', NAIF Document No.____

   4. ``Venus Express User Manual'' VEX-T-ASTR-TCN.00394, Issue 02, Rev 00,
      06/02/2004, by Astrium

   5. ``VMC Flight User Manual'' VMC-IDA-MA-SF000-001_1, Issue 01, Rev a,
      15/03/2005

   6. ``VMC Payload Interface Document, Part-B'' VMC-MPAE-PID-B, Issue 02,
      Rev a, 01/06/2004

   7. ``MAG Payload Interface Document, Part-B'' VE-MAG-DS-0001, Issue 02,
      Rev. 1, 29/04/2004

   8. ``PFS Instrument Description'' MEX-CNR-IQAR-02, November 15, 2001

   9. ``PFS for Venus Express'' Delta Documentation

  10. ``SPICAV Payload Interface Document, Part-B'' SPV-DES-011 Issue 3.2
      May 01, 2004

  11. ``Venus Express SPICAV Flight User Manual'', SPV-DES-032, Issue 002,
      Rev. 2, February 04, 2004

  12. ``FM VIRTIS EXPERIMENT USER MANUAL (Delta Documentation)'',
      VVX-VIR-UM-001, Issue 1, June 05, 2004

  13. ``Rosetta - VIRTIS Experiment Interface Document Part-B'',
      ROS-EST-RS-3015/EID-B, Issue 2, February 14, 2000

  14. ``ASPERA-3 PID-B'', VE-ASP-MA-0003, Issue D. December 06, 2002

  15. E-Mail from Stephane Erard (VIRTIS Team), December 8, 2005

  16. VIRTIS Presentation, VEX SWT Meeting, December 2005.

  17. LOS_Alignment_Geometry_Measured-2.pdf, provided by Dr. Giuseppe
      Piccioni, February 2006

  18. ``Alignment Test Engineering Evaluation Report'', VEX.ASTR.RP.01830,
      20/06/05, pg 49.

  19. Mail by T. Roatsch (08 Apr. 2008), specifying the offset of the
      boresight for the VMC filters.

  20. E-Mail from O. Camino to B. Geiger, May 31, 2010.

  21. DOR__FDLVMA_D06032AASTR_ROT_01308.VEX

  22. E-Mail ``VEX HGA1 and HGA2 modeling'' from Stefan Remus (ESTEC/ESA)
      on 18th March 2020.

  23. ``RF DESIGN DESCRIPTION AND ANALYSIS HGA-2 Antenna'',
      VEX-CAS-RP-0025, EADCS CASA Espacio, Issue 03, July 2003.


Contact Information
========================================================================

   Alfredo Escalante Lopez, ESAC/ESA +34 91 8131 429 alfredo.escalante@esa.int

   Marc Costa Sitja, ESAC/ESA, +34 91 8131 457 marc.costa@esa.int

   Boris Semenov, NAIF/JPL, (818) 354-8136, boris.semenov@jpl.nasa.gov


Implementation Notes
========================================================================

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must `load' the kernel, normally during program
   initialization. The SPICELIB routine FURNSH and CSPICE function furnsh_c
   load a kernel file into the kernel pool as shown below.

      CALL FURNSH ( 'frame_kernel_name' )
      furnsh_c    ( "frame_kernel_name" );

   This file was created and may be updated with a text editor or word
   processor.


Venus Express Mission NAIF ID Codes
========================================================================

   The following names and NAIF ID codes are assigned to the VEX spacecraft,
   its structures and science instruments (the keywords implementing these
   definitions are located in the section "Venus Express Mission NAIF ID
   Codes -- Definition Section" at the end of this file):

   VEX Spacecraft and Spacecraft Structures names/IDs:

            VEX                          -248     (synonyms: VENUS EXPRESS,
                                                   VENUS-EXPRESS,
                                                   VENUS_EXPRESS )
            VEX_SPACECRAFT               -248000  (synonym: VEX_SC)

            VEX_SPACECRAFT_C1            -248001
            VEX_SPACECRAFT_C2            -248002
            VEX_SPACECRAFT_C3            -248003
            VEX_SPACECRAFT_C4            -248004
            VEX_SPACECRAFT_C5            -248005
            VEX_SPACECRAFT_C6            -248006
            VEX_SPACECRAFT_C7            -248007
            VEX_SPACECRAFT_C8            -248008

            VEX_SA+Y_GIMBAL              -248010
            VEX_SA+Y                     -248011
            VEX_SA+Y_C1                  -248014
            VEX_SA+Y_C2                  -248015
            VEX_SA+Y_C3                  -248016
            VEX_SA+Y_C4                  -248017
            VEX_SA-Y_GIMBAL              -248020
            VEX_SA-Y                     -248013
            VEX_SA-Y_C1                  -248024
            VEX_SA-Y_C2                  -248025
            VEX_SA-Y_C3                  -248026
            VEX_SA-Y_C4                  -248027

            VEX_HGA1                     -248021
            VEX_HGA2                     -248022

            VEX_LGA-1                    -248031
            VEX_LGA-2                    -248032

            VEX_ST1                      -248033
            VEX_ST2                      -248034

   ASPERA-4 names/IDs:

            VEX_ASPERA4                  -248100
            VEX_ASPERA4_URF              -248110
            VEX_ASPERA4_SAF              -248111
            VEX_ASPERA4_ELS              -248120
            VEX_ASPERA4_NPI              -248130
            VEX_ASPERA4_NPD1             -248141
            VEX_ASPERA4_NPD2             -248142
            VEX_ASPERA4_IMA_URF          -248150
            VEX_ASPERA4_IMA              -248151
            VEX_ASPERA4_IMAS             -248152
            VEX_ASPERA4_SS1              -248161
            VEX_ASPERA4_SS2              -248162

   MAG names/IDs:

            VEX_MAG_MAGB-H               -248200
            VEX_MAG_MAGB                 -248201
            VEX_MAG_MAGIS                -248210
            VEX_MAG_MAGOS                -248220

   PFS names/IDs:

            VEX_PFS_BASE                 -248300
            VEX_PFS_SCANNER              -248310
            VEX_PFS_LWC                  -248320
            VEX_PFS_SWC                  -248330

   SPICAV names/IDs:

            VEX_SPICAV_BASE        -248400
            VEX_SPICAV_SIR         -248410
            VEX_SPICAV_SIR_SOLAR   -248411
            VEX_SPICAV_SUV         -248420
            VEX_SPICAV_SUV_SOLAR   -248421
            VEX_SPICAV_SOIR        -248430

   VIRTIS names/IDs:

            VEX_VIRTIS                   -248500
            VEX_VIRTIS-M                 -248510
            VEX_VIRTIS-M_VIS             -248511
            VEX_VIRTIS-M_IR              -248513
            VEX_VIRTIS-M_VIS_ZERO        -248512
            VEX_VIRTIS-M_IR_ZERO         -248514
            VEX_VIRTIS-H                 -248520

   VMC names/IDs:

            VEX_VMC_BASE                 -248600
            VEX_VMC_NIR-1                -248610
            VEX_VMC_NIR-2                -248620
            VEX_VMC_UV                   -248630
            VEX_VMC_VIS                  -248640


Venus Express Frames
========================================================================

   The following VEX frames are defined in this kernel file:

           Name                  Relative to           Type       NAIF ID
      ======================  ===================  ============   =======

   VEX Spacecraft and Spacecraft Structures frames:
   ------------------------------------------------
      VEX_SPACECRAFT          J2000                CK             -248000
      VEX_SA+Y_ZERO           VEX_SPACECRAFT       FIXED          -284012
      VEX_SA+Y                VEX_SA+Y_ZERO        CK             -248011
      VEX_SA-Y_ZERO           VEX_SPACECRAFT       FIXED          -248014
      VEX_SA-Y                VEX_SA-y_ZERO        CK             -248013
      VEX_HGA1                VEX_SPACECRAFT       FIXED          -248021
      VEX_HGA2                VEX_SPACECRAFT       FIXED          -248022
      VEX_LGA-1               VEX_SPACECRAFT       FIXED          -248031
      VEX_LGA-2               VEX_SPACECRAFT       FIXED          -248032
      VEX_ST1                 VEX_SPACECRAFT       FIXED          -248033
      VEX_ST2                 VEX_SPACECRAFT       FIXED          -248034

   ASPERA-4 frames:
   ----------------
      VEX_ASPERA4_URF         VEX_SPACECRAFT       FIXED          -248110
      VEX_ASPERA4_SAF         VEX_ASPERA4_URF      CK             -248111
      VEX_ASPERA4_ELS         VEX_ASPERA4_SAF      FIXED          -248120
      VEX_ASPERA4_NPI         VEX_ASPERA4_SAF      FIXED          -248130
      VEX_ASPERA4_NPD1        VEX_ASPERA4_SAF      FIXED          -248141
      VEX_ASPERA4_NPD2        VEX_ASPERA4_SAF      FIXED          -248142
      VEX_ASPERA4_IMA_URF     VEX_SPACECRAFT       FIXED          -248150
      VEX_ASPERA4_IMA         VEX_ASPERA4_IMA_URF  FIXED          -248151
      VEX_ASPERA4_IMAS        VEX_ASPERA4_IMA      FIXED          -248152
      VEX_ASPERA4_SS1         VEX_ASPERA4_SAF      FIXED          -248161
      VEX_ASPERA4_SS2         VEX_ASPERA4_SAF      FIXED          -248162

   MAG frames:
   -----------
      VEX_MAG_MAGB-H          VEX_SPACECRAFT       FIXED          -248200
      VEX_MAG_MAGB            VEX_MAG_MAGB-H       CK             -248201
      VEX_MAG_MAGIS           VEX_SPACECRAFT       FIXED          -248210
      VEX_MAG_MAGOS           VEX_MAG_MAGB         FIXED          -248220

   PFS frames:
   -----------
      VEX_PFS_BASE            VEX_SPACECRAFT       FIXED          -248300
      VEX_PFS_SCANNER         VEX_PFS_BASE         CK             -248310
      VEX_PFS_SWC             VEX_PFS_SCANNER      FIXED          -248320
      VEX_PFS_LWC             VEX_PFS_SCANNER      FIXED          -248330

   SPICAV frames:
   --------------
      VEX_SPICAV_BASE         VEX_SPACECRAFT       FIXED          -248400
      VEX_SPICAV_SIR          VEX_SPICAV_BASE      FIXED          -248410
      VEX_SPICAV_SIR_SOLAR    VEX_SPICAV_BASE      FIXED          -248411
      VEX_SPICAV_SUV          VEX_SPICAV_BASE      FIXED          -248420
      VEX_SPICAV_SUV_SOLAR    VEX_SPICAV_BASE      FIXED          -248421
      VEX_SPICAV_SOIR         VEX_SPICAV_BASE      FIXED          -248430

   VIRTIS frames:
   --------------
      VEX_VIRTIS-M            VEX_SPACECRAFT       FIXED          -248510
      VEX_VIRTIS-M_SCAN       VEX_VIRTIS-M         CK             -248515
      VEX_VIRTIS-M_VIS        VEX_VIRTIS-M_SCAN    FIXED          -248511
      VEX_VIRTIS-M_IR         VEX_VIRTIS-M_SCAN    FIXED          -248513
      VEX_VIRTIS-M_VIS_ZERO   VEX_VIRTIS-M         FIXED          -248512
      VEX_VIRTIS-M_IR_ZERO    VEX_VIRTIS-M         FIXED          -248514
      VEX_VIRTIS-H            VEX_SPACECRAFT       FIXED          -248520

   VMC frames:
   -----------
      VEX_VMC_BASE            VEX_SPACECRAFT       FIXED          -248600
      VEX_VMC_NIR-1           VEX_VMC_BASE         FIXED          -248610
      VEX_VMC_NIR-2           VEX_VMC_BASE         FIXED          -248620
      VEX_VMC_UV              VEX_VMC_BASE         FIXED          -248630
      VEX_VMC_VIS             VEX_VMC_BASE         FIXED          -248640


Spacecraft and Its Structures Frame Tree
========================================================================

   The diagram below shows the Venus Express spacecraft and its structures
   frame hierarchy (not including science instrument frames.)


                               "J2000" INERTIAL
           +-------------------------------------------------------+
           |                            |                          |
           |<-pck                       |                          |<-pck
           |                            |                          |
           V                            |                          V
      "IAU_VENUS"                       |                     "IAU_EARTH"
    VENUS BODY-FIXED                    |                   EARTH BODY-FIXED
    ----------------                    |                   ----------------
                                        |
                                        |
                                        |
                                        |        "VEX_ST1"  "VEX_ST2"
                                        |        ---------  ---------
                                        |               ^    ^
                                        |               |    |
                                        |<-ck    fixed->|    |<-fixed
                                        |               |    |
                                        V               |    |
                                 "VEX_SPACECRAFT"       |    |
      +------------------------------------------------------------+
      |                     |           .        |      |    |     |
      |<-fixed              |<-fixed    . fixed->|      |    |     |<-fixed
      |                     |           .        |      |    |     |
      V                     V           .        V      |    |     V
   "VEX_SA+Y_ZERO"   "VEX_SA-Y_ZERO"    .    "VEX_HGA1" |    | "VEX_HGA2"
   ---------------   ---------------    .    ---------- |    | ----------
      |                     |           .               |    |
      |<-ck                 |<-ck       .        fixed->|    |<-fixed
      |                     |           .               |    |
      V                     V           .               V    V
   "VEX_SA+Y"           "VEX_SA-Y"      .       "VEX_LGA-1" "VEX_LGA-2"
   ----------           ----------      .       ----------- -----------
                                        .
                                        .
                                        V
                  Individual instrument frame trees are provided
                     in the corresponding sections of this file


VEX Spacecraft and Spacecraft Structures Frames
========================================================================

   This section of the file contains the definitions of the spacecraft
   and spacecraft structures frames.


VEX Spacecraft Frames
--------------------------------------

   According to [4] the Venus Express spacecraft frame is defined as
   follows:

      -  +Z axis is perpendicular to the launch vehicle interface plane
         and points toward the payload side; representing the spacecraft
         line of sight toward Venus during science operation;

      -  +X axis is perpendicular to the HGA-1 mounting plane and points
         toward HGA1;

      -  +Y axis completes the right-handed frame.

      -  the origin of this frame is the launch vehicle interface point.


   These diagrams illustrate the VEX_SPACECRAFT frame:

   +X S/C side (HGA1 side) view:
   -----------------------------
                                    ^
                                    | Nadir
                                    |
                              Science Deck
                             ._____________.
                             |             |
      =====================o |             | o=====================
      -Y Solar Array         |             |         +Y Solar Array
                             |    +Zsc     |
                             |      ^      |
                             |      |      |
                             |      |      |
                             .______|______.              +Xsc is out
                               |    |    |                of the page
                               .____o-------> +Ysc
                                  /   \
                                 /_____\ Main Engine


   +Z S/C side view:
   -----------------

      .________________.     ._____________.     .________________.
      |                 \    |             |    /                 |
      |                  \   |             |   /                  |
      |                   |. |  +Zsc     +Ysc |                   |
      |                   | o|      o------->o|                   |
      |                   |' |      |      |  |                   |
      |                  /   |      |      |   \                  |
      ._________________/    .______|______.    \_________________.
       -Y Solar Array             . | .             +Y Solar Array
                          HGA1  .'  V +Xsc
                               /_________\
                                                      +Zsc is out of
                                                      the page


   Since the S/C bus attitude with respect to an inertial frame is provided
   by a C-kernel (see [3] for more information), this frame is defined as
   a CK-based frame.

   \begindata

      FRAME_VEX_SPACECRAFT             = -248000
      FRAME_-248000_NAME               = 'VEX_SPACECRAFT'
      FRAME_-248000_CLASS              =  3
      FRAME_-248000_CLASS_ID           = -248000
      FRAME_-248000_CENTER             = -248000
      CK_-248000_SCLK                  = -248
      CK_-248000_SPK                   = -248

   \begintext


Venus Express Solar Array Frames
--------------------------------------

   Since the VEX solar arrays can be articulated (having one degree of
   freedom), the solar Array frames, VEX_SA+Y and VEX_SA-Y, are defined as
   CK frames with their orientation given relative to VEX_SA+Y_ZERO and
   VEX_SA-Y_ZERO respectively. VEX_SA+Y_ZERO and VEX_SA-Y_ZERO are two offset
   frames, defined with respect to VEX_SPACECRAFT, as follows:

      - +Y is parallel to the longest side of the array, positively oriented
        from the yoke to the end of the wing.

      - +Z coincides with +Xsc.

      - +x is defined such that (X,Y,Z) is right handed.

      - the origin of the frame is located at the yoke geometric center.


   Both Solar Array frames (VEX_SA+Y and VEX_SA-Y) are defined as follows:

      -  +Y is parallel to the longest side of the array, positively oriented
         from the yoke to the end of the wing;

      -  +Z is normal to the solar array plane, the solar cells facing +Z;

      -  +X is defined such that (X,Y,Z) is right handed;

      -  the origin of the frame is located at the yoke geometric center.


   The axis of rotation is parallel to the Y axis of the spacecraft and the
   solar array frames.

   This diagram illustrates the VEX_SA+Y and VEX_SA-Y frames:


   +X S/C side view:
   -----------------

                  ^
                  |+Xsa-y_zero
                  |
                  |                 ^+Zsc
         +Zsa-y_zero is out         |
             of the page     .______|______.   +Zsa+y_zero is out of the page
    <-------------o          |Science Deck |         o---------> +Ysa+y_zero
    +Ysa-y_zero              |      |      |
  .________________________  |      |      |  _______|________________.
  |                        \ |      |      | /       |                |
  |                         o|      |      |o        |                |
  |________________________/ |      |      | \_______|________________|
                             |      o---------> +Ysc |
                             |    +Xsc     |         V +Xsa+y_zero
                             |  (out of the page )
                             ._____________.
                               |         |
                               ._________.
                                  /   \
                                 /_____\ Main Engine


   These sets of keywords define solar array frames as CK frames:

   \begindata

      FRAME_VEX_SA+Y_ZERO             = -248012
      FRAME_-248012_NAME              = 'VEX_SA+Y_ZERO'
      FRAME_-248012_CLASS             = 4
      FRAME_-248012_CLASS_ID          = -248012
      FRAME_-248012_CENTER            = -248011
      TKFRAME_-248012_RELATIVE        = 'VEX_SPACECRAFT'
      TKFRAME_-248012_SPEC            = 'ANGLES'
      TKFRAME_-248012_UNITS           = 'DEGREES'
      TKFRAME_-248012_ANGLES          = (   0.0, -90.0, 0.0 )
      TKFRAME_-248012_AXES            = (   3,     2,   1   )

      FRAME_VEX_SA+Y                  = -248011
      FRAME_-248011_NAME              = 'VEX_SA+Y'
      FRAME_-248011_CLASS             =  3
      FRAME_-248011_CLASS_ID          = -248011
      FRAME_-248011_CENTER            = -248011
      CK_-248011_SCLK                 = -248
      CK_-248011_SPK                  = -248

      FRAME_VEX_SA-Y_ZERO             = -248014
      FRAME_-248014_NAME              = 'VEX_SA-Y_ZERO'
      FRAME_-248014_CLASS             = 4
      FRAME_-248014_CLASS_ID          = -248014
      FRAME_-248014_CENTER            = -248013
      TKFRAME_-248014_RELATIVE        = 'VEX_SPACECRAFT'
      TKFRAME_-248014_SPEC            = 'ANGLES'
      TKFRAME_-248014_UNITS           = 'DEGREES'
      TKFRAME_-248014_ANGLES          = ( 180.0, 90.0, 0.0 )
      TKFRAME_-248014_AXES            = ( 3,     2,    1   )

      FRAME_VEX_SA-Y                  = -248013
      FRAME_-248013_NAME              = 'VEX_SA-Y'
      FRAME_-248013_CLASS             =  3
      FRAME_-248013_CLASS_ID          = -248013
      FRAME_-248013_CENTER            = -248013
      CK_-248013_SCLK                 = -248
      CK_-248013_SPK                  = -248

   \begintext


VEX High Gain Antenna Frame
--------------------------------------

   Venus Express has two fixed high gain antennas, HGA1 and HGA2,
   accommodated on the spacecraft to allow the Earth pointing of the
   spacecraft while satisfying the thermal constraints.

   The Venus Express main High Gain Antenna, HGA1, is rigidly attached to
   the +X side of the spacecraft bus. Therefore, the VEX HGA1 frame,
   VEX_HGA1, is defined as a fixed offset frame with its orientation given
   relative to the VEX_SPACECRAFT frame.

   The VEX_HGA1 frame is defined as follows:

      -  +Z axis is in the antenna boresight direction (nominally
         -5 degrees off the S/C +X axis toward the S/C +Z axis);

      -  +Y axis is in the direction of the S/C +Y axis ;

      -  +X completes the right hand frame;

      -  the origin of the frame is located at the geometric center of the
         HGA1 dish outer rim circle.


   The Venus Express auxiliary High Gain Antenna, HGA2, is rigidly attached
   to the +Z side of the spacecraft bus. Its pointing direction is symmetric
   to the HGA1 antenna with respect to the +Z axis of the spacecraft frame.
   Therefore, the VEX HGA2 frame, VEX_HGA2, is defined as a fixed offset
   frame with its orientation given relative to the VEX_SPACECRAFT frame.

   The VEX_HGA2 frame is defined as follows:

      -  +Z axis is in the antenna boresight direction (nominally
         5 degrees off the S/C -X axis toward the S/C +Z axis);

      -  +Y axis is in the direction of the S/C +Y axis ;

      -  +X completes the right hand frame;

      -  the origin of the frame is located at the geometric center of the
         HGA2 dish outer rim circle.


   This diagram illustrates the VEX High Gain Antennas frames:

   +Z S/C side view:
   -----------------


      .________________.     ._____________.     .________________.
      |                 \    |      ^+Zhga2|    /                 |
      |                  \   |      |      |   /                  |
      |                   |  |      |      |  |                   |
      |                   |o=|+Xhga2|     +Yhga2                  |
      |                   |  |  ____o------>  |                   |
      |                  /   |  \       /  |   \                  |
      ._________________/    .___`.____'___.    \_________________.
       -Y Solar Array   +Zsc o------>   `.          +Y Solar Array
                             | /  +Ysc   +Yhga1
                             |._____x------->
                             |      |+Xhga1
                        +Xsc V      |              +Xhga1 is into the page
                                    |              +Xhga2 is out of the page
                                    |              +Xsc is out of the page
                                    V +Zhga1


   Nominally a single rotation of +85 degrees about the +Y axis is needed to
   co-align the S/C frame with the HGA1 frame.

   Nominally a single rotation of -85 degrees about the +Y axis is needed to
   co-align the S/C frame with the HGA2 frame.

   A misalignment for HGA1 and HGA2 is implemented from [22]. Please note
   that no Instrument Kernel is associated with either HGA1 or HGA2 and
   therefore no boresight nor FOV is available. In order to implement such
   a model, the analysis of the received signal power (amplitude) would be
   necessary to use the value of the HGA gain in LOS direction. This can only
   be done if a HGA2 beam characterisation is available else the analysis of
   the absorption due to the Venus atmosphere is not possible. More
   information can be found in [23].

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_VEX_HGA1                  =  -248021
      FRAME_-248021_NAME              = 'VEX_HGA1'
      FRAME_-248021_CLASS             =  4
      FRAME_-248021_CLASS_ID          =  -248021
      FRAME_-248021_CENTER            =  -248021
      TKFRAME_-248021_RELATIVE        = 'VEX_SPACECRAFT'
      TKFRAME_-248021_SPEC            = 'ANGLES'
      TKFRAME_-248021_UNITS           = 'DEGREES'
      TKFRAME_-248021_AXES            = (  1,         2,        3       )
      TKFRAME_-248021_ANGLES          = ( -1.58705, -84.95813,  1.58091 )

      FRAME_VEX_HGA2                  =  -248022
      FRAME_-248022_NAME              = 'VEX_HGA2'
      FRAME_-248022_CLASS             =  4
      FRAME_-248022_CLASS_ID          =  -248022
      FRAME_-248022_CENTER            =  -248022
      TKFRAME_-248022_RELATIVE        = 'VEX_SPACECRAFT'
      TKFRAME_-248022_SPEC            = 'ANGLES'
      TKFRAME_-248022_UNITS           = 'DEGREES'
      TKFRAME_-248022_AXES            = (  1,         2,        3       )
      TKFRAME_-248022_ANGLES          = (  1.46328,  84.91692,  1.45753 )

   \begintext


Other Venus Express Antenna Frames
--------------------------------------

   The frames for the other two Venus Express antennas -- LGA-1 and
   LGA-2 -- are defined as follows:

      -  +Z axis is in the antenna boresight direction;

      -  +Y axis is nominally parallel to the S/C +Y axis;

      -  +X axis completes the right hand frame;

      -  the origin of the frame is located at the geometric center of
         the antenna outer side.


   The LGA-1 is located on the +Z side of the spacecraft bus and nominally
   points toward the spacecraft +Z axis, therefore, the S/C frame and the
   LGA-1 frames are nominally co-aligned.

   The LGA-2 is located on the -Z side of the spacecraft bus and nominally
   points 17.5 degrees off the spacecraft -Z axis toward the S/C +X axis.
   One rotation by +162.5 degrees about +Y is needed to align the S/C frame
   with the LGA-2 frame.

   This diagram illustrates the VEX_LGA-1 and VEX_LGA-2 frames:

   +Y S/C side view:
   -----------------
                                    ^
                                    |
                        +Zlga1 ^    |
                               |    | toward Venus
                               |
                               |+Ylga1
                       <-------o
                     +Xlga1   _|___________.
                             | Science Deck|
                         |`. |             |
                         |  \|  +Zsc       |
                         |   |      ^      |
                    HGA1 |   |      |      |
                         |   |      |      |
                         |  /|      |      |
                         |.' |      |+Ysc  |
                            <-------o _____|
                          +Xsc  /
                               o.
                              /  `.
                             /     `. +Xlga2
                            /        v
                           V +Zlga2

                                        +Y solar array is not shown

                                         +Ysc, +Ylga1, and +Ylga2
                                           are out of the page


   These sets of keywords define LGA frames as fixed offset
   frames:

   \begindata

      FRAME_VEX_LGA-1                  =  -248031
      FRAME_-248031_NAME               = 'VEX_LGA-1'
      FRAME_-248031_CLASS              =  4
      FRAME_-248031_CLASS_ID           =  -248031
      FRAME_-248031_CENTER             =  -248031
      TKFRAME_-248031_RELATIVE         = 'VEX_SPACECRAFT'
      TKFRAME_-248031_SPEC             = 'ANGLES'
      TKFRAME_-248031_UNITS            = 'DEGREES'
      TKFRAME_-248031_ANGLES           = (   0.000,   0.000,   0.000 )
      TKFRAME_-248031_AXES             = (   1,       2,       3     )

      FRAME_VEX_LGA-2                  =  -248032
      FRAME_-248032_NAME               = 'VEX_LGA-2'
      FRAME_-248032_CLASS              =  4
      FRAME_-248032_CLASS_ID           =  -248032
      FRAME_-248032_CENTER             =  -248032
      TKFRAME_-248032_RELATIVE         = 'VEX_SPACECRAFT'
      TKFRAME_-248032_SPEC             = 'ANGLES'
      TKFRAME_-248032_UNITS            = 'DEGREES'
      TKFRAME_-248032_ANGLES           = (   0.000, -162.500,  0.000 )
      TKFRAME_-248032_AXES             = (   1,       2,       3     )

   \begintext


Venus Express Star Tracker Frames
---------------------------------

   The frames for the two Venus Express star trackers -- ST1 and ST2 --
   are defined as follows:

      -  +Z axis is in the star tracker boresight direction;

      -  +X axis nominally points along the S/C -X/+Z quadrant bisector;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the star tracker focal
         point.


   Both star trackers are mounted on the -X panel of the S/C and point
   roughly in the S/C -X/-Z direction with the ST1 boresight tilted
   about 15 degrees toward the S/C +Y axis and the ST2 boresight tilted
   about 15 degrees toward the S/C -Y axis, resulting in the nominal
   30 degree separation between the ST1 and ST2 boresight directions.

   This diagram illustrates the VEX_ST1 and VEX_ST2 frames:

   +Y S/C side view:
   -----------------
                             ._____________.
                             | Science Deck|
                         |`. |             |       +Xst1
                         |  \|  +Zsc       |     ^ +Xst2
                         |   |      ^      |   .'
                    HGA1 |   |      |      | .'
                         |   |      |      |o
                         |  /|      |      | `.
                         |.' |      |+Ysc  |   `.
                            <-------o _____|     v +Zst1
                        +Xsc      /   \            +Zst2
                                 /_____\
                               Main Engine

                                         +Ysc, +Yst1, and +Yst2 are
                                               out of the page

                                         +Zst1 is 15 deg above the page

                                         +Zst2 is 15 deg below the page

   The precise orientation of the ST1 and ST2 frames is provided in
   [18] using rotation matrices. These matrices are incorporated in
   the keywords below defining the star tracker frames as fixed offset
   frames relative to the S/C frame:

   \begindata

      FRAME_VEX_ST1                 =  -248033
      FRAME_-248033_NAME            = 'VEX_ST1'
      FRAME_-248033_CLASS           =  4
      FRAME_-248033_CLASS_ID        =  -248033
      FRAME_-248033_CENTER          =  -248033
      TKFRAME_-248033_RELATIVE      = 'VEX_SPACECRAFT'
      TKFRAME_-248033_SPEC          = 'MATRIX'
      TKFRAME_-248033_MATRIX        = (-0.707260, -0.000260,  0.706940,
                                        0.181777,  0.966322,  0.182179,
                                       -0.683185,  0.257328, -0.683395)

      FRAME_VEX_ST2                 =  -248034
      FRAME_-248034_NAME            = 'VEX_ST2'
      FRAME_-248034_CLASS           =  4
      FRAME_-248034_CLASS_ID        =  -248034
      FRAME_-248034_CENTER          =  -248034
      TKFRAME_-248034_RELATIVE      = 'VEX_SPACECRAFT'
      TKFRAME_-248034_SPEC          = 'MATRIX'
      TKFRAME_-248034_MATRIX        = (-0.70632534,  0.00051061,  0.70788717,
                                       -0.18729836,  0.96422654, -0.18758064,
                                       -0.68265938, -0.26507906, -0.68096201)

   \begintext


ASPERA-4 Frames
========================================================================

   This section of the file contains the definitions of the ASPERA-4
   instrument frames.


ASPERA-4 Frame Tree
--------------------------------------

   The diagram below shows the ASPERA-4 frame hierarchy.


                               "J2000" INERTIAL
           +-----------------------------------------------------+
           |                          |                          |
           |<-pck                     |                          |<-pck
           |                          |                          |
           V                          |                          V
      "IAU_VENUS"                     |                     "IAU_EARTH"
    VENUS BODY-FIXED                  |                   EARTH BODY-FIXED
    ----------------                  |                   ----------------
                                      |
                                      |<-ck
                                      |
                               "VEX_SPACECRAFT"
           +-----------------------------------+
           |                                   |
           |<-fixed                            |<-fixed
           |                                   |
           V                                   V
   "VEX_ASPERA4_URF"                 "VEX_ASPERA4_IMA_URF"
   -----------------                 ---------------------
           |                                   |
           |                                   |<-fixed
           |                                   |
           |                                   V
           |                           "VEX_ASPERA4_IMA"
           |                           -----------------
           |                                   |
           |                                   |<-fixed
           |                                   |
           |                                   V
           |                           "VEX_ASPERA4_IMAS"
           |                           ------------------
           |
           |
           |
           |         "VEX_ASPERA4_NPD1"    "VEX_ASPERA4_NPD2"
           |         ------------------    -----------------
           |                  ^                     ^
           |<-ck              |                     |
           |                  |<-fixed              |<-fixed
           V                  |                     |
    "VEX_ASPERA4_SAF"         |                     |
    -----------------------------------------------------------------+
           |                 |                 |                     |
           |<-fixed          |<-fixed          |<-fixed       fixed->|
           |                 |                 |                     |
           V                 V                 V                     V
   "VEX_ASPERA4_ELS"  "VEX_ASPERA4_NPI"  "VEX_ASPERA4_SS1"  "VEX_ASPERA4_SS2"
   -----------------  -----------------  -----------------  -----------------


ASPERA-4 Main Unit URF and SAF Frames
--------------------------------------

   The ASPERA-4 main unit base is rigidly mounted on the S/C -Y wall.
   Therefore, the frame associated with it -- the ASPERA-4 main
   unit reference frame, VEX_ASPERA4_URF, -- is a fixed offset frame
   with its orientation given relative to the VEX_SPACECRAFT frame.

   The VEX_ASPERA4_URF frame is defined as follows:

      -  +Z axis is along the scanner rotation axis and points from the
         main unit mounting plate toward the scanner (nominally this
         axis is co-aligned with the S/C -Y axis);

      -  +X axis is parallel to the longer side of the main unit base
         and points from the NPD side toward the ELS side for scanner
         in "90 degrees" position (nominally this axis is co-aligned
         with the S/C -Z axis);

      -  +Y completes the right handed frame;

      -  the origin of the frame is located at the intersection of the
         mounting surface of the main unit base and the axis of the
         mounting screw hole located at NPD2 side for scanner in "90
         degrees" position.


   Nominally two rotations are required to align the ASPERA-4 Main Unit
   base frame and the S/C frame: first the ASPERA-4 Main Unit frame has
   to be rotated by +90 degrees about +X axis and then by -90 degrees
   about the new position of +Z axis.

   Since ASPERA-4 main unit scanner rotates with respect to its base with
   0..180 angle range clockwise about Z axis of the VEX_ASPERA4_URF
   frame, the frame associated with it -- the sensor assembly frame,
   VEX_ASPERA4_SAF, -- is defined as a CK frame with its orientation
   provided in a CK file relative to the VEX_ASPERA4_URF frame.

   The VEX_ASPERA4_SAF frame is defined as follows:

      -  +Z axis is along the scanner rotation axis and points from the
         main unit mounting plate toward the scanner; this axis is
         co-aligned with the +Z axis of the VEX_ASPERA4_URF frame;

      -  +X axis is along the ASPERA-4 sensor assembly central axis and
         points from the NPD sensor toward the ELS sensor; this axis
         is co-aligned with the +X axis of the VEX_ASPERA4_URF frame
         when scanner is in "90 degrees" position.

      -  +Y axis completes the right handed frame;

      -  the origin of the VEX_ASPERA4_SAF frame is located at the
         intersection of the scanner rotation axis and the bottom
         (mounting) surface of the scanner base.


   These diagrams  the VEX_ASPERA4_URF and VEX_ASPERA4_SAF
   frames for a scanner angle of 90 degrees:


   +X S/C side view:
   -----------------


                             .______^_+Zsc_.
                             |    .-|-.    |
   o=======================o |  .'  |  `.  |o======================o
     -Y Solar Array    ASPERA-4'    |      |        +Y Solar Array
                         .---MU|   .o----->|
                     <-----o |     '-'   +Ysc
                +Zurf    |_|_|  `.     .'  |
                +Zsaf     ||||____`---'____|
                           |
                           V +Xurf
                             +Xsaf                    +Xsc, +Yurf and
                                                      +Ysaf are out of the
                           |                          page.
                           .
                           |
                         "90 deg"
                        position

    -Y S/C side view:
   -----------------
                                    ^
                             .______| +Zsc_.
                             |      |      |  ,| HGA1
                             |      |      | . |
                             |      |      |'  |
                             |      x-----> +Xsc
                             | ASPERA-4    |   |
                             |   MU  .---. |+Yurf
                "180 deg"-.- |       | o----->.+Ysaf  -.- "0 deg"
                position     |       '-|-' |              position
                             '________|||__'
                                       |
                                       V +Xurf
                                         +Xsaf
                                       |
                                       .
                                       |
                                    "90 deg"
                                    position


                                       -Y solar array is not shown
                                       +Ysc is into the page
                                       +Zurf and +Zsaf are out of the
                                       page


   In general the VEX_ASPERA4_SAF frame is rotated with respect to the
   VEX_ASPERA4_URF frame by ( 90-<angle> ) degrees about +Z axis for
   scanner in <angle> position. This rotation as a function of time is
   provided in the ASPERA-4 scanner CK files.

   These sets of keywords define the ASPERA-4 URF and SAF frames:

   \begindata

      FRAME_VEX_ASPERA4_URF            =  -248110
      FRAME_-248110_NAME               = 'VEX_ASPERA4_URF'
      FRAME_-248110_CLASS              =  4
      FRAME_-248110_CLASS_ID           =  -248110
      FRAME_-248110_CENTER             =  -248100
      TKFRAME_-248110_RELATIVE         = 'VEX_SPACECRAFT'
      TKFRAME_-248110_SPEC             = 'ANGLES'
      TKFRAME_-248110_UNITS            = 'DEGREES'
      TKFRAME_-248110_AXES             = ( 2,     1,     3   )
      TKFRAME_-248110_ANGLES           = ( 0.0, -90.0,  90.0 )

      FRAME_VEX_ASPERA4_SAF            = -248111
      FRAME_-248111_NAME               = 'VEX_ASPERA4_SAF'
      FRAME_-248111_CLASS              =  3
      FRAME_-248111_CLASS_ID           = -248111
      FRAME_-248111_CENTER             = -248100
      CK_-248111_SCLK                  = -248
      CK_-248111_SPK                   = -248

   \begintext


ASPERA Main Unit Sensor Frames
--------------------------------------

   Because ASPERA-4 main unit sensors are rigidly mounted on the scanner,
   their corresponding frames -- VEX_ASPERA4_ELS, VEX_ASPERA4_NPI,
   VEX_ASPERA4_NPD1, and VEX_ASPERA4_NPD2 -- are defined as fixed-offset
   frames with respect to the VEX_ASPERA4_SAF frame.

   ELS and NPI sensor frames are defined such that their axes are
   co-aligned with the axes of the VEX_ASPERA4_SAF frame and their
   origins are at the sensors' "focal points", located at the
   intersection of the sensor's aperture plane and the sensor's
   symmetry axis.

   NPD1 and NPD2 sensor frames are defined such that their +Y and +Z
   axes are in the sensor's aperture plane, with the +Z axis along the
   central axis of the aperture (view direction of the middle sector),
   and +X axis is perpendicular to the aperture plane and points in
   direction of the SAF frame +X axis. The origins of these frames are
   at the sensor "focal points", which are located in the sensor's
   aperture plane at the point here the sensor sector view directions
   intersect.

   In all cases the "focal point" of a particular sensor is the point
   from which all sensor view direction are emanating.

   This diagram illustrates the ELS, NPI, NPD1, and NPD2 sensor frames
   orientation w.r.t to the SAF, URF and spacecraft frames (for scanner
   at 90 degrees position:


                            +Xels
                             .--- ^ ---. ELS
                             |    |    |
                       +Yels |<---o    | - - - - - - - - - - - - - -
                             |         |               ELS aperture
                            +Xnpi ^ -----. NPI             plane
                          +Xss2 ^ |      |
                        +Ynpi <---o      | - - - - - - - - - - - - -
          ----------- +Yss2 <---o   o---> +Yss1 -.     NPI aperture
         /           .--------------|----------. |         plane
        |            |       +Xsaf^ V +Xss1    | |
         \           |            |            | |
         /           |  +Ysaf <---o    +Xnpd1  | |      YZ of "npd1" frame
        |            |                    ^   +Znpd1   are in the aperture
         \           |                   .-\--.^.|           plane
         /         +Xnpd2         +Ynpd1 <--o'  ||     +Xnpd1 is into the page
        |              ^                 `------'|     +Ynpd1 and +Znpd1 are
         \          .---\---.          NPD1    | |       out of the page
         /    +Ynpd2 <---o  |                  | |
        |           `--.'---' NPD2     Scanner | |      YZ of "npd2" frame
         \    +Znpd2 <'________________________. |     are in the aperture
         /             |                     |   |           plane
        |              |^ +Xurf              |   |
         \             ||              Base  |   |     +Ynpd1 is into the page
          \   +Yurf <---o____________________.   |     +Xnpd1 and +Znpd1 are
           \                                     |       out of the page
     +Xsc   \____                     Nadir deck |
       <---x     \____________                   |
           |                  \__________________|    +Z axes of all frames
           V +Zsc                                       are out of the page
                                                      +Ysc axis is into the
                                                       page.


   These sets of keywords define the VEX_ASPERA4_ELS and VEX_ASPERA4_NPI
   frames:

   \begindata

      FRAME_VEX_ASPERA4_ELS            =  -248120
      FRAME_-248120_NAME               = 'VEX_ASPERA4_ELS'
      FRAME_-248120_CLASS              =  4
      FRAME_-248120_CLASS_ID           =  -248120
      FRAME_-248120_CENTER             =  -248100
      TKFRAME_-248120_RELATIVE         = 'VEX_ASPERA4_SAF'
      TKFRAME_-248120_SPEC             = 'ANGLES'
      TKFRAME_-248120_UNITS            = 'DEGREES'
      TKFRAME_-248120_AXES             = ( 1,   2,   3   )
      TKFRAME_-248120_ANGLES           = ( 0.0, 0.0, 0.0 )

      FRAME_VEX_ASPERA4_NPI            =  -248130
      FRAME_-248130_NAME               = 'VEX_ASPERA4_NPI'
      FRAME_-248130_CLASS              =  4
      FRAME_-248130_CLASS_ID           =  -248130
      FRAME_-248130_CENTER             =  -248100
      TKFRAME_-248130_RELATIVE         = 'VEX_ASPERA4_SAF'
      TKFRAME_-248130_SPEC             = 'ANGLES'
      TKFRAME_-248130_UNITS            = 'DEGREES'
      TKFRAME_-248130_AXES             = ( 1,   2,   3   )
      TKFRAME_-248130_ANGLES           = ( 0.0, 0.0, 0.0 )

   \begintext


   The NPD1 aperture plane is tilted by 15 degrees toward +X axis of
   the SAF frame about +Y/+Z line of the SAF frame. Thus, to align the
   SAF frame with the NPD1 frame the SAF frame has to be rotated by +45
   degrees about X axis and then by +15 degrees about new position of Y
   axis.

   The NPD2 aperture plane is tilted by 15 degrees toward -X axis of
   the SAF frame about -Y/+Z line of the SAF frame. Thus, to align the
   SAF frame with the NPD2 frame the SAF frame has to be rotated by -45
   degrees about X axis and then by -15 degrees about new position of Y
   axis.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   These sets of keywords define the VEX_ASPERA4_NPD1 and VEX_ASPERA4_NPD2
   frames:

   \begindata

      FRAME_VEX_ASPERA4_NPD1           =  -248141
      FRAME_-248141_NAME               = 'VEX_ASPERA4_NPD1'
      FRAME_-248141_CLASS              =  4
      FRAME_-248141_CLASS_ID           =  -248141
      FRAME_-248141_CENTER             =  -248100
      TKFRAME_-248141_RELATIVE         = 'VEX_ASPERA4_SAF'
      TKFRAME_-248141_SPEC             = 'ANGLES'
      TKFRAME_-248141_UNITS            = 'DEGREES'
      TKFRAME_-248141_AXES             = (   1,     2,     1   )
      TKFRAME_-248141_ANGLES           = ( -45.0, -15.0,   0.0 )

      FRAME_VEX_ASPERA4_NPD2           =  -248142
      FRAME_-248142_NAME               = 'VEX_ASPERA4_NPD2'
      FRAME_-248142_CLASS              =  4
      FRAME_-248142_CLASS_ID           =  -248142
      FRAME_-248142_CENTER             =  -248100
      TKFRAME_-248142_RELATIVE         = 'VEX_ASPERA4_SAF'
      TKFRAME_-248142_SPEC             = 'ANGLES'
      TKFRAME_-248142_UNITS            = 'DEGREES'
      TKFRAME_-248142_AXES             = (   1,     2,     1   )
      TKFRAME_-248142_ANGLES           = (  45.0,  15.0,   0.0 )

   \begintext


   The ASPERA-4 Solar Sensor 1 frame, VEX_ASPERA4_SS1, is defined as follows:

      -  +X axis is co-aligned with +X axis of the VEX_ASPERA4_SAF
         frame;

      -  +Z axis is 15 degrees off +Z axis of the VEX_ASPERA4_SAF frame
         toward -Y axis of VEX_ASPERA4_SAF frame;

      -  +Y completes the right handed frame and is along the sensor
         boresight direction;

      -  the origin of the frame is located at the sensor's FOV focal
         point.


   The ASPERA-4 Solar Sensor 2 frame, VEX_ASPERA4_SS2, is defined as follows:

      -  +X axis is co-aligned with -X axis of the VEX_ASPERA4_SAF
         frame;

      -  +Z axis is 15 degrees off +Z axis of the VEX_ASPERA4_SAF frame
         toward +Y axis of VEX_ASPERA4_SAF frame;

      -  +Y completes the right handed frame and is along the sensor
         boresight direction;

      -  the origin of the frame is located at the sensor's FOV focal
         point.


   This diagram illustrates the VEX_ASPERA4_SS1 and VEX_ASPERA4_SS2
   frames:


                                  ^ +Zsaf
                                  |
                         +Zss1 ^  |  ^ +Zss2
                              ..\.|./..
                           .'    \|/    `.
               +Yss2 <-. .'       |       `. .-> +Yss1
                        `-.      /|\      .-'
                       .   `-.  / | \  .-'   .
                       . +Xss2`x  |  o'+Xss1 .
                       .          o--------------> +Ysaf
                       .           +Xsaf     .
                       .                     .
                        .                   .
                         .                 .
                          `.             .'
                            ` ......... '


   Both frames are defined as fixed offset frames with respect to the
   VEX_ASPERA4_SAF frame.

   To align the SAF frame with the SS1 frame the SAF frame has to be
   rotated by +15 degrees about X axis.

   To align the SAF frame with the SS2 frame the SAF frame has to be
   rotated by 180 degrees about Z axis and then by +15 degrees about
   new position of X axis.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   These sets of keywords define the VEX_ASPERA4_SS1 and VEX_ASPERA4_SS2
   frames:

   \begindata

      FRAME_VEX_ASPERA4_SS1            =  -248161
      FRAME_-248161_NAME               = 'VEX_ASPERA4_SS1'
      FRAME_-248161_CLASS              =  4
      FRAME_-248161_CLASS_ID           =  -248161
      FRAME_-248161_CENTER             =  -248100
      TKFRAME_-248161_RELATIVE         = 'VEX_ASPERA4_SAF'
      TKFRAME_-248161_SPEC             = 'ANGLES'
      TKFRAME_-248161_UNITS            = 'DEGREES'
      TKFRAME_-248161_AXES             = (   3,   2,     1   )
      TKFRAME_-248161_ANGLES           = (   0.0, 0.0, -15.0 )

      FRAME_VEX_ASPERA4_SS2            =  -248162
      FRAME_-248162_NAME               = 'VEX_ASPERA4_SS2'
      FRAME_-248162_CLASS              =  4
      FRAME_-248162_CLASS_ID           =  -248162
      FRAME_-248162_CENTER             =  -248100
      TKFRAME_-248162_RELATIVE         = 'VEX_ASPERA4_SAF'
      TKFRAME_-248162_SPEC             = 'ANGLES'
      TKFRAME_-248162_UNITS            = 'DEGREES'
      TKFRAME_-248162_AXES             = (   3,   2,     1   )
      TKFRAME_-248162_ANGLES           = ( 180.0, 0.0, -15.0 )

   \begintext


ASPERA-4 Ion Mass Analyzer Unit Frames
--------------------------------------

   The ASPERA-4 IMA unit is rigidly mounted in the +X/+Y quadrant of the
   on the S/C -Z ("main engine") deck and has no moving parts.
   Therefore, the three ASPERA IMA frames -- IMA Unit Reference Frame
   (VEX_ASPERA4_IMA_URF), IMA sensor frame (VEX_ASPERA4_IMA), and IMA
   sensor head frame (VEX_ASPERA4_IMAS) -- are defined as fixed offset
   frames.

   The VEX_ASPERA4_IMA_URF frame is defined as follows:

      -  +Z axis is normal to the UMA unit mounting plate and points
         from the the mounting plate toward the sensor (nominally this
         axis is co-aligned with the S/C -Z axis);

      -  +X axis is parallel to the longer side of the IMA unit base
         and sensor symmetry axis and points toward the sensors
         aperture side (nominally this axis is co-aligned with
         the S/C +Y axis);

      -  +Y completes the right handed frame;

      -  the origin of the frame is located at the intersection of the
         mounting surface of the IMA unit base and the axis of the
         mounting screw hole located far right from the sensor aperture
         (as seen on the top view with the sensor aperture at the bottom
         on the page)

   The VEX_ASPERA4_IMA frame is defined such that its axes are
   co-aligned with the axes of the VEX_ASPERA4_IMA_URF frame and its
   origin is at the sensor's "focal point", located at the intersection
   of the sensor's aperture symmetry plane and the sensor's symmetry
   axis.

   The VEX_ASPERA4_IMAS frame is defined such that its axes are aligned
   with the axes of the VEX_ASPERA4_IMA frame as follows:

      -  +Z-imas points along the +X-ima axis

      -  +X-imas axis points along the +Y-ima axis

      -  +Y-imas axis points along the +Z-ima axis

   The origin of the VEX_ASPERA4_IMAS is also at the sensor's "focal point".


   These diagrams illustrate the VEX_ASPERA4_IMA_URF, VEX_ASPERA4_IMA, and
   VEX_ASPERA4_IMAS frames:

   -Z S/C side view ("main engine" side):
   --------------------------------------


                                    +Ximas
                            HGA1    +Yima ^+Yimau
                               _________^_|
                               \+Xsc^   |/|
       _________________      __`.__|__.|_|    +Ximau_____________
      |                 \    |      |   | o---->/                 |
      |                  \   |      |   o----->+Zimas             |
      |                   |  |      |      |  +Xima               |
      |                   |o=|      x-------> |                   |
      |                   |  |            +Ysc|                   |
      |                  /   |             |   \                  |
      ._________________/    ._____________.    \_________________.
       -Y Solar Array                               +Y Solar Array



                                          +Zsc is into the page
                                        +Zima, +Zimau, and +Yimas
                                           are out of the page


   -Z S/C side view ("main engine" side) -- zoom in:
   -------------------------------------------------

                                                              +Zsc
                           --                         <-------x
                          |  \                     +Ysc       |
                          |   \__                             |
                          |      \_________                   |
                          |                \                  |
                          |                 \                 v
                IMA       |._____________.   \               +Xsc
               Aperture   || o         o |    \
                   .___________________. |     \____
          +Zimas   | |  +Yimas         | |          \
          +Xima    | |  +Zima          | |           \
               <-------o |             | |            \
                   | | | |             | |   IMA       |
                   | | | |             | | Mounting     \
                   .___|_______________. |   plate      |
                       |  || o <-------o |              |
                +Ximas V  |. +Ximau ___|_.             /
                +Yima     |            |               | "Main Engine"
                          .____________|_______________/      Deck
                                       |
                                +Yimau V


   As seen in the diagram two rotations are needed to align the S/C
   frame (VEX_SPACECRAFT) with the IMA URF frame (VEX_ASPERA4_IMA_URF)
   -- first rotation is by 180 degrees about Y axis, and then by +90
   degrees about new position of Z axis.

   No rotations are needed to align the IMA URF frame
   (VEX_ASPERA4_IMA_URF) with the IMA sensor frame (VEX_ASPERA4_IMA).

   Two rotations -- first by +90 degrees about X axis and then by +90
   degrees about Y axis -- are needed to align the IMA sensor frame
   (VEX_ASPERA4_IMA) with the IMA sensor head frame (VEX_ASPERA4_IMAS).

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_VEX_ASPERA4_IMA_URF        =  -248150
      FRAME_-248150_NAME               = 'VEX_ASPERA4_IMA_URF'
      FRAME_-248150_CLASS              =  4
      FRAME_-248150_CLASS_ID           =  -248150
      FRAME_-248150_CENTER             =  -248100
      TKFRAME_-248150_RELATIVE         = 'VEX_SPACECRAFT'
      TKFRAME_-248150_SPEC             = 'ANGLES'
      TKFRAME_-248150_UNITS            = 'DEGREES'
      TKFRAME_-248150_AXES             = ( 1,     2,     3   )
      TKFRAME_-248150_ANGLES           = ( 0.0, 180.0, -90.0 )

      FRAME_VEX_ASPERA4_IMA            =  -248151
      FRAME_-248151_NAME               = 'VEX_ASPERA4_IMA'
      FRAME_-248151_CLASS              =  4
      FRAME_-248151_CLASS_ID           =  -248151
      FRAME_-248151_CENTER             =  -248100
      TKFRAME_-248151_RELATIVE         = 'VEX_ASPERA4_IMA_URF'
      TKFRAME_-248151_SPEC             = 'ANGLES'
      TKFRAME_-248151_UNITS            = 'DEGREES'
      TKFRAME_-248151_AXES             = ( 1,   2,   3   )
      TKFRAME_-248151_ANGLES           = ( 0.0, 0.0, 0.0 )

      FRAME_VEX_ASPERA4_IMAS           =  -248152
      FRAME_-248152_NAME               = 'VEX_ASPERA4_IMAS'
      FRAME_-248152_CLASS              =  4
      FRAME_-248152_CLASS_ID           =  -248152
      FRAME_-248152_CENTER             =  -248100
      TKFRAME_-248152_RELATIVE         = 'VEX_ASPERA4_IMA'
      TKFRAME_-248152_SPEC             = 'ANGLES'
      TKFRAME_-248152_UNITS            = 'DEGREES'
      TKFRAME_-248152_AXES             = ( 3  ,   1,     2   )
      TKFRAME_-248152_ANGLES           = ( 0.0, -90.0, -90.0 )

   \begintext


MAG Frames
========================================================================

   This section of the file contains the definitions of the Magnetometer
   frames.


MAG Frame Tree
--------------------------------------

   The diagram below shows the MAG frame hierarchy.


                               "J2000" INERTIAL
           +-----------------------------------------------------+
           |                          |                          |
           |<-pck                     |                          |<-pck
           |                          |                          |
           V                          |                          V
      "IAU_VENUS"                     |                     "IAU_EARTH"
    VENUS BODY-FIXED                  |                   EARTH BODY-FIXED
    ----------------                  |                   ----------------
                                      |
                                      |<-ck
                                      |
                                      V
                               "VEX_SPACECRAFT"
                               ----------------
                                      |
                                      |<-fixed
                                      |
                                      V
                                  "VEX_MAG"
                    +------------------------------+
                    |                              |
                    |<-fixed                fixed->|
                    |                              |
                    V                              V
            "VEX_MAG_MAGB-H"               "VEX_MAG_MAGIS"
            ----------------               ---------------
                    |
                    |<-ck
                    |
                    V
             "VEX_MAG_MAGB"
             --------------
                    |
                    |<-fixed
                    |
                    V
             "VEX_MAG_MAGOS"
             ---------------


MAG Boom hinge and MAGIS Frames
--------------------------------------

   The Magnetometer's boom hinge  and MAGIS sensor frames -- VEX_MAG_MAGB-H
   and VEX_MAG_MAGIS -- are defined based as follows (from [7]):

      -  +Z axis is nominally co-aligned with the S/C +Z mechanical
         axis;

      -  +X axis is nominally co-aligned with the S/C +X mechanical
         axis, pointing toward the HGA-1;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at each respective reference
         hole.


   This diagram illustrates the MAGIS and Magnetometer's boom hinge frames:


   +Y S/C side view:
   -----------------
                                           ^
                        +Zhinge            |
                               ^           |
                               |^+Zmagis   | toward Venus
                               ||
                        +Yhinge||
               +Xhinge <-------o|+Ymagis
                         <------o__________.
                    +Xmagis  | Science Deck|
                         |`. |             |
                         |  \|  +Zsc       |
                         |   |      ^      |
                    HGA1 |   |      |      |
                         |   |      |      |
                         |  /|      |      |
                         |.' |      |+Ysc  |
                            <-------o _____|
                          +Xsc

                                        +Y solar array is not shown

                                         +Ysc, +Ymagis, and +Yhinge
                                           are out of the page


   As shown on the diagram, no rotation is required to co-align the S/C
   frame with neither the Magnetometer's boom hinge nor the MAGIS sensor
   frame.

   \begindata

      FRAME_VEX_MAG_MAGB-H             =  -248200
      FRAME_-248200_NAME               = 'VEX_MAG_MAGB-H'
      FRAME_-248200_CLASS              =  4
      FRAME_-248200_CLASS_ID           =  -248200
      FRAME_-248200_CENTER             =  -248200
      TKFRAME_-248200_RELATIVE         = 'VEX_SPACECRAFT'
      TKFRAME_-248200_SPEC             = 'ANGLES'
      TKFRAME_-248200_UNITS            = 'DEGREES'
      TKFRAME_-248200_ANGLES           = ( 0.0, 0.0, 0.0 )
      TKFRAME_-248200_AXES             = ( 2,   3,   1   )

      FRAME_VEX_MAG_MAGIS              =  -248210
      FRAME_-248210_NAME               = 'VEX_MAG_MAGIS'
      FRAME_-248210_CLASS              =  4
      FRAME_-248210_CLASS_ID           =  -248210
      FRAME_-248210_CENTER             =  -248200
      TKFRAME_-248210_RELATIVE         = 'VEX_SPACECRAFT'
      TKFRAME_-248210_SPEC             = 'ANGLES'
      TKFRAME_-248210_UNITS            = 'DEGREES'
      TKFRAME_-248210_ANGLES           = ( 0.0, 0.0, 0.0 )
      TKFRAME_-248210_AXES             = ( 2,   3,   1   )

    \begintext


MAG Boom Frame
--------------------------------------

   Since both, pre- and post- deployment orientation of the Magnetometer's
   boom could be required for MAG data analysis, the boom's frame is defined
   as a CK-based frame with its orientation provided in CK files. This frame
   is describing the time dependent relationship between the Magnetometer's
   boom hinge and MAGOS fixed frames.

   The Magnetometer's boom frame is defined as follows:

       -  +Z axis is parallel to the boom and points from the boom
         deployment hinge toward its tip; and in deployed configuration
         is nominally co-aligned with the S/C +Z axis;

      -  +Y axis is parallel to the Magnetometer's hinge rotation axis, +Y
         and nominally co-aligned with the S/C +Y axis;

      -  +X axis completes the right hand frame;

      -  the origin of the frame is located at the boom's hinge geometrical
         center.


   This diagram illustrates the Magnetometer's boom frame:

   +Z S/C side view (Magnetometer's boom is showed in deployed position):
   ----------------------------------------------------------------------

                             ._____________
                             |             |
                             |             |
                             |  +Zsc       | +Ysc
   o==/ /==================o |      o------->o==================/ /==o
     -Y Solar Array          |      |      |          +Y Solar Array
                           +Zboom   |      |
                             |o----->+Yboom|
                             -|-----V------'
                              |.' +Xsc  `. HGA1
                              |___________\
                        +XboomV                 +Zsc and +Zboom
                                                point out of the page


   These sets of keywords define the Magnetometer's boom frame as CK frame:

   \begindata

      FRAME_VEX_MAG_MAGB               =  -248201
      FRAME_-248201_NAME               = 'VEX_MAG_MAGB'
      FRAME_-248201_CLASS              =  3
      FRAME_-248201_CLASS_ID           =  -248201
      FRAME_-248201_CENTER             =  -248200
      CK_-248201_SCLK                  =  -248
      CK_-248201_SPK                   =  -248

   \begintext


MAG MAGOS Frame
--------------------------------------

    The MAGOS sensor frame -- VEX_MAG_MAGOS -- is defined as follows
    (from [7]):

      -  +Z axis is parallel to the boom and points from the boom
         deployment hinge toward the sensor; and in deployed configuration
         is nominally co-aligned with the S/C +Z axis;

      -  +X axis is nominally co-aligned with the boom's +X axis; and
         in deployed configuration it is also co-aligned with the S/C +X
         axis;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the geometric center of
         the sensor.


   This diagram illustrates the MAG MAGOS frame:

   +Y S/C side view (Magnetometer's boom is showed in deployed position):
   ----------------------------------------------------------------------


                               ^+Zmagos
                               |           ^
                               |           |
                     +Xmagos  _|+Ymagos    |
                         <-----o|          | toward Venus
                              |^
                              ||+Zboom
                              ||
                    +Xboom    ||+Yboom
                         <-----o___________.
                             | Science Deck|
                         |`. |             |
                         |  \|  +Zsc       |
                         |   |      ^      |
                    HGA1 |   |      |      |
                         |   |      |      |
                         |  /|      |      |
                         |.' |      |+Ysc  |
                            <-------o _____|
                          +Xsc

                                        +Y solar array is not shown

                                         +Ysc, +Yboom, and +Ymagos
                                           are out of the page


   As shown on the diagram, nominally no rotation is needed to co-align
   the Magnetometer's boom frame with the MAG MAGOS frame.

   \begindata

      FRAME_VEX_MAG_MAGOS              =  -248220
      FRAME_-248220_NAME               = 'VEX_MAG_MAGOS'
      FRAME_-248220_CLASS              =  4
      FRAME_-248220_CLASS_ID           =  -248220
      FRAME_-248220_CENTER             =  -248220
      TKFRAME_-248220_RELATIVE         = 'VEX_MAG_MAGB'
      TKFRAME_-248220_SPEC             = 'ANGLES'
      TKFRAME_-248220_UNITS            = 'DEGREES'
      TKFRAME_-248220_ANGLES           = ( 0.0, 0.0, 0.0 )
      TKFRAME_-248220_AXES             = ( 2,   3,   1   )

   \begintext


PFS Frames
========================================================================

   This section of the file contains the definitions of the PFS frames.


PFS Frame Tree
--------------------------------------

   The diagram below shows the PFS frame hierarchy.


                               "J2000" INERTIAL
           +-----------------------------------------------------+
           |                          |                          |
           |<-pck                     |                          |<-pck
           |                          |                          |
           V                          |                          V
      "IAU_VENUS"                     |                     "IAU_EARTH"
    VENUS BODY-FIXED                  |                   EARTH BODY-FIXED
    ----------------                  |                   ----------------
                                      |
                                      |<-ck
                                      |
                                      V
                               "VEX_SPACECRAFT"
                               ----------------
                                      |
                                      |<-fixed
                                      |
                                      V
                                "VEX_PFS_BASE"
                                --------------
                                      |
                                      |<-ck
                                      |
                                      V
                              "VEX_PFS_SCANNER"
                             +-----------------+
                             |                 |
                             |<-fixed          |<-fixed
                             |                 |
                             V                 V
                       "VEX_PFS_SWC"     "VEX_PFS_LWC"
                       -------------     -------------


PFS Base and Scanner Frames
--------------------------------------

   The PFS instrument is rigidly mounted on the S/C science
   deck. Therefore, the PFS base frame, VEX_PFS_BASE, is a fixed offset
   frame with its orientation given relative to the VEX_SPACECRAFT frame.

   The VEX_PFS_BASE frame is defined by the instrument design and its
   mounting on the S/C as follows (from [8] and [9]):

      -  +Y axis is along the nominal PFS 'S' module scanner rotation
         axis and nominal PFS 'O' module optical axis, and points from the
         PFS 'S' module toward the PFS 'O' module; nominally this axis
         is co-aligned with the S/C +Y axis;

      -  +Z axis is parallel to the nominal direction of the PFS 'S'
         scanner boresight in its 'nadir' (zero) position; it nominally
         points in the same direction as the S/C +Z axis;

      -  +X completes the right hand frame; it nominally points
         in the same direction as the S/C +X axis;

      -  the origin of this frame is located at the intersection of the
         PFS 'S' scanner rotation axis and the scanner cylinder central
         axis.


   Nominally this frame is co-aligned with the S/C frame. Any misalignment
   between nominal and actual PFS mounting alignment measured pre-launch
   can be incorporated into the definition of this frame.

   Since the PFS 'S' scanner rotates with respect to its base, the
   VEX_PFS_SCANNER frame is defined as a CK frame with its orientation
   provided in a CK file relative to the VEX_PFS_BASE frame.

   The VEX_PFS_SCANNER frame is defined as follows:

      -  +Y axis is along the nominal PFS 'S' module scanner rotation
         axis and nominal PFS 'O' module optical axis, and points from the
         PFS 'S' module toward PFS 'O' module; nominally this axis
         is co-aligned with the +Y axis of the VEX_PFS_BASE frame;

      -  +Z axis is parallel to the PFS 'S' scanner boresight; in 'nadir'
         scanner position it is co-aligned with the +Z axis of
         the VEX_PFS_BASE frame;

      -  +X completes the right hand frame;

      -  the origin of this frame is located at the intersection of the
         PFS 'S' scanner rotation axis and the scanner central axis.


   For an arbitrary scanner angle, the VEX_PFS_SCANNER frame is rotated by
   this angle about the +Y axis with respect to the VEX_PFS_BASE frame.

   Possible nominal scanner angels are (in degrees), taken from [9]:
        -25.0, -12.5, -10.0, -7.5, -5.0, -2.5,   0.0
        +25.0, +12.5, +10.0, +7.5, +5.0, +2.5, +85.0

   These diagrams illustrate the VEX_PFS_BASE and VEX_PFS_SCANNER
   frames for scanner angles of +25 degrees ('25 left') and -25 degrees
   ('25 right'). Both diagrams are +Y S/C side view:


   Scanner in '25 left' position     Scanner in '25 right' position
   -----------------------------     ------------------------------

                +Zbase                          +Zbase
       +Zscan   ^                                  ^     +Zscan
            ^   |                       +Xscan     |   ^
             \  |       Science              ^.    |  /     Science
              \ | PFS     Deck                 `.  | /        Deck
               \|___________.                    `.|/__________.
        <-------o |         |              <-------o |         |
    +Xbase    .'  | =o========         +Xbase    |   | =o========
            .'|___.       SA+Y                 PFS___.       SA+Y
          <'  |   +Zsc      |                    |   +Zsc      |
       +Xscan |      ^      |                    |      ^      |
              |      |      |                    |      |      |
              |      |      |                    |      |      |
              .______|______.                    .______|______.
                |    |    |                        |    |    |
             <-------o____.                     <-------o____.
            +Xsc   / +Ysc                      +Xsc   / +Ysc
                  /_____\                            /_____\
                 Main Engine                         Main Engine

                     +Ysc, +Ybase, and +Yscan are out of the page


   Given that the scanner got stuck after launch, it could not
   rotate, therefore disabling the instrument. This is why the
   frame VEX_PFS_SCANNER is defined as a FIXED frame (as compared
   to former versions of this kernel).

   These sets of keywords define PFS base and scanner frames:

   \begindata

      FRAME_VEX_PFS_BASE              =  -248300
      FRAME_-248300_NAME              = 'VEX_PFS_BASE'
      FRAME_-248300_CLASS             =  4
      FRAME_-248300_CLASS_ID          =  -248300
      FRAME_-248300_CENTER            =  -248300
      TKFRAME_-248300_RELATIVE        = 'VEX_SPACECRAFT'
      TKFRAME_-248300_SPEC            = 'ANGLES'
      TKFRAME_-248300_UNITS           = 'DEGREES'
      TKFRAME_-248300_AXES            = ( 1,   2,   3   )
      TKFRAME_-248300_ANGLES          = ( 0.0, 0.0, 0.0 )

      FRAME_VEX_PFS_SCANNER           = -248310
      FRAME_-248310_NAME              = 'VEX_PFS_SCANNER'
      FRAME_-248310_CLASS             =  4
      FRAME_-248310_CLASS_ID          =  -248310
      FRAME_-248310_CENTER            =  -248300
      TKFRAME_-248310_RELATIVE        = 'VEX_PFS_BASE'
      TKFRAME_-248310_SPEC            = 'ANGLES'
      TKFRAME_-248310_UNITS           = 'DEGREES'
      TKFRAME_-248310_AXES            = ( 1,   2,   3   )
      TKFRAME_-248310_ANGLES          = ( 0.0, 0.0, 0.0 )

   \begintext


PFS Detector Frames
--------------------------------------

   Since both PFS detectors receive radiation through the scanner
   and both essentially have a single pixel, their frames, VEX_PFS_SWC
   and VEX_PFS_LWC, are defined to be nominally co-aligned with the PFS
   scanner frame, VEX_PFS_SCANNER. These frames are introduced to allow
   incorporating into the PFS frame chain any misalignment between the
   scanner boresight direction and the individual detector view directions
   measured prior to delivering the instrument for installation
   on the S/C.

   Currently no misalignment data are available, and, therefore, the set
   of keywords below makes these frames co-aligned with their reference.

   \begindata

      FRAME_VEX_PFS_SWC               =  -248320
      FRAME_-248320_NAME              = 'VEX_PFS_SWC'
      FRAME_-248320_CLASS             =  4
      FRAME_-248320_CLASS_ID          =  -248320
      FRAME_-248320_CENTER            =  -248300
      TKFRAME_-248320_RELATIVE        = 'VEX_PFS_SCANNER'
      TKFRAME_-248320_SPEC            = 'ANGLES'
      TKFRAME_-248320_UNITS           = 'DEGREES'
      TKFRAME_-248320_AXES            = ( 1,   2,   3   )
      TKFRAME_-248320_ANGLES          = ( 0.0, 0.0, 0.0 )

      FRAME_VEX_PFS_LWC               =  -248320
      FRAME_-248320_NAME              = 'VEX_PFS_LWC'
      FRAME_-248320_CLASS             =  4
      FRAME_-248320_CLASS_ID          =  -248320
      FRAME_-248320_CENTER            =  -248300
      TKFRAME_-248320_RELATIVE        = 'VEX_PFS_SCANNER'
      TKFRAME_-248320_SPEC            = 'ANGLES'
      TKFRAME_-248320_UNITS           = 'DEGREES'
      TKFRAME_-248320_AXES            = ( 1,   2,   3   )
      TKFRAME_-248320_ANGLES          = ( 0.0, 0.0, 0.0 )

   \begintext


SPICAV Frames
========================================================================

   This section of the file contains the definitions of the SPICAV
   frames.


SPICAV Frame Tree
--------------------------------------

   The diagram below shows the SPICAV frame hierarchy.


                               "J2000" INERTIAL
           +-----------------------------------------------------+
           |                          |                          |
           |<-pck                     |                          |<-pck
           |                          |                          |
           V                          |                          V
      "IAU_VENUS"                     |                     "IAU_EARTH"
    VENUS BODY-FIXED                  |                   EARTH BODY-FIXED
    ----------------                  |                   ----------------
                                      |
                                      |<-ck
                                      |
                                      V
                               "VEX_SPACECRAFT"
                               ----------------
                                      |
                                      |<-fixed
                                      |
                                      V
                               "VEX_SPICAV_BASE"
           +-------------------------------------------------+
           |           |           |           |             |
           |<-fixed    |<-fixed    |<--fixed   |<--fixed     |<-fixed
           |           |           |           |             |
           V           |           V           |             v
    "VEX_SPICAV_SIR"   |    "VEX_SPICAV_SUV"   |     "VEX_SPICAV_SOIR"
    ----------------   |    ----------------   |     -----------------
                       V                       V
            "VEX_SPICAV_SIR_SOLAR"   "VEX_SPICAV_SUV_SOLAR"
            ----------------------   ----------------------


SPICAV Base Frame
--------------------------------------

   The SPICAV base frame is defined by the instrument design and its
   mounting on the S/C as follows:

      -  +Z axis is in the nominal direction of the SPICAV SUV/nadir and
         IR detector boresights; it nominally points in the direction of the
         S/C +Z axis;

      -  +X axis is parallel to the nominal direction of SPICAV SUV CCD
         columns; it is nominally along the S/C +X axis;

      -  +Y completes the right hand frame; it is nominally along
         the S/C +Y axis; (*)

      -  the origin of the frame is located at the SPICAV SUV detector
         focal point.


   (*) SPICAV SUV spectral dimension is along CCD lines, which are parallel
   to Y,Z plane. SPICAV SIR has a single pixel.

   Because the SPICAV instrument is rigidly mounted to the S/C, the SPICAV
   base frame is defined as a fixed-offset frame with its orientation
   given relative to the VEX_SPACECRAFT frame. Any misalignment between the
   nominal and actual SPICAV mounting alignment measured pre-launch
   can be incorporated into the definition of this frame.

   This diagram illustrates the nominal VEX_SPICAV_BASE frame with respect
   to the spacecraft frame.


   +Z S/C side view:
   -----------------

      .________________.     ._____SPICAV__. +Ysbase______________.
      |                 \    |       ' o------> /                 |
      |                  \   |       | | | |   /                  |
      |                   |. |  +Zsc  -|- +Ysc|                   |
      |                   | o|      o--|---->o|                   |
      |                   |' |      |  V   |  |                   |
      |                  /   |      | +Xsbase  \                  |
      ._________________/    .______|______.    \_________________.
       -Y Solar Array             . | .             +Y Solar Array
                          HGA1  .'  V +Xsc
                               /_________\



                                             +Zsc and +Zsbase are
                                                 out of the page


   Nominally, the SPICAV base frame is co-aligned the S/C frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_VEX_SPICAV_BASE           =  -248400
      FRAME_-248400_NAME              = 'VEX_SPICAV_BASE'
      FRAME_-248400_CLASS             =  4
      FRAME_-248400_CLASS_ID          =  -248400
      FRAME_-248400_CENTER            =  -248400
      TKFRAME_-248400_RELATIVE        = 'VEX_SPACECRAFT'
      TKFRAME_-248400_SPEC            = 'ANGLES'
      TKFRAME_-248400_UNITS           = 'DEGREES'
      TKFRAME_-248400_AXES            = (   1,       2,       3     )
      TKFRAME_-248400_ANGLES          = ( 000.000, 000.000, 000.000 )

   \begintext


SPICAV Detector Frames
--------------------------------------

   The SPICAV detector nadir port frames -- VEX_SPICAV_SUV and
   VEX_SPICAV_SIR -- are defined exactly as, and are nominally co-aligned
   with, the SPICAV base frame VEX_SPICAV_BASE. These frames are
   introduced to allow incorporating into the SPICAV frame chain any
   misalignment between the instrument base and detectors measured prior
   to delivering the instrument for installation on the S/C.

   The SPICAV SIR and SUV detector solar port frames -- VEX_SPICAV_SIR_SOLAR
   and VEX_SPICAV_SUV_SOLAR -- and the SPICAV SOIR detector frame --
   VEX_SPICAV_SOIR -- are defined in the same way as follows:

      -  +Z axis points along SIR/SUV/SOIR solar port boresight;

      -  +X axis is parallel to the Sensor Unit assembly symmetry axis
         and points toward the SPICAV SUV/SIR/SOIR opening side; it points
         nominally along the S/C +Z axis;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the SPICAV SIR/SUV/SOIR
         detector focal point.


   SPICAV solar ports are located in the +Y wall of the S/C, pointing +30
   degrees off from the +X SPICAV base frame axis, within the +X/+Y plane.

   This diagram illustrates all five SPICAV detector port frames:


   +Z S/C side view:
   -----------------



   __ ______         .________SPICAV_ _+Ysir_____.         ____________ ___
  |  \\     \        |           |o------->      |        /            \\  |
  |  //      \       |           || o-------->   |       /             //  |
  |  \\       \      |           || |     | +Ysuv|      /              \\  |
  |  //        \     |       +Xsir| |     | +Ysbase    /               //  |
  |  \\         \    |           |v |     |      |    /                \\  |
  |  //          \   |        +Xsuv_|____o.      |   /                 //  |
  |  \\           |==|      +Xsbase v  .' \      |==|                  \\  |
  |  //           |  |               .'    \     |  |            +Ysc  //  |
  |  \\           |==|             .'       \    |==|         ----->   \\  |
  |  //          /   |           v'          \  +Zsir_solar            //  |
  |  \\         /    | +Ysir_solar            V +Zsuv_solar            \\  |
  |  //        /     | +Ysuv_solar              +Zsoir \               //  |
  |  \\       /      |   +Ysoir          |<--->\ |      \              \\  |
  |  //      /       |             |     30 deg  |       \             //  |
  |__\\_____/        ._____________|_____________.        \____________\\__|
   -Y Solar Array           .'     |      '.                 +Y Solar Array
                          .'       | +Xsc   '.
                         / HGA1    V          \
                        .______________________.


                                             +Zsc, +Zsbase, +Zsuv,
                                             +Zsir, +Xsir_solar, +Xsoir
                                             +Xsuv_solar are out of
                                              the page

   Nominally, the SPICAV SIR and SUV frames are co-aligned the SPICAV base
   frame while the SPICAV SIR and SUV solar port frames
   frame are first rotated from the SPICAV base frame by -90 degrees about
   +Y, and then rotated by -150 degrees about the new position of +X.

   MB: The SPICAV SOIR is first rotated from the SPICAV base frame by -90
   degrees about +Y, and then rotated by -150.2167 degrees about the new
   position of +X. The SPICAV SOIR frame is then rotated by +0.1166 degrees
   about the new +Y axis.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.


   \begindata

      FRAME_VEX_SPICAV_SIR            =  -248410
      FRAME_-248410_NAME              = 'VEX_SPICAV_SIR'
      FRAME_-248410_CLASS             =  4
      FRAME_-248410_CLASS_ID          =  -248410
      FRAME_-248410_CENTER            =  -248
      TKFRAME_-248410_RELATIVE        = 'VEX_SPICAV_BASE'
      TKFRAME_-248410_SPEC            = 'ANGLES'
      TKFRAME_-248410_UNITS           = 'DEGREES'
      TKFRAME_-248410_AXES            = (   1,       2,       3     )
      TKFRAME_-248410_ANGLES          = ( 000.000, 000.000, 000.000 )

      FRAME_VEX_SPICAV_SUV            =  -248420
      FRAME_-248420_NAME              = 'VEX_SPICAV_SUV'
      FRAME_-248420_CLASS             =  4
      FRAME_-248420_CLASS_ID          =  -248420
      FRAME_-248420_CENTER            =  -248
      TKFRAME_-248420_RELATIVE        = 'VEX_SPICAV_BASE'
      TKFRAME_-248420_SPEC            = 'ANGLES'
      TKFRAME_-248420_UNITS           = 'DEGREES'
      TKFRAME_-248420_AXES            = (   1,       2,       3     )
      TKFRAME_-248420_ANGLES          = ( 000.000, 000.000, 000.000 )

      FRAME_VEX_SPICAV_SIR_SOLAR      =  -248411
      FRAME_-248411_NAME              = 'VEX_SPICAV_SIR_SOLAR'
      FRAME_-248411_CLASS             =  4
      FRAME_-248411_CLASS_ID          =  -248411
      FRAME_-248411_CENTER            =  -248
      TKFRAME_-248411_RELATIVE        = 'VEX_SPICAV_BASE'
      TKFRAME_-248411_SPEC            = 'ANGLES'
      TKFRAME_-248411_UNITS           = 'DEGREES'
      TKFRAME_-248411_AXES            = (   3,       2,       1     )
      TKFRAME_-248411_ANGLES          = ( 000.000,  90.000, 150.000 )

      FRAME_VEX_SPICAV_SUV_SOLAR      =  -248421
      FRAME_-248421_NAME              = 'VEX_SPICAV_SUV_SOLAR'
      FRAME_-248421_CLASS             =  4
      FRAME_-248421_CLASS_ID          =  -248421
      FRAME_-248421_CENTER            =  -248
      TKFRAME_-248421_RELATIVE        = 'VEX_SPICAV_BASE'
      TKFRAME_-248421_SPEC            = 'ANGLES'
      TKFRAME_-248421_UNITS           = 'DEGREES'
      TKFRAME_-248421_AXES            = (   3,       2,       1     )
      TKFRAME_-248421_ANGLES          = ( 000.000,  90.000, 150.000 )

      FRAME_VEX_SPICAV_SOIR           =  -248430
      FRAME_-248430_NAME              = 'VEX_SPICAV_SOIR'
      FRAME_-248430_CLASS             =  4
      FRAME_-248430_CLASS_ID          =  -248430
      FRAME_-248430_CENTER            =  -248400
      TKFRAME_-248430_RELATIVE        = 'VEX_SPICAV_BASE'
      TKFRAME_-248430_SPEC            = 'ANGLES'
      TKFRAME_-248430_UNITS           = 'DEGREES'
      TKFRAME_-248430_AXES            = (   2,        1,        2     )
      TKFRAME_-248430_ANGLES          = ( 90.07669, 150.26672,  0.0   )

   \begintext


VIRTIS frames
========================================================================

   This section of the file contains the definitions of the VIRTIS
   frames.


VIRTIS Frame Tree
--------------------------------------

   The diagram below shows the VIRTIS frame hierarchy.


                               "J2000" INERTIAL
           +-----------------------------------------------------+
           |                          |                          |
           |<-pck                     |                          |<-pck
           |                          |                          |
           V                          |                          V
      "IAU_VENUS"                     |                     "IAU_EARTH"
    VENUS BODY-FIXED                  |                   EARTH BODY-FIXED
    ----------------                  |                   ----------------
                                      |
                                      |<-ck
                                      |
                                      V
                               "VEX_SPACECRAFT"
                        +--------------------------+
                        |                          |
                        |<-fixed                   |<-fixed
                        |                          |
                        V                          |
                  "VEX_VIRTIS-H"                   |
                  --------------                   |
                                                   |
                                                   V
                                            "VEX_VIRTIS-M"
               +---------------------------------------------+
               |                      |                      |
               |<-fixed               |<-ck                  |<-fixed
               |                      |                      |
               V                      V                      V
    "VEX_VIRTIS-M_VIS_ZERO"   "VEX_VIRTIS-M_SCAN"   "VEX_VIRTIS-M_IR_ZERO"
    -----------------------   +-----------------+   ----------------------
                              |                 |
                              |<-fixed          |<-fixed
                              |                 |
                              V                 V
                     "VEX_VIRTIS-M_VIS"  "VEX_VIRTIS-M_IR"
                     ------------------  -----------------


VIRTIS Frames
--------------------------------------

   The six different frames are defined for VIRTIS-M instrument with
   the following intent:

      Frame Name              Frame Intent
      --------------------    --------------------------------------
      VEX_VIRTIS-M            This frame is defined to capture
                              misalignment between the instrument
                              mirror rotation axis and the S/C +Y axis.
                              This misalignment is constant therefore
                              this frame is defined as a fixed offset
                              frame relative to the VEX_SPACECRAFT
                              frame.

      VEX_VIRTIS-M_SCAN       This frame is defined to capture
                              orientation of the reflected instrument
                              view direction due to the scan mirror
                              motion. This frame is defined as as
                              CK-based frame because this time variable
                              orientation is stored in a CK file.

      VEX_VIRTIS-M_VIS        These two frames are defined to capture
      VEX_VIRTIS-M_IR         misalignments for each of the two
                              instrument channels relative to the
                              reflected view view direction. These
                              frames are defined as fixed offset frames
                              relative to the VEX_VIRTIS-M_SCAN frame.
                              These two frames are the frames that
                              should be used to compute the instrument
                              pixel view directions when the CK files
                              for the scan mirror are available.

      VEX_VIRTIS-M_VIS_ZERO   These two frames are defined to capture
      VEX_VIRTIS-M_IR_ZERO    misalignments for each of the two
                              instrument channels relative to the
                              reflected view view direction with scan
                              mirror in zero position. The main purpose
                              of these frames is to capture all
                              available misalignment data while allowing
                              to compute reflected view direction
                              externally to SPICE and then combine it
                              with the misalignments. These frames should
                              be used when CK files for the scan mirror
                              are not available.

   Each of the VIRTIS-M frames listed above is defined in the same way
   as follows:

      -  +Z axis points along the boresight (for VEX_VIRTIS-M boresight
         is the nominal center pixel view direction for the scan mirror
         in "zero" position; for VEX_VIRTIS-M_SCAN boresight is the
         nominal center pixel view direction, "off-pointed" due to the
         scan mirror; for VEX_VIRTIS-M_VIS and VEX_VIRTIS-M_IR
         boresight is the particular detector center pixel view
         direction, "off-pointed" due to the scan mirror; for
         VEX_VIRTIS-M_VIS_ZERO and VEX_VIRTIS-M_IR_ZERO frames it is
         the center pixel view direction, adjusted for all known
         misalignments with the scan mirror in "zero" position)

      -  +Y axis is parallel to the apparent spatial resolution
         direction; it is nominally co-aligned with the S/C +Y axis;

      -  +X axis completes the right hand frame;

      -  the origin of the frame is located at the instrument focal
         point for VEX_VIRTIS-M_VIS, VEX_VIRTIS-M_IR,
         VEX_VIRTIS-M_VIS_ZERO and VEX_VIRTIS-M_IR_ZERO frames and at
         the intersection of the nominal center pixel view direction
         and the scan mirror axis for VEX_VIRTIS-M and
         VEX_VIRTIS-M_SCAN frames.


   Nominally, in ``zero'' scan mirror position all six frames are
   co-aligned with each other and the S/C frame.

   The VIRTIS-H frame, VEX_VIRTIS-H, is defined as follows:

      -  +Z axis points along the boresight;

      -  +Y axis is parallel to the apparent spatial resolution
         direction (i.e. along the slit); it is nominally co-aligned
         with the S/C +Y axis;

      -  +X axis completes the right hand frame; it is nominally
         co-aligned with the S/C +X axis;

      -  the origin of the frame is located at the instrument focal
         point.


   Nominally, VEX_VIRTIS-H frame is co-aligned with the S/C frame.

   This diagram illustrates the VIRTIS frames (with VIRTIS-M scan
   mirror in "zero" position):

   +Z S/C side (science deck side) view:
   -------------------------------------


                                          +Ymir
                             .____ +Yh __ +Ymvis
                      VIRTIS | o-o---->-> +Ymscan
                             | | |        +Ym
                             | | |         | +Ysc
   o==/ /==================o | | |  o------->o==================/ /==o
     -Y Solar Array            | |  |      |        +Y Solar Array
                           +Xh V v  |      |
                             ._+Xm _|______.
                             +Xmscan|   .'
                             +Xmvis-V +Xsc
                             +Xmir      `.
                              /___________\
                              HGA1                    +Zsc, +Zmvis, +Zmir,
                                                      +Zm, +Zmscan and +Zh
                                                       are out of the page.


   According to [16] alignment data indicate that VIRTIS-M rotation axis
   is tilted from S/C +Y toward S/C +X by 1.23 milliradians. This misalignment
   is incorporated as a single rotation by -1.23 milliradians about +Z axis
   into the definition of the VEX_VIRTIS-M frame.

   According to [17] alignment data for VIRTIS-M indicate that the instrument
   boresight (center pixel view direction) is tilted with respect to the
   spacecraft +Z axis by 0.270 milliradians toward +Y axis and 0.069
   milliradians toward -X. This misalignment is incorporated as a two
   rotations, first by -0.270 milliradians about +X axis and then by -0.069
   milliradians about +Y axis, into the definitions of the VEX_VIRTIS-M_VIS,
   VEX_VIRTIS-M_IR, VEX_VIRTIS-M_VIS_ZERO and VEX_VIRTIS-M_IR_ZERO frames.

   According to [17] alignment data for VIRTIS-H indicate that the instrument
   boresight (center pixel view direction) is tilted with respect to the
   spacecraft +Z axis by 0.993 milliradians towards +Y axis and 0.845
   milliradians towards -X. This misalignment is incorporated as a two
   rotations, first by -0.993 milliradians about +X axis and then by -0.845
   milliradians about +Y axis, into the definition of the VEX_VIRTIS-H frame.

   The data blocks below define VIRTIS frames.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_VEX_VIRTIS-M               =  -248510
      FRAME_-248510_NAME               = 'VEX_VIRTIS-M'
      FRAME_-248510_CLASS              =  4
      FRAME_-248510_CLASS_ID           =  -248510
      FRAME_-248510_CENTER             =  -248500
      TKFRAME_-248510_RELATIVE         = 'VEX_SPACECRAFT'
      TKFRAME_-248510_SPEC             = 'ANGLES'
      TKFRAME_-248510_UNITS            = 'RADIANS'
      TKFRAME_-248510_AXES             = (  1,   2,   3       )
      TKFRAME_-248510_ANGLES           = (  0.0, 0.0, 0.00123 )

      FRAME_VEX_VIRTIS-M_SCAN          = -248515
      FRAME_-248515_NAME               = 'VEX_VIRTIS-M_SCAN'
      FRAME_-248515_CLASS              =  3
      FRAME_-248515_CLASS_ID           = -248515
      FRAME_-248515_CENTER             = -248500
      CK_-248515_SCLK                  = -248
      CK_-248515_SPK                   = -248

      FRAME_VEX_VIRTIS-M_VIS           =  -248511
      FRAME_-248511_NAME               = 'VEX_VIRTIS-M_VIS'
      FRAME_-248511_CLASS              =  4
      FRAME_-248511_CLASS_ID           =  -248511
      FRAME_-248511_CENTER             =  -248500
      TKFRAME_-248511_RELATIVE         = 'VEX_VIRTIS-M_SCAN'
      TKFRAME_-248511_SPEC             = 'ANGLES'
      TKFRAME_-248511_UNITS            = 'RADIANS'
      TKFRAME_-248511_AXES             = ( 3,   1,        2        )
      TKFRAME_-248511_ANGLES           = ( 0.0, 0.000270, 0.000069 )

      FRAME_VEX_VIRTIS-M_IR            =  -248513
      FRAME_-248513_NAME               = 'VEX_VIRTIS-M_IR'
      FRAME_-248513_CLASS              =  4
      FRAME_-248513_CLASS_ID           =  -248513
      FRAME_-248513_CENTER             =  -248500
      TKFRAME_-248513_RELATIVE         = 'VEX_VIRTIS-M_SCAN'
      TKFRAME_-248513_SPEC             = 'ANGLES'
      TKFRAME_-248513_UNITS            = 'RADIANS'
      TKFRAME_-248513_AXES             = ( 3,   1,        2        )
      TKFRAME_-248513_ANGLES           = ( 0.0, 0.000270, 0.000069 )

      FRAME_VEX_VIRTIS-M_VIS_ZERO      =  -248512
      FRAME_-248512_NAME               = 'VEX_VIRTIS-M_VIS_ZERO'
      FRAME_-248512_CLASS              =  4
      FRAME_-248512_CLASS_ID           =  -248512
      FRAME_-248512_CENTER             =  -248500
      TKFRAME_-248512_RELATIVE         = 'VEX_VIRTIS-M'
      TKFRAME_-248512_SPEC             = 'ANGLES'
      TKFRAME_-248512_UNITS            = 'RADIANS'
      TKFRAME_-248512_AXES             = ( 3,   1,        2        )
      TKFRAME_-248512_ANGLES           = ( 0.0, 0.000270, 0.000069 )

      FRAME_VEX_VIRTIS-M_IR_ZERO       =  -248514
      FRAME_-248514_NAME               = 'VEX_VIRTIS-M_IR_ZERO'
      FRAME_-248514_CLASS              =  4
      FRAME_-248514_CLASS_ID           =  -248514
      FRAME_-248514_CENTER             =  -248500
      TKFRAME_-248514_RELATIVE         = 'VEX_VIRTIS-M'
      TKFRAME_-248514_SPEC             = 'ANGLES'
      TKFRAME_-248514_UNITS            = 'RADIANS'
      TKFRAME_-248514_AXES             = ( 3,   1,        2        )
      TKFRAME_-248514_ANGLES           = ( 0.0, 0.000270, 0.000069 )

      FRAME_VEX_VIRTIS-H               =  -248520
      FRAME_-248520_NAME               = 'VEX_VIRTIS-H'
      FRAME_-248520_CLASS              =  4
      FRAME_-248520_CLASS_ID           =  -248520
      FRAME_-248520_CENTER             =  -248500
      TKFRAME_-248520_RELATIVE         = 'VEX_SPACECRAFT'
      TKFRAME_-248520_SPEC             = 'ANGLES'
      TKFRAME_-248520_UNITS            = 'RADIANS'
      TKFRAME_-248520_AXES             = ( 3,   1,        2        )
      TKFRAME_-248520_ANGLES           = ( 0.0, 0.000993, 0.000845 )

   \begintext


VMC Frames
========================================================================

   This section of the file contains the definitions of the VMC camera
   frames.


VMC Frame Tree
--------------------------------------

   The diagram below shows the VMC frame hierarchy.


                               "J2000" INERTIAL
           +-----------------------------------------------------+
           |                          |                          |
           |<-pck                     |                          |<-pck
           |                          |                          |
           V                          |                          V
      "IAU_VENUS"                     |                     "IAU_EARTH"
    VENUS BODY-FIXED                  |                   EARTH BODY-FIXED
    ----------------                  |                   ----------------
                                      |
                                      |<-ck
                                      |
                                      V
                               "VEX_SPACECRAFT"
                               ----------------
                                      |
                                      |<-fixed
                                      |
                                      V
                                "VEX_VMC_BASE"
           +-----------------------------------------------------+
           |                 |                 |                 |
           |                 |                 |                 |
           |                 |                 |                 |
           V                 V                 V                 V
    "VEX_VMC_NIR-1"   "VEX_VMC_NIR-2"     "VEX_VMC_UV"     "VEX_VMC_VIS"
    ---------------   ---------------     ------------     -------------


VMC Base Frame
--------------------------------------

   The VMC camera base frame -- VEX_VMC_BASE -- is defined by the camera
   design and its mounting on the S/C as follows:

      -  +Z axis is in the nominal direction of the VMC camera boresight;
         it nominally points in the direction of the S/C +Z axis;

      -  +Y axis is perpendicular to the nominal opposite direction of VMC
         camera CCD lines and nominally points along the S/C +Y axis;

      -  +X completes the right hand frame and is parallel to the nominal
         CCD detector lines; it nominally points in the direction of the
         S/C +X axis;

      -  the origin of the frame is located at the VMC camera focal
         point.


   Because the VMC camera is rigidly mounted on the S/C, the VMC base
   frame is defined as a fixed-offset frame with its orientation given
   relative to the VEX_SPACECRAFT frame.

   This diagram illustrates nominal VEX_VMC_BASE frame with respect to the
   spacecraft frame.


   +Z S/C side view:
   -----------------

      .________________.     ._______VMC___.    +Yvmcb____________.
      |                 \    |         | o------>                 |
      |                  \   |         |_|+Zvmcb                  |
      |                   |. |   +Zsc    | |  |        +Ysc       |
      |                   | o|      o--- | | o|    ------->       |
      |                   |' |      |    V |  |                   |
      |                  /   |      |     +Xvmcb                  |
      ._________________/    .______|______.    \_________________.
       -Y Solar Array             . | .             +Y Solar Array
                          HGA1  .'  V +Xsc
                               /_________\



                                             +Zsc and +Zvmcb are
                                                 out of the page


   Nominally, the VMC base frame is co-aligned with the S/C frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_VEX_VMC_BASE              =  -248600
      FRAME_-248600_NAME              = 'VEX_VMC_BASE'
      FRAME_-248600_CLASS             =  4
      FRAME_-248600_CLASS_ID          =  -248600
      FRAME_-248600_CENTER            =  -248600
      TKFRAME_-248600_RELATIVE        = 'VEX_SPACECRAFT'
      TKFRAME_-248600_SPEC            = 'ANGLES'
      TKFRAME_-248600_UNITS           = 'DEGREES'
      TKFRAME_-248600_AXES            = (   1,       2,       3     )
      TKFRAME_-248600_ANGLES          = ( 000.000, 000.000, 000.000 )

   \begintext


VMC Optical Channels Frames
--------------------------------------

    The VMC Camera Optical Channels, NIR-1, NIR-2, UV and VIS --
    VEX_VMC_NIR-1, VEX_VMC_NIR-2, VEX_VMC_UV and VEX_VMC_VIS -- are nominally
    co-aligned with the VMC base frame -- VEX_VMC_BASE (from [5]):

      -  +Z axis is in the nominal direction of the VMC camera boresight;
         it nominally points in the direction of the S/C +Z axis;

      -  +Y axis is perpendicular to the nominal opposite direction of VMC
         camera CCD lines and nominally points along the S/C +Y axis;

      -  +X completes the right hand frame and is parallel to the nominal
         CCD detector lines; it nominally points in the direction of the
         S/C +X axis;

      -  the origin of the frame is located at the optical channel focal
         point.


   This diagram illustrates nominal VMC optical channel frames with respect
   to the VEX_VMC_BASE


   +Z S/C side view:
   -----------------

      .________________.     ._______VMC___.  +Ynir2  ______+Yvmcb.
      |                 \    |         |ooo-----> +Ynir1 --->     |
      |                  \   |         |o|o----->+Yuv             |
      |                   |. |   +Zsc   |||| .| +Yvis  +Ysc       |
      |                   |==|      o---||||==|    ------->       |
      |                   |' |      |   ||V+Xnir2                 |
      |                  /   |      |   V  +Xuv                   |
      ._________________/    .______|___+Xnir1  \_________________.
       -Y Solar Array             . | . +Xvis       +Y Solar Array
                          HGA1  .'  V    |
                               /__+Xsc___|
                                         |
                                         V +Xvmcb

                                             +Zsc, +Zvmcb, +Zuv, +Zvis,
                                             +Znir1 and +Znir2 are
                                             out of the page


   The focal point of each of the optical channels of the VMC camera is
   on the same plane, and therefore, every single frame is, nominally
   co-aligned with the VMC base frame.

   The actual boresight direction is offset from its nominal direction. The
   offsets for the VMC filters have been specified by T. Roatsch [19].

   The VMC frames definitions below incorporate these offsets.

   \begindata

      FRAME_VEX_VMC_NIR-1             =  -248610
      FRAME_-248610_NAME              = 'VEX_VMC_NIR-1'
      FRAME_-248610_CLASS             =  4
      FRAME_-248610_CLASS_ID          =  -248610
      FRAME_-248610_CENTER            =  -248600
      TKFRAME_-248610_RELATIVE        = 'VEX_VMC_BASE'
      TKFRAME_-248610_SPEC            = 'ANGLES'
      TKFRAME_-248610_UNITS           = 'DEGREES'
      TKFRAME_-248610_AXES            = (   1,       2,       3     )
      TKFRAME_-248610_ANGLES          = (  -0.81,    1.02,    0.0   )

      FRAME_VEX_VMC_NIR-2             =  -248620
      FRAME_-248620_NAME              = 'VEX_VMC_NIR-2'
      FRAME_-248620_CLASS             =  4
      FRAME_-248620_CLASS_ID          =  -248620
      FRAME_-248620_CENTER            =  -248600
      TKFRAME_-248620_RELATIVE        = 'VEX_VMC_BASE'
      TKFRAME_-248620_SPEC            = 'ANGLES'
      TKFRAME_-248620_UNITS           = 'DEGREES'
      TKFRAME_-248620_AXES            = (   1,       2,       3     )
      TKFRAME_-248620_ANGLES          = (   0.85,    0.8,    0.0    )

      FRAME_VEX_VMC_UV                =  -248630
      FRAME_-248630_NAME              = 'VEX_VMC_UV'
      FRAME_-248630_CLASS             =  4
      FRAME_-248630_CLASS_ID          =  -248630
      FRAME_-248630_CENTER            =  -248600
      TKFRAME_-248630_RELATIVE        = 'VEX_VMC_BASE'
      TKFRAME_-248630_SPEC            = 'ANGLES'
      TKFRAME_-248630_UNITS           = 'DEGREES'
      TKFRAME_-248630_AXES            = (   1,       2,       3      )
      TKFRAME_-248630_ANGLES          = (   0.62,   -1.08,    0.60   )

      FRAME_VEX_VMC_VIS               =  -248640
      FRAME_-248640_NAME              = 'VEX_VMC_VIS'
      FRAME_-248640_CLASS             =  4
      FRAME_-248640_CLASS_ID          =  -248640
      FRAME_-248640_CENTER            =  -248600
      TKFRAME_-248640_RELATIVE        = 'VEX_VMC_BASE'
      TKFRAME_-248640_SPEC            = 'ANGLES'
      TKFRAME_-248640_UNITS           = 'DEGREES'
      TKFRAME_-248640_AXES            = (   1,       2,       3     )
      TKFRAME_-248640_ANGLES          = (  -1.07,   -0.92,    0.0   )

   \begintext


Venus Express Mission NAIF ID Codes -- Definition Section
========================================================================

   This section contains name to NAIF ID mappings for the VEX mission.


Venus Express Spacecraft (VEX) spacecraft and instruments IDs:
-------------------------------------------------------------

   This table summarizes VEX Spacecraft IDs:

            Name                   ID       Synonyms
            ---------------------  -------  ----------------------------
            VEX                    -248     VENUS EXPRESS, VENUS-EXPRESS,
                                            VENUS_EXPRESS
   Notes:

      -- 'VEX', 'VENUS EXPRESS', 'VENUS-EXPRESS', and 'VENUS_EXPRESS' are
         synonyms and all map to the official VEX S/C ID (-248);

   Name-ID Mapping keywords:

         \begindata

            NAIF_BODY_NAME += ( 'VENUS EXPRESS'          )
            NAIF_BODY_CODE += ( -248                     )

            NAIF_BODY_NAME += ( 'VENUS-EXPRESS'          )
            NAIF_BODY_CODE += ( -248                     )

            NAIF_BODY_NAME += ( 'VENUS_EXPRESS'          )
            NAIF_BODY_CODE += ( -248                     )

            NAIF_BODY_NAME += ( 'VEX'                    )
            NAIF_BODY_CODE += ( -248                     )

         \begintext


VEX Spacecraft Structures IDs
--------------------------------------

   This table summarizes VEX Spacecraft Structure IDs:

            Name                   ID       Synonyms
            ---------------------  -------  -------------------------
            VEX_SPACECRAFT         -248000  VEX_SC

            VEX_SPACECRAFT_C1      -248001
            VEX_SPACECRAFT_C2      -248002
            VEX_SPACECRAFT_C3      -248003
            VEX_SPACECRAFT_C4      -248004
            VEX_SPACECRAFT_C5      -248005
            VEX_SPACECRAFT_C6      -248006
            VEX_SPACECRAFT_C7      -248007
            VEX_SPACECRAFT_C8      -248008

            VEX_SA+Y_GIMBAL        -248010
            VEX_SA+Y               -248011
            VEX_SA+Y_C1            -248014
            VEX_SA+Y_C2            -248015
            VEX_SA+Y_C3            -248016
            VEX_SA+Y_C4            -248017
            VEX_SA-Y_GIMBAL        -248020
            VEX_SA-Y               -248013
            VEX_SA-Y_C1            -248024
            VEX_SA-Y_C2            -248025
            VEX_SA-Y_C3            -248026
            VEX_SA-Y_C4            -248027

            VEX_HGA1               -248021
            VEX_HGA2               -248022

            VEX_LGA-1              -248031
            VEX_LGA-2              -248032

            VEX_ST1                -248033
            VEX_ST2                -248034

   Notes:

      -- 'VEX_SC' and 'VEX_SPACECRAFT' are synonyms and all map to the VEX
         S/C bus structure ID (-248000);

   Name-ID Mapping keywords:

         \begindata

            NAIF_BODY_NAME += ( 'VEX_SPACECRAFT'         )
            NAIF_BODY_CODE += ( -248000                  )

            NAIF_BODY_NAME += ( 'VEX_SC'                 )
            NAIF_BODY_CODE += ( -248000                  )

            NAIF_BODY_NAME += ( 'VEX_SPACECRAFT_C1'      )
            NAIF_BODY_CODE += ( -248001                  )

            NAIF_BODY_NAME += ( 'VEX_SPACECRAFT_C2'      )
            NAIF_BODY_CODE += ( -248002                  )

            NAIF_BODY_NAME += ( 'VEX_SPACECRAFT_C3'      )
            NAIF_BODY_CODE += ( -248003                  )

            NAIF_BODY_NAME += ( 'VEX_SPACECRAFT_C4'      )
            NAIF_BODY_CODE += ( -248004                  )

            NAIF_BODY_NAME += ( 'VEX_SPACECRAFT_C5'      )
            NAIF_BODY_CODE += ( -248005                  )

            NAIF_BODY_NAME += ( 'VEX_SPACECRAFT_C6'      )
            NAIF_BODY_CODE += ( -248006                  )

            NAIF_BODY_NAME += ( 'VEX_SPACECRAFT_C7'      )
            NAIF_BODY_CODE += ( -248007                  )

            NAIF_BODY_NAME += ( 'VEX_SPACECRAFT_C8'      )
            NAIF_BODY_CODE += ( -248008                  )

            NAIF_BODY_NAME += ( 'VEX_SA+Y'               )
            NAIF_BODY_CODE += ( -248011                  )

            NAIF_BODY_NAME += ( 'VEX_SA-Y'               )
            NAIF_BODY_CODE += ( -248013                  )

            NAIF_BODY_NAME += ( 'VEX_SA+Y_GIMBAL'        )
            NAIF_BODY_CODE += ( -248010                  )

            NAIF_BODY_NAME += ( 'VEX_SA+Y_C1'            )
            NAIF_BODY_CODE += ( -248014                  )

            NAIF_BODY_NAME += ( 'VEX_SA+Y_C2'            )
            NAIF_BODY_CODE += ( -248015                  )

            NAIF_BODY_NAME += ( 'VEX_SA+Y_C3'            )
            NAIF_BODY_CODE += ( -248016                  )

            NAIF_BODY_NAME += ( 'VEX_SA+Y_C4'            )
            NAIF_BODY_CODE += ( -248017                  )

            NAIF_BODY_NAME += ( 'VEX_SA-Y_GIMBAL'        )
            NAIF_BODY_CODE += ( -248020                  )

            NAIF_BODY_NAME += ( 'VEX_SA-Y_C1 '           )
            NAIF_BODY_CODE += ( -248024                  )

            NAIF_BODY_NAME += ( 'VEX_SA-Y_C2 '           )
            NAIF_BODY_CODE += ( -248025                  )

            NAIF_BODY_NAME += ( 'VEX_SA-Y_C3 '           )
            NAIF_BODY_CODE += ( -248026                  )

            NAIF_BODY_NAME += ( 'VEX_SA-Y_C4 '           )
            NAIF_BODY_CODE += ( -248027                  )

            NAIF_BODY_NAME += ( 'VEX_HGA1'               )
            NAIF_BODY_CODE += ( -248021                  )

            NAIF_BODY_NAME += ( 'VEX_HGA2'               )
            NAIF_BODY_CODE += ( -248022                  )

            NAIF_BODY_NAME += ( 'VEX_LGA-1'              )
            NAIF_BODY_CODE += ( -248031                  )

            NAIF_BODY_NAME += ( 'VEX_LGA-2'              )
            NAIF_BODY_CODE += ( -248032                  )

            NAIF_BODY_NAME += ( 'VEX_ST1'                )
            NAIF_BODY_CODE += ( -248033                  )

            NAIF_BODY_NAME += ( 'VEX_ST2'                )
            NAIF_BODY_CODE += ( -248034                  )

         \begintext


ASPERA-4 IDs
--------------------------------------

   This table summarizes ASPERA-4 IDs:

            Name                   ID
            ---------------------  -------
            VEX_ASPERA4            -248100
            VEX_ASPERA4_URF        -248110
            VEX_ASPERA4_SAF        -248111
            VEX_ASPERA4_ELS        -248120
            VEX_ASPERA4_NPI        -248130
            VEX_ASPERA4_NPD1       -248141
            VEX_ASPERA4_NPD2       -248142
            VEX_ASPERA4_IMA_URF    -248150
            VEX_ASPERA4_IMA        -248151
            VEX_ASPERA4_IMAS       -248152
            VEX_ASPERA4_SS1        -248161
            VEX_ASPERA4_SS2        -248162

   Name-ID Mapping keywords:

         \begindata

            NAIF_BODY_NAME += ( 'VEX_ASPERA4'             )
            NAIF_BODY_CODE += ( -248100                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_URF'         )
            NAIF_BODY_CODE += ( -248110                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_SAF'         )
            NAIF_BODY_CODE += ( -248111                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_ELS'         )
            NAIF_BODY_CODE += ( -248120                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_NPI'         )
            NAIF_BODY_CODE += ( -248130                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_NPD1'        )
            NAIF_BODY_CODE += ( -248141                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_NPD2'        )
            NAIF_BODY_CODE += ( -248142                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_IMA_URF'     )
            NAIF_BODY_CODE += ( -248150                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_IMA'         )
            NAIF_BODY_CODE += ( -248151                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_IMAS'        )
            NAIF_BODY_CODE += ( -248152                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_SS1'         )
            NAIF_BODY_CODE += ( -248161                   )

            NAIF_BODY_NAME += ( 'VEX_ASPERA4_SS2'         )
            NAIF_BODY_CODE += ( -248162                   )

         \begintext


MAG IDs
--------------------------------------

   This table summarizes MAG IDs:

            Name                   ID
            ---------------------  -------
            VEX_MAG_MAGB-H         -248200
            VEX_MAG_MAGB           -248201
            VEX_MAG_MAGIS          -248210
            VEX_MAG_MAGOS          -248220

   Name-ID Mapping keywords:

         \begindata

            NAIF_BODY_NAME += ( 'VEX_MAG_MAGB-H' )
            NAIF_BODY_CODE += ( -248200          )

            NAIF_BODY_NAME += ( 'VEX_MAG_MAGB'   )
            NAIF_BODY_CODE += ( -248201          )

            NAIF_BODY_NAME += ( 'VEX_MAG_MAGIS'  )
            NAIF_BODY_CODE += ( -248210          )

            NAIF_BODY_NAME += ( 'VEX_MAG_MAGOS'  )
            NAIF_BODY_CODE += ( -248220          )

         \begintext


PFS IDs
--------------------------------------

   This table summarizes PFS IDs:

            Name                   ID
            ---------------------  -------
            VEX_PFS_BASE           -248300
            VEX_PFS_SCANNER        -248310
            VEX_PFS_LWC            -248320
            VEX_PFS_SWC            -248330

   Name-ID Mapping keywords:

         \begindata

            NAIF_BODY_NAME += ( 'VEX_PFS_BASE'     )
            NAIF_BODY_CODE += ( -248300            )

            NAIF_BODY_NAME += ( 'VEX_PFS_SCANNER'  )
            NAIF_BODY_CODE += ( -248310            )

            NAIF_BODY_NAME += ( 'VEX_PFS_LWC'      )
            NAIF_BODY_CODE += ( -248320            )

            NAIF_BODY_NAME += ( 'VEX_PFS_SWC'      )
            NAIF_BODY_CODE += ( -248330            )

         \begintext


SPICAV IDs
--------------------------------------

   This table summarizes SPICAV IDs:

            Name                   ID
            ---------------------  -------
            VEX_SPICAV_BASE        -248400
            VEX_SPICAV_SIR         -248410
            VEX_SPICAV_SIR_SOLAR   -248411
            VEX_SPICAV_SUV         -248420
            VEX_SPICAV_SUV_SOLAR   -248421
            VEX_SPICAV_SOIR        -248430


   Name-ID Mapping keywords:

         \begindata

            NAIF_BODY_NAME += ( 'VEX_SPICAV_BASE'        )
            NAIF_BODY_CODE += ( -248400                  )

            NAIF_BODY_NAME += ( 'VEX_SPICAV_SIR'         )
            NAIF_BODY_CODE += ( -248410                  )

            NAIF_BODY_NAME += ( 'VEX_SPICAV_SIR_SOLAR'   )
            NAIF_BODY_CODE += ( -248411                  )

            NAIF_BODY_NAME += ( 'VEX_SPICAV_SUV'         )
            NAIF_BODY_CODE += ( -248420                  )

            NAIF_BODY_NAME += ( 'VEX_SPICAV_SUV_SOLAR'   )
            NAIF_BODY_CODE += ( -248421                  )

            NAIF_BODY_NAME += ( 'VEX_SPICAV_SOIR'        )
            NAIF_BODY_CODE += ( -248430                  )

         \begintext


VIRTIS IDs
--------------------------------------

   This table summarizes VIRTIS IDs:

            Name                   ID
            ---------------------  -------
            VEX_VIRTIS             -248500
            VEX_VIRTIS-M           -248510
            VEX_VIRTIS-M_VIS       -248511
            VEX_VIRTIS-M_IR        -248513
            VEX_VIRTIS-H           -248520

   Name-ID Mapping keywords:

         \begindata

            NAIF_BODY_NAME += ( 'VEX_VIRTIS'       )
            NAIF_BODY_CODE += ( -248500            )

            NAIF_BODY_NAME += ( 'VEX_VIRTIS-M'     )
            NAIF_BODY_CODE += ( -248510            )

            NAIF_BODY_NAME += ( 'VEX_VIRTIS-M_VIS' )
            NAIF_BODY_CODE += ( -248511            )

            NAIF_BODY_NAME += ( 'VEX_VIRTIS-M_IR'  )
            NAIF_BODY_CODE += ( -248513            )

            NAIF_BODY_NAME += ( 'VEX_VIRTIS-H'     )
            NAIF_BODY_CODE += ( -248520            )

         \begintext


VMC IDs
--------------------------------------

   This table summarizes VMC IDs:

            Name                   ID
            ---------------------  -------
            VEX_VMC_BASE           -248600
            VEX_VMC_NIR-1          -248610
            VEX_VMC_NIR-2          -248620
            VEX_VMC_UV             -248630
            VEX_VMC_VIS            -248640

   Name-ID Mapping keywords:

         \begindata

            NAIF_BODY_NAME += ( 'VEX_VMC_BASE'  )
            NAIF_BODY_CODE += ( -248600         )

            NAIF_BODY_NAME += ( 'VEX_VMC_NIR-1' )
            NAIF_BODY_CODE += ( -248610         )

            NAIF_BODY_NAME += ( 'VEX_VMC_NIR-2' )
            NAIF_BODY_CODE += ( -248620         )

            NAIF_BODY_NAME += ( 'VEX_VMC_UV'    )
            NAIF_BODY_CODE += ( -248630         )

            NAIF_BODY_NAME += ( 'VEX_VMC_VIS'   )
            NAIF_BODY_CODE += ( -248640         )

         \begintext


End of FK file.