KPL/MK

Meta-kernel for Mars Express Dataset v100 -- Operational 20200623_001
==========================================================================

   This meta-kernel lists the Mars_Express Operational SPICE kernels
   that provide information for the Operational scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the Mars_Express Operational scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v1.4.1.


Usage of the Meta-kernel
-------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/MARS-EXPRESS/kernels/


Implementation Notes
-------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the Mars_Express SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on June 23, 2020 by Marc Costa Sitja ESA/ESAC.
   The original name of this file was MEX_OPS_V100_20200623_001.TM.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/ck/ATNM_PTR01298_200321_001.BC'
                           '$KERNELS/ck/ATNM_PTR01300_200418_002.BC'
                           '$KERNELS/ck/ATNM_PTR01302_200516_001.BC'
                           '$KERNELS/ck/ATNM_SGS_P170331235152_01588.BC'
                           '$KERNELS/ck/MEX_SA_180414_180414_S200604_V0002.BC'
                           '$KERNELS/ck/MEX_SA_210129_210131_S200604_V0001.BC'
                           '$KERNELS/ck/MEX_SA_210201_210202_S200604_V0001.BC'

                           '$KERNELS/fk/MEX_V14.TF'

                           '$KERNELS/lsk/NAIF0012.TLS'

                           '$KERNELS/pck/DE403-MASSES.TPC'
                           '$KERNELS/pck/PCK00010.TPC'

                           '$KERNELS/sclk/MEX_200604_STEP.TSC'

                           '$KERNELS/spk/MAR097_030101_300101_V0001.BSP'
                           '$KERNELS/spk/ORMM_T19_191201000000_01566.BSP'
                           '$KERNELS/spk/ORMM_T19_200101000000_01566.BSP'

                         )

   \begintext


SPICE Kernel Dataset Version
------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v100_20200623_001'

   \begintext


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           esa_spice@sciops.esa.int, marc.costa@esa.int,


End of MK file.