C$ Procedure     TCPPRN -- Output TCP Data Table

      SUBROUTINE TCPPRN ( MSG, ON, NREC, DDHTIM, DDHS, DDHMS, 
     .                    TCPG, TCPO, TCPTS, UTC, ET, OBTSTR ) 

C$ Abstract
C
C     This routine outputs all TCP data to STDOUT as a nice formatted
C     table.
C
C     This routine calls SPEAK routine to do output. If SPEAK[er] is 
C     OFF, it will print nothing.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     None.
C
C$ Declarations
 
      IMPLICIT  NONE

      INCLUDE               'tcp2scet.inc'

      CHARACTER*(*)         MSG
      LOGICAL               ON
      INTEGER               NREC
      DOUBLE PRECISION      DDHTIM ( * )
      INTEGER               DDHS   ( * )
      INTEGER               DDHMS  ( * )
      DOUBLE PRECISION      TCPO   ( * )
      DOUBLE PRECISION      TCPG   ( * )
      INTEGER               TCPTS  ( * )
      CHARACTER*(*)         UTC    ( * )
      DOUBLE PRECISION      ET     ( * )
      CHARACTER*(*)         OBTSTR ( * )
      
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     MSG        I   Message to be printed before table
C     ON         I   Flag indicating to output or not (.TRUE. to print)
C     NREC       I   Number of TCP records in the input buffers
C     DDHTIM     I   DDH time, as DP seconds
C     DDHS       I   DDH time, integer seconds 
C     DDHMS      I   DDH time, fractional seconds
C     TCPO       I   TCP offset
C     TCPG       I   TCP gradient
C     TCPTS      I   TCP generation time
C     UTC        I   UTC corresponding to DDH time
C     ET         I   ET corresponding to DDH time
C     OBTSTR     I   Reference SCLK
C
C$ Detailed_Input
C
C     N/A.
C
C$ Detailed_Output
C
C     N/A
C
C$ Parameters
C
C     See 'tcp2scet.inc'.
C
C$ Exceptions
C
C     Error free.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     N/A.
C
C$ Examples
C
C     N/A.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     B.V. Semenov     (JPL)
C
C$ Version
C
C-    TCP2SCET Version 1.0.0, 17-SEP-2003 (BVS)
C
C-&

C
C     Locals.
C
      INTEGER               RECIDX
      CHARACTER*(WRDSIZ)    HWORD
      CHARACTER*(LINSIZ)    LINE
      DOUBLE PRECISION      HDP

C
C     SPICELIB functions
C
      INTEGER               RTRIM


C
C     Should we do it?
C
      IF ( .NOT. ON ) THEN
         RETURN
      END IF

C
C     Print table header.
C
      CALL SPEAK( ' ' )
      CALL SPEAK( MSG )
      CALL SPEAK( ' ' )
      CALL SPEAK( 'DDH sec    mksec  gradient       ' //
     .             'offset         gen OBT  ' //
     .             'DDH UTC               DDH ET         Ref OBT' )
      CALL SPEAK( '---------- ------ -------------- ' //
     .             '-------------- -------- ' //
     .             '--------------------- -------------- ' //
     .             '--------------' )

C
C     Print TCP data.
C
      DO RECIDX = 1, NREC

         HDP = DDHS(RECIDX)
         CALL DPFMT( HDP, 'xxxxxxxxxxxx', HWORD )
         LINE = HWORD

         HDP = DDHMS(RECIDX)
         CALL DPFMT( HDP, 'xxxxxxx', HWORD )
         LINE = LINE(:RTRIM(LINE)) // HWORD

         CALL DPFMT( TCPG(RECIDX),   'xx.xxxxxxxxxxxx', HWORD )
         LINE = LINE(:RTRIM(LINE)) // HWORD

         CALL DPFMT( TCPO(RECIDX),   'xxxxxxxxxxx.xxx',   HWORD )
         LINE = LINE(:RTRIM(LINE)) // HWORD

         HDP = TCPTS(RECIDX) 
         CALL DPFMT( HDP, 'xxxxxxxxx',   HWORD )
         LINE = LINE(:RTRIM(LINE)) // HWORD

         LINE = LINE(:RTRIM(LINE)) // ' ' // 
     .          UTC(RECIDX)(:RTRIM(UTC(RECIDX)))

         CALL DPFMT( ET(RECIDX),  'xxxxxxxxxxx.xxx',      HWORD )
         LINE = LINE(:RTRIM(LINE)) // HWORD

         LINE = LINE(:RTRIM(LINE)) // ' ' // 
     .          OBTSTR(RECIDX)(:RTRIM(OBTSTR(RECIDX)))

         CALL SPEAK( LINE )

      END DO
      CALL SPEAK( ' ' )

      RETURN
      END

