C$Procedure      SHOSYN ( Show the direction syntax )
 
      SUBROUTINE SHOSYN
 
C$ Abstract
C
C     Send the syntax of supported direction specifications to
C     standard output.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     Utility
C
C$ Declarations
 
      IMPLICIT NONE
 
 
C$ Brief_I/O
C
C
C     None.
C
C$ Detailed_Input
C
C     None.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     Send the syntax of supported direction specification to
C     standard output.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 08-AUG-2000 (WLT)
C
C
C-&
 
 
      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )
 
      INTEGER               TXTSIZ
      PARAMETER           ( TXTSIZ = 120 )
 
      CHARACTER*(LNSIZE)    TEXT ( TXTSIZ )
 
      INTEGER               I
 
      TEXT(  1 ) = ' '
      TEXT(  2 ) = 'The following methods may be used to spec'
     .//           'ify a direction:'
      TEXT(  3 ) = ' '
      TEXT(  4 ) = 'Position and Velocity determined Directio'
     .//           'ns:'
      TEXT(  5 ) = '-----------------------------------------'
     .//           '---'
      TEXT(  6 ) = ' '
      TEXT(  7 ) = '      POSITION OF   @body[target]'
      TEXT(  8 ) = '               FROM @body[observer]'
      TEXT(  9 ) = '               CORRECTION [NONE|LT|LT+S]'
      TEXT( 10 ) = ' '
      TEXT( 11 ) = '      VELOCITY OF   @body[target]'
      TEXT( 12 ) = '               FROM @body'
      TEXT( 13 ) = '               CORRECTION [NONE|LT|LT+S]'
      TEXT( 14 ) = ' '
      TEXT( 15 ) = '      ORBIT NORMAL OF   @body[target]'
      TEXT( 16 ) = '                   FROM @body[observer]'
      TEXT( 17 ) = '                   CORRECTION [NONE|LT|LT'
     .//           '+S]'
      TEXT( 18 ) = ' '
      TEXT( 19 ) = ' '
      TEXT( 20 ) = 'Frame Fixed Directions:'
      TEXT( 21 ) = '-----------------------------------------'
     .//           '---'
      TEXT( 22 ) = ' '
      TEXT( 23 ) = '      FIXED @name[frame] XYZ @number[x] @'
     .//           'number[y] @number[z]'
      TEXT( 24 ) = ' '
      TEXT( 25 ) = '      FIXED @name[frame] RA  @numbe'
     .//           'r [@unit]  DEC @number [@unit]'
      TEXT( 26 ) = ' '
      TEXT( 27 ) = '   where @name is the name of some frame.'
      TEXT( 28 ) = ' '
      TEXT( 29 ) = ' '
      TEXT( 30 ) = ' '
      TEXT( 31 ) = 'Sub-observer direction:'
      TEXT( 32 ) = '-----------------------------------------'
     .//           '---'
      TEXT( 33 ) = ' '
      TEXT( 34 ) = '      SUBOBSERVER ON   @body[target]'
      TEXT( 35 ) = '                  FROM @body[observer]'
      TEXT( 36 ) = '                  CORRECTION [NONE|LT|LT+'
     .//           'S]'
      TEXT( 37 ) = ' '
      TEXT( 38 ) = ' '
      TEXT( 39 ) = 'Surface Normals:'
      TEXT( 40 ) = '-----------------------------------------'
     .//           '---'
      TEXT( 41 ) = ' '
      TEXT( 42 ) = ' '
      TEXT( 43 ) = ' '
      TEXT( 44 ) = '      NORMAL  TO @body AT (2:2){  LATITUD'
     .//           'E  @number [@unit]'
      TEXT( 45 ) = '                               |  @option'
      TEXT( 46 ) = '                               |  LONGITU'
     .//           'DE @number [@unit]'
      TEXT( 47 ) = '                               |  CARTOGR'
     .//           'APHIC LONGITUDE @number [@unit]'
      TEXT( 48 ) = '                               }'
      TEXT( 49 ) = ' '
      TEXT( 50 ) = '      NORMAL TO @body AT (3:3){ X @number'
      TEXT( 51 ) = '                              | Y @number'
      TEXT( 52 ) = '                              | Z @number'
      TEXT( 53 ) = '                              }'
      TEXT( 54 ) = ' '
      TEXT( 55 ) = ' '
      TEXT( 56 ) = 'Coordinate Directions:'
      TEXT( 57 ) = '-----------------------------------------'
     .//           '---'
      TEXT( 58 ) = ' '
      TEXT( 59 ) = '      INCREASING (1:1){ LATITUDE'
      TEXT( 60 ) = '                      | LONGTIDUTE'
      TEXT( 61 ) = '                      | CARTOGRAPHIC LONG'
     .//           'ITUDE'
      TEXT( 62 ) = '                      }'
      TEXT( 63 ) = '              AT (2:2){ LATITUDE  @number'
     .//           ' [@unit]'
      TEXT( 64 ) = '                      | @option'
      TEXT( 65 ) = '                      | LONGITUDE @number'
     .//           ' [@unit]'
      TEXT( 66 ) = '                      | CARTOGRAPHIC LONG'
     .//           'ITUDE @number [@unit]'
      TEXT( 67 ) = '                      }'
      TEXT( 68 ) = '              ON @body'
      TEXT( 69 ) = ' '
      TEXT( 70 ) = '      DECREASING (1:1){ LATITUDE'
      TEXT( 71 ) = '                      | LONGTIDUTE'
      TEXT( 72 ) = '                      | CARTOGRAPHIC LONG'
     .//           'ITUDE'
      TEXT( 73 ) = '                      }'
      TEXT( 74 ) = '              AT (2:2){ LATITUDE  @number'
     .//           ' [@unit]'
      TEXT( 75 ) = '                      | @option'
      TEXT( 76 ) = '                      | LONGITUDE @number'
     .//           ' [@unit]'
      TEXT( 77 ) = '                      | CARTOGRAPHIC LONG'
     .//           'ITUDE @number [@unit]'
      TEXT( 78 ) = '                      }'
      TEXT( 79 ) = '              ON @body'
      TEXT( 80 ) = ' '
      TEXT( 81 ) = ' '
      TEXT( 82 ) = '      INCREASING (1:1){ LATITUDE'
      TEXT( 83 ) = '                      | LONGTIDUTE'
      TEXT( 84 ) = '                      | CARTOGRAPHIC LONG'
     .//           'ITUDE'
      TEXT( 85 ) = '                      }'
      TEXT( 86 ) = '              AT (3:3){ X @number'
      TEXT( 87 ) = '                      | Y @number'
      TEXT( 88 ) = '                      | Z @number'
      TEXT( 89 ) = '                      }'
      TEXT( 90 ) = '              ON @body'
      TEXT( 91 ) = ' '
      TEXT( 92 ) = '      DECREASING (1:1){ LATITUDE'
      TEXT( 93 ) = '                      | LONGTIDUTE'
      TEXT( 94 ) = '                      | CARTOGRAPHIC LONG'
     .//           'ITUDE'
      TEXT( 95 ) = '                      }'
      TEXT( 96 ) = '              AT (3:3){ X @number'
      TEXT( 97 ) = '                      | Y @number'
      TEXT( 98 ) = '                      | Z @number'
      TEXT( 99 ) = '                      }'
      TEXT( 100 ) = '              ON @body'
      TEXT( 101 ) = ' '
      TEXT( 102 ) = ' '
      TEXT( 103 ) = ' '
      TEXT( 104 ) = ' '
      TEXT( 105 ) = 'Binary Definitions:'
      TEXT( 106 ) = '----------------------------------------'
     .//            '----'
      TEXT( 107 ) = ' '
      TEXT( 108 ) = '       ROTATE @name @number [@unit]'
      TEXT( 109 ) = '       (1:1){ TOWARDS'
      TEXT( 110 ) = '            | AWAY FROM } @name'
      TEXT( 111 ) = ' '
      TEXT( 112 ) = '       ROTATE @name @number'
      TEXT( 113 ) = '       OF THE WAY TOWARDS @name'
      TEXT( 114 ) = ' '
      TEXT( 115 ) = '       CROSS PRODUCT @name @name'
      TEXT( 116 ) = ' '
      TEXT( 117 ) = '       ROTATE @name @number [@unit] ABOU'
     .//            'T @name'
      TEXT( 118 ) = ' '
      TEXT( 119 ) = '   where @name is the name of some direc'
     .//            'tion.'
      TEXT( 120 ) = ' '
 
 
 
      DO I = 1, TXTSIZ
         CALL TOSTDO ( TEXT(I) )
      END DO
 
      RETURN
      END
