C$Procedure PRCINF ( Process an information request )

      SUBROUTINE PRCINF ( INFTYP )

C$ Abstract
C
C     Process an information request:  display "help," "usage," or
C     program version information.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     MEX2KER
C
C$ Declarations
 
      IMPLICIT NONE
      CHARACTER*(*)         INFTYP
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     INFTYP     I   Type of information to display.
C
C$ Detailed_Input
C
C     INFTYP         is a character string indicating the type
C                    of information to display.  The options are:
C
C                       'HELP'        Dump the user's guide.
C
C                       'USAGE'       Display a terse description
C                                     of the program's invocation
C                                     syntax.
C
C                       'VERSION'     Display the program version
C                                     and creation date.  
C
C                     
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If the value of INFTYP is not recognized, the error
C        SPICE(NOTSUPPORTED) is signaled.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     This routine centralizes message display functions for 
C     MEX2KER.  Version, usage, or help text can be displayed.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     N.J. Bachman    (JPL)
C     B.V. Semenov    (JPL)
C
C$ Version
C
C-    MEX2KER Version 2.0.2, 15-JUL-2014 (NJB)(BVS)
C
C        Updated program version. Set help text to point to the
C        User's Guide.
C
C-    MEX2KER Version 2.0.1, 28-JUN-2012 (NJB)
C
C        Updated program version.
C        Updated header format.
C
C-    MEX2KER Version 2.0.0, 20-FEB-2004 (NJB)
C
C        Updated version parameter.
C
C-    MEX2KER Version 1.4.0, 24-JUL-2003 (NJB)
C
C        Updated version parameter.
C
C-    MEX2KER Version 1.3.0, 18-JUN-2003 (NJB)
C
C        Updated version parameter.
C
C-    MEX2KER Version 1.2.0, 14-FEB-2003 (NJB)
C
C        Updated version parameter.
C
C-    MEX2KER Version 1.1.0, 30-JAN-2003 (NJB)
C
C        Updated version parameter.
C
C-    MEX2KER Version 1.0.0, 07-JUN-2002 (NJB)
C
C-&

      
C
C     SPICELIB functions
C
      INTEGER               RTRIM

      LOGICAL               EQSTR      
      LOGICAL               RETURN

C
C     Local parameters
C
      CHARACTER*(*)         VER
      PARAMETER           ( VER = '2.2.0, 15-JUL-2014' )


      INTEGER               HSIZE
      PARAMETER           ( HSIZE  = 1  )

      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )

      INTEGER               USIZE
      PARAMETER           ( USIZE  = 19 )

      INTEGER               VSTRLN
      PARAMETER           ( VSTRLN = 80 )

C
C     Local variables
C
      CHARACTER*(LNSIZE)    HLPTXT ( HSIZE )
      CHARACTER*(LNSIZE)    USGTXT ( USIZE )
      CHARACTER*(VSTRLN)    VERSTR     

      INTEGER               I

      LOGICAL               FIRST

C
C     Saved variables
C
      SAVE                  FIRST
      SAVE                  HLPTXT
      SAVE                  USGTXT
      SAVE                  VERSTR

C
C     Initial values
C
      DATA                  FIRST / .TRUE. /



      IF ( RETURN() ) THEN
         RETURN
      END IF

      CALL CHKIN ( 'PRCINF' )


      IF ( FIRST ) THEN
C
C        This lovely mess was created using Bill Taber's ImportText
C        pipe.
C
         USGTXT(  1 ) = '     Program usage:'
         USGTXT(  2 ) = ' '
         USGTXT(  3 ) = '              > mex2ker [-setup <setup f'
     .   //             'ile name>]'
         USGTXT(  4 ) = '                        [-input <input d'
     .   //             'ata file name>]'
         USGTXT(  5 ) = '                        [-output <output'
     .   //             ' SPK/CK file name>]'
         USGTXT(  6 ) = '                        [-append]'
         USGTXT(  7 ) = '                        [-h|-help]'
         USGTXT(  8 ) = '                        [-u|-usage]'
         USGTXT(  9 ) = '                        [-v|-version]'
         USGTXT( 10 ) = ' '
         USGTXT( 11 ) = '     If a setup file name isn''t provide'
     .   //             'd on the command line, the'
         USGTXT( 12 ) = '     program will prompt for it. It will'
     .   //             ' not prompt for the input'
         USGTXT( 13 ) = '     or output file names; these file na'
     .   //             'mes must be provided on'
         USGTXT( 14 ) = '     the command line or in the setup fi'
     .   //             'le. If input and output'
         USGTXT( 15 ) = '     file names are provided on the comm'
     .   //             'and line, any file names'
         USGTXT( 16 ) = '     assigned using setup keywords are i'
     .   //             'gnored. The input file'
         USGTXT( 17 ) = '     must already exist and, if the -app'
     .   //             'end key or corresponding'
         USGTXT( 18 ) = '     setup file keyword is not specified'
     .   //             ', the output file must be'
         USGTXT( 19 ) = '     a new file.'

         HLPTXT( 1  ) = '     Please see MEX2KER User''s Guide.'

         FIRST = .FALSE.

      END IF




      IF ( EQSTR(INFTYP, 'USAGE') ) THEN
C
C        Display the usage text.
C
         DO I = 1, USIZE
            CALL TOSTDO ( USGTXT(I) )
         END DO

         CALL TOSTDO ( ' ' )


      ELSE IF ( EQSTR(INFTYP, 'VERSION') ) THEN
C
C        Create and display "version" message.
C
         CALL TKVRSN ( 'TOOLKIT', VERSTR )

         CALL TOSTDO ( ' '                                           )
         CALL TOSTDO ( 'MEX2KER Program; Ver. ' // VER // 
     .                 '; Toolkit Ver. ' // VERSTR(:RTRIM(VERSTR))   )
         CALL TOSTDO ( ' '                                           )


      ELSE IF ( EQSTR(INFTYP, 'HELP') ) THEN

         DO I = 1, HSIZE
            CALL TOSTDO ( HLPTXT(I) )
         END DO

         CALL TOSTDO ( ' ' )

      ELSE
C
C        We shouldn't arrive here.
C
         CALL SETMSG ( 'Informational message type # is not '   //
     .                 'supported.'                             )
         CALL ERRCH  ( '#', INFTYP                              )
         CALL SIGERR ( 'SPICE(NOTSUPPORTED)'                    )
         CALL CHKOUT ( 'PRCINF'                                 )
         RETURN

      END IF

      CALL CHKOUT ( 'PRCINF' )
      RETURN
      END
