C$ Abstract
C
C     Include Section:  AEM2CK Global Parameters
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Author_and_Institution
C
C     N.J. Bachman   (JPL)
C
C$ Version
C
C-    Version 1.0.0, 25-JUL-2015 (NJB).
C
C-&

C
C     Command line length:
C
      INTEGER               CMDLEN
      PARAMETER           ( CMDLEN = 2000 )
      
C
C     SPICELIB cell lower bound:
C
      INTEGER               LBCELL
      PARAMETER           ( LBCELL = -5 )
      
C
C     Maximum file name length:
C
      INTEGER               FILSIZ
      PARAMETER           ( FILSIZ = 255 )

C
C     Maximum number of allowed comment lines:
C
      INTEGER               MXCMNT
      PARAMETER           ( MXCMNT = 500 )
      
C
C     Input file line length:
C
      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 500 )

C
C     Input line classification string length:
C
      INTEGER               TYPLEN
      PARAMETER           ( TYPLEN = 80 )

C
C     Length of string for keyword value processing:
C
      INTEGER               SHRTLN
      PARAMETER           ( SHRTLN = 80 ) 

C
C     Method string length:
C
      INTEGER               MTHLEN
      PARAMETER           ( MTHLEN = 20 )

C
C     Attitude representation string length:
C
      INTEGER               ATRLEN
      PARAMETER           ( ATRLEN = 80 )

C
C     Frame name length:
C
      INTEGER               FRNMLN
      PARAMETER           ( FRNMLN = 32 )

C
C     Time system name length:
C
      INTEGER               TSYLEN
      PARAMETER           ( TSYLEN = 20 )

C
C     Default limit on minimum spacing between successive quaternions 
C     in an input AEM file:
C
      DOUBLE PRECISION      MINSPC
      PARAMETER           ( MINSPC = 1.D-3 )

C
C     Default limit on maximum ratio of successive quaternion 
C     separations (input AEM file:
C
      DOUBLE PRECISION      MAXQUO
      PARAMETER           ( MAXQUO = 1.D2 )

C
C     AEM line classifications:
C
      CHARACTER*(*)         CRELIN
      PARAMETER           ( CRELIN = 'CREATION_DATE_LINE' )

      CHARACTER*(*)         COMLIN
      PARAMETER           ( COMLIN = 'COMMENT_LINE' )

      CHARACTER*(*)         COVBEG
      PARAMETER           ( COVBEG = 'COVARIANCE_START_LINE' )

      CHARACTER*(*)         COVEND
      PARAMETER           ( COVEND = 'COVARIANCE_STOP_LINE' )

      CHARACTER*(*)         DATLIN
      PARAMETER           ( DATLIN = 'DATA_LINE' )

      CHARACTER*(*)         DATBEG
      PARAMETER           ( DATBEG = 'DATA_START_LINE' )

      CHARACTER*(*)         DATEND
      PARAMETER           ( DATEND = 'DATA_STOP_LINE' )

      CHARACTER*(*)         METBEG
      PARAMETER           ( METBEG = 'METADATA_START_LINE' )

      CHARACTER*(*)         METEND
      PARAMETER           ( METEND = 'METADATA_STOP_LINE' )

      CHARACTER*(*)         METLIN
      PARAMETER           ( METLIN = 'METADATA_LINE' )

      CHARACTER*(*)         ORGLIN
      PARAMETER           ( ORGLIN = 'ORIGINATOR_LINE' )

      CHARACTER*(*)         VERLIN
      PARAMETER           ( VERLIN = 'VERSION_LINE' )



      


C
C     End Include Section:  AEM2CK Global Parameters 
C
