#!/bin/csh
#
#  This script removes CRs from files listed in the text file specified
#  on the command line.
#
set REMCRS = "remove_crs.pl"

foreach FF (`cat $1`)

   echo $FF

   $REMCRS < $FF > tmp.file

   if ( -z tmp.file ) then
      echo " "
      echo "ERROR: $REMCRS failed to remove CRs from $FF"
      echo "       and produced a zero size file. $REMCRS was run as follows:"
      echo " "
      echo "          $REMCRS < $FF > tmp.file"
      echo " "
      echo "       Possible reasons for this include but are not limited to "
      echo "       $REMCRS not being in the current path, $REMCRS not being "
      echo "       an executable, or $REMCRS invoking perl that doesn't exist"
      echo "       on this system."
      echo " "
      exit(1)

   endif

   mv tmp.file $FF

end

exit

