C$Procedure PRCINF ( Process an information request )

      SUBROUTINE PRCINF ( INFTYP )

C$ Abstract
C
C     Process an information request:  display "help," "usage," 
C     "template, or program version information.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     OEM2SPK
C
C$ Declarations
 
      IMPLICIT NONE
      CHARACTER*(*)         INFTYP
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     INFTYP     I   Type of information to display.
C
C$ Detailed_Input
C
C     INFTYP         is a character string indicating the type
C                    of information to display.  The options are:
C
C                       'HELP'        Dump the introduction from
C                                     the user's guide.
C
C                       'TEMPLATE'    Display a setup file template.
C
C                       'USAGE'       Display a terse description
C                                     of the program's invocation
C                                     syntax.
C
C                       'VERSION'     Display the program version
C                                     and creation date.  
C                     
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If the value of INFTYP is not recognized, the error
C        SPICE(NOTSUPPORTED) is signaled.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     This routine centralizes message display functions for 
C     OEM2SPK.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     [1]  CCSDS Orbit Data Messages Blue Book, version CCSDS 502.0-B-1,
C          September, 2004.
C
C     [2]  CCSDS Orbit Data Messages Blue Book, version CCSDS 502.0-B-2,
C          November, 2009.
C
C$ Author_and_Institution
C
C     N.J. Bachman    (JPL)
C     M.C. Kim        (JPL)
C     B.V. Semenov    (JPL)
C
C$ Version
C
C-    OEM2SPK Version 2.2.0, 01-DEC-2016 (BVS)
C
C        Updated version info. Updated setup file template for
C        the new COVARIANCE_COMMENTS keyword.
C
C-    OEM2SPK Version 2.1.0, 08-MAY-2014 (BVS)
C
C        Updated version info.
C
C-    OEM2SPK Version 2.0.0, 30-AUG-2013 (MCK)
C
C        Updated version info for upgrade to process EOMs 2.0.
C
C-    OEM2SPK Version 1.2.0, 07-OCT-2011 (NJB)
C
C        Updated version info for PRSMET bug fix.
C
C-    OEM2SPK Version 1.1.0, 06-OCT-2006 (NJB)
C
C        Updated version info for CMAP, CMAPI bug fixes.
C
C-    OEM2SPK Version 1.0.0, 26-FEB-2005 (NJB)
C
C-&

      
C
C     SPICELIB functions
C
      INTEGER               RTRIM

      LOGICAL               EQSTR      
      LOGICAL               RETURN

C
C     Local parameters
C
      CHARACTER*(*)         VER
      PARAMETER           ( VER = '2.2.0, 01-DEC-2016' )

      INTEGER               HSIZE
      PARAMETER           ( HSIZE  = 18 )

      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )

      INTEGER               TSIZE
      PARAMETER           ( TSIZE  = 26 )

      INTEGER               USIZE
      PARAMETER           ( USIZE  = 20 )

      INTEGER               VSTRLN
      PARAMETER           ( VSTRLN = 80 )

C
C     Local variables
C
      CHARACTER*(LNSIZE)    BEGMRK
      CHARACTER*(LNSIZE)    ENDMRK
      CHARACTER*(LNSIZE)    HLPTXT ( HSIZE )
      CHARACTER*(LNSIZE)    TMPTXT ( TSIZE )
      CHARACTER*(LNSIZE)    USGTXT ( USIZE )
      CHARACTER*(VSTRLN)    VERSTR     

      INTEGER               I

      LOGICAL               FIRST

C
C     Saved variables
C
      SAVE                  FIRST
      SAVE                  HLPTXT
      SAVE                  TMPTXT
      SAVE                  USGTXT
      SAVE                  VERSTR

C
C     Initial values
C
      DATA                  FIRST / .TRUE. /



      IF ( RETURN() ) THEN
         RETURN
      END IF

      CALL CHKIN ( 'PRCINF' )


      IF ( FIRST ) THEN
C
C        This lovely mess was created using Bill Taber's ImportText
C        pipe.
C
         HLPTXT(  1 ) = '   OEM2SPK is a SPICE-based utility '
     .   //             'program that converts a CCSDS'
         HLPTXT(  2 ) = '   ``Orbit Ephemeris Message'''' tex'
     .   //             't file (referred to as an ``OEM'''' '
     .   //             'or'
         HLPTXT(  3 ) = '   ``OEM file'''') to a binary SPICE'
     .   //             ' SPK file containing type 9 or type'
         HLPTXT(  4 ) = '   13 segments. This SPK file is a b'
     .   //             'inary file constructed according to'
         HLPTXT(  5 ) = '   the DAF (Double precision Array a'
     .   //             'rchitecture, containing one or more'
         HLPTXT(  6 ) = '   SPK data segments.'
         HLPTXT(  7 ) = ' '
         HLPTXT(  8 ) = '   OEM2SPK requires as inputs an OEM'
     .   //             ' file, a SPICE leapseconds kernel, a'
     .   //             'nd a'
         HLPTXT(  9 ) = '   setup file containing commands an'
     .   //             'd data that control OEM2SPK''s opera'
     .   //             'tion.'
         HLPTXT( 10 ) = ' '
         HLPTXT( 11 ) = '   The user may optionally specify a'
     .   //             ' text file containing descriptive te'
     .   //             'xt to'
         HLPTXT( 12 ) = '   be placed in the comment area of '
     .   //             'the SPK file. (Doing this is highly'
         HLPTXT( 13 ) = '   recommended.)'
         HLPTXT( 14 ) = ' '
         HLPTXT( 15 ) = '   For documentation purposes the co'
     .   //             'ntent of the OEM2SPK setup file is'
         HLPTXT( 16 ) = '   automatically placed at the end o'
     .   //             'f the comment area of the SPK file.'
         HLPTXT( 17 ) = ' '
         HLPTXT( 18 ) = '   Run the program with -usage comma'
     .   //             'nd line flag to see usage informatio'
     .   //             'n.'



         USGTXT(  1 ) = '     Program usage:'
         USGTXT(  2 ) = ' '
         USGTXT(  3 ) = '              > oem2spk [-setup <setup '
     .   //             'file name>]'
         USGTXT(  4 ) = '                        [-input <input '
     .   //             'data file name>]'
         USGTXT(  5 ) = '                        [-output <outpu'
     .   //             't SPK file name>]'
         USGTXT(  6 ) = '                        [-append]'
         USGTXT(  7 ) = '                        [-h|-help]'
         USGTXT(  8 ) = '                        [-t|-template]'
         USGTXT(  9 ) = '                        [-u|-usage]'
         USGTXT( 10 ) = '                        [-v|-version]'
         USGTXT( 11 ) = ' '
         USGTXT( 12 ) = '     If a setup file name isn''t provid'
     .   //             'ed on the command line, the'
         USGTXT( 13 ) = '     program will prompt for it. It wil'
     .   //             'l not prompt for the input'
         USGTXT( 14 ) = '     or output file names; these file n'
     .   //             'ames must be provided on'
         USGTXT( 15 ) = '     the command line or in the setup f'
     .   //             'ile. If input and output'
         USGTXT( 16 ) = '     file names are provided on the com'
     .   //             'mand line, any file names'
         USGTXT( 17 ) = '     assigned using setup keywords are '
     .   //             'ignored. The input file'
         USGTXT( 18 ) = '     must already exist and, if the -ap'
     .   //             'pend key or corresponding'
         USGTXT( 19 ) = '     setup file keyword is not specifie'
     .   //             'd, the output file must be'
         USGTXT( 20 ) = '     a new file.'


         BEGMRK(1:1)  =  CHAR( 92 )
         BEGMRK(2: )  =  'begindata'
         ENDMRK(1:1)  =  BEGMRK(1:1)
         ENDMRK(2: )  =  'begintext'

         
         TMPTXT(  1 ) = 'Complete OEM2SPK Setup File Template'
     .   //             ':'
         TMPTXT(  2 ) = ' '
         TMPTXT(  3 ) = ' '
         TMPTXT(  4 ) = BEGMRK
         TMPTXT(  5 ) = '   INPUT_OEM_FILE       = ''OEM file'
     .   //             ' name'''
         TMPTXT(  6 ) = '   OUTPUT_SPK_FILE      = ''SPK file'
     .   //             ' name'''
         TMPTXT(  7 ) = '   LEAPSECONDS_FILE     = ''leapseco'
     .   //             'nds file name'''
         TMPTXT(  8 ) = '   INTERPOLATION_METHOD = ''HERMITE'''
     .   //             ' or ''LAGRANGE'''
         TMPTXT(  9 ) = '   INTERPOLATION_DEGREE = one of {3,'
     .   //             ' 7, 11, 15} if interpolation'
         TMPTXT( 10 ) = '                          method is '
     .   //             'HERMITE; one of {1, 3, ... , 15}'
         TMPTXT( 11 ) = '                          if interpo'
     .   //             'lation method is LAGRANGE'
         TMPTXT( 12 ) = '   STRING_MAPPING       = ( ''first '
     .   //             'input value'',   ''first mapped valu'
     .   //             'e'','
         TMPTXT( 13 ) = '                            ''second'
     .   //             ' input value'',  ''second mapped val'
     .   //             'ue'','
         TMPTXT( 14 ) = '                             ...  )'
         TMPTXT( 15 ) = '   COMMENT_FILE         = ''comment '
     .   //             'file name'''
         TMPTXT( 16 ) = '   MINIMUM_SPACING      = minimum va'
     .   //             'lid time tag spacing in seconds'
         TMPTXT( 17 ) = '   MAXIMUM_SEP_QUOTIENT = maximum al'
     .   //             'lowed value of'
         TMPTXT( 18 ) = '                          (t3-t2)/(t'
     .   //             '2-t1) and (t2-t1)/(t3-t2) for'
         TMPTXT( 19 ) = '                          consecutiv'
     .   //             'e time tags t1, t2, t3'
         TMPTXT( 20 ) = '   START_TIME           = ''start ti'
     .   //             'me''  This must be a string'
         TMPTXT( 21 ) = '                          allowed by'
     .   //             ' the SPICELIB routine STR2ET.'
         TMPTXT( 22 ) = '   STOP_TIME            = ''stop tim'
     .   //             'e''  This must be a string'
         TMPTXT( 23 ) = '                          allowed by'
     .   //             ' the SPICELIB routine STR2ET.'
         TMPTXT( 24 ) = '   APPEND_TO_OUTPUT     = ''YES'' or'
     .   //             ' ''NO'''
         TMPTXT( 25 ) = '   COVARIANCE_COMMENTS  = ''YES'' or'
     .   //             ' ''NO'''
         TMPTXT( 26 ) = ENDMRK

 

         FIRST = .FALSE.

      END IF

 
      IF ( EQSTR(INFTYP, 'TEMPLATE') ) THEN
C
C        Display the template text.
C
         DO I = 1, TSIZE
            CALL TOSTDO ( TMPTXT(I) )
         END DO

         CALL TOSTDO ( ' ' )


      ELSE IF ( EQSTR(INFTYP, 'USAGE') ) THEN
C
C        Display the usage text.
C
         DO I = 1, USIZE
            CALL TOSTDO ( USGTXT(I) )
         END DO

         CALL TOSTDO ( ' ' )


      ELSE IF ( EQSTR(INFTYP, 'VERSION') ) THEN
C
C        Create and display "version" message.
C
         CALL TKVRSN ( 'TOOLKIT', VERSTR )

         CALL TOSTDO ( ' '                                           )
         CALL TOSTDO ( 'OEM2SPK Program; Ver. ' // VER // 
     .                 '; Toolkit Ver. ' // VERSTR(:RTRIM(VERSTR))   )
         CALL TOSTDO ( ' '                                           )


      ELSE IF ( EQSTR(INFTYP, 'HELP') ) THEN

         DO I = 1, HSIZE
            CALL TOSTDO ( HLPTXT(I) )
         END DO

         CALL TOSTDO ( ' ' )

      ELSE
C
C        We shouldn't arrive here.
C
         CALL SETMSG ( 'Informational message type # is not '   //
     .                 'supported.'                             )
         CALL ERRCH  ( '#', INFTYP                              )
         CALL SIGERR ( 'SPICE(NOTSUPPORTED)'                    )
         CALL CHKOUT ( 'PRCINF'                                 )
         RETURN

      END IF

      CALL CHKOUT ( 'PRCINF' )
      RETURN
      END
