#!/bin/csh
#
#  This script adds CRs to files listed in the text file specified on
#  the command line.
#
set ADDCRS = "add_crs.pl"

foreach FF (`cat $1`)

   echo $FF

   $ADDCRS < $FF > tmp.file

   if ( -z tmp.file ) then
      echo " "
      echo "ERROR: $ADDCRS failed to add CRs to $FF"
      echo "       and produced a zero size file. $ADDCRS was run as follows:"
      echo " "
      echo "          $ADDCRS < $FF > tmp.file"
      echo " "
      echo "       Possible reasons for this include but are not limited to "
      echo "       $ADDCRS not being in the current path, $ADDCRS not being "
      echo "       an executable, or $ADDCRS invoking perl that doesn't exist"
      echo "       on this system."
      echo " "
      exit(1)

   endif

   mv tmp.file $FF

end

exit
