#!/usr/bin/env python3

import arcgen.command_line
import json
import os
from os import getcwd

# config_file = 'arcgen_mex.json'
config_file = 'arcgen_tgo.json'

config = None
with open(os.path.join(getcwd(), config_file), 'r') as f:
    config = json.load(f)

if config:

    print("Calling arcgen with configuration file " + config_file + ' ...')
    arcgen.command_line.main(config_file, log=True)

    if config['pds'] == '4':

        # Generate transfer manifest file
        bundle = os.path.basename(config['bundle_directory'])
        print("Generating the transfer manifest file " + bundle + ' ...')
        arcgen.command_line.transfer(bundle, config['bundle_directory'])

    '''
        This block is not working yet because looks like the transfer file is not properly
        closed until this script finishes, so at this point the file is still not flushed
        to disk.
    
        # Move transfer file to the PDS4 Bundle directory
        transfer_file = bundle + ".transfer"
        bundle_base_path = os.path.abspath(config['bundle_directory']).replace(bundle, '')
        old_transfer_file_path = os.path.join(getcwd(), transfer_file)
        new_transfer_file_path = os.path.join(bundle_base_path, transfer_file)
        os.rename(old_transfer_file_path, new_transfer_file_path)
    '''

else:
    print("Cannot load configuration file: " + config_file)
