#!/bin/tcsh

#
# Check that we have exactly two argiments -- keyword=value file with
# source values and XML template that we will try to fill.
#
# The output XML file will have the same name as keyword=value file
# with addiitonal extenssion XML.
#
if ( "$#argv" != 2 ) then
   echo
   echo "Usage: % $0 <valuefile> <templatefile>"
   echo
   exit 1
else
   set VALUES   = $1
   set TEMPLATE = $2
endif

#
# Set path to Java and generate tool bin directory.
#
# Setting on RHEL5:
#
# set path = ( /usr/lib/jvm/jre-1.6.0-ibm.x86_64/bin /home/bsemenov/pds/misc/pds4/generate-0.9.0-dev/bin $path )
#
# Setting on RHEL7:
#
set path = ( /usr/lib/jvm/java-1.6.0-openjdk-1.6.0.41.x86_64/bin /home/bsemenov/pds/misc/pds4/generate-0.9.0-dev/bin $path )

#
# Set Java directory.
#
# Setting on RHEL5:
#
# setenv JAVA_HOME "/usr/lib/jvm/jre-1.6.0-ibm.x86_64"
#
# Setting on RHEL7:
#
setenv JAVA_HOME "/usr/lib/jvm/java-1.6.0-openjdk-1.6.0.41.x86_64"

#
# Run generate tool.
#
generate -p $VALUES -t $TEMPLATE

if ( $status ) then
    echo
    echo "$0 failed. See messages above." 
    echo
    exit 1
endif

#
# "generate" does not write LF on the last line which is problem for
# tools downstream. Add a couple of lines to the end of the output XML
# label to fix that.
#
echo "" >> $VALUES.xml
echo "" >> $VALUES.xml
 
exit 0

