#!/bin/tcsh

set NEWDIR = /usr1/rosetta/RO_RL-E_M_A_C-SPICE-6-V1.0

cd $NEWDIR

set LSK  = "DATA/LSK/NAIF0011.TLS"
set SCLK = "DATA/SCLK/ROS_150908_STEP.TSC"
set FK   = "DATA/FK/ROS_V25.TF"


#
# Do new labels one by one.
#

set NEW = DATA/IK/ROS_STR_V10.TI
set OLD = DATA/IK/ROS_NAVCAM_V01.TI

#-- change: ^SPICE_KERNEL, PRODUCT_CREATION_TIME, PRODUCT_ID, SOURCE_PRODUCT_ID + NAIF_INSTRUMENT_ID ({-226170,-226180} -> {-226080,-226090}), DESCRIPTION ('NAVCAM' -> 'Star Trackers')

cat $OLD:r.LBL | \
    sed "s/$OLD:t/$NEW:t/g" | \
    sed 's/2015-10-26/2015-11-24/g' | \
    sed 's/{-226170,-226180}/{-226080,-226090}/g' | \
    sed 's/NAVCAM/Star Trackers/g' \
    > $NEW:r.LBL

tkdiff $OLD:r.LBL $NEW:r.LBL


exit


