#!/bin/tcsh

set NEWDIR = /usr1/rosetta/RO_RL-E_M_A_C-SPICE-6-V1.0

cd $NEWDIR

set LSK  = "DATA/LSK/NAIF0011.TLS"
set SCLK = "DATA/SCLK/ROS_150908_STEP.TSC"
set FK   = "DATA/FK/ROS_V25.TF"


#
# Do new labels one by one.
#


set NEW = DATA/CK/ROS_VIRTIS_ZERO_V1.BC
set OLD = DATA/CK/ROS_HGA_2010_V0046.BC

#-- change: ^SPICE_KERNEL, PRODUCT_CREATION_TIME, PRODUCT_ID, START_TIME, STOP_TIME, SOURCE_PRODUCT_ID + PRODUCT_VERSION_TYPE, NAIF_INSTRUMENT_ID ({ -226071, -226072 } -> -226215), DESCRIPTION ('reconstructed' -> 'nominal', 'high gain antenna for the year' -> 'Virtis-M articulating mirror', '2010' -> 'at zero position.')

set START = `frmdiff -k $LSK $SCLK $FK -t dumpc -f 'YYYY-MM-DDTHR:MN:SC.### ::RND' $NEW | grep -v '^#' | head -1 | awk '{print $1}'`
set STOP  = `frmdiff -k $LSK $SCLK $FK -t dumpc -f 'YYYY-MM-DDTHR:MN:SC.### ::RND' $NEW | grep -v '^#' | tail -1 | awk '{print $2}'`

cat $OLD:r.LBL | \
    sed "s/$OLD:t/$NEW:t/g" | \
    sed 's/2011-10-27/2015-11-23/g' | \
    sed 's/START_TIME *=.*$/START_TIME                   = '$START'/g' | \
    sed 's/STOP_TIME  *=.*$/STOP_TIME                    = '$STOP'/g' | \
    sed 's/ACTUAL/PREDICT/g' | \
    sed 's/{ -226071, -226072 }/-226215/g' | \
    sed 's/reconstructed/nominal/g' | \
    sed 's/high gain antenna for the year/Virtis-M articulating mirror/g' | \
    sed 's/2010/at zero position./g' \
    > $NEW:r.LBL

tkdiff $OLD:r.LBL $NEW:r.LBL




set NEW = DATA/CK/ROS_VIRTIS_M_0403_1509_V1.BC
set OLD = DATA/CK/ROS_HGA_2010_V0046.BC

#-- change: ^SPICE_KERNEL, PRODUCT_CREATION_TIME, PRODUCT_ID, START_TIME, STOP_TIME, SOURCE_PRODUCT_ID + NAIF_INSTRUMENT_ID ({ -226071, -226072 } -> -226215), DESCRIPTION ('high gain antenna for the year' -> 'Virtis-M articulating mirror', '2010' -> 'for March 2004 - September 2015.')

set START = `frmdiff -k $LSK $SCLK $FK -t dumpc -f 'YYYY-MM-DDTHR:MN:SC.### ::RND' $NEW | grep -v '^#' | head -1 | awk '{print $1}'`
set STOP  = `frmdiff -k $LSK $SCLK $FK -t dumpc -f 'YYYY-MM-DDTHR:MN:SC.### ::RND' $NEW | grep -v '^#' | tail -1 | awk '{print $2}'`

cat $OLD:r.LBL | \
    sed "s/$OLD:t/$NEW:t/g" | \
    sed 's/2011-10-27/2015-11-23/g' | \
    sed 's/START_TIME *=.*$/START_TIME                   = '$START'/g' | \
    sed 's/STOP_TIME  *=.*$/STOP_TIME                    = '$STOP'/g' | \
    sed 's/{ -226071, -226072 }/-226215/g' | \
    sed 's/high gain antenna for the year/Virtis-M articulating mirror/g' | \
    sed 's/2010/for March 2004 - September 2015./g' \
    > $NEW:r.LBL

tkdiff $OLD:r.LBL $NEW:r.LBL




set NEW = DATA/FK/ROS_V25.TF
set OLD = DATA/FK/ROS_V17.TF

#-- change: ^SPICE_KERNEL, PRODUCT_CREATION_TIME, PRODUCT_ID, SOURCE_PRODUCT_ID + DESCRIPTION ('(ROS)' -> '(RO)', '(ROSLN)' -> '(RL)')

cat $OLD:r.LBL | \
    sed "s/$OLD:t/$NEW:t/g" | \
    sed 's/2011-10-27/2015-11-23/g' | \
    sed 's/(ROS)/(RO)/g' | \
    sed 's/(ROSLN)/(RL)/g' \
    > $NEW:r.LBL

tkdiff $OLD:r.LBL $NEW:r.LBL




set NEW = DATA/PCK/ROS_CG_ROT_1408_1409_V10.TPC
set OLD = DATA/PCK/ROS_CGS_RSOC_V01.TPC

#-- change: ^SPICE_KERNEL, PRODUCT_CREATION_TIME, PRODUCT_ID, START_TIME, STOP_TIME, SOURCE_PRODUCT_ID, + PRODUCER_ID, DESCRIPTION ('draft values for the' -> '67P/C-G rotation', 'pole orientation, rotation period and shape' -> 'constants for the CHEOPS coordinate system', 'for 21 Lutetia, with information from the' -> 'applicable only for the period of August-', 'RSOC/RMOC teams, used by the PTB software' -> 'September 2014.')

cat $OLD:r.LBL | \
    sed "s/$OLD:t/$NEW:t/g" | \
    sed 's/2011-10-27/2015-11-23/g' | \
    sed 's/START_TIME *=.*$/START_TIME                   = 2014-08-01T00:00:00/g' | \
    sed 's/STOP_TIME  *=.*$/STOP_TIME                    = 2014-10-01T00:00:00/g' | \
    sed 's/ESA_ESTEC/JPL/g' | \
    sed 's/draft values for the/67P\/C-G rotation/g' | \
    sed 's/pole orientation, rotation period and shape/constants for the CHEOPS coordinate system/g' | \
    sed 's/for 21 Lutetia, with information from the/applicable only for the period of August-/g' | \
    sed 's/RSOC\/RMOC teams, used by the PTB software/September 2014./g' \
    > $NEW:r.LBL

tkdiff $OLD:r.LBL $NEW:r.LBL




set NEW = DATA/PCK/ROS_CG_RAD_V10.TPC
set OLD = DATA/PCK/ROS_CGS_RSOC_V01.TPC

#-- change: ^SPICE_KERNEL, PRODUCT_CREATION_TIME, PRODUCT_ID, SOURCE_PRODUCT_ID + PRODUCER_ID, DESCRIPTION ('draft values for the' -> '67P/C-G radii', 'pole orientation, rotation period and shape' -> 'values for the CHEOPS coordinate system', 'for 21 Lutetia, with information from the' -> ' ', 'RSOC/RMOC teams, used by the PTB software' -> ' ')

cat $OLD:r.LBL | \
    sed "s/$OLD:t/$NEW:t/g" | \
    sed 's/2011-10-27/2015-11-23/g' | \
    sed 's/ESA_ESTEC/JPL/g' | \
    sed 's/draft values for the/67P\/C-G radii/g' | \
    sed 's/pole orientation, rotation period and shape/values for the CHEOPS coordinate system/g' | \
    sed 's/for 21 Lutetia, with information from the//g' | \
    sed 's/RSOC\/RMOC teams, used by the PTB software//g' \
    > $NEW:r.LBL

tkdiff $OLD:r.LBL $NEW:r.LBL



set NEW = DATA/PCK/EARTH_000101_160131_151109.BPC
set OLD = DATA/PCK/EARTH_000101_120117_111026.BPC

#-- change: ^SPICE_KERNEL, PRODUCT_CREATION_TIME, PRODUCT_ID, START_TIME, STOP_TIME, SOURCE_PRODUCT_ID

set START = `frmdiff -k $LSK $SCLK $FK -t dumpc -f 'YYYY-MM-DDTHR:MN:SC.### ::RND' $NEW | grep -v '^#' | head -1 | awk '{print $1}'`
set STOP  = `frmdiff -k $LSK $SCLK $FK -t dumpc -f 'YYYY-MM-DDTHR:MN:SC.### ::RND' $NEW | grep -v '^#' | tail -1 | awk '{print $2}'`

cat $OLD:r.LBL | \
    sed "s/$OLD:t/$NEW:t/g" | \
    sed 's/2011-10-27/2015-11-23/g' | \
    sed 's/START_TIME *=.*$/START_TIME                   = '$START'/g' | \
    sed 's/STOP_TIME  *=.*$/STOP_TIME                    = '$STOP'/g' \
    > $NEW:r.LBL

tkdiff $OLD:r.LBL $NEW:r.LBL




end

