#!/bin/tcsh

#
# This makes index table and label.
#

set TEMPLATE = `pwd`/make_index.template

if ( ! -e $TEMPLATE ) then
    echo cannot find $TEMPLATE
    exit
endif

cd /usr1/rosetta/RO_RL-E_M_A_C-SPICE-6-V1.0

#
# Get field lengths.
#
set LBLLEN = `ls -1 DATA/*/*.LBL | awk 'BEGIN {l=0} {if(length($NF)>l)l=length($NF)} END {print l}'`

set FILLEN = `grep '^ *PRODUCT_ID' DATA/*/*.LBL | sed 's/"/ /g' | awk 'BEGIN {l=0} {if(length($NF)>l)l=length($NF)} END {print l}'`

set DATLEN = `grep '^ *PRODUCT_CREATION_TIME' DATA/*/*.LBL | sed 's/"/ /g' | awk 'BEGIN {l=0} {if(length($NF)>l)l=length($NF)} END {print l}'`

set DSLEN = `grep '^ *DATA_SET_ID' DATA/*/*.LBL | sed 's/"/ /g' | awk 'BEGIN {l=0} {if(length($NF)>l)l=length($NF)} END {print l}'`

#
# Generate index table.
#
\rm INDEX/INDEX.TAB >& /dev/null

foreach FF ( DATA/*/*.LBL )
   set PROD = `grep '^ *PRODUCT_ID' $FF | sed 's/"/ /g' | awk '{print $NF}'`
   set DATE = `grep '^ *PRODUCT_CREATION_TIME' $FF | sed 's/"/ /g' | awk '{print $NF}'`
   set DSID = `grep '^ *DATA_SET_ID' $FF | sed 's/"/ /g' | awk '{print $NF}'`
   echo $FF $PROD $DATE $DSID | awk '{printf "'"@%-${LBLLEN}s@,@%-${FILLEN}s@,%-${DATLEN}s,@%-${DSLEN}s@\n"'", $1, $2, $3, $4}' | sed 's/@/"/g' >> INDEX/INDEX.TAB
end

#
# Set record count and field positions.
#
set NREC   = `wc -l INDEX/INDEX.TAB | awk '{print $1}'`

set DATTIM = `date +"%Y-%m-%dT%H:%M:%S"`

@ FNBEG  = 2
@ FNLEN  = $LBLLEN

@ PIDBEG = 2 + $LBLLEN + 3 
@ PIDLEN = $FILLEN

@ TIMBEG = 2 + $LBLLEN + 3 + $FILLEN + 2
@ TIMLEN = $DATLEN

@ DSBEG  = 2 + $LBLLEN + 3 + $FILLEN + 2 + $DATLEN + 2
@ DSLEN  = $DSLEN 

@ RBYTES = 2 + $LBLLEN + 3 + $FILLEN + 2 + $DATLEN + 2 + $DSLEN + 2

#echo $NREC $DATTIM $FNBEG $FNLEN $PIDBEG $PIDLEN $TIMBEG $TIMLEN $DSBEG $DSLEN $RBYTES

cat $TEMPLATE | \
   sed "s/@rbytes@/$RBYTES/g" | \
   sed "s/@nrec@/$NREC/g" | \
   sed "s/@dattim@/$DATTIM/g" | \
   sed "s/@fnbeg@/$FNBEG/g" | \
   sed "s/@fnlen@/$FNLEN/g" | \
   sed "s/@pidbeg@/$PIDBEG/g" | \
   sed "s/@pidlen@/$PIDLEN/g" | \
   sed "s/@timbeg@/$TIMBEG/g" | \
   sed "s/@timlen@/$TIMLEN/g" | \
   sed "s/@dsbeg@/$DSBEG/g" | \
   sed "s/@dslen@/$DSLEN/g"  \
   > INDEX/INDEX.LBL

tkdiff $TEMPLATE INDEX/INDEX.LBL

exit


