#!/bin/tcsh

#
# This makes DSK labels based on a template. Use @ instead of / in
# values; @ will be replaced with / as a the last set.
#

set TEMPLATE = `pwd`/make_dsk_labels.template

if ( ! -e $TEMPLATE ) then
    echo cannot find $TEMPLATE
    exit
endif

cd /usr1/rosetta/RO_RL-E_M_A_C-SPICE-6-V1.0

foreach FF ( DATA/DSK/*.BDS )

    set FILENAME = $FF:t

    set TNAME    = "N@A"
    if      ( `echo $FF:t | awk '{print substr($1,5,2)}'` == "CG" ) then
	set TNAME    = "67P@CHURYUMOV-GERASIMENKO 1 (1969 R1)"
    else if ( `echo $FF:t | awk '{print substr($1,5,2)}'` == "LU" ) then
	set TNAME    = "21 LUTETIA"
    else if ( `echo $FF:t | awk '{print substr($1,5,2)}'` == "ST" ) then
	set TNAME    = "2867 STEINS"
    endif

    set CNAME    = "N@A"
    if      ( `echo $FF:t | awk '{print substr($1,13,1)}'` == "O" ) then
	set CNAME    = "OSIRIS"
    else if ( `echo $FF:t | awk '{print substr($1,13,1)}'` == "N" ) then
	set CNAME    = "NAVCAM"
    endif

    set TECHN    = "N@A"
    if      ( `echo $FF:t | awk '{print substr($1,14,3)}'` == "SPC" ) then
	set TECHN    = "SPC"
    else if ( `echo $FF:t | awk '{print substr($1,14,3)}'` == "MSD" ) then
	set TECHN    = "MSPCD"
    else if ( `echo $FF:t | awk '{print substr($1,14,3)}'` == "SPG" ) then
	set TECHN    = "SPG"
    endif

    set PNAME    = "N@A"
    if      ( `echo $FF:t | awk '{print substr($1,17,3)}'` == "ESA" ) then
	set PNAME    = "ESA"
    else if ( `echo $FF:t | awk '{print substr($1,17,3)}'` == "LAM" ) then
	set PNAME    = "LAM"
    else if ( `echo $FF:t | awk '{print substr($1,17,3)}'` == "LPS" ) then
	set PNAME    = "LAM-PSI"
    else if ( `echo $FF:t | awk '{print substr($1,17,3)}'` == "DLR" ) then
	set PNAME    = "DLR"
    endif

    set COUNT    = "N@A"
    if      ( `echo $FF:t | awk '{print substr($1,8,1)}'` == "K" ) then
	set COUNT    = "thousand"
    else if ( `echo $FF:t | awk '{print substr($1,8,1)}'` == "M" ) then
	set COUNT    = "million"
    endif
    set COUNT = `echo $FF:t | awk '{print substr($1,9,3)}'`" $COUNT"
    
    set NAMED    = "N@A"
    set TOOLKIT  = "N@A"
    if      ( `echo $FF:t | awk '{print substr($1,21,1)}'` == "N" ) then
	set NAMED    = "named"
	set TOOLKIT  = "SPICE toolkit N0066 or later"
    else if ( `echo $FF:t | awk '{print substr($1,21,1)}'` == "U" ) then
	set NAMED    = "un-named"
	set TOOLKIT  = "SPICE toolkit N0065 or earlier"
    endif

    cat $TEMPLATE | \
        sed "s/@tname@/$TNAME/g" | \
        sed "s/@filename@/$FILENAME/g" | \
        sed "s/@cname@/$CNAME/g" | \
        sed "s/@pname@/$PNAME/g" | \
        sed "s/@techn@/$TECHN/g" | \
        sed "s/@count@/$COUNT/g" | \
        sed "s/@named@/$NAMED/g" | \
        sed "s/@toolkit@/$TOOLKIT/g" | \
        sed "s/@/\//g" \
    	> $FF:r.LBL

    tkdiff $TEMPLATE $FF:r.LBL

end

exit


