#!/bin/tcsh

cd /usr1/rosetta/RO_RL-E_M_A_C-SPICE-6-V1.0

#
# Make a saved copy.
#
foreach FF (  \
              DATA/CK/CATT_DV_145_01_______00216.LBL \
              DATA/CK/ROS_HGA_2014_V0044.LBL \
              DATA/CK/ROS_HGA_2015_V0038.LBL \
              DATA/CK/ROS_SA_2014_V0047.LBL \
              DATA/CK/ROS_SA_2015_V0037.LBL \
              DATA/CK/ROS_LBOOM_V0.LBL \
              DATA/FK/ESTRACK_V01.LBL \
              DATA/IK/ROS_ROLIS_V03.LBL \
              DATA/SPK/ESTRACK_V01.LBL \
              DATA/SPK/ROS_STRUCT_V5.LBL \
           )
   cp $FF $FF.save
end

#
# Fix labels one by one.
#
cat DATA/CK/CATT_DV_145_01_______00216.LBL | \
    sed 's/attitude that/attitude/' | \
    sed 's/must be used with ROS_CHURYUMOV_V01.TF/associated with 67P\/C-G_CK frame/' | \
    sed 's/-100001/-1000012/' > \
    1.txt 
mv 1.txt DATA/CK/CATT_DV_145_01_______00216.LBL

cat DATA/CK/ROS_HGA_2014_V0044.LBL | \
    sed 's/PREDICT/ACTUAL/' | \
    sed 's/Antenna frame/Antenna/' > \
    1.txt
mv 1.txt DATA/CK/ROS_HGA_2014_V0044.LBL

cat DATA/CK/ROS_HGA_2015_V0038.LBL | \
    sed 's/PREDICT/ACTUAL/' | \
    sed 's/Antenna frame/Antenna/' > \
    1.txt
mv 1.txt DATA/CK/ROS_HGA_2015_V0038.LBL

cat DATA/CK/ROS_SA_2014_V0047.LBL | \
    sed 's/PREDICT/ACTUAL/' | \
    sed 's/Arrays frames/Arrays/' > \
    1.txt
mv 1.txt DATA/CK/ROS_SA_2014_V0047.LBL 

cat DATA/CK/ROS_SA_2015_V0037.LBL | \
    sed 's/PREDICT/ACTUAL/' | \
    sed 's/Arrays frames/Arrays/' > \
    1.txt
mv 1.txt DATA/CK/ROS_SA_2015_V0037.LBL

cat DATA/CK/ROS_LBOOM_V0.LBL | \
    sed 's/ESA-ESAC/JPL/' > \
    1.txt
mv 1.txt DATA/CK/ROS_LBOOM_V0.LBL

cat DATA/FK/ESTRACK_V01.LBL | \
    sed 's/JPL/ESA-ESAC/' > \
    1.txt
mv 1.txt DATA/FK/ESTRACK_V01.LBL

cat DATA/IK/ROS_ROLIS_V03.LBL | \
    sed 's/-226811,-226812,-226813,-226814/-226810,-226811,-226812,-226813,-226814/' > \
    1.txt
mv 1.txt DATA/IK/ROS_ROLIS_V03.LBL

cat DATA/SPK/ESTRACK_V01.LBL | \
    sed 's/JPL/ESA-ESAC/' > \
    1.txt
mv 1.txt DATA/SPK/ESTRACK_V01.LBL

cat DATA/SPK/ROS_STRUCT_V5.LBL | \
    sed 's/ESA_ESTEC/ESA-ESAC/' > \
    1.txt
mv 1.txt DATA/SPK/ROS_STRUCT_V5.LBL

#
# Check against saves copies.
#
foreach FF (  \
              DATA/CK/CATT_DV_145_01_______00216.LBL \
              DATA/CK/ROS_HGA_2014_V0044.LBL \
              DATA/CK/ROS_HGA_2015_V0038.LBL \
              DATA/CK/ROS_SA_2014_V0047.LBL \
              DATA/CK/ROS_SA_2015_V0037.LBL \
              DATA/CK/ROS_LBOOM_V0.LBL \
              DATA/FK/ESTRACK_V01.LBL \
              DATA/IK/ROS_ROLIS_V03.LBL \
              DATA/SPK/ESTRACK_V01.LBL \
              DATA/SPK/ROS_STRUCT_V5.LBL \
           )
   tkdiff $FF $FF.save
end

exit
