#!/bin/tcsh

set NEWDIR = /usr1/rosetta/RO_RL-E_M_A_C-SPICE-6-V1.0

cd $NEWDIR

set LSK  = "DATA/LSK/NAIF0011.TLS"
set SCLK = "DATA/SCLK/ROS_150908_STEP.TSC"
set FK   = "DATA/FK/ROS_V25.TF"

#foreach FF ( `ls -1 DATA/CK/*BC | grep -v VIRTIS` )
foreach FF ( DATA/CK/ROS_HGA_2004_V0001.BC )
    set START = `frmdiff -k $LSK $SCLK $FK -t dumpc -f 'YYYY-MM-DDTHR:MN:SC.### ::RND' $FF | grep -v '^#' | head -1 | awk '{print $1}'`
    set STOP  = `frmdiff -k $LSK $SCLK $FK -t dumpc -f 'YYYY-MM-DDTHR:MN:SC.### ::RND' $FF | grep -v '^#' | tail -1 | awk '{print $2}'`
    
    cat $FF:r.LBL | \
      sed 's/^ *START_TIME *=.*$/START_TIME                   = '$START'/' | \
      sed 's/^ *STOP_TIME *=.*$/STOP_TIME                    = '$STOP'/'   \
      > $FF:r.LBL.new

    echo made $FF:r.LBL.new

end 

exit

