KPL/MK

   This meta-kernel lists the CASSINI SPICE kernels providing coverage
   for 2005. All of the kernels listed below are archived in the CAS
   SPICE data set (DATA_SET_ID = "CO-S/J/E/V-SPICE-6-V1.0"). This set
   of files and the order in which they are listed were picked to
   provide the best available data and the most complete coverage for
   the specified year based on the information about the kernels
   available at the time this meta-kernel was made. For detailed
   information about the kernels listed below refer to the internal
   comments included in the kernels and the documentation accompanying
   the CASSINI SPICE data set.

   WARNING: the list of kernels in this meta-kernel does not include
   any PCK files, preventing this data collection from being usable for
   computing derived parameters that require knowledge of the natural
   body orientations, rotations and shapes. The reason for this
   omission is that the multitude of PCK files produced by the CASSINI
   project and archived in the CASSINI SPICE data set did not allow
   NAIF to make a reasonable pick for this kernel type. It is the
   user's responsibility to identify the PCK(s) most suitable for
   his/her application and to load this(these) PCK(s) in addition to
   this meta-kernel.

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the CAS SPICE data set's ``data'' directory on their
   system. Replacing ``/'' with ``\'' and converting line terminators
   to the format native to the user's system may also be required if
   this meta-kernel is to be used on a non-UNIX workstation.

   This file was created on March 12, 2007 by Boris Semenov,
   NAIF/JPL. The original name of this file was cas_2005_v01.tm.

   \begindata

      PATH_VALUES     = ( './data' )

      PATH_SYMBOLS    = ( 'KERNELS' )

      KERNELS_TO_LOAD = (

                          '$KERNELS/lsk/naif0008.tls'

                          '$KERNELS/fk/cas_rocks_v09.tf'

                          '$KERNELS/fk/cas_v39.tf'

                          '$KERNELS/ik/cas_caps_v03.ti'
                          '$KERNELS/ik/cas_cda_v01.ti'
                          '$KERNELS/ik/cas_cirs_v09.ti'
                          '$KERNELS/ik/cas_inms_v02.ti'
                          '$KERNELS/ik/cas_iss_v10.ti'
                          '$KERNELS/ik/cas_mag_v01.ti'
                          '$KERNELS/ik/cas_mimi_v11.ti'
                          '$KERNELS/ik/cas_radar_v11.ti'
                          '$KERNELS/ik/cas_rpws_v01.ti'
                          '$KERNELS/ik/cas_rss_v03.ti'
                          '$KERNELS/ik/cas_sru_v02.ti'
                          '$KERNELS/ik/cas_uvis_v05.ti'
                          '$KERNELS/ik/cas_vims_v06.ti'

                          '$KERNELS/sclk/cas00105.tsc'

                          '$KERNELS/spk/051212AP_RE_90165_14363.bsp'
                          '$KERNELS/spk/060222AP_IRRE_00256_14363.bsp'

                          '$KERNELS/spk/050214R_SCPSE_04336_05015.bsp'
                          '$KERNELS/spk/050411R_SCPSE_05015_05034.bsp'
                          '$KERNELS/spk/050414R_SCPSE_05034_05060.bsp'
                          '$KERNELS/spk/050504R_SCPSE_05060_05081.bsp'
                          '$KERNELS/spk/050506R_SCPSE_05081_05097.bsp'
                          '$KERNELS/spk/050513R_SCPSE_05097_05114.bsp'
                          '$KERNELS/spk/050606R_SCPSE_05114_05132.bsp'
                          '$KERNELS/spk/050623R_SCPSE_05132_05150.bsp'
                          '$KERNELS/spk/050708R_SCPSE_05150_05169.bsp'
                          '$KERNELS/spk/050802R_SCPSE_05169_05186.bsp'
                          '$KERNELS/spk/050825R_SCPSE_05186_05205.bsp'
                          '$KERNELS/spk/050907R_SCPSE_05205_05225.bsp'
                          '$KERNELS/spk/050922R_SCPSE_05225_05245.bsp'
                          '$KERNELS/spk/051011R_SCPSE_05245_05257.bsp'
                          '$KERNELS/spk/051021R_SCPSE_05257_05275.bsp'
                          '$KERNELS/spk/051114R_SCPSE_05275_05293.bsp'
                          '$KERNELS/spk/051213R_SCPSE_05293_05320.bsp'
                          '$KERNELS/spk/060111R_SCPSE_05320_05348.bsp'
                          '$KERNELS/spk/060213R_SCPSE_05348_06005.bsp'

                          '$KERNELS/ck/04351_05022ph_fsiv.bc'
                          '$KERNELS/ck/05022_05058pj_fsiv.bc'
                          '$KERNELS/ck/05058_05099pg_psiv2.bc'
                          '$KERNELS/ck/05099_05134pg_fsiv_lmb.bc'
                          '$KERNELS/ck/05134_05169pn_fsiv_lmb.bc'
                          '$KERNELS/ck/05169_05212pg_fsiv_lmb.bc'
                          '$KERNELS/ck/05212_05242pl_fsiv.bc'
                          '$KERNELS/ck/05242_05281ph_fsiv.bc'
                          '$KERNELS/ck/05281_05316pg.bc'
                          '$KERNELS/ck/05316_05351pg_fsiv.bc'
                          '$KERNELS/ck/05351_06027ph.bc'

                          '$KERNELS/ck/04361_05002ra.bc'
                          '$KERNELS/ck/05002_05007ra.bc'
                          '$KERNELS/ck/05007_05012ra.bc'
                          '$KERNELS/ck/05012_05017ra.bc'
                          '$KERNELS/ck/05017_05022ra.bc'
                          '$KERNELS/ck/05022_05027ra.bc'
                          '$KERNELS/ck/05027_05032ra.bc'
                          '$KERNELS/ck/05032_05037ra.bc'
                          '$KERNELS/ck/05037_05042ra.bc'
                          '$KERNELS/ck/05042_05047ra.bc'
                          '$KERNELS/ck/05047_05052ra.bc'
                          '$KERNELS/ck/05052_05057ra.bc'
                          '$KERNELS/ck/05057_05062ra.bc'
                          '$KERNELS/ck/05062_05067ra.bc'
                          '$KERNELS/ck/05067_05072ra.bc'
                          '$KERNELS/ck/05072_05077ra.bc'
                          '$KERNELS/ck/05077_05082ra.bc'
                          '$KERNELS/ck/05082_05087ra.bc'
                          '$KERNELS/ck/05087_05092ra.bc'
                          '$KERNELS/ck/05092_05097ra.bc'
                          '$KERNELS/ck/05097_05102ra.bc'
                          '$KERNELS/ck/05102_05107ra.bc'
                          '$KERNELS/ck/05107_05112ra.bc'
                          '$KERNELS/ck/05112_05117ra.bc'
                          '$KERNELS/ck/05117_05122ra.bc'
                          '$KERNELS/ck/05122_05127ra.bc'
                          '$KERNELS/ck/05127_05132ra.bc'
                          '$KERNELS/ck/05132_05137ra.bc'
                          '$KERNELS/ck/05137_05142ra.bc'
                          '$KERNELS/ck/05142_05147ra.bc'
                          '$KERNELS/ck/05147_05152ra.bc'
                          '$KERNELS/ck/05152_05157ra.bc'
                          '$KERNELS/ck/05157_05162ra.bc'
                          '$KERNELS/ck/05162_05167ra.bc'
                          '$KERNELS/ck/05167_05172ra.bc'
                          '$KERNELS/ck/05172_05177ra.bc'
                          '$KERNELS/ck/05177_05182ra.bc'
                          '$KERNELS/ck/05182_05187ra.bc'
                          '$KERNELS/ck/05187_05192ra.bc'
                          '$KERNELS/ck/05192_05197ra.bc'
                          '$KERNELS/ck/05197_05202ra.bc'
                          '$KERNELS/ck/05202_05207ra.bc'
                          '$KERNELS/ck/05207_05212ra.bc'
                          '$KERNELS/ck/05212_05217ra.bc'
                          '$KERNELS/ck/05217_05222ra.bc'
                          '$KERNELS/ck/05222_05227ra.bc'
                          '$KERNELS/ck/05227_05232ra.bc'
                          '$KERNELS/ck/05232_05237ra.bc'
                          '$KERNELS/ck/05237_05242ra.bc'
                          '$KERNELS/ck/05242_05247ra.bc'
                          '$KERNELS/ck/05247_05252ra.bc'
                          '$KERNELS/ck/05252_05257ra.bc'
                          '$KERNELS/ck/05257_05262ra.bc'
                          '$KERNELS/ck/05262_05267ra.bc'
                          '$KERNELS/ck/05267_05272ra.bc'
                          '$KERNELS/ck/05272_05277ra.bc'
                          '$KERNELS/ck/05277_05282ra.bc'
                          '$KERNELS/ck/05282_05287ra.bc'
                          '$KERNELS/ck/05287_05292ra.bc'
                          '$KERNELS/ck/05292_05297ra.bc'
                          '$KERNELS/ck/05297_05302ra.bc'
                          '$KERNELS/ck/05302_05307ra.bc'
                          '$KERNELS/ck/05307_05312ra.bc'
                          '$KERNELS/ck/05312_05317ra.bc'
                          '$KERNELS/ck/05317_05322ra.bc'
                          '$KERNELS/ck/05322_05327ra.bc'
                          '$KERNELS/ck/05327_05332ra.bc'
                          '$KERNELS/ck/05332_05337ra.bc'
                          '$KERNELS/ck/05337_05342ra.bc'
                          '$KERNELS/ck/05342_05347ra.bc'
                          '$KERNELS/ck/05347_05352ra.bc'
                          '$KERNELS/ck/05352_05357ra.bc'
                          '$KERNELS/ck/05357_05362ra.bc'
                          '$KERNELS/ck/05362_06002ra.bc'

                          '$KERNELS/ck/cas_cda_20070309.bc'

                        )

   \begintext
