KPL/FK


Mars Global Surveyor Frame Definitions Kernel
===============================================================================

   This Frames Kernel (FK) file contains the complete set of frame
   definitions for the Mars Global Surveyor (MGS) spacecraft, its
   structures, and science instruments. This frames kernel also contains
   name - to - NAIF ID mappings for the MGS science instruments and s/c
   structures (see the last section of the file.)


Version and Date
-------------------------------------------------------------------------------

   Version 1.0 -- January 16, 2007

      Initial release. This release incorporates all frame definitions
      that for a number of historical reasons were initially placed
      into the following MGS text kernels:

         -- SCLK (contained the definitions of the spacecraft and solar
            array frames)

         -- MAG/ER IK (contained the definitions of the additional
            solar array frames and MAG and ER sensor frames)

         -- MHSA IK (contained the MHSA frames definitions)

         -- MOC IK (contained the MOC frames definitions)

         -- MOLA IK (contained the MOLA frame definition)

         -- TES IK (contained the TES frame definition)

         -- HGA FK (contained the definitions of the HGA and other
            antenna frames)

      Note that although the frame definitions were copied to this FK
      file, they were NOT removed from the text kernels in which they
      were originally located.


References
-------------------------------------------------------------------------------

   1.  ``Frames Required Reading''

   2.  ``Kernel Pool Required Reading''

   3.  ``C-Kernel Required Reading''

   4.  The latest MGS SCLK file (mgs_sclkscet_00061.tsc as of 01/16/07)

   5.  The latest MAG/ER IK file (mgs_mager_v12.ti as of 01/16/07)

   6.  The latest MHSA IK file (mgs_mhsa_v23.ti as of 01/16/07)

   7.  The latest MOC IK file (mgs_moc_v20.ti as of 01/16/07)

   8.  The latest MOLA IK file (mgs_mola_v26.ti as of 01/16/07)

   9.  The latest TES IK file (mgs_tes_v12.ti as of 01/16/07)

   10. The latest HGA FK file (mgs_hga_v10.tf as of 01/16/07)


Contact Information
-------------------------------------------------------------------------------

   Boris V. Semenov, NAIF/JPL, (818)-354-8136, Boris.Semenov@jpl.nasa.gov


Implementation Notes
-------------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must ``load'' the kernel, normally during
   program initialization (see [2]). The SPICELIB routine FURNSH
   (furnsh_c in CSPICE, cspice_furnsh in ICY) loads a kernel file into
   the pool as follows:

      CALL FURNSH  ( 'frame_kernel_name' )
      furnsh_c     ( "frame_kernel_name" );
      cspice_furnsh, "frame_kernel_name"

   This file was created and may be updated with a text editor or word
   processor. Should you need to update this kernel in any way,
   please, modify the "Version and Date" section above to reflect the
   changes.


MGS Frames
-------------------------------------------------------------------------------

   The following MGS frames are defined in this kernel file:

           Frame Name          "Relative to" Frame    Frame Type    Frame ID
      ======================  =====================  ============   ========

   Spacecraft frame:
   -----------------
      MGS_SPACECRAFT          J2000                  CK             -94000

   Antenna frames:
   ---------------
      MGS_HGA_HINGE           MGS_SPACECRAFT         CK             -94070
      MGS_HGA_EL_GIMBAL       MGS_HGA_HINGE          CK             -94071
      MGS_HGA_AZ_GIMBAL       MGS_HGA_EL_GIMBAL      CK             -94072
      MGS_HGA                 MGS_HGA_AZ_GIMBAL      FIXED          -94073
      MGS_LGT1                MGS_HGA                FIXED          -94074
      MGS_LGT2                MGS_HGA                FIXED          -94075
      MGS_LGR1                MGS_SPACECRAFT         FIXED          -94076
      MGS_LGR2                MGS_SPACECRAFT         FIXED          -94077

   Solar Array frames:
   -------------------
      MGS_LEFT_SOLAR_ARRAY    MGS_SPACECRAFT         CK             -94001
      MGS_RIGHT_SOLAR_ARRAY   MGS_SPACECRAFT         CK             -94002
      MGS_+Y_SOLAR_ARRAY      MGS_LEFT_SOLAR_ARRAY   FIXED          -94901
      MGS_-Y_SOLAR_ARRAY      MGS_RIGHT_SOLAR_ARRAY  CK             -94902

   Science Instrument frames:
   --------------------------
      MGS_TES                 MGS_SPACECRAFT         FIXED          -94010

      MGS_MHSA                MGS_SPACECRAFT         FIXED          -94020
      MGS_MHSA_D1             MGS_MHSA               FIXED          -94021
      MGS_MHSA_D2             MGS_MHSA               FIXED          -94022
      MGS_MHSA_D3             MGS_MHSA               FIXED          -94023
      MGS_MHSA_D4             MGS_MHSA               FIXED          -94024

      MGS_MOC_NA              MGS_SPACECRAFT         FIXED          -94031
      MGS_MOC_WA_RED          MGS_SPACECRAFT         FIXED          -94032
      MGS_MOC_WA_BLUE         MGS_SPACECRAFT         FIXED          -94033

      MGS_MOLA                MGS_SPACECRAFT         FIXED          -94040

      MGS_MAG_+Y_SENSOR       MGS_+Y_SOLAR_ARRAY     FIXED          -94051
      MGS_MAG_-Y_SENSOR       MGS_-Y_SOLAR_ARRAY     FIXED          -94052
      MGS_ER                  MGS_SPACECRAFT         FIXED          -94053


MGS Frames Hierarchy
-------------------------------------------------------------------------------

   The diagram below shows the MGS reference frames hierarchy:

                                  "J2000"
             +-----------------------------------------------+
             |                       |                       |
             | <--pck                |                       | <--pck
             V                       |                       V
         "IAU_MARS"                  |                  "IAU_EARTH"
         ----------                  |                  -----------
                                     |
                                     |
                                     |
                                     |                 "MGS_MOC_WA_BLUE"
                                     |                 -----------------
                                     |                       ^
                                     |                       |
                                     |                       | <--fixed
                                     |                       |
      "MGS_MHSA_D#"                  |      "MGS_MOC_WA_RED" |
      -------------                  |      ---------------- |
             ^                       |               ^       |
             |                       |               |       |
    fixed--> |                       |               | <-fxd |
             |                       |               |       |
      "MGS_MHSA"   "MGS_MOLA"        |  "MGS_MOC_NA" |       |
      ----------   ----------        |  ------------ |       |
             ^       ^               |       |       |       |
             |       |               |       |       |       |
             | fxd-> |         ck--> |       | <-fxd |       |
             |       |               |       |       |       |
             |       |               V       |       |       |
             |       |      "MGS_SPACECRAFT" |       |       |
             +-----------------------------------------------+
             |       |       |       |       |       |       |
             | fxd-> | fxd-> |       |       | <-fxd | <-fxd |
             |       |       |       |       |       |       |
             |       V       V       |       V       V       |
             | "MGS_LGR1"  "MGS_ER"  |  "MGS_TES" "MGS_LGR2" |
             | ----------  --------  |  --------- ---------- |
             |                       |                       |
             | <--ck                 | <--ck                 | <--ck
             |                       |                       |
             V                       V                       V
    "MGS_RIGHT_SOLAR_ARRAY"   "MGS_HGA_HINGE"      "MGS_LEFT_SOLAR_ARRAY"
    -----------------------   ---------------      ----------------------
             |                       |                       |
             | <--ck                 | <--ck                 | <--fixed
             |                       |                       |
             V                       |                       V
     "MGS_-Y_SOLAR_ARRAY"    "MGS_HGA_EL_GIMBAL"    "MGS_+Y_SOLAR_ARRAY"
     --------------------    -------------------    --------------------
             |                       |                       |
             | <--fixed              | <--ck                 |  <--fixed
             |                       |                       |
             V                       V                       V
     "MGS_MAG_-Y_SENSOR"     "MGS_HGA_AZ_GIMBAL"    "MGS_MAG_+Y_SENSOR"
     -------------------     -------------------    -------------------
                                     |
                                     | <--fixed
                                     |
                                     V
                                 "MGS_HGA"
             +-----------------------------------------------+
             |                                               |
             | <--fixed                                      | <--fixed
             |                                               |
             V                                               V
         "MGS_LGT1"                                      "MGS_LGT2"
         ----------                                      ----------


Spacecraft Frame
-------------------------------------------------------------------------------

   This section contains the definition of the spacecraft reference
   frame. This definition was copied to this FK file from the latest
   MGS SCLK file where it resided during mission operations (for
   historical reasons).

   The spacecraft frame is defined by the s/c design as follows:

      -  +Z axis is parallel to the nominal science instrument boresights;

      -  +X axis is parallel to the nominal HGA boresight for the antenna
         in the stowed position;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is centered on the launch vehicle
         separation plane.

   This diagrams illustrates the s/c frame:

                            Scince
                             Deck
      ._________________.  ._______.  ._________________.
      |                  \ |HGA Side /                  |
      |                   o|       |o                   |
      |                  / |   ^+Zsc \                  |
      ._________________.  .___|___.  ._________________.
                            |  |  |
                            /__|__\                 +Xsc is
                             /_o------> +Ysc      out of the page
                              +Xsc

   Since the S/C bus attitude with respect to an inertial frame is
   provided by a C kernel (see [3]), this frame is defined as a
   CK-based frame.

   \begindata

      FRAME_MGS_SPACECRAFT          = -94000
      FRAME_-94000_NAME             = 'MGS_SPACECRAFT'
      FRAME_-94000_CLASS            =  3
      FRAME_-94000_CLASS_ID         = -94000
      FRAME_-94000_CENTER           = -94
      CK_-94000_SCLK                = -94
      CK_-94000_SPK                 = -94

   \begintext


TES Frames
-------------------------------------------------------------------------------

   This section contains the definition of the reference frame for the
   Thermal Emission Spectrometer  (TES).

   The description and frame definition provided in this section were
   copied from the TES IK file ([9]). In the process, only the
   description was modified; the definition was copied ``as is.''


TES Frames Summary
------------------

   The following TES frame is defined in this kernel file:

           Frame Name          "Relative to" Frame    Frame Type    Frame ID
      ======================  =====================  ============   ========
      MGS_TES                 MGS_SPACECRAFT         FIXED          -94010


TES Frames Hierarchy
--------------------

   The diagram below shows the TES frames hierarchy:

                                  "J2000"
             +-----------------------------------------------+
             |                       |                       |
             | <--pck                |                       | <--pck
             V                       |                       V
         "IAU_MARS"                  |                  "IAU_EARTH"
         ----------                  |                  -----------
                                     |
                                     | <--ck
                                     |
                                     V
                              "MGS_SPACECRAFT"
                              ----------------
                                     |
                                     | <--fixed
                                     |
                                     V
                                 "MGS_TES"
                                 ---------


TES Alignment
-------------

     The offset of the TES instrument fixed frame relative to the Mars
     Global Surveyor spacecraft frame can be specified as three
     rotation angles -- ROLL, PITCH and YAW. From these angles a
     rotation matrix can be constructed that will transform the
     components of a vector expressed in the spacecraft frame to
     components expressed in the TES instrument fixed frame. For
     example, if x y and z are the components of a vector expressed in
     the spacecraft frame, X Y and Z will be the components of the same
     vector expressed in the TES instrument fixed frame:

        [ X ]    [     ]  [ x ]
        | Y |  = | ROT |  | y |
        [ Z ]    [     ]  [ z ]

     where ROT is the rotation matrix constructed from the rotation
     angles as follows:

        [     ]   [     ]  [       ]  [      ]
        [ ROT ] = [ YAW ]  [ PITCH ]  [ ROLL ]
        [     ]   [     ]  [       ]  [      ]
                         Z          Y         X

     where each of three matrices on the right side represent a
     coordinate frame rotation by the given angle around the indicated
     axis.

     The following values of ROLL, PITCH and YAW were measured during
     the pre-launch alignment calibration:

        ROLL  =     0.016 (degrees)
        PITCH =     0.014 (degrees)
        YAW   =   359.996 (degrees)


TES Frame Definition
--------------------

   The TES instrument frame, MGS_TES, is defined as follows:

      -  +Z axis is the instrument boresight; nominally co-aligned with
         the s/c +Z axis;

      -  +Y axis nominally points in the same direction as the s/c +Y
         axis;

      -  +X axis completes the right hand frame; nominally points in
         the same direction as the s/c +X axis;

   This picture illustrates the MGS_TES frame:

                               ^+Ztes
                               |
                               |
                         +Xtes |     +Ytes
                               o------>
      ._________________.  .__|_|__.  ._________________.
      |                  \ |       | /                  |
      |                   o|       |o                   |
      |                  / |   ^+Zsc \                  |
      ._________________.  .___|___.  ._________________.
                            |  |  |
                            /__|__\                 +Xsc and +Xtes
                             /_o------> +Ysc      are out of the page
                              +Xsc


   The block below provides the frame definition keyword set for the
   TES frame incorporating the rotation angles specified in the
   previous subsection (note the opposite sign/order of rotations in the
   definition because the definition contains the transformation from
   the instrument frame to the spacecraft frame, see [1]):

   \begindata

      FRAME_MGS_TES            = -94010
      FRAME_-94010_NAME        = 'MGS_TES'
      FRAME_-94010_CLASS       = 4
      FRAME_-94010_CLASS_ID    = -94010
      FRAME_-94010_CENTER      = -94
      TKFRAME_-94010_SPEC      = 'ANGLES'
      TKFRAME_-94010_RELATIVE  = 'MGS_SPACECRAFT'
      TKFRAME_-94010_ANGLES    = ( -0.000279252680,
                                   -0.000244346095,
                                   -6.283115494010 )
      TKFRAME_-94010_AXES      = (   1,            2,              3 )
      TKFRAME_-94010_UNITS     = 'RADIANS'

   \begintext


MOLA Frames
-------------------------------------------------------------------------------

   This section contains the definition of the reference frame for the
   Mars Orbiter Laser Altimeter (MOLA).

   The description and frame definition provided in this section were
   copied from the MOLA IK file ([8]). In the process, only the
   description was modified; the definition was copied ``as is.''


MOLA Frames Summary
-------------------

   The following MOLA frame is defined in this kernel file:

           Frame Name          "Relative to" Frame    Frame Type    Frame ID
      ======================  =====================  ============   ========
      MGS_MOLA                MGS_SPACECRAFT         FIXED          -94040


MOLA Frames Hierarchy
---------------------

   The diagram below shows the MOLA frames hierarchy:

                                  "J2000"
             +-----------------------------------------------+
             |                       |                       |
             | <--pck                |                       | <--pck
             V                       |                       V
         "IAU_MARS"                  |                  "IAU_EARTH"
         ----------                  |                  -----------
                                     |
                                     | <--ck
                                     |
                                     V
                              "MGS_SPACECRAFT"
                              ----------------
                                     |
                                     | <--fixed
                                     |
                                     V
                                 "MGS_MOLA"
                                 ----------


MOLA Alignment
--------------

   The offset of the MOLA instrument fixed frame relative to the Mars
   Global Surveyor spacecraft frame can be specified as three rotation
   angles -- ROLL, PITCH and YAW. From these angels a rotation matrix
   can be constructed that will transform the components of a vector
   expressed in the spacecraft frame to components expressed in the
   MOLA instrument fixed frame. For example, if x y and z are the
   components of a vector expressed in the spacecraft frame, X Y and Z
   will be the components of the same vector expressed in the MOLA
   instrument fixed frame:

      [ X ]    [     ]  [ x ]
      | Y |  = | ROT |  | y |
      [ Z ]    [     ]  [ z ]

   where ROT is the rotation matrix constructed from the rotation
   angles as follows:

      [     ]   [     ]  [       ]  [      ]
      [ ROT ] = [ YAW ]  [ PITCH ]  [ ROLL ]
      [     ]   [     ]  [       ]  [      ]
                        Z          Y         X

   where each of three matrices on the right side represent a
   coordinate frame rotation by the given angle around the indicated
   axis.

   This set of MOLA alignment angles was derived by the MOLA team from
   in-flight calibration data:

      ROLL  =    -0.0029 (degrees)
      PITCH =   359.9914 (degrees)
      YAW   =     0.059  (degrees)


MOLA Frame Definition
---------------------

   The MOLA instrument frame, MGS_MOLA, is defined as follows:

      -  +Z axis is the receiver boresight; nominally co-aligned with
         the s/c +Z axis;

      -  +Y axis nominally points in the same direction as the s/c +Y
         axis;

      -  +X axis completes the right hand frame; nominally points in
         the same direction as the s/c +X axis;

   This picture illustrates the MGS_MOLA frame:

                                 ^+Zmola
                                 |
                                 |
                          +Xmola.|_.    +Ymola
                               \ o------>
      ._________________.  .____\_/.  ._________________.
      |                  \ |       | /                  |
      |                   o|       |o                   |
      |                  / |   ^+Zsc \                  |
      ._________________.  .___|___.  ._________________.
                            |  |  |
                            /__|__\                 +Xsc and +Xmola
                             /_o------> +Ysc      are out of the page
                              +Xsc


   The block below provides the frame definition keyword set for the
   MOLA frame incorporating the rotation angles specified in the
   previous subsection (note the opposite sign/order of rotations in the
   definition because the definition contains the transformation from
   the instrument frame to the spacecraft frame, see [1]):

   \begindata

      FRAME_MGS_MOLA           = -94040
      FRAME_-94040_NAME        = 'MGS_MOLA'
      FRAME_-94040_CLASS       = 4
      FRAME_-94040_CLASS_ID    = -94040
      FRAME_-94040_CENTER      = -94
      TKFRAME_-94040_SPEC      = 'ANGLES'
      TKFRAME_-94040_RELATIVE  = 'MGS_SPACECRAFT'
      TKFRAME_-94040_ANGLES    = (   0.0000506145,
                                    -6.283035209,
                                    -0.001029744259 )
      TKFRAME_-94040_AXES      = (  1, 2, 3  )
      TKFRAME_-94040_UNITS     = 'RADIANS'

   \begintext


MOC Frames
-------------------------------------------------------------------------------

   This section contains the definitions of the reference frames for
   the Mars Orbiter Camera camera (MOC).

   The description and frame definitions provided in this section were
   copied from the MOC IK file ([7]). In the process, only the
   description was modified; the definitions were copied ``as is.''


MOC Frames Summary
------------------

   The following MOC frames are defined in this kernel file:

           Frame Name          "Relative to" Frame    Frame Type    Frame ID
      ======================  =====================  ============   ========
      MGS_MOC_NA              MGS_SPACECRAFT         FIXED          -94031
      MGS_MOC_WA_RED          MGS_SPACECRAFT         FIXED          -94032
      MGS_MOC_WA_BLUE         MGS_SPACECRAFT         FIXED          -94033


MOC Frames Hierarchy
--------------------

   The diagram below shows the MOC frames hierarchy:

                                  "J2000"
             +-----------------------------------------------+
             |                       |                       |
             | <--pck                |                       | <--pck
             V                       |                       V
         "IAU_MARS"                  |                  "IAU_EARTH"
         ----------                  |                  -----------
                                     |
                                     | <--ck
                                     |
                                     V
                              "MGS_SPACECRAFT"
             +-----------------------------------------------+
             |                       |                       |
             | <--fixed              | <--fixed              |  <--fixed
             |                       |                       |
             V                       V                       V
       "MGS_MOC_NA"            "MGS_MOC_WA_RED"      "MGS_MOC_WA_BLUE"
       ------------            ----------------      -----------------


MOC Camera Alignments
---------------------

   The offset of each individual MOC camera frame relative to the Mars
   Global Surveyor spacecraft frame can be specified as three rotation
   angles -- ROLL, PITCH and YAW. From these angles a rotation matrix
   can be constructed that will transform the components of a vector
   expressed in the spacecraft frame to components expressed in the MOC
   camera fixed frame. For example, if x y and z are the components of
   a vector expressed in the spacecraft frame, X Y and Z will be the
   components of the same vector expressed in the MOC camera frame:

      [ X ]    [     ]  [ x ]
      | Y |  = | ROT |  | y |
      [ Z ]    [     ]  [ z ]

   where ROT is the rotation matrix constructed from the rotation
   angles as follows:

      [     ]   [     ]  [       ]  [      ]
      [ ROT ] = [ YAW ]  [ PITCH ]  [ ROLL ]
      [     ]   [     ]  [       ]  [      ]
                       Z          Y         X

   where each of three matrices on the right side represent a
   coordinate frame rotation by the given angle around the indicated
   axis.

   This set of MOC camera alignment angles was derived by USGS as the
   result of extensive analysis of the in-flight MOC images:

      ----------------------------------------------------------------
       Instrument        Roll, deg       Pitch, deg        Yaw, deg
      ----------------------------------------------------------------
       MOC-NA            0.11463          -0.07162          0.18000
       MOC-WA/RED  (*)   1.04764          -0.45229         -0.78644
       MOC-WA/BLUE (*)   1.01022          -0.35472         -0.30189

   (*) The boresight direction defined by these angles for the WA/RED
       and WA/BLUE cameras corresponds to the pixel closest to the
       optical axis rather than to the central pixel of the line
       detector. For the WA/RED camera it's pixel 1673.65; for the
       WA/BLUE camera it's pixel 1687.58. For both WA cameras these
       angles define the frame with respect to which the radial
       distortion function provided in the MOC IK file ([7]).


MOC Frames Definitions
----------------------

   The NA camera frame is defined as follows:

      -  +Z axis is the camera boresight, looking outwards (based on
         the view direction from the detector line central pixel);

      -  +Y axis is along the camera detector line and points in the
         same direction as the s/c +Y axis;

      -  +X axis completes the right hand frame (X cross Y = Z);

   The WA camera frames are defined as follows:

      -  +Z axis is the camera optical boresight, looking outwards
         (based on the view direction from the pixel closest to the
         optical axis of the camera -- pixel 1673.6 for WA/RED and
         pixel 1687.58 for WA/BLUE.);

      -  +Y axis is along the camera detector line and points in the
         same direction as the s/c +Y axis;

      -  +X axis completes the right hand frame (X cross Y = Z);

   This picture illustrates the NA, WA_RED and WA_BLUE camera frames:

                                 ^+Zmoc
                                 |
                                 |
                           +Xmoc.|.      +Ymoc
                                |o------>
      ._________________.  .____|_|.  ._________________.
      |                  \ |       | /                  |
      |                   o|       |o                   |
      |                  / |   ^+Zsc \                  |
      ._________________.  .___|___.  ._________________.
                            |  |  |
                            /__|__\                 +Xsc and +Xmoc
                             /_o------> +Ysc      are out of the page
                              +Xsc

   The block below provides the frame definition keyword sets for the
   MOC frames incorporating the rotation angles specified in the
   previous subsection (note the opposite sign/order of rotations in the
   definitions because the definitions contain the transformations from
   the camera frames to the spacecraft frame, see [1]):

   \begindata

      FRAME_MGS_MOC_NA         = -94031
      FRAME_-94031_NAME        = 'MGS_MOC_NA'
      FRAME_-94031_CLASS       = 4
      FRAME_-94031_CLASS_ID    = -94031
      FRAME_-94031_CENTER      = -94
      TKFRAME_-94031_SPEC      = 'ANGLES'
      TKFRAME_-94031_RELATIVE  = 'MGS_SPACECRAFT'
      TKFRAME_-94031_ANGLES    = ( -0.0020006709 0.0012500048 -0.0031415927 )
      TKFRAME_-94031_AXES      = (  1,           2,            3            )
      TKFRAME_-94031_UNITS     = 'RADIANS'

      FRAME_MGS_MOC_WA_RED     = -94032
      FRAME_-94032_NAME        = 'MGS_MOC_WA_RED'
      FRAME_-94032_CLASS       = 4
      FRAME_-94032_CLASS_ID    = -94032
      FRAME_-94032_CENTER      = -94
      TKFRAME_-94032_SPEC      = 'ANGLES'
      TKFRAME_-94032_RELATIVE  = 'MGS_SPACECRAFT'
      TKFRAME_-94032_ANGLES    = ( -0.0182847674 0.0078939497  0.0137259674 )
      TKFRAME_-94032_AXES      = (  1,           2,            3            )
      TKFRAME_-94032_UNITS     = 'RADIANS'

      FRAME_MGS_MOC_WA_BLUE    = -94033
      FRAME_-94033_NAME        = 'MGS_MOC_WA_BLUE'
      FRAME_-94033_CLASS       = 4
      FRAME_-94033_CLASS_ID    = -94033
      FRAME_-94033_CENTER      = -94
      TKFRAME_-94033_SPEC      = 'ANGLES'
      TKFRAME_-94033_RELATIVE  = 'MGS_SPACECRAFT'
      TKFRAME_-94033_ANGLES    = ( -0.0176316652 0.0061910319  0.0052689745 )
      TKFRAME_-94033_AXES      = (  1,           2,            3            )
      TKFRAME_-94033_UNITS     = 'RADIANS'

   \begintext


MHSA Frames
-------------------------------------------------------------------------------

   This section contains the definitions of the reference frames for
   the MGS Horizon Sensor Assembly (MHSA) and its detectors.

   The description and frame definition provided in this section were
   copied from the MHSA IK file ([6]). In the process, only the
   description was modified; the definitions were copied ``as is.''


MHSA Frames Summary
-------------------

   The following MHSA frames are defined in this kernel file:

           Frame Name          "Relative to" Frame    Frame Type    Frame ID
      ======================  =====================  ============   ========
      MGS_MHSA                MGS_SPACECRAFT         FIXED          -94020
      MGS_MHSA_D1             MGS_MHSA               FIXED          -94021
      MGS_MHSA_D2             MGS_MHSA               FIXED          -94022
      MGS_MHSA_D3             MGS_MHSA               FIXED          -94023
      MGS_MHSA_D4             MGS_MHSA               FIXED          -94024


MHSA Frames Hierarchy
---------------------

   The diagram below shows the MHSA frames hierarchy:

                                  "J2000"
             +-----------------------------------------------+
             |                       |                       |
             | <--pck                |                       | <--pck
             V                       |                       V
         "IAU_MARS"                  |                  "IAU_EARTH"
         ----------                  |                  -----------
                                     |
                                     | <--ck
                                     |
                                     V
                              "MGS_SPACECRAFT"
                              ----------------
                                     |
                                     | <--fixed
                                     |
                                     V
                                 "MGS_MHSA"
               +--------------------------------------------+
               |              |              |              |
               | <--fixed     |  <--fixed    |  <--fixed    | <--fixed
               |              |              |              |
               V              V              V              V
         "MGS_MHSA_D1"  "MGS_MHSA_D2"  "MGS_MHSA_D3"  "MGS_MHSA_D4"
         -------------  -------------  -------------  -------------


MHSA Mounting Offset
--------------------

   The offset of the MHSA instrument fixed frame relative to the Mars
   Global Surveyor spacecraft frame can be specified as the three
   rotation angles -- ROLL, PITCH and YAW. From these angles a rotation
   matrix can be constructed that will transform the components of a
   vector expressed in the spacecraft frame to components expressed in
   the MHSA instrument fixed frame. For example, if x y and z are the
   components of a vector expressed in the spacecraft frame, X Y and Z
   will be the components of the same vector expressed in the MHSA
   instrument fixed frame:

        [ X ]    [     ]  [ x ]
        | Y |  = | ROT |  | y |
        [ Z ]    [     ]  [ z ]

   where ROT is the rotation matrix constructed from the rotation
   angles as follows:

        [     ]   [     ]  [       ]  [      ]
        [ ROT ] = [ YAW ]  [ PITCH ]  [ ROLL ]
        [     ]   [     ]  [       ]  [      ]
                         Z          Y         X

   where each of three matrices on the right side represent a
   coordinate frame rotation by the given angle around the indicated
   axis.

   The following values of ROLL, PITCH and YAW measured pre-launch give
   the alignment of the MHSA alignment cube:

      ROLL  =   359.967 (degrees)
      PITCH =     0.037 (degrees)
      YAW   =   359.974 (degrees)

   An additional -45 degree offset must be applied in YAW because the
   actual MHSA frame (or so called Barnes frame) in which the detector
   field of view vectors are defined is rotated relative to the
   alignment cube by that angle about Z axis. So

      YAW   = ( 359.974 - 45.0 ) = 314.974 (degrees)


MHSA Detectors Orientations
---------------------------

   The following text describes the MHSA detector view directions:

      For each MHSA quadrant, two angles are necessary to describe the
      field of view vectors in Barnes(*) frame. These angles are ALPHA
      and THETA. Following is the table showing the Barnes data:

                  THETA          ALPHA
               -----------    -----------
            1     44.85583       65.68686
            2     45.11277       65.62951
            3     45.18111       65.62672
            4     44.81861       65.72406

      ALPHA (A) is defined as the angle from Barnes Z axis to the field
      of view vector. In general, THETA (T) defines an angle from
      Barnes +/-Y axis to the projection of the field of view vector
      onto the Barnes XY plane. However, the precise definition of the
      angle depends on which quadrant it refers to. Following is a
      table which specifies how the field of view vectors were
      calculated in the Barnes frame, using the correct quadrant
      dependent definition of THETA.

                        X              Y           Z
                  ------------   ------------   -------
         QUAD1     sin(A)sin(T)   sin(A)cos(T)  cos(A)
         QUAD2    -sin(A)sin(T)  -sin(A)cos(T)  cos(A)
         QUAD3     sin(A)sin(T)  -sin(A)cos(T)  cos(A)
         QUAD4    -sin(A)sin(T)   sin(A)cos(T)  cos(A)


   The angles ALPHA and THETA provided in the first table above in
   combination with the data from the second table can be easily
   transformed into two other angles (ALPHA' and THETA'), defining the
   rotations required to construct a rotation matrix that will
   transform the components of a vector expressed in the MHSA
   instrument fixed frame to the components of a vector expressed in a
   particular detector frame.

   The first of these angles, THETA', is the angle between +X axis of
   the Barnes frame and projection of the field of view vector onto the
   Barnes XY plane. It can be derived from THETA and corresponds to the
   first rotation about +Z axis of the Barnes frame. The second angle,
   ALPHA', is the same as ALPHA, i.e. it the angle from Barnes Z axis
   to the field of view vector. It corresponds to the second rotation
   about new position of the +Y axis of the Barnes frame.

   The derived values of the ALPHA' and THETA' are provided in the table
   below:

                      THETA'                      ALPHA'
              ----------------------------     -----------
         1   (  90 - 44.85583 ) =  45.14417      65.68686
         2   ( 270 - 45.11277 ) = 224.88723      65.62951
         3   ( 270 + 45.18111 ) = 315.18111      65.62672
         4   (  90 + 44.81861 ) = 134.81861      65.72406

   The FOV vectors defined in the table above go through the
   geometrical centers of the detectors (i.e. centers of the circles
   circumscribing 4 elements of each FOV). To make the centers of the
   middle lower elements be FOV vectors, 2.7 degrees offset must be
   subtracted from ALPHA angle for each detector:

                      THETA'                      ALPHA'       ALPHA1'
              ----------------------------     -----------   ----------
         1   (  90 - 44.85583 ) =  45.14417      65.68686     62.98686
         2   ( 270 - 45.11277 ) = 224.88723      65.62951     62.92951
         3   ( 270 + 45.18111 ) = 315.18111      65.62672     62.92672
         4   (  90 + 44.81861 ) = 134.81861      65.72406     63.02406

   A rotation matrix transforming the components of a vector expressed
   in the MHSA instrument fixed frame to the components of a vector
   expressed in a particular detector frame can be constructed from
   these two rotation angles as follows:

         [      ]    [         ]  [         ]
         [ ROTi ] =  [ ALPHA'i ]  [ THETA'i ]
         [      ]    [         ]  [         ]
                                Y            Z

   where each of two matrices on the right side represent a coordinate
   frame rotation by the given angle around the indicated axis.

   Then given a X, Y and Z, the components of a vector expressed in the
   Barnes instrument fixed frame, the corresponding Xi, Yi and Zi, the
   components of the same vector expressed in the "i"th detector frame,
   can be calculated as follows:


         [ Xi ]    [      ]  [ x ]
         | Yi |  = | ROTi |  | y |
         [ Zi ]    [      ]  [ z ]

   where ROTi is the rotation matrix constructed from the corresponding
   rotation angles above


MHSA Frame Definitions
----------------------

   The block below provides the frame definition keyword sets for the
   MHSA frames incorporating the rotation angles specified in the
   previous two subsections (note the opposite sign/order of rotations in
   the definitions because the definitions contain the transformations
   from the instrument frames to the base frames, see [1]):

   \begindata

      FRAME_MGS_MHSA           = -94020
      FRAME_-94020_NAME        = 'MGS_MHSA'
      FRAME_-94020_CLASS       = 4
      FRAME_-94020_CLASS_ID    = -94020
      FRAME_-94020_CENTER      = -94
      TKFRAME_-94020_SPEC      = 'ANGLES'
      TKFRAME_-94020_RELATIVE  = 'MGS_SPACECRAFT'
      TKFRAME_-94020_ANGLES    = ( -6.282609348526,
                                   -0.000645771823,
                                   -5.497333358177 )
      TKFRAME_-94020_AXES      = (  1,             2,              3    )
      TKFRAME_-94020_UNITS     = 'RADIANS'

      FRAME_MGS_MHSA_D1        = -94021
      FRAME_-94021_NAME        = 'MGS_MHSA_D1'
      FRAME_-94021_CLASS       = 4
      FRAME_-94021_CLASS_ID    = -94021
      FRAME_-94021_CENTER      = -94
      TKFRAME_-94021_SPEC      = 'ANGLES'
      TKFRAME_-94021_RELATIVE  = 'MGS_MHSA'
      TKFRAME_-94021_ANGLES    = ( -0.7879144046, -1.0993280925,  0.0   )
      TKFRAME_-94021_AXES      = (  3,             2,              3    )
      TKFRAME_-94021_UNITS     = 'RADIANS'

      FRAME_MGS_MHSA_D2        = -94022
      FRAME_-94022_NAME        = 'MGS_MHSA_D2'
      FRAME_-94022_CLASS       = 4
      FRAME_-94022_CLASS_ID    = -94022
      FRAME_-94022_CENTER      = -94
      TKFRAME_-94022_SPEC      = 'ANGLES'
      TKFRAME_-94022_RELATIVE  = 'MGS_MHSA'
      TKFRAME_-94022_ANGLES    = ( -3.9250226092, -1.0983271462,  0.0   )
      TKFRAME_-94022_AXES      = (  3,             2,              3    )
      TKFRAME_-94022_UNITS     = 'RADIANS'

      FRAME_MGS_MHSA_D3        = -94023
      FRAME_-94023_NAME        = 'MGS_MHSA_D3'
      FRAME_-94023_CLASS       = 4
      FRAME_-94023_CLASS_ID    = -94023
      FRAME_-94023_CENTER      = -94
      TKFRAME_-94023_SPEC      = 'ANGLES'
      TKFRAME_-94023_RELATIVE  = 'MGS_MHSA'
      TKFRAME_-94023_ANGLES    = ( -5.5009481096, -1.0982784515,  0.0   )
      TKFRAME_-94023_AXES      = (  3,              2,              3   )
      TKFRAME_-94023_UNITS     = 'RADIANS'

      FRAME_MGS_MHSA_D4        = -94024
      FRAME_-94024_NAME        = 'MGS_MHSA_D4'
      FRAME_-94024_CLASS       = 4
      FRAME_-94024_CLASS_ID    = -94024
      FRAME_-94024_CENTER      = -94
      TKFRAME_-94024_SPEC      = 'ANGLES'
      TKFRAME_-94024_RELATIVE  = 'MGS_MHSA'
      TKFRAME_-94024_ANGLES    = ( -2.3530286375, -1.0999773550,  0.0   )
      TKFRAME_-94024_AXES      = (  3,              2,              3   )
      TKFRAME_-94024_UNITS     = 'RADIANS'

   \begintext


Solar Array and MAG/ER Sensor Frames
-------------------------------------------------------------------------------

   This section contains the definitions of the reference frames for
   the Magnetometer (MAG) sensors, Electron-Reflectometer (ER) sensor
   and the solar arrays.

   The description and most of the frame definitions provided in this
   section were copied from the MAG/ER IK file ([5]); the
   "MGS_LEFT_SOLAR_ARRAY" and "MGS_RIGHT_SOLAR_ARRAY" frame definitions
   were copied from the MGS SCLK file ([4]). In the process, only the
   description was modified; the definitions were copied ``as is.''


Solar Array and MAG/ER Frames Summary
-------------------------------------

   The following MGS solar array and MAG/ER frames are defined in this
   kernel file:

           Frame Name          "Relative to" Frame    Frame Type    Frame ID
      ======================  =====================  ============   ========
      MGS_LEFT_SOLAR_ARRAY    MGS_SPACECRAFT         CK             -94001
      MGS_RIGHT_SOLAR_ARRAY   MGS_SPACECRAFT         CK             -94002
      MGS_+Y_SOLAR_ARRAY      MGS_LEFT_SOLAR_ARRAY   FIXED          -94901
      MGS_-Y_SOLAR_ARRAY      MGS_RIGHT_SOLAR_ARRAY  CK             -94902
      MGS_MAG_+Y_SENSOR       MGS_+Y_SOLAR_ARRAY     FIXED          -94051
      MGS_MAG_-Y_SENSOR       MGS_-Y_SOLAR_ARRAY     FIXED          -94052
      MGS_ER                  MGS_SPACECRAFT         FIXED          -94053


Solar Array and MAG/ER Sensor Frames Hierarchy
----------------------------------------------

   The diagram below shows the MGS Solar Array and MAG/ER frames hierarchy:

                                  "J2000"
             +-----------------------------------------------+
             |                       |                       |
             | <--pck                |                       | <--pck
             V                       |                       V
         "IAU_MARS"                  |                  "IAU_EARTH"
         ----------                  |                  -----------
                                     |
                                     | <--ck
                                     |
                                     V
                              "MGS_SPACECRAFT"
             +-----------------------------------------------+
             |                       |                       |
             | <--ck                 |                       | <--ck
             |                       |                       |
             V                       |                       V
    "MGS_RIGHT_SOLAR_ARRAY"          |             "MGS_LEFT_SOLAR_ARRAY"
    -----------------------          |             ----------------------
             |                       |                       |
             | <--ck                 |                       | <--fixed
             |                       |                       |
             V                       |                       V
     "MGS_-Y_SOLAR_ARRAY"            |              "MGS_+Y_SOLAR_ARRAY"
     --------------------            |              --------------------
             |                       |                       |
             | <--fixed              | <--fixed              |  <--fixed
             |                       |                       |
             V                       V                       V
     "MGS_MAG_-Y_SENSOR"          "MGS_ER"          "MGS_MAG_+Y_SENSOR"
     -------------------          --------          -------------------


Solar Array and MAG/ER Frames Diagram
-------------------------------------

   The following diagrams shows the frames defined for the MGS solar
   arrays and MAG sensors:
                                     +Z
                                      |
                                      |
                                      *--- +Y
                                  +X /

                                 S/C body FR
                      +Z       (MGS_SPACECRAFT)            +Z
                        | +X          |                   |
                        |/            |                   |
                  +Y ---*             |                   *--- +Y
                                      |               +X /
                         -Y Gimbal FR |  +Y Gimbal FR
                         (MGS_RIGHT_  |  (MGS_LEFT_              +Z
               +Z        SOLAR_ARRAY) |  SOLAR_ARRAY)           |
                | +X           |      |      |                  |
                |/             |      |      |                  *--- +Y
          +Y ---*              |      |      |              +X /
                   -Y Yoke FR  |      |      |    +Y Yoke FR
                 (MGS_+Y_SOLAR |      |      |  (MGS_+Y_SOLAR
                    _ARRAY)    |      |      |      _ARRAY)
        *--- +Y        |       |      |      |       |             *--- +Y
       /|              |       |      |      |       |            /|
    +Z  |              |       |      |      |       |         +Z  |
       +X              |       |      |      |       |              +X
                       |       |      V      |       |
   -Y MAG sensor FR    |       |    ______   |       |    +Y MAG sensor FR
   (MGS_MAG_-Y_SENSOR) |       V   /     /|  V       |  (MGS_MAG_+Y_SENSOR)
        |  .___________|_ _____.  /_____/ |       .__|__ ___________|__.
        V /            V//     |  |     | |     .'   V //           V /
         /    -Y Solar //      |  |     | |   .'      // +Y Solar    /
        @       Array /@       @--|     | ---@       @/   Array     @
       /             //      .'   |     | |  |      //             /
      ._____________//_____.'     |     | '  |_____//_____________.
                                  ._____.'


   The "MGS_LEFT_SOLAR_ARRAY" and "MGS_RIGHT_SOLAR_ARRAY" frames are
   associated with the +Y and -Y solar array gimbals respectively. The
   orientation of these frames is provided in the CK files produced by
   the MGSSCK program at LMA. Note that there are no separate frames
   defined for inboard ("elevation") and outboard ("azimuth") gimbals
   for each solar array. Instead each pair of gimbals is considered as
   a single gimbal having two degrees of rotational freedom. These
   frames can be considered the "nominal" solar array position frames
   since they specify gimbal orientation and do not take into account
   any additional rotations that occured due to an incomplete
   deployment of the -Y array.

   The "MGS_+Y_SOLAR_ARRAY" and "MGS_-Y_SOLAR_ARRAY" frames are
   associated with the +Y and -Y solar array yokes respectively. These
   frames are defined relative to the corresponding gimbal frames
   Defining these frames was required because of the -Y solar array
   deployment failure, which introduced an additional rotation in the
   yoke for that panel. For the +Y panel this frame is co-aligned with
   the gimbal frame.

   The "MGS_MAG_+Y_SENSOR" and "MGS_MAG_-Y_SENSOR" frames are
   associated with the +Y and -Y MAG sensors. These frames are fixed
   offset frames whose orientation is specified by a set of Euler
   angles relative to the corresponding yoke frames.

   The "MGS_MAG_ER" frame is associated with the ER sensor. Because the
   ER sensor is rigidly mounted on the spacecraft, this frame is a
   fixed offset frame whose orientation is specified by a set of Euler
   angles relative to the spacecraft frame.


Solar Array Gimbal and Yoke Frame Definitions
---------------------------------------------

   The +Y solar array gimbal frame ("MGS_LEFT_SOLAR_ARRAY") and the -Y
   solar array gimbal ("MGS_RIGHT_SOLAR_ARRAY") frames constantly
   change their orientation with respect to the spacecraft frame as
   they track the Sun. These frame are defined as CK-based frames with
   their orientation provided in the solar array CK files.

   The -Y solar array yoke frame ("MGS_-Y_SOLAR_ARRAY") is rotated by
   the hinge deflection angle about the X axis relative to the -Y solar
   array gimbal frame ("MGS_RIGHT_SOLAR_ARRAY"). Because the -Y solar
   array was not fully deployed causing this rotation to vary over
   time, this frame is defined as a CK-based frame with it orientation
   stored in the hinge deflection CK file.

   The +Y solar array yoke frame("MGS_+Y_SOLAR_ARRAY") is co-aligned
   with the +Y solar array gimbal frame ("MGS_LEFT_SOLAR_ARRAY") frame.
   It is defined as a fixed offset frame.

   The block below provides the frame definition keyword sets for the
   SA gimbal and yoke frames:

   \begindata

      FRAME_MGS_LEFT_SOLAR_ARRAY        = -94001
      FRAME_-94001_NAME                 = 'MGS_LEFT_SOLAR_ARRAY'
      FRAME_-94001_CLASS                =  3
      FRAME_-94001_CLASS_ID             = -94001
      FRAME_-94001_CENTER               = -94
      CK_-94001_SCLK                    = -94
      CK_-94001_SPK                     = -94

      FRAME_MGS_+Y_SOLAR_ARRAY          = -94901
      FRAME_-94901_NAME                 = 'MGS_+Y_SOLAR_ARRAY'
      FRAME_-94901_CLASS                = 4
      FRAME_-94901_CLASS_ID             = -94901
      FRAME_-94901_CENTER               = -94
      TKFRAME_-94901_SPEC               = 'ANGLES'
      TKFRAME_-94901_RELATIVE           = 'MGS_LEFT_SOLAR_ARRAY'
      TKFRAME_-94901_ANGLES             = ( 0.0, 0.0, 0.0 )
      TKFRAME_-94901_AXES               = (   1,   2,   3 )
      TKFRAME_-94901_UNITS              = 'DEGREES'

      FRAME_MGS_RIGHT_SOLAR_ARRAY       = -94002
      FRAME_-94002_NAME                 = 'MGS_RIGHT_SOLAR_ARRAY'
      FRAME_-94002_CLASS                =  3
      FRAME_-94002_CLASS_ID             = -94002
      FRAME_-94002_CENTER               = -94
      CK_-94002_SCLK                    = -94
      CK_-94002_SPK                     = -94

      FRAME_MGS_-Y_SOLAR_ARRAY          = -94902
      FRAME_-94902_NAME                 = 'MGS_-Y_SOLAR_ARRAY'
      FRAME_-94902_CLASS                = 3
      FRAME_-94902_CLASS_ID             = -94902
      FRAME_-94902_CENTER               = -94
      CK_-94902_SCLK                    = -94
      CK_-94902_SPK                     = -94

   \begintext


MAG Sensor Frames Definitions
-----------------------------

   The +Y MAG sensor frame ("MGS_MAG_+Y_SENSOR") is rotated +90 degrees
   about the +Y axis relative to the +Y solar array yoke frame
   ("MGS_+Y_SOLAR_ARRAY").

   The -Y MAG sensor frame ("MGS_MAG_-Y_SENSOR") is first rotated -90
   degrees about the +Y axis, and then rotated +180 degrees about the
   new position of the +Z axis relative to the -Y solar array yoke
   frame ("MGS_+Y_SOLAR_ARRAY").

   Since the orientation of both MAG sensor frames is fixed with
   respect to the corresponding yoke frames, their frames are defined
   as fixed offset frames.

   The block below provides the frame definition keyword sets for the
   MAG sensor frames (note the opposite sign/order of rotations in the
   definitions because the definitions contain the transformation from
   the sensor frames to the yoke frames, see [1]):

   \begindata

      FRAME_MGS_MAG_+Y_SENSOR           = -94051
      FRAME_-94051_NAME                 = 'MGS_MAG_+Y_SENSOR'
      FRAME_-94051_CLASS                = 4
      FRAME_-94051_CLASS_ID             = -94051
      FRAME_-94051_CENTER               = -94
      TKFRAME_-94051_SPEC               = 'ANGLES'
      TKFRAME_-94051_RELATIVE           = 'MGS_+Y_SOLAR_ARRAY'
      TKFRAME_-94051_ANGLES             = ( 0.0,  -90.0, 0.0 )
      TKFRAME_-94051_AXES               = (   1,     2,   3  )
      TKFRAME_-94051_UNITS              = 'DEGREES'

      FRAME_MGS_MAG_-Y_SENSOR           = -94052
      FRAME_-94052_NAME                 = 'MGS_MAG_-Y_SENSOR'
      FRAME_-94052_CLASS                = 4
      FRAME_-94052_CLASS_ID             = -94052
      FRAME_-94052_CENTER               = -94
      TKFRAME_-94052_SPEC               = 'ANGLES'
      TKFRAME_-94052_RELATIVE           = 'MGS_-Y_SOLAR_ARRAY'
      TKFRAME_-94052_ANGLES             = (  0.0, 90.0, 180.0 )
      TKFRAME_-94052_AXES               = (  1,     2,   3  )
      TKFRAME_-94052_UNITS              = 'DEGREES'

   \begintext


ER Sensor Frame Definition
--------------------------

   The ER instrument frame ("MGS_ER") +Z axis lies in the S/C XY plane,
   10 degrees from the -X axis in the direction of the -Y axis. The ER
   frame is defined as a fixed-fixed offset frame because the sensor is
   rigidly mounted on the spacecraft bus.

   The block below provides the frame definition keyword set for the ER
   sensor frame (note the opposite sign/order of rotations in the
   definition because the definition contain the transformation from
   the sensor frame to the spacecraft frame, see [1]):

   \begindata

      FRAME_MGS_ER                      = -94053
      FRAME_-94053_NAME                 = 'MGS_ER'
      FRAME_-94053_CLASS                = 4
      FRAME_-94053_CLASS_ID             = -94053
      FRAME_-94053_CENTER               = -94
      TKFRAME_-94053_SPEC               = 'ANGLES'
      TKFRAME_-94053_RELATIVE           = 'MGS_SPACECRAFT'
      TKFRAME_-94053_ANGLES             = (  0.0,  90.0, -10.0 )
      TKFRAME_-94053_AXES               = (    3,     2,   1   )
      TKFRAME_-94053_UNITS              = 'DEGREES'

   \begintext


Antenna Frames
-------------------------------------------------------------------------------

   This section contains the definitions of the reference frames for
   the High Gain Antenna (HGA) and Low Gain Transmit (LGT) and Receive
   (LGR) antennas.

   The description and frame definitions provided in this section were
   copied from the MGS HGA FK file ([10]). In the process, only the
   description was modified; the definitions were copied ``as is.''


Antenna Description
-------------------

   The following text describes the MGS antennas:

      The MGS spacecraft is equipped with High Gain Antenna (HGA)
      and four low-gain antennas (LGA), two for transmit and two
      for receive.

      The HGA is mounted on the boom attached by a hinge to the +X
      side of the AFT deck of the spacecraft propulsion module. The
      HGA boresight direction is fixed and co-aligned with the
      spacecraft +X axis when antenna is in the stowed configuration
      (during cruise and aerobraking phases of the mission.) After
      the HGA is deployed for mapping operations, its pointing is
      achieved by rotation of the azimuth and elevation gimbals.

      Both transmitting LGAs are mounted to the TWA Enclosure Box
      which is itself mounted to the HGA reflector. One of the
      transmit LGAs (LGT1) is co-aligned with the HGA boresight
      (nominally in the +X direction while the antenna is stowed),
      while the other's (LGT2) boresight is oriented approximately
      160 degrees away from this axis (near the -X axis while the
      HGA is stowed).

      The two receive LGAs are mounted on the -X panel of the
      equipment module (LGR2) and the +X side of the propulsion
      module (LGR1).


HGA Hinge Geometry
------------------

   The following text describes the MGS HGA boom hinge:

      The MGS HGA deployment hinge is a mechanism attaching the HGA
      boom to the +X side of the AFT deck of the propulsion module.
      During transition from aerobraking to mapping, the locks
      holding antenna in stowed configuration get released and,
      driven by the spring, the hinge rotates from stowed to deployed
      position and locks in deployed position for the rest of the
      mission.

      The hinge rotation axis is parallel to the s/c Y axis. In the
      stowed configuration the antenna boom is parallel to the s/c
      Z axis. In the deployed configuration the boom is parallel to
      the s/c XZ plane and is rotated by 5 degrees from the s/c -Z axis
      towards the s/c +X axis. The full nominal deployment angle between
      stowed and deployed positions is 175 degrees.

      There is no direct measurement of the hinge deployment angle
      available in the s/c engineering telemetry after antenna is
      deployed. The deployment actual angle is planned to be estimated
      from signal strength during the initial HGA calibration tests.


HGA Gimbal Geometry
-------------------

   The following text describes the MGS HGA gimbals:

      The MGS HGA Gimbal assembly is a mechanism attaching the HGA
      reflector to the end of the HGA boom. It consists of two
      independent gimbals -- elevation (EL) and azimuth (AZ) gimbals
      -- and is used to achieve antenna pointing in deployed
      configuration. The first of them -- EL gimbal -- is attached
      to the antenna boom. The second -- AZ gimbal -- is attached
      by one side to the first gimbal with a "corner-like" fitting
      and by the opposite side to the antenna reflector.

      The EL gimbal rotation axis is parallel to the deployment
      hinge rotation axis. The AZ gimbal rotation axis is perpendicular
      to the EL gimbal rotation axis and parallel to the s/c XZ and
      the antenna reflector rim circle planes.

      The gimbals have the following hard/soft stop positions
      determining limits of the rotation ranges:

         Soft Stops:         azimuth:    -8 deg ...  +81 deg
                           elevation:  -153 deg ... +153 deg

         Hard stops:         azimuth:   -30 deg ... +190 deg
                           elevation:  -158 deg ... +158 deg

      "Zero" angle position (EL=0,AZ=0) puts the HGA boresight vector
      parallel to the -Z axis of the spacecraft.

      Other recognized antenna positions include:

         Stowed Position:    azimuth:  +180 deg
                           elevation:   -95 deg

         Initial Deployed    azimuth:     0 deg
                Position:  elevation:   -90 deg

         Park Position:      azimuth:    80 deg
                           elevation:  -120 deg

      The antenna gimbal angle values are available in the spacecraft
      engineering telemetry channels:

         F-0190 (HGA_AZ_ANG), Azimuth Angles
         F-0195 (HGA_EL_ANG), Elevation Angles

      at the s/c housekeeping medium rate i.e. once every
      32 seconds. The angle value are downlinked in radians.

      There are also three additional HGA data telemetry channels:

         F-0193 (HGA_AZ_TRG), Azimuth Targets
         F-0198 (HGA_EL_TRG), Elevation Targets
         F-0200 (HGA_STATS), HGA Status words

      the first two of which give the expected final values +-0.04
      degrees of the panels when motion is commanded and which are
      unnecessary for the computation of the gimbal rotations.

      During mapping, movement of the of the azimuth gimbal is in
      general fixed for a given orbit. For a fixed azimuth position,
      the elevation gimbal angle is varied to provide proper pointing
      throughout the orbit.


Antenna Frames Summary
----------------------

   The following MGS Antenna frames are defined in this kernel file:

           Frame Name          "Relative to" Frame    Frame Type    Frame ID
      ======================  =====================  ============   ========
      MGS_HGA_HINGE           MGS_SPACECRAFT         CK             -94070
      MGS_HGA_EL_GIMBAL       MGS_HGA_HINGE          CK             -94071
      MGS_HGA_AZ_GIMBAL       MGS_HGA_EL_GIMBAL      CK             -94072
      MGS_HGA                 MGS_HGA_AZ_GIMBAL      FIXED          -94073
      MGS_LGT1                MGS_HGA                FIXED          -94074
      MGS_LGT2                MGS_HGA                FIXED          -94075
      MGS_LGR1                MGS_SPACECRAFT         FIXED          -94076
      MGS_LGR2                MGS_SPACECRAFT         FIXED          -94077


Antenna Frames Hierarchy
------------------------

   The diagram below shows the MGS Antenna frames hierarchy:


                                  "J2000"
             +-----------------------------------------------+
             |                       |                       |
             | <--pck                |                       | <--pck
             V                       |                       V
         "IAU_MARS"                  |                  "IAU_EARTH"
         ----------                  |                  -----------
                                     |
                                     | <--ck
                                     |
                                     V
                              "MGS_SPACECRAFT"
             +-----------------------------------------------+
             |                       |                       |
             | <--fixed              | <--ck                 | <--fixed
             |                       |                       |
             V                       V                       V
         "MGS_LGR1"           "MGS_HGA_HINGE"            "MGS_LGR2"
         ----------           ---------------            ----------
                                     |
                                     | <--ck
                                     |
                                     V
                            "MGS_HGA_EL_GIMBAL"
                            -------------------
                                     |
                                     | <--ck
                                     |
                                     V
                            "MGS_HGA_AZ_GIMBAL"
                            -------------------
                                     |
                                     | <--fixed
                                     |
                                     V
                                 "MGS_HGA"
             +-----------------------------------------------+
             |                                               |
             | <--fixed                                      | <--fixed
             |                                               |
             V                                               V
         "MGS_LGT1"                                      "MGS_LGT2"
         ----------                                      ----------


HGA Frame Definitions
---------------------

   The MGS HGA deploy hinge frame is defined as follows:

      -  Z axis is along the deploy hinge rotation axis, and is
         parallel to and points in the same direction as the s/c frame
         +Y axis;

      -  X axis is perpendicular to the hinge rotation axis, parallel
         to the HGA boom central axis and points along it from the
         deploy hinge side towards the elevation gimbal side;

      -  Y axis completes the right hand frame;

      -  the origin of this frame is located at the intersection of the
         hinge rotation axis and the plane perpendicular to the rotation
         axis and containing the central axis of the boom.

   The MGS HGA elevation gimbal frame is defined as follows:

      -  Z axis is along the elevation gimbal rotation axis and points
         from the HGA boom side towards the azimuth gimbal side;

      -  X axis is perpendicular to the elevation gimbal rotation axis,
         parallel to the azimuth gimbal rotation axis and points from
         the elevation gimbal side towards the HGA reflector mounting
         side;

      -  Y axis completes the right hand frame;

      -  the origin of this frame is located at the intersection of the
         elevation gimbal rotation axis and the plane perpendicular to
         this rotation axis and containing the azimuth gimbal rotation
         axis.

   The MGS HGA azimuth gimbal frame is defined as follows:

      -  Z axis is along the azimuth gimbal rotation axis and points
         from the elevation gimbal side towards the HGA reflector
         mounting side;

      -  X axis is perpendicular to the azimuth gimbal rotation axis,
         parallel to the plane containing the HGA reflector rim circle
         and points from the azimuth gimbal towards the HGA rim circle
         center;

      -  Y axis completes the right hand frame;

      -  the origin of this frame is located at the intersection of the
         azimuth gimbal rotation axis and the plane perpendicular to
         this rotation axis and containing the HGA reflector central
         symmetry axis (boresight axis).

   The MGS HGA boresight frame is defined as follows:

      -  Z axis is along the HGA reflector central symmetry axis
         (boresight axis) and points from the reflector surface towards
         the feed horn;

      -  X axis is perpendicular to the boresight direction,
         perpendicular to azimuth gimbal rotation axis and points from
         the antenna symmetry axis towards the side of the reflector to
         which the azimuth gimbal is attached;

      -  Y axis completes the right hand frame;

      -  the origin of this frame is located at the intersection of the
         antenna reflector symmetry axis and the plane containing HGA
         reflector rim circle.

   The diagram below illustrates the HGA hinge/gimbal/boresight frames
   (the antenna is shown in the configuration when the boom is fully
   extended along the s/c +X axis, the elevation and azimuth gimbal
   axes are in the s/c plane, and the antenna boresight points along
   the s/c +Z axis):

   Top view (+Zsc view):
   ---------------------
                                            * * * * *
                                         *             *
                                       *                 *
                                      *                   *
                                     *                     *
                                    *                       *
                                    *                       *
                                    *       +Zb o----> +Yb  *
                                    *           |           *
                                    *           |           *
                                    *           v +Xb       *
                                     *                     *
                                      *         ^         *       ^ +Zel
                                        *       |+Xaz   *____     |
                                          *     |    __|     |____|_
                                           <----x__*___| +Xel<----o|+Yel
                                       +Zaz   +Yaz     |_____|   | |
                                                     azimuth    _|_|_
            ____________   +Zh                       gimbal    |     | elev.
                        | ^                                    |     | gimbal
           +Ysc         |_|__                                  |_____|
              ^        +Yh|  |___________________________________| |
              |        |  x---->___________________________________|
              |  +Xsc  |_____|  +Xh
              o---->    | deployment
            +Zsc        |   hinge
                        |
                        |
                        |
            ____________|


   Side view (-Ysc view):
   ----------------------

                                                 ^ +Zb
                                                 |
                        |                        |     +Yb
                        |             ___________o---->______   +Yel
                        |             \__         +Xb     __/     ^
                        |___             \__           __/____   _|_
                        /+Zh\_______________\__+Xaz __/_|     |_/ | \
           ____________|  x---->____________<----x______| +Xel<---x +Zel
              ^+Zsc     \_|_/  +Xh        +Zaz   |      |_____| \___/
              |   \       |                      |
              |   +Xsc    V +Yh                  v +Yaz
           ___x--->_\
            +Ysc


   On the diagram:

      +Xsc,+Ysc,+Zsc -- axes of the s/c frame;
      +Xh, +Yh, +Zh  -- axes of the hinge frame;
      +Xel,+Yel,+Zel -- axes of the elevation gimbal frame;
      +Xaz,+Yaz,+Zaz -- axes of the azimuth gimbal frame;
      +Xb, +Yb, +Zb  -- axes of the HGA boresight frame;

      "o" shows axes pointing "out of the page", "x" shows axes
      pointing "into the page"

   As follows from the definition, the HGA boresight frame is rotated
   from the azimuth gimbal frame by two rotations -- first by +90
   degrees about the +X axis and second by +180 degrees about the +Z
   axis.

   The block below provides the frame definition keyword sets for the
   HGA hinge/gimbal/boresight frames (note the opposite sign/order of
   rotations in the MGS_HGA definition because the definition contains
   the transformation from the antenna to the reference frame, see
   [1]):

   \begindata

      FRAME_MGS_HGA_HINGE        = -94070
      FRAME_-94070_NAME          = 'MGS_HGA_HINGE'
      FRAME_-94070_CLASS         = 3
      FRAME_-94070_CLASS_ID      = -94070
      FRAME_-94070_CENTER        = -94
      CK_-94070_SCLK             = -94
      CK_-94070_SPK              = -94

      FRAME_MGS_HGA_EL_GIMBAL    = -94071
      FRAME_-94071_NAME          = 'MGS_HGA_EL_GIMBAL'
      FRAME_-94071_CLASS         = 3
      FRAME_-94071_CLASS_ID      = -94071
      FRAME_-94071_CENTER        = -94
      CK_-94071_SCLK             = -94
      CK_-94071_SPK              = -94

      FRAME_MGS_HGA_AZ_GIMBAL    = -94072
      FRAME_-94072_NAME          = 'MGS_HGA_AZ_GIMBAL'
      FRAME_-94072_CLASS         = 3
      FRAME_-94072_CLASS_ID      = -94072
      FRAME_-94072_CENTER        = -94
      CK_-94072_SCLK             = -94
      CK_-94072_SPK              = -94

      FRAME_MGS_HGA              = -94073
      FRAME_-94073_NAME          = 'MGS_HGA'
      FRAME_-94073_CLASS         = 4
      FRAME_-94073_CLASS_ID      = -94073
      FRAME_-94073_CENTER        = -94
      TKFRAME_-94073_SPEC        = 'ANGLES'
      TKFRAME_-94073_RELATIVE    = 'MGS_HGA_AZ_GIMBAL'
      TKFRAME_-94073_ANGLES      = ( -90.0, 0.0, 180.0 )
      TKFRAME_-94073_AXES        = (   1,   2,     3   )
      TKFRAME_-94073_UNITS       = 'DEGREES'

   \begintext


Transmit LGA Frame Definitions
------------------------------

   The MGS LGT1 boresight frame is defined as follows:

      -  Z axis is perpendicular to the antenna "patch" surface and
         points away from its surface;

      -  X axis is parallel to the line connecting the "patch" center
         with the "patch" corner farthest from both antenna connectors
         attached to the bottom side of the patch and points from the
         center towards the corner;

      -  Y axis completes the right hand frame;

      -  the origin of this frame is located at the geometric center of
         the antenna "patch" square.

   The MGS LGT2 boresight frame is defined as follows:

      -  Z axis is perpendicular to the antenna "patch" surface and
         points away from the surface;

      -  X axis is parallel to the line connecting the "patch" center with
         the "patch" corner farthest from both antenna connectors attached
         to the bottom side of the patch and points from the center towards
         the corner;

      -  Y axis completes the right hand frame;

      -  the origin of this frame is located at the geometric center of
         the antenna "patch" square.

   As follows from the definitions, the LGT1 frame is rotated from the
   HGA boresight frame by +214 degrees about the +Z axis (34 degrees
   due to the TWA box mounting on the HGA reflector plus 180 degrees
   due to the "patch" orientation with respect to the bracket of which
   it is mounted.) The LGT2 frame is first rotated +34 degrees about
   the +Z axis (due to the TWA box mounting on the HGA reflector),
   after that it is rotated by -130.88 degrees about the new direction
   of +Y axis and at last it is rotated -10.4 degrees about the new
   direction of +X axis (last two rotations are due to the
   "sophisticated" geometry of the lower LGT2 mounting bracket.)

   The block below provides the frame definition keyword sets for the
   LGT1 and LGT2 frames, which incorporate these rotations (note the
   opposite sign/order of rotations because the definitions contains
   the transformations from the antenna to the reference frame, see
   [1]):

   \begindata

      FRAME_MGS_LGT1             = -94074
      FRAME_-94074_NAME          = 'MGS_LGT1'
      FRAME_-94074_CLASS         = 4
      FRAME_-94074_CLASS_ID      = -94074
      FRAME_-94074_CENTER        = -94
      TKFRAME_-94074_SPEC        = 'ANGLES'
      TKFRAME_-94074_RELATIVE    = 'MGS_HGA'
      TKFRAME_-94074_ANGLES      = ( -214.0, 0.0, 0.0 )
      TKFRAME_-94074_AXES        = (    3,   2,   1   )
      TKFRAME_-94074_UNITS       = 'DEGREES'

      FRAME_MGS_LGT2             = -94075
      FRAME_-94075_NAME          = 'MGS_LGT2'
      FRAME_-94075_CLASS         = 4
      FRAME_-94075_CLASS_ID      = -94075
      FRAME_-94075_CENTER        = -94
      TKFRAME_-94075_SPEC        = 'ANGLES'
      TKFRAME_-94075_RELATIVE    = 'MGS_HGA'
      TKFRAME_-94075_ANGLES      = ( -34.0, 130.0,  10.4 )
      TKFRAME_-94075_AXES        = (   3,     2,     1   )
      TKFRAME_-94075_UNITS       = 'DEGREES'

   \begintext


Receive LGA Frame Definitions
-----------------------------

   The MGS LGR1 boresight frame is defined as follows:

      -  Z axis is perpendicular to the antenna "patch" surface, and is
         parallel and points in the same direction as the s/c +X axis;

      -  Y axis is parallel to and points in the same direction as the
         s/c +Y axis;

      -  X axis completes the right hand frame;

      -  the origin of this frame is located at the geometric center of
         the antenna "patch" square.

   The MGS LGR2 boresight frame is defined as follows:

      -  Z axis is perpendicular to the antenna "patch" surface, and is
         parallel and points in the same direction as the s/c -X axis;

      -  Y axis is parallel to and points in the same direction as the
         s/c +Y axis;

      -  X axis completes the right hand frame;

      -  the origin of this frame is located at the geometric center of
         the antenna "patch" square.

   As follows from the definitions, the LGR1 frame is rotated from the
   spacecraft frame by +90 degrees about the +Y axis and the LRG2 frame
   is rotated from the spacecraft frame by -90 degrees about the +Y
   axis.

   The diagram below illustrates the LGR1 and LGR2 frames:

   Side View (-Ysc):
   -----------------
                          LGT2 ____  LGT1
                            @=|    |=@
                              |    |_
                              |__ /  |
                  ___________    /   |
          +Xlgr2 |           |  /    |
               ^ |           | /     |
               | |           ||      |
    +Zlgr2     | |           ||      | HGA
          <----x=|           ||      |
           +Ylgr2|___________| \     |
                 |           |  \    |
                 |           |   \   |
                 |           |    \__|
                 |           |
                 |          +Ylgr1
                 |           |=x---->
                 |___________| |     +Zlgr1
                    +Zsc \     |
                    /  ^  \    v
                   /   |   \    +Xlgr1
                  /    |    \
                 /_____x---->
                    +Ysc   +Xsc

   On the diagram:

      +Xsc,   +Ysc,   +Zsc    -- axes of the s/c frame;
      +Xlgr1, +Ylgr1, +Zlgr1  -- axes of the LGR1 frame;
      +Xlgr2, +Ylgr2, +Zlgr2  -- axes of the LGR2 frame;

      "x" shows axes pointing "into the page"

   The block below provides the frame definition keyword sets for the
   LGR1 and LGR2 frames, which incorporate these rotations (note the
   opposite sign/order of rotations because the definitions contains
   the transformation from the antenna to the reference frame, see
   [1]):

   \begindata

      FRAME_MGS_LGR1             = -94076
      FRAME_-94076_NAME          = 'MGS_LGR1'
      FRAME_-94076_CLASS         = 4
      FRAME_-94076_CLASS_ID      = -94076
      FRAME_-94076_CENTER        = -94
      TKFRAME_-94076_SPEC        = 'ANGLES'
      TKFRAME_-94076_RELATIVE    = 'MGS_SPACECRAFT'
      TKFRAME_-94076_ANGLES      = ( 0.0, -90.0, 0.0 )
      TKFRAME_-94076_AXES        = (   3,     2,   1 )
      TKFRAME_-94076_UNITS       = 'DEGREES'

      FRAME_MGS_LGR2             = -94077
      FRAME_-94077_NAME          = 'MGS_LGR2'
      FRAME_-94077_CLASS         = 4
      FRAME_-94077_CLASS_ID      = -94077
      FRAME_-94077_CENTER        = -94
      TKFRAME_-94077_SPEC        = 'ANGLES'
      TKFRAME_-94077_RELATIVE    = 'MGS_SPACECRAFT'
      TKFRAME_-94077_ANGLES      = ( 0.0, 90.0, 0.0 )
      TKFRAME_-94077_AXES        = (   3,    2,   1 )
      TKFRAME_-94077_UNITS       = 'DEGREES'

   \begintext


Mars Global Surveyor NAIF ID Codes Definitions
-------------------------------------------------------------------------------

   This section contains name - to - NAIF ID mappings for the MGS
   mission. Once the contents of this file is loaded into the KERNEL
   POOL, these mappings become available within SPICE, making it
   possible to use these names in the high level SPICE routine calls.

   Spacecraft:
   -----------

      MARS GLOBAL SURVEYOR          -94
      MGS                           -94
      MGS_SPACECRAFT_BUS            -94000
      MGS_SC_BUS                    -94000
      MGS_SPACECRAFT                -94000

   Science Instruments:
   --------------------

      MGS_TES                       -94010

      MGS_MHSA                      -94020
      MGS_MHSA_D1                   -94021
      MGS_MHSA_D2                   -94022
      MGS_MHSA_D3                   -94023
      MGS_MHSA_D4                   -94024

      MGS_MOC                       -94030
      MGS_MOC_NA                    -94031
      MGS_MOC_WA_RED                -94032
      MGS_MOC_WA_BLUE               -94033

      MGS_MOLA                      -94040

      MGS_MAG_+Y_SENSOR             -94051
      MGS_MAG_-Y_SENSOR             -94052
      MGS_ER                        -94053

   Antennas:
   ---------

      MGS_HGA_HINGE                 -94070
      MGS_HGA_EL_GIMBAL             -94071
      MGS_HGA_AZ_GIMBAL             -94072
      MGS_HGA                       -94073
      MGS_HGA_PHASE_CENTER          -94078
      MGS_LGT1                      -94074
      MGS_LGT2                      -94075
      MGS_LGR1                      -94076
      MGS_LGR2                      -94077

   Solar Arrays:
   -------------

      MGS_+Y_GIMBAL                 -94001
      MGS_-Y_GIMBAL                 -94002
      MGS_+Y_YOKE                   -94901
      MGS_-Y_YOKE                   -94902


   The mappings summarized in this table are implemented by the keywords
   below.

   \begindata

      NAIF_BODY_NAME += ( 'MARS GLOBAL SURVEYOR' )
      NAIF_BODY_CODE += ( -94                    )

      NAIF_BODY_NAME += ( 'MGS'                  )
      NAIF_BODY_CODE += ( -94                    )

      NAIF_BODY_NAME += ( 'MGS_SPACECRAFT_BUS'   )
      NAIF_BODY_CODE += ( -94000                 )

      NAIF_BODY_NAME += ( 'MGS_SC_BUS'           )
      NAIF_BODY_CODE += ( -94000                 )

      NAIF_BODY_NAME += ( 'MGS_SPACECRAFT'       )
      NAIF_BODY_CODE += ( -94000                 )

      NAIF_BODY_NAME += ( 'MGS_TES'              )
      NAIF_BODY_CODE += ( -94010                 )

      NAIF_BODY_NAME += ( 'MGS_MHSA'             )
      NAIF_BODY_CODE += ( -94020                 )

      NAIF_BODY_NAME += ( 'MGS_MHSA_D1'          )
      NAIF_BODY_CODE += ( -94021                 )

      NAIF_BODY_NAME += ( 'MGS_MHSA_D2'          )
      NAIF_BODY_CODE += ( -94022                 )

      NAIF_BODY_NAME += ( 'MGS_MHSA_D3'          )
      NAIF_BODY_CODE += ( -94023                 )

      NAIF_BODY_NAME += ( 'MGS_MHSA_D4'          )
      NAIF_BODY_CODE += ( -94024                 )

      NAIF_BODY_NAME += ( 'MGS_MOC'              )
      NAIF_BODY_CODE += ( -94030                 )

      NAIF_BODY_NAME += ( 'MGS_MOC_NA'           )
      NAIF_BODY_CODE += ( -94031                 )

      NAIF_BODY_NAME += ( 'MGS_MOC_WA_RED'       )
      NAIF_BODY_CODE += ( -94032                 )

      NAIF_BODY_NAME += ( 'MGS_MOC_WA_BLUE'      )
      NAIF_BODY_CODE += ( -94033                 )

      NAIF_BODY_NAME += ( 'MGS_MOLA'             )
      NAIF_BODY_CODE += ( -94040                 )

      NAIF_BODY_NAME += ( 'MGS_MAG_+Y_SENSOR'    )
      NAIF_BODY_CODE += ( -94051                 )

      NAIF_BODY_NAME += ( 'MGS_MAG_-Y_SENSOR'    )
      NAIF_BODY_CODE += ( -94052                 )

      NAIF_BODY_NAME += ( 'MGS_ER'               )
      NAIF_BODY_CODE += ( -94053                 )

      NAIF_BODY_NAME += ( 'MGS_HGA_HINGE'        )
      NAIF_BODY_CODE += ( -94070 )

      NAIF_BODY_NAME += ( 'MGS_HGA_EL_GIMBAL'    )
      NAIF_BODY_CODE += ( -94071                 )

      NAIF_BODY_NAME += ( 'MGS_HGA_AZ_GIMBAL'    )
      NAIF_BODY_CODE += ( -94072                 )

      NAIF_BODY_NAME += ( 'MGS_HGA'              )
      NAIF_BODY_CODE += ( -94073                 )

      NAIF_BODY_NAME += ( 'MGS_HGA_PHASE_CENTER' )
      NAIF_BODY_CODE += ( -94078                 )

      NAIF_BODY_NAME += ( 'MGS_LGT1'             )
      NAIF_BODY_CODE += ( -94074                 )

      NAIF_BODY_NAME += ( 'MGS_LGT2'             )
      NAIF_BODY_CODE += ( -94075                 )

      NAIF_BODY_NAME += ( 'MGS_LGR1'             )
      NAIF_BODY_CODE += ( -94076                 )

      NAIF_BODY_NAME += ( 'MGS_LGR2'             )
      NAIF_BODY_CODE += ( -94077                 )

      NAIF_BODY_NAME += ( 'MGS_+Y_GIMBAL'        )
      NAIF_BODY_CODE += ( -94001                 )

      NAIF_BODY_NAME += ( 'MGS_-Y_GIMBAL'        )
      NAIF_BODY_CODE += ( -94002                 )

      NAIF_BODY_NAME += ( 'MGS_+Y_YOKE'          )
      NAIF_BODY_CODE += ( -94901                 )

      NAIF_BODY_NAME += ( 'MGS_-Y_YOKE'          )
      NAIF_BODY_CODE += ( -94902                 )

   \begintext
