KPL/FK


Deep Space One Frame Definitions Kernel
================================================================================

   This frame kernel contains the Deep Space One (DS-1) spacecraft, science
   instrument, communication antenna and solar array frame definitions.


Version and Date
--------------------------------------------------------

   Version 7.0 -- September 21, 2001 -- Boris Semenov

      Added comet Borrelly body fixed frame definition.

   Version 6.2 -- July 21, 1999 -- Boris Semenov

      Orientation of the DS1_MICAS_IR and DS1_MICAS_UV was changed -- both 
      frames were rotated by -90 degrees about boresight (+Z) to align 
      increasing slit pixel direction with +Y axis direction.
      
   Version 6.1 -- July 17, 1999 -- Boris Semenov

      Removed DS1_MICAS frame. Re-defined CCD and APS frames to be relative
      to the DS1 spacecraft. Updated CCD and APS frame orientation based on 
      the latest calibration data from DS1 OPNAV team.
      
   Version 6.0 -- July 8, 1999 -- Boris Semenov

      Added 1992 KD body fixed frame definition.

   Version 5.1 -- June 12, 1999 -- Boris Semenov

      Updated APS frame orientation based on preliminary processing of the APS
      images taken on May 23, 1999.

   Version 5.0 -- June 8, 1999 -- Boris Semenov

      Added solar array frame definitions. Reset all frame centers to be -30.

   Version 4.1 -- June 1, 1999 -- Boris Semenov

      Corrected comments.

   Version 4.0 -- May 23, 1999 -- Boris Semenov

      Added PEPE frame definition.

   Version 3.0 -- May 17, 1999 -- Boris Semenov

      Added frame definitions for MICAS ASP, UV and IR detectors.

   Version 2.1 -- April 23, 1999 -- Boris Semenov

      Changed file type architecture string.

   Version 2.0 -- March 10, 1999 -- Boris Semenov

      Added MICAS and PEPE instrument frames.

   Version 1.0 -- November 25, 1997 -- Jeff Bytof

      Initial Release.


References
--------------------------------------------------------

   1. Kevin Tong and Ramona Tung provided the antenna pointing information,
      November 21 and 26, 1997.

   2. ``C-kernel Required Reading''

   3. ``Kernel Pool Required Reading''

   4. ``Frames Required Reading''

   5. Note regarding in-light calibrated MICAS mounting alignment angles
      by Shyam Bhaskaran, DS-1 OPNAV team, February 19, 1999

   6. MICAS Web pages (http://bubbles.jpl.nasa.gov/MICAS) published by
      Memong Lee, JPL; May 1999.

   7. Pre-flight detector FOV relative geometry data provided by David
      Thomas, JPL; May 1999.
      
   8. DS1 Coordinate Systems, Vectors and Phasing Definitions, Ver 2.0,
      19 September 1997, by Douglas W. Caldwell.


Contact Information
-------------------------------------------------------------------------------

   Jeff A. Bytof,    NAIF/JPL, (818)-354-8136, jbytof@spice.jpl.nasa.gov
   Boris V. Semenov, NAIF/JPL, (818)-354-8136, bsemenov@spice.jpl.nasa.gov


Implementation Notes
--------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must `load' the kernel, normally during program
   initialization. Loading the kernel associates data items with their
   names in a data structure called the `kernel pool'. The SPICELIB
   routine LDPOOL loads a kernel file into the pool as shown below.


      CALL LDPOOL ( frame_kernel_name )


   In order for a program or subroutine to extract data from the pool,
   the SPICELIB routines GDPOOL and GIPOOL are used. See [3] for more details.

   This file was created and may be updated with a text editor or word
   processor.


DS1 Frames
-------------------------------------------------------------------------------

   The following DS1 frames are defined in this kernel file:

        Frame Name                    Relative to              Type    NAIF ID
   =========================     =========================    =======   =======

   Asteroid 1992 KD frame (2009969):
   ---------------------------------
      1992KD_FIXED               rel.to J2000                  PCK      2009969

   Comet Borrelly frame (1000005):
   -------------------------------
      BORRELLY_FIXED             rel.to J2000                  PCK      1000005

   Spacecraft Bus Frame:
   ---------------------
      DS1_SC_BUS                 rel.to J2000                  CK       -30000

   MICAS Frame(s) (-3001x):
   ------------------------
      DS1_MICAS_CCD              rel.to SC_BUS                 FIXED    -30011
      DS1_MICAS_APS              rel.to SC_BUS                 FIXED    -30012
      DS1_MICAS_UV               rel.to MICAS_CCD              FIXED    -30013
      DS1_MICAS_IR               rel.to MICAS_CCD              FIXED    -30014

   PEPE Frame(s) (-3002x):
   -----------------------
      DS1_PEPE                   rel.to SC_BUS                 FIXED    -30020

   Antenna Frame(s) (-301xx):
   --------------------------
      DS1_HGA                    rel.to SC_BUS                 FIXED    -30101
      DS1_LGA+X                  rel.to SC_BUS                 FIXED    -30102
      DS1_LGA+Z                  rel.to SC_BUS                 FIXED    -30103
      DS1_LGA-Z                  rel.to SC_BUS                 FIXED    -30104
      DS1_KA                     rel.to SC_BUS                 FIXED    -30105

   Solar Array Frame(s) (-302xx):
   ------------------------------
      DS1_SA1                    rel.to SC_BUS                 CK       -30201
      DS1_SA2                    rel.to SC_BUS                 CK       -30202


DS1 Frames Hierarchy
-------------------------------------------------------------------------------

   The diagram below shows DS1 frames hierarchy:


                               "J2000" INERTIAL
               +-----------------------------------------------+
               |             |                |                |
               | <--ck       | <--pck         | <--pck         | <--pck
               |             |                |                |
               |             V                V                V
               |      "BORRELLY_FIXED"   "1992KD_FIXED"    "IAU_EARTH"
               |        COMET BFR(*)     ASTEROID BFR(*)   EARTH BFR(*)
               |      ----------------   ---------------   ------------
               |
               |
               |         "DS1_PEPE"            "DS1_SA1"   "DS1_SA2"
               |         ----------            ---------   ---------
               |             ^                     ^          ^
               |             |                     |          |
               V             | <--fixed            | <--ck    | <--ck
          "DS1_SC_BUS"       |                     |          |
       +-----------------------------------------------------------------+
       |          |          |          |          |          |          |
       |<--fixed  |<--fixed  |          |  fixed-->|  fixed-->|  fixed-->|
       |          |          |          |          |          |          |
       |          |          |          |          |          |          |
       |          |          |          |          |          |          |
       |          |          |          |          |          |          |
       |          |          |          |          |          |          |
       V          V          |          |          V          V          V
    "DS1_HGA"  "DS1_LGA+X"   |          |     "DS1_LGA+Z"  "DS1_LGA-Z"  "DS1_KA"
    ---------  -----------   |          |     -----------  -----------  --------
                             |          |
                             |          |
                     fixed-->|          |<--fixed
                             |          |
                             V          V
                  "DS1_MICAS_APS"     "DS1_MICAS_CCD"
                  ---------------   +----------------+
                                    |                |
                                    |<--fixed        |<--fixed
                                    |                |
                                    V                V
                              "DS1_MICAS_UV"   "DS1_MICAS_IR"
                              --------------   --------------


Comet Borrelly body-fixed frame
--------------------------------------------------------

   The Borrelly fixed frame is defined in the same as any other PCK frame:
   
      *  +Z along comet's North pole;
      
      *  +X along comet's prime meridian;
      
      *  +Y completes the right hand frame;
      
      *  the origin of this frame is at the center of the comet ellipsoid.
      
   As for any PCK frame orientation of this frame is computed by evaluating 
   corresponding rotation constants provided in a PCK file.

   \begindata

      FRAME_BORRELLY_FIXED   =  1000005
      FRAME_1000005_NAME     = 'BORRELLY_FIXED'
      FRAME_1000005_CLASS    =  2
      FRAME_1000005_CLASS_ID =  1000005
      FRAME_1000005_CENTER   =  1000005

      OBJECT_1000005_FRAME   = 'BORRELLY_FIXED'

   \begintext


Asteroid 1992 KD body-fixed frame
--------------------------------------------------------

   The 1992 KD fixed is defined in the same as any other PCK frame:
   
      *  +Z along asteroid's North pole;
      
      *  +X along asteroid's prime meridian;
      
      *  +Y complements to the right hand frame;
      
      *  the origin of this frame is at the center of the asteroid ellipsoid.
      
   As for any PCK frame orientation of this frame is computed by evaluating 
   corresponding rotation constants provided in a PCK file.

   \begindata

      FRAME_1992KD_FIXED     =  2009969
      FRAME_2009969_NAME     = '1992KD_FIXED'
      FRAME_2009969_CLASS    =  2
      FRAME_2009969_CLASS_ID =  2009969
      FRAME_2009969_CENTER   =  2009969

      OBJECT_2009969_FRAME   = '1992KD_FIXED'

   \begintext


Spacecraft Bus Frame
--------------------------------------------------------

   The spacecraft bus frame is defined by the spacecraft design as follows:

      *  +Z axis is along the central axis of the spacecraft "cylinder"
         equipment module and points from the ion engine side of the module
         towards the power processing unit side;

      *  +X is perpendicular to a plane containing +Z axis and solar array
         gimbal rotation axis and points from the MICAS side of the equipment
         module towards the HGA side of the equipment module (i.e. in the HGA
         pointing direction;

      *  +Y complements to the right hand frame;

      *  the origin of this frame is at TBD;

   Spacecraft bus attitude with respect to an inertial frame is provided by
   a C kernel (see [2] for more information).

   \begindata

      FRAME_DS1_SC_BUS         = -30000
      FRAME_-30000_NAME        = 'DS1_SC_BUS'
      FRAME_-30000_CLASS       = 3
      FRAME_-30000_CLASS_ID    = -30000
      FRAME_-30000_CENTER      = -30
      CK_-30000_SCLK           = -30
      CK_-30000_SPK            = -30

   \begintext


Miniature Integrated Camera Spectrometer (MICAS) Frames
--------------------------------------------------------

   The MICAS instrument is mounted in on the -X side of the spacecraft equipment
   module and the MICAS optical axis is nominally pointed in the direction of
   the spacecraft +Z axis.

MICAS CCD Frame

   The MICAS CCD frame is defined by the instrument design as follows:

      *  +Z axis is along the 10 cm telescope optical axis;

      *  +Y is perpendicular to the instrument mounting side and points from
         the mounting side (bottom) toward the opposite side (top); the +Y axis
         is nominally parallel to the direction of the the columns in an
         instrument image taken by CCD detector;

      *  +X complements to the right hand frame; it is nominally parallel to
         the direction of the rows in an instrument image taken by CCD detector;

      *  the origin of this frame is at TBD;

   The MICAS CCD frame is nominally rotated +90 degrees about +Z axis from
   the spacecraft frame.

   The actual orientation of the frame with respect to the spacecraft bus was
   computed by DS1 OPNAV team (see [5]) from series of in-flight calibration
   images taken by the camera after launch. In accordance with these data, the
   MICAS CCD frame is rotated from the spacecraft frame first by -0.032021
   degrees about the spacecraft +Y axis, then by -0.036668 degrees about new
   position of the +X axis and, at last, by +89.449 degrees about new position
   of the +Z axis. Given that, a matrix rotating vectors from the spacecraft
   frame to the MICAS CCD/optics frame can be constructed as follows:


      [     ]   [         ]  [           ]  [           ]
      [  M  ] = [ +89.449 ]  [ -0.036668 ]  [ -0.032021 ]
      [     ]   [         ]  [           ]  [           ]
                           Z              X              Y

   where [x]i represent rotation by a given angle a about a given axis i.

   The DS1_MICAS_CCD frame definition below contains the actual orientation.

   \begindata

      FRAME_DS1_MICAS_CCD      = -30011
      FRAME_-30011_NAME        = 'DS1_MICAS_CCD'
      FRAME_-30011_CLASS       = 4
      FRAME_-30011_CLASS_ID    = -30011
      FRAME_-30011_CENTER      = -30
      TKFRAME_-30011_SPEC      = 'ANGLES'
      TKFRAME_-30011_RELATIVE  = 'DS1_SC_BUS'
      TKFRAME_-30011_ANGLES    = ( 0.032021, 0.036668, -89.449 )
      TKFRAME_-30011_AXES      = ( 2,        1,          3     )
      TKFRAME_-30011_UNITS     = 'DEGREES'

   \begintext


MICAS APS Frame

   The MICAS APS frame is defined by the instrument design as follows:

      *  +Z axis is along the 10 cm telescope optical axis;

      *  +Y is perpendicular to the instrument mounting side and points from
         the mounting side (bottom) toward the opposite side (top); the +Y axis
         is nominally parallel to the direction of the the columns in an
         instrument image taken by APS detector;

      *  +X complements to the right hand frame; it is nominally parallel to
         the direction of the rows in an instrument image taken by APS detector;

      *  the origin of this frame is at TBD;

   The MICAS APS frame is nominally rotated +90 degrees about +Z axis from
   the spacecraft frame.

   The actual orientation of the frame with respect to the spacecraft bus was
   computed by DS1 OPNAV team (see [5]) from series of in-flight calibration
   images taken by the camera after launch. In accordance with these data, the
   MICAS APS frame is rotated from the spacecraft frame first by +0.0281
   degrees about the spacecraft +Y axis, then by -0.0301 degrees about new
   position of the +X axis and, at last, by +89.993 degrees about new position
   of the +Z axis. Given that, a matrix rotating vectors from the spacecraft
   frame to the MICAS APS/optics frame can be constructed as follows:


      [     ]   [         ]  [         ]  [         ]
      [  M  ] = [ +89.993 ]  [ -0.0301 ]  [ +0.0281 ]
      [     ]   [         ]  [         ]  [         ]
                           Z            X            Y

   where [x]i represent rotation by a given angle a about a given axis i.

   The DS1_MICAS_APS frame definition below contains the actual orientation.

   \begindata

      FRAME_DS1_MICAS_APS      = -30012
      FRAME_-30012_NAME        = 'DS1_MICAS_APS'
      FRAME_-30012_CLASS       = 4
      FRAME_-30012_CLASS_ID    = -30012
      FRAME_-30012_CENTER      = -30
      TKFRAME_-30012_SPEC      = 'ANGLES'
      TKFRAME_-30012_RELATIVE  = 'DS1_SC_BUS'
      TKFRAME_-30012_ANGLES    = ( -0.0281, 0.0301, -89.993 )
      TKFRAME_-30012_AXES      = (  2,      1,        3     )
      TKFRAME_-30012_UNITS     = 'DEGREES'

   \begintext
   

MICAS UV and IR Frames

   The orientation of two other detectors -- UV and IR -- can be
   defined with respect to CCD Frame based on the result of pre-flight
   calibrations.

   The diagrams below obtained from [6] and [7] illustrate MICAS detector FOV
   nominal and actual (as measured on the ground before launch) relative
   angular positions.


   Nominal Angular Relative FOV Position (in degrees):
   ---------------------------------------------------

                                          Rotation            negative
                                          direction:        ^ about Yccd
                                                            ^
           Zsc                                              ^       positive
            x----->                                   < < <   > > > about Xccd
            |    Xsc                            negative    v
            |                                   about Xccd  v
        Ysc V                                               v positive
                                                              about Yccd
                                                              

           Zuv    Xuv         Zccd            Zaps                Zir      
            x----->      <-----x         <-----x                   x----->      
            |          Yccd    |       Yaps    |                   |     Xir  
            |                  |               |                   |       
        Yuv V                  V Xccd          V Xaps              V Yir  

                   ____________________________________
                  |CCD(1,1)                            |         ____
           ____   |...|                                |        |    |
          |    |  |...|                                |        | IR |
          | UV |  |...|                                |        |____|
          |____|  |...|       _____________            |          ||
            ||    |...|      |     APS(1,1)|           |          ||
            ||    |...|      |             |           |          ||
            ||    |...|      |      |      |           |          ||
       UV --o-- ----------------- --o-- ----------------------- --o-- IR
      center||    |...|      |      |      |           |          ||center
            ||    |...|      | CCD/APS cen.|           |          ||
            ||    |...|      |_____________|           |          ||
            ||    |...|                                |          ||
            ||    |...|             |                  |          ||
            ||    |...|             |                  |          ||
            ||    |...|             |                  |          ||
            |     |___|_____________|__________________|          |
            |                       |                             |
            |            0.6        |           0.75              |
            |<--------------------->|<--------------------------->|
            |                       |                             |


   Nominal rotational offsets between CCD, APS, UV and IR boresights (centers)
   about +X and +Y of the CCD frame (based on [6] and [7]):

                                nominal          nominal
                           offset rotation   offset rotation
                           about Xccd, deg   about Yccd, deg
                           ---------------   ---------------

               CCD-to-APS        0.0               0.0

               CCD-to-IR        +0.75              0.0

               CCD-to-UV        -0.60              0.0


   Pre-launch Actual Angular Relative FOV Position (in degrees):
   -------------------------------------------------------------

                                          Rotation            negative
                                          direction:        ^ about Yccd
                                                            ^
           Zsc                                              ^       positive
            x----->                                   < < <   > > > about Xccd
            |    Xsc                            negative    v
            |                                   about Xccd  v
        Ysc V                                               v positive
                                                              about Yccd
                                                              

           Zuv    Xuv         Zccd            Zaps                Zir      
            x----->      <-----x         <-----x                   x----->      
            |          Yccd    |       Yaps    |                   |     Xir  
            |                  |               |                   |       
        Yuv V                  V Xccd          V Xaps              V Yir  

                   ____________________________________
          ____    |CCD(1,1)                            |
         |    |   |...|                                |         ____
         | UV |   |...|                                |        |    |
         |____|   |...|         _____________          |        | IR |
           ||     |...|        |     APS(1,1)|         |        |____|
           ||  |  |...|        |             |  |      |          ||
           ||  v  |...|        |      |APS   |  v      |      |   ||
      UV --o- --- |...|        |    |-o-- ---------    |      v   ||
   center  || ------------------- --o-| ------------------------  ||
           ||  ^  |...|        | CCD|        |  ^      |     --- -o-- IR
           ||  |  |...|        |____|________|  |      |      ^   ||center
           || 0.05|...|             |          0.01    |      |   ||
           ||     |...|             | | 0.08           |     0.02 ||
           ||     |...|         --->|-|<----           |          ||
           ||     |...|             |                  |          ||
                  |...|             |                  |          ||
                  |___|_____________|__________________|          ||
                                    |
           |             0.61       |           0.65              |
           |<---------------------->|<--------------------------->|
           |                        |                             |

   Actual rotational offsets between CCD, APS, UV and IR boresights (centers)
   about +X and +Y of the CCD frame:

                                actual          actual
                           offset rotation   offset rotation
                           about Xccd, deg   about Yccd, deg
                           ---------------   ---------------

               CCD-to-APS       +0.08             -0.01

               CCD-to-IR        +0.65             +0.02

               CCD-to-UV        -0.61             -0.05

   These values were derived as the result of the calibrations of the FOV
   relative positions with respect to the MICAS boresight mirror performed
   on the ground before launch (see [7].) No measurements for rotation about
   Z ("clock" angle) were made at that time.

   Post-launch Actual Angular Relative FOV Position (in degrees):
   -------------------------------------------------------------
   
                                          Rotation            negative
                                          direction:        ^ about Yccd
                                                            ^
           Zsc                                              ^       positive
            x----->                                   < < <   > > > about Xccd
            |    Xsc                            negative    v
            |                                   about Xccd  v
        Ysc V                                               v positive
                                                              about Yccd
                                                              

           Zuv    Xuv         Zccd            Zaps                Zir      
            x----->      <-----x         <-----x                   x----->      
            |          Yccd    |       Yaps    |                   |     Xir  
            |                  |               |                   |       
        Yuv V                  V Xccd          V Xaps              V Yir  

                   ____________________________________ 
          ____    |*CCD(1,1)                           |
         |    |   |...|                                |         ____
         | UV |   |...|                                |        |    |
         |____|   |...|         _____________          |        | IR |
           ||     |...|        |    APS(1,1)*|         |        |____|
           ||  |  |...|        |             |  |      |          ||
           ||  v  |...|        |      |APS   |  v      |      |   ||
      UV --o- --- |...|        |    |-o-- ---------    |      v   ||
   center  || ------------------- --o-| ------------------------  ||
           ||  ^  |...|        | CCD|        |  ^      |     --- -o-- IR
           ||  |  |...|        |____|________|  |      |      ^   ||center
           || 0.05|...|             |      0.006568(*) |      |   ||
           ||     |...|             | |                |     0.02 ||
           ||     |...|         --->|-|<----           |          ||
           ||     |...|             |    0.060121(*)   |          ||
                  |...|             |                  |          ||
                  |___|_____________|__________________|          ||
                                    |
           |             0.61       |           0.65              |
           |<---------------------->|<--------------------------->|
           |                        |                             |
      
   Actual rotational offsets between CCD, APS, UV and IR boresights (centers)
   about +X and +Y of the CCD frame:
   
                                actual          actual
                           offset rotation   offset rotation
                           about Xccd, deg   about Yccd, deg 
                           ---------------   ---------------
            
               CCD-to-APS     +0.060121(*)     0.006568(*)
               
               CCD-to-IR      +0.65            +0.02
               
               CCD-to-UV      -0.61            -0.05
               
   (*) values for actual APS offset were computed by differencing  
   corresponding rotation angles determined by DS1 OPNAV team.
               
   Thus, the orientation of UV and IR is fixed with respect to the CCD and 
   can be represented as a 3x3 rotation matrix for each of two detectors.
   
   Let x y and z be the components of a vector expressed in the CCD frame and
    X Y and Z be the components of the same vector expressed in another MICAS
   detector frame (UV or IR):

       [ X ]    [     ] [ x ]
       | Y |  = [ ROT ] | y |
       [ Z ]    [     ] [ z ]

   where ROT is a 3x3 rotation matrix computed from three independent rotation 
   angles -- ALPHA, BETA and GAMMA -- as follows:
   
      [     ]   [       ]  [      ]  [       ]
      [ ROT ] = [ GAMMA ]  [ BETA ]  [ ALPHA ]
      [     ]   [       ]  [      ]  [       ]
                         Z         Y          X
                                 
   where each of three matrixes on the right side represent a coordinate
   frame rotation by the given angle around the indicated axis.
   
   Note that GAMMA angle for both UR and UV detector frames is -90 degrees.
   This additional rotation has to be applied in order to align +Y axis of 
   these frames with the increasing line coordinate of the corresponding 
   images.
   
   The frame definitions below contains the actual rotational offsets between
   MICAS CCD and MICAS UV and IR frames.

   \begindata

      FRAME_DS1_MICAS_UV       = -30013
      FRAME_-30013_NAME        = 'DS1_MICAS_UV'
      FRAME_-30013_CLASS       = 4
      FRAME_-30013_CLASS_ID    = -30013
      FRAME_-30013_CENTER      = -30
      TKFRAME_-30013_SPEC      = 'ANGLES'
      TKFRAME_-30013_RELATIVE  = 'DS1_MICAS_CCD'
      TKFRAME_-30013_ANGLES    = ( 0.61, 0.05, 90.0 )
      TKFRAME_-30013_AXES      = ( 1,    2,    3    )
      TKFRAME_-30013_UNITS     = 'DEGREES'

      FRAME_DS1_MICAS_IR       = -30014
      FRAME_-30014_NAME        = 'DS1_MICAS_IR'
      FRAME_-30014_CLASS       = 4
      FRAME_-30014_CLASS_ID    = -30014
      FRAME_-30014_CENTER      = -30
      TKFRAME_-30014_SPEC      = 'ANGLES'
      TKFRAME_-30014_RELATIVE  = 'DS1_MICAS_CCD'
      TKFRAME_-30014_ANGLES    = ( -0.65, -0.02, 90.0 )
      TKFRAME_-30014_AXES      = (  1,     2,    3    )
      TKFRAME_-30014_UNITS     = 'DEGREES'

   \begintext


Plasma Experiment for Planetary Exploration (PEPE) Frame
--------------------------------------------------------

   The PEPE instrument is mounted in on the +X side of the spacecraft equipment
   module and the PEPE central symmetry axis is nominally along spacecraft Y
   axis.

   The PEPE instrument frame is defined by the instrument design as follows:

      *  +Z axis is along the instrument symmetry axis and points towards
         FOV opening side of the instrument;

      *  +X axis is perpendicular to the instrument symmetry axis and point
         in the PEPE sensing direction defined by zero AZ and EL angles;

      *  +Y complements to the right hand frame;

      *  the origin of the frame is at the intersection of the FOV opening
         central plane (EL=0 plane) with the instrument symmetry axis;

   The diagram below illustrates PEPE instrument frame orientation:

   +Z PEPE (-Ysc) Side View:
   -------------------------

      Spacecraft Frame:                      PEPE Frame:
      -----------------                      -----------

               ^ Zsc                           <----o Zpepe (out of page)
               |                            Xpepe   |
               |       Xsc                          |
               x----->                              v Ypepe
            Ysc (into page)
                                   |
                                _______
                              /  AZ=90  \
                            /      *      \
                          /     .  |  .     \
                         |     .   |   AZ=180|    
                      -- | ----*---o---*---- | --
                         | AZ=0.   |   .     |
                          \     .  |  .     /
                            \      *<'AZ=270
                              \ _______ /
                           
                                   |

   -X PEPE (+Xsc) Side View:
   -------------------------

      Spacecraft Frame:                      PEPE Frame:
      -----------------                      -----------

               ^ Zsc                           <----x Xpepe (into page)
               |                             Zpepe  |
               |      +Ysc                          |
               o----->                              v Ypepe
            Xsc (out of page)

                              EL=0
                                |
                         +45 \..|../ -45
                              \ | /
                         _____ \|/ ________________
                        |     |   |                |
                        |     | . |                |
                        |     | . |                |
                        |     | . |                |
                    --- | --- | . | -------------- | ---
                        |     | . |                |
                        |     | . |                |
                        |     | . |                |
                        |_____| . |________________|
                               /|\
                              / | \
                         +45 /..|..\ -45
                                |
                              EL=0


   As seen on the diagram PEPE frame is first rotated from spacecraft frame
   first by +90 degrees about +X axis and after that by 180 degrees about new
   position of Z axis, i.e. transformation matrix rotating vectors from the
   spacecraft frame into the PEPE frames can be constructed as follows:


      [     ]   [       ]  [       ]  [       ]
      [  M  ] = [  0.0  ]  [ 180.0 ]  [  90.0 ]
      [     ]   [       ]  [       ]  [       ]
                         Y          Z          X

   where [x]i represent rotation by a given angle a about a given axis i.

   The DS1_PEPE frame definition below contains the actual orientation.

   \begindata

      FRAME_DS1_PEPE          = -30020
      FRAME_-30020_NAME        = 'DS1_PEPE'
      FRAME_-30020_CLASS       = 4
      FRAME_-30020_CLASS_ID    = -30020
      FRAME_-30020_CENTER      = -30
      TKFRAME_-30020_SPEC      = 'ANGLES'
      TKFRAME_-30020_RELATIVE  = 'DS1_SC_BUS'
      TKFRAME_-30020_ANGLES    = ( -90.0, 180.0, 0.0 )
      TKFRAME_-30020_AXES      = (  1,    3,     2   )
      TKFRAME_-30020_UNITS     = 'DEGREES'

   \begintext


Solar Array (SA1 and SA2) Frames
--------------------------------------------------------

   The solar array frames are defined by the solar array design as follows
   (this definition is consistent with the definition provided in [8]):

      *  +Z axis is along the normal to the plane of array and points 
         in the direction of the active cell side;

      *  +Y axis is along the solar array rotation axis and points from  
         the solar array drive (gimbal) side towards the end of the array; 

      *  +X complements to the right hand frame;

      *  the origin of this frame is at the center of the solar array 
         drive (gimbal).
         
   From this definition follows that for any spacecraft configuration
   (except stowed), +Y axes of the SA1 and SA2 frames point in opposite 
   directions and that for maximum power output the Sun must at the +Z 
   axis in the array frames.
   
   In the initially deployed configuration ("zero" solar array rotation 
   angle) orientation of the solar array frames with respect to the
   spacecraft frame is shown on the diagram below:
   
                              +Xsa2
       _______________________  ^   _______      _______________________
      |    SA2                \ |  |       |    /                SA1    |
      |(cell side)             \|  |      +Zsa1/   +Ysa1     (cell side)|
      |                    <----o==| +Zsc  |==o---->                    |
      |                +Ysa2   /Zsa2   ^   |  |\                        |
      |_______________________/    |___|___|  | \_______________________|
                                     / | \    V +Xsa1
                                    /__o---->
                                    +Xsc    +Ysc

   The solar array frame orientation with respect to the spacecraft bus
   frame is provided by C kernel (see [2] for more information). The 
   orientation stored in the CK files is computed from array rotation 
   angles extracted in the spacecraft engineering telemetry.
   
   \begindata

      FRAME_DS1_SA1            = -30201
      FRAME_-30201_NAME        = 'DS1_SA1'
      FRAME_-30201_CLASS       = 3
      FRAME_-30201_CLASS_ID    = -30201
      FRAME_-30201_CENTER      = -30
      CK_-30201_SCLK           = -30
      CK_-30201_SPK            = -30

      FRAME_DS1_SA2            = -30202
      FRAME_-30202_NAME        = 'DS1_SA2'
      FRAME_-30202_CLASS       = 3
      FRAME_-30202_CLASS_ID    = -30202
      FRAME_-30202_CENTER      = -30
      CK_-30202_SCLK           = -30
      CK_-30202_SPK            = -30

   \begintext


DS-1 Antenna Frame Definition Keywords Naming Convention
--------------------------------------------------------

   All names referencing values in this frame kernel start with the
   characters `FRAME', 'CK' or `TKFRAME' followed by the DSN Deep Space One
   spacecraft bus ID number (-30000) added to zero or the three digit antenna
   number (101-105).

   The remainder of the name is an underscore character followed by the
   unique name of the data item. For example, the DS-1 antenna offsets
   relative to the spacecraft frame, given as three Euler angles, are
   specified using two items:

      TKFRAME_-30101_ANGLES    = ( 0.0, -90.0, 0.0 )
      TKFRAME_-30101_AXES      = (  1,      2,   3 )


   The upper bound on the length of the name of any data item is 32
   characters.

   If the same item is included in more then one file, or if the same
   item appears more than once within a single file, the latest value
   supersedes any earlier values.

   See [4] for a discussion of the FRAME and CK keywords.


TKFRAME Keyword Description
--------------------------------------------------------

   This section describes the TKFRAME keywords. The rotational offsets
   can be given as three angles -- ROLL, PITCH and YAW, from which a
   rotation matrix can be constructed that will transform the components
   of a vector expressed in the spacecraft frame to components expressed
   in the antenna fixed frame. For example, if x, y and z are the
   components of a vector expressed in the spacecraft frame, X, Y and
   Z will be the components of the same vector expressed in the antenna
   fixed frame:


      [ X ]    [     ]  [ x ]
      | Y |  = | ROT |  | y |
      [ Z ]    [     ]  [ z ]


   where ROT is the rotation matrix constructed from the rotation angles
   as follows:

      [     ]   [     ]  [       ]  [      ]
      [ ROT ] = [ YAW ]  [ PITCH ]  [ ROLL ]
      [     ]   [     ]  [       ]  [      ]
                        Z          Y         X

   where each of three matrixes on the right side represent a coordinate
   frame rotation by the given angle around the indicated axis. See
   the SPICELIB routine EUL2M for more information about constructing
   a rotation matrix from a set of rotation angles.

   Following are some examples of use of the TKFRAME keywords:

   The keyword that indicates which frame the axis rotations are
   referred to is:

      TKFRAME_-30101_RELATIVE  = 'DS1_SC_BUS'


   The keyword TKFRAME_-91000_ANGLES contain these values, in radians,
   in the following order:

                                 ``ROLL''  ``PITCH''  ``YAW''
      TKFRAME_-30101_ANGLES = (     0.0,      -90.0,     0.0   )


   The keyword TKFRAME_-30101_AXES contains integer codes of the
   corresponding axes of rotations (1 -- X, 2 -- Y, 3 -- Z).

      TKFRAME_-30101_AXES      = (  1,    2,   3 )


   The keyword TKFRAME_-30101_UNITS gives the units of the angles.

      TKFRAME_-30101_UNITS     = 'DEGREES'



Antenna Frame Definitions
--------------------------------------------------------

   Here are the antenna frame definitions for DS1.  These will be
   utilized by SPICE's FRAMES subsystem to provide automatic state
   transformations to/from the DS-1 frame.  Note that SPICE toolkit
   version N0047 or higher is required to use fixed-offset frames.

   Note that angles in the frame definitions are specified for the
   "from instrument to base (relative to) frame" transformation.

   \begindata

      FRAME_DS1_HGA            = -30101
      FRAME_-30101_NAME        = 'DS1_HGA'
      FRAME_-30101_CLASS       = 4
      FRAME_-30101_CLASS_ID    = -30101
      FRAME_-30101_CENTER      = -30
      TKFRAME_-30101_SPEC      = 'ANGLES'
      TKFRAME_-30101_RELATIVE  = 'DS1_SC_BUS'
      TKFRAME_-30101_ANGLES    = ( 0.0, -90.0, 0.0 )
      TKFRAME_-30101_AXES      = (  1,      2,   3 )
      TKFRAME_-30101_UNITS     = 'DEGREES'

      FRAME_DS1_LGA+X          = -30102
      FRAME_-30102_NAME        = 'DS1_LGA+X'
      FRAME_-30102_CLASS       = 4
      FRAME_-30102_CLASS_ID    = -30102
      FRAME_-30102_CENTER      = -30
      TKFRAME_-30102_SPEC      = 'ANGLES'
      TKFRAME_-30102_RELATIVE  = 'DS1_SC_BUS'
      TKFRAME_-30102_ANGLES    = ( 0.0,    -90.0,     0.0 )
      TKFRAME_-30102_AXES      = (  1,         2,       3 )
      TKFRAME_-30102_UNITS     = 'DEGREES'

      FRAME_DS1_LGA+Z          = -30103
      FRAME_-30103_NAME        = 'DS1_LGA+Z'
      FRAME_-30103_CLASS       = 4
      FRAME_-30103_CLASS_ID    = -30103
      FRAME_-30103_CENTER      = -30
      TKFRAME_-30103_SPEC      = 'ANGLES'
      TKFRAME_-30103_RELATIVE  = 'DS1_SC_BUS'
      TKFRAME_-30103_ANGLES    = ( 0.0,  0.0, 0.0 )
      TKFRAME_-30103_AXES      = (  1,     2,   3 )
      TKFRAME_-30103_UNITS     = 'DEGREES'

      FRAME_DS1_LGA-Z          = -30104
      FRAME_-30104_NAME        = 'DS1_LGA-Z'
      FRAME_-30104_CLASS       = 4
      FRAME_-30104_CLASS_ID    = -30104
      FRAME_-30104_CENTER      = -30
      TKFRAME_-30104_SPEC      = 'ANGLES'
      TKFRAME_-30104_RELATIVE  = 'DS1_SC_BUS'
      TKFRAME_-30104_ANGLES    = ( 0.0, 180.0, 0.0 )
      TKFRAME_-30104_AXES      = (  1,      2,   3 )
      TKFRAME_-30104_UNITS     = 'DEGREES'

      FRAME_DS1_KA             = -30105
      FRAME_-30105_NAME        = 'DS1_KA'
      FRAME_-30105_CLASS       = 4
      FRAME_-30105_CLASS_ID    = -30105
      FRAME_-30105_CENTER      = -30
      TKFRAME_-30105_SPEC      = 'ANGLES'
      TKFRAME_-30105_RELATIVE  = 'DS1_SC_BUS'
      TKFRAME_-30105_ANGLES    = ( 0.0, -90.0, 0.0 )
      TKFRAME_-30105_AXES      = (  1,      2,   3 )
      TKFRAME_-30105_UNITS     = 'DEGREES'

   \begintext
