import os
from pathlib import Path


# Clean string contents
def clean_contents(data, remove_str_list=None, ignore_str_list=None, replace_str_map=None):

    data = data.replace("\r", "")  # Removes return carriage char

    if remove_str_list and len(remove_str_list):
        for removeStr in remove_str_list:
            data = data.replace(removeStr, "")

    if not ignore_str_list:
        ignore_str_list = ["#"]

    clean_data = ""

    for line in data.splitlines():
        line = line.strip()  # Trims the line
        if line != "":
            is_valid = True

            for ignore_str in ignore_str_list:
                if line.startswith(ignore_str):
                    is_valid = False
                    break

            if is_valid:

                if replace_str_map:
                    for replace_str in replace_str_map:
                        if replace_str in line:
                            line = line.replace(replace_str, replace_str_map[replace_str])

                clean_data += line + "\n"

    return clean_data


# Compares to strings line by line
def equal_contents_line_by_line(data1, data2, remove_str_list=None, ignore_str_list=None, replace_str_map=None):
    cdata1 = clean_contents(data1, remove_str_list, ignore_str_list, replace_str_map)
    cdata2 = clean_contents(data2, remove_str_list, ignore_str_list, replace_str_map)
    lines1 = cdata1.splitlines()
    lines2 = cdata2.splitlines()

    if len(lines1) == len(lines2):
        for i in range(0, len(lines1)):
            if lines1[i] != lines2[i]:
                print("equalContentsLineByLine: Diferent line " + str(i))
                print(lines1[i])
                print(lines2[i])
                return False

        return True

    else:
        print(
            "equalContentsLineByLine: Diferent number of lines -> " + str(len(lines1)) + " vs " + str(len(lines2)))
        print("cdata1: - - - - - - - - - - - - - - - - - - -  - -")
        print(cdata1)
        print("cdata2: - - - - - - - - - - - - - - - - - - -  - -")
        print(cdata2)

    return False


# Compares to strings
def equal_clean_contents(data1, data2, remove_str_list=None, ignore_str_list=None, replace_str_map=None):
    return clean_contents(data1, remove_str_list, ignore_str_list, replace_str_map) \
           == clean_contents(data2, remove_str_list, ignore_str_list, replace_str_map)


# Checks if two files has same contents
def equal_file_contents(filename1, filename2, remove_str_list=None, ignore_str_list=None, replace_str_map=None):

    # Cross-platform support
    filename1 = str(Path(filename1))
    filename2 = str(Path(filename2))

    if os.path.isfile(filename1):
        filedata1 = open(filename1, 'r').read()

        if os.path.isfile(filename2):
            filedata2 = open(filename2, 'r').read()

            if equal_clean_contents(filedata1, filedata2, remove_str_list, ignore_str_list, replace_str_map):
                return True
            else:
                equal_contents_line_by_line(filedata1, filedata2, remove_str_list, ignore_str_list, replace_str_map)
        else:
            print("FILE NOT FOUND OR INVALID: " + filename2)
    else:
        print("FILE NOT FOUND OR INVALID: " + filename1)

    return False


# Checks if two CSV files has same contents with option to ignore a column
def equal_csv_contents(filename1, filename2, separator=",", ignore_columns=None, remove_str_list=None, ignore_str_list=None, replace_str_map=None):

    # Cross-platform support
    filename1 = str(Path(filename1))
    filename2 = str(Path(filename2))

    if not ignore_columns:
        ignore_columns = []

    if os.path.isfile(filename1):
        filedata1 = open(filename1, 'r').read()

        if os.path.isfile(filename2):
            filedata2 = open(filename2, 'r').read()

            cdata1 = clean_contents(filedata1, remove_str_list, ignore_str_list, replace_str_map)
            cdata2 = clean_contents(filedata2, remove_str_list, ignore_str_list, replace_str_map)
            lines1 = cdata1.splitlines()
            lines2 = cdata2.splitlines()

            if len(lines1) == len(lines2):
                for i in range(0, len(lines1)):

                    columns1 = lines1[i].split(separator)
                    columns2 = lines2[i].split(separator)

                    if len(columns1) == len(columns2):

                        for c in range(0, len(columns1)):
                            if c not in ignore_columns:
                                if columns1[c] != columns2[c]:
                                    print("equal_csv_contents: Diferent line " + str(i))
                                    print(lines1[i])
                                    print(lines2[i])
                                    return False

                    else:
                        print("equal_csv_contents: Diferent number of columns at line " + str(i))

                return True

            else:
                print(
                    "equal_csv_contents: Diferent number of lines -> " + str(len(lines1)) + " vs " + str(
                        len(lines2)))
                print("cdata1: - - - - - - - - - - - - - - - - - - -  - -")
                print(cdata1)
                print("cdata2: - - - - - - - - - - - - - - - - - - -  - -")
                print(cdata2)

        else:
            print("FILE NOT FOUND OR INVALID: " + filename2)
    else:
        print("FILE NOT FOUND OR INVALID: " + filename1)

    return False


# Replace an string in a given mk file and writes an
# output mk file with all the occurrences replaced
def file_replace(in_file_path, str_to_replace, new_str, out_file_path):
    in_file = open(in_file_path, 'r').readlines()
    out_file = open(out_file_path, 'w+')

    for line in in_file:
        if str_to_replace in line:
            line = line.replace(str_to_replace, new_str)
        out_file.write(line)

    return
