KPL/FK

Venus Express Target Body DSK Surface ID Codes
========================================================================

   This frame kernel contains a set of Venus Express structures DSK Surface
   ID Codes for Bus, +Y Solar Array and -Y Solar Array.


Version and Date
========================================================================

   Version 1.0 -- April 3, 2020 -- Alfredo Escalante Lopez, ESAC/ESA

      First version.


References
========================================================================

   1. ``Frames Required Reading''

   2. ``Kernel Pool Required Reading''

   3. ``DS-Kernel Required Reading''

   4. Venus Express Frames Kernel.


Contact Information
========================================================================

   Alfredo Escalante Lopez, ESAC/ESA +34 91 8131 429 alfredo.escalante@esa.int

   Marc Costa Sitja, ESAC/ESA, +34 91 8131 457 marc.costa@esa.int

   Boris Semenov, NAIF/JPL, (818) 354-8136, boris.semenov@jpl.nasa.gov


Implementation Notes
========================================================================

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must `load' the kernel, normally during
   program initialization. The SPICELIB routine FURNSH and CSPICE
   function furnsh_c load a kernel file into the kernel pool as shown
   below.

      CALL FURNSH ( 'frame_kernel_name' )
      furnsh_c    ( "frame_kernel_name" );

   This file was created and may be updated with a text editor or word
   processor.


Definition Section
========================================================================

   This section contains name to ID mappings for the Venus Express
   structures body DSK surfaces. These mappings are supported by all SPICE
   toolkits with integrated DSK capabilities (version N0066 or later).

   Venus Express Bus Surface name/IDs:

          DSK Surface Name           ID     Body ID
      ===========================  =======  =======

      VEX_SC_BUS                   -248000  -248000


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'VEX_SC_BUS'
      NAIF_SURFACE_CODE += -248000
      NAIF_SURFACE_BODY += -248000

   \begintext


   Venus Express Solar Arrays Surface name/IDs:

          DSK Surface Name           ID     Body ID
      ===========================  =======  =======

      VEX_SC_SA+Y                  -248011  -248011
      VEX_SC_SA-Y                  -248013  -248013


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'VEX_SC_SA+Y'
      NAIF_SURFACE_CODE += -248011
      NAIF_SURFACE_BODY += -248011

      NAIF_SURFACE_NAME += 'VEX_SC_SA-Y'
      NAIF_SURFACE_CODE += -248013
      NAIF_SURFACE_BODY += -248013

   \begintext


End of FK file.