KPL/MK

   This meta-kernel lists the ROS SPICE kernels providing coverage
   since the beginning of the mission. All of the kernels listed below
   are archived in the ROS SPICE data set, RO/RL-E/M/A/C-SPICE-6-V1.0.
   This set of files and the order in which they are listed were picked
   to provide the best available data and the most complete coverage
   based on the information about the kernels available at the time
   this meta-kernel was made. For detailed information about the
   kernels listed below refer to the internal comments included in the
   kernels and the documentation accompanying the ROS SPICE data set.

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the ROS SPICE data set's ``data'' directory on their
   system. Replacing ``/'' with ``\'' and converting line terminators
   to the format native to the user's system may also be required if
   this meta-kernel is to be used on a non-UNIX workstation.

   This file was created on June 26, 2019 by Bjoern Grieger, ESAC/ESA.

   The original name of this file was ROS_WITH_DSK_V06.TM.

   \begindata

     PATH_VALUES       = ( './DATA'  )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                          '$KERNELS/LSK/NAIF0011.TLS'


                          '$KERNELS/SCLK/ROS_160929_STEP.TSC'
                          '$KERNELS/SCLK/LANDER_170904_STEP.TSC'


                          '$KERNELS/PCK/PCK00010.TPC'
                          '$KERNELS/PCK/DE403_MASSES.TPC'

                          '$KERNELS/PCK/EARTH_000101_170227_161206.BPC'

                          '$KERNELS/PCK/ROS_LUTETIA_RSOC_V03.TPC'
                          '$KERNELS/PCK/ROS_STEINS_V05.TPC'
                          '$KERNELS/PCK/ROS_CG_RAD_V10.TPC'


                          '$KERNELS/FK/EARTHFIXEDITRF93.TF'
                          '$KERNELS/FK/EARTH_TOPO_050714.TF'
                          '$KERNELS/FK/ESTRACK_V01.TF'
                          '$KERNELS/FK/NEW_NORCIA_TOPO.TF'

                          '$KERNELS/FK/ROS_LUTETIA_RSOC_V03.TF'

                          '$KERNELS/FK/RSSD0002.TF'

                          '$KERNELS/FK/ROS_V34.TF'
                          '$KERNELS/FK/ROS_DSK_SURFACES_V02.TF'

                          '$KERNELS/IK/ROS_ALICE_V17.TI'
                          '$KERNELS/IK/ROS_CIVA_V10.TI'
                          '$KERNELS/IK/ROS_CONSERT_V11.TI'
                          '$KERNELS/IK/ROS_COSIMA_V15.TI'
                          '$KERNELS/IK/ROS_DIM_V11.TI'
                          '$KERNELS/IK/ROS_GIADA_V12.TI'
                          '$KERNELS/IK/ROS_MIDAS_V11.TI'
                          '$KERNELS/IK/ROS_MIRO_V11.TI'
                          '$KERNELS/IK/ROS_NAVCAM_V03.TI'
                          '$KERNELS/IK/ROS_OSIRIS_V15.TI'
                          '$KERNELS/IK/ROS_ROLIS_V03.TI'
                          '$KERNELS/IK/ROS_ROSINA_V12.TI'
                          '$KERNELS/IK/ROS_RPC_V19.TI'
                          '$KERNELS/IK/ROS_SREM_V01.TI'
                          '$KERNELS/IK/ROS_STR_V12.TI'
                          '$KERNELS/IK/ROS_VIRTIS_V14.TI'


                          '$KERNELS/SPK/DE405.BSP'
                          '$KERNELS/SPK/OUTERPLANETS_V0003.BSP'

                          '$KERNELS/SPK/EARTHSTNS_ITRF93_050714.BSP'
                          '$KERNELS/SPK/ESTRACK_V01.BSP'
                          '$KERNELS/SPK/NEW_NORCIA.BSP'

                          '$KERNELS/SPK/TEMPEL1_9P_DI_P.BSP'
                          '$KERNELS/SPK/C2002_T7_LINEAR_HOR_V01.BSP'
                          '$KERNELS/SPK/C2004_Q2_MACHHOLZ_HOR_V01.BSP'
                          '$KERNELS/SPK/C2010_A2_LINEAR_HOR_V01.BSP'
                          '$KERNELS/SPK/VESTA_HOR_V01.BSP'
                          '$KERNELS/SPK/MAR097_030101_170101_V0001.BSP'

                          '$KERNELS/SPK/21_LUTETIA_2004_2016.BSP'
                          '$KERNELS/SPK/ORHS_______________00109.BSP'

                          '$KERNELS/SPK/2867_STEINS_2004_2016.BSP'
                          '$KERNELS/SPK/ORHO_______________00077.BSP'

                          '$KERNELS/SPK/ORHW_______________00016.BSP'
                          '$KERNELS/SPK/ORHW_______________00122.BSP'
                          '$KERNELS/SPK/CORB_DV_257_03___T19_00345.BSP' 

                          '$KERNELS/SPK/ROS_STRUCT_V6.BSP'

                          '$KERNELS/SPK/LORB_ROS_SC_PRESEP_V1_0.BSP'
                          '$KERNELS/SPK/LORB_SUN_J2000_SDL_V1_1.BSP'
                          '$KERNELS/SPK/LORB_C_G_FIXED_RBD_7_V2_0.BSP'
                          '$KERNELS/SPK/SPICE_PHILAE_CFF_SONC_V2_0.BSP'

                          '$KERNELS/SPK/ORHR___________T19_00122.BSP'
                          '$KERNELS/SPK/RORB_DV_257_03___T19_00345.BSP' 
                          '$KERNELS/SPK/ROS_ORBITER_EXTENSION_V2.BSP'
                          '$KERNELS/SPK/ROS_COG_V4.BSP'


                          '$KERNELS/CK/ROS_LBOOM_V0.BC'

                          '$KERNELS/CK/ROS_HGA_2004_V0001.BC'
                          '$KERNELS/CK/ROS_HGA_2005_V0001.BC'
                          '$KERNELS/CK/ROS_HGA_2006_V0001.BC'
                          '$KERNELS/CK/ROS_HGA_2007_V0001.BC'
                          '$KERNELS/CK/ROS_HGA_2008_V0019.BC'
                          '$KERNELS/CK/ROS_HGA_2009_V0052.BC'
                          '$KERNELS/CK/ROS_HGA_2010_V0046.BC'
                          '$KERNELS/CK/ROS_HGA_2011_V0018.BC'
                          '$KERNELS/CK/ROS_HGA_2014_V0044.BC'
                          '$KERNELS/CK/ROS_HGA_2015_V0053.BC'
                          '$KERNELS/CK/ROS_HGA_2016_V0042.BC'

                          '$KERNELS/CK/ROS_SA_2004_V0001.BC'
                          '$KERNELS/CK/ROS_SA_2005_V0001.BC'
                          '$KERNELS/CK/ROS_SA_2006_V0001.BC'
                          '$KERNELS/CK/ROS_SA_2007_V0001.BC'
                          '$KERNELS/CK/ROS_SA_2008_V0038.BC'
                          '$KERNELS/CK/ROS_SA_2009_V0054.BC'
                          '$KERNELS/CK/ROS_SA_2010_V0052.BC'
                          '$KERNELS/CK/ROS_SA_2011_V0020.BC'
                          '$KERNELS/CK/ROS_SA_2014_V0047.BC'
                          '$KERNELS/CK/ROS_SA_2015_V0042.BC'
                          '$KERNELS/CK/ROS_SA_2016_V0041.BC'

                          '$KERNELS/CK/ROS_VIRTIS_M_0403_1509_V1.BC'
                          '$KERNELS/CK/ROS_VIRTIS_M_1509_1609_V1.BC'

                          '$KERNELS/CK/ATNR_P040302093352_T6_00127.BC'
                          '$KERNELS/CK/RATT_DV_145_01_01_T6_00216.BC'
                          '$KERNELS/CK/RATT_DV_223_01_01_T6_00302.BC'
                          '$KERNELS/CK/RATT_DV_257_02_01_T6_00344.BC'
                          '$KERNELS/CK/ROS_ORBITER_EXTENSION_V2.BC'

                          '$KERNELS/CK/CATT_DV_145_02_______00216.BC'
                          '$KERNELS/CK/CATT_DV_223_02_______00302.BC'
                          '$KERNELS/CK/CATT_DV_257_03_______00344.BC'

                          '$KERNELS/CK/LATT_ROS2LDR_PRESEP_V1_0.BC'
                          '$KERNELS/CK/LATT_EME2LDR_SDL_V1_0.BC'
                          '$KERNELS/CK/LATT_ROS2LDR_SDL_ROMAP_V1_0.BC'
                          '$KERNELS/CK/LATT_CFF2LDR_FSS_V2_0.BC'

                          '$KERNELS/DSK/ROS_CG_M004_NSPCESA_N_V1.BDS'
                          '$KERNELS/DSK/ROS_ST_K020_OSPCLAM_N_V1.BDS'
                          '$KERNELS/DSK/ROS_LU_M003_OSPCLAM_N_V1.BDS'
                          '$KERNELS/DSK/PHOBOS_M003_GAS_V01.BDS'
                          '$KERNELS/DSK/DEIMOS_K005_THO_V01.BDS'
                          '$KERNELS/DSK/TEMPEL1_9P_K032_THO_V01.BDS'

                         )

   \begintext

End of MK file.