KPL/FK

Rosetta Target Body DSK Surface ID Codes
========================================================================

   This frame kernel contains a set of Rosetta Target Body DSK Surface ID
   Codes for Phobos, Deimos and Comet 9P/Tempel 1. The DSK Surface ID Codes
   for Comet 67P/Churyumov-Gerasimenko and Asteroids Lutetia and Steins are
   provided in the Rosetta Frames Kernel.


Version and Date
========================================================================

   Version 0.2 -- May 21, 2019 -- Bjoern Grieger, ESAC/ESA

      Corrected plate number token in file names for DEIMOS_K005_THO_V01,
      PHOBOS_K275_DLR_V02, PHOBOS_M003_GAS_V01.

   Version 0.1 -- March 28, 2019 -- Bjoern Grieger, ESAC/ESA

      Added PHOBOS_K137_DLR_V02.

   Version 0.0 -- August 29, 2018 -- Marc Costa Sitja, ESAC/ESA

      First version.


References
========================================================================

   1. ``Frames Required Reading''

   2. ``Kernel Pool Required Reading''

   3. ``DS-Kernel Required Reading''

   4. Rosetta Frames Kernel.


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact SPICE support at
   ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           mcosta@sciops.esa.int, esa_spice@sciops.esa.int

           Bjoern Grieger
           (+34) 91-8131-107
           bgrieger@sciops.esa.int, esa_spice@sciops.esa.int

   or NAIF at JPL:

           Boris Semenov
           (818) 354-8136
           Boris.Semenov@jpl.nasa.gov


Implementation Notes
========================================================================

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must `load' the kernel, normally during
   program initialization. The SPICELIB routine FURNSH and CSPICE
   function furnsh_c load a kernel file into the kernel pool as shown
   below.

      CALL FURNSH ( 'frame_kernel_name' )
      furnsh_c    ( "frame_kernel_name" );

   This file was created and may be updated with a text editor or word
   processor.


Definition Section
========================================================================

   This section contains name to ID mappings for the Rosetta target
   body DSK surfaces. These mappings are supported by all SPICE
   toolkits with integrated DSK capabilities (version N0066 or later).

   Mars Satellite Phobos Surface name/IDs:

          DSK Surface Name          ID    Body ID
      ===========================  =====  =======

      PHOBOS_M003_GAS_V01          14011      401
      PHOBOS_K137_DLR_V01          10041      401
      PHOBOS_K275_DLR_V02          10042      401


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'PHOBOS_M003_GAS_V01'
      NAIF_SURFACE_CODE += 14011
      NAIF_SURFACE_BODY += 401

      NAIF_SURFACE_NAME += 'PHOBOS_K137_DLR_V01'
      NAIF_SURFACE_CODE += 10041
      NAIF_SURFACE_BODY += 401

      NAIF_SURFACE_NAME += 'PHOBOS_K275_DLR_V02'
      NAIF_SURFACE_CODE += 10042
      NAIF_SURFACE_BODY += 401

   \begintext


   Mars Satellite Deimos Surface name/IDs:

          DSK Surface Name          ID    Body ID
      ===========================  =====  =======

      DEIMOS_K005_THO_V01          14020      402


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'DEIMOS_K005_THO_V01'
      NAIF_SURFACE_CODE += 14020
      NAIF_SURFACE_BODY += 402

   \begintext


   Comet 9P/Tempel 1 name/IDs:

          DSK Surface Name          ID    Body ID
      ===========================  =====  =======

      TEMPEL_9P_K032_THO_V01       10930  1000093


   Name-ID Mapping keywords:

   \begindata

      NAIF_SURFACE_NAME += 'TEMPEL_9P_K032_THO_V01'
      NAIF_SURFACE_CODE += 10930
      NAIF_SURFACE_BODY += 1000093

   \begintext


End of FK file.