KPL/FK

JUpiter ICy moons Explorer (JUICE) Frames Kernel
==============================================================================

   This frame kernel contains complete set of frame definitions for the
   Jupiter Icy Moons Explorer (JUICE) spacecraft, its structures and science
   instruments. This frame kernel also contains name - to - NAIF ID mappings
   for JUICE science instruments and s/c structures (see the last section of
   the file.)


Version and Date
-----------------------------------------------------------------------------

   Version 2.0 -- May 11, 2020 -- Alfredo Escalante Lopez, ESAC/ESA

      Define all sensors as ephemeris objects. Frames centers have been
      changed to the corresponding instrument ephemeris object.

   Version 1.9 -- March 3, 2020 -- Marc Costa Sitja, ESAC/ESA

      Updated PEP-NIM NEUION sector names.

   Version 1.8 -- November 13, 2019 -- Marc Costa Sitja, ESAC/ESA

      Added auxiliary FOV name and ID for SWI.

   Version 1.7 -- October 29, 2019 -- Marc Costa Sitja, ESAC/ESA
                                     Vincent Hue, UVS/SRI

      Updated centres of the MAG Boom, Solar Array and S/C frames in order
      to be able to use the JUICE SC SA DSK.
      Updated PEP NIM reference frames for PEP NIM FoV obstruction study.
      Corrected typo in the UVS reference frames diagram.
      Updated Solar Array Zero frames definition.

   Version 1.6 -- October 16, 2018 -- Marc Costa Sitja, ESAC/ESA

      Added JUICE_IO_PLASMA_TORUS ID. Modified center of JUICE_SPACECRAFT
      in order to be able to use the JUICE SC BUS DSK.

   Version 1.5 -- October 10, 2018 -- Marc Costa Sitja, ESAC/ESA

      Corrected JUICE_MGA frame and IDs.

   Version 1.4 -- November 6, 2017 -- Marc Costa Sitja, ESAC/ESA

      Updated PEP NIM IDs.

   Version 1.3 -- October 23, 2017 -- Marc Costa Sitja, ESAC/ESA

      Added PEP JEI references.

   Version 1.2 -- February 13, 2017 -- Marc Costa Sitja, ESAC/ESA

      Added diagram for the PEP Nadir Unit frames definition.
      Added PEP NIM Thermal and Neutral/ion references, corrected PEP JNA
      reference frame. Added JUICE_<CENTRALBODY>_RAM frames references.

      The full list of PEP IDs is now included in the PEP IK (from version
      05) and only a reference is provided in this FK. This has been done
      in order to avoid overloading of this FK.

   Version 1.1 -- November 30, 2016 -- Marc Costa Sitja, ESAC/ESA

      Corrected SWI frame definitions and added Channel 1 and Channel 2
      definitions.

      Added references [14], [15], [16], [17] and [18].

   Version 1.0 -- November 3, 2016 -- Marc Costa Sitja, ESAC/ESA

      Updated JUICE PEP frames and NAIF IDs and JUICE SWI sensor field-
      of-view definitions. Added Star Trackers, Monitoring Cameras,
      NavCams and Medium and Low Gain Antenna frames and corresponding
      NAIF IDs. Corrected minor typos and text layout.
      Updated JUICE_SA+Y_ZERO and JUICE_SA-Y_ZERO definitions.

      Added references [14], [15], [16], [17] and [18].

   Version 0.9 -- August 15, 2016 -- Marc Costa Sitja, ESAC/ESA
                                     Jorge Diaz del Rio, ODC Space

      Updated JUICE Mission frames with frames from juice_sci_v05.tf
      frames kernel.

      Added JUICE_SA+Y and JUICE_SA-Y name/ID mappings.

      Minor edits to comments and frame descriptions to correct typos
      and missing information.

   Version 0.8 -- July 19, 2016 -- Marc Costa Sitja, ESAC/ESA

      Updated JUICE Mission frames with frames from juice_sci_v03.tf
      frames kernel and missing instrument frames.

      Corrected deployment angle of the MAG Boom in stowed configuration
      Angle of +Zmagb w.r.t +Xsc changed from 45 to 51 degrees as
      indicated by Ignacio Torralba (ESTEC/ESA).

      Added JUICE_RIME_BASE instrument ID and updated the JUICE_RIME
      instrument ID.

      Corrected typo in RPWI Frame Tree and in MAJIS frame definition.

   Version 0.7 -- June 22, 2016 -- Marc Costa Sitja, ESAC/ESA

      Corrected definition of JUICE_PEP_* frames.

   Version 0.6 -- June 10, 2016 -- Jorge Diaz del Rio, ODC Space

      Corrected definition of JUICE_RIME_BASE frame. Corrected comments on
      the JUICE spacecraft NAME/ID mapping section.

   Version 0.5 -- June 04, 2016 -- Marc Costa Sitja, ESAC/ESA

      Updated all NAIF ID codes from -907* to -28* since the JUICE
      spacecraft NAIF ID has been updated from -907 to -28.

   Version 0.4 -- May 11, 2016 -- Jorge Diaz del Rio, ODC Space

      Corrected Name/ID code mappings for J-MAG. Updated MAG_BOOM-H and
      MAG_BOOM frame descriptions. Corrected typos in text. Corrected
      JUICE_HGA frame definition. Added JUICE_IO_NPO to the list of frames.
      Added J-MAG sensor's frames diagram.

   Version 0.3 -- April 25, 2016 -- Jorge Diaz del Rio, ODC Space

      Preliminary Version. Updated to include frames for RIME, J-MAG, PEP
      and RPWI.

   Version 0.2 -- March 06, 2016 -- Jorge Diaz del Rio, ODC Space

      Preliminary Version. Updated to include frames for GALA, JANUS, MAJIS
      SWI and UVS.

   Version 0.1 -- January 19, 2016 --  Marc Costa Sitja, ESAC/ESA

      Preliminary Version. Updated to use Cosmographia based on initial
      release for SOLab.

   Version 0.0 -- November 23, 2015 -- Jorge Diaz del Rio, ODC Space

      Initial Release: very preliminary draft for its use in WGC.

   Version 0.0-draft -- March 15, 2012 -- Marc Costa Sitja, ESAC/ESA

      Draft release for use in SOLab.


References
-----------------------------------------------------------------------------

    1. ``Frames Required Reading'', NAIF

    2. ``Kernel Pool Required Reading'', NAIF

    3. ``C-Kernel Required Reading'', NAIF

    4. ``JUICE - Jupiter Icy Moons Explorer. Experiment Interface Document
       part A,'' JUI-EST-SYS-EID-001, Issue 2.5, 18/06/2015

    5. ``JUICE - Jupiter Icy Moons Explorer. Exploring the emergence of
       habitable worlds around gas giants. Definition Study report,''
       ESA/SRE(2014)1, September 2014 (JUICE Red book v1.0)

    6. ``JUICE - JUpiter Icy Moons Explorer SWI - Submillimetre Wave
       Instrument. Experiment Interface Document EID-B,'' JUI-MPS-SWI-EID-001
       Issue 4.3, 17 July 2015

    7. ``JUICE - JUpiter Icy Moons Explorer MAJIS - Moons And Jupiter Imaging
       Spectrometer Experiment Interface Document - Part B,''
       JUI-IAS-MAJ-EID-001 Issue 1.2, 30 January 2014

     8. ``JANUS - Camera for the ESA JUICE mission Experiment Interface
        Document - Part B,'' JUI-JAC-JAN-EID-B-001, Issue 0.7, 10 November
        2015

    9. ``Radar for Icy Moon Exploration (RIME) - Experiment Interface Document
         Part B,'' JUI-UTR-RIM-EID-001, Issue 5.2, 1 December 2014

   10. ``JUICE - JUpiter ICy moons Explorer J-MAG (Magnetometer) Experiment
       Interface Document - Part B,'' JUICE-ICL-MAG-EID-B, Issue 2.4, 7 April
       2016

   11. ``JUICE - JUpiter Icy Moons Explorer RPWI (Radio & Plasma Waves
       Investigation) Experiment Interface Document - Part B,''
       JUICE-IRF-RPWI-EID-003, Issue 2.1, 16 June 2013

   12. ``JUICE - JUpiter Icy Moons Explorer PEP (Particle Environment Package)
       Experiment Interface Document - Part B,'' JUI-UBE-PEP-EID-001,
       Issue 2.1, 3 May 2013

   13. JUICE Spacecraft Structures SPK and comments, latest version.

   14. ``AOCS Analyses Report'', JUI-ADST-SYS-RP-000130, Issue 1,
       Airbus Defense and Space, 4 December 2015

   15. ``JUICE Spacecraft Design Report'', JUI-ADST-SYS-DD-000122, Issue 1,
       Airbus Defense and Space, 4 December 2015

   16. ``JUICE - JUpiter Icy Moons Explorer PEP (Particle Environment Package)
       Experiment Interface Document - Part B,'' JUI-UBE-PEP-EID-001,
       Issue 4.3, 29 April 2016

   17. ``PEP sensor fields of view obstructions by s/c elements'',
       JUI-ADST-SYS-TN-000159, Issue 1, Airbus Defence and Space SAS,
       27 May 2016

   18. ``JUICE Medium Gain Antenna Main Assembly'', JUI-SEN-MGA-OF-0002,
       Revision 1, SENER, 25 January 2016

   19. ``PEP Sensors Field of View'', JUI-IRF-PEP-DD-0XX, Issue 0, Revision 2,
       Gabriella Stenberg Wieser, 8th February 2017.


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service at ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           marc.costa@esa.int, esa_spice@sciops.esa.int

   or NAIF at JPL:

           Boris Semenov
           (818) 354-8136
           Boris.Semenov@jpl.nasa.gov


Implementation Notes
-----------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".  The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

          cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

          furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy


JUICE Mission NAIF ID Codes
-----------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the JUICE
   spacecraft, its structures and science instruments (the keywords
   implementing these definitions are located in the section "JUICE
   Mission NAIF ID Codes -- Definition Section" at the end of this
   file):

      JUICE Spacecraft and Spacecraft Structures names/IDs:

            JUICE                     -28     (synonym:
                                                  JUPITER ICY MOONS EXPLORER)

            JUICE_SPACECRAFT          -28000  (synonym: JUICE_SC)
            JUICE_SA+Y_ZERO           -28010
            JUICE_SA+Y                -28011
            JUICE_SA-Y_ZERO           -28012
            JUICE_SA-Y                -28013

            JUICE_HGA                 -28020
            JUICE_HGA_X               -28021
            JUICE_HGA_KA              -28022

            JUICE_MAG_BOOM            -28031

            JUICE_MGA                 -28044

            JUICE_LGA+X               -28045
            JUICE_LGA-X               -28046

            JUICE_NAVCAM-1            -28051
            JUICE_NAVCAM-2            -28052

            JUICE_STR-OH1             -28061
            JUICE_STR-OH2             -28062
            JUICE_STR-OH3             -28063

            JUICE_RADEM
            JUICE_RADEM_PT
            JUICE_RADEM_ES

            JUICE_JMC-1               -28081
            JUICE_JMC-1               -28082
            JUICE_JMU-1               -28083
            JUICE_JMU-2               -28084


      Natural Bodies and Models names/IDS:

            JUICE_IO_PLASMA_TORUS     -28968


      GALA names/IDs:

            JUICE_GALA                -28100
            JUICE_GALA_LHM            -28110
            JUICE_GALA_RXT            -28120

      JANUS names/IDs:

            JUICE_JANUS               -28200

      J-MAG names/IDs:

            JUICE_JMAG_MAGIBS         -28300
            JUICE_JMAG_MAGOBS         -28310
            JUICE_JMAG_MAGSCA         -28320
            JUICE_JMAG_JACS-X         -28330
            JUICE_JMAG_JACS-Y         -28331

      MAJIS names/IDs:

            JUICE_MAJIS               -28400
            JUICE_MAJIS_VISNIR        -28410
            JUICE_MAJIS_VISNIR_B2     -28412
            JUICE_MAJIS_VISNIR_B4     -28414
            JUICE_MAJIS_IR            -28420
            JUICE_MAJIS_IR_B2         -28422
            JUICE_MAJIS_IR_B4         -28424

      PEP names/IDs:

            JUICE_PEP_JDC             -28510
            JUICE_PEP_JNA             -28520
            JUICE_PEP_NIM             -28530
            JUICE_PEP_NIM_NEUION      -28531
            JUICE_PEP_NIM_NEUION_S0   -28532
            JUICE_PEP_NIM_NEUION_S1   -28533
            JUICE_PEP_NIM_NEUION_S2   -28534
            JUICE_PEP_NIM_NEUION_S3   -28535
            JUICE_PEP_NIM_NEUION_S4   -28536
            JUICE_PEP_NIM_NEUION_S5   -28537
            JUICE_PEP_NIM_THERMAL-1   -28538
            JUICE_PEP_NIM_THERMAL-2   -28539
            JUICE_PEP_JEI             -28540
            JUICE_PEP_JOEE            -28550
            JUICE_PEP_JENI            -28560
            JUICE_PEP_JDC_PIXEL_NNN   -28510NN*
            JUICE_PEP_JNA_SECTOR_NN   -2852NN**
            JUICE_PEP_JEI_NN_M        -28520NN***

         * There are NNN NAIF ID codes for the JUICE_PEP_JDC_PIXEL elements.
           NNN is the pixel number and ranges from 000 to 191.

         ** There are NN NAIF ID codes for the JUICE_PEP_JNI_SENSOR elements.
            NN is the sector number and ranges from 00 to 11.

         *** For each M (L, M and H) there are NN NAIF ID codes for the
             JUICE_PEP_JEI elements. NN is the azimuthal sector number and
             ranges from 00 to 15.

      RIME names/IDs:

            JUICE_RIME_BASE           -28600
            JUICE_RIME                -28601

      RPWI names/IDs:

            JUICE_RPWI_LPB1           -28701
            JUICE_RPWI_LP1            -28705
            JUICE_RPWI_LPB2           -28711
            JUICE_RPWI_LP2            -28715
            JUICE_RPWI_LPB3           -28721
            JUICE_RPWI_LP3            -28725
            JUICE_RPWI_LPB4           -28731
            JUICE_RPWI_LP4            -28735
            JUICE_RPWI_RWI            -28740
            JUICE_RPWI_RWI_EX         -28741
            JUICE_RPWI_RWI_EY         -28742
            JUICE_RPWI_RWI_EZ         -28743
            JUICE_RPWI_SCM            -28750

      SWI names/IDs:

            JUICE_SWI_FULL            -28800
            JUICE_SWI_FULL_GCO500     -28801
            JUICE_SWI_CH1             -28810
            JUICE_SWI_CH2             -28820

      UVS names/IDs:

            JUICE_UVS                 -28850
            JUICE_UVS_AP              -28851
            JUICE_UVS_AP_NARROW       -28852
            JUICE_UVS_AP_WIDE         -28853
            JUICE_UVS_HP              -28860
            JUICE_UVS_SP              -28870


JUICE Mission Frames
-----------------------------------------------------------------------------

   The following JUICE frames are defined in this kernel file:

           Name                  Relative to           Type          NAIF ID
      ======================  =====================  ============   =========

   Spacecraft frames:
   -----------------
      JUICE_SPACECRAFT        J2000                  CK                -28000
      JUICE_SA+Y_ZERO         JUICE_SPACECRAFT       FIXED             -28010
      JUICE_SA+Y              JUICE_SA+Y_ZERO        CK                -28011
      JUICE_SA-Y_ZERO         JUICE_SPACECRAFT       FIXED             -28012
      JUICE_SA-Y              JUICE_SA-Y_ZERO        CK                -28013

      JUICE_HGA               JUICE_SPACECRAFT       FIXED             -28020
      JUICE_HGA_X             JUICE_HGA              FIXED             -28021
      JUICE_HGA_KA            JUICE_HGA              FIXED             -28022

      JUICE_MAG_BOOM-H        JUICE_SPACECRAFT       FIXED             -28030
      JUICE_MAG_BOOM          JUICE_MAG_BOOM-H       CK                -28031

      JUICE_MGA_APM           JUICE_SPACECRAFT       FIXED             -28040
      JUICE_MGA_AZ            JUICE_MGA_APM          CK                -28041
      JUICE_MGA_EL_ZERO       JUICE_MGA_AZ           FIXED             -28042
      JUICE_MGA_EL            JUICE_MGA_EL_ZERO      CK                -28043
      JUICE_MGA               JUICE_MGA_EL           FIXED             -28044

      JUICE_LGA+X             JUICE_SPACECRAFT       FIXED             -28045
      JUICE_LGA-X             JUICE_SPACECRAFT       FIXED             -28046

      JUICE_NAVCAM-1          JUICE_SPACECRAFT       FIXED             -28051
      JUICE_NAVCAM-2          JUICE_SPACECRAFT       FIXED             -28051

      JUICE_STR-OH1           JUICE_SPACECRAFT       FIXED             -28061
      JUICE_STR-OH2           JUICE_SPACECRAFT       FIXED             -28062
      JUICE_STR-OH3           JUICE_SPACECRAFT       FIXED             -28063

      JUICE_JMC-1             JUICE_SPACECRAFT       FIXED             -28081
      JUICE_JMC-2             JUICE_SPACECRAFT       FIXED             -28082

   GALA frames:
   ------------
      JUICE_GALA_BASE         JUICE_SPACECRAFT       FIXED             -28100
      JUICE_GALA_LHM          JUICE_GALA_BASE        FIXED             -28110
      JUICE_GALA_RXT          JUICE_GALA_BASE        FIXED             -28120

   JANUS frames:
   -------------
      JUICE_JANUS             JUICE_SPACECRAFT       FIXED             -28200

   J-MAG frames:
   -------------
      JUICE_JMAG_MAGIBS       JUICE_MAG_BOOM         FIXED             -28300
      JUICE_JMAG_MAGOBS       JUICE_MAG_BOOM         FIXED             -28310
      JUICE_JMAG_MAGSCA       JUICE_MAG_BOOM         FIXED             -28320

   MAJIS frames:
   -------------
      JUICE_MAJIS_BASE        JUICE_SPACECRAFT       FIXED             -28400
      JUICE_MAJIS_SCAN        JUICE_MAJIS_BASE       CK                -28401
      JUICE_MAJIS_VISNIR      JUICE_MAJIS_SCAN       FIXED             -28410
      JUICE_MAJIS_IR          JUICE_MAJIS_SCAN       FIXED             -28420

   PEP frames:
   ------------
      JUICE_PEP_NU            JUICE_SPACECRAFT       FIXED             -28500
      JUICE_PEP_JDC           JUICE_PEP_NU           FIXED             -28510
      JUICE_PEP_JNA           JUICE_PEP_NU           FIXED             -28520
      JUICE_PEP_NIM           JUICE_PEP_NU           FIXED             -28530
      JUICE_PEP_JEI           JUICE_SPACECRAFT       FIXED             -28540
      JUICE_PEP_JOEE          JUICE_SPACECRAFT       FIXED             -28550
      JUICE_PEP_JENI          JUICE_SPACECRAFT       FIXED             -28560

   RIME frames:
   ------------
      JUICE_RIME_BASE         JUICE_SPACECRAFT       FIXED             -28600
      JUICE_RIME              JUICE_RIME_BASE        CK                -28601
      JUICE_RIME_NADC         JUICE_RIME_BASE        DYNAMIC           -28610
      JUICE_RIME_NADE         JUICE_RIME_BASE        DYNAMIC           -28611
      JUICE_RIME_NADG         JUICE_RIME_BASE        DYNAMIC           -28612
      JUICE_RIME_NADJ         JUICE_RIME_BASE        DYNAMIC           -28613

   RPWI frames:
   ------------
      JUICE_RPWI_LPB1-H       JUICE_SPACECRAFT       FIXED             -28700
      JUICE_RPWI_LBP1         JUICE_RPWI_LPB1-H      CK                -28701
      JUICE_RPWI_LP1          JUICE_RPWI_LPB1        FIXED             -28705
      JUICE_RPWI_LPB2-H       JUICE_SPACECRAFT       FIXED             -28710
      JUICE_RPWI_LBP2         JUICE_RPWI_LPB2-H      CK                -28711
      JUICE_RPWI_LP2          JUICE_RPWI_LPB2        FIXED             -28715
      JUICE_RPWI_LPB3-H       JUICE_SPACECRAFT       FIXED             -28720
      JUICE_RPWI_LBP3         JUICE_RPWI_LPB3-H      CK                -28721
      JUICE_RPWI_LP3          JUICE_RPWI_LPB3        FIXED             -28725
      JUICE_RPWI_LPB4-H       JUICE_SPACECRAFT       FIXED             -28730
      JUICE_RPWI_LBP4         JUICE_RPWI_LPB4-H      CK                -28731
      JUICE_RPWI_LP4          JUICE_RPWI_LPB4        FIXED             -28735
      JUICE_RPWI_RWI          JUICE_MAG_BOOM         FIXED             -28740
      JUICE_RPWI_RWI_EX       JUICE_RPWI_RWI         FIXED             -28741
      JUICE_RPWI_RWI_EY       JUICE_RPWI_RWI         FIXED             -28742
      JUICE_RPWI_RWI_EZ       JUICE_RPWI_RWI         FIXED             -28743
      JUICE_RPWI_SCM          JUICE_MAG_BOOM         FIXED             -28750

   SWI frames:
   -----------
      JUICE_SWI_BASE          JUICE_SPACECRAFT       FIXED             -28800
      JUICE_SWI_SCANNER       JUICE_SWI_BASE         CK                -28810

   UVS frames:
   -----------
      JUICE_UVS               JUICE_SPACECRAFT       FIXED             -28850
      JUICE_UVS_SP            JUICE_UVS              FIXED             -28870


   In addition, the following frames, in use by the JUICE mission, are
   defined in other kernels or `built into' the SPICE system:

           Name                     Relative to            Type       NAIF ID
      ==========================   =====================  ========   =========

   JUICE mission science operations frames (1):
   --------------------------------------------
      JUICE_EARTH_COMMS            J2000                   DYNAMIC      -28900
      JUICE_JUPITER_NOA            J2000                   DYNAMIC      -28905
      JUICE_CALLISTO_NOA           J2000                   DYNAMIC      -28906
      JUICE_EUROPA_NOA             J2000                   DYNAMIC      -28907
      JUICE_GANYMEDE_NOA           J2000                   DYNAMIC      -28908
      JUICE_JUPITER_NPO            J2000                   DYNAMIC      -28910
      JUICE_CALLISTO_NPO           J2000                   DYNAMIC      -28911
      JUICE_EUROPA_NPO             J2000                   DYNAMIC      -28912
      JUICE_GANYMEDE_NPO           J2000                   DYNAMIC      -28913
      JUICE_IO_NPO                 J2000                   DYNAMIC      -28914
      JUICE_JUPITER_RAM            J2000                   DYNAMIC      -28915
      JUICE_CALLISTO_RAM           J2000                   DYNAMIC      -28916
      JUICE_EUROPA_RAM             J2000                   DYNAMIC      -28917
      JUICE_GANYMEDE_RAM           J2000                   DYNAMIC      -28918


      (1) These frames are defined in the frame kernel file
          "juice_ops_vVV.tf" In order to use them with this frames kernel,
          additional fixed-offset frames kernel(s) need to be loaded. See the
          section ``Using these frames'' in the "juice_ops_vVV.tf" comment
          area for further details (VV is the version number).


   JUICE mission specific science frames (2):
   ------------------------------------------
      JUICE_JUPITER_IF_J2000       J2000                   FIXED        -28970
      JUICE_JUPITER_MAG_S3RH1965   JUPITER_SYSTEM3RH_1965  FIXED        -28971
      JUICE_JUPITER_MAG_S3RH2009   JUPITER_SYSTEM3RH_2009  FIXED        -28972

      JUICE_JSEQ                   J2000                   DYNAMIC      -28973
      JUICE_JUPITER_BSM            J2000                   DYNAMIC      -28974
      JUICE_JUPITER_SJC            J2000                   DYNAMIC      -28975
      JUICE_JSM                    J2000                   DYNAMIC      -28976
      JUICE_JSW                    JUPITER_SUN_ORB         FIXED        -28977
      JUICE_JSWM                   JUICE_JUPITER_BSM       FIXED        -28978

      JUICE_CALLISTO_PHI_ORB       J2000                   DYNAMIC      -28980
      JUICE_EUROPA_PHI_ORB         J2000                   DYNAMIC      -28981
      JUICE_GANYMEDE_PHI_ORB       J2000                   DYNAMIC      -28982

      JUICE_HGRTN                  J2000                   DYNAMIC      -28990
      JUICE_SUN_RTN                J2000                   DYNAMIC      -28991
      JUICE_JUPITER_DM             J2000                   DYNAMIC      -28992
      JUICE_JUPITER_RTP            J2000                   DYNAMIC      -28993


   Jupiter System generic frames (2):
   ----------------------------------
      JUPITER_SYSTEM3RH_1965       J2000                   PCK          -28999
      JUPITER_SYSTEM3RH_2009       J2000                   PCK          -28998
      JUPITER_MAG_VIP4             IAU_JUPITER             FIXED        -28997

      JUPITER_MEQUD                J2000                   DYNAMIC   500599000
      JUPITER_SUN_EQU              J2000                   DYNAMIC   500599001
      JUPITER_SUN_ORB              J2000                   DYNAMIC   500599002

      JUPITER_CALLISTO_BCSF        J2000                   DYNAMIC   500599006
      JUPITER_EUROPA_BCSF          J2000                   DYNAMIC   500599004
      JUPITER_GANYMEDE_BCSF        J2000                   DYNAMIC   500599005

      CALLISTO_JUPITER_ORB         J2000                   DYNAMIC   500504000
      EUROPA_JUPITER_ORB           J2000                   DYNAMIC   500502000
      GANYMEDE_JUPITER_ORB         J2000                   DYNAMIC   500503000

      (2) These frames are defined in the frame kernel file
          "juice_sci_vVV.tf" (VV is the version number)


   SPICE 'Built-in' PCK frames in use by JUICE (3):
   ------------------------------------------------
      IAU_CALLISTO                 J2000                   PCK        built-in
      IAU_EUROPA                   J2000                   PCK        built-in
      IAU_JUPITER                  J2000                   PCK        built-in
      IAU_GANYMEDE                 J2000                   PCK        built-in

      (3) Data for these frames is loaded using either the PCK file
          "pckVVVVV.tpc" or one of the mission specific PCK files
          "juice_jupVVV.tpc" (VVV is the version number)


JUICE Frames Hierarchy
-----------------------------------------------------------------------------

   The diagram below shows the JUICE frames hierarchy (except the science
   operations frames):

                                                                  "JUICE_HGRTN"
                                                                  -------------
                                                                              ^
                                                                              |
                                                                         dyn->|
                                                                              |
                                                           "JUICE_JUPITER_DM" |
                                                           ------------------ |
                                                                           ^  |
                                                                           |  |
                                                                      dyn->|  |
                                                                           |  |
                                                     "JUICE_JUPITER_BEQXS" |  |
                                                     --------------------- |  |
                                                                        ^  |  |
                             "JUICE_JUPITER_MAGS_3RH2009"               |  |  |
                             ----------------------------          dyn->|  |  |
                                                ^                       |  |  |
                                                |   "JUICE_JUPITER_SJC" |  |  |
                                         fixed->|   ------------------- |  |  |
                                                |                    ^  |  |  |
                                "JUICE_JSW"     |                    |  |  |  |
                                -----------     |               dyn->|  |  |  |
    "JUPITER_MAG_VIP4"                ^         |                    |  |  |  |
    ------------------                |         |    "JUICE_SUN_RTN" |  |  |  |
           ^                   fixed->|         |    --------------- |  |  |  |
           |                          |         |                 ^  |  |  |  |
    fixed->| "IAU_EUROPA"   "JUPITER_SUN_ORB"   |                 |  |  |  |  |
           | ------------   -----------------   |            dyn->|  |  |  |  |
           |      ^                  ^          |                 |  |  |  |  |
   "IAU_JUPITER"  |  "IAU_GANYMEDE"  |   "JUPITER_SYSTEM3RH_2009" |  |  |  |  |
   -------------  |  --------------  |   ------------------------ |  |  |  |  |
        ^         |         ^        |                          ^ |  |  |  |  |
        |         |         |        | "JUICE_JUPITER_IF_J2000" | |  |  |  |  |
        |         |         |        | ------------------------ | |  |  |  |  |
        |         |         |        |  ^                       | |  |  |  |  |
        |    pck->|         |   dyn->|  |                fixed->| |  |  |  |  |
        |         |    pck->|        |  |<-fixed                | |  |  |  |  |
        |<-pck    |         |        |  |                       | |  |  |  |  |
        |         |         |        |  |    "J2000" Inertial   | |  |  |  |  |
   +--------------------------------------------------------------------------+
   |           |    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
   |<-pck      |    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
   |           |    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
   |      pck->|    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
   v           |    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
   "IAU_EARTH" |    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
   ----------- |    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
               v    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
     "IAU_CALLISTO" |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
     -------------- |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
                    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
               dyn->|    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
                    |    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
                    v    |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
     "JUICE_JUPITER_RTP" |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
     ------------------- |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
                         |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
                  fixed->|    |   |    |   |   |   |   |   |   |  |  |  |  |  |
                         |    |   |    |   |   |   |   |   |   |  |  |  |  |  |
                         v    |   |    |   |   |   |   |   |   |  |  |  |  |  |
     "JUPITER_SYSTEM3RH_1965" |   |    |   |   |   |   |   |   |  |  |  |  |  |
     ------------------------ |   |    |   |   |   |   |   |   |  |  |  |  |  |
          |                   |   |    |   |   |   |   |   |   |  |  |  |  |  |
          |                   |   |    |   |   |   |   |   |   |  |  |  |  |  |
          |              dyn->|   |    |   |   |   |   |   |   |  |  |  |  |  |
          |                   |   |    |   |   |   |   |   |   |  |  |  |  |  |
          |                   v   |    |   |   |   |   |   |   |  |  |  |  |  |
          |           "JUICE_JSM" |    |   |   |   |   |   |   |  |  |  |  |  |
          |           ----------- |    |   |   |   |   |   |   |  |  |  |  |  |
          |                       |    |   |   |   |   |   |   |  |  |  |  |  |
          |                  dyn->|    |   |   |   |   |   |   |  |  |  |  |  |
          |                       |    |   |   |   |   |   |   |  |  |  |  |  |
          |                       v    |   |   |   |   |   |   |  |  |  |  |  |
          |       "JUICE_JUPITER_BSM"  |   |   |   |   |   |   |  |  |  |  |  |
          |       -------------------  |   |   |   |   |   |   |  |  |  |  |  |
          |             |              |   |   |   |   |   |   |  |  |  |  |  |
          |             |         dyn->|   |   |   |   |   |   |  |  |  |  |  |
          |             |              |   |   |   |   |   |   |  |  |  |  |  |
          |             |              v   |   |   |   |   |   |  |  |  |  |  |
          |      fixed->|  "JUPITER_MEQUD" |   |   |   |   |   |  |  |  |  |  |
          |             |  --------------- |   |   |   |   |   |  |  |  |  |  |
          |             v                  |   |   |   |   |   |  |  |  |  |  |
          |       "JUICE_JSWM"        dyn->|   |   |   |   |   |  |  |  |  |  |
          |       ------------             |   |   |   |   |   |  |  |  |  |  |
          |                                v   |   |   |   |   |  |  |  |  |  |
          |<-fixed          "JUPITER_SUN_EQU"  |   |   |   |   |  |  |  |  |  |
          |                 -----------------  |   |   |   |   |  |  |  |  |  |
          V                                    |   |   |   |   |  |  |  |  |  |
     "JUICE_JUPITER_MAG_S3RH1965"         dyn->|   |   |   |   |  |  |  |  |  |
     ----------------------------              |   |   |   |   |  |  |  |  |  |
                                               v   |   |   |   |  |  |  |  |  |
                          "JUPITER_GANYMEDE_BCSF"  |   |   |   |  |  |  |  |  |
                          -----------------------  |   |   |   |  |  |  |  |  |
                                                   |   |   |   |  |  |  |  |  |
                                              dyn->|   |   |   |  |  |  |  |  |
                                                   |   |   |   |  |  |  |  |  |
                                                   v   |   |   |  |  |  |  |  |
                                "JUPITER_EUROPA_BCSF"  |   |   |  |  |  |  |  |
                                ---------------------  |   |   |  |  |  |  |  |
                                                       |   |   |  |  |  |  |  |
                                                  dyn->|   |   |  |  |  |  |  |
                                                       |   |   |  |  |  |  |  |
                                                       v   |   |  |  |  |  |  |
                                  "JUPITER_CALLISTO_BCSF"  |   |  |  |  |  |  |
                                  -----------------------  |   |  |  |  |  |  |
                                                           |   |  |  |  |  |  |
                                                      dyn->|   |  |  |  |  |  |
                                                           |   |  |  |  |  |  |
                                                           v   |  |  |  |  |  |
                                       "GANYMEDE_JUPITER_ORB"  |  |  |  |  |  |
                                       ----------------------  |  |  |  |  |  |
                                                               |  |  |  |  |  |
                                                          dyn->|  |  |  |  |  |
                                                               |  |  |  |  |  |
                                                               v  |  |  |  |  |
                                             "EUROPA_JUPITER_ORB" |  |  |  |  |
                                             -------------------- |  |  |  |  |
                                                                  |  |  |  |  |
                                                             dyn->|  |  |  |  |
                                                                  |  |  |  |  |
                                                                  v  |  |  |  |
                                              "CALLISTO_JUPITER_ORB" |  |  |  |
                                              ---------------------- |  |  |  |
                   "JUICE_MGA"                                       |  |  |  |
                   -----------                                  dyn->|  |  |  |
                        ^                                            |  |  |  |
                        |                                            v  |  |  |
                 fixed->|                      "JUICE_CALLISTO_PHI_ORB" |  |  |
                        |                      ------------------------ |  |  |
                 "JUICE_MGA_EL"                                         |  |  |
                 --------------                                    dyn->|  |  |
                        ^                                               |  |  |
                        |                                               v  |  |
                    ck->|                           "JUICE_EUROPA_PHI_ORB" |  |
                        |                           ---------------------- |  |
               "JUICE_MGA_EL_ZERO"                                         |  |
               ------------------                                     dyn->|  |
                        ^                                                  |  |
                        |                                                  v  |
                 fixed->|                            "JUICE_GANYMEDE_PHI_ORB" |
                        |                             ----------------------  |
                 "JUICE_MGA_AZ"                                               |
                 --------------                                               |
                        ^                                                 ck->|
                        |                               "JUICE_SA-Y"          |
                    ck->|                               ------------          |
                        |                                    ^                |
                  "JUICE_MGA_APM"                            |                |
                  --------------                             |<-ck            |
                        ^                                    |                |
                        |                            "JUICE_SA-Y_ZERO"        |
        "JUICE_HGA_KA"  |                            -----------------        |
        --------------  |                             ^                       |
                    ^   |                             |                       |
                    |   |                             |     "JUICE_SA+Y"      |
     "JUICE_HGA_X"  |   |                             |     ------------      |
     -------------  |   |                             |          ^            |
      ^             |   |                             |<-fixed   |            |
      |      fixed->|   |                             |          |<-ck        |
      |<-fixed      |   |                             |          |            |
      |             |   |                             |  "JUICE_SA+Y_ZERO"    |
      | "JUICE_HGA" |   | "JUICE_LGA+X" "JUICE_LGA-X" |  ----------------     |
      +-------------+   | ------------- ------------- |  ^                    |
             ^          |   ^                     ^   |  |                    |
             |   fixed->|   |                     |   |  |<-fixed             |
             |          |   |<-fixed       fixed->|   |  |                    |
             |<-fixed   |   |                     |   |  |                    |
             |          |   | "JUICE_SPACECRAFT"  |   |  |                    v
   +--------------------------------------------------------------------------+
            |         |  |        .           |        |  |  |          |
     fixed->|  fixed->|  |        .    fixed->| fixed->|  |  |   fixed->|
            |         |  |        .           |        |  |  |          |
            v         |  |        .           v        |  |  |          v
   "JUICE_MAG_BOOM-H" |  |        .  "JUICE_NAVCAM-1"  |  |  | "JUICE_STR-OH3"
   ------------------ |  |        .  ----------------  |  |  | ---------------
           |          |  |        .                    |  |  |
           |<-ck      |  |        .                    v  |  |
           |          |  |        .      "JUICE_NAVCAM-2" |  |
           v          |  |        .      ---------------- |  |
     "JUICE_MAG_BOOM" |  |        .                       |  |
     ---------------- |  |        .                fixed->|  |
                      |  |        .                       |  |
                      |  |        .                       v  |
                      v  |        .          "JUICE_STR-OH1" |
          "JUICE_JMC-1"  |        .          --------------- |
         --------------  |        .                          |
                         |        .                   fixed->|
                  fixed->|        .                          |
                         v        .                          v
             "JUICE_JMC-2"        .             "JUICE_STR-OH2"
            --------------        .             ---------------
                                  .
                                  .
                                  v
               Individual instrument frame trees are provided
                 in the corresponding sections of this file


JUICE Spacecraft Bus Frame
--------------------------------------------------------------------------

   The spacecraft frame is defined by the s/c design as follows [4]:

      -  +Z is perpendicular to the launch vehicle interface plane
         and points toward the payload side, through the spacecraft
         in the launch direction;

      -  -X axis is perpendicular to the HGA mounting plane and points
         in the direction of the nominal HGA boresight;

      -  +Y axis completes the right-handed frame.

      -  the origin of this frame is the launch vehicle interface point,
         located at the separation plane between the spacecraft and the
         launch adapter, in the centre of the launch adapter.


   These diagrams illustrate the JUICE_SPACECRAFT frame:

   +X s/c side (opposite to HGA side) view:
   ----------------------------------------

                                       ^
          .---------.                  | Nadir            .---------.
          |         |                  |                  |         |
          |         |             Science Deck            |         |
          '----.----'              .-------.              '----.----'
   /----. .----'----. .---------._ |       | _.---------. .----'----. .-----\
   \    |_|         |_|         | \|       |/ |         |_|         |_|     /
   /    | |         | |         |_/|   ^   |\_|         | |         | |     \
   \----' '----.----' '---------'  |   |+Zsc  '---------' '----.----' '-----/
          .----'----.              '---|---'              .----'----.
          |         |                / | \   +Ysc         |         |
          |         |                '-o------>           |         |
          '---------'                +Xsc                 '---------'
                                      (out of the page)


   -Y s/c side view:
   -----------------
                              ^
                          ~~  |
                          ||  | Nadir direction
                          ||  |
                          oo  |
              .    .------||------.
              |`.  | Science Deck |
          HGA |  \ |      ||      |
              |   \|      ||      |
              |    |      ||      |
              |    |     /||\     |
              |    x     \||/     |
              |    |      ||      |
              |    |      |'^     |
              |   /|      |'|+Zsc |
              |  / |      |'|     |
              |.'  |      |'|     |
                   '------|'|-----'  +Xsc
                       /__oox---------->
                          || +Ysc
                          ||  (into de page)
                          ~~


   Since the s/c bus attitude with respect to an inertial frame is provided
   by a C-kernel (see [3] for more information), this frame is defined as
   a CK-based frame.

   \begindata

      FRAME_JUICE_SPACECRAFT        = -28000
      FRAME_-28000_NAME             = 'JUICE_SPACECRAFT'
      FRAME_-28000_CLASS            = 3
      FRAME_-28000_CLASS_ID         = -28000
      FRAME_-28000_CENTER           = -28000
      CK_-28000_SCLK                = -28
      CK_-28000_SPK                 = -28

   \begintext


JUICE Solar Array Frames
--------------------------------------------------------------------------

   JUICE solar arrays are articulated (having one degree of freedom),
   therefore the Solar Array frames, JUICE_SA+Y and JUICE_SA-Y, are
   defined as CK frames with their orientation given relative to
   JUICE_SA+Y_ZERO and JUICE_SA-Y_ZERO respectively.

   JUICE_SA+Y_ZERO and JUICE_SA-Y_ZERO are two ``fixed-offset'' frames,
   defined with respect to JUICE_SPACECRAFT, as follows:

      -  +Y is parallel to the longest side of the array, positively
         oriented from the yoke to the end of the wing;

      -  +Z is aligned to the spacecraft bus +Z, pointing on the
         nominal direction of nadir;

      -  +X completes the right-handed frame.

      -  the origin of the frame is located at the yoke geometric
         center.


   Both Solar Array frames (JUICE_SA+Y and JUICE_SA-Y) are defined as
   follows:

      -  +Y is parallel to the longest side of the array, positively oriented
         from the yoke to the end of the wing;

      -  +Z is normal to the solar array plane, the solar cells facing +Z;

      -  +X completes the right-handed frame;

      -  the origin of the frame is located at the yoke geometric center.


   The axis of rotation is parallel to the Y axis of the spacecraft and the
   solar array frames. Please note that in all the diagrams of this file the
   Solar Arrays are rotated 90 degrees.

   This diagram illustrates the JUICE_SA+Y and JUICE_SA-Y frames:


   -X s/c side (HGA side) view:
   ----------------------------


   \--------.                       ^                        .--------/
   /        |                       | Nadir                  |        \
   \        |                       |                        |        /
   /        |     +Zsa+y_zero ^.---------.^ +Zsa-y_zero      |        \
   \-.------'                 ||         ||                  '------.-/
   /-"------. .-------------. ||  .---.  ||  .-------------. .------"-\
   \        | | +Ysa+y_zero |-||/ HGA   \||,-|             | |        /
   /        |=|       <-------x|    x    |o------->        |=|        \
   \        | |             |_/|\       /| \_|   +Ysa-y_zero |        /
   /-.------' '-------------'  | '.___.' |   '-------------' '------.-\
   \-"------.                  '---------'                   .------"-/
   /        |                     /   \                      |        \
   \        |                     '---'                      |        /
   /        |      ^ +Zsc      Main Engine                   |        \
   \--------'      |                                         '--------/
                   |
          +Ysc     |
          <--------x                           +Xsc is into the page
                    +Xsc                       +Xsa+y_zero is into the page
                                               +Zsa-y_zero is out of the page


   These sets of keywords define solar array frames:

   \begindata

      FRAME_JUICE_SA+Y_ZERO           = -28010
      FRAME_-28010_NAME               = 'JUICE_SA+Y_ZERO'
      FRAME_-28010_CLASS              =  4
      FRAME_-28010_CLASS_ID           = -28010
      FRAME_-28010_CENTER             = -28011
      TKFRAME_-28010_RELATIVE         = 'JUICE_SPACECRAFT'
      TKFRAME_-28010_SPEC             = 'ANGLES'
      TKFRAME_-28010_UNITS            = 'DEGREES'
      TKFRAME_-28010_ANGLES           = (    0.0,    0.0,   0.0 )
      TKFRAME_-28010_AXES             = (      3,      2,     1 )

      FRAME_JUICE_SA+Y                = -28011
      FRAME_-28011_NAME               = 'JUICE_SA+Y'
      FRAME_-28011_CLASS              =  3
      FRAME_-28011_CLASS_ID           = -28011
      FRAME_-28011_CENTER             = -28011
      CK_-28011_SCLK                  = -28
      CK_-28011_SPK                   = -28011

      FRAME_JUICE_SA-Y_ZERO           = -28012
      FRAME_-28012_NAME               = 'JUICE_SA-Y_ZERO'
      FRAME_-28012_CLASS              =  4
      FRAME_-28012_CLASS_ID           = -28012
      FRAME_-28012_CENTER             = -28013
      TKFRAME_-28012_RELATIVE         = 'JUICE_SPACECRAFT'
      TKFRAME_-28012_SPEC             = 'ANGLES'
      TKFRAME_-28012_UNITS            = 'DEGREES'
      TKFRAME_-28012_ANGLES           = (   0.0,  180.0,   180.0 )
      TKFRAME_-28012_AXES             = (     3,      2,     1   )

      FRAME_JUICE_SA-Y                = -28013
      FRAME_-28013_NAME               = 'JUICE_SA-Y'
      FRAME_-28013_CLASS              =  3
      FRAME_-28013_CLASS_ID           = -28013
      FRAME_-28013_CENTER             = -28013
      CK_-28013_SCLK                  = -28
      CK_-28013_SPK                   = -28013

   \begintext


JUICE High Gain Antenna Frames
--------------------------------------------------------------------------

   JUICE spacecraft has a 2.4m diameter High Gain Antenna in X- and Ka-bands
   for nominal operations, Science data download and Radio Science
   Experiments. It is used as a sunshield during the cruise phase when close
   to the Sun.

   The JUICE High Gain Antenna, HGA, is rigidly attached to
   the -X side of the spacecraft bus. Therefore, the JUICE High Antenna
   frame, JUICE_HGA, is defined as a fixed offset frame with its orientation
   given relative to the JUICE_SPACECRAFT frame.

   The JUICE_HGA frame is defined as follows:

      -  +Z axis is in the antenna boresight direction (nominally
         co-aligned to the spacecraft -X axis);

      -  +Y axis is in the direction of the spacecraft +Y axis;

      -  +X completes the right hand frame;

      -  the origin of the frame is located at the geometric center of the
         HGA dish outer rim circle.

   X- and Ka-band antenna frames are defined such that their axes are
   nominally co-aligned with the axes of the JUICE_HGA frame and their
   origins are at the geometric centre of the HGA dish outer rim circle.
   These frames are introduced in order to include any possible misalignments
   between the X- and Ka-band pointing direction (maximum radiation power
   direction and gain).

   This diagram illustrates the JUICE High Gain Antenna frames:


   -Y s/c side view:
   -----------------
                                   ^
                               ~~  |
             +Xhga_ka          ||  | Nadir direction
             +Xhga_x           ||  |
             +Xhga             oo  |
                 ^ .    .------||------.
                 | |`.  | Science Deck |
                 | |  \ |      ||      |
    +Zhga_ka     | |   \|      ||      |
    +Zhga_x      | |    |      ||      |
    +Zhga        |/|    |     /||\     |
     <-----------x |    |     \||/     |
            +Yhga  |    |      ||      |
          +Yhga_x  |    |      |'^     |
         +Yhga_ka  |   /|      |'|+Zsc |
                   |  / |      |'|     |
                   |.'  |      |'|     |
                        '------|'|-----'  +Xsc
                            /__oox---------->
                               || +Ysc
                               ||  (into de page)
                               ~~                      +Ysc is into the page
                                                       +Yhga is into the page


   Nominally a single rotation of -90 degrees about the +Y axis is needed to
   co-align the spacecraft frame with the High Gain Antenna frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_HGA                 =  -28020
      FRAME_-28020_NAME               = 'JUICE_HGA'
      FRAME_-28020_CLASS              =  4
      FRAME_-28020_CLASS_ID           =  -28020
      FRAME_-28020_CENTER             =  -28020
      TKFRAME_-28020_RELATIVE         = 'JUICE_SPACECRAFT'
      TKFRAME_-28020_SPEC             = 'ANGLES'
      TKFRAME_-28020_UNITS            = 'DEGREES'
      TKFRAME_-28020_ANGLES           = ( 0.0,    0.0,   90.0 )
      TKFRAME_-28020_AXES             = (   1,      3,      2 )

      FRAME_JUICE_HGA_X               =  -28021
      FRAME_-28021_NAME               = 'JUICE_HGA_X'
      FRAME_-28021_CLASS              =  4
      FRAME_-28021_CLASS_ID           =  -28021
      FRAME_-28021_CENTER             =  -28020
      TKFRAME_-28021_RELATIVE         = 'JUICE_HGA'
      TKFRAME_-28021_SPEC             = 'ANGLES'
      TKFRAME_-28021_UNITS            = 'DEGREES'
      TKFRAME_-28021_ANGLES           = ( 0.0,    0.0,    0.0 )
      TKFRAME_-28021_AXES             = (   1,      3,      2 )

      FRAME_JUICE_HGA_KA              =  -28022
      FRAME_-28022_NAME               = 'JUICE_HGA_KA'
      FRAME_-28022_CLASS              =  4
      FRAME_-28022_CLASS_ID           =  -28022
      FRAME_-28022_CENTER             =  -28020
      TKFRAME_-28022_RELATIVE         = 'JUICE_HGA'
      TKFRAME_-28022_SPEC             = 'ANGLES'
      TKFRAME_-28022_UNITS            = 'DEGREES'
      TKFRAME_-28022_ANGLES           = ( 0.0,    0.0,    0.0 )
      TKFRAME_-28022_AXES             = (   1,      3,      2 )

   \begintext


JUICE Medium Gain Antenna Frames
--------------------------------------------------------------------------

   The Medium Gain Antenna (MGA) provides communication during cruise when the
   HGA is used as sunshield. At Jupiter, the MGA support the Radio Science
   Experiment (RSE) in parallel to observation by other instruments
   (in nadir pointing). It also supports emergency up- and downlink in safe
   mode. To provide a maximum coverage, the MGA is mounted on a steerable
   boom with two pointing mechanisms.

   The MGA Main Assembly (MGAMA) is accommodated at the -X/-Y/+Z corner of the
   spacecraft. Its Antenna Pointing Mechanism (APM) with two degrees of
   freedom provides a full spherical articulation range.

   To incorporate rotations in the antenna pointing mechanisms gimbals with
   respect to the medium gain antenna the MGA frame chain includes the
   following frames: JUICE_MGA_APM, JUICE_MGA_AZ, JUICE_MGA_EL_ZERO,
   JUICE_MGA_EL and JUICE_MGA.

   The Medium Gain Antenna Poining Mechanishms frame -- JUICE_MGA_APM -- is
   defined as a fixed-offset frame with respect to the JUICE_SPACECRAFT frame
   as follows (from [18]):

      -  +Z is parallel to the JUICE s/c +Z axis;

      -  +X is anti-parallel to the JUICE s/c +X axis;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the APM yoke geometric
         center.


   The JUICE Medium Gain Antenna Azimuth frame -- JUICE_MGA_AZ -- is a CK
   frame based on the JUICE_MGA_APM frame and is rotated an Azmiuth Angle
   about the JUICE_MGA_APM +Z axis, it is defined as follows:

      - +Y axis is rotated an Azimuth Angle from the JUICE_MGA_APM frame +Y
        axis around the JUICE_MGA_APM frame +Z axis;

      - +Z axis is parallel to the JUICE_MGA_APM frame +Z axis;

      - +X completes the right hand frame;

      -  the origin of the frame is located at the APM yoke geometric
         center.


   The JUICE Medium Gain Antenna Elevation Zero frame -- JUICE_MGA_EL_ZERO --
   is defined as a fixed-offset frame fixed-offset frame with respect to the
   JUICE_MGA_AZ frame as follows:

      - +Z axis is anti-parallel to the JUICE_MGA_AZ frame +Z axis;

      - +X axis is anti-parallel to the JUICE_MGA_AZ frame +X axis;

      - +Y completes the right hand frame;

      -  the origin of the frame is located at the APM yoke geometric
         center.


   The JUICE Medium Gain Antenna Elevation frame -- JUICE_MGA_EL -- is a CK
   frame based on the JUICE_MGA_EL_ZERO frame and is rotated an Elevation
   Angle about the JUICE_MGA_EL_ZERO +Y axis, it is defined as follows:

      - +X axis is rotated an Elevation Angle from the JUICE_MGA_EL_ZERO frame
        +X axis around the JUICE_MGA_EL_ZERO frame +Yaxis;

      - +Y axis is parallel to the JUICE_MGA_EL_ZERO frame +Y axis;

      - +Z completes the right hand frame;

      -  the origin of the frame is located at the APM yoke geometric
         center.


   The JUICE Medium Gain Antenna -- JUICE_MGA -- frame is defined a fixed
   offset frame relative to the JUICE_MGA_EL as follows:

      -  +Y axis points from the gimbal toward the antenna dish
         symmetry axis;

      -  +Z axis is in the antenna boresight direction;

      -  +X axis completes the right hand frame;

      -  the origin of the frame is located at the geometric center of
         the MGA dish outer rim circle.


   The MGA stowed position is at Azimuth = -180 deg and Elevation = 180 deg.
   After release, it is driven to a nominal position of Azimuth = 0 deg
   and Elevation = 0 deg. The rotations of the Azimuth and Elevation angles
   are stored in separated segments in CK files.

   These diagrams illustrate the JUICE Medium Gain Antenna Frames:


   -X s/c side (HGA, MGA side) view (MGA in stowed position):
   ----------------------------------------------------------

                                       +Zmga_apm
   \--------.                       ^   ^                    .--------/
   /        |               Nadir   |   |                    |        \
   \        |                       |   |                    |        /
   /        |                  .--------|.                   |        \
   \-.------'              MGA (o)======o------> +Ymga_apm   '------.-/
   /-"------. .-------------.  |  .---.  ||  .-------------. .------"-\
   \        | |             |-.|/ HGA   \||,-|             | |        /
   /        |=|               o|    x    |o------->        |=|        \
   \        | |             |_/|\       /| \_|             | |        /
   /-.------' '-------------'  | '.___.' |   '-------------' '------.-\
   \-"------.                  '---------'                   .------"-/
   /        |                     /   \                      |        \
   \        |                     '---'                      |        /
   /        |      ^ +Zsc      Main Engine                   |        \
   \--------'      |                                         '--------/
                   |
          +Ysc     |
          <--------x                           +Xsc is into the page
                    +Xsc                       +Ymga is out of the page


   +Z s/c side view (MGA):
   -----------------------

                        +Xmga_apm
                +Ymga_az     ^
                       ^     |
                        \    |
                   MGA -)\   |            +Xmga_az
                          \  |          .>
               - Azimuth / \ |  ___ . '___ HGA
                 Angle  |   \|  . '      /
      \ +Ymga_apm <----------o'_`._____.'__.                      \
      /              +Zmga_az,             |                      /
      \              +Zmga_apm             |                      \
      /                      |   +Zsc    +Ysc                     /
      \=>o<===============>o-|      o------->o<===============>o<=\
      /    -Y Solar Array    |      |      |    +Y Solar Array    /
      \                      |      |      |                      \
      /                      .______|______.                      /
      \                             |                             \
                                    V
                                      +Xsc

                                                       +Zsc, +Zmga_az and
                                                       +Zmga_apm are out of
                                                       the page


   +Y MGA Azimuth frame side view:
   -------------------------------


                                 +Zmga_az,
                                 +Zmga_apm   +Xmga_el, +Zmga
                                     ^      ^
                                     |     /
                        Elevation    |_   /
                           angle  . '|  '/
                    +Xmga < .   /    |  /
                              ' .    | /
                               | ' . |/
          +Xmga_el_zero <------------x------------> +Xmga_az
                            +Ymga_az,| ' .
                            +Ymga_el,|     ' .
                       +Ymga_el_zero,|         '> +Zmga_el
                               -Ymga |
                                     |
                                     |
                                     |
                                     v
                                 +Zmga_el_zero

                                                       +Ymga_az, +Ymga_el and
                                                       +Ymga_el_zero are into
                                                       the page. +Ymga is out
                                                       of the page


   -X s/c side (HGA, MGA side) view (MGA in nominal position):
   ----------------------------------------------------------


   \--------.                       ^                        .--------/
   /        |               Nadir   |                        |        \
   \        |                       |                        |        /
   /        |                  .---------.      +Zmga      +Ymga      \
   \-.------'                  |         o======(o---------> '------.-/
   /-"------. .-------------.  |  .---.  ||  .-- | ---------. .------"-\
   \        | |             |-.|/ HGA   \||,-|   |          | |        /
   /        |=|               o|    x    |o      |          |=|        \
   \        | |             |_/|\       /| \_|   v          | |        /
   /-.------' '-------------'  | '.___.' |   '- +Xmga ------' '------.-\
   \-"------.                  '---------'                   .------"-/
   /        |                     /   \                      |        \
   \        |                     '---'                      |        /
   /        |      ^ +Zsc      Main Engine                   |        \
   \--------'      |                                         '--------/
                   |
          +Ysc     |
          <--------x                           +Xsc is into the page
                    +Xsc                       +Zmga is out of the page


    Since the SPICE frames subsystem calls for specifying the reverse
    transformation--going from the instrument or structure frame to the
    base frame--as compared to the description given above, the order of
    rotations assigned to the TKFRAME_*_AXES keyword is also reversed
    compared to the above text, and the signs associated with the
    rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
    opposite from what is written in the above text.

    \begindata

      FRAME_JUICE_MGA_APM             = -28040
      FRAME_-28040_NAME               = 'JUICE_MGA_APM'
      FRAME_-28040_CLASS              =  4
      FRAME_-28040_CLASS_ID           = -28040
      FRAME_-28040_CENTER             = -28040
      TKFRAME_-28040_RELATIVE         = 'JUICE_SPACECRAFT'
      TKFRAME_-28040_SPEC             = 'ANGLES'
      TKFRAME_-28040_UNITS            = 'DEGREES'
      TKFRAME_-28040_AXES             = (    1,     2,     3    )
      TKFRAME_-28040_ANGLES           = (  0.0,   0.0,   180.0  )

      FRAME_JUICE_MGA_AZ              = -28041
      FRAME_-28041_NAME               = 'JUICE_MGA_AZ'
      FRAME_-28041_CLASS              =  3
      FRAME_-28041_CLASS_ID           = -28041
      FRAME_-28041_CENTER             = -28040
      CK_-28021_SCLK                  = -28
      CK_-28021_SPK                   = -28

      FRAME_JUICE_MGA_EL_ZERO         =  -28042
      FRAME_-28042_NAME               = 'JUICE_MGA_EL_ZERO'
      FRAME_-28042_CLASS              =  4
      FRAME_-28042_CLASS_ID           =  -28042
      FRAME_-28042_CENTER             =  -28044
      TKFRAME_-28042_RELATIVE         = 'JUICE_MGA_AZ'
      TKFRAME_-28042_SPEC             = 'ANGLES'
      TKFRAME_-28042_UNITS            = 'DEGREES'
      TKFRAME_-28042_AXES             = (   3,       1,      2  )
      TKFRAME_-28042_ANGLES           = (   0.0,   0.0,  180.0  )

      FRAME_JUICE_MGA_EL              = -28043
      FRAME_-28043_NAME               = 'JUICE_MGA_EL'
      FRAME_-28043_CLASS              =  3
      FRAME_-28043_CLASS_ID           = -28043
      FRAME_-28043_CENTER             = -28044
      CK_-28023_SCLK                  = -28
      CK_-28023_SPK                   = -28044

      FRAME_JUICE_MGA                 =  -28044
      FRAME_-28044_NAME               = 'JUICE_MGA'
      FRAME_-28044_CLASS              =  4
      FRAME_-28044_CLASS_ID           =  -28044
      FRAME_-28044_CENTER             =  -28044
      TKFRAME_-28044_RELATIVE         = 'JUICE_MGA_EL'
      TKFRAME_-28044_SPEC             = 'ANGLES'
      TKFRAME_-28044_UNITS            = 'DEGREES'
      TKFRAME_-28044_AXES             = (   3,       1,      2  )
      TKFRAME_-28044_ANGLES           = (   0.0,   0.0,   90.0  )

    \begintext


JUICE Low Gain Antenna Frames
--------------------------------------------------------------------------

   The low gain antenna is an essential component of the spacecraft in an
   emergency case. The three main phases from the communication perspective
   are the Launch and Early Orbit Phase (LEOP), the commissioning and cruise
   phase, and the operational phase at Jupiter. During and after separation,
   full antenna coverage is necessary before a stable attitude is achieved,
   requiring two antennas with spherical coverage. In case of spacecraft
   survival mode, the LGAs provide the communication capability for recovery
   by ground operation.

   The optimum location of the LGAs providing maximum coverage is found on –X
   and +X side of the s/c, thus looking into HGA direction, respectively
   into the opposite direction of the HGA.

   The LGA installed in the +X panel of the JUICE Spacecraft frame
   -- JUICE_LGA+X -- is a  ``fixed-offset'', defined with respect to the
   JUICE_SPACECRAFT frame as follows (from [15]):

      -  +Z axis is in the antenna boresight direction (nominally
         co-aligned to the spacecraft +X axis);

      -  +Y axis is in the direction of the spacecraft +X axis;

      -  +X completes the right hand frame;

      -  the origin of the frame is located at the geometric center of the
         LGA dish outer rim circle.


   The LGA installed in the -X panel of the JUICE Spacecraft frame
   -- JUICE_LGA-X -- is a  ``fixed-offset'', defined with respect to the
   JUICE_SPACECRAFT frame as follows (from [15]):

      -  +Z axis is in the antenna boresight direction (nominally
         co-aligned to the spacecraft +X axis);

      -  +Y axis is in the direction of the spacecraft +X axis;

      -  +X completes the right hand frame;

      -  the origin of the frame is located at the geometric center of the
         LGA dish outer rim circle.


   This diagram illustrate the JUICE Low Gain Antennas frames:


   +X s/c side (opposite to HGA side) view:
   ----------------------------------------

                                       ^
          .---------.                  | Nadir            .---------.
          |         |                  |                  |         |
          |         |             Science Deck            |         |
          '----.----'              .-------.              '----.----'
   /----. .----'----. .---------._ |^+Ylga+x  .---------. .----'----. .-----\
   \    |_|         |_|         | \||      |/ |         |_|         |_|     /
   /    | |         | |         |_/||  ^   |\_|         | |         | |     \
   \----' '----.----' '---------'  ||  |+Zsc  +Xlga+x --' '----.----' '-----/
          .----'----.              'o--|------>           .----'----.
          |         |          +Zlga+x | \   +Ysc         |         |
          |         |                '-o------>           |         |
          '---------'                +Xsc                 '---------'


                                                      +Xsc and +Zlga+x are
                                                       out of the page


   -X s/c side (HGA side) view:
   ----------------------------

                                       +Ylga-x
   \--------.                 Nadir ^   ^                   .--------/
   /        |                       |   |                   |        \
   \        |                       |   |                   |        /
   /        |                  .--------|.                  |        \
   \-.------'                  |        o-------> +Xlga-x   '------.-/
   /-"------. .-------------.  | . +Zlga-x  .-------------. .------"-\
   \        | |             |-.|/ HGA   \|,-|             | |        /
   /        |=|             |  |    x    |  |             |=|        \
   \        | |             |_/|\       /|\_|             | |        /
   /-.------' '-------------'  | '.___.' |  '-------------' '------.-\
   \-"------.                  '---------'                  .------"-/
   /        |                     /   \                     |        \
   \        |                     '---'                     |        /
   /        |      ^ +Zsc                                   |        \
   \--------'      |                                        '--------/
                   |
          +Ysc     |
          <--------x                           +Xsc is into the page
                    +Xsc                       +Zlga-x is out of the page


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_LGA+X                =  -28045
      FRAME_-28045_NAME                = 'JUICE_LGA+X'
      FRAME_-28045_CLASS               =  4
      FRAME_-28045_CLASS_ID            =  -28045
      FRAME_-28045_CENTER              =  -28045
      TKFRAME_-28045_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28045_SPEC              = 'ANGLES'
      TKFRAME_-28045_UNITS             = 'DEGREES'
      TKFRAME_-28045_AXES              = (     3,     1,       2 )
      TKFRAME_-28045_ANGLES            = (   0.0, -90.0,   -90.0 )


      FRAME_JUICE_LGA-X                =  -28046
      FRAME_-28046_NAME                = 'JUICE_LGA-X'
      FRAME_-28046_CLASS               =  4
      FRAME_-28046_CLASS_ID            =  -28046
      FRAME_-28046_CENTER              =  -28046
      TKFRAME_-28046_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28046_SPEC              = 'ANGLES'
      TKFRAME_-28046_UNITS             = 'DEGREES'
      TKFRAME_-28046_AXES              = (   3,         1,    2   )
      TKFRAME_-28046_ANGLES            = (  00.0,   -90.0,   90.0 )

   \begintext


JUICE Magnetometer Boom Frames
--------------------------------------------------------------------------

   This section contains the definition of the Magnetometer Boom (MAG Boom)
   frames.

   The Magnetometer Boom (MAG Boom) is one of the Instrument Supporting
   structures of the JUICE spacecraft. The MAG Boom is attached to the
   -X/-Z corner of the spacecraft main body and supports toward its outer
   end the J-MAG Inboard, Outboard and Scatterometer sensors, and the
   Radio Wave Instrument and the Scalar Magnetometer of the Radio and
   Plasma Wave Instrument (RPWI) experiments.

   The MAG Boom is a deployable structure comprising that ranges from
   3.6m long in stowed configuration at launch (along +Zsc axis), up to
   10.6m long in deployed configuration (in the -Xc, -Zsc quadrant).


Magnetometer Boom Frames Tree
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   The diagram below shows the Magnetometer Boom Frames frame hierarchy:


                    "JUICE_SPACECRAFT"
                    ------------------
                            |
                            |<-fixed
                            |
                            v
                    "JUICE_MAG_BOOM-H"
                    ------------------
                            |
                            |<-ck
                            |
                            v
                     "JUICE_MAG_BOOM"
                     ----------------


MAG Boom Hinge frame
~~~~~~~~~~~~~~~~~~~~

   The Magnetometer's boom hinge  -- JUICE_MAG_BOOM-H IS defined as follows
   (from [10]):

      -  +Z axis is nominally co-aligned with the s/c +Z mechanical
         axis; and co-aligned with the boom's third segment where the
         sensors are mounted such this axis points from the inboard
         magnetometer sensor towards the scalar magnetometer.

      -  +X axis is nominally co-aligned with the s/c +X mechanical
         axis, pointing opposite the HGA;

      -  +Y axis completes the right hand frame; and its nominally co-aligned
         with the Magnetometer boom's hinge rotation axis;

      -  the origin of the frame is located at the boom's hinge geometrical
         center.


   These diagram illustrates the JUICE MAG Boom Hinge frame:


   +X s/c side (opposite to HGA side) view:
   ----------------------------------------

                                       ^
          .---------.                  | Nadir            .---------.
          |         |                  |                  |         |
          |         |             Science Deck            |         |
          '----.----'              .-------.              '----.----'
   /----. .----'----. .---------._ |^+Zmagb-h .---------. .----'----. .-----\
   \    |_|         |_|         | \||      |/ |         |_|         |_|     /
   /    | |         | |         |_/||  ^   |\_|         | |         | |     \
   \----' '----.----' '---------'  ||  |+Zsc  +Ymagb-h--' '----.----' '-----/
          .----'----.              'o--|------>           .----'----.
          |         |                / | \   +Ysc         |         |
          |         |                '-o------>           |         |
          '---------'                +Xsc                 '---------'


                                                      +Xsc and +Xmagb-h are
                                                       out of the page


   -Y s/c side view (with MAG Boom in stowed configuration):
   ---------------------------------------------------------
                              ^
                          ~~  |
                          ||  | Nadir direction
                          ||  |
                          oo  |
              .    .------||------.
              |`.  | Science Deck |o
          HGA |  \ |      ||      |||# MAGSCA
              |   \|      ||      ||||
              |    |      ||      |||# MAGOBS
              |    |     /||\     |||\ SCM
              |    x     \||/     |||\ RWI       +Zmagb-h
              |    |      ||      ||||         ^
              |    |      |'^     ||||         |
              |   /|      |'|+Zsc |||# MAGIBS  |
              |  / |      |'|     ||||         |
              |.'  |      |'|     ||o          |       +Xmagb-h
                   '------|'|-----'o           x-------->
                       /__oox---------->
                          || +Ysc      +Xsc             +Ysc and +Xmagb-h
                          ||                             are into de page
                          ~~


   As shown on the diagram, no rotation is required to co-align the s/c
   frame with the Magnetometer's boom hinge frame.

   \begindata

      FRAME_JUICE_MAG_BOOM-H           =  -28030
      FRAME_-28030_NAME                = 'JUICE_MAG_BOOM-H'
      FRAME_-28030_CLASS               =  4
      FRAME_-28030_CLASS_ID            =  -28030
      FRAME_-28030_CENTER              =  -28031
      TKFRAME_-28030_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28030_SPEC              = 'ANGLES'
      TKFRAME_-28030_UNITS             = 'DEGREES'
      TKFRAME_-28030_ANGLES            = ( 0.0, 0.0, 0.0 )
      TKFRAME_-28030_AXES              = ( 2,   3,   1   )

   \begintext


MAG Boom frame
~~~~~~~~~~~~~~

   Since both, pre- and post- deployment orientation of the Magnetometer
   Boom could be required for J-MAG and RPWI data analysis, the boom's frame
   is defined as a CK-based frame with its orientation provided in CK files.
   This frame is describing the time dependent relationship between the
   Magnetometer Boom hinge and JUICE spacecraft fixed frames.

   The Magnetometer Boom frame is defined as follows (from [10]):

       -  +Z axis is parallel to the boom and points from the boom
         deployment hinge toward its tip; and in stowed configuration
         is nominally co-aligned with the s/c +Z axis;

      -  +Y axis is parallel to the Magnetometer boom's hinge rotation axis;

      -  +X axis completes the right hand frame;

      -  the origin of the frame is located at the boom's hinge geometrical
         center.


   The following diagram illustrates the JUICE MAG Boom frame:

   -Y s/c side view (with MAG Boom in stowed configuration):
   ---------------------------------------------------------
                              ^
                          ~~  |
                          ||  | Nadir direction
                          ||  |
                          oo  |
              .    .------||------.
              |`.  | Science Deck |
          HGA |  \ |      ||      |
              |   \|      ||      |
              |    |      ||      |
              |    |     /||\     |
              |    x     \||/     |                          +Zmagb-h
              |    |      ||      |                        ^
              |    |      |'^     |                        |
              |   /|      |'|+Zsc |                        |
              |  / |      |'|     |                        |
              |.'  |      |'|     | +Ymagb                 |       +Xmagb-h
                   '------|'|-----'x  ---.                 x-------->
                       /__oox-----> `. .' 51 degrees
                          ||    +Xsc  `.                  +Ysc and +Ymagb
                          || .'         `. +Zmagb           are into de page
                          ~.'             v.
                         .'                 `o
                       v'                     `.
                        +Xmagb                  `.
                                                  `.
                                                    `o     |  /
                                             MAGIBS   `#   | /
                                                        `. |/ RWI
                                                    ------`.--------
                                                          /='.= SCM
                                                         / |  `# MAGOBS
                                                        /  |    `# MAGSCA


   These sets of keywords define the Magnetometer's boom frame as CK frame:

   \begindata

      FRAME_JUICE_MAG_BOOM             =  -28031
      FRAME_-28031_NAME                = 'JUICE_MAG_BOOM'
      FRAME_-28031_CLASS               =  3
      FRAME_-28031_CLASS_ID            =  -28031
      FRAME_-28031_CENTER              =  -28031
      CK_-28031_SCLK                   =  -28
      CK_-28031_SPK                    =  -28

   \begintext


JUICE Star Trackers Frames
--------------------------------------------------------------------------

   There are three Star Trackers Optical Heads (STR-OHs) mounted in the
   +X s/c Panel (Opposite side of the HGA panel). The STRs are nominally
   oriented with their boresights with a given azimuth and elevation angles
   with respect to the s/c reference frame as follows


                   | Azimuth (degrees) | Elevation (degrees)
         ----------+-------------------+--------------------
          STR-OH1  |      -51.1        |      -40.2
          STR-OH2  |      -15.0        |        5.0
          STR-OH3  |       58.2        |      -44.8


   The X and Y axis of the STR frames are aligned with the sensors
   Active Pixel Sensor (APS) rows and columns respectively.

   The Star Tracker STR-OH1, STR-OH2 and STR-OH3 frames -- JUICE_STR-OH1,
   JUICE_STR-OH2 and JUICE_STR-OH3 -- are defined as follows:

      -  +Z axis points along the Star Tracker boresight;

      -  +X axis is nominally parallel to the APS sensor rows;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the Star Tracker focal
         point.

   Nominally, the following rotations, first about +Z and then about
   +X, are required in order to align each of the JUICE_STR-OHx
   frames to the s/c frame.


                             Rotation     Rotation      Rotation
           `To' frame        about +Z     about +Z      about +Y
          --------------     --------     ---------     ---------
           JUICE_STR-OH1     90.0 deg     -51.1 deg      40.2 deg
           JUICE_STR-OH2     90.0 deg     -15.0 deg      -5.0 deg
           JUICE_STR-OH3     90.0 deg      58.2 deg      44.8 deg


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.


   \begindata

      FRAME_JUICE_STR-OH1              =  -28061
      FRAME_-28061_NAME                = 'JUICE_STR-OH1'
      FRAME_-28061_CLASS               =   4
      FRAME_-28061_CLASS_ID            =  -28061
      FRAME_-28061_CENTER              =  -28061
      TKFRAME_-28061_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28061_SPEC              = 'ANGLES'
      TKFRAME_-28061_UNITS             = 'DEGREES'
      TKFRAME_-28061_ANGLES            = ( -40.2  51.1, -90.0  )
      TKFRAME_-28061_AXES              = (   2,    3,     2   )

      FRAME_JUICE_STR-OH2              =  -28062
      FRAME_-28062_NAME                = 'JUICE_STR-OH2'
      FRAME_-28062_CLASS               =   4
      FRAME_-28062_CLASS_ID            =  -28062
      FRAME_-28062_CENTER              =  -28062
      TKFRAME_-28062_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28062_SPEC              = 'ANGLES'
      TKFRAME_-28062_UNITS             = 'DEGREES'
      TKFRAME_-28062_ANGLES            = ( 5.0,   15.0, -90.0  )
      TKFRAME_-28062_AXES              = (   2,    3,     2    )

      FRAME_JUICE_STR-OH3              =  -28063
      FRAME_-28063_NAME                = 'JUICE_STR-OH3'
      FRAME_-28063_CLASS               =   4
      FRAME_-28063_CLASS_ID            =  -28063
      FRAME_-28063_CENTER              =  -28063
      TKFRAME_-28063_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28063_SPEC              = 'ANGLES'
      TKFRAME_-28063_UNITS             = 'DEGREES'
      TKFRAME_-28063_ANGLES            = ( -44.8,  -58.2  -90.0  )
      TKFRAME_-28063_AXES              = (   2,      3,     2   )

   \begintext


JUICE Navigation Cameras Frames
--------------------------------------------------------------------------

   The two JUICE Navigation Cameras (NavCam) are accommodated on the optical
   bench close to the STR-OH providing high pointing accuracy and stability
   to all the units.

   The Jupiter NavCam frames -- JUICE_NAVCAM-1 and JUICE_NAVCAM-2 --
   are defined as follows:

      -  +Z axis points along the Camera boresight;

      -  +X axis is nominally parallel to the CCD sensor lines;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the Camera focal
         point.

   The JUICE_NAVCAM-* are co-aligned with the JUICE s/c frame.


   \begindata

      FRAME_JUICE_NAVCAM-1             =  -28051
      FRAME_-28051_NAME                = 'JUICE_NAVCAM-1'
      FRAME_-28051_CLASS               =   4
      FRAME_-28051_CLASS_ID            =  -28051
      FRAME_-28051_CENTER              =  -28051
      TKFRAME_-28051_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28051_SPEC              = 'ANGLES'
      TKFRAME_-28051_UNITS             = 'DEGREES'
      TKFRAME_-28051_ANGLES            = (  0.0,    0.0,  0.0 )
      TKFRAME_-28051_AXES              = (  3,      2,    1   )

      FRAME_JUICE_NAVCAM-2             =  -28052
      FRAME_-28052_NAME                = 'JUICE_NAVCAM-2'
      FRAME_-28052_CLASS               =   4
      FRAME_-28052_CLASS_ID            =  -28052
      FRAME_-28052_CENTER              =  -28052
      TKFRAME_-28052_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28052_SPEC              = 'ANGLES'
      TKFRAME_-28052_UNITS             = 'DEGREES'
      TKFRAME_-28052_ANGLES            = (  0.0,    0.0,  0.0 )
      TKFRAME_-28052_AXES              = (  3,      2,    1   )

   \begintext


JUICE Monitoring Cameras Frames
--------------------------------------------------------------------------

   Two JUICE Monitoring Units (JMU) and two JUICE Monitoring Cameras (JMC) are
   accommodated to enhance the observability of the spacecraft and its
   instruments, at marginal impact on spacecraft design and its budgets
   (power, mass).

   The small size of the camera (100 x 100 x 100 mm) helps to accommodate it
   on the optimum position, here also without impact on spacecraft design. The
   first camera is accommodated on the bottom of the +X wall, looking in +Z/+Y
   direction. The second camera is accommodated on the top of the +X side,
   looking towards –Z/-Y. Both cameras thus benefit from the +X s/c face
   favourable environment (no direct Sun illumination).

   The JUICE Monitoring Cameras frames -- JUICE_JMC-1 and JUICE_JMC-2 --
   are defined as follows:

      -  +Z axis points along the Camera boresight;

      -  +X axis is nominally parallel to the CMOS sensor lines;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the Camera focal
         point.


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.


   \begindata

      FRAME_JUICE_JMC-1                =  -28081
      FRAME_-28081_NAME                = 'JUICE_JMC-1'
      FRAME_-28081_CLASS               =   4
      FRAME_-28081_CLASS_ID            =  -28081
      FRAME_-28081_CENTER              =  -28081
      TKFRAME_-28081_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28081_SPEC              = 'ANGLES'
      TKFRAME_-28081_UNITS             = 'DEGREES'
      TKFRAME_-28081_ANGLES            = ( 90.0,  -90.0, 45.0 )
      TKFRAME_-28081_AXES              = (  3,      3,    1   )

      FRAME_JUICE_JMC-2                =  -28082
      FRAME_-28082_NAME                = 'JUICE_JMC-2'
      FRAME_-28082_CLASS               =   4
      FRAME_-28082_CLASS_ID            =  -28082
      FRAME_-28082_CENTER              =  -28082
      TKFRAME_-28082_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28082_SPEC              = 'ANGLES'
      TKFRAME_-28082_UNITS             = 'DEGREES'
      TKFRAME_-28082_ANGLES            = ( 90.0,   -90, -135.0 )
      TKFRAME_-28082_AXES              = (    3,     3,    1   )

   \begintext


GALA Frames
--------------------------------------------------------------------------

   This section contains the definition of the GAnymede Laser Altimeter
   (GALA) instrument frames.


GALA Frame Tree
~~~~~~~~~~~~~~~

   The diagram below shows the GALA frame hierarchy:

                    "JUICE_SPACECRAFT"
                    ------------------
                            |
                            |<-fixed
                            |
                            v
                     "JUICE_GALA_BASE"
              +----------------------------+
              |                            |
              |                            |
              |<-fixed                     |<-fixed
              |                            |
              v                            v
      "JUICE_GALA_LHM"              "JUICE_GALA_RXT"
      ----------------              ----------------


GALA instrument Base frame
~~~~~~~~~~~~~~~~~~~~~~~~~~

   The GALA main unit is rigidly mounted on the spacecraft science deck.
   Therefore, the frame associated with it -- the GALA main unit base
   frame, JUICE_GALA_BASE --  is specified as a fixed offset frame relative
   with its orientation given relative to the JUICE_SPACECRAFT frame.

   The GALA main unit base frame is defined by the laser altimeter design
   and its mounting on the spacecraft as follows:

      -  +Z axis is along the nominal GALA laser head transmitter and
         receiver telescope boresights; it is nominally co-aligned with the
         spacecraft +Z axis;

      -  +Y axis is co-aligned with the +Y spacecraft axis;

      -  +X axis completes the right-handed frame;

      -  the origin of the frame is located at the center of the GALA
         reference hole (RH) at the instrument's interface plane, i.e. the
         unit mounting plane to the spacecraft.

   Any misalignment between the nominal and actual GALA mounting alignment
   measured pre-launch should be incorporated into the definition of this
   frame.


   This diagram illustrates nominal JUICE_GALA_BASE frame with respect to
   the spacecraft frame.

   +Z s/c side view:
   -----------------
                                                          direction
                                                          of flight
                               ___________ HGA        <-------------->
                               \         /
      \                      .__`._____.'__.                      \
      /                      |             |                      /
      \                      |             |                      \
      /                      |   +Zsc    +Ysc                     /
      \=>o<===============>o-|      o------->o<===============>o<=\
      /    -Y Solar Array    |___.  |      |    +Y Solar Array    /
      \                      | o------>    |                      \
      /                      ._|_|__|__+Ygala_base                /
      \                        |    |                             \
                               |    V +Xsc
                               V
                                +Xgala_base
                                             +Zsc and +Zgala_base are
                                                 out of page


   Nominally, the GALA base frame is co-aligned with the s/c frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_GALA_BASE            =  -28100
      FRAME_-28100_NAME                = 'JUICE_GALA_BASE'
      FRAME_-28100_CLASS               =  4
      FRAME_-28100_CLASS_ID            =  -28100
      FRAME_-28100_CENTER              =  -28100
      TKFRAME_-28100_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28100_SPEC              = 'ANGLES'
      TKFRAME_-28100_UNITS             = 'DEGREES'
      TKFRAME_-28100_AXES              = ( 1,   2,   3   )
      TKFRAME_-28100_ANGLES            = ( 0.0, 0.0, 0.0 )

   \begintext


GALA Laser Head Module frame
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   The GALA Laser Head Module (LHM) frame, JUICE_GALA_LHM, is defined
   exactly as, and is nominally co-aligned with, the GALA base frame
   JUICE_GALA_BASE. This frame is introduced to allow incorporating into
   the Laser Head Module frame chain any misalignment between the instrument
   base and the laser beam transmitter measured prior to delivering the
   camera for installation on the spacecraft.


   \begindata

      FRAME_JUICE_GALA_LHM             =  -28110
      FRAME_-28110_NAME                = 'JUICE_GALA_LHM'
      FRAME_-28110_CLASS               =  4
      FRAME_-28110_CLASS_ID            =  -28110
      FRAME_-28110_CENTER              =  -28100
      TKFRAME_-28110_RELATIVE          = 'JUICE_GALA_BASE'
      TKFRAME_-28110_SPEC              = 'ANGLES'
      TKFRAME_-28110_UNITS             = 'DEGREES'
      TKFRAME_-28110_AXES              = (  1,   2,   3   )
      TKFRAME_-28110_ANGLES            = (  0.0, 0.0, 0.0 )

   \begintext


GALA Receiver Telescope frame
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   The GALA Receiver Telescope (RXT) frame, JUICE_GALA_RXT, is defined
   exactly as, and is nominally co-aligned with, the GALA base frame
   JUICE_GALA_BASE. This frame is introduced to allow incorporating into
   the Receiver Telescope frame chain any misalignment between the
   instrument base and the laser beam receiver telescope measured prior
   to delivering the camera for installation on the spacecraft.


   \begindata

      FRAME_JUICE_GALA_RXT             =  -28120
      FRAME_-28120_NAME                = 'JUICE_GALA_RXT'
      FRAME_-28120_CLASS               =  4
      FRAME_-28120_CLASS_ID            =  -28120
      FRAME_-28120_CENTER              =  -28100
      TKFRAME_-28120_RELATIVE          = 'JUICE_GALA_BASE'
      TKFRAME_-28120_SPEC              = 'ANGLES'
      TKFRAME_-28120_UNITS             = 'DEGREES'
      TKFRAME_-28120_AXES              = (  1,   2,   3   )
      TKFRAME_-28120_ANGLES            = (  0.0, 0.0, 0.0 )

   \begintext


JANUS Frames
--------------------------------------------------------------------------

   This section contains the definition of the Jovis, Amorum ac Natorum
   Undique Scrutator (JANUS) camera system instrument frames.


JANUS Frame Tree
~~~~~~~~~~~~~~~~

   The diagram below shows the JANUS frame hierarchy:


                             "JUICE_SPACECRAFT"
                             ------------------
                                     |
                                     |<-fixed
                                     |
                                     v
                               "JUICE_JANUS"
                               -------------


JANUS Camera System Frame
~~~~~~~~~~~~~~~~~~~~~~~~~

   The JANUS camera frame -- JUICE_JANUS -- is defined as follows (see [8]):

      -  +Z axis points along the camera boresight;

      -  +Y axis is parallel to the apparent image columns; it is
         nominally co-aligned with the spacecraft +Y axis;

      -  +X axis completes the right hand frame; it is nominally
         parallel the to the apparent image lines and co-aligned with
         the spacecraft +X axis;

      -  the origin of the frame is located at the camera focal point.

   This diagram illustrates the JANUS camera frame:


   +Z s/c side view:
   -----------------
                                                          direction
                                                          of flight
                               ___________ HGA        <-------------->
                               \         /
      \                      .__`._____.'__.                      \
      /                      |             |                      /
      \                      |             |                      \
      /                      |   +Zsc    +Ysc                     /
      \=>o<===============>o-|      o------->o<===============>o<=\
      /    -Y Solar Array    |___.  |      |    +Y Solar Array    /
      \                      | o------>    |                      \
      /                      ._|_|__|__+Yjanus                    /
      \                        |    |                             \
                               |    V +Xsc
                               V
                                +Xjanus
                                             +Zsc and +Zjanus are
                                                 out of page


   Nominally, the JANUS camera frame is co-aligned with the spacecraft
   frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_JANUS                =  -28200
      FRAME_-28200_NAME                = 'JUICE_JANUS'
      FRAME_-28200_CLASS               =  4
      FRAME_-28200_CLASS_ID            =  -28200
      FRAME_-28200_CENTER              =  -28200
      TKFRAME_-28200_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28200_SPEC              = 'ANGLES'
      TKFRAME_-28200_UNITS             = 'DEGREES'
      TKFRAME_-28200_AXES              = ( 1,   2,   3   )
      TKFRAME_-28200_ANGLES            = ( 0.0, 0.0, 0.0 )

   \begintext


J-MAG Frames
--------------------------------------------------------------------------

   This section contains the definition of the JUICE Magnetometer (J-MAG)
   instrument frames.


J-MAG Frame Tree
~~~~~~~~~~~~~~~~

   The diagram below shows the J-MAG frame hierarchy:


                             "JUICE_SPACECRAFT"
                             ------------------
                                     |
                                     |<-fixed
                                     |
                                     v
                             "JUICE_MAG_BOOM-H"
                             ------------------
                                     |
                                     |<-ck
                                     |
                                     v
                              "JUICE_MAG_BOOM"
                +-----------------------------------------+
                |                    |                    |
                |<-fixed             |<-fixed             |<-fixed
                |                    |                    |
                v                    |                    v
       "JUICE_JMAG_MAGIBS"           |           "JUICE_JMAG_MAGSCA"
       -------------------           |           -------------------
                                     v
                            "JUICE_JMAG_MAGOBS"
                            -------------------


J-MAG frames definitions
~~~~~~~~~~~~~~~~~~~~~~~~

   The J-MAG experiment comprises three sensors mounted in the JUICE
   Magnetometer Boom at different distances from the boom's hinge. The
   innermost is called the in-board sensor (MAGIBS) and it is a fluxgate
   magnetometer. A second fluxgate magnetometer, called  the out-board
   sensor (MAGOBS), is located approximately 3 meters away toward the end
   of the boom. A scalar magnetometer (MAGSCA) is located at the tip.

   Each of the sensor's frames -- JUICE_JMAG_MAGIBS, JUICE_JMAG_MAGOBS
   and JUICE_JMAG_MAGSCA -- are defined as follows (from [10]):

      -  +Z axis is parallel to the boom and points from the boom
         deployment hinge toward the sensor;

      -  +X axis is nominally co-aligned with the boom's +X axis;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the geometric center of
         the sensor.


   This diagram illustrates the J-MAG sensors' frames:

   +X Magnetometer Boom side view:
   -------------------------------

                                       ^ +Zsca
                                       |
                                     .-|-.
                                     | | |    +Ysca
      J-MAG Scalar Magnetometer      | o-------->
        (MAGSCA)                  +Xsca  |
                                     '---'
                                      | |
                                      | |
                                      ~~~
                                      ~~~
                                      | |
                                      |^ +Zobs
                                      |||
                                     .-|-.
                                     | | |    +Yobs
          J-MAG Outboard Sensor      | o-------->
             (MAGOBS)             +Xobs  |
                                     '---'
                                      | |
                                      | |
                                      ~~~
                                      ~~~
                                      | |
                                      | |
                                      | |
                                      |^ +Zibs
                                      |||
                                     .-|-.
                                     | | |    +Yibs
            J-MAG Inboard Sensor     | o-------->
                (MAGIBS)          +Xibs  |
                                     '---'
                                      | |
                                      | |
                                      ~~~
                                      ~~~
                                      | |
                                      | |
                                      |^ +Zmagb
                                      |||
                                      |||
                                      |||      +Ymagb
                                       o-------->
                                 +Xmagb

                                               +Xmagb, +Xibs, +Xobs and
                                               +Xsca are out of the page


   Nominally, all three J-MAG sensors frames are co-aligned with the
   magnetometer frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_JMAG_MAGIBS          =  -28300
      FRAME_-28300_NAME                = 'JUICE_JMAG_MAGIBS'
      FRAME_-28300_CLASS               =  4
      FRAME_-28300_CLASS_ID            =  -28300
      FRAME_-28300_CENTER              =  -28300
      TKFRAME_-28300_RELATIVE          = 'JUICE_MAG_BOOM'
      TKFRAME_-28300_SPEC              = 'ANGLES'
      TKFRAME_-28300_UNITS             = 'DEGREES'
      TKFRAME_-28300_AXES              = ( 1,   2,   3   )
      TKFRAME_-28300_ANGLES            = ( 0.0, 0.0, 0.0 )

      FRAME_JUICE_JMAG_MAGOBS          =  -28310
      FRAME_-28310_NAME                = 'JUICE_JMAG_MAGOBS'
      FRAME_-28310_CLASS               =  4
      FRAME_-28310_CLASS_ID            =  -28310
      FRAME_-28310_CENTER              =  -28310
      TKFRAME_-28310_RELATIVE          = 'JUICE_MAG_BOOM'
      TKFRAME_-28310_SPEC              = 'ANGLES'
      TKFRAME_-28310_UNITS             = 'DEGREES'
      TKFRAME_-28310_AXES              = ( 1,   2,   3   )
      TKFRAME_-28310_ANGLES            = ( 0.0, 0.0, 0.0 )

      FRAME_JUICE_JMAG_MAGSCA          =  -28320
      FRAME_-28320_NAME                = 'JUICE_JMAG_MAGSCA'
      FRAME_-28320_CLASS               =  4
      FRAME_-28320_CLASS_ID            =  -28320
      FRAME_-28320_CENTER              =  -28320
      TKFRAME_-28320_RELATIVE          = 'JUICE_MAG_BOOM'
      TKFRAME_-28320_SPEC              = 'ANGLES'
      TKFRAME_-28320_UNITS             = 'DEGREES'
      TKFRAME_-28320_AXES              = ( 1,   2,   3   )
      TKFRAME_-28320_ANGLES            = ( 0.0, 0.0, 0.0 )

   \begintext


MAJIS Frames
--------------------------------------------------------------------------

   This section contains the definition of the Moons And Jupiter
   Imaging Spectrometer (MAJIS) instrument frames.


MAJIS Frame Tree
~~~~~~~~~~~~~~~~

   The diagram below shows the MAJIS frame hierarchy:


                             "JUICE_SPACECRAFT"
                             ------------------
                                     |
                                     |<-fixed
                                     |
                                     v
                            "JUICE_MAJIS_BASE"
                            ------------------
                                     |
                                     |
                                     |<-ck
                                     |
                                     v
                             "JUICE_MAJIS_SCAN"
                    +-----------------------------------+
                    |                                   |
                    |<-fixed                            |<-fixed
                    |                                   |
                    v                                   v
          "JUICE_MAJIS_VISNIR"                  "JUICE_MAJIS_IR"
          --------------------                  ----------------


MAJIS frames definitions
~~~~~~~~~~~~~~~~~~~~~~~~

   Currently, there are four different frames defined for the Moons and
   Jupiter Imaging Spectrometer (MAJIS), each aiming at incorporating
   different possible misalignments:

      -  JUICE_MAJIS_BASE is a fixed-offset frame aiming at introducing
         any possible misalignment between the the instrument mirror
         rotation axis and the spacecraft +X axis. This misalignment is
         constant therefore this frame is defined as a fixed offset
         frame relative to the JUICE_SPACECRAFT frame.

      -  JUICE_MAJIS_SCAN is defined to capture orientation of the
         reflected instrument view direction due to the scan mirror
         motion. This frame is defined as CK-based frame because this
         orientation is time-varying and is stored in a CK file.

      -  JUICE_MAJIS_VISNIR and JUICE_MAJIS_IR are defined to capture
         misalignments for each of the two instrument channels relative to
         the reflected view direction. These frames are defined as fixed
         offset frames relative to the JUICE_MAJIS_SCAN frame.


   Each of the MAJIS frames listed above is defined in the same way
   as follows (from [7]):

      -  +Z axis points along the boresight (for JUICE_MAJIS boresight
         is the nominal center pixel view direction for the scan mirror
         in "zero" position; for JUICE_MAJIS_SCAN boresight is the
         nominal center pixel view direction, "off-pointed" due to the
         scan mirror; for JUICE_MAJIS_VISNIR and JUICE_MAJIS_IR
         boresight is the particular detector center pixel view
         direction, "off-pointed" due to the scan mirror; adjusted for
         all known misalignments with the scan mirror in "zero" position)

      -  +X axis is parallel to the apparent spatial resolution
         direction; it is nominally co-aligned with the s/c +X axis;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the instrument focal
         point for JUICE_MAJIS_VISNIR and JUICE_MAJIS_IR frames and at
         the intersection of the nominal center pixel view direction
         and the scan mirror axis for JUICE_MAJIS and JUICE_MAJIS_SCAN
         frames.


   This diagram illustrates the MAJIS frames orientation (with MAJIS scan
   mirror in "zero" position) with respect to the spacecraft frame.

   +Z s/c side view:
   -----------------
                                                          direction
                                                          of flight
                               ___________ HGA        <-------------->
                               \         /
      \                      .__`._____.'__.                      \
      /                      |             |                      /
      \                      |             |                      \
      /                      |   +Zsc    +Ysc                     /
      \=>o<===============>o-|      o------->o<===============>o<=\
      /    -Y Solar Array    |___.  |      |    +Y Solar Array    /
      \                      | o------>+Ymajis_scan               \
      /                      ._|_|__|__+Ymajis_base               /
      \                        |    |  +Ymajis_visnir/ir          \
                               |    V
                               V      +Xsc
                         +Xmajis_scan
                         +Xmajis_base
                         +Xmajis_visnir/ir


                                             +Zsc, +Zmajis_scan, +Zmajis_base
                                             +Zmajis_visnir and +Zmajis_ir are
                                              out of page



   Nominally, in "zero" scan mirror position all four MAJIS frames are
   co-aligned with each other and the s/c frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_MAJIS_BASE           =  -28400
      FRAME_-28400_NAME                = 'JUICE_MAJIS_BASE'
      FRAME_-28400_CLASS               =   4
      FRAME_-28400_CLASS_ID            =  -28400
      FRAME_-28400_CENTER              =  -28400
      TKFRAME_-28400_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28400_SPEC              = 'ANGLES'
      TKFRAME_-28400_UNITS             = 'DEGREES'
      TKFRAME_-28400_ANGLES            = ( 0.0, 0.0, 0.0 )
      TKFRAME_-28400_AXES              = ( 1,   2,   3   )

      FRAME_JUICE_MAJIS_SCAN           =  -28401
      FRAME_-28401_NAME                =  'JUICE_MAJIS_SCAN'
      FRAME_-28401_CLASS               =   3
      FRAME_-28401_CLASS_ID            =  -28401
      FRAME_-28401_CENTER              =  -28400
      CK_-28401_SCLK                   =  -28
      CK_-28401_SPK                    =  -28

      FRAME_JUICE_MAJIS_VISNIR         =  -28410
      FRAME_-28410_NAME                = 'JUICE_MAJIS_VISNIR'
      FRAME_-28410_CLASS               =   4
      FRAME_-28410_CLASS_ID            =  -28410
      FRAME_-28410_CENTER              =  -28400
      TKFRAME_-28410_RELATIVE          = 'JUICE_MAJIS_SCAN'
      TKFRAME_-28410_SPEC              = 'ANGLES'
      TKFRAME_-28410_UNITS             = 'DEGREES'
      TKFRAME_-28410_ANGLES            = ( 0.0, 0.0, 0.0 )
      TKFRAME_-28410_AXES              = ( 1,   2,   3   )

      FRAME_JUICE_MAJIS_IR             =  -28420
      FRAME_-28420_NAME                = 'JUICE_MAJIS_IR'
      FRAME_-28420_CLASS               =   4
      FRAME_-28420_CLASS_ID            =  -28420
      FRAME_-28420_CENTER              =  -28400
      TKFRAME_-28420_RELATIVE          = 'JUICE_MAJIS_SCAN'
      TKFRAME_-28420_SPEC              = 'ANGLES'
      TKFRAME_-28420_UNITS             = 'DEGREES'
      TKFRAME_-28420_ANGLES            = ( 0.0, 0.0, 0.0 )
      TKFRAME_-28420_AXES              = ( 1,   2,   3   )

   \begintext


PEP Frames
--------------------------------------------------------------------------

   This section contains the definition of the Particle Environment Package
   (PEP) instrument and sensors frames.


PEP Frame Tree
~~~~~~~~~~~~~~~

   The diagram below show the PEP frame hierarchy:


                               "JUICE_SPACECRAFT"
                    +--------------------------------------------------+
                    |                        |           |             |
                    |<-fixed          fixed->|    fixed->|      fixed->|
                    |                        |           |             |
                    v                        v           |             v
              "JUICE_PEP_NU"         "JUICE_PEP_JENI"    |     "JUICE_PEP_JDC"
         +---------------------+     ----------------    |     ---------------
         |          |          |                         |
         |<-fixed   |<-fixed   |<-fixed                  v
         |          |          |                  "JUICE_PEP_JOEE"
         v          |          v                  ----------------
   "JUICE_PEP_JEI"  |   "JUICE_PEP_NIM"
   ---------------  |   ---------------
                    |
                    v
             "JUICE_PEP_JNA"
             ---------------


PEP Nadir Unit frames definitions
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   Currently, there are four different frames defined for the Particle
   Environment Package (PEP) Nadir Unit (NU) aiming at incorporating different
   possible misalignments between the spacecraft and the different sensors:

      -  JUICE_PEP_NU is a fixed-offset frame aiming at introducing
         any possible misalignment between the Nadir Unit base mounting
         plate and the spacecraft frame. This misalignment is
         constant therefore this frame is defined as a fixed offset
         frame relative to the JUICE_SPACECRAFT frame.

      -  JUICE_PEP_JEI, JUICE_PEP_JNA and JUICE_PEP_NIM are defined to
         capture misalignments for each of the sensors, the Jovian Electrons
         and Ions analyzer (JEI), the Jovian Neutrals Analyzer (JNA), and the
         Neutral gas and Ion Mass spectrometer (NIM) relative to the Nadir
         Unit base frame. These frames are defined as fixed offset frames
         relative to the JUICE_PEP_NU frame.

   Each of the PEP Nadir Unit frames listed above -- JUICE_PEP_NU,
   JUICE_PEP_JEI and JUICE_PEP_NIM --, except for JUICE_PEP_JNA is
   defined in the same way as follows (from [12]):

      -  +Z axis points along the nominal spacecraft nadir direction;
         and it is co-aligned with the s/c +Z axis;

      -  +X axis is nominally co-aligned with the s/c +X axis;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the reference hole in the
         mounting plane for JUICE_PEP_NU and at the sensor's geometrical
         center for the JUICE_PEP_JDC and JUICE_PEP_NIM.


   The PEP JNA frame -- JUICE_PEP_JNA -- is defined as follows (from [19]):

      -  +X axis points along the nominal spacecraft nadir direction;
         and it is co-aligned with the PEP Nadir Unit +Z axis;

      -  +Y axis is nominally co-aligned with the PEP Nadir Unit +X axis;

      -  +Z axis completes the right hand frame;

      -  the origin of the frame is located at the sensor's geometrical
         center.


   These diagrams illustrate the PEP Nadir Unit with respect to the spacecraft
   frame:

   +Z s/c side view:
   -----------------
                                                          direction
                                                          of flight
                               ___________ HGA        <-------------->
                               \         /
      \                      .__`._____.'__.                      \
      /                      |             |                      /
      \                      |             |                      \
      /                      |   +Zsc    +Ysc                     /
      \=>o<===============>o-|      o------->o<===============>o<=\
      /    -Y Solar Array    |___.  |      |                      /
      \                      | o------> +Ypep_nu,+Ypep_jna        \
      /                      ._|_|__|___+Ypep_jdc,+Ypep_nim       /
      \                        |    |                             \
                               |    V +Xsc
                               v
                         +Xpep_nu,+Xpep_jna
                         +Xpep_jdc,+Xpep_nim

                                        +Zsc, +Zpep_nu, +Zpep_jdc, +Zpep_jna
                                        and +Zpep_nim are out of page

  +Y s/c side view (PEP NU detailed view):
  ----------------------------------------

                                          +Zpep_nim
                                            ^
                                            |
                                          .-|-.
                                         /  |  \
                +Zpep_jei                |  |  |
                 ^              +Xpep_jna \_x-----> +Xpep_nim
                 |                ^       |   |
              .''|'.              |      |    |       +Zpep_nu,
             |   |  |             |     .----------.  +Zsc
            /    |   \+Xpep_jei_ .|. _  |          |   ^
            |    x----->     .'   |   '.|          |   |
            |        |      /     x-------> +Ypep_jna  |
            |        |     '             '         |   |
            /  JEI    \    |    JNA      |  NIM    |   |
       ----------------------------------------------- x---------> +Xpep_nu,
                            NU                        +Ypep_nu,    +Xsc
                                                      +Ysc

                                        +Ysc, +Ypep_nu, +Ypep_jdc, +Zpep_jna
                                        and +Ypep_nim are into the page


   Nominally, the NU, JEI and NIM base frames are co-aligned with the s/c
   frame. A single rotation of -90 degrees about the +X axis of the
   JUICE_RPWI_LPBx is required to co-align the PEP JNA frame and the
   PEP Nadir Unit.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.


   \begindata

      FRAME_JUICE_PEP_NU               =  -28500
      FRAME_-28500_NAME                = 'JUICE_PEP_NU'
      FRAME_-28500_CLASS               =   4
      FRAME_-28500_CLASS_ID            =  -28500
      FRAME_-28500_CENTER              =  -28530
      TKFRAME_-28500_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28500_SPEC              = 'ANGLES'
      TKFRAME_-28500_UNITS             = 'DEGREES'
      TKFRAME_-28500_ANGLES            = ( 0.0, 0.0,   0.0 )
      TKFRAME_-28500_AXES              = ( 1,   2,     3   )

      FRAME_JUICE_PEP_NIM              =  -28530
      FRAME_-28530_NAME                = 'JUICE_PEP_NIM'
      FRAME_-28530_CLASS               =   4
      FRAME_-28530_CLASS_ID            =  -28530
      FRAME_-28530_CENTER              =  -28530
      TKFRAME_-28530_RELATIVE          = 'JUICE_PEP_NU'
      TKFRAME_-28530_SPEC              = 'ANGLES'
      TKFRAME_-28530_UNITS             = 'DEGREES'
      TKFRAME_-28530_ANGLES            = ( 0.0, 0.0, 0.0 )
      TKFRAME_-28530_AXES              = ( 1,   2,   3   )

      FRAME_JUICE_PEP_NIM_S1           =  -28531
      FRAME_-28531_NAME                = 'JUICE_PEP_NIM_S1'
      FRAME_-28531_CLASS               =   4
      FRAME_-28531_CLASS_ID            =  -28531
      FRAME_-28531_CENTER              =  -28530
      TKFRAME_-28531_RELATIVE          = 'JUICE_PEP_NIM'
      TKFRAME_-28531_SPEC              = 'ANGLES'
      TKFRAME_-28531_UNITS             = 'DEGREES'
      TKFRAME_-28531_ANGLES            = ( 0.0, 0.0,   -90.0 )
      TKFRAME_-28531_AXES              = (   3,   2,     1   )

      FRAME_JUICE_PEP_NIM_S2           =  -28532
      FRAME_-28532_NAME                = 'JUICE_PEP_NIM_S2'
      FRAME_-28532_CLASS               =   4
      FRAME_-28532_CLASS_ID            =  -28532
      FRAME_-28532_CENTER              =  -28530
      TKFRAME_-28532_RELATIVE          = 'JUICE_PEP_NIM'
      TKFRAME_-28532_SPEC              = 'ANGLES'
      TKFRAME_-28532_UNITS             = 'DEGREES'
      TKFRAME_-28532_ANGLES            = (   0.0, 60.0,  -90.0 )
      TKFRAME_-28532_AXES              = (   2,    3,     1    )

      FRAME_JUICE_PEP_NIM_S3          =  -28533
      FRAME_-28533_NAME                = 'JUICE_PEP_NIM_S3'
      FRAME_-28533_CLASS               =   4
      FRAME_-28533_CLASS_ID            =  -28533
      FRAME_-28533_CENTER              =  -28530
      TKFRAME_-28533_RELATIVE          = 'JUICE_PEP_NIM'
      TKFRAME_-28533_SPEC              = 'ANGLES'
      TKFRAME_-28533_UNITS             = 'DEGREES'
      TKFRAME_-28533_ANGLES            = (   0.0, 120.0,  -90.0 )
      TKFRAME_-28533_AXES              = (   2,     3,     1    )

      FRAME_JUICE_PEP_NIM_S4          =  -28534
      FRAME_-28534_NAME                = 'JUICE_PEP_NIM_S4'
      FRAME_-28534_CLASS               =   4
      FRAME_-28534_CLASS_ID            =  -28534
      FRAME_-28534_CENTER              =  -28530
      TKFRAME_-28534_RELATIVE          = 'JUICE_PEP_NIM'
      TKFRAME_-28534_SPEC              = 'ANGLES'
      TKFRAME_-28534_UNITS             = 'DEGREES'
      TKFRAME_-28534_ANGLES            = (   0.0, 180.0,  -90.0 )
      TKFRAME_-28534_AXES              = (   2,     3,     1    )

      FRAME_JUICE_PEP_NIM_S5          =  -28535
      FRAME_-28535_NAME                = 'JUICE_PEP_NIM_S5'
      FRAME_-28535_CLASS               =   4
      FRAME_-28535_CLASS_ID            =  -28535
      FRAME_-28535_CENTER              =  -28530
      TKFRAME_-28535_RELATIVE          = 'JUICE_PEP_NIM'
      TKFRAME_-28535_SPEC              = 'ANGLES'
      TKFRAME_-28535_UNITS             = 'DEGREES'
      TKFRAME_-28535_ANGLES            = (   0.0, 240.0,  -90.0 )
      TKFRAME_-28535_AXES              = (   2,     3,     1    )

      FRAME_JUICE_PEP_NIM_S6          =  -28536
      FRAME_-28536_NAME                = 'JUICE_PEP_NIM_S6'
      FRAME_-28536_CLASS               =   4
      FRAME_-28536_CLASS_ID            =  -28536
      FRAME_-28536_CENTER              =  -28530
      TKFRAME_-28536_RELATIVE          = 'JUICE_PEP_NIM'
      TKFRAME_-28536_SPEC              = 'ANGLES'
      TKFRAME_-28536_UNITS             = 'DEGREES'
      TKFRAME_-28536_ANGLES            = (   0.0, 300.0,  -90.0 )
      TKFRAME_-28536_AXES              = (   2,     3,     1    )

      FRAME_JUICE_PEP_JEI              =  -28540
      FRAME_-28540_NAME                = 'JUICE_PEP_JEI'
      FRAME_-28540_CLASS               =   4
      FRAME_-28540_CLASS_ID            =  -28540
      FRAME_-28540_CENTER              =  -28530
      TKFRAME_-28540_RELATIVE          = 'JUICE_PEP_NU'
      TKFRAME_-28540_SPEC              = 'ANGLES'
      TKFRAME_-28540_UNITS             = 'DEGREES'
      TKFRAME_-28540_ANGLES            = ( 0.0, 0.0, 0.0 )
      TKFRAME_-28540_AXES              = ( 1,   2,   3   )

      FRAME_JUICE_PEP_JNA              =  -28520
      FRAME_-28520_NAME                = 'JUICE_PEP_JNA'
      FRAME_-28520_CLASS               =   4
      FRAME_-28520_CLASS_ID            =  -28520
      FRAME_-28520_CENTER              =  -28530
      TKFRAME_-28520_RELATIVE          = 'JUICE_PEP_NU'
      TKFRAME_-28520_SPEC              = 'ANGLES'
      TKFRAME_-28520_UNITS             = 'DEGREES'
      TKFRAME_-28520_ANGLES            = ( 0.0, 90.0, 90.0 )
      TKFRAME_-28520_AXES              = ( 3,   2,    1    )

   \begintext


PEP JDC and PEP-Hi frames definitions
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   Currently, there are two different frames defined for the PEP-Hi group and
   one for the PEP JDC unit of the PEP-Lo group -- which is completed by the
   PEP Nadir Unit (NU) --, each one aiming at incorporating different possible
   misalignments between the spacecraft and the different sensors:

      -  JUICE_PEP_JDC, JUICE_PEP_JOEE and JUICE_PEP_JENI are a fixed-offset
         frames aiming at introducing any possible misalignment between the
         Jovian plasma Dynamics and Composition analyzer Unit sensor, the JENI
         unit sensor and the JoEE unit sensor with respect to the spacecraft
         frame. This misalignment is constant therefore this frame is defined
         as a fixed-offset frame relative to the JUICE_SPACECRAFT frame.


      The PEP Jovian plasma Dynamics and Composition analyzer Unit frame
      -- JUICE_PEP_JDC -- is defined as a fixed-offset frame relatetive to
      the JUICE_SPACECRAFT frame as follows (from [12]):

      -  +Z axis points along the JDC sensor boresight and is rotated
         45 degrees from the s/c -Z axis around the s/c Y axis towards the
         s/c X axis;

      -  +X axis is nominally co-aligned with the s/c Y axis and;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at sensor's geometrical
         center.


      The JoEE spectometer Unit frame -- JUICE_PEP_JOEE -- is defined as
      a fixed-offset frame relatetive to the JUICE_SPACECRAFT frame as
      follows (from [12]):

      -  +Z axis points along the JoEE sensor boresight and is aligned
         with the s/c -Z axis;

      -  +X axis is nominally co-aligned with the s/c Y axis and;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at sensor's geometrical
         center.


      The PEP JENI Unit frame -- JUICE_PEP_JENI -- is defined as a
      fixed-offset frame relatetive to the JUICE_SPACECRAFT frame as
      follows (from [12]):

      -  +Y axis is nominally co-aligned with the s/c Y axis and;

      -  +Z axis points along the JENI sensor boresight and is rotated
         10 degrees from the s/c Z axis around the s/c Y axis towards the
         s/c X axis;

      -  +X axis completes the right hand frame;

      -  the origin of the frame is located at sensor's geometrical
         center.


   This diagram illustrates the PEP Zenit Unit frames orientation
   with respect to the spacecraft frame.


   -Y s/c side view (with MAG Boom in stowed configuration):
   ---------------------------------------------------------

                                 +Zpep_nu
                              ^   ^
                          ~~  |   | 10 deg
                          ||  |   |-.   .> +Zpep_jeni
                          ||  |   |  '.'
                          oo  |   |.'
              .    .------||------x--------> +Xpep_nu
              |`.  |    +Ypep_jeni|`.
          HGA |  \ |    +Ypep_nu  |  `.
              |   \|      ||      |    `.
              |    |      ||      |      `> +Xpep_jeni
              |    |     /||\     |
              |    x     \||/     |
              |    |      ||      |         ^ +Ypep_jdc
              |    |      |'^     |       .'
              |   /|      |'|+Zsc |     .'
              |  / |      |'|     |   .'
               +Xpep_jdc,+Xpep_joee .'
                   '------|'|-----'x----------> +Ypep_joee
                       /__oox----->|`.
                          ||   +Xsc|  `.
                          ||       |  .'`. +Zpep_jdc
                          ~~       |-'    v.
                                   v 45 deg `o
                              +Zpep_joee      `.
                                             /\/\/

                                        +Ysc, +Ypep_jdc, +Ypep_joee,
                                        +Ypep_janu, +Ypep_nu
                                        are into the page


   +X s/c side (opposite to HGA side) view:
   ----------------------------------------

                                       ^
          .---------.                  | Nadir            .---------.
          |         |                  |                  |         |
          |         |             Science Deck            |         |
          '----.----'              .-------.              '----.----'
   /----. .----'----. .---------._ |       |  .---------. .----'----. .-----\
   \    |_|         |_|         | \| +Zsc  |/ |         |_|         |_|     /
   /    | |         | |         |_/|   ^   |\_|         | |         | |     \
   \----' '----.----' '------+Ypep_joee|   |  '---------' '----.----' '-----/
          .----' +Xpep_joee, <--------o|---'              .----'----.
          |      +Xpep_jdc           /|| \                |         |
          |         |                '|o------> +Ysc      |         |
          '---------'                 | +Xsc              '---------'
                                      |
                                      v
                                   +Zpep_joee         +Xsc and +Ypep_joee
                                                      are out of the page


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.


   \begindata

      FRAME_JUICE_PEP_JDC              =  -28510
      FRAME_-28510_NAME                = 'JUICE_PEP_JDC'
      FRAME_-28510_CLASS               =   4
      FRAME_-28510_CLASS_ID            =  -28510
      FRAME_-28510_CENTER              =  -28530
      TKFRAME_-28510_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28510_SPEC              = 'ANGLES'
      TKFRAME_-28510_UNITS             = 'DEGREES'
      TKFRAME_-28510_ANGLES            = ( 45.0,  90.0, -180.0   )
      TKFRAME_-28510_AXES              = (  2,     3,      2     )

      FRAME_JUICE_PEP_JOEE             =  -28550
      FRAME_-28550_NAME                = 'JUICE_PEP_JOEE'
      FRAME_-28550_CLASS               =   4
      FRAME_-28550_CLASS_ID            =  -28550
      FRAME_-28550_CENTER              =  -28530
      TKFRAME_-28550_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28550_SPEC              = 'ANGLES'
      TKFRAME_-28550_UNITS             = 'DEGREES'
      TKFRAME_-28550_ANGLES            = ( 0.0,  90.0, -180.0   )
      TKFRAME_-28550_AXES              = (   1,   3,      2     )

      FRAME_JUICE_PEP_JENI             =  -28560
      FRAME_-28560_NAME                = 'JUICE_PEP_JENI'
      FRAME_-28560_CLASS               =   4
      FRAME_-28560_CLASS_ID            =  -28560
      FRAME_-28560_CENTER              =  -28530
      TKFRAME_-28560_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28560_SPEC              = 'ANGLES'
      TKFRAME_-28560_UNITS             = 'DEGREES'
      TKFRAME_-28560_ANGLES            = ( -10.0, 0.0,  0.0 )
      TKFRAME_-28560_AXES              = (     2,   1,  3   )

   \begintext


RIME Frames
--------------------------------------------------------------------------

   This section contains the definition of the Radar for Icy Moon
   Exploration (RIME) instrument frame.


RIME Frame Tree
~~~~~~~~~~~~~~~

   The diagram below show the RIME frame hierarchy:

                               "JUICE_SPACECRAFT"
                               ------------------
                                       |
                                       |<-fixed
                                       |
                                       v
                               "JUICE_RIME_BASE"
            +-----------------------------------------------------+
            |            |             |             |            |
            |<-dynamic   |             |<-ck         |   dynamic->|
            |            |             |             |            |
            v            |             |             |            v
    "JUICE_RIME_NADC"    |             |             |    "JUICE_RIME_NADG"
    -----------------    |             |             |    -----------------
                         |             |             |
                         |<-dynamic    |    dynamic->|
                         |             |             |
                         v             |             v
                 "JUICE_RIME_NADE"     |     "JUICE_RIME_NADJ"
                 -----------------     |     -----------------
                                       |
                                       |
                                       |
                                       v
                                  "JUICE_RIME"
                                  ------------


RIME base frame
~~~~~~~~~~~~~~~

   RIME is a radar sounders nadir-looking active instrument based on a dipole
   antenna of 16 meters. This antenna is rigidly mounted on the science deck
   panel, perpendicular to the spacecraft YZ plane, and its radiation pattern
   is a toroid around the antenna's 4cm diameter cylindrical tube.

   In order to incorporate any misalignment between the antenna mounting and
   the spacecraft frame, the frame JUICE_RIME_BASE is defined:

      -  +X axis is along the antenna's cylindrical tube, nominally
         co-aligned with the +X spacecraft axis;

      -  +Z axis points along the +Z spacecraft axis, in the nominal
         nadir direction and corresponds to the maximum gain of the radiation
         pattern for all frequencies within the RIME bandwidth (see [9])

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the geometric centre of the RIME's
         antenna.


   This diagram illustrates nominal JUICE_RIME_BASE frame with respect to
   the spacecraft frame.

   +Z s/c side view:
   -----------------
                                         ..
                                         ||
                                         ||
                                         ||               direction
                                         ||               of flight
                         HGA   __________||           <-------------->
                               \         ||
      \                      .__`._____.'||.                      \
      /                      |           |||                      /
      \                      |           |||                      \
      /                      |   +Zsc    +Ysc  +Yrime_base        /
      \=>o<===============>o-|      o---->o----->=============>o<=\
      /    -Y Solar Array    |      |    |||    +Y Solar Array    /
      \                      |      |    |||                      \
      /                      .______|____||.                      /
      \                             |    |v                       \
                               +Xsc V    || +Xrime_base
                                         ||
                                         ||
                                         || RIME Antenna
                                         ||
                                         ||
                                         ||
                                         ..


                                             +Zsc, and +Zrime_base
                                             are out of page


   The JUICE_RIME_BASE frame is nominally co-aligned with spacecraft frame.


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_RIME_BASE            =  -28600
      FRAME_-28600_NAME                = 'JUICE_RIME_BASE'
      FRAME_-28600_CLASS               =   4
      FRAME_-28600_CLASS_ID            =  -28600
      FRAME_-28600_CENTER              =  -28600
      TKFRAME_-28600_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28600_SPEC              = 'ANGLES'
      TKFRAME_-28600_UNITS             = 'DEGREES'
      TKFRAME_-28600_ANGLES            = ( 0.0, 0.0, 0.0 )
      TKFRAME_-28600_AXES              = ( 1,   2,   3   )

   \begintext


RIME Nadir frames and radiation pattern frame
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   RIME operations, due to the design of the instrument, are not sensitive
   to along-track off-pointing of the spacecraft, i.e. any off-pointing
   about the +X spacecraft axis will not be noticed by RIME due to the
   antenna's radiation pattern. Therefore, for each of the JUICE targets,
   a RIME Nadir frame is defined taking this characteristic into account.

   In addition to these frames, which are target dependent, a generic
   RIME radiation pattern frame (JUICE_RIME) is provided. This later frame
   is a CK-based frame which takes into account, at different mission
   phases, the target being observed.

   The RIME Nadir frame(s) -- JUICE_RIME_NADC, JUICE_RIME_NADE,
   JUICE_RIME_NADG and JUICE_RIME_NADJ -- are defined as follows:

      -  +X axis is along the antenna's cylindrical tube, nominally
         co-aligned with the +X spacecraft axis;

      -  +Z axis is the component of the spacecraft to target vector which is
         perpendicular to the +X axis, with target either Callisto, Europa,
         Ganymede or Jupiter for JUICE_RIME_NADC, JUICE_RIME_NADE,
         JUICE_RIME_NADG and JUICE_RIME_NADJ respectively;

      -  +Y axis completes the right-handed system;

      -  the origin of this frame is the geometric centre of the RIME's
         antenna.

   All vectors are geometric: no corrections are used.

   The RIME radiation pattern (JUICE_RIME) frame is defined as follows:

      - For those missions phases where the spacecraft-target distance
        is less than maximum RIME operational requirement, the JUICE_RIME
        frame is co-aligned with the corresponding RIME Nadir frame for
        that given target.

      - For all other mission phases, the JUICE_RIME frame is co-aligned
        with the JUICE_RIME_BASE frame, i.e. nominally co-aligned with
        the JUICE_SPACECRAFT frame.


   Required Data:
   --------------
   The RIME Nadir frames are defined as a two-vector frame using two
   different types of specifications for the primary and secondary vectors.

   The primary vector is defined as a constant vector in the JUICE_RIME_BASE
   frame, which provides the orientation for the RIME's antenna cylindrical
   tube, fixed with respect to the spacecraft frame.

   The secondary vector is defined as an 'observer-target position'
   vector and gives the Nadir looking direction to the target body,
   therefore, the ephemeris data required to compute the JUICE-target
   vector in J2000 frame have to be loaded before using this frame, with
   target being either Callisto, Europa, Ganymede or Jupiter, depending
   on the frame.

   The RIME radiation pattern frame is a CK-based frame, therefore loading
   of a CK that contains orientation data for the JUICE_RIME frame is
   required.


   This diagram illustrates nominal JUICE_RIME_BASE frame with respect to
   the spacecraft frame, as well as the different JUICE_RIME_NADx frames
   when no roll, pitch and yaw operations are applied to the spacecraft.

   +Z s/c side view:
   -----------------
                                         ..
                                         ||
                                         ||
                                         ||               direction
                                         ||               of flight
                         HGA   __________||           <-------------->
                               \         ||
      \                      .__`._____.'||.                      \
      /                      |           |||                      /
      \                      |           |||   +Yrime_nad         \
      /                      |   +Zsc    +Ysc  +Yrime_base        /
      \=>o<===============>o-|      o---->o----->=============>o<=\
      /    -Y Solar Array    |      |    |||    +Y Solar Array    /
      \                      |      |    |||                      \
      /                      .______|____||.                      /
      \                             |    |v +Xrime_nad            \
                               +Xsc V    || +Xrime_base
                                         ||
                                         ||
                                         || RIME Antenna
                                         ||
                                         ||
                                         ||
                                         ..


                                             +Zsc, +Zrime_base and +Zrime_nad
                                             are out of page



   This diagram illustrates the JUICE_RIME_NADx frames when the spacecraft
   +Z axis is only off-pointed along-track.

   +X s/c side (HGA side) view:
   ----------------------------

                      .
            Target    |                           direction
                     /                            of Flight
                   .                           <-------------->
              -- '

                         ^ Nadir direction
                          \ +Zrime_nad
                           \
   \--------.               \                                .--------/
   /        |                \                               |        \
   \        |                 \ +Xrime_nad                   |        /
   /        |                  X---------.                   |        \
   \-.------'                .'|         |                   '------.-/
   /-"------. .-----------.'.  |  .---.  |   .-------------. .------"-\
   \       +Yrime_nad  .'   |-.|/ HGA   \| ,-|             | |        /
   /        |=|       v     | o|    x    |o  |             |=|        \
   \        | |             |_/|\       /| \_|             | |        /
   /-.------' '-------------'  | '.___.' |   '-------------' '------.-\
   \-"------.  +Y Solar Array  '---------'    -Y Solar Array .------"-/
   /        |                     /   \                      |        \
   \        |                     '---'                      |        /
   /        |      ^ +Zsc      Main Engine                   |        \
   \--------'      |                                         '--------/
                   |
          +Ysc     |
          <--------x                           +Xsc is into the page
                    +Xsc                       +Xrime_nad is into the page


   \begindata

      FRAME_JUICE_RIME              = -28601
      FRAME_-28601_NAME             = 'JUICE_RIME'
      FRAME_-28601_CLASS            =  3
      FRAME_-28601_CLASS_ID         = -28601
      FRAME_-28601_CENTER           = -28600
      CK_-28601_SCLK                = -28
      CK_-28601_SPK                 = -28

      FRAME_JUICE_RIME_NADC         = -28610
      FRAME_-28610_NAME             = 'JUICE_RIME_NADC'
      FRAME_-28610_CLASS            =  5
      FRAME_-28610_CLASS_ID         = -28610
      FRAME_-28610_CENTER           = -28600
      FRAME_-28610_RELATIVE         = 'JUICE_RIME_BASE'
      FRAME_-28610_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28610_FAMILY           = 'TWO-VECTOR'
      FRAME_-28610_PRI_AXIS         = 'X'
      FRAME_-28610_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_-28610_PRI_FRAME        = 'JUICE_RIME_BASE'
      FRAME_-28610_PRI_SPEC         = 'RECTANGULAR'
      FRAME_-28610_PRI_VECTOR       = ( 1, 0, 0 )
      FRAME_-28610_SEC_AXIS         = 'Z'
      FRAME_-28610_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28610_SEC_OBSERVER     = 'JUICE'
      FRAME_-28610_SEC_TARGET       = 'CALLISTO'
      FRAME_-28610_SEC_ABCORR       = 'NONE'

      FRAME_JUICE_RIME_NADE         = -28611
      FRAME_-28611_NAME             = 'JUICE_RIME_NADE'
      FRAME_-28611_CLASS            =  5
      FRAME_-28611_CLASS_ID         = -28611
      FRAME_-28611_CENTER           = -28600
      FRAME_-28611_RELATIVE         = 'JUICE_RIME_BASE'
      FRAME_-28611_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28611_FAMILY           = 'TWO-VECTOR'
      FRAME_-28611_PRI_AXIS         = 'X'
      FRAME_-28611_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_-28611_PRI_FRAME        = 'JUICE_RIME_BASE'
      FRAME_-28611_PRI_SPEC         = 'RECTANGULAR'
      FRAME_-28611_PRI_VECTOR       = ( 1, 0, 0 )
      FRAME_-28611_SEC_AXIS         = 'Z'
      FRAME_-28611_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28611_SEC_OBSERVER     = 'JUICE'
      FRAME_-28611_SEC_TARGET       = 'EUROPA'
      FRAME_-28611_SEC_ABCORR       = 'NONE'

      FRAME_JUICE_RIME_NADG         = -28612
      FRAME_-28612_NAME             = 'JUICE_RIME_NADG'
      FRAME_-28612_CLASS            =  5
      FRAME_-28612_CLASS_ID         = -28612
      FRAME_-28612_CENTER           = -28600
      FRAME_-28612_RELATIVE         = 'JUICE_RIME_BASE'
      FRAME_-28612_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28612_FAMILY           = 'TWO-VECTOR'
      FRAME_-28612_PRI_AXIS         = 'X'
      FRAME_-28612_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_-28612_PRI_FRAME        = 'JUICE_RIME_BASE'
      FRAME_-28612_PRI_SPEC         = 'RECTANGULAR'
      FRAME_-28612_PRI_VECTOR       = ( 1, 0, 0 )
      FRAME_-28612_SEC_AXIS         = 'Z'
      FRAME_-28612_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28612_SEC_OBSERVER     = 'JUICE'
      FRAME_-28612_SEC_TARGET       = 'GANYMEDE'
      FRAME_-28612_SEC_ABCORR       = 'NONE'

      FRAME_JUICE_RIME_NADJ         = -28613
      FRAME_-28613_NAME             = 'JUICE_RIME_NADJ'
      FRAME_-28613_CLASS            =  5
      FRAME_-28613_CLASS_ID         = -28613
      FRAME_-28613_CENTER           = -28600
      FRAME_-28613_RELATIVE         = 'JUICE_RIME_BASE'
      FRAME_-28613_DEF_STYLE        = 'PARAMETERIZED'
      FRAME_-28613_FAMILY           = 'TWO-VECTOR'
      FRAME_-28613_PRI_AXIS         = 'X'
      FRAME_-28613_PRI_VECTOR_DEF   = 'CONSTANT'
      FRAME_-28613_PRI_FRAME        = 'JUICE_RIME_BASE'
      FRAME_-28613_PRI_SPEC         = 'RECTANGULAR'
      FRAME_-28613_PRI_VECTOR       = ( 1, 0, 0 )
      FRAME_-28613_SEC_AXIS         = 'Z'
      FRAME_-28613_SEC_VECTOR_DEF   = 'OBSERVER_TARGET_POSITION'
      FRAME_-28613_SEC_OBSERVER     = 'JUICE'
      FRAME_-28613_SEC_TARGET       = 'JUPITER'
      FRAME_-28613_SEC_ABCORR       = 'NONE'

   \begintext


RPWI Frames
--------------------------------------------------------------------------

   This section contains the definition of the Radio & Plasma Waves
   Investigation (RPWI) structures, instruments and sensor frames.


RPWI Frame Tree
~~~~~~~~~~~~~~~

   The diagram below shows the RPWI frame hierarchy:


                              "JUICE_SPACECRAFT"
             +---------------------------------------------------+
             |            |            |            |            |
             |<-fixed     |            |<-fixed     |            |<-fixed
             |            |            |            |            |
             v            |            v            |            v
    "JUICE_RPWI_LPB1-H"   |   "JUICE_RPWI_LPB3-H"   |   "JUICE_RPWI_LPB4-H"
    -------------------   |   -------------------   |   -------------------
             |            |            |            |            |
             |<-ck        |            |<-ck        |            |<-ck
             |            |            |            |            |
             v            |            |            |            v
     "JUICE_RPWI_LPB1"    |    "JUICE_RPWI_LPB3"    |    "JUICE_RPWI_LPB4"
     -----------------    |    -----------------    |    -----------------
             |            |            |            |            |
      fixed->|            |            |<-fixed     |            |<-fixed
             |            |            |            |            |
             v            |            v            |            v
     "JUICE_RPWI_LP1"     |    "JUICE_RPWI_LP3"     |    "JUICE_RPWI_LP4"
     ----------------     |    ----------------     |    ----------------
                          |                         |
                   fixed->|                         |
                          |                         |
                          v                         |
                 "JUICE_RPWI_LPB2-H"                |
                 -------------------                |
                          |                         |
                          |<-ck                     |
                          |                         |
                          v                         |
                  "JUICE_RPWI_LPB2"                 |
                  -----------------                 |
                          |                         |
                   fixed->|                         |
                          |                         |
                          v                         |
                  "JUICE_RPWI_LP2"                  |
                  ----------------                  |
                                                    |<-fixed
                                                    |
                                                    v
                                            "JUICE_MAG_BOOM-H"
                                            ------------------
                                                    |
                                                    |<-ck
                                                    |
                                                    v
                                            "JUICE_MAG_BOOM"
                                   +-------------------------------+
                                   |                               |
                                   |<-fixed                        |<-fixed
                                   |                               |
                                   v                               v
                           "JUICE_RPWI_RWI"                 "JUICE_RPWI_SCM"
             +------------------------------------------+   ----------------
             |                     |                    |
             |<-fixed              |<-fixed             |<-fixed
             |                     |                    |
             v                     v                    v
     "JUICE_RPWI_RWI_EX"   "JUICE_RPWI_RWI_EY"   "JUICE_RPWI_RWI_EZ"
     -------------------   ------------------    -------------------


RPWI Langmuir probe boom hinge frames
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   Each of the 4 Langmuir probes of the RPWI is mounted on a separate 3-meter
   long deployable boom. See the latest JUICE structures SPK file [13] for
   the location of the booms on the spacecraft bus.

   The RPWI Langmuir probes boom hinge frames -- JUICE_RPWI_LPB1-H,
   JUICE_RPWI_LPB2-H, JUICE_RPWI_LPB3-H and JUICE_RPWI_LPB4-H -- are defined
   as follows (from [11]):

      -  +Z axis is normal to the hinge mounting plane, pointing outwards
         from the spacecraft bus;

      -  +X axis is parallel to the boom's hinge rotation axis;

      -  +Y axis is parallel to the boom and completes the right hand frame;

      -  the origin of the frame is located at the boom's hinge geometrical
         center.


   This diagram illustrates the nominal JUICE_RPWI_LPBx-H frames with respect
   to the spacecraft frame.

   +Z s/c side view:
   -----------------                                +Zlpb1-h
                                                    ^         direction
                                                   /          of flight
                                ____________HGA   /       <-------------->
                                \           /    /
      \                      .---`.-------.'---.x +Ylpb1-h            \
      /                      |                 | '                    /
      \           +Xlpb2-h   |                 |  '.                  \
      /               ^      |                 |     '. +Xlpb1-h      /
      \ -Y Solar Array \     |     +Zsc      +Ysc       >             \
      /=>o<=============\=>o-|        o--------->o<===============>o<=/
      \                  \   |        |        |                      \
      /                   \  |        |        |    +Y Solar Array    /
      \                    \ +Ylbp2-h |        |                      \
      /                     x.________|________.                      /
      \                   .'o+Ylpb3-h |         x +Ylpb4-h            \
                        .' '   '.     V   +Xsc /  '.
                      .'  /       '.          /      '.
            +Zlpb2-h v   .           >       /          '. +Zlpb4-h
                        v        +Xlpb3-h   /              >
                       +Zlpb3-h            v +Xlpb4-h

                                             +Zsc and Ylpb3-h are out of the
                                             page. +Ylpb1-h, +Ylpb2-h and
                                             +Ylpb4-h are into the page.



   Nominally, the following rotations, first about +Z and then about
   +X, are required in order to align each of the JUICE_RPWI_LPBx-H
   frames to the s/c frame.

                             Rotation      Rotation
       `To' frame            about +Z      about +X
      -------------------   -----------   ----------
       JUICE_RPWI_LPB1-H     +48.0 deg     -90.0 deg
       JUICE_RPWI_LPB2-H    -138.0 deg     -90.0 deg
       JUICE_RPWI_LPB3-H     +60.0 deg      90.0 deg
       JUICE_RPWI_LPB4-H     -42.0 deg     -90.0 deg


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_RPWI_LPB1-H          =  -28700
      FRAME_-28700_NAME                = 'JUICE_RPWI_LPB1-H'
      FRAME_-28700_CLASS               =  4
      FRAME_-28700_CLASS_ID            =  -28700
      FRAME_-28700_CENTER              =  -28701
      TKFRAME_-28700_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28700_SPEC              = 'ANGLES'
      TKFRAME_-28700_UNITS             = 'DEGREES'
      TKFRAME_-28700_AXES              = ( 2,      3,      1   )
      TKFRAME_-28700_ANGLES            = ( 0.0,  -48.0,   90.0 )

      FRAME_JUICE_RPWI_LPB2-H          =  -28710
      FRAME_-28710_NAME                = 'JUICE_RPWI_LPB2-H'
      FRAME_-28710_CLASS               =  4
      FRAME_-28710_CLASS_ID            =  -28710
      FRAME_-28710_CENTER              =  -28711
      TKFRAME_-28710_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28710_SPEC              = 'ANGLES'
      TKFRAME_-28710_UNITS             = 'DEGREES'
      TKFRAME_-28710_AXES              = ( 2,      3,      1   )
      TKFRAME_-28710_ANGLES            = ( 0.0,  138.0,   90.0 )

      FRAME_JUICE_RPWI_LPB3-H          =  -28720
      FRAME_-28720_NAME                = 'JUICE_RPWI_LPB3-H'
      FRAME_-28720_CLASS               =  4
      FRAME_-28720_CLASS_ID            =  -28720
      FRAME_-28720_CENTER              =  -28721
      TKFRAME_-28720_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28720_SPEC              = 'ANGLES'
      TKFRAME_-28720_UNITS             = 'DEGREES'
      TKFRAME_-28720_AXES              = ( 2,      3,      1   )
      TKFRAME_-28720_ANGLES            = ( 0.0,  -60.0,  -90.0 )

      FRAME_JUICE_RPWI_LPB4-H          =  -28730
      FRAME_-28730_NAME                = 'JUICE_RPWI_LPB4-H'
      FRAME_-28730_CLASS               =  4
      FRAME_-28730_CLASS_ID            =  -28730
      FRAME_-28730_CENTER              =  -28731
      TKFRAME_-28730_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28730_SPEC              = 'ANGLES'
      TKFRAME_-28730_UNITS             = 'DEGREES'
      TKFRAME_-28730_AXES              = ( 2,      3,      1   )
      TKFRAME_-28730_ANGLES            = ( 0.0,   42.0,   90.0 )

   \begintext


RPWI Langmuir Probe Booms frames
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   The RPWI Langmuir Probe Booms frames -- JUICE_RPWI_LPB1, JUICE_RPWI_LPB2,
   JUICE_RPWI_LPB3 and JUICE_RPWI_LPB4 -- are defined as follows (from [11]):

      -  +Y axis is parallel to the boom, pointing outwards from the hinge
         towards the tip of the boom in deployed configuration;

      -  +X axis is parallel to the boom's hinge rotation axis;

      -  +Z axis completes the right hand frame;

      -  the origin of the frame is located at the boom's hinge geometrical
         center.


   This diagram illustrates the nominal JUICE_RPWI_LPBx frame with respect to
   the JUICE_RPWI_LPBx-H frame.

   +X Langmuir Probe side view:
   ----------------------------

                              .---. Langmuir Probe
                             /     \
                             |     |
                              '...' ---
                                  \\  \
                                   \\  \
                                    \\  \
                                     \\  \
                                      ~~ ~3m
                                       ~~  \
                                    +Ylpb^  \
                                         \\  \ ^ +Zlpb-h
                                          \\  \|
                                45 deg   .-\\  |
                                      ,'    \\.|\
                                     .     .--\|--.  +Ylbp-h
                        //-----------------'--.o------->--------//
                                            .'    spacecraft deck
                                          .'
                                  +Zlpb .'
                                      <'                      +Xlpb-h and
                                                            +Xlpb are out of
                                                            the page.


   These sets of keywords define the Langmuir Probe's boom frames as CK
   frames:

   \begindata

      FRAME_JUICE_RPWI_LPB1            =  -28701
      FRAME_-28701_NAME                = 'JUICE_RPWI_LPB1'
      FRAME_-28701_CLASS               =  3
      FRAME_-28701_CLASS_ID            =  -28701
      FRAME_-28701_CENTER              =  -28701
      CK_-28701_SCLK                   =  -28
      CK_-28701_SPK                    =  -28

      FRAME_JUICE_RPWI_LPB2            =  -28711
      FRAME_-28711_NAME                = 'JUICE_RPWI_LPB2'
      FRAME_-28711_CLASS               =  3
      FRAME_-28711_CLASS_ID            =  -28711
      FRAME_-28711_CENTER              =  -28711
      CK_-28711_SCLK                   =  -28
      CK_-28711_SPK                    =  -28

      FRAME_JUICE_RPWI_LPB3            =  -28721
      FRAME_-28721_NAME                = 'JUICE_RPWI_LPB3'
      FRAME_-28721_CLASS               =  3
      FRAME_-28721_CLASS_ID            =  -28721
      FRAME_-28721_CENTER              =  -28721
      CK_-28721_SCLK                   =  -28
      CK_-28721_SPK                    =  -28

      FRAME_JUICE_RPWI_LPB4            =  -28731
      FRAME_-28731_NAME                = 'JUICE_RPWI_LPB4'
      FRAME_-28731_CLASS               =  3
      FRAME_-28731_CLASS_ID            =  -28731
      FRAME_-28731_CENTER              =  -28731
      CK_-28731_SCLK                   =  -28
      CK_-28731_SPK                    =  -28

   \begintext


RPWI Langmuir Probes, RWI base and SCM frames
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   The RPWI Langmuir Probes frames -- JUICE_RPWI_LP1, JUICE_RPWI_LP2,
   JUICE_RPWI_LP3 and JUICE_RPWI_LP4, the Radio Wave Instrument (RWI)
   base frame -- JUICE_RPWI_SWI -- and the RPWI Search Coil Magnetometer
   (SCM) frame -- JUICE_RPWI_SCM -- are defined as follows (from [11]):

      -  +Z axis is parallel to the boom, pointing outwards from the hinge
         towards the tip of the boom in deployed configuration;

      -  +X axis is parallel to the boom's hinge rotation axis;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the sensor's geometrical
         center.


   This diagram illustrates the nominal JUICE_RPWI_LPx frame with respect to
   the JUICE_RPWI_LPBx frame and the JUICE_RPWI_SCM frame with respect to the
   JUICE_MAG_BOOM frame

   +X Langmuir Probe and SCM side view:
   ------------------------------------

                    ^ +Zlp                               ~~~ MAG boom
                    |                                    | |
                    |                                    | |
                 .--|--. Langmuir Probe                  | |
                /   |   \                                |^ +Zscm
                |   o---------->                         |||
                 +Xlp   /     +Ylp                   .---.||    SCM sensor
                 '-----'                      =========| |||==========
                   | |                     ==========| |==|========
                   | |                               '---'o----------->
                   | |                               +Xscm |       +Yscm
                   | |                                   | |
                   ~~~                                   ~~~
                   ~~~                            ~      ~~~     ~
                   | |                             \     | |    /
                   |^ +Ylpb                         \    |^ +Zrwi
                   |||                               \   |||  /
                   |||                      .         \  ||| /
          +Zlpb     |                         ` .      \ |||/
            <-------o                             ` .   \|||    +Yrwi
                    +Xlpb                             ` .=o------->
                                                     +Xrwi ` .
                                                       / | |\  ` .
                                                      /  | | \     ` .
                                                     /   ~~~  \        ` .
                                                    ~    ~~~   ~
                                                         | |
                                                         |^ +Zmagb
                                                         |||
                                                         |||
                                                         |||      +Ymagb
                                                          o-------->
                                                    +Xmagb


                                                +Xlpb, +Xmagb, +Xlp and
                                                +Xscm are out of the page.


   Nominally, the SCM and RWI base frames are co-aligned with the MAG boom
   frame. A single rotation of -90 degrees about the +X axis of the
   JUICE_RPWI_LPBx is required to co-align the Langmuir Probe frame and the
   corresponding boom's frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.


   \begindata

      FRAME_JUICE_RPWI_LP1             =  -28705
      FRAME_-28705_NAME                = 'JUICE_RPWI_LP1'
      FRAME_-28705_CLASS               =  4
      FRAME_-28705_CLASS_ID            =  -28705
      FRAME_-28705_CENTER              =  -28705
      TKFRAME_-28705_RELATIVE          = 'JUICE_RPWI_LPB1'
      TKFRAME_-28705_SPEC              = 'ANGLES'
      TKFRAME_-28705_UNITS             = 'DEGREES'
      TKFRAME_-28705_AXES              = ( 3,   2,    1   )
      TKFRAME_-28705_ANGLES            = ( 0.0, 0.0, 90.0 )

      FRAME_JUICE_RPWI_LP2             =  -28715
      FRAME_-28715_NAME                = 'JUICE_RPWI_LP2'
      FRAME_-28715_CLASS               =  4
      FRAME_-28715_CLASS_ID            =  -28715
      FRAME_-28715_CENTER              =  -28715
      TKFRAME_-28715_RELATIVE          = 'JUICE_RPWI_LPB2'
      TKFRAME_-28715_SPEC              = 'ANGLES'
      TKFRAME_-28715_UNITS             = 'DEGREES'
      TKFRAME_-28715_AXES              = ( 3,   2,    1   )
      TKFRAME_-28715_ANGLES            = ( 0.0, 0.0, 90.0 )

      FRAME_JUICE_RPWI_LP3             =  -28725
      FRAME_-28725_NAME                = 'JUICE_RPWI_LP3'
      FRAME_-28725_CLASS               =  4
      FRAME_-28725_CLASS_ID            =  -28725
      FRAME_-28725_CENTER              =  -28725
      TKFRAME_-28725_RELATIVE          = 'JUICE_RPWI_LPB3'
      TKFRAME_-28725_SPEC              = 'ANGLES'
      TKFRAME_-28725_UNITS             = 'DEGREES'
      TKFRAME_-28725_AXES              = ( 3,   2,    1   )
      TKFRAME_-28725_ANGLES            = ( 0.0, 0.0, 90.0 )

      FRAME_JUICE_RPWI_LP4             =  -28735
      FRAME_-28735_NAME                = 'JUICE_RPWI_LP4'
      FRAME_-28735_CLASS               =  4
      FRAME_-28735_CLASS_ID            =  -28735
      FRAME_-28735_CENTER              =  -28735
      TKFRAME_-28735_RELATIVE          = 'JUICE_RPWI_LPB4'
      TKFRAME_-28735_SPEC              = 'ANGLES'
      TKFRAME_-28735_UNITS             = 'DEGREES'
      TKFRAME_-28735_AXES              = ( 3,   2,    1   )
      TKFRAME_-28735_ANGLES            = ( 0.0, 0.0, 90.0 )

      FRAME_JUICE_RPWI_RWI             =  -28740
      FRAME_-28740_NAME                = 'JUICE_RPWI_RWI'
      FRAME_-28740_CLASS               =  4
      FRAME_-28740_CLASS_ID            =  -28740
      FRAME_-28740_CENTER              =  -28740
      TKFRAME_-28740_RELATIVE          = 'JUICE_MAG_BOOM'
      TKFRAME_-28740_SPEC              = 'ANGLES'
      TKFRAME_-28740_UNITS             = 'DEGREES'
      TKFRAME_-28740_AXES              = ( 1,   2,   3   )
      TKFRAME_-28740_ANGLES            = ( 0.0, 0.0, 0.0 )

      FRAME_JUICE_RPWI_SCM             =  -28750
      FRAME_-28750_NAME                = 'JUICE_RPWI_SCM'
      FRAME_-28750_CLASS               =  4
      FRAME_-28750_CLASS_ID            =  -28750
      FRAME_-28750_CENTER              =  -28750
      TKFRAME_-28750_RELATIVE          = 'JUICE_MAG_BOOM'
      TKFRAME_-28750_SPEC              = 'ANGLES'
      TKFRAME_-28750_UNITS             = 'DEGREES'
      TKFRAME_-28750_AXES              = ( 1,   2,   3   )
      TKFRAME_-28750_ANGLES            = ( 0.0, 0.0, 0.0 )

   \begintext


SWI Frames
--------------------------------------------------------------------------

   This section contains the definition of the Sub-millimeter Wave
   Instrument (SWI) instrument frames.

   SWI is on the nadir platform in order to observe the target in nadir and
   limb viewing geometry. A clear field of view of +/-76 degrees along the
   track for 1) scanning across Jupiter, 2) viewing the Galilean satellites
   and 3) viewing cold space for calibration purpose is needed. Across the
   track SWI needs just a clear field of view of +/-4.3 degrees to scan across
   Jupiter in North- South direction.


SWI Frame Tree
~~~~~~~~~~~~~~~

   The diagram below shows the SWI frame hierarchy:

                             "JUICE_SPACECRAFT"
                             ------------------
                                     |
                                     |<-fixed
                                     |
                                     v
                              "JUICE_SWI_BASE"
                              ----------------
                                     |
                                     |
                                     |<-CK
                                     |
                                     v
                            "JUICE_SWI_SCANNER"
                            -------------------


SWI instrument Base frame
~~~~~~~~~~~~~~~~~~~~~~~~~

   The SWI base frame, JUICE_SWI_BASE, is fixed with respect to the
   spacecraft and defined as follows:

      -  +Z axis is normal to the instrument mounting plane and points
         towards the Nadir direction; it is nominally aligned to the +Z
         spacecraft axis;

      -  +X axis is nominally aligned to the +X spacecraft axis -- during the
         Jupiter phase the +X axis is aligned with the along-track direction
         whereas during the Ganymede phase, it is aligned with the cross-track
         direction; that is, tilted by 90 deg --.

      -  +Y axis completes the right-handed frame;

      -  the origin of the frame is at the center of the reference
         mounting hole.


   Any misalignment between the nominal and actual SWI mounting alignment
   measured pre-launch should be incorporated into the definition of this
   frame.


   This diagram illustrates nominal JUICE_SWI_BASE frame with respect to
   the spacecraft frame.

   +Z s/c side view:
   -----------------
                                                          direction
                                                          of flight
                               ___________ HGA        <-------------->
                               \         /
      \                      .__`._____.'__.                      \
      /                      |             |                      /
      \                      |             |                      \
      /                      |   +Zsc    +Ysc                     /
      \=>o<===============>o-|      o------->o<===============>o<=\
      /    -Y Solar Array    |___.  |      |    +Y Solar Array    /
      \                      | o------>    |                      \
      /                      ._|_|__|__+Yswi_base                 /
      \                        |    |                             \
                               |    V +Xsc
                               V
                                +Xswi_base
                                             +Zsc and +Zswi_base are
                                                 out of page


   Nominally, the SWI base frame is co-aligned with the s/c frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_SWI_BASE             =  -28800
      FRAME_-28800_NAME                = 'JUICE_SWI_BASE'
      FRAME_-28800_CLASS               =  4
      FRAME_-28800_CLASS_ID            =  -28800
      FRAME_-28800_CENTER              =  -28800
      TKFRAME_-28800_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28800_SPEC              = 'ANGLES'
      TKFRAME_-28800_UNITS             = 'DEGREES'
      TKFRAME_-28800_AXES              = ( 1,   2,   3   )
      TKFRAME_-28800_ANGLES            = ( 0.0, 0.0, 0.0 )

   \begintext


SWI Scanner frame:
~~~~~~~~~~~~~~~~~~

   SWI telescope is equipped with a two-axis scan mechanism to allow
   scanning around the nadir viewing direction in a range of +/- 76
   degrees inside the spacecraft's orbital plane (along-track) and
   +/- 4.3 degree perpendicular to the plane (across-track)  during the
   Jupiter phase (see [6]).

   The SWI Scanner frame, JUICE_SWI_SCANNER, is a CK-based frame defined
   as follows:

      -  +Z axis is aligned to the SWI antenna boresight direction; i.e.
         direction of maximum gain of the receiver radiation pattern. In
         the scanning mechanism "zero" position, it is nominally co-aligned
         to the JUICE_SWI_BASE +Z axis and points Nadir;

      -  +X axis is parallel to the shortest side of the Telescope and
         Receiver Unit. In the scanning mechanism "zero position", it is
         nominally aligned to the +X spacecraft axis and the +X axis of the
         JUICE_SWI_BASE frame;

      -  +Y axis completes the right-handed frame;

      -  the origin of the frame is located at the geometric center of the
         primary reflector dish outer rim circle.


   \begindata

      FRAME_JUICE_SWI_SCANNER       = -28810
      FRAME_-28810_NAME             = 'JUICE_SWI_SCANNER'
      FRAME_-28810_CLASS            =  3
      FRAME_-28810_CLASS_ID         = -28810
      FRAME_-28810_CENTER           = -28800
      CK_-28810_SCLK                = -28
      CK_-28810_SPK                 = -28

   \begintext


UVS Frames
--------------------------------------------------------------------------

   This section contains the definition of the Ultraviolet Spectrograph
   (UVS) instrument frames.


UVS Frame Tree
~~~~~~~~~~~~~~~

   The diagram below shows the UVS frame hierarchy:

                             "JUICE_SPACECRAFT"
                             ------------------
                                     |
                                     |<-fixed
                                     |
                                     v
                                "JUICE_UVS"
                                -----------
                                     |
                                     |
                                     |<-fixed
                                     |
                                     v
                               "JUICE_UVS_SP"
                               --------------


UVS instrument frame
~~~~~~~~~~~~~~~~~~~~

   The Ultraviolet Spectrograph is rigidly mounted on the spacecraft science
   deck, with its main entrance aperture in the +Z spacecraft panel and a
   solar aperture in the +X spacecraft panel.

   Therefore, the frame associated with it -- the UVS instrument base
   frame, JUICE_UVS --  is specified as a fixed offset frame relative
   with its orientation given relative to the JUICE_SPACECRAFT frame.

   The UVS instrument frame is defined by the spectrograph design
   and its mounting on the spacecraft as follows:

      -  +Z axis is along the nominal UVS main entrance aperture boresight;
         it is nominally co-aligned with the spacecraft +Z axis;

      -  +X axis is parallel to the apparent spatial resolution
         direction (i.e. along the slit); it is nominally co-aligned
         with the spacecraft +X axis;

      -  +Y axis completes the right hand frame; it is nominally
         co-aligned with the s/c +Y axis;

      -  the origin of the frame is located at the instrument focal
         point.


   Any misalignment between the nominal and actual UVS mounting alignment
   measured pre-launch should be incorporated into the definition of this
   frame.

   This diagram illustrates nominal JUICE_UVS frame with respect to
   the spacecraft frame.


   +Z s/c side view:
   -----------------
                                                          direction
                                                          of flight
                               ___________ HGA        <-------------->
                               \         /
      \                      .__`._____.'__.                      \
      /                      |             |                      /
      \                      |             |                      \
      /                      |   +Zsc    +Ysc                     /
      \=>o<===============>o-|      o------->o<===============>o<=\
      /    -Y Solar Array    |      |  .___|    +Y Solar Array    /
      \                      |      |  | o------>                 \
      /                      .______|__|_|_.   +Yuvs              /
      \                             |    |                        \
                               +Xsc V    |
                                         v
                                          +Xuvs

                                             +Zsc and +Zuvs_base are
                                                 out of page


   Nominally, the UVS instrument frame is co-aligned with the s/c frame.

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_UVS                  =  -28850
      FRAME_-28850_NAME                = 'JUICE_UVS'
      FRAME_-28850_CLASS               =  4
      FRAME_-28850_CLASS_ID            =  -28850
      FRAME_-28850_CENTER              =  -28850
      TKFRAME_-28850_RELATIVE          = 'JUICE_SPACECRAFT'
      TKFRAME_-28850_SPEC              = 'ANGLES'
      TKFRAME_-28850_UNITS             = 'DEGREES'
      TKFRAME_-28850_AXES              = ( 1,   2,   3   )
      TKFRAME_-28850_ANGLES            = ( 0.0, 0.0, 0.0 )

   \begintext


UVS Solar Port frame
~~~~~~~~~~~~~~~~~~~~

   The UVS Solar Port (SP) frame, JUICE_UVS_AP, is defined as follows
   (from [5], pp. 53 and 54):

      -  +Z axis is along the nominal UVS solar port aperture boresight,
         which is located on the +Y spacecraft panel; it is nominally at
         an angle of 60 degrees from the main entrance Airglow Port (AP)
         towards UVS +Y axis;

      -  +X axis is aligned with the apparent spatial resolution
         direction (i.e. along the main slit); it is nominally co-aligned
         with the UVS +X axis;

      -  +Y axis completes the right hand frame;

      -  the origin of the frame is located at the instrument focal
         point.

   Any misalignment between the UVS nominal boresight direction and the
   solar port boresight direction measured post instrument integration
   should be incorporated into the definition of this frame.

   This diagram illustrates nominal JUICE_UVS_SP frame with respect to
   the JUICE_UVS frame.


   -Y UVS instrument side:
   -----------------------

   +Ysc            +Zsc
     x-------------->
     |
     |  .------------------------------------.
     |  |  C&DH                              |
     |  |                 LVPS               |
     |  +------------.                       |
     v  |          .-|           HVPS        |
   +Xsc | Detector | '-----------------------'--.
        |  elect.  |        ,---,             . |
        |          |   Detector/              |<-- Grating
        |          |      /   /               ' |
        +----------'-----'---'--  --------------|
        |   . +Yuvs          +Yuvs_sp                   +Zuvs
    OAP --> |   x--------------x--------------------------> AP & HP nominal
        |   '   |            .' `.   60 deg                 boresight
        '-------|----------.'---. `.  .---------'
                |        .'      `. `. `.
                |      .'          `. `. `.
                |     v              `. `.
                v     +Xuvs_sp            `.
            +Xuvs                           v +Zuvs_sp
                                                SP nominal boresight


                                                    +Ysc, +Yuvs and +Yuvs_sp
                                                    are into the page

   Since the SPICE frames subsystem calls for specifying the reverse
   transformation--going from the instrument or structure frame to the
   base frame--as compared to the description given above, the order of
   rotations assigned to the TKFRAME_*_AXES keyword is also reversed
   compared to the above text, and the signs associated with the
   rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
   opposite from what is written in the above text.

   \begindata

      FRAME_JUICE_UVS_SP               =  -28870
      FRAME_-28870_NAME                = 'JUICE_UVS_SP'
      FRAME_-28870_CLASS               =  4
      FRAME_-28870_CLASS_ID            =  -28870
      FRAME_-28870_CENTER              =  -28850
      TKFRAME_-28870_RELATIVE          = 'JUICE_UVS'
      TKFRAME_-28870_SPEC              = 'ANGLES'
      TKFRAME_-28870_UNITS             = 'DEGREES'
      TKFRAME_-28870_AXES              = (    3,     1,   3   )
      TKFRAME_-28870_ANGLES            = (  0.0,  60.0,   0.0 )

   \begintext


JUICE NAIF ID Codes -- Definitions
==============================================================================

   This section contains name to NAIF ID mappings for the JUICE mission.
   Once the contents of this file is loaded into the KERNEL POOL, these
   mappings become available within SPICE, making it possible to use
   names instead of ID code in the high level SPICE routine calls.


   Spacecraft:
   -----------

   TODO:update

      This table presents the JUICE Spacecraft and its main
      structures' names and IDs

      Name                   ID       Synonyms
      ---------------------  -------  --------------------------
      JUICE                  -28      JUPITER ICY MOONS EXPLORER
      JUICE_SPACECRAFT       -28000   JUICE_SC

      JUICE_SA+Y             -28011
      JUICE_SA-Y             -28013

      JUICE_HGA              -28020

      JUICE_MAG_BOOM         -28030

      JUICE_MGA              -28044

      JUICE_LGA+X            -28045
      JUICE_LGA-X            -28046

      JUICE_STR-OH1          -28061
      JUICE_STR-OH2          -28062
      JUICE_STR-OH3          -28063

      Notes:

         -- 'JUICE' and 'JUPITER ICY MOONS EXPLORER' are synonyms and all map
            to the JUICE spacecraft ID (-28);

         -- 'JUICE_SC' and 'JUICE_SPACECRAFT' are synonyms and all map to the
            JUICE s/c bus structure ID (-28000);


      The mappings summarized in this table are implemented by the keywords
      below.

    \begindata

      NAIF_BODY_NAME += ( 'JUPITER ICY MOONS EXPLORER'  )
      NAIF_BODY_CODE += ( -28                           )

      NAIF_BODY_NAME += ( 'JUICE'                       )
      NAIF_BODY_CODE += ( -28                           )

      NAIF_BODY_NAME += ( 'JUICE_SC'                    )
      NAIF_BODY_CODE += ( -28000                        )

      NAIF_BODY_NAME += ( 'JUICE_SPACECRAFT'            )
      NAIF_BODY_CODE += ( -28000                        )

      NAIF_BODY_NAME += ( 'JUICE_SA+Y'                  )
      NAIF_BODY_CODE += ( -28011                        )

      NAIF_BODY_NAME += ( 'JUICE_SA-Y'                  )
      NAIF_BODY_CODE += ( -28013                        )

      NAIF_BODY_NAME += ( 'JUICE_HGA'                   )
      NAIF_BODY_CODE += ( -28020                        )

      NAIF_BODY_NAME += ( 'JUICE_MAG_BOOM'              )
      NAIF_BODY_CODE += ( -28031                        )

      NAIF_BODY_NAME += ( 'JUICE_MGA_APM'               )
      NAIF_BODY_CODE += ( -28040                        )

      NAIF_BODY_NAME += ( 'JUICE_MGA'                   )
      NAIF_BODY_CODE += ( -28044                        )

      NAIF_BODY_NAME += ( 'JUICE_LGA+X'                 )
      NAIF_BODY_CODE += ( -28045                        )

      NAIF_BODY_NAME += ( 'JUICE_LGA-X'                 )
      NAIF_BODY_CODE += ( -28046                        )

      NAIF_BODY_NAME += ( 'JUICE_NAVCAM-1'              )
      NAIF_BODY_CODE += ( -28051                        )

      NAIF_BODY_NAME += ( 'JUICE_NAVCAM-2'              )
      NAIF_BODY_CODE += ( -28052                        )

      NAIF_BODY_NAME += ( 'JUICE_STR-OH1'               )
      NAIF_BODY_CODE += ( -28061                        )

      NAIF_BODY_NAME += ( 'JUICE_STR-OH2'               )
      NAIF_BODY_CODE += ( -28062                        )

      NAIF_BODY_NAME += ( 'JUICE_STR-OH3'               )
      NAIF_BODY_CODE += ( -28063                        )

      NAIF_BODY_NAME += ( 'JUICE_JMC-1'                 )
      NAIF_BODY_CODE += ( -28081                        )

      NAIF_BODY_NAME += ( 'JUICE_JMC-2'                 )
      NAIF_BODY_CODE += ( -28082                        )

    \begintext


   Natural Bodies and Models:
   --------------------------

      This table presents the JUICE Natural Bodies and Models and its main
      structures' names and IDs

      Name                   ID       Synonyms
      ---------------------  -------  --------------------------
      JUICE_IO_PLASMA_TORUS  -28968  JUPITER ICY MOONS EXPLORER


      The mappings summarized in this table are implemented by the keywords
      below.

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_IO_PLASMA_TORUS'       )
      NAIF_BODY_CODE += ( -28968                        )

   \begintext


   GAnymede Laser Altimeter:
   -------------------------

      This table presents the GAnymede Laser Altimeter (GALA) instrument
      and structures' names and IDs:

      Name                   ID       Synonyms
      ---------------------  -------  -----------------------
      JUICE_GALA             -28100
      JUICE_GALA_LHM         -28110
      JUICE_GALA_RXT         -28120


      The mappings summarized in this table are implemented by the keywords
      below.

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_GALA'                  )
      NAIF_BODY_CODE += ( -28100                        )

      NAIF_BODY_NAME += ( 'JUICE_GALA_LHM'              )
      NAIF_BODY_CODE += ( -28110                        )

      NAIF_BODY_NAME += ( 'JUICE_GALA_RXT'              )
      NAIF_BODY_CODE += ( -28120                        )

   \begintext


   Jovis, Amorum ac Natorum Undique Scrutator:
   -------------------------------------------

      This table presents the Jovis, Amorum ac Natorum Undique Scrutator
      (JANUS) instrument name and ID:

      Name                   ID       Synonyms
      ---------------------  -------  -----------------------
      JUICE_JANUS            -28200


      The mappings summarized in this table are implemented by the keywords
      below.

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_JANUS'                 )
      NAIF_BODY_CODE += ( -28200                        )

   \begintext


   Magnetometer:
   -------------

      This table presents the Magnetometer (J-MAG) instrument and J-MAG
      Alignment Calibration Systems sensors names and IDs:

      Name                   ID       Synonyms
      ---------------------  -------  -----------------------
      JUICE_JMAG_MAGIBS      -28300
      JUICE_JMAG_MAGOBS      -28310
      JUICE_JMAG_MAGSCA      -28320
      JUICE_JMAG_JACS-X      -28330
      JUICE_JMAG_JACS-Y      -28331


      The mappings summarized in this table are implemented by the keywords
      below.

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_JMAG_MAGIBS'           )
      NAIF_BODY_CODE += ( -28300                        )

      NAIF_BODY_NAME += ( 'JUICE_JMAG_MAGOBS'           )
      NAIF_BODY_CODE += ( -28310                        )

      NAIF_BODY_NAME += ( 'JUICE_JMAG_MAGSCA'           )
      NAIF_BODY_CODE += ( -28320                        )

      NAIF_BODY_NAME += ( 'JUICE_JMAG_JACS-X'           )
      NAIF_BODY_CODE += ( -28330                        )

      NAIF_BODY_NAME += ( 'JUICE_JMAG_JACS-Y'           )
      NAIF_BODY_CODE += ( -28331                        )

   \begintext



   Moons And Jupiter Imaging Spectrometer:
   ---------------------------------------

      This table presents the Moons And Jupiter Imaging Spectrometer (MAJIS)
      instrument and structures' names and IDs:

      Name                   ID       Synonyms
      ---------------------  -------  -----------------------
      JUICE_MAJIS            -28400
      JUICE_MAJIS_VISNIR     -28410
      JUICE_MAJIS_VISNIR_B2  -28412
      JUICE_MAJIS_VISNIR_B4  -28414
      JUICE_MAJIS_IR         -28420
      JUICE_MAJIS_IR_B2      -28422
      JUICE_MAJIS_IR_B4      -28424


      The mappings summarized in this table are implemented by the keywords
      below.

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_MAJIS'                 )
      NAIF_BODY_CODE += ( -28400                        )

      NAIF_BODY_NAME += ( 'JUICE_MAJIS_VISNIR'          )
      NAIF_BODY_CODE += ( -28410                        )

      NAIF_BODY_NAME += ( 'JUICE_MAJIS_VISNIR_B2'       )
      NAIF_BODY_CODE += ( -28412                        )

      NAIF_BODY_NAME += ( 'JUICE_MAJIS_VISNIR_B4'       )
      NAIF_BODY_CODE += ( -28414                        )

      NAIF_BODY_NAME += ( 'JUICE_MAJIS_IR'              )
      NAIF_BODY_CODE += ( -28420                        )

      NAIF_BODY_NAME += ( 'JUICE_MAJIS_IR_B2'           )
      NAIF_BODY_CODE += ( -28422                        )

      NAIF_BODY_NAME += ( 'JUICE_MAJIS_IR_B4'           )
      NAIF_BODY_CODE += ( -28424                        )

   \begintext



   Particle Environment Package:
   -----------------------------

      This table presents the Particle Environment Package (PEP)
      instrument and sensor names and IDs:

      Name                       ID           Synonyms
      -------------------------  -----------  -----------------------
      JUICE_PEP_JDC              -28510
      JUICE_PEP_JNA              -28520
      JUICE_PEP_NIM              -28530
      JUICE_PEP_NIM_NEUION       -28539
      JUICE_PEP_NIM_NEUION_S1    -28531
      JUICE_PEP_NIM_NEUION_S2    -28532
      JUICE_PEP_NIM_NEUION_S3    -28533
      JUICE_PEP_NIM_NEUION_S4    -28534
      JUICE_PEP_NIM_NEUION_S5    -28535
      JUICE_PEP_NIM_NEUION_S6    -28536
      JUICE_PEP_NIM_THERMAL-1    -28538
      JUICE_PEP_NIM_THERMAL-2    -28539
      JUICE_PEP_JEI              -28540
      JUICE_PEP_JOEE             -28550
      JUICE_PEP_JENI             -28560
      JUICE_PEP_JDC_PIXEL_NNN    -2851NNN*
      JUICE_PEP_JNA_SECTOR_NN    -2852NN**
      JUICE_PEP_JEI_NN_M         -2852NN***

      * There are NNN NAIF ID codes for the JUICE_PEP_JDC_PIXEL elements.
        NNN is the pixel number and ranges from 000 to 191.

      ** There are NN NAIF ID codes for the JUICE_PEP_JNI_SECTOR elements.
         NN is the sector number and ranges from 00 to 11.

      *** For each M (L, M and H) there are NN NAIF ID codes for the
          JUICE_PEP_JEI elements. NN is the azimuthal sector number and
          ranges from 00 to 15.

      DISCLAIMER: Please note that the JUICE_PEP_JDC_PIXEL_NNN*, the
      JUICE_PEP_JNA_SECTOR_NN** and the  JUICE_PEP_JEI_NNN_M
      NAIF ID definitions are not included in the JUICE Frames Kernel file
      (juice_vNN.tf, where NN is the version number of the file).

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_PEP_JDC'               )
      NAIF_BODY_CODE += ( -28510                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_JNA'               )
      NAIF_BODY_CODE += ( -28520                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM'               )
      NAIF_BODY_CODE += ( -28530                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM_NEUION'        )
      NAIF_BODY_CODE += ( -28539                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM_NEUION_S1'     )
      NAIF_BODY_CODE += ( -28531                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM_NEUION_S2'     )
      NAIF_BODY_CODE += ( -28532                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM_NEUION_S3'     )
      NAIF_BODY_CODE += ( -28533                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM_NEUION_S4'     )
      NAIF_BODY_CODE += ( -28534                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM_NEUION_S5'     )
      NAIF_BODY_CODE += ( -28535                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM_NEUION_S6'     )
      NAIF_BODY_CODE += ( -28536                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM_THERMAL-1'     )
      NAIF_BODY_CODE += ( -28538                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_NIM_THERMAL-2'     )
      NAIF_BODY_CODE += ( -28539                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_JEI'               )
      NAIF_BODY_CODE += ( -28540                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_JOEE'              )
      NAIF_BODY_CODE += ( -28550                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_JOEE_S1'           )
      NAIF_BODY_CODE += ( -28551                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_JOEE_S2'           )
      NAIF_BODY_CODE += ( -28552                        )

      NAIF_BODY_NAME += ( 'JUICE_PEP_JENI'              )
      NAIF_BODY_CODE += ( -28560                        )

   \begintext


   Radar for Icy Moon Exploration:
   -------------------------------

      This table presents the Radar for Icy Moon Exploration (RIME)
      instrument name and ID:

      Name                   ID       Synonyms
      ---------------------  -------  -----------------------
      JUICE_RIME_BASE        -28600
      JUICE_RIME             -28601


      The mappings summarized in this table are implemented by the keywords
      below.

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_RIME_BASE'             )
      NAIF_BODY_CODE += ( -28600                        )

      NAIF_BODY_NAME += ( 'JUICE_RIME'                  )
      NAIF_BODY_CODE += ( -28601                        )

   \begintext


   Radio & Plasma Waves Investigation:
   -----------------------------------

      This table presents the Radio & Plasma Waves Investigation (RPWI)
      structures, instruments and sensors names and IDs:

      Name                   ID       Synonyms
      ---------------------  -------  -----------------------
      JUICE_RPWI_LPB1        -28700
      JUICE_RPWI_LP1         -28705
      JUICE_RPWI_LPB2        -28710
      JUICE_RPWI_LP2         -28715
      JUICE_RPWI_LPB3        -28720
      JUICE_RPWI_LP3         -28725
      JUICE_RPWI_LPB4        -28730
      JUICE_RPWI_LP4         -28735
      JUICE_RPWI_RWI         -28740
      JUICE_RPWI_RWI_EX      -28741
      JUICE_RPWI_RWI_EY      -28742
      JUICE_RPWI_RWI_EZ      -28743
      JUICE_RPWI_SCM         -28750


      The mappings summarized in this table are implemented by the keywords
      below.

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_RPWI_LPB1'             )
      NAIF_BODY_CODE += ( -28701                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_LP1'              )
      NAIF_BODY_CODE += ( -28705                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_LPB2'             )
      NAIF_BODY_CODE += ( -28711                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_LP2'              )
      NAIF_BODY_CODE += ( -28715                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_LPB3'             )
      NAIF_BODY_CODE += ( -28721                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_LP3'              )
      NAIF_BODY_CODE += ( -28725                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_LPB4'             )
      NAIF_BODY_CODE += ( -28731                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_LP4'              )
      NAIF_BODY_CODE += ( -28735                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_RPW'              )
      NAIF_BODY_CODE += ( -28740                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_RPW_EX'           )
      NAIF_BODY_CODE += ( -28741                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_RPW_EY'           )
      NAIF_BODY_CODE += ( -28742                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_RPW_EZ'           )
      NAIF_BODY_CODE += ( -28743                        )

      NAIF_BODY_NAME += ( 'JUICE_RPWI_SCM'              )
      NAIF_BODY_CODE += ( -28750                        )

   \begintext


   Sub-millimeter Wave Instrument:
   -------------------------------

      This table presents the Sub-millimeter Wave Instrument (SWI) instrument
      and structures' names and IDs:

      Name                   ID       Synonyms
      ---------------------  -------  -----------------------
      JUICE_SWI_FULL         -28800
      JUICE_SWI_FULL_GCO500  -28801
      JUICE_SWI_CH1          -28810
      JUICE_SWI_CH2          -28820


      The mappings summarized in this table are implemented by the keywords
      below.

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_SWI_FULL'              )
      NAIF_BODY_CODE += ( -28800                        )

      NAIF_BODY_NAME += ( 'JUICE_SWI_FULL_GCO500'       )
      NAIF_BODY_CODE += ( -28801                        )

      NAIF_BODY_NAME += ( 'JUICE_SWI_CH1'               )
      NAIF_BODY_CODE += ( -28810                        )

      NAIF_BODY_NAME += ( 'JUICE_SWI_CH2'               )
      NAIF_BODY_CODE += ( -28820                        )

   \begintext



   Ultraviolet Spectrograph:
   -------------------------

      This table presents the Ultraviolet Spectrograph (UVS) instrument
      and sensors' names and IDs:

      Name                   ID       Synonyms
      ---------------------  -------  -----------------------
      JUICE_UVS              -28850
      JUICE_UVS_AP           -28851
      JUICE_UVS_AP_NARROW    -28852
      JUICE_UVS_AP_WIDE      -28853
      JUICE_UVS_HP           -28860
      JUICE_UVS_SP           -28870


      The mappings summarized in this table are implemented by the keywords
      below.

   \begindata

      NAIF_BODY_NAME += ( 'JUICE_UVS'                   )
      NAIF_BODY_CODE += ( -28850                        )

      NAIF_BODY_NAME += ( 'JUICE_UVS_AP'                )
      NAIF_BODY_CODE += ( -28851                        )

      NAIF_BODY_NAME += ( 'JUICE_UVS_AP_NARROW'         )
      NAIF_BODY_CODE += ( -28852                        )

      NAIF_BODY_NAME += ( 'JUICE_UVS_AP_WIDE'           )
      NAIF_BODY_CODE += ( -28853                        )

      NAIF_BODY_NAME += ( 'JUICE_UVS_HP'                )
      NAIF_BODY_CODE += ( -28860                        )

      NAIF_BODY_NAME += ( 'JUICE_UVS_SP'                )
      NAIF_BODY_CODE += ( -28870                        )

   \begintext


End of FK file.