KPL/MK

Meta-kernel for ExoMars 2016 Dataset v100 -- Operational 20200916_001
==========================================================================

   This meta-kernel lists the ExoMars2016 Operational SPICE kernels
   that provide information for the Operational scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the ExoMars2016 Operational scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v2.1.0.


Usage of the Meta-kernel
-------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/ExoMars2016/kernels/


Implementation Notes
-------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the ExoMars2016 SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on September 16, 2020 by Marc Costa Sitja ESA/ESAC.
   The original name of this file was em16_ops_v100_20200916_001.tm.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/ck/em16_tgo_cassis_tel_20160407_20181231_s20171007_v01.bc'
                           '$KERNELS/ck/em16_tgo_nomad_ssm_20210507_20210507_s20200824_v01.bc'
                           '$KERNELS/ck/em16_tgo_sc_fsp_002_01_20180222_20180222_s20200824_v01.bc'

                           '$KERNELS/fk/em16_tgo_v18.tf'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/sclk/em16_tgo_fict_20180215.tsc'
                           '$KERNELS/sclk/em16_tgo_step_20200824.tsc'

                           '$KERNELS/spk/em16_tgo_cog_121_01_20180220_20180220_v01.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v100_20200916_001'

   \begintext


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           esa_spice@sciops.esa.int, marc.costa@esa.int,


End of MK file.