C$Procedure      DSPLAY -- Display static descriptive information

      SUBROUTINE DSPLAY ( WHAT, ACTION )

C$ Abstract
C
C     Displays TCP2SCET usage, help, or template information and stops
C     the program if needed.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     None
C
C$ Declarations
 
      IMPLICIT NONE
      
      INCLUDE              'tcp2scet.inc'
      
      CHARACTER*(*)         WHAT
      CHARACTER*(*)         ACTION

C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     WHAT       I   "What should be displayed" key.
C     ACTION     I   Stop/continue key.
C
C$ Detailed_Input
C
C     WHAT           Key specifying what should be displayed. The value 
C                    can be 'VERSION', 'USAGE', 'HELP' or 'TEMPLATE'.
C
C     ACTION         Key specifying whether program should proceed 
C                    or stop ('STOP', 'PROCEED')
C
C$ Detailed_Output
C
C     None.
C
C     The routine prints requested message to STDOUT and stops (or not)
C     depending on the requested action.
C
C$ Parameters
C
C     See the include file.
C
C$ Exceptions
C
C     Error free.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     If WHAT value is not one of the values listed in Detailed_Input,
C     then no message is displayed.
C
C     If ACTION value is not 'STOP', then the routine does not stop the
C     program.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     B.V. Semenov      (JPL)
C
C$ Version
C
C-    TCP2SCET Version 1.0.0, 16-SEP-2003 (BVS)
C 
C        Stolen from CHRONOS. Then global-replaced and further tweaked
C        to be TCP2SCET-specific.
C
C-&
 
C
C     Local parameters.
C
      INTEGER               DSPSIZ
      PARAMETER           ( DSPSIZ = 80 )

      INTEGER               VERCNT
      PARAMETER           ( VERCNT = 4 )
      
      INTEGER               USGCNT
      PARAMETER           ( USGCNT = 19 )
      
      INTEGER               HLPCNT
      PARAMETER           ( HLPCNT =  6 )
      
      INTEGER               TMLCNT
      PARAMETER           ( TMLCNT = 28 )

C
C     Backslash character ord.
C
      INTEGER               BSLASH
      PARAMETER           ( BSLASH = 92 )
            
C
C     Local variables.
C
      CHARACTER*(DSPSIZ)    VERMSG ( VERCNT )
      CHARACTER*(DSPSIZ)    USGMSG ( USGCNT )
      CHARACTER*(DSPSIZ)    HLPMSG ( HLPCNT )
      CHARACTER*(DSPSIZ)    TMLMSG ( TMLCNT )
      CHARACTER*(WRDSIZ)    VERSTR
      
      INTEGER               STDOUT
      
C
C     SPICELIB function.
C
      LOGICAL               RETURN
      INTEGER               RTRIM
      
C
C     Standard SPICE error handling.
C
      IF ( RETURN () ) THEN
         RETURN
      ELSE
         CALL CHKIN ( 'DSPLAY' )
      END IF

C
C     Version display.
C
      CALL TKVRSN ( 'TOOLKIT', VERSTR )

      VERMSG(  1 ) = ' '
      VERMSG(  2 ) = 'TCP2SCET -- ESOC Time Correlation Packets To '
     .//             'SCLKvSCET Format'
      VERMSG(  3 ) = 'Version ' // VER // ' (Toolkit ' 
     .//             VERSTR(:RTRIM(VERSTR)) // ')'
      VERMSG(  4 ) = ' '
 
C
C     Usage display.
C
      USGMSG(  1 ) = 'TCP2SCET Usage'
      USGMSG(  2 ) = '---------------------------------------'
     .//             '---------------------------'
      USGMSG(  3 ) = ' '
      USGMSG(  4 ) = '   To convert file containing ESOC TCP packets '
     .//             'to SCLKvSCET file:'
      USGMSG(  5 ) = ' '
      USGMSG(  6 ) = '      % TCP2SCET # <setup file>'
      USGMSG(  7 ) = '                 # <#|#>'
      USGMSG(  8 ) = '                 # <input TCP file>'
      USGMSG(  9 ) = '                 # <output SCET file>'
      USGMSG( 10 ) = '                [#]'
      USGMSG( 11 ) = '                [#]'
      USGMSG( 12 ) = ' '
      USGMSG( 13 ) = '   To display usage:               % '
     .//             'TCP2SCET [#|#]'
      USGMSG( 14 ) = '   To display help:                % TCP2SCET #|#'
      USGMSG( 15 ) = '   To display setup file template: % TCP2SCET #'
      USGMSG( 16 ) = ' '
      USGMSG( 17 ) = '   The case of command line switches is'
     .//             ' insignificant. Switches shown within '
      USGMSG( 18 ) = '   square braces [] are optional.'
      USGMSG( 19 ) = ' '
      CALL REPMC ( USGMSG(  6 ), '#', SETKEY, USGMSG(  6 ) )
      CALL REPMC ( USGMSG(  7 ), '#', MODKEY, USGMSG(  7 ) )
      CALL REPMC ( USGMSG(  7 ), '#', STPMOD, USGMSG(  7 ) )
      CALL REPMC ( USGMSG(  7 ), '#', STRMOD, USGMSG(  7 ) )
      CALL REPMC ( USGMSG(  8 ), '#', TCPKEY, USGMSG(  8 ) )
      CALL REPMC ( USGMSG(  9 ), '#', SCTKEY, USGMSG(  9 ) )
      CALL REPMC ( USGMSG( 10 ), '#', SILKEY, USGMSG( 10 ) )
      CALL REPMC ( USGMSG( 11 ), '#', VRBKEY, USGMSG( 11 ) )
      CALL REPMC ( USGMSG( 13 ), '#', HLPKEY, USGMSG( 13 ) )
      CALL REPMC ( USGMSG( 13 ), '#', HKEY,   USGMSG( 13 ) )
      CALL REPMC ( USGMSG( 14 ), '#', USGKEY, USGMSG( 14 ) )
      CALL REPMC ( USGMSG( 14 ), '#', UKEY,   USGMSG( 14 ) )
      CALL REPMC ( USGMSG( 15 ), '#', TMLKEY, USGMSG( 15 ) )
     
C
C     Help display.
C
      HLPMSG(  1 ) = 'TCP2SCET Help'
      HLPMSG(  2 ) = '---------------------------------------'
     .//             '---------------------------'
      HLPMSG(  3 ) = ' '
      HLPMSG(  4 ) = 'TCP2SCET is a program that converts a file '
     .//             'containing ESOC TCP packets to '
      HLPMSG(  5 ) = 'SCLKvSCET format. Refer to the User''s Guide for '
     .//             'more information.'
      HLPMSG(  6 ) = ' '

C
C     Template display
C
      TMLMSG(  1 ) = 'TCP2SCET Setup File'
      TMLMSG(  2 ) = '---------------------------------------'
     .//             '---------------------------'
      TMLMSG(  3 ) = ' '
      TMLMSG(  4 ) = 'TCP2SCET requires some parameters to be '
     .//             'provided in a setup file.'
      TMLMSG(  5 ) = 'The setup file format should correspond'
     .//             ' to the SPICE Kernel Text'
      TMLMSG(  6 ) = 'file format specification, i.e. it must'
     .//             ' contain data formatted as'
      TMLMSG(  7 ) = 'a set of KEYWORD=VALUE assignments encl'
     .//             'osed between'
      TMLMSG(  8 ) = ' '
      TMLMSG(  9 ) = '   ' // CHAR(BSLASH) // 'begindata'
      TMLMSG( 10 ) = '   ' // CHAR(BSLASH) // 'begintext'
      TMLMSG( 11 ) = ' '
      TMLMSG( 12 ) = 'markers. Each assignment and marker mus'
     .//             't be on a line by itself.'
      TMLMSG( 13 ) = ' '
      TMLMSG( 14 ) = 'The following parameters may be provid'
     .//             'ed in a setup file:'
      TMLMSG( 15 ) = ' '
      TMLMSG( 16 ) = '   ' // CHAR(BSLASH) // 'begindata'
      TMLMSG( 17 ) = '      # = ''name of an LSK file'''
      TMLMSG( 18 ) = '      # = ''clock start time (UTC)'''
      TMLMSG( 19 ) = '      # = ( ''UTCs of bad TCPs'', ''...'', ...) '
      TMLMSG( 20 ) = '      # = max allowed discontinuity '
     .//             'between TCPs, seconds'
      TMLMSG( 21 ) = '      # = duration of the ''step'' interval, '
     .//             'seconds'
      TMLMSG( 22 ) = '      # = ''mission name'''
      TMLMSG( 23 ) = '      # = mission ID'
      TMLMSG( 24 ) = '      # = ''spacecraft name'''
      TMLMSG( 25 ) = '      # = spacecraft ID (negative of NAIF ID)'
      TMLMSG( 26 ) = '      # = ''producer name/affiliation'''
      TMLMSG( 27 ) = '   ' // CHAR(BSLASH) // 'begintext'
      TMLMSG( 28 ) = ' '


      CALL REPMC ( TMLMSG( 17 ), '#', LSKKWD, TMLMSG( 17 ) )
      CALL REPMC ( TMLMSG( 18 ), '#', SCLKWD, TMLMSG( 18 ) )
      CALL REPMC ( TMLMSG( 19 ), '#', BADKWD, TMLMSG( 19 ) )
      CALL REPMC ( TMLMSG( 20 ), '#', DISKWD, TMLMSG( 20 ) )
      CALL REPMC ( TMLMSG( 21 ), '#', INTKWD, TMLMSG( 21 ) )
      CALL REPMC ( TMLMSG( 22 ), '#', MNMKWD, TMLMSG( 22 ) )
      CALL REPMC ( TMLMSG( 23 ), '#', MIDKWD, TMLMSG( 23 ) )
      CALL REPMC ( TMLMSG( 24 ), '#', SNMKWD, TMLMSG( 24 ) )
      CALL REPMC ( TMLMSG( 25 ), '#', SIDKWD, TMLMSG( 25 ) )
      CALL REPMC ( TMLMSG( 26 ), '#', PIDKWD, TMLMSG( 26 ) )

C
C     Get STDOUT
C
      CALL STDIO ( 'STDOUT', STDOUT )

C
C     What was requested for display?
C
      IF       ( WHAT .EQ. 'VERSION'  ) THEN
 
C
C        Display version.
C
         CALL WRITLA ( VERCNT, VERMSG, STDOUT )

      ELSE IF  ( WHAT .EQ. 'USAGE' ) THEN
     
C
C        Display usage.
C
         CALL WRITLA ( VERCNT, VERMSG, STDOUT )
         CALL WRITLA ( USGCNT, USGMSG, STDOUT )

      ELSE IF  ( WHAT .EQ. 'HELP' ) THEN
     
C
C        Display help.
C
         CALL WRITLA ( VERCNT, VERMSG, STDOUT )
         CALL WRITLA ( HLPCNT, HLPMSG, STDOUT )
         
      ELSE IF  ( WHAT .EQ. 'TEMPLATE' ) THEN
     
C
C        Display help.
C      
         CALL WRITLA ( VERCNT, VERMSG, STDOUT )
         CALL WRITLA ( TMLCNT, TMLMSG, STDOUT )
            
      END IF
      
C
C     Should we stop the program?
C
      IF ( ACTION .EQ. 'STOP' ) THEN
         STOP
      END IF

      CALL CHKOUT ( 'DSPLAY' )
      RETURN      
      END
